/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.tag.DefaultTagErrorRenderer;
import net.sourceforge.stripes.tag.InputTagSupport;
import net.sourceforge.stripes.tag.TagErrorRenderer;
import net.sourceforge.stripes.tag.TagErrorRendererFactory;

public class DefaultTagErrorRendererFactory
implements TagErrorRendererFactory {
    public static final String RENDERER_CLASS_KEY = "TagErrorRenderer.Class";
    private Configuration configuration;
    private Class<? extends TagErrorRenderer> rendererClass;

    public void init(Configuration configuration) throws Exception {
        this.setConfiguration(configuration);
        this.rendererClass = configuration.getBootstrapPropertyResolver().getClassProperty(RENDERER_CLASS_KEY, TagErrorRenderer.class);
        if (this.rendererClass == null) {
            this.rendererClass = DefaultTagErrorRenderer.class;
        }
    }

    public TagErrorRenderer getTagErrorRenderer(InputTagSupport tag) {
        try {
            TagErrorRenderer renderer = this.rendererClass.newInstance();
            renderer.init(tag);
            return renderer;
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Could not create an instance of the configured TagErrorRenderer class '" + this.rendererClass.getName() + "'. Please check " + "that the class is public and has a no-arg public constructor.", e);
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

