/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.io.BufferedReader;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.controller.StripesRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashRequest
implements HttpServletRequest,
Serializable {
    private static final long serialVersionUID = 1L;
    private Cookie[] cookies;
    private HttpServletRequest delegate;
    private List<Locale> locales;
    private Locale locale;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Map<String, Long> dateHeaders = new HashMap<String, Long>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private String authType;
    private String characterEncoding;
    private String contentType;
    private String contextPath;
    private String localAddr;
    private String localName;
    private String method;
    private String pathInfo;
    private String pathTranslated;
    private String protocol;
    private String queryString;
    private String remoteAddr;
    private String remoteHost;
    private String remoteUser;
    private String requestURI;
    private String requestedSessionId;
    private String scheme;
    private String serverName;
    private String servletPath;
    private StringBuffer requestURL;
    private boolean requestedSessionIdFromCookie;
    private boolean requestedSessionIdFromURL;
    private boolean requestedSessionIdFromUrl;
    private boolean requestedSessionIdValid;
    private boolean secure;
    private int localPort;
    private int remotePort;
    private int serverPort;

    public static StripesRequestWrapper replaceRequest(HttpServletRequest request) {
        StripesRequestWrapper wrapper = StripesRequestWrapper.findStripesWrapper((ServletRequest)request);
        wrapper.setRequest((ServletRequest)new FlashRequest((HttpServletRequest)wrapper.getRequest()));
        return wrapper;
    }

    public FlashRequest(HttpServletRequest prototype) {
        this.authType = prototype.getAuthType();
        this.characterEncoding = prototype.getCharacterEncoding();
        this.contentType = prototype.getContentType();
        this.contextPath = prototype.getContextPath();
        this.cookies = prototype.getCookies();
        this.localAddr = prototype.getLocalAddr();
        this.localName = prototype.getLocalName();
        this.localPort = prototype.getLocalPort();
        this.locale = prototype.getLocale();
        this.method = prototype.getMethod();
        this.pathInfo = prototype.getPathInfo();
        this.pathTranslated = prototype.getPathTranslated();
        this.protocol = prototype.getProtocol();
        this.queryString = prototype.getQueryString();
        this.remoteAddr = prototype.getRemoteAddr();
        this.remoteHost = prototype.getRemoteHost();
        this.remotePort = prototype.getRemotePort();
        this.remoteUser = prototype.getRemoteUser();
        this.requestURI = prototype.getRequestURI();
        this.requestURL = prototype.getRequestURL();
        this.requestedSessionId = prototype.getRequestedSessionId();
        this.requestedSessionIdFromCookie = prototype.isRequestedSessionIdFromCookie();
        this.requestedSessionIdFromURL = prototype.isRequestedSessionIdFromURL();
        this.requestedSessionIdFromUrl = prototype.isRequestedSessionIdFromUrl();
        this.requestedSessionIdValid = prototype.isRequestedSessionIdValid();
        this.scheme = prototype.getScheme();
        this.secure = prototype.isSecure();
        this.serverName = prototype.getServerName();
        this.serverPort = prototype.getServerPort();
        this.servletPath = prototype.getServletPath();
        for (String key : Collections.list(prototype.getAttributeNames())) {
            this.attributes.put(key, prototype.getAttribute(key));
        }
        for (String key : Collections.list(prototype.getHeaderNames())) {
            this.headers.put(key, Collections.list(prototype.getHeaders(key)));
            try {
                this.dateHeaders.put(key, prototype.getDateHeader(key));
            }
            catch (Exception e) {}
        }
        this.locales = Collections.list(prototype.getLocales());
        this.parameters.putAll(prototype.getParameterMap());
    }

    protected HttpServletRequest getDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Attempt to access a delegate method of " + FlashRequest.class.getName() + " but no delegate request has been set");
        }
        return this.delegate;
    }

    public void setDelegate(HttpServletRequest delegate) {
        this.delegate = delegate;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        Long value = this.dateHeaders.get(name);
        return value == null ? 0L : value;
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        return values != null && values.size() > 0 ? values.get(0) : null;
    }

    public Enumeration<String> getHeaders(String name) {
        return Collections.enumeration((Collection)this.headers.get(name));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        try {
            return Integer.parseInt(this.getHeader(name));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public boolean isUserInRole(String role) {
        return this.getDelegate().isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.getDelegate().getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestURL.toString());
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        return this.getDelegate().getSession(create);
    }

    public HttpSession getSession() {
        return this.getDelegate().getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.requestedSessionIdValid;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.requestedSessionIdFromUrl;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return 0;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() {
        return null;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() {
        return null;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public RequestDispatcher getRequestDispatcher(String name) {
        return this.getDelegate().getRequestDispatcher(name);
    }

    @Deprecated
    public String getRealPath(String name) {
        return this.getDelegate().getRealPath(name);
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }
}

