/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.exceptions.FeedMarshallException;
import org.intabulas.sandler.parser.AtomParser;
import org.xmlpull.v1.XmlPullParserException;

public class Sandler {
    private Sandler() {
    }

    public static Feed unmarshallFeed(String feed) throws FeedMarshallException {
        return Sandler.unmarshallFeed(new ByteArrayInputStream(feed.getBytes()));
    }

    public static Feed unmarshallFeed(InputStream stream) throws FeedMarshallException {
        AtomParser parser = new AtomParser();
        Feed result = null;
        try {
            result = parser.parseInput(stream);
        }
        catch (XmlPullParserException e) {
            throw new FeedMarshallException(e);
        }
        return result;
    }

    public static String marshallFeed(Feed feed) {
        return feed.toString();
    }

    public static Entry unmarshallEntry(String entry) throws FeedMarshallException {
        return Sandler.unmarshallEntry(new ByteArrayInputStream(entry.getBytes()));
    }

    public static Entry unmarshallEntry(InputStream stream) throws FeedMarshallException {
        AtomParser parser = new AtomParser();
        Entry result = null;
        try {
            result = parser.parseEntryInput(stream);
        }
        catch (XmlPullParserException e) {
            throw new FeedMarshallException(e);
        }
        return result;
    }

    public static String marshallEntry(Entry entry) {
        return entry.toString();
    }
}

