/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.HashMap;
import java.util.Map;

public class FrameAddress {
    private String windowName;
    private String localFrameAddress;
    private static Map<String, FrameAddress> stringToFrameAddress = new HashMap<String, FrameAddress>();

    private FrameAddress(String windowName, String localFrameAddress) {
        this.windowName = windowName != null ? windowName : "";
        this.localFrameAddress = localFrameAddress != null ? localFrameAddress : "top";
    }

    public static FrameAddress make(String windowName, String localFrameAddress) {
        FrameAddress f = new FrameAddress(windowName, localFrameAddress);
        String s = f.toString();
        if (stringToFrameAddress.containsKey(s)) {
            return stringToFrameAddress.get(s);
        }
        stringToFrameAddress.put(s, f);
        return f;
    }

    public String toString() {
        return this.windowName + ":" + this.localFrameAddress;
    }

    public String getLocalFrameAddress() {
        return this.localFrameAddress;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public boolean isDefault() {
        return this.getWindowName().equals("") && this.getLocalFrameAddress().equals("top");
    }

    public boolean equals(Object obj) {
        if (obj instanceof FrameAddress) {
            FrameAddress other = (FrameAddress)obj;
            return this.getWindowName().equals(other.getWindowName()) && this.getLocalFrameAddress().equals(other.getLocalFrameAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.getLocalFrameAddress().hashCode();
    }

    public void setLocalFrameAddress(String localFrameAddress) {
        assert (this == stringToFrameAddress.remove(this.toString()));
        this.localFrameAddress = localFrameAddress;
        stringToFrameAddress.put(this.toString(), this);
    }

    public void setWindowName(String windowName) {
        assert (this == stringToFrameAddress.remove(this.toString()));
        this.windowName = windowName;
        stringToFrameAddress.put(this.toString(), this);
    }
}

