      SUBROUTINE TAUTOG	(IERROR)
C
C LATEST REVISION	 FEBRUARY 1985
C
C PURPOSE		 TO PROVIDE A SIMPLE DEMONSTRATION OF
C			 AUTOGRAPH AND TO TEST AUTOGRAPH ON A
C			 SIMPLE	PROBLEM
C
C USAGE			 CALL TAUTOG (IERROR)
C
C ARGUMENTS
C
C ON OUTPUT		 IERROR
C			   AN ERROR PARAMETER
C			   = 0,	IF THE TEST IS SUCCESSFUL,
C			   = 1,	OTHERWISE
C
C I/O			 IF THE	TEST IS	SUCCESSFUL, THE	MESSAGE
C
C			   AUTOGRAPH TEST SUCCESSFUL  .	. .  SEE PLOT
C			   TO VERIFY PERFORMANCE
C
C			 IS WRITTEN ON UNIT 6.
C
C			 IN ADDITION, FOUR (4) LABELLED	FRAMES
C			 CONTAINING THE	TWO-DIMENSIONAL	PLOTS ARE
C			 PRODUCED ON THE MACHINE GRAPHICS DEVICE.
C			 TO DETERMINE IF THE TEST WAS SUCCESSFUL,
C			 IT IS NECESSARY TO EXAMINE THESE PLOTS.
C
C PRECISION		 SINGLE
C
C REQUIRED LIBRARY	 AUTOGRAPH
C FILES
C
C LANGUAGE		 FORTRAN
C
C HISTORY		 ORIGINALLY WRITTEN IN APRIL, 1979 AND
C			 CONVERTED TO FORTRAN 77 AND GKS IN FEBRUARY
C			 1985.
C
C ALGORITHM		 TAUTOG	COMPUTES DATA FOR AUTOGRAPH SUBROUTINES
C
C			   EZY,	EZXY, EZMY, AND	EZMXY,
C
C			 AND CALLS EACH	OF THESE ROUTINES TO PRODUCE
C			 ONE PLOT EACH.
C
C			 ON THREE OF THE PLOTS,	TAUTOG USES THE
C			 AUTOGRAPH CONTROL PARAMETER ROUTINES
C			 AGSETF, AGSETI, AND AGSETP TO SPECIFY
C			 Y-AXIS	LABELS OR INTRODUCE LOG	SCALING.
C
C PORTABILITY		 FORTRAN 77
C
      REAL	      X(21)	 ,Y1D(21)    ,Y2D(21,5)
C
C X CONTAINS THE ABSCISSA VALUES FOR THE PLOTS PRODUCED	BY EZXY	AND
C EZMXY,  Y1D CONTAINS THE ORDINATE VALUES FOR THE PLOTS PRODUCED BY
C EZXY AND EZY,	 AND Y2D CONTAINS THE ORDINATE VALUES FOR THE PLOTS
C PRODUCED BY EZMY AND EZMXY.
C
C
C
C
C FILL Y1D ARRAY FOR ENTRY EZY
C
      DO  10 I=1,21
	 Y1D(I)	= EXP(-.1*FLOAT(I))*COS(FLOAT(I)*.5)
   10 CONTINUE
C
C     ENTRY EZY	PLOTS THE CONTENTS OF Y1D AS A FUNCTION	OF THE INTEGERS
C     THE TITLE	FOR THIS PLOT IS
C
C	DEMONSTRATING EZY ENTRY	OF AUTOGRAPH
C
      CALL EZY (Y1D(1),21,'DEMONSTRATING EZY ENTRY OF AUTOGRAPH$')
C
	
C
C
C
C FILL X AND Y1D ARRAYS	FOR ENTRY EZXY
C
      DO  20 I=1,21
	 X(I) =	FLOAT(I-1)*.314
	 Y1D(I)	= X(I)+COS(X(I))*2.0
   20 CONTINUE
C
C     SET AUTOGRAPH CONTROL PARAMETERS FOR Y-AXIS LABEL
C	  X+COS(X)*2
C
      CALL AGSETC('LABEL/NAME.','L')
      CALL AGSETI('LINE/NUMBER.',100)
      CALL AGSETC('LINE/TEXT.','X+COS(X)*2$')
C
C     ENTRY EZXY PLOTS CONTENTS	OF X-ARRAY VS. Y1D-ARRAY
C     THE TITLE	FOR THIS PLOT IS
C
C	DEMONSTRATING EZXY ENTRY OF AUTOGRAPH
C
      CALL EZXY	(X,Y1D,21,'DEMONSTRATING EZXY ENTRY IN AUTOGRAPH$')
C
C
C
C
C FILL Y2D ARRAY FOR ENTRY EZMY
C
      DO  40 I=1,21
	 T = .5*FLOAT(I-1)
	 DO  30	J=1,5
	    Y2D(I,J) = EXP(-.5*T)*COS(T)/FLOAT(J)
   30	 CONTINUE
   40 CONTINUE
C
C     SET AUTOGRAPH CONTROL PARAMETERS FOR Y-AXIS LABEL
C	  EXP(-X/2)*COS(X)*SCALE
C
      CALL AGSETC('LABEL/NAME.','L')
      CALL AGSETI('LINE/NUMBER.',100)
      CALL AGSETC('LINE/TEXT.','EXP(-X/2)*COS(X)*SCALE$')
C
C     SET AUTOGRAPH CONTROL PARAMETER FOR SPECIFYING THAT THE
C     ALPHABETIC SET OF	DASHED LINE PATTERNS IS	TO BE USED.
C
      CALL AGSETI('DASH/SELECTOR.',-1)
C
C     SET AUTOGRAPH CONTROL PARAMETER FOR SPECIFYING THAT THE
C     GRAPH DRAWN IS TO	BE LOGARITHMIC IN THE X-AXIS.
C
      CALL AGSETI('X/LOGARITHMIC.',1)
C
C     ENTRY EZMY PLOTS MULTIPLE	ARRAYS AS A FUNCTION OF	THE INTEGERS
C     THE TITLE	FOR THIS PLOT IS
C
C	DEMONSTRATING EZMY ENTRY OF AUTOGRAPH
C
      CALL EZMY	(Y2D,21,5,10,'DEMONSTRATING EZMY ENTRY OF AUTOGRAPH$')
C
C
C
C
C FILL Y2D ARRAY FOR EZMXY
C
      DO  60 I=1,21
	 DO  50	J=1,5
	    Y2D(I,J) = X(I)**J+COS(X(I))
   50	 CONTINUE
   60 CONTINUE
C
C     SET AUTOGRAPH CONTROL PARAMETERS FOR Y-AXIS LABEL
C	  X**J+COS(X)
C
      CALL AGSETC('LABEL/NAME.','L')
      CALL AGSETI('LINE/NUMBER.',100)
      CALL AGSETC('LINE/TEXT.','X**J+COS(X)$')
C
C     SET AUTOGRAPH CONTROL PARAMETER FOR SPECIFYING THAT THE
C     ALPHABETIC SET OF	DASHED LINE PATTERNS IS	TO BE USED.
C
      CALL AGSETI('DASH/SELECTOR.',-1)
C
C     SET AUTOGRAPH CONTROL PARAMETER FOR SPECIFYING THAT THE GRAPH
C     IS TO BE LINEAR IN THE X-AXIS AND	LOGARITHMIC IN THE Y-AXIS.
C
      CALL AGSETI('X/LOGARITHMIC.',0)
      CALL AGSETI('Y/LOGARITHMIC.',1)
C
C     ENTRY EZMXY PLOTS	MULTIPLE ARRAYS	AS A FUNCTION OF A SINGLE
C		  X ARRAY (OR MANY X ARRAYS)
C     THE TITLE	FOR THIS PLOT IS
C
C	DEMONSTRATING EZMXY ENTRY OF AUTOGRAPH
C
      CALL EZMXY (X,Y2D,21,5,21,
     +		  'DEMONSTRATING EZMXY ENTRY OF AUTOGRAPH$')
C
      IERROR = 0
c     WRITE (6,1001)
C
      RETURN
C
c1001 FORMAT ('	 AUTOGRAPH TEST	SUCCESSFUL',24X,
c    1	      'SEE PLOT	TO VERIFY PERFORMANCE')
C
      END
