/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _IFPGUIVIEW_H_
#define _IFPGUIVIEW_H_

#include <QWidget>

#include "fileviewer.h"
#include "settings.h"
#include "ifpguiview.h"

//int progress(void *context, struct ifp_transfer_status *status);

class QPainter;
class ifpGUIView;
//class fileManagerView;

extern int progress(void *context, struct ifp_transfer_status *status);


typedef struct progress_info
{
    bool show_progress;     // show the ifp progress bar
    bool is_batch;          // ifp-gui defined is batch (user selected multiple files)
    int  total_transfered;  // The number of bytes transferred in the transfer so far
    int  total_to_transfer; // The total number of bytes expected during this transfer

    int  file_bytes; // The number of bytes transferred for the current file
    int  file_total; // The number of bytes in the current file

    bool is_status_batch;   // libifp defined is batch (called up/download directory)
    int  batch_total;
    int  batch_bytes;

    int files_count; // The number of files successfully transferred so far.
    int files_total; // The number of files expected to be transferred in this batch.

    bool delete_success; // a return value for the ifp_delete function
    bool auto_convert;   // whether or not to convert the file after download

    QString file_name; // the name of the current file
}
ifp_progress_info;


/**
 * This is the main view class for ifpGUI.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * @short Main view
 * @author Jim Campbell <ifpgui@gmail.com>
 * @version 0.1
 */
class ifpGUIView : public QWidget
{
    Q_OBJECT
public:
    ifpGUIView(QMainWindow *parent);
    ~ifpGUIView();

    void enableWindow(bool enable);
    int updateFileAndStatus(void);
    int updateStatus(void);
    bool isProcessing();
    Settings *guiSettings;
    bool cancel_progress;

    //QString truncateFileName(const QString &org, const QFontMetrics &fm, int width);
    //QString truncateFilePath(QString &fileStr);
    void setFileName(const QString &fileName);
    void setFileProgress(int progress);
    void setFileProgressTarget(int totalSteps);
    void setTotalProgress(int progress);
    void setTotalProgressTarget(int totalSteps);
    void hideCancelBtn(void);
    void showCancelBtn(void);
    void showTransferProgress();
    void hideTransferProgress();
    bool isTransferProgressVisible();
    void updateProgress(ifp_progress_info *pg_info);

public slots:
    void uploadPlaylist(void);
    void uploadSelectedFile(void);
    void downloadSelectedFile(void);
    void deleteSelectedFile(void);
    void setBatteryStatus(int bStatus);
    void setCapacity(int capSize, int capFree);
    int  getBatteryStatus();
    QString getFirmwareRev();
    QString getifpType();
    int  getCapacity();
    int  getFreeSpace();
    void formatIfpDevice();
    void UpdateFirmware();
    void setRadioFrequency();
    void create_directory();
    void rename_file();
    void delete_file();
    void file_properties();
    void align_horizontal();
    void align_vertical();
    void btnCancel_clicked(bool checked);

signals:
    void signalChangeStatusbar(const QString& text);
    //void signalChangeCaption(const QString& text);
    void signalSetBatteryStatus(int bStatus);
    void signalSetCapacity(int capSize, int capFree);

    //private slots:
    //    void slotSetTitle(const QString& title);


private:
    QMainWindow *parent_window;
    QGridLayout  *top_layout;
    QSplitter *split;
    int msgflag;
    bool yesAll;
    fileManagerView *dirview;
    fileManagerView *ifpview;

    // Transfer toolbar
    QToolBar     *ifpTransferToolBar;
    QVBoxLayout  *transferLayout;
    QProgressBar *fileprogress;
    QProgressBar *totalprogress;
    QLabel       *lblFilename;
    QPushButton  *btnCancel;
    QString lastFileName;

    void refreshFileItem(void);
    void unselectAllChildren(QTreeWidgetItem *parentItem);
    void createToolBars();
};

#endif // _IFPGUIVIEW_H_
