#!/usr/bin/perl

=head1 NAME

emlist-tdebs.pl - get a list of all packages currently with TDebs

=cut

=head1 Description

Scans the locale repository below --base-path to get a hash of
source package names, components and versions.

=cut

=head1 Synopsis

 Syntax: emlist-tdebs.pl -b PATH [OPTIONS]

 Commands:
 -b|--base-path PATH:           path to the top level grip directory [required]

Options:
 -s|--suite:                    which suite to check
    --filter-name STRING:       alternative name for the filter repository
    --grip-name STRING:         alternative name for the grip repository

=cut

use Debian::Packages::Compare;

$filter_name = 'filter';
$grip_name = 'grip';
$suite = "unstable";

while( @ARGV ) {
	$_= shift( @ARGV );
	last if m/^--$/;
	if (!/^-/) {
		unshift(@ARGV,$_);
		last;
	}
	elsif (/^(-b|--base-path)$/) {
		$base = shift;
	}
	elsif (/^(-s|--suite)$/) {
		$suite = shift;
	}
	elsif (/^(--filter-name)$/) {
		$filter_name = shift;
	}
	elsif (/^(--grip-name)$/) {
		$grip_name = shift;
	}
	else {
		die "$prog: Unknown option $_.\n";
	}
}

die "ERR: Please specify an existing directory for the base-path.\n"
	if (not defined $base);

$base .= '/' if ("$base" !~ m:/$:);
if (not -d $base)
{
	print "ERR: Please specify an existing directory for the base-path: $base";
	exit 1;
}
&set_base($base);
my $a = &get_archlist ($suite, $filter_name);
@archlist = (not defined $a or not @$a) ?
	sort qw/i386 amd64 arm armel powerpc mips mipsel/ : sort @$a;
my $l = &get_locale_roots ($suite, 'locale');
@locroots = (not defined $l or not @$l) ? qw/ af am ang ar as az be bg
bn br bs ca cs cy da de dz el en eo es et eu fa fi fr ga gl gu he hi hr
hu hy ia id io is it ja ka kn km ko ku ky lg li lt lv mg mi mk ml mn mr
ms nb ne nl nn no ns nso oc or pa pl pt rm ro ru rw si sk sl sq sr sv
ta te th tk tl tr tt ug uk ur uz vi wa wo xh yi zh zu / : @$l;

my $tdebu = &read_locale   ($suite, 'locale');
%tdebs   = %$tdebu  if (defined $tdebu);
%roots=();
%results=();
foreach my $pkg (keys %tdebs)
{
	next if (not defined $tdebs{$pkg}{'locale'});
	$results{$tdebs{$pkg}{'source'}}++;
	$roots{$tdebs{$pkg}{'locale'}}++;
}

print "These ".scalar keys (%results)." source packages have TDebs in $suite:\n";
print join (', ', sort keys (%results)) . "\n";
print "Total of ".scalar keys (%tdebs)." TDebs.\n";
print "Covering ".scalar keys (%roots)." locale roots.\n";
exit 0;

=head1 Copyright and Licence

 Copyright (C) 2007-2009  Neil Williams <codehelp@debian.org>

 This package is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

=cut

sub usageversion
{
	print(STDERR <<END)
emlist-tdebs.pl - get a list of all packages currently with TDebs

Syntax: emlist-tdebs.pl -b PATH [OPTIONS]

Commands:
-b|--base-path PATH:           path to the top level grip directory [required]

Options:
-s|--suite:                    change the suite
   --filter-name STRING:       alternative name for the filter repository
   --grip-name STRING:         alternative name for the grip repository

END
	or die "$0: failed to write usage: $!\n";
}
