# Desktop (Pre-)Autoloader

This little project got inspired and co-authored by Klaus Ade Johnstad
from https://linuxavdelingen.no.

The Desktop Autoloader project aims at being used on Diskless Workstations
(aka LTSP Fat Clients).

In class rooms or similar PC setups, a bottle neck occurs when all
diskless clients startup simultaneously, students login simultaneously
and start the same application(s) simultaneously. The storage devices of
the serving machine cannot cope with all the simulataneous diskless
clients demanding the same but slightly shifted file access on the
server's NFS share or NBD block device (where the clients root filesystem
is hosted).

Observations have shown that diskless workstations work smoothly if
people use them "asymmetrically", but become really really slow once 10 or
more people use the diskless workstations in a symmetrical usage pattern.
This normally happens when the users are students and follow instructions
in class. We observed launch times for LibreOffice of 15min and more.

The way to work around this bottleneck is taking advantage of the file
system RAM cache of the Linux kernel. An application that has once been
launched can be re-launched and during the re-launch it gets mostly
accessed from the file system cache. This brings a tremendous
acceleration to the usability experience of diskless workstations.

## History

This code project formalize and generalizes an old dirty hack:

Stick this line in a file under /etc/rc.local.d/ [ $(date +%s) -lt $(date
-d 07:55 +%s) ] && su autoload -c "Xvfb :10 & DISPLAY=:10
/usr/bin/dbus-launch --exit-with-session startxfce4 &"

This will start things if the machine boots up before 07:55, combine
this with WoL, so things are up and running before people arrive.

Then, create a autostart.desktop file for the "autoload" user, which
logs him automatically out after 90 sec, like this:

```
$ cat /home/autoload/.config/autostart/sleepandkill.desktop
[Desktop Entry]
Encoding=UTF-8
Name=sleepandkill
Exec=/bin/sh -c "sleep 90; pkill -u autoload"
Terminal=false
Type=Application
StartupNotify=false
```

I stick these desktopfiles in under ``/home/autoload/.config/autostart/``
as well:

```
firefox.desktop
geogebra.desktop
libreoffice-writer.desktop
sleepandkill.desktop
Thunar.desktop
```

That way Libre Office, Firefox, Thunar and Geogebra are already cached on the client.

Dirty hack, but you notice the differene quite well.

## The Generic Approach

This code project attempts at a general approach of the above hack.
Whereas the above hack only works well for XFCE desktops, the Desktop
Autoloader project generalizes the concept and makes it compatible
with various desktop environments.

The currently supported (i.e., tested) desktop environments are:

  * MATE
  * XFCE
