# -*- coding: utf-8 -*-
info = {
    "name": "ga",
    "date_order": "DMY",
    "january": [
        "eanáir",
        "ean"
    ],
    "february": [
        "feabhra",
        "feabh"
    ],
    "march": [
        "márta"
    ],
    "april": [
        "aibreán",
        "aib"
    ],
    "may": [
        "bealtaine",
        "beal"
    ],
    "june": [
        "meitheamh",
        "meith"
    ],
    "july": [
        "iúil"
    ],
    "august": [
        "lúnasa",
        "lún"
    ],
    "september": [
        "meán fómhair",
        "mfómh"
    ],
    "october": [
        "deireadh fómhair",
        "dfómh"
    ],
    "november": [
        "samhain",
        "samh"
    ],
    "december": [
        "nollaig",
        "noll"
    ],
    "monday": [
        "dé luain",
        "luan"
    ],
    "tuesday": [
        "dé máirt",
        "máirt"
    ],
    "wednesday": [
        "dé céadaoin",
        "céad"
    ],
    "thursday": [
        "déardaoin",
        "déar"
    ],
    "friday": [
        "dé haoine",
        "aoine"
    ],
    "saturday": [
        "dé sathairn",
        "sath"
    ],
    "sunday": [
        "dé domhnaigh",
        "domh"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "bliain",
        "bl"
    ],
    "month": [
        "mí"
    ],
    "week": [
        "seachtain",
        "scht"
    ],
    "day": [
        "lá"
    ],
    "hour": [
        "uair",
        "u"
    ],
    "minute": [
        "nóiméad",
        "nóim",
        "n"
    ],
    "second": [
        "soicind",
        "soic",
        "s"
    ],
    "relative-type": {
        "1 year ago": [
            "anuraidh"
        ],
        "0 year ago": [
            "an bhliain seo",
            "an bhl seo"
        ],
        "in 1 year": [
            "an bhliain seo chugainn",
            "an bhl seo chugainn"
        ],
        "1 month ago": [
            "an mhí seo caite"
        ],
        "0 month ago": [
            "an mhí seo"
        ],
        "in 1 month": [
            "an mhí seo chugainn"
        ],
        "1 week ago": [
            "an tseachtain seo caite",
            "an tscht seo caite"
        ],
        "0 week ago": [
            "an tseachtain seo",
            "an tscht seo"
        ],
        "in 1 week": [
            "an tseachtain seo chugainn",
            "an tscht seo chugainn"
        ],
        "1 day ago": [
            "inné"
        ],
        "0 day ago": [
            "inniu"
        ],
        "in 1 day": [
            "amárach"
        ],
        "0 hour ago": [
            "an uair seo"
        ],
        "0 minute ago": [
            "an nóiméad seo"
        ],
        "0 second ago": [
            "anois"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "i gceann (\\d+) bhliain",
            "i gceann (\\d+) bliain",
            "i gceann (\\d+) bl"
        ],
        "\\1 year ago": [
            "(\\d+) bhliain ó shin",
            "(\\d+) bliain ó shin",
            "(\\d+) bhl ó shin",
            "(\\d+) bl ó shin"
        ],
        "in \\1 month": [
            "i gceann (\\d+) mhí",
            "i gceann (\\d+) mí"
        ],
        "\\1 month ago": [
            "(\\d+) mhí ó shin",
            "(\\d+) mí ó shin"
        ],
        "in \\1 week": [
            "i gceann (\\d+) seachtain",
            "i gceann (\\d+) scht"
        ],
        "\\1 week ago": [
            "(\\d+) seachtain ó shin",
            "(\\d+) scht ó shin"
        ],
        "in \\1 day": [
            "i gceann (\\d+) lá"
        ],
        "\\1 day ago": [
            "(\\d+) lá ó shin"
        ],
        "in \\1 hour": [
            "i gceann (\\d+) uair an chloig",
            "i gceann (\\d+) uair"
        ],
        "\\1 hour ago": [
            "(\\d+) uair an chloig ó shin",
            "(\\d+) uair ó shin"
        ],
        "in \\1 minute": [
            "i gceann (\\d+) nóiméad",
            "i gceann (\\d+) nóim"
        ],
        "\\1 minute ago": [
            "(\\d+) nóiméad ó shin",
            "(\\d+) nóim ó shin"
        ],
        "in \\1 second": [
            "i gceann (\\d+) soicind",
            "i gceann (\\d+) soic"
        ],
        "\\1 second ago": [
            "(\\d+) soicind ó shin",
            "(\\d+) soic ó shin"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}