# Configure and install the Swig runtime, the BornAgain Python module, and more

if(NOT BORNAGAIN_PYTHON)
    message(FATAL_ERROR PythonAPI included though BORNAGAIN_PYTHON=false)
endif()

if(WIN32)
    set(BA_MODULES_IMPORT_PATH ../../bin)
elseif(BA_APPLE_BUNDLE)
    set(BA_MODULES_IMPORT_PATH
        lib/BornAgain-${BornAgain_VERSION_MAJOR}.${BornAgain_VERSION_MINOR})
else()
    set(BA_MODULES_IMPORT_PATH ${CMAKE_INSTALL_PREFIX}/${destination_lib})
endif()

configure_file(${WRAP_DIR}/Python/__init__.py.in
    ${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/bornagain/__init__.py @ONLY)

file(GLOB py_files ${WRAP_DIR}/Python/*.py)
foreach(py_file ${py_files})
    get_filename_component(out_file ${py_file} NAME)
    configure_file(${py_file}
        ${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/bornagain/${out_file} COPYONLY)
endforeach()

if(CONFIGURE_BINDINGS)
    add_custom_command(
        OUTPUT ${AUTO_WRAP_DIR}/swig_runtime.h
        COMMAND ${SWIG_EXECUTABLE} -c++;-python;-external-runtime;${AUTO_WRAP_DIR}/swig_runtime.h
        DEPENDS ${swig_dependencies} ${include_files}
        )
endif()

add_custom_target(swig_runtime DEPENDS ${AUTO_WRAP_DIR}/swig_runtime.h)

install(DIRECTORY ${EXAMPLES_PUBL_DIR}
    DESTINATION ${destination_share} COMPONENT Examples FILES_MATCHING PATTERN *.py )

if(BA_CPP_API)
    install(FILES ${AUTO_WRAP_DIR}/swig_runtime.h
        DESTINATION ${destination_include}/Wrap COMPONENT Headers)
endif()

# Install bornagain/__init__.py and utilites
install(DIRECTORY ${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/bornagain/
        DESTINATION ${destination_python}/bornagain
        COMPONENT Libraries
        FILES_MATCHING PATTERN *.py
        PATTERN __pycache__ EXCLUDE)
