/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Timeout;
import com.jayway.android.robotium.solo.Waiter;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Getter {
    private final Instrumentation instrumentation;
    private final ActivityUtils activityUtils;
    private final Waiter waiter;
    private final int TIMEOUT = 1000;

    public Getter(Instrumentation instrumentation, ActivityUtils activityUtils, Waiter waiter) {
        this.instrumentation = instrumentation;
        this.activityUtils = activityUtils;
        this.waiter = waiter;
    }

    public <T extends View> T getView(Class<T> classToFilterBy, int index) {
        return this.waiter.waitForAndGetView(index, classToFilterBy);
    }

    public <T extends TextView> T getView(Class<T> classToFilterBy, String text, boolean onlyVisible) {
        T viewToReturn = this.waiter.waitForText(classToFilterBy, text, 0, Timeout.getSmallTimeout(), false, onlyVisible, false);
        if (viewToReturn == null) {
            Assert.assertTrue((String)(classToFilterBy.getSimpleName() + " with text: '" + text + "' is not found!"), (boolean)false);
        }
        return viewToReturn;
    }

    public String getString(int id) {
        Activity activity = this.activityUtils.getCurrentActivity(false);
        return activity.getString(id);
    }

    public String getString(String id) {
        Context targetContext = this.instrumentation.getTargetContext();
        String packageName = targetContext.getPackageName();
        int viewId = targetContext.getResources().getIdentifier(id, "string", packageName);
        if (viewId == 0) {
            viewId = targetContext.getResources().getIdentifier(id, "string", "android");
        }
        return this.getString(viewId);
    }

    public View getView(int id, int index, int timeout) {
        Activity activity = this.activityUtils.getCurrentActivity(false);
        View viewToReturn = null;
        if (index < 1) {
            index = 0;
            viewToReturn = activity.findViewById(id);
        }
        if (viewToReturn != null) {
            return viewToReturn;
        }
        return this.waiter.waitForView(id, index, timeout);
    }

    public View getView(int id, int index) {
        return this.getView(id, index, 0);
    }

    public View getView(String id, int index) {
        int androidViewId;
        View viewToReturn = null;
        Context targetContext = this.instrumentation.getTargetContext();
        String packageName = targetContext.getPackageName();
        int viewId = targetContext.getResources().getIdentifier(id, "id", packageName);
        if (viewId != 0) {
            viewToReturn = this.getView(viewId, index, 1000);
        }
        if (viewToReturn == null && (androidViewId = targetContext.getResources().getIdentifier(id, "id", "android")) != 0) {
            viewToReturn = this.getView(androidViewId, index, 1000);
        }
        if (viewToReturn != null) {
            return viewToReturn;
        }
        return this.getView(viewId, index);
    }
}

