/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/AttachmentCollectionXml.h"
#include "Doc/DocXml/CafCoreTypesXml/StatisticsXml.h"
#include "Doc/DocXml/ResponseXml/ManifestCollectionXml.h"
#include "Doc/DocXml/ResponseXml/ResponseHeaderXml.h"

#include "Doc/CafCoreTypesDoc/CAttachmentCollectionDoc.h"
#include "Doc/CafCoreTypesDoc/CStatisticsDoc.h"
#include "Doc/ResponseDoc/CManifestCollectionDoc.h"
#include "Doc/ResponseDoc/CResponseDoc.h"
#include "Doc/ResponseDoc/CResponseHeaderDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ResponseXml/ResponseXml.h"

using namespace Caf;

void ResponseXml::add(
	const SmartPtrCResponseDoc responseDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ResponseXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(responseDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string clientIdVal =
			BasePlatform::UuidToString(responseDoc->getClientId());
		if (! clientIdVal.empty()) {
			thisXml->addAttribute("clientId", clientIdVal);
		}

		const std::string requestIdVal =
			BasePlatform::UuidToString(responseDoc->getRequestId());
		if (! requestIdVal.empty()) {
			thisXml->addAttribute("requestId", requestIdVal);
		}

		const std::string pmeIdVal = responseDoc->getPmeId();
		if (! pmeIdVal.empty()) {
			thisXml->addAttribute("pmeId", pmeIdVal);
		}

		const SmartPtrCResponseHeaderDoc responseHeaderVal =
			responseDoc->getResponseHeader();
		if (! responseHeaderVal.IsNull()) {
			const SmartPtrCXmlElement responseHeaderXml =
				thisXml->createAndAddElement("responseHeader");
			ResponseHeaderXml::add(responseHeaderVal, responseHeaderXml);
		}

		const SmartPtrCManifestCollectionDoc manifestCollectionVal =
			responseDoc->getManifestCollection();
		if (! manifestCollectionVal.IsNull()) {
			const SmartPtrCXmlElement manifestCollectionXml =
				thisXml->createAndAddElement("manifestCollection");
			ManifestCollectionXml::add(manifestCollectionVal, manifestCollectionXml);
		}

		const SmartPtrCAttachmentCollectionDoc attachmentCollectionVal =
			responseDoc->getAttachmentCollection();
		if (! attachmentCollectionVal.IsNull()) {
			const SmartPtrCXmlElement attachmentCollectionXml =
				thisXml->createAndAddElement("attachmentCollection");
			AttachmentCollectionXml::add(attachmentCollectionVal, attachmentCollectionXml);
		}

		const SmartPtrCStatisticsDoc statisticsVal =
			responseDoc->getStatistics();
		if (! statisticsVal.IsNull()) {
			const SmartPtrCXmlElement statisticsXml =
				thisXml->createAndAddElement("statistics");
			StatisticsXml::add(statisticsVal, statisticsXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCResponseDoc ResponseXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ResponseXml", "parse");

	SmartPtrCResponseDoc responseDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string clientIdStrVal =
			thisXml->findOptionalAttribute("clientId");
		UUID clientIdVal = CAFCOMMON_GUID_NULL;
		if (! clientIdStrVal.empty()) {
			BasePlatform::UuidFromString(clientIdStrVal.c_str(), clientIdVal);
		}

		const std::string requestIdStrVal =
			thisXml->findOptionalAttribute("requestId");
		UUID requestIdVal = CAFCOMMON_GUID_NULL;
		if (! requestIdStrVal.empty()) {
			BasePlatform::UuidFromString(requestIdStrVal.c_str(), requestIdVal);
		}

		const std::string pmeIdVal =
			thisXml->findOptionalAttribute("pmeId");

		const SmartPtrCXmlElement responseHeaderXml =
			thisXml->findOptionalChild("responseHeader");
		SmartPtrCResponseHeaderDoc responseHeaderVal;
		if (! responseHeaderXml.IsNull()) {
			responseHeaderVal = ResponseHeaderXml::parse(responseHeaderXml);
		}

		const SmartPtrCXmlElement manifestCollectionXml =
			thisXml->findOptionalChild("manifestCollection");

		SmartPtrCManifestCollectionDoc manifestCollectionVal;
		if (! manifestCollectionXml.IsNull()) {
			manifestCollectionVal = ManifestCollectionXml::parse(manifestCollectionXml);
		}

		const SmartPtrCXmlElement attachmentCollectionXml =
			thisXml->findOptionalChild("attachmentCollection");
		SmartPtrCAttachmentCollectionDoc attachmentCollectionVal;
		if (! attachmentCollectionXml.IsNull()) {
			attachmentCollectionVal = AttachmentCollectionXml::parse(attachmentCollectionXml);
		}

		const SmartPtrCXmlElement statisticsXml =
			thisXml->findOptionalChild("statistics");
		SmartPtrCStatisticsDoc statisticsVal;
		if (! statisticsXml.IsNull()) {
			statisticsVal = StatisticsXml::parse(statisticsXml);
		}

		responseDoc.CreateInstance();
		responseDoc->initialize(
			clientIdVal,
			requestIdVal,
			pmeIdVal,
			responseHeaderVal,
			manifestCollectionVal,
			attachmentCollectionVal,
			statisticsVal);
	}
	CAF_CM_EXIT;

	return responseDoc;
}

