/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 *  Copyright (C) 2001 Ben. Herrenschmidt (benh@kernel.crashing.org)
 *
 *  Modifications for ppc64:
 *      Copyright (C) 2003 Dave Engebretsen <engebret@us.ibm.com>
 */

/* NOTE:
 * Unlike ppc32, ppc64 will only call cpu_setup() for the boot CPU, it's
 * the responsibility of the appropriate CPU save/restore functions to
 * eventually copy these settings over. Those save/restore aren't yet
 * part of the cputable though. That has to be fixed for both ppc32
 * and ppc64
 */
#define COMMON_USER_PPC64	(PPC_FEATURE_32 | PPC_FEATURE_HAS_FPU | \
				 PPC_FEATURE_HAS_MMU | PPC_FEATURE_64)
#define COMMON_USER_POWER4	(COMMON_USER_PPC64 | PPC_FEATURE_POWER4)
#define COMMON_USER_POWER5	(COMMON_USER_PPC64 | PPC_FEATURE_POWER5 |\
				 PPC_FEATURE_SMT | PPC_FEATURE_ICACHE_SNOOP)
#define COMMON_USER_POWER5_PLUS	(COMMON_USER_PPC64 | PPC_FEATURE_POWER5_PLUS|\
				 PPC_FEATURE_SMT | PPC_FEATURE_ICACHE_SNOOP)
#define COMMON_USER_POWER6	(COMMON_USER_PPC64 | PPC_FEATURE_ARCH_2_05 |\
				 PPC_FEATURE_SMT | PPC_FEATURE_ICACHE_SNOOP | \
				 PPC_FEATURE_TRUE_LE | \
				 PPC_FEATURE_PSERIES_PERFMON_COMPAT)
#define COMMON_USER_POWER7	(COMMON_USER_PPC64 | PPC_FEATURE_ARCH_2_06 |\
				 PPC_FEATURE_SMT | PPC_FEATURE_ICACHE_SNOOP | \
				 PPC_FEATURE_TRUE_LE | \
				 PPC_FEATURE_PSERIES_PERFMON_COMPAT)
#define COMMON_USER2_POWER7	(PPC_FEATURE2_DSCR)
#define COMMON_USER_POWER8	(COMMON_USER_PPC64 | PPC_FEATURE_ARCH_2_06 |\
				 PPC_FEATURE_SMT | PPC_FEATURE_ICACHE_SNOOP | \
				 PPC_FEATURE_TRUE_LE | \
				 PPC_FEATURE_PSERIES_PERFMON_COMPAT)
#define COMMON_USER2_POWER8	(PPC_FEATURE2_ARCH_2_07 | \
				 PPC_FEATURE2_HTM_COMP | \
				 PPC_FEATURE2_HTM_NOSC_COMP | \
				 PPC_FEATURE2_DSCR | \
				 PPC_FEATURE2_ISEL | PPC_FEATURE2_TAR | \
				 PPC_FEATURE2_VEC_CRYPTO)
#define COMMON_USER_PA6T	(COMMON_USER_PPC64 | PPC_FEATURE_PA6T |\
				 PPC_FEATURE_TRUE_LE | \
				 PPC_FEATURE_HAS_ALTIVEC_COMP)
#define COMMON_USER_POWER9	COMMON_USER_POWER8
#define COMMON_USER2_POWER9	(COMMON_USER2_POWER8 | \
				 PPC_FEATURE2_ARCH_3_00 | \
				 PPC_FEATURE2_HAS_IEEE128 | \
				 PPC_FEATURE2_DARN | \
				 PPC_FEATURE2_SCV)
#define COMMON_USER_POWER10	COMMON_USER_POWER9
#define COMMON_USER2_POWER10	(PPC_FEATURE2_ARCH_3_1 | \
				 PPC_FEATURE2_MMA | \
				 PPC_FEATURE2_ARCH_3_00 | \
				 PPC_FEATURE2_HAS_IEEE128 | \
				 PPC_FEATURE2_DARN | \
				 PPC_FEATURE2_SCV | \
				 PPC_FEATURE2_ARCH_2_07 | \
				 PPC_FEATURE2_DSCR | \
				 PPC_FEATURE2_ISEL | PPC_FEATURE2_TAR | \
				 PPC_FEATURE2_VEC_CRYPTO)

static struct cpu_spec cpu_specs[] __initdata = {
	{	/* PPC970 */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x00390000,
		.cpu_name		= "PPC970",
		.cpu_features		= CPU_FTRS_PPC970,
		.cpu_user_features	= COMMON_USER_POWER4 | PPC_FEATURE_HAS_ALTIVEC_COMP,
		.mmu_features		= MMU_FTRS_PPC970,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 8,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_ppc970,
		.cpu_restore		= __restore_cpu_ppc970,
		.platform		= "ppc970",
	},
	{	/* PPC970FX */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x003c0000,
		.cpu_name		= "PPC970FX",
		.cpu_features		= CPU_FTRS_PPC970,
		.cpu_user_features	= COMMON_USER_POWER4 | PPC_FEATURE_HAS_ALTIVEC_COMP,
		.mmu_features		= MMU_FTRS_PPC970,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 8,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_ppc970,
		.cpu_restore		= __restore_cpu_ppc970,
		.platform		= "ppc970",
	},
	{	/* PPC970MP DD1.0 - no DEEPNAP, use regular 970 init */
		.pvr_mask		= 0xffffffff,
		.pvr_value		= 0x00440100,
		.cpu_name		= "PPC970MP",
		.cpu_features		= CPU_FTRS_PPC970,
		.cpu_user_features	= COMMON_USER_POWER4 | PPC_FEATURE_HAS_ALTIVEC_COMP,
		.mmu_features		= MMU_FTRS_PPC970,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 8,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_ppc970,
		.cpu_restore		= __restore_cpu_ppc970,
		.platform		= "ppc970",
	},
	{	/* PPC970MP */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x00440000,
		.cpu_name		= "PPC970MP",
		.cpu_features		= CPU_FTRS_PPC970,
		.cpu_user_features	= COMMON_USER_POWER4 | PPC_FEATURE_HAS_ALTIVEC_COMP,
		.mmu_features		= MMU_FTRS_PPC970,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 8,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_ppc970MP,
		.cpu_restore		= __restore_cpu_ppc970,
		.platform		= "ppc970",
	},
	{	/* PPC970GX */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x00450000,
		.cpu_name		= "PPC970GX",
		.cpu_features		= CPU_FTRS_PPC970,
		.cpu_user_features	= COMMON_USER_POWER4 | PPC_FEATURE_HAS_ALTIVEC_COMP,
		.mmu_features		= MMU_FTRS_PPC970,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 8,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_ppc970,
		.platform		= "ppc970",
	},
	{	/* Power5 GR */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x003a0000,
		.cpu_name		= "POWER5 (gr)",
		.cpu_features		= CPU_FTRS_POWER5,
		.cpu_user_features	= COMMON_USER_POWER5,
		.mmu_features		= MMU_FTRS_POWER5,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.platform		= "power5",
	},
	{	/* Power5++ */
		.pvr_mask		= 0xffffff00,
		.pvr_value		= 0x003b0300,
		.cpu_name		= "POWER5+ (gs)",
		.cpu_features		= CPU_FTRS_POWER5,
		.cpu_user_features	= COMMON_USER_POWER5_PLUS,
		.mmu_features		= MMU_FTRS_POWER5,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.platform		= "power5+",
	},
	{	/* Power5 GS */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x003b0000,
		.cpu_name		= "POWER5+ (gs)",
		.cpu_features		= CPU_FTRS_POWER5,
		.cpu_user_features	= COMMON_USER_POWER5_PLUS,
		.mmu_features		= MMU_FTRS_POWER5,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.platform		= "power5+",
	},
	{	/* POWER6 in P5+ mode; 2.04-compliant processor */
		.pvr_mask		= 0xffffffff,
		.pvr_value		= 0x0f000001,
		.cpu_name		= "POWER5+",
		.cpu_features		= CPU_FTRS_POWER5,
		.cpu_user_features	= COMMON_USER_POWER5_PLUS,
		.mmu_features		= MMU_FTRS_POWER5,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.platform		= "power5+",
	},
	{	/* Power6 */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x003e0000,
		.cpu_name		= "POWER6 (raw)",
		.cpu_features		= CPU_FTRS_POWER6,
		.cpu_user_features	= COMMON_USER_POWER6 | PPC_FEATURE_POWER6_EXT,
		.mmu_features		= MMU_FTRS_POWER6,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.platform		= "power6x",
	},
	{	/* 2.05-compliant processor, i.e. Power6 "architected" mode */
		.pvr_mask		= 0xffffffff,
		.pvr_value		= 0x0f000002,
		.cpu_name		= "POWER6 (architected)",
		.cpu_features		= CPU_FTRS_POWER6,
		.cpu_user_features	= COMMON_USER_POWER6,
		.mmu_features		= MMU_FTRS_POWER6,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.platform		= "power6",
	},
	{	/* 2.06-compliant processor, i.e. Power7 "architected" mode */
		.pvr_mask		= 0xffffffff,
		.pvr_value		= 0x0f000003,
		.cpu_name		= "POWER7 (architected)",
		.cpu_features		= CPU_FTRS_POWER7,
		.cpu_user_features	= COMMON_USER_POWER7,
		.cpu_user_features2	= COMMON_USER2_POWER7,
		.mmu_features		= MMU_FTRS_POWER7,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.cpu_setup		= __setup_cpu_power7,
		.cpu_restore		= __restore_cpu_power7,
		.machine_check_early	= __machine_check_early_realmode_p7,
		.platform		= "power7",
	},
	{	/* 2.07-compliant processor, i.e. Power8 "architected" mode */
		.pvr_mask		= 0xffffffff,
		.pvr_value		= 0x0f000004,
		.cpu_name		= "POWER8 (architected)",
		.cpu_features		= CPU_FTRS_POWER8,
		.cpu_user_features	= COMMON_USER_POWER8,
		.cpu_user_features2	= COMMON_USER2_POWER8,
		.mmu_features		= MMU_FTRS_POWER8,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.cpu_setup		= __setup_cpu_power8,
		.cpu_restore		= __restore_cpu_power8,
		.machine_check_early	= __machine_check_early_realmode_p8,
		.platform		= "power8",
	},
	{	/* 2.07-compliant processor, HeXin C2000 processor */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x00660000,
		.cpu_name		= "HX-C2000",
		.cpu_features		= CPU_FTRS_POWER8,
		.cpu_user_features	= COMMON_USER_POWER8,
		.cpu_user_features2	= COMMON_USER2_POWER8,
		.mmu_features		= MMU_FTRS_POWER8,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.cpu_setup		= __setup_cpu_power8,
		.cpu_restore		= __restore_cpu_power8,
		.machine_check_early	= __machine_check_early_realmode_p8,
		.platform		= "power8",
	},
	{	/* 3.00-compliant processor, i.e. Power9 "architected" mode */
		.pvr_mask		= 0xffffffff,
		.pvr_value		= 0x0f000005,
		.cpu_name		= "POWER9 (architected)",
		.cpu_features		= CPU_FTRS_POWER9,
		.cpu_user_features	= COMMON_USER_POWER9,
		.cpu_user_features2	= COMMON_USER2_POWER9,
		.mmu_features		= MMU_FTRS_POWER9,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.cpu_setup		= __setup_cpu_power9,
		.cpu_restore		= __restore_cpu_power9,
		.platform		= "power9",
	},
	{	/* 3.1-compliant processor, i.e. Power10 "architected" mode */
		.pvr_mask		= 0xffffffff,
		.pvr_value		= 0x0f000006,
		.cpu_name		= "POWER10 (architected)",
		.cpu_features		= CPU_FTRS_POWER10,
		.cpu_user_features	= COMMON_USER_POWER10,
		.cpu_user_features2	= COMMON_USER2_POWER10,
		.mmu_features		= MMU_FTRS_POWER10,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.cpu_setup		= __setup_cpu_power10,
		.cpu_restore		= __restore_cpu_power10,
		.platform		= "power10",
	},
	{	/* Power7 */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x003f0000,
		.cpu_name		= "POWER7 (raw)",
		.cpu_features		= CPU_FTRS_POWER7,
		.cpu_user_features	= COMMON_USER_POWER7,
		.cpu_user_features2	= COMMON_USER2_POWER7,
		.mmu_features		= MMU_FTRS_POWER7,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power7,
		.cpu_restore		= __restore_cpu_power7,
		.machine_check_early	= __machine_check_early_realmode_p7,
		.platform		= "power7",
	},
	{	/* Power7+ */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x004A0000,
		.cpu_name		= "POWER7+ (raw)",
		.cpu_features		= CPU_FTRS_POWER7,
		.cpu_user_features	= COMMON_USER_POWER7,
		.cpu_user_features2	= COMMON_USER2_POWER7,
		.mmu_features		= MMU_FTRS_POWER7,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power7,
		.cpu_restore		= __restore_cpu_power7,
		.machine_check_early	= __machine_check_early_realmode_p7,
		.platform		= "power7+",
	},
	{	/* Power8E */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x004b0000,
		.cpu_name		= "POWER8E (raw)",
		.cpu_features		= CPU_FTRS_POWER8E,
		.cpu_user_features	= COMMON_USER_POWER8,
		.cpu_user_features2	= COMMON_USER2_POWER8,
		.mmu_features		= MMU_FTRS_POWER8,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power8,
		.cpu_restore		= __restore_cpu_power8,
		.machine_check_early	= __machine_check_early_realmode_p8,
		.platform		= "power8",
	},
	{	/* Power8NVL */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x004c0000,
		.cpu_name		= "POWER8NVL (raw)",
		.cpu_features		= CPU_FTRS_POWER8,
		.cpu_user_features	= COMMON_USER_POWER8,
		.cpu_user_features2	= COMMON_USER2_POWER8,
		.mmu_features		= MMU_FTRS_POWER8,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power8,
		.cpu_restore		= __restore_cpu_power8,
		.machine_check_early	= __machine_check_early_realmode_p8,
		.platform		= "power8",
	},
	{	/* Power8 */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x004d0000,
		.cpu_name		= "POWER8 (raw)",
		.cpu_features		= CPU_FTRS_POWER8,
		.cpu_user_features	= COMMON_USER_POWER8,
		.cpu_user_features2	= COMMON_USER2_POWER8,
		.mmu_features		= MMU_FTRS_POWER8,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power8,
		.cpu_restore		= __restore_cpu_power8,
		.machine_check_early	= __machine_check_early_realmode_p8,
		.platform		= "power8",
	},
	{	/* Power9 DD2.0 */
		.pvr_mask		= 0xffffefff,
		.pvr_value		= 0x004e0200,
		.cpu_name		= "POWER9 (raw)",
		.cpu_features		= CPU_FTRS_POWER9_DD2_0,
		.cpu_user_features	= COMMON_USER_POWER9,
		.cpu_user_features2	= COMMON_USER2_POWER9,
		.mmu_features		= MMU_FTRS_POWER9,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power9,
		.cpu_restore		= __restore_cpu_power9,
		.machine_check_early	= __machine_check_early_realmode_p9,
		.platform		= "power9",
	},
	{	/* Power9 DD 2.1 */
		.pvr_mask		= 0xffffefff,
		.pvr_value		= 0x004e0201,
		.cpu_name		= "POWER9 (raw)",
		.cpu_features		= CPU_FTRS_POWER9_DD2_1,
		.cpu_user_features	= COMMON_USER_POWER9,
		.cpu_user_features2	= COMMON_USER2_POWER9,
		.mmu_features		= MMU_FTRS_POWER9,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power9,
		.cpu_restore		= __restore_cpu_power9,
		.machine_check_early	= __machine_check_early_realmode_p9,
		.platform		= "power9",
	},
	{	/* Power9 DD2.2 */
		.pvr_mask		= 0xffffefff,
		.pvr_value		= 0x004e0202,
		.cpu_name		= "POWER9 (raw)",
		.cpu_features		= CPU_FTRS_POWER9_DD2_2,
		.cpu_user_features	= COMMON_USER_POWER9,
		.cpu_user_features2	= COMMON_USER2_POWER9,
		.mmu_features		= MMU_FTRS_POWER9,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power9,
		.cpu_restore		= __restore_cpu_power9,
		.machine_check_early	= __machine_check_early_realmode_p9,
		.platform		= "power9",
	},
	{	/* Power9 DD2.3 or later */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x004e0000,
		.cpu_name		= "POWER9 (raw)",
		.cpu_features		= CPU_FTRS_POWER9_DD2_3,
		.cpu_user_features	= COMMON_USER_POWER9,
		.cpu_user_features2	= COMMON_USER2_POWER9,
		.mmu_features		= MMU_FTRS_POWER9,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power9,
		.cpu_restore		= __restore_cpu_power9,
		.machine_check_early	= __machine_check_early_realmode_p9,
		.platform		= "power9",
	},
	{	/* Power10 */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x00800000,
		.cpu_name		= "POWER10 (raw)",
		.cpu_features		= CPU_FTRS_POWER10,
		.cpu_user_features	= COMMON_USER_POWER10,
		.cpu_user_features2	= COMMON_USER2_POWER10,
		.mmu_features		= MMU_FTRS_POWER10,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.cpu_setup		= __setup_cpu_power10,
		.cpu_restore		= __restore_cpu_power10,
		.machine_check_early	= __machine_check_early_realmode_p10,
		.platform		= "power10",
	},
	{	/* Cell Broadband Engine */
		.pvr_mask		= 0xffff0000,
		.pvr_value		= 0x00700000,
		.cpu_name		= "Cell Broadband Engine",
		.cpu_features		= CPU_FTRS_CELL,
		.cpu_user_features	= COMMON_USER_PPC64 | PPC_FEATURE_CELL |
					  PPC_FEATURE_HAS_ALTIVEC_COMP | PPC_FEATURE_SMT,
		.mmu_features		= MMU_FTRS_CELL,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 4,
		.pmc_type		= PPC_PMC_IBM,
		.platform		= "ppc-cell-be",
	},
	{	/* PA Semi PA6T */
		.pvr_mask		= 0x7fff0000,
		.pvr_value		= 0x00900000,
		.cpu_name		= "PA6T",
		.cpu_features		= CPU_FTRS_PA6T,
		.cpu_user_features	= COMMON_USER_PA6T,
		.mmu_features		= MMU_FTRS_PA6T,
		.icache_bsize		= 64,
		.dcache_bsize		= 64,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_PA6T,
		.cpu_setup		= __setup_cpu_pa6t,
		.cpu_restore		= __restore_cpu_pa6t,
		.platform		= "pa6t",
	},
	{	/* default match */
		.pvr_mask		= 0x00000000,
		.pvr_value		= 0x00000000,
		.cpu_name		= "POWER5 (compatible)",
		.cpu_features		= CPU_FTRS_COMPATIBLE,
		.cpu_user_features	= COMMON_USER_PPC64,
		.mmu_features		= MMU_FTRS_POWER,
		.icache_bsize		= 128,
		.dcache_bsize		= 128,
		.num_pmcs		= 6,
		.pmc_type		= PPC_PMC_IBM,
		.platform		= "power5",
	}
};
