/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.devapi;

import com.mysql.cj.api.x.AddStatement;
import com.mysql.cj.api.x.BaseSession;
import com.mysql.cj.api.x.Collection;
import com.mysql.cj.api.x.CreateCollectionIndexStatement;
import com.mysql.cj.api.x.DatabaseObject;
import com.mysql.cj.api.x.DropCollectionIndexStatement;
import com.mysql.cj.api.x.FindStatement;
import com.mysql.cj.api.x.ModifyStatement;
import com.mysql.cj.api.x.RemoveStatement;
import com.mysql.cj.api.x.Schema;
import com.mysql.cj.core.exceptions.AssertionFailedException;
import com.mysql.cj.core.exceptions.FeatureNotAvailableException;
import com.mysql.cj.mysqlx.ExprUnparser;
import com.mysql.cj.mysqlx.devapi.AddStatementImpl;
import com.mysql.cj.mysqlx.devapi.CreateCollectionIndexStatementImpl;
import com.mysql.cj.mysqlx.devapi.DropCollectionIndexStatementImpl;
import com.mysql.cj.mysqlx.devapi.FindStatementImpl;
import com.mysql.cj.mysqlx.devapi.ModifyStatementImpl;
import com.mysql.cj.mysqlx.devapi.RemoveStatementImpl;
import com.mysql.cj.mysqlx.devapi.SchemaImpl;
import com.mysql.cj.x.json.DbDoc;
import com.mysql.cj.x.json.JsonParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;

public class CollectionImpl
implements Collection {
    private SchemaImpl schema;
    private String name;

    CollectionImpl(SchemaImpl schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    @Override
    public BaseSession getSession() {
        return this.schema.getSession();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DatabaseObject.DbObjectStatus existsInDatabase() {
        if (this.schema.getSession().getMysqlxSession().tableExists(this.schema.getName(), this.name)) {
            return DatabaseObject.DbObjectStatus.EXISTS;
        }
        return DatabaseObject.DbObjectStatus.NOT_EXISTS;
    }

    @Override
    public AddStatement add(Map<String, ?> doc) {
        throw new FeatureNotAvailableException("TODO: ");
    }

    @Override
    public AddStatement add(String jsonString) {
        try {
            DbDoc doc = JsonParser.parseDoc(new StringReader(jsonString));
            return this.add(doc);
        }
        catch (IOException ex) {
            throw AssertionFailedException.shouldNotHappen(ex);
        }
    }

    @Override
    public AddStatement add(DbDoc doc) {
        return new AddStatementImpl(this, doc);
    }

    @Override
    public AddStatement add(DbDoc[] docs) {
        return new AddStatementImpl(this, docs);
    }

    @Override
    public FindStatement find() {
        return this.find(null);
    }

    @Override
    public FindStatement find(String searchCondition) {
        return new FindStatementImpl(this, searchCondition);
    }

    @Override
    public ModifyStatement modify() {
        return this.modify(null);
    }

    @Override
    public ModifyStatement modify(String searchCondition) {
        return new ModifyStatementImpl(this, searchCondition);
    }

    @Override
    public RemoveStatement remove() {
        return this.remove(null);
    }

    @Override
    public RemoveStatement remove(String searchCondition) {
        return new RemoveStatementImpl(this, searchCondition);
    }

    @Override
    public void drop() {
        this.schema.getSession().getMysqlxSession().dropCollection(this.schema.getName(), this.name);
    }

    @Override
    public CreateCollectionIndexStatement createIndex(String indexName, boolean isUnique) {
        return new CreateCollectionIndexStatementImpl(this, indexName, isUnique);
    }

    @Override
    public DropCollectionIndexStatement dropIndex(String indexName) {
        return new DropCollectionIndexStatementImpl(this, indexName);
    }

    @Override
    public long count() {
        return this.schema.getSession().getMysqlxSession().tableCount(this.schema.getName(), this.name);
    }

    @Override
    public DbDoc newDoc() {
        return new DbDoc();
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == CollectionImpl.class && ((CollectionImpl)other).schema.equals(this.schema) && ((CollectionImpl)other).schema.getSession() == this.schema.getSession()) {
            return this.name.equals(((CollectionImpl)other).name);
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Collection(");
        sb.append(ExprUnparser.quoteIdentifier(this.schema.getName()));
        sb.append(".");
        sb.append(ExprUnparser.quoteIdentifier(this.name));
        sb.append(")");
        return sb.toString();
    }
}

