-- $Id: tpch14.sql 2657 2007-06-12 16:08:15Z rdempsey $
-- TPC-H/TPC-R Promotion Effect Query (Q14)
-- Functional Query Definition
-- Approved February 1998

define 1 = 1995-09-01

select
	100.00 * sum(case
		when p_type like 'PROMO%'
			then l_extendedprice * (1 - l_discount)
		else 0
	end) / sum(l_extendedprice * (1 - l_discount)) as promo_revenue
from
	lineitem,
	part
where
	l_partkey = p_partkey
	and l_shipdate >= '&1'
	and l_shipdate < date '&1' + interval '1' month;

