/* wc_kyber_asm.S */
/*
 * Copyright (C) 2006-2024 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

#ifdef WOLFSSL_USER_SETTINGS
#ifdef WOLFSSL_USER_SETTINGS_ASM
/*
 * user_settings_asm.h is a file generated by the script user_settings_asm.sh.
 * The script takes in a user_settings.h and produces user_settings_asm.h, which
 * is a stripped down version of user_settings.h containing only preprocessor
 * directives. This makes the header safe to include in assembly (.S) files.
 */
#include "user_settings_asm.h"
#else
/*
 * Note: if user_settings.h contains any C code (e.g. a typedef or function
 * prototype), including it here in an assembly (.S) file will cause an
 * assembler failure. See user_settings_asm.h above.
 */
#include "user_settings.h"
#endif /* WOLFSSL_USER_SETTINGS_ASM */
#endif /* WOLFSSL_USER_SETTINGS */

#ifndef HAVE_INTEL_AVX1
#define HAVE_INTEL_AVX1
#endif /* HAVE_INTEL_AVX1 */
#ifndef NO_AVX2_SUPPORT
#define HAVE_INTEL_AVX2
#endif /* NO_AVX2_SUPPORT */

#ifdef WOLFSSL_WC_KYBER
#ifdef HAVE_INTEL_AVX2
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
kyber_q:
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
kyber_qinv:
.value	0xf301,0xf301
.value	0xf301,0xf301
.value	0xf301,0xf301
.value	0xf301,0xf301
.value	0xf301,0xf301
.value	0xf301,0xf301
.value	0xf301,0xf301
.value	0xf301,0xf301
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
kyber_f:
.value	0x549,0x549
.value	0x549,0x549
.value	0x549,0x549
.value	0x549,0x549
.value	0x549,0x549
.value	0x549,0x549
.value	0x549,0x549
.value	0x549,0x549
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
kyber_f_qinv:
.value	0x5049,0x5049
.value	0x5049,0x5049
.value	0x5049,0x5049
.value	0x5049,0x5049
.value	0x5049,0x5049
.value	0x5049,0x5049
.value	0x5049,0x5049
.value	0x5049,0x5049
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
kyber_v:
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_avx2_zetas:
.value	0xa0b,0xa0b
.value	0xa0b,0xa0b
.value	0xa0b,0xa0b
.value	0xa0b,0xa0b
.value	0xa0b,0xa0b
.value	0xa0b,0xa0b
.value	0xa0b,0xa0b
.value	0xa0b,0xa0b
.value	0x7b0b,0x7b0b
.value	0x7b0b,0x7b0b
.value	0x7b0b,0x7b0b
.value	0x7b0b,0x7b0b
.value	0x7b0b,0x7b0b
.value	0x7b0b,0x7b0b
.value	0x7b0b,0x7b0b
.value	0x7b0b,0x7b0b
.value	0xb9a,0xb9a
.value	0xb9a,0xb9a
.value	0xb9a,0xb9a
.value	0xb9a,0xb9a
.value	0xb9a,0xb9a
.value	0xb9a,0xb9a
.value	0xb9a,0xb9a
.value	0xb9a,0xb9a
.value	0x399a,0x399a
.value	0x399a,0x399a
.value	0x399a,0x399a
.value	0x399a,0x399a
.value	0x399a,0x399a
.value	0x399a,0x399a
.value	0x399a,0x399a
.value	0x399a,0x399a
.value	0x5d5,0x5d5
.value	0x5d5,0x5d5
.value	0x5d5,0x5d5
.value	0x5d5,0x5d5
.value	0x5d5,0x5d5
.value	0x5d5,0x5d5
.value	0x5d5,0x5d5
.value	0x5d5,0x5d5
.value	0x34d5,0x34d5
.value	0x34d5,0x34d5
.value	0x34d5,0x34d5
.value	0x34d5,0x34d5
.value	0x34d5,0x34d5
.value	0x34d5,0x34d5
.value	0x34d5,0x34d5
.value	0x34d5,0x34d5
.value	0x58e,0x58e
.value	0x58e,0x58e
.value	0x58e,0x58e
.value	0x58e,0x58e
.value	0x58e,0x58e
.value	0x58e,0x58e
.value	0x58e,0x58e
.value	0x58e,0x58e
.value	0xcf8e,0xcf8e
.value	0xcf8e,0xcf8e
.value	0xcf8e,0xcf8e
.value	0xcf8e,0xcf8e
.value	0xcf8e,0xcf8e
.value	0xcf8e,0xcf8e
.value	0xcf8e,0xcf8e
.value	0xcf8e,0xcf8e
.value	0xc56,0xc56
.value	0xc56,0xc56
.value	0xc56,0xc56
.value	0xc56,0xc56
.value	0xc56,0xc56
.value	0xc56,0xc56
.value	0xc56,0xc56
.value	0xc56,0xc56
.value	0xae56,0xae56
.value	0xae56,0xae56
.value	0xae56,0xae56
.value	0xae56,0xae56
.value	0xae56,0xae56
.value	0xae56,0xae56
.value	0xae56,0xae56
.value	0xae56,0xae56
.value	0x26e,0x26e
.value	0x26e,0x26e
.value	0x26e,0x26e
.value	0x26e,0x26e
.value	0x26e,0x26e
.value	0x26e,0x26e
.value	0x26e,0x26e
.value	0x26e,0x26e
.value	0x6c6e,0x6c6e
.value	0x6c6e,0x6c6e
.value	0x6c6e,0x6c6e
.value	0x6c6e,0x6c6e
.value	0x6c6e,0x6c6e
.value	0x6c6e,0x6c6e
.value	0x6c6e,0x6c6e
.value	0x6c6e,0x6c6e
.value	0x629,0x629
.value	0x629,0x629
.value	0x629,0x629
.value	0x629,0x629
.value	0x629,0x629
.value	0x629,0x629
.value	0x629,0x629
.value	0x629,0x629
.value	0xf129,0xf129
.value	0xf129,0xf129
.value	0xf129,0xf129
.value	0xf129,0xf129
.value	0xf129,0xf129
.value	0xf129,0xf129
.value	0xf129,0xf129
.value	0xf129,0xf129
.value	0xb6,0xb6
.value	0xb6,0xb6
.value	0xb6,0xb6
.value	0xb6,0xb6
.value	0xb6,0xb6
.value	0xb6,0xb6
.value	0xb6,0xb6
.value	0xb6,0xb6
.value	0xc2b6,0xc2b6
.value	0xc2b6,0xc2b6
.value	0xc2b6,0xc2b6
.value	0xc2b6,0xc2b6
.value	0xc2b6,0xc2b6
.value	0xc2b6,0xc2b6
.value	0xc2b6,0xc2b6
.value	0xc2b6,0xc2b6
.value	0x23d,0x23d
.value	0x23d,0x23d
.value	0x23d,0x23d
.value	0x23d,0x23d
.value	0x7d4,0x7d4
.value	0x7d4,0x7d4
.value	0x7d4,0x7d4
.value	0x7d4,0x7d4
.value	0xe93d,0xe93d
.value	0xe93d,0xe93d
.value	0xe93d,0xe93d
.value	0xe93d,0xe93d
.value	0x43d4,0x43d4
.value	0x43d4,0x43d4
.value	0x43d4,0x43d4
.value	0x43d4,0x43d4
.value	0x108,0x108
.value	0x108,0x108
.value	0x108,0x108
.value	0x108,0x108
.value	0x17f,0x17f
.value	0x17f,0x17f
.value	0x17f,0x17f
.value	0x17f,0x17f
.value	0x9908,0x9908
.value	0x9908,0x9908
.value	0x9908,0x9908
.value	0x9908,0x9908
.value	0x8e7f,0x8e7f
.value	0x8e7f,0x8e7f
.value	0x8e7f,0x8e7f
.value	0x8e7f,0x8e7f
.value	0x4c7,0x4c7
.value	0x4c7,0x4c7
.value	0x28c,0x28c
.value	0x28c,0x28c
.value	0xad9,0xad9
.value	0xad9,0xad9
.value	0x3f7,0x3f7
.value	0x3f7,0x3f7
.value	0xe9c7,0xe9c7
.value	0xe9c7,0xe9c7
.value	0xe68c,0xe68c
.value	0xe68c,0xe68c
.value	0x5d9,0x5d9
.value	0x5d9,0x5d9
.value	0x78f7,0x78f7
.value	0x78f7,0x78f7
.value	0x7f4,0x7f4
.value	0x7f4,0x7f4
.value	0x5d3,0x5d3
.value	0x5d3,0x5d3
.value	0xbe7,0xbe7
.value	0xbe7,0xbe7
.value	0x6f9,0x6f9
.value	0x6f9,0x6f9
.value	0xa3f4,0xa3f4
.value	0xa3f4,0xa3f4
.value	0x4ed3,0x4ed3
.value	0x4ed3,0x4ed3
.value	0x50e7,0x50e7
.value	0x50e7,0x50e7
.value	0x61f9,0x61f9
.value	0x61f9,0x61f9
.value	0x9c4,0x9c4
.value	0x9c4,0x9c4
.value	0x9c4,0x9c4
.value	0x9c4,0x9c4
.value	0x5b2,0x5b2
.value	0x5b2,0x5b2
.value	0x5b2,0x5b2
.value	0x5b2,0x5b2
.value	0x15c4,0x15c4
.value	0x15c4,0x15c4
.value	0x15c4,0x15c4
.value	0x15c4,0x15c4
.value	0xfbb2,0xfbb2
.value	0xfbb2,0xfbb2
.value	0xfbb2,0xfbb2
.value	0xfbb2,0xfbb2
.value	0x6bf,0x6bf
.value	0x6bf,0x6bf
.value	0x6bf,0x6bf
.value	0x6bf,0x6bf
.value	0xc7f,0xc7f
.value	0xc7f,0xc7f
.value	0xc7f,0xc7f
.value	0xc7f,0xc7f
.value	0x53bf,0x53bf
.value	0x53bf,0x53bf
.value	0x53bf,0x53bf
.value	0x53bf,0x53bf
.value	0x997f,0x997f
.value	0x997f,0x997f
.value	0x997f,0x997f
.value	0x997f,0x997f
.value	0x204,0x204
.value	0x204,0x204
.value	0xcf9,0xcf9
.value	0xcf9,0xcf9
.value	0xbc1,0xbc1
.value	0xbc1,0xbc1
.value	0xa67,0xa67
.value	0xa67,0xa67
.value	0xce04,0xce04
.value	0xce04,0xce04
.value	0x67f9,0x67f9
.value	0x67f9,0x67f9
.value	0x3ec1,0x3ec1
.value	0x3ec1,0x3ec1
.value	0xcf67,0xcf67
.value	0xcf67,0xcf67
.value	0x6af,0x6af
.value	0x6af,0x6af
.value	0x877,0x877
.value	0x877,0x877
.value	0x7e,0x7e
.value	0x7e,0x7e
.value	0x5bd,0x5bd
.value	0x5bd,0x5bd
.value	0x23af,0x23af
.value	0x23af,0x23af
.value	0xfd77,0xfd77
.value	0xfd77,0xfd77
.value	0x9a7e,0x9a7e
.value	0x9a7e,0x9a7e
.value	0x6cbd,0x6cbd
.value	0x6cbd,0x6cbd
.value	0x8b2,0x8b2
.value	0x1ae,0x1ae
.value	0x22b,0x22b
.value	0x34b,0x34b
.value	0x81e,0x81e
.value	0x367,0x367
.value	0x60e,0x60e
.value	0x69,0x69
.value	0xfeb2,0xfeb2
.value	0x2bae,0x2bae
.value	0xd32b,0xd32b
.value	0x344b,0x344b
.value	0x821e,0x821e
.value	0xc867,0xc867
.value	0x500e,0x500e
.value	0xab69,0xab69
.value	0x1a6,0x1a6
.value	0x24b,0x24b
.value	0xb1,0xb1
.value	0xc16,0xc16
.value	0xbde,0xbde
.value	0xb35,0xb35
.value	0x626,0x626
.value	0x675,0x675
.value	0x93a6,0x93a6
.value	0x334b,0x334b
.value	0x3b1,0x3b1
.value	0xee16,0xee16
.value	0xc5de,0xc5de
.value	0x5a35,0x5a35
.value	0x1826,0x1826
.value	0x1575,0x1575
.value	0xc0b,0xc0b
.value	0x30a,0x30a
.value	0x487,0x487
.value	0xc6e,0xc6e
.value	0x9f8,0x9f8
.value	0x5cb,0x5cb
.value	0xaa7,0xaa7
.value	0x45f,0x45f
.value	0x7d0b,0x7d0b
.value	0x810a,0x810a
.value	0x2987,0x2987
.value	0x766e,0x766e
.value	0x71f8,0x71f8
.value	0xb6cb,0xb6cb
.value	0x8fa7,0x8fa7
.value	0x315f,0x315f
.value	0x6cb,0x6cb
.value	0x284,0x284
.value	0x999,0x999
.value	0x15d,0x15d
.value	0x1a2,0x1a2
.value	0x149,0x149
.value	0xc65,0xc65
.value	0xcb6,0xcb6
.value	0xb7cb,0xb7cb
.value	0x4e84,0x4e84
.value	0x4499,0x4499
.value	0x485d,0x485d
.value	0xc7a2,0xc7a2
.value	0x4c49,0x4c49
.value	0xeb65,0xeb65
.value	0xceb6,0xceb6
.value	0x714,0x714
.value	0x714,0x714
.value	0x714,0x714
.value	0x714,0x714
.value	0x714,0x714
.value	0x714,0x714
.value	0x714,0x714
.value	0x714,0x714
.value	0x314,0x314
.value	0x314,0x314
.value	0x314,0x314
.value	0x314,0x314
.value	0x314,0x314
.value	0x314,0x314
.value	0x314,0x314
.value	0x314,0x314
.value	0x11f,0x11f
.value	0x11f,0x11f
.value	0x11f,0x11f
.value	0x11f,0x11f
.value	0x11f,0x11f
.value	0x11f,0x11f
.value	0x11f,0x11f
.value	0x11f,0x11f
.value	0x6e1f,0x6e1f
.value	0x6e1f,0x6e1f
.value	0x6e1f,0x6e1f
.value	0x6e1f,0x6e1f
.value	0x6e1f,0x6e1f
.value	0x6e1f,0x6e1f
.value	0x6e1f,0x6e1f
.value	0x6e1f,0x6e1f
.value	0xca,0xca
.value	0xca,0xca
.value	0xca,0xca
.value	0xca,0xca
.value	0xca,0xca
.value	0xca,0xca
.value	0xca,0xca
.value	0xca,0xca
.value	0xbeca,0xbeca
.value	0xbeca,0xbeca
.value	0xbeca,0xbeca
.value	0xbeca,0xbeca
.value	0xbeca,0xbeca
.value	0xbeca,0xbeca
.value	0xbeca,0xbeca
.value	0xbeca,0xbeca
.value	0x3c2,0x3c2
.value	0x3c2,0x3c2
.value	0x3c2,0x3c2
.value	0x3c2,0x3c2
.value	0x3c2,0x3c2
.value	0x3c2,0x3c2
.value	0x3c2,0x3c2
.value	0x3c2,0x3c2
.value	0x29c2,0x29c2
.value	0x29c2,0x29c2
.value	0x29c2,0x29c2
.value	0x29c2,0x29c2
.value	0x29c2,0x29c2
.value	0x29c2,0x29c2
.value	0x29c2,0x29c2
.value	0x29c2,0x29c2
.value	0x84f,0x84f
.value	0x84f,0x84f
.value	0x84f,0x84f
.value	0x84f,0x84f
.value	0x84f,0x84f
.value	0x84f,0x84f
.value	0x84f,0x84f
.value	0x84f,0x84f
.value	0x54f,0x54f
.value	0x54f,0x54f
.value	0x54f,0x54f
.value	0x54f,0x54f
.value	0x54f,0x54f
.value	0x54f,0x54f
.value	0x54f,0x54f
.value	0x54f,0x54f
.value	0x73f,0x73f
.value	0x73f,0x73f
.value	0x73f,0x73f
.value	0x73f,0x73f
.value	0x73f,0x73f
.value	0x73f,0x73f
.value	0x73f,0x73f
.value	0x73f,0x73f
.value	0xd43f,0xd43f
.value	0xd43f,0xd43f
.value	0xd43f,0xd43f
.value	0xd43f,0xd43f
.value	0xd43f,0xd43f
.value	0xd43f,0xd43f
.value	0xd43f,0xd43f
.value	0xd43f,0xd43f
.value	0x5bc,0x5bc
.value	0x5bc,0x5bc
.value	0x5bc,0x5bc
.value	0x5bc,0x5bc
.value	0x5bc,0x5bc
.value	0x5bc,0x5bc
.value	0x5bc,0x5bc
.value	0x5bc,0x5bc
.value	0x79bc,0x79bc
.value	0x79bc,0x79bc
.value	0x79bc,0x79bc
.value	0x79bc,0x79bc
.value	0x79bc,0x79bc
.value	0x79bc,0x79bc
.value	0x79bc,0x79bc
.value	0x79bc,0x79bc
.value	0xa58,0xa58
.value	0xa58,0xa58
.value	0xa58,0xa58
.value	0xa58,0xa58
.value	0x3f9,0x3f9
.value	0x3f9,0x3f9
.value	0x3f9,0x3f9
.value	0x3f9,0x3f9
.value	0x9258,0x9258
.value	0x9258,0x9258
.value	0x9258,0x9258
.value	0x9258,0x9258
.value	0x5ef9,0x5ef9
.value	0x5ef9,0x5ef9
.value	0x5ef9,0x5ef9
.value	0x5ef9,0x5ef9
.value	0x2dc,0x2dc
.value	0x2dc,0x2dc
.value	0x2dc,0x2dc
.value	0x2dc,0x2dc
.value	0x260,0x260
.value	0x260,0x260
.value	0x260,0x260
.value	0x260,0x260
.value	0xd6dc,0xd6dc
.value	0xd6dc,0xd6dc
.value	0xd6dc,0xd6dc
.value	0xd6dc,0xd6dc
.value	0x2260,0x2260
.value	0x2260,0x2260
.value	0x2260,0x2260
.value	0x2260,0x2260
.value	0x9ac,0x9ac
.value	0x9ac,0x9ac
.value	0xca7,0xca7
.value	0xca7,0xca7
.value	0xbf2,0xbf2
.value	0xbf2,0xbf2
.value	0x33e,0x33e
.value	0x33e,0x33e
.value	0x4dac,0x4dac
.value	0x4dac,0x4dac
.value	0x91a7,0x91a7
.value	0x91a7,0x91a7
.value	0xc1f2,0xc1f2
.value	0xc1f2,0xc1f2
.value	0xdd3e,0xdd3e
.value	0xdd3e,0xdd3e
.value	0x6b,0x6b
.value	0x6b,0x6b
.value	0x774,0x774
.value	0x774,0x774
.value	0xc0a,0xc0a
.value	0xc0a,0xc0a
.value	0x94a,0x94a
.value	0x94a,0x94a
.value	0x916b,0x916b
.value	0x916b,0x916b
.value	0x2374,0x2374
.value	0x2374,0x2374
.value	0x8a0a,0x8a0a
.value	0x8a0a,0x8a0a
.value	0x474a,0x474a
.value	0x474a,0x474a
.value	0x6fb,0x6fb
.value	0x6fb,0x6fb
.value	0x6fb,0x6fb
.value	0x6fb,0x6fb
.value	0x19b,0x19b
.value	0x19b,0x19b
.value	0x19b,0x19b
.value	0x19b,0x19b
.value	0x47fb,0x47fb
.value	0x47fb,0x47fb
.value	0x47fb,0x47fb
.value	0x47fb,0x47fb
.value	0x229b,0x229b
.value	0x229b,0x229b
.value	0x229b,0x229b
.value	0x229b,0x229b
.value	0xc34,0xc34
.value	0xc34,0xc34
.value	0xc34,0xc34
.value	0xc34,0xc34
.value	0x6de,0x6de
.value	0x6de,0x6de
.value	0x6de,0x6de
.value	0x6de,0x6de
.value	0x6834,0x6834
.value	0x6834,0x6834
.value	0x6834,0x6834
.value	0x6834,0x6834
.value	0xc0de,0xc0de
.value	0xc0de,0xc0de
.value	0xc0de,0xc0de
.value	0xc0de,0xc0de
.value	0xb73,0xb73
.value	0xb73,0xb73
.value	0x3c1,0x3c1
.value	0x3c1,0x3c1
.value	0x71d,0x71d
.value	0x71d,0x71d
.value	0xa2c,0xa2c
.value	0xa2c,0xa2c
.value	0x3473,0x3473
.value	0x3473,0x3473
.value	0x36c1,0x36c1
.value	0x36c1,0x36c1
.value	0x8e1d,0x8e1d
.value	0x8e1d,0x8e1d
.value	0xce2c,0xce2c
.value	0xce2c,0xce2c
.value	0x1c0,0x1c0
.value	0x1c0,0x1c0
.value	0x8d8,0x8d8
.value	0x8d8,0x8d8
.value	0x2a5,0x2a5
.value	0x2a5,0x2a5
.value	0x806,0x806
.value	0x806,0x806
.value	0x41c0,0x41c0
.value	0x41c0,0x41c0
.value	0x10d8,0x10d8
.value	0x10d8,0x10d8
.value	0xa1a5,0xa1a5
.value	0xa1a5,0xa1a5
.value	0xba06,0xba06
.value	0xba06,0xba06
.value	0x331,0x331
.value	0x449,0x449
.value	0x25b,0x25b
.value	0x262,0x262
.value	0x52a,0x52a
.value	0x7fc,0x7fc
.value	0x748,0x748
.value	0x180,0x180
.value	0x8631,0x8631
.value	0x4f49,0x4f49
.value	0x635b,0x635b
.value	0x862,0x862
.value	0xe32a,0xe32a
.value	0x3bfc,0x3bfc
.value	0x5f48,0x5f48
.value	0x8180,0x8180
.value	0x842,0x842
.value	0xc79,0xc79
.value	0x4c2,0x4c2
.value	0x7ca,0x7ca
.value	0x997,0x997
.value	0xdc,0xdc
.value	0x85e,0x85e
.value	0x686,0x686
.value	0xae42,0xae42
.value	0xe779,0xe779
.value	0x2ac2,0x2ac2
.value	0xc5ca,0xc5ca
.value	0x5e97,0x5e97
.value	0xd4dc,0xd4dc
.value	0x425e,0x425e
.value	0x3886,0x3886
.value	0x860,0x860
.value	0x707,0x707
.value	0x803,0x803
.value	0x31a,0x31a
.value	0x71b,0x71b
.value	0x9ab,0x9ab
.value	0x99b,0x99b
.value	0x1de,0x1de
.value	0x2860,0x2860
.value	0xac07,0xac07
.value	0xe103,0xe103
.value	0xb11a,0xb11a
.value	0xa81b,0xa81b
.value	0x5aab,0x5aab
.value	0x2a9b,0x2a9b
.value	0xbbde,0xbbde
.value	0xc95,0xc95
.value	0xbcd,0xbcd
.value	0x3e4,0x3e4
.value	0x3df,0x3df
.value	0x3be,0x3be
.value	0x74d,0x74d
.value	0x5f2,0x5f2
.value	0x65c,0x65c
.value	0x7b95,0x7b95
.value	0xa2cd,0xa2cd
.value	0x6fe4,0x6fe4
.value	0xb0df,0xb0df
.value	0x5dbe,0x5dbe
.value	0x1e4d,0x1e4d
.value	0xbbf2,0xbbf2
.value	0x5a5c,0x5a5c
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_avx2_zetas_basemul:
.value	0x8b2,0x81e
.value	0xf74e,0xf7e2
.value	0x1ae,0x367
.value	0xfe52,0xfc99
.value	0x22b,0x60e
.value	0xfdd5,0xf9f2
.value	0x34b,0x69
.value	0xfcb5,0xff97
.value	0xfeb2,0x821e
.value	0x14e,0x7de2
.value	0x2bae,0xc867
.value	0xd452,0x3799
.value	0xd32b,0x500e
.value	0x2cd5,0xaff2
.value	0x344b,0xab69
.value	0xcbb5,0x5497
.value	0x1a6,0xbde
.value	0xfe5a,0xf422
.value	0x24b,0xb35
.value	0xfdb5,0xf4cb
.value	0xb1,0x626
.value	0xff4f,0xf9da
.value	0xc16,0x675
.value	0xf3ea,0xf98b
.value	0x93a6,0xc5de
.value	0x6c5a,0x3a22
.value	0x334b,0x5a35
.value	0xccb5,0xa5cb
.value	0x3b1,0x1826
.value	0xfc4f,0xe7da
.value	0xee16,0x1575
.value	0x11ea,0xea8b
.value	0xc0b,0x9f8
.value	0xf3f5,0xf608
.value	0x30a,0x5cb
.value	0xfcf6,0xfa35
.value	0x487,0xaa7
.value	0xfb79,0xf559
.value	0xc6e,0x45f
.value	0xf392,0xfba1
.value	0x7d0b,0x71f8
.value	0x82f5,0x8e08
.value	0x810a,0xb6cb
.value	0x7ef6,0x4935
.value	0x2987,0x8fa7
.value	0xd679,0x7059
.value	0x766e,0x315f
.value	0x8992,0xcea1
.value	0x6cb,0x1a2
.value	0xf935,0xfe5e
.value	0x284,0x149
.value	0xfd7c,0xfeb7
.value	0x999,0xc65
.value	0xf667,0xf39b
.value	0x15d,0xcb6
.value	0xfea3,0xf34a
.value	0xb7cb,0xc7a2
.value	0x4835,0x385e
.value	0x4e84,0x4c49
.value	0xb17c,0xb3b7
.value	0x4499,0xeb65
.value	0xbb67,0x149b
.value	0x485d,0xceb6
.value	0xb7a3,0x314a
.value	0x331,0x52a
.value	0xfccf,0xfad6
.value	0x449,0x7fc
.value	0xfbb7,0xf804
.value	0x25b,0x748
.value	0xfda5,0xf8b8
.value	0x262,0x180
.value	0xfd9e,0xfe80
.value	0x8631,0xe32a
.value	0x79cf,0x1cd6
.value	0x4f49,0x3bfc
.value	0xb0b7,0xc404
.value	0x635b,0x5f48
.value	0x9ca5,0xa0b8
.value	0x862,0x8180
.value	0xf79e,0x7e80
.value	0x842,0x997
.value	0xf7be,0xf669
.value	0xc79,0xdc
.value	0xf387,0xff24
.value	0x4c2,0x85e
.value	0xfb3e,0xf7a2
.value	0x7ca,0x686
.value	0xf836,0xf97a
.value	0xae42,0x5e97
.value	0x51be,0xa169
.value	0xe779,0xd4dc
.value	0x1887,0x2b24
.value	0x2ac2,0x425e
.value	0xd53e,0xbda2
.value	0xc5ca,0x3886
.value	0x3a36,0xc77a
.value	0x860,0x71b
.value	0xf7a0,0xf8e5
.value	0x707,0x9ab
.value	0xf8f9,0xf655
.value	0x803,0x99b
.value	0xf7fd,0xf665
.value	0x31a,0x1de
.value	0xfce6,0xfe22
.value	0x2860,0xa81b
.value	0xd7a0,0x57e5
.value	0xac07,0x5aab
.value	0x53f9,0xa555
.value	0xe103,0x2a9b
.value	0x1efd,0xd565
.value	0xb11a,0xbbde
.value	0x4ee6,0x4422
.value	0xc95,0x3be
.value	0xf36b,0xfc42
.value	0xbcd,0x74d
.value	0xf433,0xf8b3
.value	0x3e4,0x5f2
.value	0xfc1c,0xfa0e
.value	0x3df,0x65c
.value	0xfc21,0xf9a4
.value	0x7b95,0x5dbe
.value	0x846b,0xa242
.value	0xa2cd,0x1e4d
.value	0x5d33,0xe1b3
.value	0x6fe4,0xbbf2
.value	0x901c,0x440e
.value	0xb0df,0x5a5c
.value	0x4f21,0xa5a4
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_avx2_zetas_inv:
.value	0x6a5,0x6a5
.value	0x5b4,0x5b4
.value	0x70f,0x70f
.value	0x943,0x943
.value	0x922,0x922
.value	0x134,0x134
.value	0x91d,0x91d
.value	0x6c,0x6c
.value	0xa5a5,0xa5a5
.value	0xe1b4,0xe1b4
.value	0x440f,0x440f
.value	0xa243,0xa243
.value	0x4f22,0x4f22
.value	0x5d34,0x5d34
.value	0x901d,0x901d
.value	0x846c,0x846c
.value	0xb23,0xb23
.value	0x356,0x356
.value	0x366,0x366
.value	0x5e6,0x5e6
.value	0x9e7,0x9e7
.value	0x5fa,0x5fa
.value	0x4fe,0x4fe
.value	0x4a1,0x4a1
.value	0x4423,0x4423
.value	0xa556,0xa556
.value	0xd566,0xd566
.value	0x57e6,0x57e6
.value	0x4ee7,0x4ee7
.value	0x53fa,0x53fa
.value	0x1efe,0x1efe
.value	0xd7a1,0xd7a1
.value	0x4fb,0x4fb
.value	0x4fb,0x4fb
.value	0xa5c,0xa5c
.value	0xa5c,0xa5c
.value	0x429,0x429
.value	0x429,0x429
.value	0xb41,0xb41
.value	0xb41,0xb41
.value	0x45fb,0x45fb
.value	0x45fb,0x45fb
.value	0x5e5c,0x5e5c
.value	0x5e5c,0x5e5c
.value	0xef29,0xef29
.value	0xef29,0xef29
.value	0xbe41,0xbe41
.value	0xbe41,0xbe41
.value	0x2d5,0x2d5
.value	0x2d5,0x2d5
.value	0x5e4,0x5e4
.value	0x5e4,0x5e4
.value	0x940,0x940
.value	0x940,0x940
.value	0x18e,0x18e
.value	0x18e,0x18e
.value	0x31d5,0x31d5
.value	0x31d5,0x31d5
.value	0x71e4,0x71e4
.value	0x71e4,0x71e4
.value	0xc940,0xc940
.value	0xc940,0xc940
.value	0xcb8e,0xcb8e
.value	0xcb8e,0xcb8e
.value	0x623,0x623
.value	0x623,0x623
.value	0x623,0x623
.value	0x623,0x623
.value	0xcd,0xcd
.value	0xcd,0xcd
.value	0xcd,0xcd
.value	0xcd,0xcd
.value	0x3f23,0x3f23
.value	0x3f23,0x3f23
.value	0x3f23,0x3f23
.value	0x3f23,0x3f23
.value	0x97cd,0x97cd
.value	0x97cd,0x97cd
.value	0x97cd,0x97cd
.value	0x97cd,0x97cd
.value	0xb66,0xb66
.value	0xb66,0xb66
.value	0xb66,0xb66
.value	0xb66,0xb66
.value	0x606,0x606
.value	0x606,0x606
.value	0x606,0x606
.value	0x606,0x606
.value	0xdd66,0xdd66
.value	0xdd66,0xdd66
.value	0xdd66,0xdd66
.value	0xdd66,0xdd66
.value	0xb806,0xb806
.value	0xb806,0xb806
.value	0xb806,0xb806
.value	0xb806,0xb806
.value	0x745,0x745
.value	0x745,0x745
.value	0x745,0x745
.value	0x745,0x745
.value	0x745,0x745
.value	0x745,0x745
.value	0x745,0x745
.value	0x745,0x745
.value	0x8645,0x8645
.value	0x8645,0x8645
.value	0x8645,0x8645
.value	0x8645,0x8645
.value	0x8645,0x8645
.value	0x8645,0x8645
.value	0x8645,0x8645
.value	0x8645,0x8645
.value	0x5c2,0x5c2
.value	0x5c2,0x5c2
.value	0x5c2,0x5c2
.value	0x5c2,0x5c2
.value	0x5c2,0x5c2
.value	0x5c2,0x5c2
.value	0x5c2,0x5c2
.value	0x5c2,0x5c2
.value	0x2bc2,0x2bc2
.value	0x2bc2,0x2bc2
.value	0x2bc2,0x2bc2
.value	0x2bc2,0x2bc2
.value	0x2bc2,0x2bc2
.value	0x2bc2,0x2bc2
.value	0x2bc2,0x2bc2
.value	0x2bc2,0x2bc2
.value	0xc37,0xc37
.value	0xc37,0xc37
.value	0xc37,0xc37
.value	0xc37,0xc37
.value	0xc37,0xc37
.value	0xc37,0xc37
.value	0xc37,0xc37
.value	0xc37,0xc37
.value	0x4137,0x4137
.value	0x4137,0x4137
.value	0x4137,0x4137
.value	0x4137,0x4137
.value	0x4137,0x4137
.value	0x4137,0x4137
.value	0x4137,0x4137
.value	0x4137,0x4137
.value	0x67b,0x67b
.value	0xc25,0xc25
.value	0x4a3,0x4a3
.value	0x36a,0x36a
.value	0x537,0x537
.value	0x88,0x88
.value	0x83f,0x83f
.value	0x4bf,0x4bf
.value	0xc77b,0xc77b
.value	0x2b25,0x2b25
.value	0xbda3,0xbda3
.value	0xa16a,0xa16a
.value	0x3a37,0x3a37
.value	0x1888,0x1888
.value	0xd53f,0xd53f
.value	0x51bf,0x51bf
.value	0xb81,0xb81
.value	0x505,0x505
.value	0x5b9,0x5b9
.value	0x7d7,0x7d7
.value	0xa9f,0xa9f
.value	0x8b8,0x8b8
.value	0xaa6,0xaa6
.value	0x9d0,0x9d0
.value	0x7e81,0x7e81
.value	0xc405,0xc405
.value	0xa0b9,0xa0b9
.value	0x1cd7,0x1cd7
.value	0xf79f,0xf79f
.value	0xb0b8,0xb0b8
.value	0x9ca6,0x9ca6
.value	0x79d0,0x79d0
.value	0x3b7,0x3b7
.value	0x3b7,0x3b7
.value	0xf7,0xf7
.value	0xf7,0xf7
.value	0x58d,0x58d
.value	0x58d,0x58d
.value	0xc96,0xc96
.value	0xc96,0xc96
.value	0xb8b7,0xb8b7
.value	0xb8b7,0xb8b7
.value	0x75f7,0x75f7
.value	0x75f7,0x75f7
.value	0xdc8d,0xdc8d
.value	0xdc8d,0xdc8d
.value	0x6e96,0x6e96
.value	0x6e96,0x6e96
.value	0x9c3,0x9c3
.value	0x9c3,0x9c3
.value	0x10f,0x10f
.value	0x10f,0x10f
.value	0x5a,0x5a
.value	0x5a,0x5a
.value	0x355,0x355
.value	0x355,0x355
.value	0x22c3,0x22c3
.value	0x22c3,0x22c3
.value	0x3e0f,0x3e0f
.value	0x3e0f,0x3e0f
.value	0x6e5a,0x6e5a
.value	0x6e5a,0x6e5a
.value	0xb255,0xb255
.value	0xb255,0xb255
.value	0xaa1,0xaa1
.value	0xaa1,0xaa1
.value	0xaa1,0xaa1
.value	0xaa1,0xaa1
.value	0xa25,0xa25
.value	0xa25,0xa25
.value	0xa25,0xa25
.value	0xa25,0xa25
.value	0xdda1,0xdda1
.value	0xdda1,0xdda1
.value	0xdda1,0xdda1
.value	0xdda1,0xdda1
.value	0x2925,0x2925
.value	0x2925,0x2925
.value	0x2925,0x2925
.value	0x2925,0x2925
.value	0x908,0x908
.value	0x908,0x908
.value	0x908,0x908
.value	0x908,0x908
.value	0x2a9,0x2a9
.value	0x2a9,0x2a9
.value	0x2a9,0x2a9
.value	0x2a9,0x2a9
.value	0xa108,0xa108
.value	0xa108,0xa108
.value	0xa108,0xa108
.value	0xa108,0xa108
.value	0x6da9,0x6da9
.value	0x6da9,0x6da9
.value	0x6da9,0x6da9
.value	0x6da9,0x6da9
.value	0x4b2,0x4b2
.value	0x4b2,0x4b2
.value	0x4b2,0x4b2
.value	0x4b2,0x4b2
.value	0x4b2,0x4b2
.value	0x4b2,0x4b2
.value	0x4b2,0x4b2
.value	0x4b2,0x4b2
.value	0xfab2,0xfab2
.value	0xfab2,0xfab2
.value	0xfab2,0xfab2
.value	0xfab2,0xfab2
.value	0xfab2,0xfab2
.value	0xfab2,0xfab2
.value	0xfab2,0xfab2
.value	0xfab2,0xfab2
.value	0x93f,0x93f
.value	0x93f,0x93f
.value	0x93f,0x93f
.value	0x93f,0x93f
.value	0x93f,0x93f
.value	0x93f,0x93f
.value	0x93f,0x93f
.value	0x93f,0x93f
.value	0xd63f,0xd63f
.value	0xd63f,0xd63f
.value	0xd63f,0xd63f
.value	0xd63f,0xd63f
.value	0xd63f,0xd63f
.value	0xd63f,0xd63f
.value	0xd63f,0xd63f
.value	0xd63f,0xd63f
.value	0xbe2,0xbe2
.value	0xbe2,0xbe2
.value	0xbe2,0xbe2
.value	0xbe2,0xbe2
.value	0xbe2,0xbe2
.value	0xbe2,0xbe2
.value	0xbe2,0xbe2
.value	0xbe2,0xbe2
.value	0x91e2,0x91e2
.value	0x91e2,0x91e2
.value	0x91e2,0x91e2
.value	0x91e2,0x91e2
.value	0x91e2,0x91e2
.value	0x91e2,0x91e2
.value	0x91e2,0x91e2
.value	0x91e2,0x91e2
.value	0x5ed,0x5ed
.value	0x5ed,0x5ed
.value	0x5ed,0x5ed
.value	0x5ed,0x5ed
.value	0x5ed,0x5ed
.value	0x5ed,0x5ed
.value	0x5ed,0x5ed
.value	0x5ed,0x5ed
.value	0xfced,0xfced
.value	0xfced,0xfced
.value	0xfced,0xfced
.value	0xfced,0xfced
.value	0xfced,0xfced
.value	0xfced,0xfced
.value	0xfced,0xfced
.value	0xfced,0xfced
.value	0x4b,0x4b
.value	0xbb8,0xbb8
.value	0x9c,0x9c
.value	0xb5f,0xb5f
.value	0xba4,0xba4
.value	0xa7d,0xa7d
.value	0x368,0x368
.value	0x636,0x636
.value	0x314b,0x314b
.value	0xb3b8,0xb3b8
.value	0x149c,0x149c
.value	0x385f,0x385f
.value	0xb7a4,0xb7a4
.value	0xb17d,0xb17d
.value	0xbb68,0xbb68
.value	0x4836,0x4836
.value	0x8a2,0x8a2
.value	0x736,0x736
.value	0x25a,0x25a
.value	0x309,0x309
.value	0x93,0x93
.value	0x9f7,0x9f7
.value	0x87a,0x87a
.value	0xf6,0xf6
.value	0xcea2,0xcea2
.value	0x4936,0x4936
.value	0x705a,0x705a
.value	0x8e09,0x8e09
.value	0x8993,0x8993
.value	0x7ef7,0x7ef7
.value	0xd67a,0xd67a
.value	0x82f6,0x82f6
.value	0x744,0x744
.value	0x744,0x744
.value	0xc83,0xc83
.value	0xc83,0xc83
.value	0x48a,0x48a
.value	0x48a,0x48a
.value	0x652,0x652
.value	0x652,0x652
.value	0x9344,0x9344
.value	0x9344,0x9344
.value	0x6583,0x6583
.value	0x6583,0x6583
.value	0x28a,0x28a
.value	0x28a,0x28a
.value	0xdc52,0xdc52
.value	0xdc52,0xdc52
.value	0x29a,0x29a
.value	0x29a,0x29a
.value	0x140,0x140
.value	0x140,0x140
.value	0x8,0x8
.value	0x8,0x8
.value	0xafd,0xafd
.value	0xafd,0xafd
.value	0x309a,0x309a
.value	0x309a,0x309a
.value	0xc140,0xc140
.value	0xc140,0xc140
.value	0x9808,0x9808
.value	0x9808,0x9808
.value	0x31fd,0x31fd
.value	0x31fd,0x31fd
.value	0x82,0x82
.value	0x82,0x82
.value	0x82,0x82
.value	0x82,0x82
.value	0x642,0x642
.value	0x642,0x642
.value	0x642,0x642
.value	0x642,0x642
.value	0x6682,0x6682
.value	0x6682,0x6682
.value	0x6682,0x6682
.value	0x6682,0x6682
.value	0xac42,0xac42
.value	0xac42,0xac42
.value	0xac42,0xac42
.value	0xac42,0xac42
.value	0x74f,0x74f
.value	0x74f,0x74f
.value	0x74f,0x74f
.value	0x74f,0x74f
.value	0x33d,0x33d
.value	0x33d,0x33d
.value	0x33d,0x33d
.value	0x33d,0x33d
.value	0x44f,0x44f
.value	0x44f,0x44f
.value	0x44f,0x44f
.value	0x44f,0x44f
.value	0xea3d,0xea3d
.value	0xea3d,0xea3d
.value	0xea3d,0xea3d
.value	0xea3d,0xea3d
.value	0xc4b,0xc4b
.value	0xc4b,0xc4b
.value	0xc4b,0xc4b
.value	0xc4b,0xc4b
.value	0xc4b,0xc4b
.value	0xc4b,0xc4b
.value	0xc4b,0xc4b
.value	0xc4b,0xc4b
.value	0x3d4b,0x3d4b
.value	0x3d4b,0x3d4b
.value	0x3d4b,0x3d4b
.value	0x3d4b,0x3d4b
.value	0x3d4b,0x3d4b
.value	0x3d4b,0x3d4b
.value	0x3d4b,0x3d4b
.value	0x3d4b,0x3d4b
.value	0x6d8,0x6d8
.value	0x6d8,0x6d8
.value	0x6d8,0x6d8
.value	0x6d8,0x6d8
.value	0x6d8,0x6d8
.value	0x6d8,0x6d8
.value	0x6d8,0x6d8
.value	0x6d8,0x6d8
.value	0xed8,0xed8
.value	0xed8,0xed8
.value	0xed8,0xed8
.value	0xed8,0xed8
.value	0xed8,0xed8
.value	0xed8,0xed8
.value	0xed8,0xed8
.value	0xed8,0xed8
.value	0x773,0x773
.value	0x773,0x773
.value	0x773,0x773
.value	0x773,0x773
.value	0x773,0x773
.value	0x773,0x773
.value	0x773,0x773
.value	0x773,0x773
.value	0x3073,0x3073
.value	0x3073,0x3073
.value	0x3073,0x3073
.value	0x3073,0x3073
.value	0x3073,0x3073
.value	0x3073,0x3073
.value	0x3073,0x3073
.value	0x3073,0x3073
.value	0x68c,0x68c
.value	0x1cc,0x1cc
.value	0x6db,0x6db
.value	0x123,0x123
.value	0xeb,0xeb
.value	0xab6,0xab6
.value	0xc50,0xc50
.value	0xb5b,0xb5b
.value	0xea8c,0xea8c
.value	0xa5cc,0xa5cc
.value	0xe7db,0xe7db
.value	0x3a23,0x3a23
.value	0x11eb,0x11eb
.value	0xccb6,0xccb6
.value	0xfc50,0xfc50
.value	0x6c5b,0x6c5b
.value	0xc98,0xc98
.value	0x99a,0x99a
.value	0x6f3,0x6f3
.value	0x4e3,0x4e3
.value	0x9b6,0x9b6
.value	0xb53,0xb53
.value	0xad6,0xad6
.value	0x44f,0x44f
.value	0x5498,0x5498
.value	0x379a,0x379a
.value	0xaff3,0xaff3
.value	0x7de3,0x7de3
.value	0xcbb6,0xcbb6
.value	0xd453,0xd453
.value	0x2cd6,0x2cd6
.value	0x14f,0x14f
.value	0x608,0x608
.value	0x608,0x608
.value	0x11a,0x11a
.value	0x11a,0x11a
.value	0x72e,0x72e
.value	0x72e,0x72e
.value	0x50d,0x50d
.value	0x50d,0x50d
.value	0x9e08,0x9e08
.value	0x9e08,0x9e08
.value	0xaf1a,0xaf1a
.value	0xaf1a,0xaf1a
.value	0xb12e,0xb12e
.value	0xb12e,0xb12e
.value	0x5c0d,0x5c0d
.value	0x5c0d,0x5c0d
.value	0x90a,0x90a
.value	0x90a,0x90a
.value	0x228,0x228
.value	0x228,0x228
.value	0xa75,0xa75
.value	0xa75,0xa75
.value	0x83a,0x83a
.value	0x83a,0x83a
.value	0x870a,0x870a
.value	0x870a,0x870a
.value	0xfa28,0xfa28
.value	0xfa28,0xfa28
.value	0x1975,0x1975
.value	0x1975,0x1975
.value	0x163a,0x163a
.value	0x163a,0x163a
.value	0xb82,0xb82
.value	0xb82,0xb82
.value	0xb82,0xb82
.value	0xb82,0xb82
.value	0xbf9,0xbf9
.value	0xbf9,0xbf9
.value	0xbf9,0xbf9
.value	0xbf9,0xbf9
.value	0x7182,0x7182
.value	0x7182,0x7182
.value	0x7182,0x7182
.value	0x7182,0x7182
.value	0x66f9,0x66f9
.value	0x66f9,0x66f9
.value	0x66f9,0x66f9
.value	0x66f9,0x66f9
.value	0x52d,0x52d
.value	0x52d,0x52d
.value	0x52d,0x52d
.value	0x52d,0x52d
.value	0xac4,0xac4
.value	0xac4,0xac4
.value	0xac4,0xac4
.value	0xac4,0xac4
.value	0xbc2d,0xbc2d
.value	0xbc2d,0xbc2d
.value	0xbc2d,0xbc2d
.value	0xbc2d,0xbc2d
.value	0x16c4,0x16c4
.value	0x16c4,0x16c4
.value	0x16c4,0x16c4
.value	0x16c4,0x16c4
.value	0xa93,0xa93
.value	0xa93,0xa93
.value	0xa93,0xa93
.value	0xa93,0xa93
.value	0xa93,0xa93
.value	0xa93,0xa93
.value	0xa93,0xa93
.value	0xa93,0xa93
.value	0x9393,0x9393
.value	0x9393,0x9393
.value	0x9393,0x9393
.value	0x9393,0x9393
.value	0x9393,0x9393
.value	0x9393,0x9393
.value	0x9393,0x9393
.value	0x9393,0x9393
.value	0xab,0xab
.value	0xab,0xab
.value	0xab,0xab
.value	0xab,0xab
.value	0xab,0xab
.value	0xab,0xab
.value	0xab,0xab
.value	0xab,0xab
.value	0x51ab,0x51ab
.value	0x51ab,0x51ab
.value	0x51ab,0x51ab
.value	0x51ab,0x51ab
.value	0x51ab,0x51ab
.value	0x51ab,0x51ab
.value	0x51ab,0x51ab
.value	0x51ab,0x51ab
.value	0x72c,0x72c
.value	0x72c,0x72c
.value	0x72c,0x72c
.value	0x72c,0x72c
.value	0x72c,0x72c
.value	0x72c,0x72c
.value	0x72c,0x72c
.value	0x72c,0x72c
.value	0xcb2c,0xcb2c
.value	0xcb2c,0xcb2c
.value	0xcb2c,0xcb2c
.value	0xcb2c,0xcb2c
.value	0xcb2c,0xcb2c
.value	0xcb2c,0xcb2c
.value	0xcb2c,0xcb2c
.value	0xcb2c,0xcb2c
.value	0x167,0x167
.value	0x167,0x167
.value	0x167,0x167
.value	0x167,0x167
.value	0x167,0x167
.value	0x167,0x167
.value	0x167,0x167
.value	0x167,0x167
.value	0xc667,0xc667
.value	0xc667,0xc667
.value	0xc667,0xc667
.value	0xc667,0xc667
.value	0xc667,0xc667
.value	0xc667,0xc667
.value	0xc667,0xc667
.value	0xc667,0xc667
.value	0x2f6,0x2f6
.value	0x2f6,0x2f6
.value	0x2f6,0x2f6
.value	0x2f6,0x2f6
.value	0x2f6,0x2f6
.value	0x2f6,0x2f6
.value	0x2f6,0x2f6
.value	0x2f6,0x2f6
.value	0x84f6,0x84f6
.value	0x84f6,0x84f6
.value	0x84f6,0x84f6
.value	0x84f6,0x84f6
.value	0x84f6,0x84f6
.value	0x84f6,0x84f6
.value	0x84f6,0x84f6
.value	0x84f6,0x84f6
.value	0x5a1,0x5a1
.value	0x5a1,0x5a1
.value	0x5a1,0x5a1
.value	0x5a1,0x5a1
.value	0x5a1,0x5a1
.value	0x5a1,0x5a1
.value	0x5a1,0x5a1
.value	0x5a1,0x5a1
.value	0xd8a1,0xd8a1
.value	0xd8a1,0xd8a1
.value	0xd8a1,0xd8a1
.value	0xd8a1,0xd8a1
.value	0xd8a1,0xd8a1
.value	0xd8a1,0xd8a1
.value	0xd8a1,0xd8a1
.value	0xd8a1,0xd8a1
#ifndef __APPLE__
.text
.globl	kyber_keygen_avx2
.type	kyber_keygen_avx2,@function
.align	16
kyber_keygen_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_keygen_avx2
.p2align	4
_kyber_keygen_avx2:
#endif /* __APPLE__ */
        vmovdqu	kyber_q(%rip), %ymm14
        vmovdqu	kyber_v(%rip), %ymm15
        movq	%r8, %r9
        movq	%rdi, %r10
L_kyber_keygen_avx2_priv:
        # ntt
        leaq	L_kyber_avx2_zetas(%rip), %r11
        vmovdqu	(%r11), %ymm10
        vmovdqu	32(%r11), %ymm12
        vmovdqu	128(%r10), %ymm0
        vmovdqu	160(%r10), %ymm1
        vmovdqu	192(%r10), %ymm2
        vmovdqu	224(%r10), %ymm3
        vmovdqu	384(%r10), %ymm4
        vmovdqu	416(%r10), %ymm5
        vmovdqu	448(%r10), %ymm6
        vmovdqu	480(%r10), %ymm7
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vmovdqu	%ymm0, 128(%r10)
        vmovdqu	%ymm1, 160(%r10)
        vmovdqu	%ymm2, 192(%r10)
        vmovdqu	%ymm3, 224(%r10)
        vmovdqu	%ymm4, 384(%r10)
        vmovdqu	%ymm5, 416(%r10)
        vmovdqu	%ymm6, 448(%r10)
        vmovdqu	%ymm7, 480(%r10)
        vmovdqu	(%r10), %ymm0
        vmovdqu	32(%r10), %ymm1
        vmovdqu	64(%r10), %ymm2
        vmovdqu	96(%r10), %ymm3
        vmovdqu	256(%r10), %ymm4
        vmovdqu	288(%r10), %ymm5
        vmovdqu	320(%r10), %ymm6
        vmovdqu	352(%r10), %ymm7
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vmovdqu	%ymm4, 256(%r10)
        vmovdqu	%ymm5, 288(%r10)
        vmovdqu	%ymm6, 320(%r10)
        vmovdqu	%ymm7, 352(%r10)
        vmovdqu	128(%r10), %ymm4
        vmovdqu	160(%r10), %ymm5
        vmovdqu	192(%r10), %ymm6
        vmovdqu	224(%r10), %ymm7
        # 64: 0/3
        vmovdqu	64(%r11), %ymm10
        vmovdqu	96(%r11), %ymm12
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        # 32: 0/3
        vmovdqu	128(%r11), %ymm10
        vmovdqu	160(%r11), %ymm12
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm2
        vpsubw	%ymm9, %ymm1, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        # 32: 0/3
        vmovdqu	192(%r11), %ymm10
        vmovdqu	224(%r11), %ymm12
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm6
        vpsubw	%ymm9, %ymm5, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        # 16: 0/3
        vmovdqu	256(%r11), %ymm10
        vmovdqu	288(%r11), %ymm12
        vmovdqu	320(%r11), %ymm11
        vmovdqu	352(%r11), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 16: 0/3
        vmovdqu	384(%r11), %ymm10
        vmovdqu	416(%r11), %ymm12
        vmovdqu	448(%r11), %ymm11
        vmovdqu	480(%r11), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 8: 0/3
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	512(%r11), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	544(%r11), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	576(%r11), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	608(%r11), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm0
        vpsubw	%ymm2, %ymm3, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm1
        vpsubw	%ymm2, %ymm9, %ymm3
        vpaddw	%ymm0, %ymm8, %ymm8
        vpaddw	%ymm2, %ymm9, %ymm9
        # 4: 0/3
        vmovdqu	640(%r11), %ymm10
        vmovdqu	672(%r11), %ymm12
        vmovdqu	704(%r11), %ymm11
        vmovdqu	736(%r11), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 8: 0/3
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	768(%r11), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	800(%r11), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	832(%r11), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	864(%r11), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm4
        vpsubw	%ymm6, %ymm7, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm5
        vpsubw	%ymm6, %ymm9, %ymm7
        vpaddw	%ymm4, %ymm8, %ymm8
        vpaddw	%ymm6, %ymm9, %ymm9
        # 4: 0/3
        vmovdqu	896(%r11), %ymm10
        vmovdqu	928(%r11), %ymm12
        vmovdqu	960(%r11), %ymm11
        vmovdqu	992(%r11), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 2: 0/3
        vmovdqu	1024(%r11), %ymm10
        vmovdqu	1056(%r11), %ymm12
        vmovdqu	1088(%r11), %ymm11
        vmovdqu	1120(%r11), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 2: 0/3
        vmovdqu	1152(%r11), %ymm10
        vmovdqu	1184(%r11), %ymm12
        vmovdqu	1216(%r11), %ymm11
        vmovdqu	1248(%r11), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vpmulhw	%ymm15, %ymm0, %ymm8
        vpmulhw	%ymm15, %ymm1, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm8
        vpsubw	%ymm9, %ymm1, %ymm9
        vmovdqu	%ymm8, (%r10)
        vmovdqu	%ymm9, 32(%r10)
        vpmulhw	%ymm15, %ymm2, %ymm8
        vpmulhw	%ymm15, %ymm3, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vmovdqu	%ymm8, 64(%r10)
        vmovdqu	%ymm9, 96(%r10)
        vpmulhw	%ymm15, %ymm4, %ymm8
        vpmulhw	%ymm15, %ymm5, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vmovdqu	%ymm8, 128(%r10)
        vmovdqu	%ymm9, 160(%r10)
        vpmulhw	%ymm15, %ymm6, %ymm8
        vpmulhw	%ymm15, %ymm7, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vmovdqu	%ymm8, 192(%r10)
        vmovdqu	%ymm9, 224(%r10)
        vmovdqu	256(%r10), %ymm0
        vmovdqu	288(%r10), %ymm1
        vmovdqu	320(%r10), %ymm2
        vmovdqu	352(%r10), %ymm3
        vmovdqu	384(%r10), %ymm4
        vmovdqu	416(%r10), %ymm5
        vmovdqu	448(%r10), %ymm6
        vmovdqu	480(%r10), %ymm7
        # 64: 1/3
        vmovdqu	1280(%r11), %ymm10
        vmovdqu	1312(%r11), %ymm12
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        # 32: 1/3
        vmovdqu	1344(%r11), %ymm10
        vmovdqu	1376(%r11), %ymm12
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm2
        vpsubw	%ymm9, %ymm1, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        # 32: 1/3
        vmovdqu	1408(%r11), %ymm10
        vmovdqu	1440(%r11), %ymm12
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm6
        vpsubw	%ymm9, %ymm5, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        # 16: 1/3
        vmovdqu	1472(%r11), %ymm10
        vmovdqu	1504(%r11), %ymm12
        vmovdqu	1536(%r11), %ymm11
        vmovdqu	1568(%r11), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 16: 1/3
        vmovdqu	1600(%r11), %ymm10
        vmovdqu	1632(%r11), %ymm12
        vmovdqu	1664(%r11), %ymm11
        vmovdqu	1696(%r11), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 8: 1/3
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	1728(%r11), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	1760(%r11), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	1792(%r11), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	1824(%r11), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm0
        vpsubw	%ymm2, %ymm3, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm1
        vpsubw	%ymm2, %ymm9, %ymm3
        vpaddw	%ymm0, %ymm8, %ymm8
        vpaddw	%ymm2, %ymm9, %ymm9
        # 4: 1/3
        vmovdqu	1856(%r11), %ymm10
        vmovdqu	1888(%r11), %ymm12
        vmovdqu	1920(%r11), %ymm11
        vmovdqu	1952(%r11), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 8: 1/3
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	1984(%r11), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	2016(%r11), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	2048(%r11), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	2080(%r11), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm4
        vpsubw	%ymm6, %ymm7, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm5
        vpsubw	%ymm6, %ymm9, %ymm7
        vpaddw	%ymm4, %ymm8, %ymm8
        vpaddw	%ymm6, %ymm9, %ymm9
        # 4: 1/3
        vmovdqu	2112(%r11), %ymm10
        vmovdqu	2144(%r11), %ymm12
        vmovdqu	2176(%r11), %ymm11
        vmovdqu	2208(%r11), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 2: 1/3
        vmovdqu	2240(%r11), %ymm10
        vmovdqu	2272(%r11), %ymm12
        vmovdqu	2304(%r11), %ymm11
        vmovdqu	2336(%r11), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 2: 1/3
        vmovdqu	2368(%r11), %ymm10
        vmovdqu	2400(%r11), %ymm12
        vmovdqu	2432(%r11), %ymm11
        vmovdqu	2464(%r11), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vpmulhw	%ymm15, %ymm0, %ymm8
        vpmulhw	%ymm15, %ymm1, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm8
        vpsubw	%ymm9, %ymm1, %ymm9
        vmovdqu	%ymm8, 256(%r10)
        vmovdqu	%ymm9, 288(%r10)
        vpmulhw	%ymm15, %ymm2, %ymm8
        vpmulhw	%ymm15, %ymm3, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vmovdqu	%ymm8, 320(%r10)
        vmovdqu	%ymm9, 352(%r10)
        vpmulhw	%ymm15, %ymm4, %ymm8
        vpmulhw	%ymm15, %ymm5, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vmovdqu	%ymm8, 384(%r10)
        vmovdqu	%ymm9, 416(%r10)
        vpmulhw	%ymm15, %ymm6, %ymm8
        vpmulhw	%ymm15, %ymm7, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vmovdqu	%ymm8, 448(%r10)
        vmovdqu	%ymm9, 480(%r10)
        addq	$0x200, %r10
        subq	$0x01, %r9
        jg	L_kyber_keygen_avx2_priv
        vmovdqu	kyber_qinv(%rip), %ymm13
        movq	%r8, %rax
        movq	%rsi, %r10
L_kyber_keygen_avx2_acc:
        # Pointwise acc mont
        movq	%r8, %r9
        # Base mul mont
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r11
        vmovdqu	(%rcx), %ymm2
        vmovdqu	32(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%rdi), %ymm4
        vmovdqu	32(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r11), %ymm10
        vmovdqu	32(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, (%r10)
        vmovdqu	%ymm1, 32(%r10)
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%rdi), %ymm4
        vmovdqu	96(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r11), %ymm10
        vmovdqu	96(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%r10)
        vmovdqu	%ymm1, 96(%r10)
        vmovdqu	128(%rcx), %ymm2
        vmovdqu	160(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r11), %ymm10
        vmovdqu	160(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%r10)
        vmovdqu	%ymm1, 160(%r10)
        vmovdqu	192(%rcx), %ymm2
        vmovdqu	224(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%rdi), %ymm4
        vmovdqu	224(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r11), %ymm10
        vmovdqu	224(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%r10)
        vmovdqu	%ymm1, 224(%r10)
        vmovdqu	256(%rcx), %ymm2
        vmovdqu	288(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%rdi), %ymm4
        vmovdqu	288(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r11), %ymm10
        vmovdqu	288(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%r10)
        vmovdqu	%ymm1, 288(%r10)
        vmovdqu	320(%rcx), %ymm2
        vmovdqu	352(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%rdi), %ymm4
        vmovdqu	352(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r11), %ymm10
        vmovdqu	352(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%r10)
        vmovdqu	%ymm1, 352(%r10)
        vmovdqu	384(%rcx), %ymm2
        vmovdqu	416(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r11), %ymm10
        vmovdqu	416(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%r10)
        vmovdqu	%ymm1, 416(%r10)
        vmovdqu	448(%rcx), %ymm2
        vmovdqu	480(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%rdi), %ymm4
        vmovdqu	480(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r11), %ymm10
        vmovdqu	480(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%r10)
        vmovdqu	%ymm1, 480(%r10)
        addq	$0x200, %rcx
        addq	$0x200, %rdi
        subq	$2, %r9
        jz	L_pointwise_acc_mont_end_keygen
L_pointwise_acc_mont_start_keygen:
        # Base mul mont add
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r11
        vmovdqu	(%rcx), %ymm2
        vmovdqu	32(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%rdi), %ymm4
        vmovdqu	32(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r11), %ymm10
        vmovdqu	32(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	(%r10), %ymm6
        vmovdqu	32(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, (%r10)
        vmovdqu	%ymm1, 32(%r10)
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%rdi), %ymm4
        vmovdqu	96(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r11), %ymm10
        vmovdqu	96(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	64(%r10), %ymm6
        vmovdqu	96(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%r10)
        vmovdqu	%ymm1, 96(%r10)
        vmovdqu	128(%rcx), %ymm2
        vmovdqu	160(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r11), %ymm10
        vmovdqu	160(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	128(%r10), %ymm6
        vmovdqu	160(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%r10)
        vmovdqu	%ymm1, 160(%r10)
        vmovdqu	192(%rcx), %ymm2
        vmovdqu	224(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%rdi), %ymm4
        vmovdqu	224(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r11), %ymm10
        vmovdqu	224(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	192(%r10), %ymm6
        vmovdqu	224(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%r10)
        vmovdqu	%ymm1, 224(%r10)
        vmovdqu	256(%rcx), %ymm2
        vmovdqu	288(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%rdi), %ymm4
        vmovdqu	288(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r11), %ymm10
        vmovdqu	288(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	256(%r10), %ymm6
        vmovdqu	288(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%r10)
        vmovdqu	%ymm1, 288(%r10)
        vmovdqu	320(%rcx), %ymm2
        vmovdqu	352(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%rdi), %ymm4
        vmovdqu	352(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r11), %ymm10
        vmovdqu	352(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	320(%r10), %ymm6
        vmovdqu	352(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%r10)
        vmovdqu	%ymm1, 352(%r10)
        vmovdqu	384(%rcx), %ymm2
        vmovdqu	416(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r11), %ymm10
        vmovdqu	416(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	384(%r10), %ymm6
        vmovdqu	416(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%r10)
        vmovdqu	%ymm1, 416(%r10)
        vmovdqu	448(%rcx), %ymm2
        vmovdqu	480(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%rdi), %ymm4
        vmovdqu	480(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r11), %ymm10
        vmovdqu	480(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	448(%r10), %ymm6
        vmovdqu	480(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%r10)
        vmovdqu	%ymm1, 480(%r10)
        addq	$0x200, %rcx
        addq	$0x200, %rdi
        subq	$0x01, %r9
        jg	L_pointwise_acc_mont_start_keygen
L_pointwise_acc_mont_end_keygen:
        # Base mul mont add
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r11
        vmovdqu	(%rcx), %ymm2
        vmovdqu	32(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%rdi), %ymm4
        vmovdqu	32(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r11), %ymm10
        vmovdqu	32(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	(%r10), %ymm6
        vmovdqu	32(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, (%r10)
        vmovdqu	%ymm1, 32(%r10)
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%rdi), %ymm4
        vmovdqu	96(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r11), %ymm10
        vmovdqu	96(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	64(%r10), %ymm6
        vmovdqu	96(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%r10)
        vmovdqu	%ymm1, 96(%r10)
        vmovdqu	128(%rcx), %ymm2
        vmovdqu	160(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r11), %ymm10
        vmovdqu	160(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	128(%r10), %ymm6
        vmovdqu	160(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%r10)
        vmovdqu	%ymm1, 160(%r10)
        vmovdqu	192(%rcx), %ymm2
        vmovdqu	224(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%rdi), %ymm4
        vmovdqu	224(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r11), %ymm10
        vmovdqu	224(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	192(%r10), %ymm6
        vmovdqu	224(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%r10)
        vmovdqu	%ymm1, 224(%r10)
        vmovdqu	256(%rcx), %ymm2
        vmovdqu	288(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%rdi), %ymm4
        vmovdqu	288(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r11), %ymm10
        vmovdqu	288(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	256(%r10), %ymm6
        vmovdqu	288(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%r10)
        vmovdqu	%ymm1, 288(%r10)
        vmovdqu	320(%rcx), %ymm2
        vmovdqu	352(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%rdi), %ymm4
        vmovdqu	352(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r11), %ymm10
        vmovdqu	352(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	320(%r10), %ymm6
        vmovdqu	352(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%r10)
        vmovdqu	%ymm1, 352(%r10)
        vmovdqu	384(%rcx), %ymm2
        vmovdqu	416(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r11), %ymm10
        vmovdqu	416(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	384(%r10), %ymm6
        vmovdqu	416(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%r10)
        vmovdqu	%ymm1, 416(%r10)
        vmovdqu	448(%rcx), %ymm2
        vmovdqu	480(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%rdi), %ymm4
        vmovdqu	480(%rdi), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r11), %ymm10
        vmovdqu	480(%r11), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm13, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	448(%r10), %ymm6
        vmovdqu	480(%r10), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%r10)
        vmovdqu	%ymm1, 480(%r10)
        addq	$0x200, %rcx
        addq	$0x200, %rdi
        movq	%r8, %r9
        shl	$9, %r9d
        subq	%r9, %rdi
        addq	$0x200, %r10
        subq	$0x01, %rax
        jg	L_kyber_keygen_avx2_acc
        movq	%r8, %rax
        vmovdqu	kyber_f(%rip), %ymm12
        vmovdqu	kyber_f_qinv(%rip), %ymm13
        movq	%r8, %rax
        movq	%rsi, %r10
L_kyber_keygen_avx2_to_mont:
        # To Mont
        vmovdqu	(%r10), %ymm0
        vmovdqu	32(%r10), %ymm1
        vmovdqu	64(%r10), %ymm2
        vmovdqu	96(%r10), %ymm3
        vpmullw	%ymm13, %ymm0, %ymm4
        vpmulhw	%ymm12, %ymm0, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm0
        vpmullw	%ymm13, %ymm1, %ymm4
        vpmulhw	%ymm12, %ymm1, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm4
        vpmulhw	%ymm12, %ymm2, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm2
        vpmullw	%ymm13, %ymm3, %ymm4
        vpmulhw	%ymm12, %ymm3, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm3
        vmovdqu	%ymm0, (%r10)
        vmovdqu	%ymm1, 32(%r10)
        vmovdqu	%ymm2, 64(%r10)
        vmovdqu	%ymm3, 96(%r10)
        vmovdqu	128(%r10), %ymm0
        vmovdqu	160(%r10), %ymm1
        vmovdqu	192(%r10), %ymm2
        vmovdqu	224(%r10), %ymm3
        vpmullw	%ymm13, %ymm0, %ymm4
        vpmulhw	%ymm12, %ymm0, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm0
        vpmullw	%ymm13, %ymm1, %ymm4
        vpmulhw	%ymm12, %ymm1, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm4
        vpmulhw	%ymm12, %ymm2, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm2
        vpmullw	%ymm13, %ymm3, %ymm4
        vpmulhw	%ymm12, %ymm3, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm3
        vmovdqu	%ymm0, 128(%r10)
        vmovdqu	%ymm1, 160(%r10)
        vmovdqu	%ymm2, 192(%r10)
        vmovdqu	%ymm3, 224(%r10)
        vmovdqu	256(%r10), %ymm0
        vmovdqu	288(%r10), %ymm1
        vmovdqu	320(%r10), %ymm2
        vmovdqu	352(%r10), %ymm3
        vpmullw	%ymm13, %ymm0, %ymm4
        vpmulhw	%ymm12, %ymm0, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm0
        vpmullw	%ymm13, %ymm1, %ymm4
        vpmulhw	%ymm12, %ymm1, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm4
        vpmulhw	%ymm12, %ymm2, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm2
        vpmullw	%ymm13, %ymm3, %ymm4
        vpmulhw	%ymm12, %ymm3, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm3
        vmovdqu	%ymm0, 256(%r10)
        vmovdqu	%ymm1, 288(%r10)
        vmovdqu	%ymm2, 320(%r10)
        vmovdqu	%ymm3, 352(%r10)
        vmovdqu	384(%r10), %ymm0
        vmovdqu	416(%r10), %ymm1
        vmovdqu	448(%r10), %ymm2
        vmovdqu	480(%r10), %ymm3
        vpmullw	%ymm13, %ymm0, %ymm4
        vpmulhw	%ymm12, %ymm0, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm0
        vpmullw	%ymm13, %ymm1, %ymm4
        vpmulhw	%ymm12, %ymm1, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm4
        vpmulhw	%ymm12, %ymm2, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm2
        vpmullw	%ymm13, %ymm3, %ymm4
        vpmulhw	%ymm12, %ymm3, %ymm5
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpsubw	%ymm4, %ymm5, %ymm3
        vmovdqu	%ymm0, 384(%r10)
        vmovdqu	%ymm1, 416(%r10)
        vmovdqu	%ymm2, 448(%r10)
        vmovdqu	%ymm3, 480(%r10)
        addq	$0x200, %r10
        subq	$0x01, %rax
        jg	L_kyber_keygen_avx2_to_mont
        movq	%r8, %rax
L_kyber_keygen_avx2_to_mont_ntt_err:
        # ntt
        leaq	L_kyber_avx2_zetas(%rip), %r11
        vmovdqu	(%r11), %ymm10
        vmovdqu	32(%r11), %ymm12
        vmovdqu	128(%rdx), %ymm0
        vmovdqu	160(%rdx), %ymm1
        vmovdqu	192(%rdx), %ymm2
        vmovdqu	224(%rdx), %ymm3
        vmovdqu	384(%rdx), %ymm4
        vmovdqu	416(%rdx), %ymm5
        vmovdqu	448(%rdx), %ymm6
        vmovdqu	480(%rdx), %ymm7
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vmovdqu	%ymm0, 128(%rdx)
        vmovdqu	%ymm1, 160(%rdx)
        vmovdqu	%ymm2, 192(%rdx)
        vmovdqu	%ymm3, 224(%rdx)
        vmovdqu	%ymm4, 384(%rdx)
        vmovdqu	%ymm5, 416(%rdx)
        vmovdqu	%ymm6, 448(%rdx)
        vmovdqu	%ymm7, 480(%rdx)
        vmovdqu	(%rdx), %ymm0
        vmovdqu	32(%rdx), %ymm1
        vmovdqu	64(%rdx), %ymm2
        vmovdqu	96(%rdx), %ymm3
        vmovdqu	256(%rdx), %ymm4
        vmovdqu	288(%rdx), %ymm5
        vmovdqu	320(%rdx), %ymm6
        vmovdqu	352(%rdx), %ymm7
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vmovdqu	%ymm4, 256(%rdx)
        vmovdqu	%ymm5, 288(%rdx)
        vmovdqu	%ymm6, 320(%rdx)
        vmovdqu	%ymm7, 352(%rdx)
        vmovdqu	128(%rdx), %ymm4
        vmovdqu	160(%rdx), %ymm5
        vmovdqu	192(%rdx), %ymm6
        vmovdqu	224(%rdx), %ymm7
        # 64: 0/3
        vmovdqu	64(%r11), %ymm10
        vmovdqu	96(%r11), %ymm12
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        # 32: 0/3
        vmovdqu	128(%r11), %ymm10
        vmovdqu	160(%r11), %ymm12
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm2
        vpsubw	%ymm9, %ymm1, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        # 32: 0/3
        vmovdqu	192(%r11), %ymm10
        vmovdqu	224(%r11), %ymm12
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm6
        vpsubw	%ymm9, %ymm5, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        # 16: 0/3
        vmovdqu	256(%r11), %ymm10
        vmovdqu	288(%r11), %ymm12
        vmovdqu	320(%r11), %ymm11
        vmovdqu	352(%r11), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 16: 0/3
        vmovdqu	384(%r11), %ymm10
        vmovdqu	416(%r11), %ymm12
        vmovdqu	448(%r11), %ymm11
        vmovdqu	480(%r11), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 8: 0/3
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	512(%r11), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	544(%r11), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	576(%r11), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	608(%r11), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm0
        vpsubw	%ymm2, %ymm3, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm1
        vpsubw	%ymm2, %ymm9, %ymm3
        vpaddw	%ymm0, %ymm8, %ymm8
        vpaddw	%ymm2, %ymm9, %ymm9
        # 4: 0/3
        vmovdqu	640(%r11), %ymm10
        vmovdqu	672(%r11), %ymm12
        vmovdqu	704(%r11), %ymm11
        vmovdqu	736(%r11), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 8: 0/3
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	768(%r11), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	800(%r11), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	832(%r11), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	864(%r11), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm4
        vpsubw	%ymm6, %ymm7, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm5
        vpsubw	%ymm6, %ymm9, %ymm7
        vpaddw	%ymm4, %ymm8, %ymm8
        vpaddw	%ymm6, %ymm9, %ymm9
        # 4: 0/3
        vmovdqu	896(%r11), %ymm10
        vmovdqu	928(%r11), %ymm12
        vmovdqu	960(%r11), %ymm11
        vmovdqu	992(%r11), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 2: 0/3
        vmovdqu	1024(%r11), %ymm10
        vmovdqu	1056(%r11), %ymm12
        vmovdqu	1088(%r11), %ymm11
        vmovdqu	1120(%r11), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 2: 0/3
        vmovdqu	1152(%r11), %ymm10
        vmovdqu	1184(%r11), %ymm12
        vmovdqu	1216(%r11), %ymm11
        vmovdqu	1248(%r11), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vmovdqu	%ymm0, (%rdx)
        vmovdqu	%ymm1, 32(%rdx)
        vmovdqu	%ymm2, 64(%rdx)
        vmovdqu	%ymm3, 96(%rdx)
        vmovdqu	%ymm4, 128(%rdx)
        vmovdqu	%ymm5, 160(%rdx)
        vmovdqu	%ymm6, 192(%rdx)
        vmovdqu	%ymm7, 224(%rdx)
        vmovdqu	256(%rdx), %ymm0
        vmovdqu	288(%rdx), %ymm1
        vmovdqu	320(%rdx), %ymm2
        vmovdqu	352(%rdx), %ymm3
        vmovdqu	384(%rdx), %ymm4
        vmovdqu	416(%rdx), %ymm5
        vmovdqu	448(%rdx), %ymm6
        vmovdqu	480(%rdx), %ymm7
        # 64: 1/3
        vmovdqu	1280(%r11), %ymm10
        vmovdqu	1312(%r11), %ymm12
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        # 32: 1/3
        vmovdqu	1344(%r11), %ymm10
        vmovdqu	1376(%r11), %ymm12
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm2
        vpsubw	%ymm9, %ymm1, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        # 32: 1/3
        vmovdqu	1408(%r11), %ymm10
        vmovdqu	1440(%r11), %ymm12
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm6
        vpsubw	%ymm9, %ymm5, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        # 16: 1/3
        vmovdqu	1472(%r11), %ymm10
        vmovdqu	1504(%r11), %ymm12
        vmovdqu	1536(%r11), %ymm11
        vmovdqu	1568(%r11), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 16: 1/3
        vmovdqu	1600(%r11), %ymm10
        vmovdqu	1632(%r11), %ymm12
        vmovdqu	1664(%r11), %ymm11
        vmovdqu	1696(%r11), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 8: 1/3
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	1728(%r11), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	1760(%r11), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	1792(%r11), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	1824(%r11), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm0
        vpsubw	%ymm2, %ymm3, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm1
        vpsubw	%ymm2, %ymm9, %ymm3
        vpaddw	%ymm0, %ymm8, %ymm8
        vpaddw	%ymm2, %ymm9, %ymm9
        # 4: 1/3
        vmovdqu	1856(%r11), %ymm10
        vmovdqu	1888(%r11), %ymm12
        vmovdqu	1920(%r11), %ymm11
        vmovdqu	1952(%r11), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 8: 1/3
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	1984(%r11), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	2016(%r11), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	2048(%r11), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	2080(%r11), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm4
        vpsubw	%ymm6, %ymm7, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm5
        vpsubw	%ymm6, %ymm9, %ymm7
        vpaddw	%ymm4, %ymm8, %ymm8
        vpaddw	%ymm6, %ymm9, %ymm9
        # 4: 1/3
        vmovdqu	2112(%r11), %ymm10
        vmovdqu	2144(%r11), %ymm12
        vmovdqu	2176(%r11), %ymm11
        vmovdqu	2208(%r11), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 2: 1/3
        vmovdqu	2240(%r11), %ymm10
        vmovdqu	2272(%r11), %ymm12
        vmovdqu	2304(%r11), %ymm11
        vmovdqu	2336(%r11), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 2: 1/3
        vmovdqu	2368(%r11), %ymm10
        vmovdqu	2400(%r11), %ymm12
        vmovdqu	2432(%r11), %ymm11
        vmovdqu	2464(%r11), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vmovdqu	%ymm0, 256(%rdx)
        vmovdqu	%ymm1, 288(%rdx)
        vmovdqu	%ymm2, 320(%rdx)
        vmovdqu	%ymm3, 352(%rdx)
        vmovdqu	%ymm4, 384(%rdx)
        vmovdqu	%ymm5, 416(%rdx)
        vmovdqu	%ymm6, 448(%rdx)
        vmovdqu	%ymm7, 480(%rdx)
        # Add Errors
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vmovdqu	64(%rsi), %ymm2
        vmovdqu	96(%rsi), %ymm3
        vmovdqu	(%rdx), %ymm4
        vmovdqu	32(%rdx), %ymm5
        vmovdqu	64(%rdx), %ymm6
        vmovdqu	96(%rdx), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	%ymm2, 64(%rsi)
        vmovdqu	%ymm3, 96(%rsi)
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	160(%rsi), %ymm1
        vmovdqu	192(%rsi), %ymm2
        vmovdqu	224(%rsi), %ymm3
        vmovdqu	128(%rdx), %ymm4
        vmovdqu	160(%rdx), %ymm5
        vmovdqu	192(%rdx), %ymm6
        vmovdqu	224(%rdx), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	%ymm2, 192(%rsi)
        vmovdqu	%ymm3, 224(%rsi)
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	288(%rsi), %ymm1
        vmovdqu	320(%rsi), %ymm2
        vmovdqu	352(%rsi), %ymm3
        vmovdqu	256(%rdx), %ymm4
        vmovdqu	288(%rdx), %ymm5
        vmovdqu	320(%rdx), %ymm6
        vmovdqu	352(%rdx), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	%ymm2, 320(%rsi)
        vmovdqu	%ymm3, 352(%rsi)
        vmovdqu	384(%rsi), %ymm0
        vmovdqu	416(%rsi), %ymm1
        vmovdqu	448(%rsi), %ymm2
        vmovdqu	480(%rsi), %ymm3
        vmovdqu	384(%rdx), %ymm4
        vmovdqu	416(%rdx), %ymm5
        vmovdqu	448(%rdx), %ymm6
        vmovdqu	480(%rdx), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	%ymm1, 416(%rsi)
        vmovdqu	%ymm2, 448(%rsi)
        vmovdqu	%ymm3, 480(%rsi)
        addq	$0x200, %rdx
        addq	$0x200, %rsi
        subq	$0x01, %rax
        jg	L_kyber_keygen_avx2_to_mont_ntt_err
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_keygen_avx2,.-kyber_keygen_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_encapsulate_avx2
.type	kyber_encapsulate_avx2,@function
.align	16
kyber_encapsulate_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_encapsulate_avx2
.p2align	4
_kyber_encapsulate_avx2:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        movq	40(%rsp), %rax
        movq	48(%rsp), %r10
        movq	56(%rsp), %r11
        subq	$48, %rsp
        vmovdqu	kyber_q(%rip), %ymm14
        vmovdqu	kyber_v(%rip), %ymm15
        movq	%r11, %r13
        movq	%r8, %r14
L_kyber_encapsulate_avx2_trans:
        # ntt
        leaq	L_kyber_avx2_zetas(%rip), %r15
        vmovdqu	(%r15), %ymm10
        vmovdqu	32(%r15), %ymm12
        vmovdqu	128(%r14), %ymm0
        vmovdqu	160(%r14), %ymm1
        vmovdqu	192(%r14), %ymm2
        vmovdqu	224(%r14), %ymm3
        vmovdqu	384(%r14), %ymm4
        vmovdqu	416(%r14), %ymm5
        vmovdqu	448(%r14), %ymm6
        vmovdqu	480(%r14), %ymm7
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vmovdqu	%ymm0, 128(%r14)
        vmovdqu	%ymm1, 160(%r14)
        vmovdqu	%ymm2, 192(%r14)
        vmovdqu	%ymm3, 224(%r14)
        vmovdqu	%ymm4, 384(%r14)
        vmovdqu	%ymm5, 416(%r14)
        vmovdqu	%ymm6, 448(%r14)
        vmovdqu	%ymm7, 480(%r14)
        vmovdqu	(%r14), %ymm0
        vmovdqu	32(%r14), %ymm1
        vmovdqu	64(%r14), %ymm2
        vmovdqu	96(%r14), %ymm3
        vmovdqu	256(%r14), %ymm4
        vmovdqu	288(%r14), %ymm5
        vmovdqu	320(%r14), %ymm6
        vmovdqu	352(%r14), %ymm7
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vmovdqu	%ymm4, 256(%r14)
        vmovdqu	%ymm5, 288(%r14)
        vmovdqu	%ymm6, 320(%r14)
        vmovdqu	%ymm7, 352(%r14)
        vmovdqu	128(%r14), %ymm4
        vmovdqu	160(%r14), %ymm5
        vmovdqu	192(%r14), %ymm6
        vmovdqu	224(%r14), %ymm7
        # 64: 0/3
        vmovdqu	64(%r15), %ymm10
        vmovdqu	96(%r15), %ymm12
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        # 32: 0/3
        vmovdqu	128(%r15), %ymm10
        vmovdqu	160(%r15), %ymm12
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm2
        vpsubw	%ymm9, %ymm1, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        # 32: 0/3
        vmovdqu	192(%r15), %ymm10
        vmovdqu	224(%r15), %ymm12
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm6
        vpsubw	%ymm9, %ymm5, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        # 16: 0/3
        vmovdqu	256(%r15), %ymm10
        vmovdqu	288(%r15), %ymm12
        vmovdqu	320(%r15), %ymm11
        vmovdqu	352(%r15), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 16: 0/3
        vmovdqu	384(%r15), %ymm10
        vmovdqu	416(%r15), %ymm12
        vmovdqu	448(%r15), %ymm11
        vmovdqu	480(%r15), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 8: 0/3
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	512(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	544(%r15), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	576(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	608(%r15), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm0
        vpsubw	%ymm2, %ymm3, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm1
        vpsubw	%ymm2, %ymm9, %ymm3
        vpaddw	%ymm0, %ymm8, %ymm8
        vpaddw	%ymm2, %ymm9, %ymm9
        # 4: 0/3
        vmovdqu	640(%r15), %ymm10
        vmovdqu	672(%r15), %ymm12
        vmovdqu	704(%r15), %ymm11
        vmovdqu	736(%r15), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 8: 0/3
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	768(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	800(%r15), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	832(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	864(%r15), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm4
        vpsubw	%ymm6, %ymm7, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm5
        vpsubw	%ymm6, %ymm9, %ymm7
        vpaddw	%ymm4, %ymm8, %ymm8
        vpaddw	%ymm6, %ymm9, %ymm9
        # 4: 0/3
        vmovdqu	896(%r15), %ymm10
        vmovdqu	928(%r15), %ymm12
        vmovdqu	960(%r15), %ymm11
        vmovdqu	992(%r15), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 2: 0/3
        vmovdqu	1024(%r15), %ymm10
        vmovdqu	1056(%r15), %ymm12
        vmovdqu	1088(%r15), %ymm11
        vmovdqu	1120(%r15), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 2: 0/3
        vmovdqu	1152(%r15), %ymm10
        vmovdqu	1184(%r15), %ymm12
        vmovdqu	1216(%r15), %ymm11
        vmovdqu	1248(%r15), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vmovdqu	%ymm0, (%r14)
        vmovdqu	%ymm1, 32(%r14)
        vmovdqu	%ymm2, 64(%r14)
        vmovdqu	%ymm3, 96(%r14)
        vmovdqu	%ymm4, 128(%r14)
        vmovdqu	%ymm5, 160(%r14)
        vmovdqu	%ymm6, 192(%r14)
        vmovdqu	%ymm7, 224(%r14)
        vmovdqu	256(%r14), %ymm0
        vmovdqu	288(%r14), %ymm1
        vmovdqu	320(%r14), %ymm2
        vmovdqu	352(%r14), %ymm3
        vmovdqu	384(%r14), %ymm4
        vmovdqu	416(%r14), %ymm5
        vmovdqu	448(%r14), %ymm6
        vmovdqu	480(%r14), %ymm7
        # 64: 1/3
        vmovdqu	1280(%r15), %ymm10
        vmovdqu	1312(%r15), %ymm12
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        # 32: 1/3
        vmovdqu	1344(%r15), %ymm10
        vmovdqu	1376(%r15), %ymm12
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm2
        vpsubw	%ymm9, %ymm1, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        # 32: 1/3
        vmovdqu	1408(%r15), %ymm10
        vmovdqu	1440(%r15), %ymm12
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm6
        vpsubw	%ymm9, %ymm5, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        # 16: 1/3
        vmovdqu	1472(%r15), %ymm10
        vmovdqu	1504(%r15), %ymm12
        vmovdqu	1536(%r15), %ymm11
        vmovdqu	1568(%r15), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 16: 1/3
        vmovdqu	1600(%r15), %ymm10
        vmovdqu	1632(%r15), %ymm12
        vmovdqu	1664(%r15), %ymm11
        vmovdqu	1696(%r15), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 8: 1/3
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	1728(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	1760(%r15), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	1792(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	1824(%r15), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm0
        vpsubw	%ymm2, %ymm3, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm1
        vpsubw	%ymm2, %ymm9, %ymm3
        vpaddw	%ymm0, %ymm8, %ymm8
        vpaddw	%ymm2, %ymm9, %ymm9
        # 4: 1/3
        vmovdqu	1856(%r15), %ymm10
        vmovdqu	1888(%r15), %ymm12
        vmovdqu	1920(%r15), %ymm11
        vmovdqu	1952(%r15), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 8: 1/3
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	1984(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	2016(%r15), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	2048(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	2080(%r15), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm4
        vpsubw	%ymm6, %ymm7, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm5
        vpsubw	%ymm6, %ymm9, %ymm7
        vpaddw	%ymm4, %ymm8, %ymm8
        vpaddw	%ymm6, %ymm9, %ymm9
        # 4: 1/3
        vmovdqu	2112(%r15), %ymm10
        vmovdqu	2144(%r15), %ymm12
        vmovdqu	2176(%r15), %ymm11
        vmovdqu	2208(%r15), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 2: 1/3
        vmovdqu	2240(%r15), %ymm10
        vmovdqu	2272(%r15), %ymm12
        vmovdqu	2304(%r15), %ymm11
        vmovdqu	2336(%r15), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 2: 1/3
        vmovdqu	2368(%r15), %ymm10
        vmovdqu	2400(%r15), %ymm12
        vmovdqu	2432(%r15), %ymm11
        vmovdqu	2464(%r15), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vmovdqu	%ymm0, 256(%r14)
        vmovdqu	%ymm1, 288(%r14)
        vmovdqu	%ymm2, 320(%r14)
        vmovdqu	%ymm3, 352(%r14)
        vmovdqu	%ymm4, 384(%r14)
        vmovdqu	%ymm5, 416(%r14)
        vmovdqu	%ymm6, 448(%r14)
        vmovdqu	%ymm7, 480(%r14)
        addq	$0x200, %r14
        subq	$0x01, %r13
        jg	L_kyber_encapsulate_avx2_trans
        movq	%r11, %r12
L_kyber_encapsulate_avx2_calc:
        vmovdqu	kyber_qinv(%rip), %ymm12
        # Pointwise acc mont
        movq	%r11, %r13
        # Base mul mont
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r15
        vmovdqu	(%rcx), %ymm2
        vmovdqu	32(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%r8), %ymm4
        vmovdqu	32(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r15), %ymm10
        vmovdqu	32(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%r8), %ymm4
        vmovdqu	96(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r15), %ymm10
        vmovdqu	96(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	%ymm1, 96(%rsi)
        vmovdqu	128(%rcx), %ymm2
        vmovdqu	160(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%r8), %ymm4
        vmovdqu	160(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r15), %ymm10
        vmovdqu	160(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	192(%rcx), %ymm2
        vmovdqu	224(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%r8), %ymm4
        vmovdqu	224(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r15), %ymm10
        vmovdqu	224(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%rsi)
        vmovdqu	%ymm1, 224(%rsi)
        vmovdqu	256(%rcx), %ymm2
        vmovdqu	288(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%r8), %ymm4
        vmovdqu	288(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r15), %ymm10
        vmovdqu	288(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	320(%rcx), %ymm2
        vmovdqu	352(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%r8), %ymm4
        vmovdqu	352(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r15), %ymm10
        vmovdqu	352(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%rsi)
        vmovdqu	%ymm1, 352(%rsi)
        vmovdqu	384(%rcx), %ymm2
        vmovdqu	416(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%r8), %ymm4
        vmovdqu	416(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r15), %ymm10
        vmovdqu	416(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	%ymm1, 416(%rsi)
        vmovdqu	448(%rcx), %ymm2
        vmovdqu	480(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%r8), %ymm4
        vmovdqu	480(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r15), %ymm10
        vmovdqu	480(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%rsi)
        vmovdqu	%ymm1, 480(%rsi)
        addq	$0x200, %rcx
        addq	$0x200, %r8
        subq	$2, %r13
        jz	L_pointwise_acc_mont_end_encap_bp
L_pointwise_acc_mont_start_encap_bp:
        # Base mul mont add
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r15
        vmovdqu	(%rcx), %ymm2
        vmovdqu	32(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%r8), %ymm4
        vmovdqu	32(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r15), %ymm10
        vmovdqu	32(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	(%rsi), %ymm6
        vmovdqu	32(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%r8), %ymm4
        vmovdqu	96(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r15), %ymm10
        vmovdqu	96(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	64(%rsi), %ymm6
        vmovdqu	96(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	%ymm1, 96(%rsi)
        vmovdqu	128(%rcx), %ymm2
        vmovdqu	160(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%r8), %ymm4
        vmovdqu	160(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r15), %ymm10
        vmovdqu	160(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	128(%rsi), %ymm6
        vmovdqu	160(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	192(%rcx), %ymm2
        vmovdqu	224(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%r8), %ymm4
        vmovdqu	224(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r15), %ymm10
        vmovdqu	224(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	192(%rsi), %ymm6
        vmovdqu	224(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%rsi)
        vmovdqu	%ymm1, 224(%rsi)
        vmovdqu	256(%rcx), %ymm2
        vmovdqu	288(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%r8), %ymm4
        vmovdqu	288(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r15), %ymm10
        vmovdqu	288(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	256(%rsi), %ymm6
        vmovdqu	288(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	320(%rcx), %ymm2
        vmovdqu	352(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%r8), %ymm4
        vmovdqu	352(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r15), %ymm10
        vmovdqu	352(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	320(%rsi), %ymm6
        vmovdqu	352(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%rsi)
        vmovdqu	%ymm1, 352(%rsi)
        vmovdqu	384(%rcx), %ymm2
        vmovdqu	416(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%r8), %ymm4
        vmovdqu	416(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r15), %ymm10
        vmovdqu	416(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	384(%rsi), %ymm6
        vmovdqu	416(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	%ymm1, 416(%rsi)
        vmovdqu	448(%rcx), %ymm2
        vmovdqu	480(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%r8), %ymm4
        vmovdqu	480(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r15), %ymm10
        vmovdqu	480(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	448(%rsi), %ymm6
        vmovdqu	480(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%rsi)
        vmovdqu	%ymm1, 480(%rsi)
        addq	$0x200, %rcx
        addq	$0x200, %r8
        subq	$0x01, %r13
        jg	L_pointwise_acc_mont_start_encap_bp
L_pointwise_acc_mont_end_encap_bp:
        # Base mul mont add
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r15
        vmovdqu	(%rcx), %ymm2
        vmovdqu	32(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%r8), %ymm4
        vmovdqu	32(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r15), %ymm10
        vmovdqu	32(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	(%rsi), %ymm6
        vmovdqu	32(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	64(%rcx), %ymm2
        vmovdqu	96(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%r8), %ymm4
        vmovdqu	96(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r15), %ymm10
        vmovdqu	96(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	64(%rsi), %ymm6
        vmovdqu	96(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	%ymm1, 96(%rsi)
        vmovdqu	128(%rcx), %ymm2
        vmovdqu	160(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%r8), %ymm4
        vmovdqu	160(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r15), %ymm10
        vmovdqu	160(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	128(%rsi), %ymm6
        vmovdqu	160(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	192(%rcx), %ymm2
        vmovdqu	224(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%r8), %ymm4
        vmovdqu	224(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r15), %ymm10
        vmovdqu	224(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	192(%rsi), %ymm6
        vmovdqu	224(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%rsi)
        vmovdqu	%ymm1, 224(%rsi)
        vmovdqu	256(%rcx), %ymm2
        vmovdqu	288(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%r8), %ymm4
        vmovdqu	288(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r15), %ymm10
        vmovdqu	288(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	256(%rsi), %ymm6
        vmovdqu	288(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	320(%rcx), %ymm2
        vmovdqu	352(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%r8), %ymm4
        vmovdqu	352(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r15), %ymm10
        vmovdqu	352(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	320(%rsi), %ymm6
        vmovdqu	352(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%rsi)
        vmovdqu	%ymm1, 352(%rsi)
        vmovdqu	384(%rcx), %ymm2
        vmovdqu	416(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%r8), %ymm4
        vmovdqu	416(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r15), %ymm10
        vmovdqu	416(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	384(%rsi), %ymm6
        vmovdqu	416(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	%ymm1, 416(%rsi)
        vmovdqu	448(%rcx), %ymm2
        vmovdqu	480(%rcx), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%r8), %ymm4
        vmovdqu	480(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r15), %ymm10
        vmovdqu	480(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	448(%rsi), %ymm6
        vmovdqu	480(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%rsi)
        vmovdqu	%ymm1, 480(%rsi)
        addq	$0x200, %rcx
        addq	$0x200, %r8
        movq	%r11, %r13
        shl	$9, %r13d
        subq	%r13, %r8
        # invntt
        leaq	L_kyber_avx2_zetas_inv(%rip), %r15
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vmovdqu	64(%rsi), %ymm2
        vmovdqu	96(%rsi), %ymm3
        vmovdqu	128(%rsi), %ymm4
        vmovdqu	160(%rsi), %ymm5
        vmovdqu	192(%rsi), %ymm6
        vmovdqu	224(%rsi), %ymm7
        # 2: 1/2
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm9
        vmovdqu	32(%r15), %ymm12
        vpsllq	$32, %ymm9, %ymm0
        vpsrlq	$32, %ymm8, %ymm1
        vpblendd	$0xaa, %ymm0, %ymm8, %ymm0
        vpblendd	$0x55, %ymm1, %ymm9, %ymm1
        vperm2i128	$32, %ymm3, %ymm2, %ymm8
        vmovdqu	64(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm9
        vmovdqu	96(%r15), %ymm13
        vpsllq	$32, %ymm9, %ymm2
        vpsrlq	$32, %ymm8, %ymm3
        vpblendd	$0xaa, %ymm2, %ymm8, %ymm2
        vpblendd	$0x55, %ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 4: 1/2
        vmovdqu	128(%r15), %ymm10
        vmovdqu	160(%r15), %ymm12
        vmovdqu	192(%r15), %ymm11
        vmovdqu	224(%r15), %ymm13
        vpunpckldq	%ymm1, %ymm8, %ymm0
        vpunpckhdq	%ymm1, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm9, %ymm2
        vpunpckhdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm2
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm8
        vpsubw	%ymm2, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 8: 1/2
        vmovdqu	256(%r15), %ymm10
        vmovdqu	288(%r15), %ymm12
        vmovdqu	320(%r15), %ymm11
        vmovdqu	352(%r15), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 16: 1/2
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	384(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	416(%r15), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	448(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	480(%r15), %ymm13
        vpsubw	%ymm1, %ymm0, %ymm8
        vpsubw	%ymm3, %ymm2, %ymm9
        vpaddw	%ymm1, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm2, %ymm2
        vpmullw	%ymm12, %ymm8, %ymm1
        vpmullw	%ymm13, %ymm9, %ymm3
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm1, %ymm8, %ymm1
        vpsubw	%ymm3, %ymm9, %ymm3
        # 32: 1/2
        vmovdqu	512(%r15), %ymm10
        vmovdqu	544(%r15), %ymm12
        vpaddw	%ymm2, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm1, %ymm9
        vpsubw	%ymm2, %ymm0, %ymm2
        vpsubw	%ymm3, %ymm1, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        # 2: 1/2
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	576(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm9
        vmovdqu	608(%r15), %ymm12
        vpsllq	$32, %ymm9, %ymm4
        vpsrlq	$32, %ymm8, %ymm5
        vpblendd	$0xaa, %ymm4, %ymm8, %ymm4
        vpblendd	$0x55, %ymm5, %ymm9, %ymm5
        vperm2i128	$32, %ymm7, %ymm6, %ymm8
        vmovdqu	640(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm9
        vmovdqu	672(%r15), %ymm13
        vpsllq	$32, %ymm9, %ymm6
        vpsrlq	$32, %ymm8, %ymm7
        vpblendd	$0xaa, %ymm6, %ymm8, %ymm6
        vpblendd	$0x55, %ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 4: 1/2
        vmovdqu	704(%r15), %ymm10
        vmovdqu	736(%r15), %ymm12
        vmovdqu	768(%r15), %ymm11
        vmovdqu	800(%r15), %ymm13
        vpunpckldq	%ymm5, %ymm8, %ymm4
        vpunpckhdq	%ymm5, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm9, %ymm6
        vpunpckhdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm6
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm6, %ymm6
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm8
        vpsubw	%ymm6, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 8: 1/2
        vmovdqu	832(%r15), %ymm10
        vmovdqu	864(%r15), %ymm12
        vmovdqu	896(%r15), %ymm11
        vmovdqu	928(%r15), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 16: 1/2
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	960(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	992(%r15), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	1024(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	1056(%r15), %ymm13
        vpsubw	%ymm5, %ymm4, %ymm8
        vpsubw	%ymm7, %ymm6, %ymm9
        vpaddw	%ymm5, %ymm4, %ymm4
        vpaddw	%ymm7, %ymm6, %ymm6
        vpmullw	%ymm12, %ymm8, %ymm5
        vpmullw	%ymm13, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm5, %ymm8, %ymm5
        vpsubw	%ymm7, %ymm9, %ymm7
        # 32: 1/2
        vmovdqu	1088(%r15), %ymm10
        vmovdqu	1120(%r15), %ymm12
        vpaddw	%ymm6, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm5, %ymm9
        vpsubw	%ymm6, %ymm4, %ymm6
        vpsubw	%ymm7, %ymm5, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm5
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm5, %ymm5
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        # 64: 1/2
        vmovdqu	1152(%r15), %ymm10
        vmovdqu	1184(%r15), %ymm12
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	%ymm2, 64(%rsi)
        vmovdqu	%ymm3, 96(%rsi)
        vmovdqu	%ymm4, 128(%rsi)
        vmovdqu	%ymm5, 160(%rsi)
        vmovdqu	%ymm6, 192(%rsi)
        vmovdqu	%ymm7, 224(%rsi)
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	288(%rsi), %ymm1
        vmovdqu	320(%rsi), %ymm2
        vmovdqu	352(%rsi), %ymm3
        vmovdqu	384(%rsi), %ymm4
        vmovdqu	416(%rsi), %ymm5
        vmovdqu	448(%rsi), %ymm6
        vmovdqu	480(%rsi), %ymm7
        # 2: 2/2
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	1216(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm9
        vmovdqu	1248(%r15), %ymm12
        vpsllq	$32, %ymm9, %ymm0
        vpsrlq	$32, %ymm8, %ymm1
        vpblendd	$0xaa, %ymm0, %ymm8, %ymm0
        vpblendd	$0x55, %ymm1, %ymm9, %ymm1
        vperm2i128	$32, %ymm3, %ymm2, %ymm8
        vmovdqu	1280(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm9
        vmovdqu	1312(%r15), %ymm13
        vpsllq	$32, %ymm9, %ymm2
        vpsrlq	$32, %ymm8, %ymm3
        vpblendd	$0xaa, %ymm2, %ymm8, %ymm2
        vpblendd	$0x55, %ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 4: 2/2
        vmovdqu	1344(%r15), %ymm10
        vmovdqu	1376(%r15), %ymm12
        vmovdqu	1408(%r15), %ymm11
        vmovdqu	1440(%r15), %ymm13
        vpunpckldq	%ymm1, %ymm8, %ymm0
        vpunpckhdq	%ymm1, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm9, %ymm2
        vpunpckhdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm2
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm8
        vpsubw	%ymm2, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 8: 2/2
        vmovdqu	1472(%r15), %ymm10
        vmovdqu	1504(%r15), %ymm12
        vmovdqu	1536(%r15), %ymm11
        vmovdqu	1568(%r15), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 16: 2/2
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	1600(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	1632(%r15), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	1664(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	1696(%r15), %ymm13
        vpsubw	%ymm1, %ymm0, %ymm8
        vpsubw	%ymm3, %ymm2, %ymm9
        vpaddw	%ymm1, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm2, %ymm2
        vpmullw	%ymm12, %ymm8, %ymm1
        vpmullw	%ymm13, %ymm9, %ymm3
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm1, %ymm8, %ymm1
        vpsubw	%ymm3, %ymm9, %ymm3
        # 32: 2/2
        vmovdqu	1728(%r15), %ymm10
        vmovdqu	1760(%r15), %ymm12
        vpaddw	%ymm2, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm1, %ymm9
        vpsubw	%ymm2, %ymm0, %ymm2
        vpsubw	%ymm3, %ymm1, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        # 2: 2/2
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	1792(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm9
        vmovdqu	1824(%r15), %ymm12
        vpsllq	$32, %ymm9, %ymm4
        vpsrlq	$32, %ymm8, %ymm5
        vpblendd	$0xaa, %ymm4, %ymm8, %ymm4
        vpblendd	$0x55, %ymm5, %ymm9, %ymm5
        vperm2i128	$32, %ymm7, %ymm6, %ymm8
        vmovdqu	1856(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm9
        vmovdqu	1888(%r15), %ymm13
        vpsllq	$32, %ymm9, %ymm6
        vpsrlq	$32, %ymm8, %ymm7
        vpblendd	$0xaa, %ymm6, %ymm8, %ymm6
        vpblendd	$0x55, %ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 4: 2/2
        vmovdqu	1920(%r15), %ymm10
        vmovdqu	1952(%r15), %ymm12
        vmovdqu	1984(%r15), %ymm11
        vmovdqu	2016(%r15), %ymm13
        vpunpckldq	%ymm5, %ymm8, %ymm4
        vpunpckhdq	%ymm5, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm9, %ymm6
        vpunpckhdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm6
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm6, %ymm6
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm8
        vpsubw	%ymm6, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 8: 2/2
        vmovdqu	2048(%r15), %ymm10
        vmovdqu	2080(%r15), %ymm12
        vmovdqu	2112(%r15), %ymm11
        vmovdqu	2144(%r15), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 16: 2/2
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	2176(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	2208(%r15), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	2240(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	2272(%r15), %ymm13
        vpsubw	%ymm5, %ymm4, %ymm8
        vpsubw	%ymm7, %ymm6, %ymm9
        vpaddw	%ymm5, %ymm4, %ymm4
        vpaddw	%ymm7, %ymm6, %ymm6
        vpmullw	%ymm12, %ymm8, %ymm5
        vpmullw	%ymm13, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm5, %ymm8, %ymm5
        vpsubw	%ymm7, %ymm9, %ymm7
        # 32: 2/2
        vmovdqu	2304(%r15), %ymm10
        vmovdqu	2336(%r15), %ymm12
        vpaddw	%ymm6, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm5, %ymm9
        vpsubw	%ymm6, %ymm4, %ymm6
        vpsubw	%ymm7, %ymm5, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm5
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm5, %ymm5
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        # 64: 2/2
        vmovdqu	2368(%r15), %ymm10
        vmovdqu	2400(%r15), %ymm12
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	%ymm2, 320(%rsi)
        vmovdqu	%ymm3, 352(%rsi)
        # 128
        vmovdqu	2432(%r15), %ymm10
        vmovdqu	2464(%r15), %ymm12
        vmovdqu	2496(%r15), %ymm11
        vmovdqu	2528(%r15), %ymm13
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	160(%rsi), %ymm1
        vmovdqu	192(%rsi), %ymm2
        vmovdqu	224(%rsi), %ymm3
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm11, %ymm0, %ymm0
        vpmulhw	%ymm11, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm0
        vpsubw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm11, %ymm2, %ymm2
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        vpmullw	%ymm13, %ymm4, %ymm8
        vpmullw	%ymm13, %ymm5, %ymm9
        vpmulhw	%ymm11, %ymm4, %ymm4
        vpmulhw	%ymm11, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm4
        vpsubw	%ymm9, %ymm5, %ymm5
        vpmullw	%ymm13, %ymm6, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm11, %ymm6, %ymm6
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	%ymm2, 192(%rsi)
        vmovdqu	%ymm3, 224(%rsi)
        vmovdqu	%ymm4, 384(%rsi)
        vmovdqu	%ymm5, 416(%rsi)
        vmovdqu	%ymm6, 448(%rsi)
        vmovdqu	%ymm7, 480(%rsi)
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vmovdqu	64(%rsi), %ymm2
        vmovdqu	96(%rsi), %ymm3
        vmovdqu	256(%rsi), %ymm4
        vmovdqu	288(%rsi), %ymm5
        vmovdqu	320(%rsi), %ymm6
        vmovdqu	352(%rsi), %ymm7
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm11, %ymm0, %ymm0
        vpmulhw	%ymm11, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm0
        vpsubw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm11, %ymm2, %ymm2
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        vpmullw	%ymm13, %ymm4, %ymm8
        vpmullw	%ymm13, %ymm5, %ymm9
        vpmulhw	%ymm11, %ymm4, %ymm4
        vpmulhw	%ymm11, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm4
        vpsubw	%ymm9, %ymm5, %ymm5
        vpmullw	%ymm13, %ymm6, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm11, %ymm6, %ymm6
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	%ymm2, 64(%rsi)
        vmovdqu	%ymm3, 96(%rsi)
        vmovdqu	%ymm4, 256(%rsi)
        vmovdqu	%ymm5, 288(%rsi)
        vmovdqu	%ymm6, 320(%rsi)
        vmovdqu	%ymm7, 352(%rsi)
        # Add Errors
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vmovdqu	64(%rsi), %ymm2
        vmovdqu	96(%rsi), %ymm3
        vmovdqu	(%r9), %ymm4
        vmovdqu	32(%r9), %ymm5
        vmovdqu	64(%r9), %ymm6
        vmovdqu	96(%r9), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	%ymm2, 64(%rsi)
        vmovdqu	%ymm3, 96(%rsi)
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	160(%rsi), %ymm1
        vmovdqu	192(%rsi), %ymm2
        vmovdqu	224(%rsi), %ymm3
        vmovdqu	128(%r9), %ymm4
        vmovdqu	160(%r9), %ymm5
        vmovdqu	192(%r9), %ymm6
        vmovdqu	224(%r9), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	%ymm2, 192(%rsi)
        vmovdqu	%ymm3, 224(%rsi)
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	288(%rsi), %ymm1
        vmovdqu	320(%rsi), %ymm2
        vmovdqu	352(%rsi), %ymm3
        vmovdqu	256(%r9), %ymm4
        vmovdqu	288(%r9), %ymm5
        vmovdqu	320(%r9), %ymm6
        vmovdqu	352(%r9), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	%ymm2, 320(%rsi)
        vmovdqu	%ymm3, 352(%rsi)
        vmovdqu	384(%rsi), %ymm0
        vmovdqu	416(%rsi), %ymm1
        vmovdqu	448(%rsi), %ymm2
        vmovdqu	480(%rsi), %ymm3
        vmovdqu	384(%r9), %ymm4
        vmovdqu	416(%r9), %ymm5
        vmovdqu	448(%r9), %ymm6
        vmovdqu	480(%r9), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	%ymm1, 416(%rsi)
        vmovdqu	%ymm2, 448(%rsi)
        vmovdqu	%ymm3, 480(%rsi)
        addq	$0x200, %r9
        addq	$0x200, %rsi
        subq	$0x01, %r12
        jg	L_kyber_encapsulate_avx2_calc
        vmovdqu	kyber_qinv(%rip), %ymm12
        # Pointwise acc mont
        movq	%r11, %r13
        # Base mul mont
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r15
        vmovdqu	(%rdi), %ymm2
        vmovdqu	32(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%r8), %ymm4
        vmovdqu	32(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r15), %ymm10
        vmovdqu	32(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, (%rdx)
        vmovdqu	%ymm1, 32(%rdx)
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%r8), %ymm4
        vmovdqu	96(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r15), %ymm10
        vmovdqu	96(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%rdx)
        vmovdqu	%ymm1, 96(%rdx)
        vmovdqu	128(%rdi), %ymm2
        vmovdqu	160(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%r8), %ymm4
        vmovdqu	160(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r15), %ymm10
        vmovdqu	160(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%rdx)
        vmovdqu	%ymm1, 160(%rdx)
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%r8), %ymm4
        vmovdqu	224(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r15), %ymm10
        vmovdqu	224(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%rdx)
        vmovdqu	%ymm1, 224(%rdx)
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	288(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%r8), %ymm4
        vmovdqu	288(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r15), %ymm10
        vmovdqu	288(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%rdx)
        vmovdqu	%ymm1, 288(%rdx)
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%r8), %ymm4
        vmovdqu	352(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r15), %ymm10
        vmovdqu	352(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%rdx)
        vmovdqu	%ymm1, 352(%rdx)
        vmovdqu	384(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%r8), %ymm4
        vmovdqu	416(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r15), %ymm10
        vmovdqu	416(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%rdx)
        vmovdqu	%ymm1, 416(%rdx)
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%r8), %ymm4
        vmovdqu	480(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r15), %ymm10
        vmovdqu	480(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%rdx)
        vmovdqu	%ymm1, 480(%rdx)
        addq	$0x200, %rdi
        addq	$0x200, %r8
        subq	$2, %r13
        jz	L_pointwise_acc_mont_end_encap_v
L_pointwise_acc_mont_start_encap_v:
        # Base mul mont add
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r15
        vmovdqu	(%rdi), %ymm2
        vmovdqu	32(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%r8), %ymm4
        vmovdqu	32(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r15), %ymm10
        vmovdqu	32(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	(%rdx), %ymm6
        vmovdqu	32(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, (%rdx)
        vmovdqu	%ymm1, 32(%rdx)
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%r8), %ymm4
        vmovdqu	96(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r15), %ymm10
        vmovdqu	96(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	64(%rdx), %ymm6
        vmovdqu	96(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%rdx)
        vmovdqu	%ymm1, 96(%rdx)
        vmovdqu	128(%rdi), %ymm2
        vmovdqu	160(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%r8), %ymm4
        vmovdqu	160(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r15), %ymm10
        vmovdqu	160(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	128(%rdx), %ymm6
        vmovdqu	160(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%rdx)
        vmovdqu	%ymm1, 160(%rdx)
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%r8), %ymm4
        vmovdqu	224(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r15), %ymm10
        vmovdqu	224(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	192(%rdx), %ymm6
        vmovdqu	224(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%rdx)
        vmovdqu	%ymm1, 224(%rdx)
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	288(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%r8), %ymm4
        vmovdqu	288(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r15), %ymm10
        vmovdqu	288(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	256(%rdx), %ymm6
        vmovdqu	288(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%rdx)
        vmovdqu	%ymm1, 288(%rdx)
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%r8), %ymm4
        vmovdqu	352(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r15), %ymm10
        vmovdqu	352(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	320(%rdx), %ymm6
        vmovdqu	352(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%rdx)
        vmovdqu	%ymm1, 352(%rdx)
        vmovdqu	384(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%r8), %ymm4
        vmovdqu	416(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r15), %ymm10
        vmovdqu	416(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	384(%rdx), %ymm6
        vmovdqu	416(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%rdx)
        vmovdqu	%ymm1, 416(%rdx)
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%r8), %ymm4
        vmovdqu	480(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r15), %ymm10
        vmovdqu	480(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	448(%rdx), %ymm6
        vmovdqu	480(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%rdx)
        vmovdqu	%ymm1, 480(%rdx)
        addq	$0x200, %rdi
        addq	$0x200, %r8
        subq	$0x01, %r13
        jg	L_pointwise_acc_mont_start_encap_v
L_pointwise_acc_mont_end_encap_v:
        # Base mul mont add
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r15
        vmovdqu	(%rdi), %ymm2
        vmovdqu	32(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%r8), %ymm4
        vmovdqu	32(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r15), %ymm10
        vmovdqu	32(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	(%rdx), %ymm6
        vmovdqu	32(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, (%rdx)
        vmovdqu	%ymm1, 32(%rdx)
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%r8), %ymm4
        vmovdqu	96(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r15), %ymm10
        vmovdqu	96(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	64(%rdx), %ymm6
        vmovdqu	96(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%rdx)
        vmovdqu	%ymm1, 96(%rdx)
        vmovdqu	128(%rdi), %ymm2
        vmovdqu	160(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%r8), %ymm4
        vmovdqu	160(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r15), %ymm10
        vmovdqu	160(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	128(%rdx), %ymm6
        vmovdqu	160(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%rdx)
        vmovdqu	%ymm1, 160(%rdx)
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%r8), %ymm4
        vmovdqu	224(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r15), %ymm10
        vmovdqu	224(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	192(%rdx), %ymm6
        vmovdqu	224(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%rdx)
        vmovdqu	%ymm1, 224(%rdx)
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	288(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%r8), %ymm4
        vmovdqu	288(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r15), %ymm10
        vmovdqu	288(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	256(%rdx), %ymm6
        vmovdqu	288(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%rdx)
        vmovdqu	%ymm1, 288(%rdx)
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%r8), %ymm4
        vmovdqu	352(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r15), %ymm10
        vmovdqu	352(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	320(%rdx), %ymm6
        vmovdqu	352(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%rdx)
        vmovdqu	%ymm1, 352(%rdx)
        vmovdqu	384(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%r8), %ymm4
        vmovdqu	416(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r15), %ymm10
        vmovdqu	416(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	384(%rdx), %ymm6
        vmovdqu	416(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%rdx)
        vmovdqu	%ymm1, 416(%rdx)
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%r8), %ymm4
        vmovdqu	480(%r8), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r15), %ymm10
        vmovdqu	480(%r15), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	448(%rdx), %ymm6
        vmovdqu	480(%rdx), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%rdx)
        vmovdqu	%ymm1, 480(%rdx)
        addq	$0x200, %rdi
        addq	$0x200, %r8
        movq	%r11, %r13
        shl	$9, %r13d
        subq	%r13, %r8
        # invntt
        leaq	L_kyber_avx2_zetas_inv(%rip), %r15
        vmovdqu	(%rdx), %ymm0
        vmovdqu	32(%rdx), %ymm1
        vmovdqu	64(%rdx), %ymm2
        vmovdqu	96(%rdx), %ymm3
        vmovdqu	128(%rdx), %ymm4
        vmovdqu	160(%rdx), %ymm5
        vmovdqu	192(%rdx), %ymm6
        vmovdqu	224(%rdx), %ymm7
        # 2: 1/2
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm9
        vmovdqu	32(%r15), %ymm12
        vpsllq	$32, %ymm9, %ymm0
        vpsrlq	$32, %ymm8, %ymm1
        vpblendd	$0xaa, %ymm0, %ymm8, %ymm0
        vpblendd	$0x55, %ymm1, %ymm9, %ymm1
        vperm2i128	$32, %ymm3, %ymm2, %ymm8
        vmovdqu	64(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm9
        vmovdqu	96(%r15), %ymm13
        vpsllq	$32, %ymm9, %ymm2
        vpsrlq	$32, %ymm8, %ymm3
        vpblendd	$0xaa, %ymm2, %ymm8, %ymm2
        vpblendd	$0x55, %ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 4: 1/2
        vmovdqu	128(%r15), %ymm10
        vmovdqu	160(%r15), %ymm12
        vmovdqu	192(%r15), %ymm11
        vmovdqu	224(%r15), %ymm13
        vpunpckldq	%ymm1, %ymm8, %ymm0
        vpunpckhdq	%ymm1, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm9, %ymm2
        vpunpckhdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm2
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm8
        vpsubw	%ymm2, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 8: 1/2
        vmovdqu	256(%r15), %ymm10
        vmovdqu	288(%r15), %ymm12
        vmovdqu	320(%r15), %ymm11
        vmovdqu	352(%r15), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 16: 1/2
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	384(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	416(%r15), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	448(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	480(%r15), %ymm13
        vpsubw	%ymm1, %ymm0, %ymm8
        vpsubw	%ymm3, %ymm2, %ymm9
        vpaddw	%ymm1, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm2, %ymm2
        vpmullw	%ymm12, %ymm8, %ymm1
        vpmullw	%ymm13, %ymm9, %ymm3
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm1, %ymm8, %ymm1
        vpsubw	%ymm3, %ymm9, %ymm3
        # 32: 1/2
        vmovdqu	512(%r15), %ymm10
        vmovdqu	544(%r15), %ymm12
        vpaddw	%ymm2, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm1, %ymm9
        vpsubw	%ymm2, %ymm0, %ymm2
        vpsubw	%ymm3, %ymm1, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        # 2: 1/2
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	576(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm9
        vmovdqu	608(%r15), %ymm12
        vpsllq	$32, %ymm9, %ymm4
        vpsrlq	$32, %ymm8, %ymm5
        vpblendd	$0xaa, %ymm4, %ymm8, %ymm4
        vpblendd	$0x55, %ymm5, %ymm9, %ymm5
        vperm2i128	$32, %ymm7, %ymm6, %ymm8
        vmovdqu	640(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm9
        vmovdqu	672(%r15), %ymm13
        vpsllq	$32, %ymm9, %ymm6
        vpsrlq	$32, %ymm8, %ymm7
        vpblendd	$0xaa, %ymm6, %ymm8, %ymm6
        vpblendd	$0x55, %ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 4: 1/2
        vmovdqu	704(%r15), %ymm10
        vmovdqu	736(%r15), %ymm12
        vmovdqu	768(%r15), %ymm11
        vmovdqu	800(%r15), %ymm13
        vpunpckldq	%ymm5, %ymm8, %ymm4
        vpunpckhdq	%ymm5, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm9, %ymm6
        vpunpckhdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm6
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm6, %ymm6
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm8
        vpsubw	%ymm6, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 8: 1/2
        vmovdqu	832(%r15), %ymm10
        vmovdqu	864(%r15), %ymm12
        vmovdqu	896(%r15), %ymm11
        vmovdqu	928(%r15), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 16: 1/2
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	960(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	992(%r15), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	1024(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	1056(%r15), %ymm13
        vpsubw	%ymm5, %ymm4, %ymm8
        vpsubw	%ymm7, %ymm6, %ymm9
        vpaddw	%ymm5, %ymm4, %ymm4
        vpaddw	%ymm7, %ymm6, %ymm6
        vpmullw	%ymm12, %ymm8, %ymm5
        vpmullw	%ymm13, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm5, %ymm8, %ymm5
        vpsubw	%ymm7, %ymm9, %ymm7
        # 32: 1/2
        vmovdqu	1088(%r15), %ymm10
        vmovdqu	1120(%r15), %ymm12
        vpaddw	%ymm6, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm5, %ymm9
        vpsubw	%ymm6, %ymm4, %ymm6
        vpsubw	%ymm7, %ymm5, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm5
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm5, %ymm5
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        # 64: 1/2
        vmovdqu	1152(%r15), %ymm10
        vmovdqu	1184(%r15), %ymm12
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vmovdqu	%ymm0, (%rdx)
        vmovdqu	%ymm1, 32(%rdx)
        vmovdqu	%ymm2, 64(%rdx)
        vmovdqu	%ymm3, 96(%rdx)
        vmovdqu	%ymm4, 128(%rdx)
        vmovdqu	%ymm5, 160(%rdx)
        vmovdqu	%ymm6, 192(%rdx)
        vmovdqu	%ymm7, 224(%rdx)
        vmovdqu	256(%rdx), %ymm0
        vmovdqu	288(%rdx), %ymm1
        vmovdqu	320(%rdx), %ymm2
        vmovdqu	352(%rdx), %ymm3
        vmovdqu	384(%rdx), %ymm4
        vmovdqu	416(%rdx), %ymm5
        vmovdqu	448(%rdx), %ymm6
        vmovdqu	480(%rdx), %ymm7
        # 2: 2/2
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	1216(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm9
        vmovdqu	1248(%r15), %ymm12
        vpsllq	$32, %ymm9, %ymm0
        vpsrlq	$32, %ymm8, %ymm1
        vpblendd	$0xaa, %ymm0, %ymm8, %ymm0
        vpblendd	$0x55, %ymm1, %ymm9, %ymm1
        vperm2i128	$32, %ymm3, %ymm2, %ymm8
        vmovdqu	1280(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm9
        vmovdqu	1312(%r15), %ymm13
        vpsllq	$32, %ymm9, %ymm2
        vpsrlq	$32, %ymm8, %ymm3
        vpblendd	$0xaa, %ymm2, %ymm8, %ymm2
        vpblendd	$0x55, %ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 4: 2/2
        vmovdqu	1344(%r15), %ymm10
        vmovdqu	1376(%r15), %ymm12
        vmovdqu	1408(%r15), %ymm11
        vmovdqu	1440(%r15), %ymm13
        vpunpckldq	%ymm1, %ymm8, %ymm0
        vpunpckhdq	%ymm1, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm9, %ymm2
        vpunpckhdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm2
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm8
        vpsubw	%ymm2, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 8: 2/2
        vmovdqu	1472(%r15), %ymm10
        vmovdqu	1504(%r15), %ymm12
        vmovdqu	1536(%r15), %ymm11
        vmovdqu	1568(%r15), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 16: 2/2
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	1600(%r15), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	1632(%r15), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	1664(%r15), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	1696(%r15), %ymm13
        vpsubw	%ymm1, %ymm0, %ymm8
        vpsubw	%ymm3, %ymm2, %ymm9
        vpaddw	%ymm1, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm2, %ymm2
        vpmullw	%ymm12, %ymm8, %ymm1
        vpmullw	%ymm13, %ymm9, %ymm3
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm1, %ymm8, %ymm1
        vpsubw	%ymm3, %ymm9, %ymm3
        # 32: 2/2
        vmovdqu	1728(%r15), %ymm10
        vmovdqu	1760(%r15), %ymm12
        vpaddw	%ymm2, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm1, %ymm9
        vpsubw	%ymm2, %ymm0, %ymm2
        vpsubw	%ymm3, %ymm1, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        # 2: 2/2
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	1792(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm9
        vmovdqu	1824(%r15), %ymm12
        vpsllq	$32, %ymm9, %ymm4
        vpsrlq	$32, %ymm8, %ymm5
        vpblendd	$0xaa, %ymm4, %ymm8, %ymm4
        vpblendd	$0x55, %ymm5, %ymm9, %ymm5
        vperm2i128	$32, %ymm7, %ymm6, %ymm8
        vmovdqu	1856(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm9
        vmovdqu	1888(%r15), %ymm13
        vpsllq	$32, %ymm9, %ymm6
        vpsrlq	$32, %ymm8, %ymm7
        vpblendd	$0xaa, %ymm6, %ymm8, %ymm6
        vpblendd	$0x55, %ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 4: 2/2
        vmovdqu	1920(%r15), %ymm10
        vmovdqu	1952(%r15), %ymm12
        vmovdqu	1984(%r15), %ymm11
        vmovdqu	2016(%r15), %ymm13
        vpunpckldq	%ymm5, %ymm8, %ymm4
        vpunpckhdq	%ymm5, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm9, %ymm6
        vpunpckhdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm6
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm6, %ymm6
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm8
        vpsubw	%ymm6, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 8: 2/2
        vmovdqu	2048(%r15), %ymm10
        vmovdqu	2080(%r15), %ymm12
        vmovdqu	2112(%r15), %ymm11
        vmovdqu	2144(%r15), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 16: 2/2
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	2176(%r15), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	2208(%r15), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	2240(%r15), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	2272(%r15), %ymm13
        vpsubw	%ymm5, %ymm4, %ymm8
        vpsubw	%ymm7, %ymm6, %ymm9
        vpaddw	%ymm5, %ymm4, %ymm4
        vpaddw	%ymm7, %ymm6, %ymm6
        vpmullw	%ymm12, %ymm8, %ymm5
        vpmullw	%ymm13, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm5, %ymm8, %ymm5
        vpsubw	%ymm7, %ymm9, %ymm7
        # 32: 2/2
        vmovdqu	2304(%r15), %ymm10
        vmovdqu	2336(%r15), %ymm12
        vpaddw	%ymm6, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm5, %ymm9
        vpsubw	%ymm6, %ymm4, %ymm6
        vpsubw	%ymm7, %ymm5, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm5
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm5, %ymm5
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        # 64: 2/2
        vmovdqu	2368(%r15), %ymm10
        vmovdqu	2400(%r15), %ymm12
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vmovdqu	%ymm0, 256(%rdx)
        vmovdqu	%ymm1, 288(%rdx)
        vmovdqu	%ymm2, 320(%rdx)
        vmovdqu	%ymm3, 352(%rdx)
        # 128
        vmovdqu	2432(%r15), %ymm10
        vmovdqu	2464(%r15), %ymm12
        vmovdqu	2496(%r15), %ymm11
        vmovdqu	2528(%r15), %ymm13
        vmovdqu	128(%rdx), %ymm0
        vmovdqu	160(%rdx), %ymm1
        vmovdqu	192(%rdx), %ymm2
        vmovdqu	224(%rdx), %ymm3
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm11, %ymm0, %ymm0
        vpmulhw	%ymm11, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm0
        vpsubw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm11, %ymm2, %ymm2
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        vpmullw	%ymm13, %ymm4, %ymm8
        vpmullw	%ymm13, %ymm5, %ymm9
        vpmulhw	%ymm11, %ymm4, %ymm4
        vpmulhw	%ymm11, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm4
        vpsubw	%ymm9, %ymm5, %ymm5
        vpmullw	%ymm13, %ymm6, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm11, %ymm6, %ymm6
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, 128(%rdx)
        vmovdqu	%ymm1, 160(%rdx)
        vmovdqu	%ymm2, 192(%rdx)
        vmovdqu	%ymm3, 224(%rdx)
        vmovdqu	%ymm4, 384(%rdx)
        vmovdqu	%ymm5, 416(%rdx)
        vmovdqu	%ymm6, 448(%rdx)
        vmovdqu	%ymm7, 480(%rdx)
        vmovdqu	(%rdx), %ymm0
        vmovdqu	32(%rdx), %ymm1
        vmovdqu	64(%rdx), %ymm2
        vmovdqu	96(%rdx), %ymm3
        vmovdqu	256(%rdx), %ymm4
        vmovdqu	288(%rdx), %ymm5
        vmovdqu	320(%rdx), %ymm6
        vmovdqu	352(%rdx), %ymm7
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm11, %ymm0, %ymm0
        vpmulhw	%ymm11, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm0
        vpsubw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm11, %ymm2, %ymm2
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        vpmullw	%ymm13, %ymm4, %ymm8
        vpmullw	%ymm13, %ymm5, %ymm9
        vpmulhw	%ymm11, %ymm4, %ymm4
        vpmulhw	%ymm11, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm4
        vpsubw	%ymm9, %ymm5, %ymm5
        vpmullw	%ymm13, %ymm6, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm11, %ymm6, %ymm6
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, (%rdx)
        vmovdqu	%ymm1, 32(%rdx)
        vmovdqu	%ymm2, 64(%rdx)
        vmovdqu	%ymm3, 96(%rdx)
        vmovdqu	%ymm4, 256(%rdx)
        vmovdqu	%ymm5, 288(%rdx)
        vmovdqu	%ymm6, 320(%rdx)
        vmovdqu	%ymm7, 352(%rdx)
        # Add Errors
        vmovdqu	(%rdx), %ymm0
        vmovdqu	32(%rdx), %ymm1
        vmovdqu	64(%rdx), %ymm2
        vmovdqu	96(%rdx), %ymm3
        vmovdqu	(%rax), %ymm4
        vmovdqu	32(%rax), %ymm5
        vmovdqu	64(%rax), %ymm6
        vmovdqu	96(%rax), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vmovdqu	%ymm0, (%rdx)
        vmovdqu	%ymm1, 32(%rdx)
        vmovdqu	%ymm2, 64(%rdx)
        vmovdqu	%ymm3, 96(%rdx)
        vmovdqu	128(%rdx), %ymm0
        vmovdqu	160(%rdx), %ymm1
        vmovdqu	192(%rdx), %ymm2
        vmovdqu	224(%rdx), %ymm3
        vmovdqu	128(%rax), %ymm4
        vmovdqu	160(%rax), %ymm5
        vmovdqu	192(%rax), %ymm6
        vmovdqu	224(%rax), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vmovdqu	%ymm0, 128(%rdx)
        vmovdqu	%ymm1, 160(%rdx)
        vmovdqu	%ymm2, 192(%rdx)
        vmovdqu	%ymm3, 224(%rdx)
        vmovdqu	256(%rdx), %ymm0
        vmovdqu	288(%rdx), %ymm1
        vmovdqu	320(%rdx), %ymm2
        vmovdqu	352(%rdx), %ymm3
        vmovdqu	256(%rax), %ymm4
        vmovdqu	288(%rax), %ymm5
        vmovdqu	320(%rax), %ymm6
        vmovdqu	352(%rax), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vmovdqu	%ymm0, 256(%rdx)
        vmovdqu	%ymm1, 288(%rdx)
        vmovdqu	%ymm2, 320(%rdx)
        vmovdqu	%ymm3, 352(%rdx)
        vmovdqu	384(%rdx), %ymm0
        vmovdqu	416(%rdx), %ymm1
        vmovdqu	448(%rdx), %ymm2
        vmovdqu	480(%rdx), %ymm3
        vmovdqu	384(%rax), %ymm4
        vmovdqu	416(%rax), %ymm5
        vmovdqu	448(%rax), %ymm6
        vmovdqu	480(%rax), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vmovdqu	%ymm0, 384(%rdx)
        vmovdqu	%ymm1, 416(%rdx)
        vmovdqu	%ymm2, 448(%rdx)
        vmovdqu	%ymm3, 480(%rdx)
        # Add Errors
        vmovdqu	(%rdx), %ymm0
        vmovdqu	32(%rdx), %ymm1
        vmovdqu	64(%rdx), %ymm2
        vmovdqu	96(%rdx), %ymm3
        vmovdqu	(%r10), %ymm4
        vmovdqu	32(%r10), %ymm5
        vmovdqu	64(%r10), %ymm6
        vmovdqu	96(%r10), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, (%rdx)
        vmovdqu	%ymm1, 32(%rdx)
        vmovdqu	%ymm2, 64(%rdx)
        vmovdqu	%ymm3, 96(%rdx)
        vmovdqu	128(%rdx), %ymm0
        vmovdqu	160(%rdx), %ymm1
        vmovdqu	192(%rdx), %ymm2
        vmovdqu	224(%rdx), %ymm3
        vmovdqu	128(%r10), %ymm4
        vmovdqu	160(%r10), %ymm5
        vmovdqu	192(%r10), %ymm6
        vmovdqu	224(%r10), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 128(%rdx)
        vmovdqu	%ymm1, 160(%rdx)
        vmovdqu	%ymm2, 192(%rdx)
        vmovdqu	%ymm3, 224(%rdx)
        vmovdqu	256(%rdx), %ymm0
        vmovdqu	288(%rdx), %ymm1
        vmovdqu	320(%rdx), %ymm2
        vmovdqu	352(%rdx), %ymm3
        vmovdqu	256(%r10), %ymm4
        vmovdqu	288(%r10), %ymm5
        vmovdqu	320(%r10), %ymm6
        vmovdqu	352(%r10), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 256(%rdx)
        vmovdqu	%ymm1, 288(%rdx)
        vmovdqu	%ymm2, 320(%rdx)
        vmovdqu	%ymm3, 352(%rdx)
        vmovdqu	384(%rdx), %ymm0
        vmovdqu	416(%rdx), %ymm1
        vmovdqu	448(%rdx), %ymm2
        vmovdqu	480(%rdx), %ymm3
        vmovdqu	384(%r10), %ymm4
        vmovdqu	416(%r10), %ymm5
        vmovdqu	448(%r10), %ymm6
        vmovdqu	480(%r10), %ymm7
        vpaddw	%ymm4, %ymm0, %ymm4
        vpaddw	%ymm5, %ymm1, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpaddw	%ymm6, %ymm2, %ymm6
        vpaddw	%ymm7, %ymm3, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 384(%rdx)
        vmovdqu	%ymm1, 416(%rdx)
        vmovdqu	%ymm2, 448(%rdx)
        vmovdqu	%ymm3, 480(%rdx)
        vzeroupper
        addq	$48, %rsp
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	kyber_encapsulate_avx2,.-kyber_encapsulate_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_decapsulate_avx2
.type	kyber_decapsulate_avx2,@function
.align	16
kyber_decapsulate_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_decapsulate_avx2
.p2align	4
_kyber_decapsulate_avx2:
#endif /* __APPLE__ */
        vmovdqu	kyber_q(%rip), %ymm14
        vmovdqu	kyber_v(%rip), %ymm15
        movq	%r8, %rax
        movq	%rdx, %r9
L_kyber_decapsulate_avx2_trans:
        # ntt
        leaq	L_kyber_avx2_zetas(%rip), %r10
        vmovdqu	(%r10), %ymm10
        vmovdqu	32(%r10), %ymm12
        vmovdqu	128(%r9), %ymm0
        vmovdqu	160(%r9), %ymm1
        vmovdqu	192(%r9), %ymm2
        vmovdqu	224(%r9), %ymm3
        vmovdqu	384(%r9), %ymm4
        vmovdqu	416(%r9), %ymm5
        vmovdqu	448(%r9), %ymm6
        vmovdqu	480(%r9), %ymm7
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vmovdqu	%ymm0, 128(%r9)
        vmovdqu	%ymm1, 160(%r9)
        vmovdqu	%ymm2, 192(%r9)
        vmovdqu	%ymm3, 224(%r9)
        vmovdqu	%ymm4, 384(%r9)
        vmovdqu	%ymm5, 416(%r9)
        vmovdqu	%ymm6, 448(%r9)
        vmovdqu	%ymm7, 480(%r9)
        vmovdqu	(%r9), %ymm0
        vmovdqu	32(%r9), %ymm1
        vmovdqu	64(%r9), %ymm2
        vmovdqu	96(%r9), %ymm3
        vmovdqu	256(%r9), %ymm4
        vmovdqu	288(%r9), %ymm5
        vmovdqu	320(%r9), %ymm6
        vmovdqu	352(%r9), %ymm7
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vmovdqu	%ymm4, 256(%r9)
        vmovdqu	%ymm5, 288(%r9)
        vmovdqu	%ymm6, 320(%r9)
        vmovdqu	%ymm7, 352(%r9)
        vmovdqu	128(%r9), %ymm4
        vmovdqu	160(%r9), %ymm5
        vmovdqu	192(%r9), %ymm6
        vmovdqu	224(%r9), %ymm7
        # 64: 0/3
        vmovdqu	64(%r10), %ymm10
        vmovdqu	96(%r10), %ymm12
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        # 32: 0/3
        vmovdqu	128(%r10), %ymm10
        vmovdqu	160(%r10), %ymm12
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm2
        vpsubw	%ymm9, %ymm1, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        # 32: 0/3
        vmovdqu	192(%r10), %ymm10
        vmovdqu	224(%r10), %ymm12
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm6
        vpsubw	%ymm9, %ymm5, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        # 16: 0/3
        vmovdqu	256(%r10), %ymm10
        vmovdqu	288(%r10), %ymm12
        vmovdqu	320(%r10), %ymm11
        vmovdqu	352(%r10), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 16: 0/3
        vmovdqu	384(%r10), %ymm10
        vmovdqu	416(%r10), %ymm12
        vmovdqu	448(%r10), %ymm11
        vmovdqu	480(%r10), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 8: 0/3
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	512(%r10), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	544(%r10), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	576(%r10), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	608(%r10), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm0
        vpsubw	%ymm2, %ymm3, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm1
        vpsubw	%ymm2, %ymm9, %ymm3
        vpaddw	%ymm0, %ymm8, %ymm8
        vpaddw	%ymm2, %ymm9, %ymm9
        # 4: 0/3
        vmovdqu	640(%r10), %ymm10
        vmovdqu	672(%r10), %ymm12
        vmovdqu	704(%r10), %ymm11
        vmovdqu	736(%r10), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 8: 0/3
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	768(%r10), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	800(%r10), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	832(%r10), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	864(%r10), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm4
        vpsubw	%ymm6, %ymm7, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm5
        vpsubw	%ymm6, %ymm9, %ymm7
        vpaddw	%ymm4, %ymm8, %ymm8
        vpaddw	%ymm6, %ymm9, %ymm9
        # 4: 0/3
        vmovdqu	896(%r10), %ymm10
        vmovdqu	928(%r10), %ymm12
        vmovdqu	960(%r10), %ymm11
        vmovdqu	992(%r10), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 2: 0/3
        vmovdqu	1024(%r10), %ymm10
        vmovdqu	1056(%r10), %ymm12
        vmovdqu	1088(%r10), %ymm11
        vmovdqu	1120(%r10), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 2: 0/3
        vmovdqu	1152(%r10), %ymm10
        vmovdqu	1184(%r10), %ymm12
        vmovdqu	1216(%r10), %ymm11
        vmovdqu	1248(%r10), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vpmulhw	%ymm15, %ymm0, %ymm8
        vpmulhw	%ymm15, %ymm1, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm8
        vpsubw	%ymm9, %ymm1, %ymm9
        vmovdqu	%ymm8, (%r9)
        vmovdqu	%ymm9, 32(%r9)
        vpmulhw	%ymm15, %ymm2, %ymm8
        vpmulhw	%ymm15, %ymm3, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vmovdqu	%ymm8, 64(%r9)
        vmovdqu	%ymm9, 96(%r9)
        vpmulhw	%ymm15, %ymm4, %ymm8
        vpmulhw	%ymm15, %ymm5, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vmovdqu	%ymm8, 128(%r9)
        vmovdqu	%ymm9, 160(%r9)
        vpmulhw	%ymm15, %ymm6, %ymm8
        vpmulhw	%ymm15, %ymm7, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vmovdqu	%ymm8, 192(%r9)
        vmovdqu	%ymm9, 224(%r9)
        vmovdqu	256(%r9), %ymm0
        vmovdqu	288(%r9), %ymm1
        vmovdqu	320(%r9), %ymm2
        vmovdqu	352(%r9), %ymm3
        vmovdqu	384(%r9), %ymm4
        vmovdqu	416(%r9), %ymm5
        vmovdqu	448(%r9), %ymm6
        vmovdqu	480(%r9), %ymm7
        # 64: 1/3
        vmovdqu	1280(%r10), %ymm10
        vmovdqu	1312(%r10), %ymm12
        vpmullw	%ymm12, %ymm4, %ymm8
        vpmullw	%ymm12, %ymm5, %ymm9
        vpmulhw	%ymm10, %ymm4, %ymm4
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm4
        vpsubw	%ymm9, %ymm1, %ymm5
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm6
        vpsubw	%ymm9, %ymm3, %ymm7
        vpaddw	%ymm8, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        # 32: 1/3
        vmovdqu	1344(%r10), %ymm10
        vmovdqu	1376(%r10), %ymm12
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm2
        vpsubw	%ymm9, %ymm1, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        # 32: 1/3
        vmovdqu	1408(%r10), %ymm10
        vmovdqu	1440(%r10), %ymm12
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm6
        vpsubw	%ymm9, %ymm5, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        # 16: 1/3
        vmovdqu	1472(%r10), %ymm10
        vmovdqu	1504(%r10), %ymm12
        vmovdqu	1536(%r10), %ymm11
        vmovdqu	1568(%r10), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 16: 1/3
        vmovdqu	1600(%r10), %ymm10
        vmovdqu	1632(%r10), %ymm12
        vmovdqu	1664(%r10), %ymm11
        vmovdqu	1696(%r10), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 8: 1/3
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	1728(%r10), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	1760(%r10), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	1792(%r10), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	1824(%r10), %ymm13
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm0
        vpsubw	%ymm2, %ymm3, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm1
        vpsubw	%ymm2, %ymm9, %ymm3
        vpaddw	%ymm0, %ymm8, %ymm8
        vpaddw	%ymm2, %ymm9, %ymm9
        # 4: 1/3
        vmovdqu	1856(%r10), %ymm10
        vmovdqu	1888(%r10), %ymm12
        vmovdqu	1920(%r10), %ymm11
        vmovdqu	1952(%r10), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 8: 1/3
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	1984(%r10), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	2016(%r10), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	2048(%r10), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	2080(%r10), %ymm13
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm4
        vpsubw	%ymm6, %ymm7, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm5
        vpsubw	%ymm6, %ymm9, %ymm7
        vpaddw	%ymm4, %ymm8, %ymm8
        vpaddw	%ymm6, %ymm9, %ymm9
        # 4: 1/3
        vmovdqu	2112(%r10), %ymm10
        vmovdqu	2144(%r10), %ymm12
        vmovdqu	2176(%r10), %ymm11
        vmovdqu	2208(%r10), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        # 2: 1/3
        vmovdqu	2240(%r10), %ymm10
        vmovdqu	2272(%r10), %ymm12
        vmovdqu	2304(%r10), %ymm11
        vmovdqu	2336(%r10), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm1, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm1
        vpsubw	%ymm9, %ymm2, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm2, %ymm2
        # 2: 1/3
        vmovdqu	2368(%r10), %ymm10
        vmovdqu	2400(%r10), %ymm12
        vmovdqu	2432(%r10), %ymm11
        vmovdqu	2464(%r10), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm5, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm5
        vpsubw	%ymm9, %ymm6, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vpmulhw	%ymm15, %ymm0, %ymm8
        vpmulhw	%ymm15, %ymm1, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm8
        vpsubw	%ymm9, %ymm1, %ymm9
        vmovdqu	%ymm8, 256(%r9)
        vmovdqu	%ymm9, 288(%r9)
        vpmulhw	%ymm15, %ymm2, %ymm8
        vpmulhw	%ymm15, %ymm3, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm8
        vpsubw	%ymm9, %ymm3, %ymm9
        vmovdqu	%ymm8, 320(%r9)
        vmovdqu	%ymm9, 352(%r9)
        vpmulhw	%ymm15, %ymm4, %ymm8
        vpmulhw	%ymm15, %ymm5, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm8
        vpsubw	%ymm9, %ymm5, %ymm9
        vmovdqu	%ymm8, 384(%r9)
        vmovdqu	%ymm9, 416(%r9)
        vpmulhw	%ymm15, %ymm6, %ymm8
        vpmulhw	%ymm15, %ymm7, %ymm9
        vpsraw	$10, %ymm8, %ymm8
        vpsraw	$10, %ymm9, %ymm9
        vpmullw	%ymm14, %ymm8, %ymm8
        vpmullw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm8
        vpsubw	%ymm9, %ymm7, %ymm9
        vmovdqu	%ymm8, 448(%r9)
        vmovdqu	%ymm9, 480(%r9)
        addq	$0x200, %r9
        subq	$0x01, %rax
        jg	L_kyber_decapsulate_avx2_trans
        vmovdqu	kyber_qinv(%rip), %ymm12
        # Pointwise acc mont
        movq	%r8, %rax
        # Base mul mont
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r10
        vmovdqu	(%rdi), %ymm2
        vmovdqu	32(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%rdx), %ymm4
        vmovdqu	32(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r10), %ymm10
        vmovdqu	32(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%rdx), %ymm4
        vmovdqu	96(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r10), %ymm10
        vmovdqu	96(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	%ymm1, 96(%rsi)
        vmovdqu	128(%rdi), %ymm2
        vmovdqu	160(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%rdx), %ymm4
        vmovdqu	160(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r10), %ymm10
        vmovdqu	160(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%rdx), %ymm4
        vmovdqu	224(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r10), %ymm10
        vmovdqu	224(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%rsi)
        vmovdqu	%ymm1, 224(%rsi)
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	288(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%rdx), %ymm4
        vmovdqu	288(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r10), %ymm10
        vmovdqu	288(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%rdx), %ymm4
        vmovdqu	352(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r10), %ymm10
        vmovdqu	352(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%rsi)
        vmovdqu	%ymm1, 352(%rsi)
        vmovdqu	384(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%rdx), %ymm4
        vmovdqu	416(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r10), %ymm10
        vmovdqu	416(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	%ymm1, 416(%rsi)
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%rdx), %ymm4
        vmovdqu	480(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r10), %ymm10
        vmovdqu	480(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%rsi)
        vmovdqu	%ymm1, 480(%rsi)
        addq	$0x200, %rdi
        addq	$0x200, %rdx
        subq	$2, %rax
        jz	L_pointwise_acc_mont_end_decap
L_pointwise_acc_mont_start_decap:
        # Base mul mont add
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r10
        vmovdqu	(%rdi), %ymm2
        vmovdqu	32(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%rdx), %ymm4
        vmovdqu	32(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r10), %ymm10
        vmovdqu	32(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	(%rsi), %ymm6
        vmovdqu	32(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%rdx), %ymm4
        vmovdqu	96(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r10), %ymm10
        vmovdqu	96(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	64(%rsi), %ymm6
        vmovdqu	96(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	%ymm1, 96(%rsi)
        vmovdqu	128(%rdi), %ymm2
        vmovdqu	160(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%rdx), %ymm4
        vmovdqu	160(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r10), %ymm10
        vmovdqu	160(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	128(%rsi), %ymm6
        vmovdqu	160(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%rdx), %ymm4
        vmovdqu	224(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r10), %ymm10
        vmovdqu	224(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	192(%rsi), %ymm6
        vmovdqu	224(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%rsi)
        vmovdqu	%ymm1, 224(%rsi)
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	288(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%rdx), %ymm4
        vmovdqu	288(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r10), %ymm10
        vmovdqu	288(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	256(%rsi), %ymm6
        vmovdqu	288(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%rdx), %ymm4
        vmovdqu	352(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r10), %ymm10
        vmovdqu	352(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	320(%rsi), %ymm6
        vmovdqu	352(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%rsi)
        vmovdqu	%ymm1, 352(%rsi)
        vmovdqu	384(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%rdx), %ymm4
        vmovdqu	416(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r10), %ymm10
        vmovdqu	416(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	384(%rsi), %ymm6
        vmovdqu	416(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	%ymm1, 416(%rsi)
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%rdx), %ymm4
        vmovdqu	480(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r10), %ymm10
        vmovdqu	480(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	448(%rsi), %ymm6
        vmovdqu	480(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%rsi)
        vmovdqu	%ymm1, 480(%rsi)
        addq	$0x200, %rdi
        addq	$0x200, %rdx
        subq	$0x01, %rax
        jg	L_pointwise_acc_mont_start_decap
L_pointwise_acc_mont_end_decap:
        # Base mul mont add
        leaq	L_kyber_avx2_zetas_basemul(%rip), %r10
        vmovdqu	(%rdi), %ymm2
        vmovdqu	32(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	(%rdx), %ymm4
        vmovdqu	32(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	(%r10), %ymm10
        vmovdqu	32(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	(%rsi), %ymm6
        vmovdqu	32(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	64(%rdx), %ymm4
        vmovdqu	96(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	64(%r10), %ymm10
        vmovdqu	96(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	64(%rsi), %ymm6
        vmovdqu	96(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	%ymm1, 96(%rsi)
        vmovdqu	128(%rdi), %ymm2
        vmovdqu	160(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	128(%rdx), %ymm4
        vmovdqu	160(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	128(%r10), %ymm10
        vmovdqu	160(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	128(%rsi), %ymm6
        vmovdqu	160(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	192(%rdx), %ymm4
        vmovdqu	224(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	192(%r10), %ymm10
        vmovdqu	224(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	192(%rsi), %ymm6
        vmovdqu	224(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 192(%rsi)
        vmovdqu	%ymm1, 224(%rsi)
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	288(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	256(%rdx), %ymm4
        vmovdqu	288(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	256(%r10), %ymm10
        vmovdqu	288(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	256(%rsi), %ymm6
        vmovdqu	288(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	320(%rdx), %ymm4
        vmovdqu	352(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	320(%r10), %ymm10
        vmovdqu	352(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	320(%rsi), %ymm6
        vmovdqu	352(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 320(%rsi)
        vmovdqu	%ymm1, 352(%rsi)
        vmovdqu	384(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	384(%rdx), %ymm4
        vmovdqu	416(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	384(%r10), %ymm10
        vmovdqu	416(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	384(%rsi), %ymm6
        vmovdqu	416(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	%ymm1, 416(%rsi)
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpslld	$16, %ymm3, %ymm6
        vpsrld	$16, %ymm2, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm2, %ymm2
        vpblendw	$0x55, %ymm7, %ymm3, %ymm3
        vmovdqu	448(%rdx), %ymm4
        vmovdqu	480(%rdx), %ymm5
        vpslld	$16, %ymm5, %ymm6
        vpsrld	$16, %ymm4, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm4, %ymm4
        vpblendw	$0x55, %ymm7, %ymm5, %ymm5
        vmovdqu	448(%r10), %ymm10
        vmovdqu	480(%r10), %ymm11
        vpmullw	%ymm5, %ymm3, %ymm0
        vpmulhw	%ymm5, %ymm3, %ymm6
        vpmullw	%ymm4, %ymm2, %ymm1
        vpmulhw	%ymm4, %ymm2, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm0, %ymm8
        vpmullw	%ymm12, %ymm1, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm0
        vpsubw	%ymm9, %ymm7, %ymm1
        vpmullw	%ymm11, %ymm0, %ymm6
        vpmulhw	%ymm10, %ymm0, %ymm7
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm6, %ymm7, %ymm0
        vpaddw	%ymm1, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm2, %ymm1
        vpmulhw	%ymm5, %ymm2, %ymm6
        vpmullw	%ymm4, %ymm3, %ymm2
        vpmulhw	%ymm4, %ymm3, %ymm7
        # Mont Reduce
        vpmullw	%ymm12, %ymm1, %ymm8
        vpmullw	%ymm12, %ymm2, %ymm9
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm1
        vpsubw	%ymm9, %ymm7, %ymm2
        vpaddw	%ymm2, %ymm1, %ymm1
        vmovdqu	448(%rsi), %ymm6
        vmovdqu	480(%rsi), %ymm7
        vpaddw	%ymm6, %ymm0, %ymm0
        vpaddw	%ymm7, %ymm1, %ymm1
        vpslld	$16, %ymm1, %ymm6
        vpsrld	$16, %ymm0, %ymm7
        vpblendw	$0xaa, %ymm6, %ymm0, %ymm0
        vpblendw	$0x55, %ymm7, %ymm1, %ymm1
        vmovdqu	%ymm0, 448(%rsi)
        vmovdqu	%ymm1, 480(%rsi)
        addq	$0x200, %rdi
        addq	$0x200, %rdx
        movq	%r8, %rax
        shl	$9, %eax
        subq	%rax, %rdx
        # invntt
        leaq	L_kyber_avx2_zetas_inv(%rip), %r10
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vmovdqu	64(%rsi), %ymm2
        vmovdqu	96(%rsi), %ymm3
        vmovdqu	128(%rsi), %ymm4
        vmovdqu	160(%rsi), %ymm5
        vmovdqu	192(%rsi), %ymm6
        vmovdqu	224(%rsi), %ymm7
        # 2: 1/2
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	(%r10), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm9
        vmovdqu	32(%r10), %ymm12
        vpsllq	$32, %ymm9, %ymm0
        vpsrlq	$32, %ymm8, %ymm1
        vpblendd	$0xaa, %ymm0, %ymm8, %ymm0
        vpblendd	$0x55, %ymm1, %ymm9, %ymm1
        vperm2i128	$32, %ymm3, %ymm2, %ymm8
        vmovdqu	64(%r10), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm9
        vmovdqu	96(%r10), %ymm13
        vpsllq	$32, %ymm9, %ymm2
        vpsrlq	$32, %ymm8, %ymm3
        vpblendd	$0xaa, %ymm2, %ymm8, %ymm2
        vpblendd	$0x55, %ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 4: 1/2
        vmovdqu	128(%r10), %ymm10
        vmovdqu	160(%r10), %ymm12
        vmovdqu	192(%r10), %ymm11
        vmovdqu	224(%r10), %ymm13
        vpunpckldq	%ymm1, %ymm8, %ymm0
        vpunpckhdq	%ymm1, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm9, %ymm2
        vpunpckhdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm2
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm8
        vpsubw	%ymm2, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 8: 1/2
        vmovdqu	256(%r10), %ymm10
        vmovdqu	288(%r10), %ymm12
        vmovdqu	320(%r10), %ymm11
        vmovdqu	352(%r10), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 16: 1/2
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	384(%r10), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	416(%r10), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	448(%r10), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	480(%r10), %ymm13
        vpsubw	%ymm1, %ymm0, %ymm8
        vpsubw	%ymm3, %ymm2, %ymm9
        vpaddw	%ymm1, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm2, %ymm2
        vpmullw	%ymm12, %ymm8, %ymm1
        vpmullw	%ymm13, %ymm9, %ymm3
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm1, %ymm8, %ymm1
        vpsubw	%ymm3, %ymm9, %ymm3
        # 32: 1/2
        vmovdqu	512(%r10), %ymm10
        vmovdqu	544(%r10), %ymm12
        vpaddw	%ymm2, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm1, %ymm9
        vpsubw	%ymm2, %ymm0, %ymm2
        vpsubw	%ymm3, %ymm1, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        # 2: 1/2
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	576(%r10), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm9
        vmovdqu	608(%r10), %ymm12
        vpsllq	$32, %ymm9, %ymm4
        vpsrlq	$32, %ymm8, %ymm5
        vpblendd	$0xaa, %ymm4, %ymm8, %ymm4
        vpblendd	$0x55, %ymm5, %ymm9, %ymm5
        vperm2i128	$32, %ymm7, %ymm6, %ymm8
        vmovdqu	640(%r10), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm9
        vmovdqu	672(%r10), %ymm13
        vpsllq	$32, %ymm9, %ymm6
        vpsrlq	$32, %ymm8, %ymm7
        vpblendd	$0xaa, %ymm6, %ymm8, %ymm6
        vpblendd	$0x55, %ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 4: 1/2
        vmovdqu	704(%r10), %ymm10
        vmovdqu	736(%r10), %ymm12
        vmovdqu	768(%r10), %ymm11
        vmovdqu	800(%r10), %ymm13
        vpunpckldq	%ymm5, %ymm8, %ymm4
        vpunpckhdq	%ymm5, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm9, %ymm6
        vpunpckhdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm6
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm6, %ymm6
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm8
        vpsubw	%ymm6, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 8: 1/2
        vmovdqu	832(%r10), %ymm10
        vmovdqu	864(%r10), %ymm12
        vmovdqu	896(%r10), %ymm11
        vmovdqu	928(%r10), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 16: 1/2
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	960(%r10), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	992(%r10), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	1024(%r10), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	1056(%r10), %ymm13
        vpsubw	%ymm5, %ymm4, %ymm8
        vpsubw	%ymm7, %ymm6, %ymm9
        vpaddw	%ymm5, %ymm4, %ymm4
        vpaddw	%ymm7, %ymm6, %ymm6
        vpmullw	%ymm12, %ymm8, %ymm5
        vpmullw	%ymm13, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm5, %ymm8, %ymm5
        vpsubw	%ymm7, %ymm9, %ymm7
        # 32: 1/2
        vmovdqu	1088(%r10), %ymm10
        vmovdqu	1120(%r10), %ymm12
        vpaddw	%ymm6, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm5, %ymm9
        vpsubw	%ymm6, %ymm4, %ymm6
        vpsubw	%ymm7, %ymm5, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm5
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm5, %ymm5
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        # 64: 1/2
        vmovdqu	1152(%r10), %ymm10
        vmovdqu	1184(%r10), %ymm12
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	%ymm2, 64(%rsi)
        vmovdqu	%ymm3, 96(%rsi)
        vmovdqu	%ymm4, 128(%rsi)
        vmovdqu	%ymm5, 160(%rsi)
        vmovdqu	%ymm6, 192(%rsi)
        vmovdqu	%ymm7, 224(%rsi)
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	288(%rsi), %ymm1
        vmovdqu	320(%rsi), %ymm2
        vmovdqu	352(%rsi), %ymm3
        vmovdqu	384(%rsi), %ymm4
        vmovdqu	416(%rsi), %ymm5
        vmovdqu	448(%rsi), %ymm6
        vmovdqu	480(%rsi), %ymm7
        # 2: 2/2
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	1216(%r10), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm9
        vmovdqu	1248(%r10), %ymm12
        vpsllq	$32, %ymm9, %ymm0
        vpsrlq	$32, %ymm8, %ymm1
        vpblendd	$0xaa, %ymm0, %ymm8, %ymm0
        vpblendd	$0x55, %ymm1, %ymm9, %ymm1
        vperm2i128	$32, %ymm3, %ymm2, %ymm8
        vmovdqu	1280(%r10), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm9
        vmovdqu	1312(%r10), %ymm13
        vpsllq	$32, %ymm9, %ymm2
        vpsrlq	$32, %ymm8, %ymm3
        vpblendd	$0xaa, %ymm2, %ymm8, %ymm2
        vpblendd	$0x55, %ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 4: 2/2
        vmovdqu	1344(%r10), %ymm10
        vmovdqu	1376(%r10), %ymm12
        vmovdqu	1408(%r10), %ymm11
        vmovdqu	1440(%r10), %ymm13
        vpunpckldq	%ymm1, %ymm8, %ymm0
        vpunpckhdq	%ymm1, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm9, %ymm2
        vpunpckhdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm2
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm8, %ymm8
        vpsubw	%ymm2, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 8: 2/2
        vmovdqu	1472(%r10), %ymm10
        vmovdqu	1504(%r10), %ymm12
        vmovdqu	1536(%r10), %ymm11
        vmovdqu	1568(%r10), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpaddw	%ymm1, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm2, %ymm9
        vpsubw	%ymm1, %ymm0, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpmullw	%ymm12, %ymm1, %ymm0
        vpmullw	%ymm13, %ymm3, %ymm2
        vpmulhw	%ymm10, %ymm1, %ymm1
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm0, %ymm0
        vpmulhw	%ymm14, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm1, %ymm1
        vpsubw	%ymm2, %ymm3, %ymm3
        # 16: 2/2
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	1600(%r10), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	1632(%r10), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	1664(%r10), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	1696(%r10), %ymm13
        vpsubw	%ymm1, %ymm0, %ymm8
        vpsubw	%ymm3, %ymm2, %ymm9
        vpaddw	%ymm1, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm2, %ymm2
        vpmullw	%ymm12, %ymm8, %ymm1
        vpmullw	%ymm13, %ymm9, %ymm3
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm1, %ymm8, %ymm1
        vpsubw	%ymm3, %ymm9, %ymm3
        # 32: 2/2
        vmovdqu	1728(%r10), %ymm10
        vmovdqu	1760(%r10), %ymm12
        vpaddw	%ymm2, %ymm0, %ymm8
        vpaddw	%ymm3, %ymm1, %ymm9
        vpsubw	%ymm2, %ymm0, %ymm2
        vpsubw	%ymm3, %ymm1, %ymm3
        vpmulhw	%ymm15, %ymm8, %ymm0
        vpmulhw	%ymm15, %ymm9, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpmullw	%ymm12, %ymm2, %ymm8
        vpmullw	%ymm12, %ymm3, %ymm9
        vpmulhw	%ymm10, %ymm2, %ymm2
        vpmulhw	%ymm10, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        # 2: 2/2
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	1792(%r10), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm9
        vmovdqu	1824(%r10), %ymm12
        vpsllq	$32, %ymm9, %ymm4
        vpsrlq	$32, %ymm8, %ymm5
        vpblendd	$0xaa, %ymm4, %ymm8, %ymm4
        vpblendd	$0x55, %ymm5, %ymm9, %ymm5
        vperm2i128	$32, %ymm7, %ymm6, %ymm8
        vmovdqu	1856(%r10), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm9
        vmovdqu	1888(%r10), %ymm13
        vpsllq	$32, %ymm9, %ymm6
        vpsrlq	$32, %ymm8, %ymm7
        vpblendd	$0xaa, %ymm6, %ymm8, %ymm6
        vpblendd	$0x55, %ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 4: 2/2
        vmovdqu	1920(%r10), %ymm10
        vmovdqu	1952(%r10), %ymm12
        vmovdqu	1984(%r10), %ymm11
        vmovdqu	2016(%r10), %ymm13
        vpunpckldq	%ymm5, %ymm8, %ymm4
        vpunpckhdq	%ymm5, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm9, %ymm6
        vpunpckhdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm6
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm6, %ymm6
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm8, %ymm8
        vpsubw	%ymm6, %ymm9, %ymm9
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 8: 2/2
        vmovdqu	2048(%r10), %ymm10
        vmovdqu	2080(%r10), %ymm12
        vmovdqu	2112(%r10), %ymm11
        vmovdqu	2144(%r10), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpaddw	%ymm5, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm6, %ymm9
        vpsubw	%ymm5, %ymm4, %ymm5
        vpsubw	%ymm7, %ymm6, %ymm7
        vpmullw	%ymm12, %ymm5, %ymm4
        vpmullw	%ymm13, %ymm7, %ymm6
        vpmulhw	%ymm10, %ymm5, %ymm5
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpsubw	%ymm4, %ymm5, %ymm5
        vpsubw	%ymm6, %ymm7, %ymm7
        # 16: 2/2
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	2176(%r10), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	2208(%r10), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	2240(%r10), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	2272(%r10), %ymm13
        vpsubw	%ymm5, %ymm4, %ymm8
        vpsubw	%ymm7, %ymm6, %ymm9
        vpaddw	%ymm5, %ymm4, %ymm4
        vpaddw	%ymm7, %ymm6, %ymm6
        vpmullw	%ymm12, %ymm8, %ymm5
        vpmullw	%ymm13, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm11, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm5, %ymm8, %ymm5
        vpsubw	%ymm7, %ymm9, %ymm7
        # 32: 2/2
        vmovdqu	2304(%r10), %ymm10
        vmovdqu	2336(%r10), %ymm12
        vpaddw	%ymm6, %ymm4, %ymm8
        vpaddw	%ymm7, %ymm5, %ymm9
        vpsubw	%ymm6, %ymm4, %ymm6
        vpsubw	%ymm7, %ymm5, %ymm7
        vpmulhw	%ymm15, %ymm8, %ymm4
        vpmulhw	%ymm15, %ymm9, %ymm5
        vpsraw	$10, %ymm4, %ymm4
        vpsraw	$10, %ymm5, %ymm5
        vpmullw	%ymm14, %ymm4, %ymm4
        vpmullw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpmullw	%ymm12, %ymm6, %ymm8
        vpmullw	%ymm12, %ymm7, %ymm9
        vpmulhw	%ymm10, %ymm6, %ymm6
        vpmulhw	%ymm10, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        # 64: 2/2
        vmovdqu	2368(%r10), %ymm10
        vmovdqu	2400(%r10), %ymm12
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	%ymm2, 320(%rsi)
        vmovdqu	%ymm3, 352(%rsi)
        # 128
        vmovdqu	2432(%r10), %ymm10
        vmovdqu	2464(%r10), %ymm12
        vmovdqu	2496(%r10), %ymm11
        vmovdqu	2528(%r10), %ymm13
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	160(%rsi), %ymm1
        vmovdqu	192(%rsi), %ymm2
        vmovdqu	224(%rsi), %ymm3
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm11, %ymm0, %ymm0
        vpmulhw	%ymm11, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm0
        vpsubw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm11, %ymm2, %ymm2
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        vpmullw	%ymm13, %ymm4, %ymm8
        vpmullw	%ymm13, %ymm5, %ymm9
        vpmulhw	%ymm11, %ymm4, %ymm4
        vpmulhw	%ymm11, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm4
        vpsubw	%ymm9, %ymm5, %ymm5
        vpmullw	%ymm13, %ymm6, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm11, %ymm6, %ymm6
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	%ymm2, 192(%rsi)
        vmovdqu	%ymm3, 224(%rsi)
        vmovdqu	%ymm4, 384(%rsi)
        vmovdqu	%ymm5, 416(%rsi)
        vmovdqu	%ymm6, 448(%rsi)
        vmovdqu	%ymm7, 480(%rsi)
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vmovdqu	64(%rsi), %ymm2
        vmovdqu	96(%rsi), %ymm3
        vmovdqu	256(%rsi), %ymm4
        vmovdqu	288(%rsi), %ymm5
        vmovdqu	320(%rsi), %ymm6
        vmovdqu	352(%rsi), %ymm7
        vpsubw	%ymm4, %ymm0, %ymm8
        vpsubw	%ymm5, %ymm1, %ymm9
        vpaddw	%ymm4, %ymm0, %ymm0
        vpaddw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm12, %ymm8, %ymm4
        vpmullw	%ymm12, %ymm9, %ymm5
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm4, %ymm4
        vpmulhw	%ymm14, %ymm5, %ymm5
        vpsubw	%ymm4, %ymm8, %ymm4
        vpsubw	%ymm5, %ymm9, %ymm5
        vpsubw	%ymm6, %ymm2, %ymm8
        vpsubw	%ymm7, %ymm3, %ymm9
        vpaddw	%ymm6, %ymm2, %ymm2
        vpaddw	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm12, %ymm8, %ymm6
        vpmullw	%ymm12, %ymm9, %ymm7
        vpmulhw	%ymm10, %ymm8, %ymm8
        vpmulhw	%ymm10, %ymm9, %ymm9
        vpmulhw	%ymm14, %ymm6, %ymm6
        vpmulhw	%ymm14, %ymm7, %ymm7
        vpsubw	%ymm6, %ymm8, %ymm6
        vpsubw	%ymm7, %ymm9, %ymm7
        vpmullw	%ymm13, %ymm0, %ymm8
        vpmullw	%ymm13, %ymm1, %ymm9
        vpmulhw	%ymm11, %ymm0, %ymm0
        vpmulhw	%ymm11, %ymm1, %ymm1
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm0, %ymm0
        vpsubw	%ymm9, %ymm1, %ymm1
        vpmullw	%ymm13, %ymm2, %ymm8
        vpmullw	%ymm13, %ymm3, %ymm9
        vpmulhw	%ymm11, %ymm2, %ymm2
        vpmulhw	%ymm11, %ymm3, %ymm3
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm9, %ymm3, %ymm3
        vpmullw	%ymm13, %ymm4, %ymm8
        vpmullw	%ymm13, %ymm5, %ymm9
        vpmulhw	%ymm11, %ymm4, %ymm4
        vpmulhw	%ymm11, %ymm5, %ymm5
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm4, %ymm4
        vpsubw	%ymm9, %ymm5, %ymm5
        vpmullw	%ymm13, %ymm6, %ymm8
        vpmullw	%ymm13, %ymm7, %ymm9
        vpmulhw	%ymm11, %ymm6, %ymm6
        vpmulhw	%ymm11, %ymm7, %ymm7
        vpmulhw	%ymm14, %ymm8, %ymm8
        vpmulhw	%ymm14, %ymm9, %ymm9
        vpsubw	%ymm8, %ymm6, %ymm6
        vpsubw	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	%ymm2, 64(%rsi)
        vmovdqu	%ymm3, 96(%rsi)
        vmovdqu	%ymm4, 256(%rsi)
        vmovdqu	%ymm5, 288(%rsi)
        vmovdqu	%ymm6, 320(%rsi)
        vmovdqu	%ymm7, 352(%rsi)
        # Sub Errors
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vmovdqu	64(%rsi), %ymm2
        vmovdqu	96(%rsi), %ymm3
        vmovdqu	(%rcx), %ymm4
        vmovdqu	32(%rcx), %ymm5
        vmovdqu	64(%rcx), %ymm6
        vmovdqu	96(%rcx), %ymm7
        vpsubw	%ymm0, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm5, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpsubw	%ymm2, %ymm6, %ymm6
        vpsubw	%ymm3, %ymm7, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	%ymm2, 64(%rsi)
        vmovdqu	%ymm3, 96(%rsi)
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	160(%rsi), %ymm1
        vmovdqu	192(%rsi), %ymm2
        vmovdqu	224(%rsi), %ymm3
        vmovdqu	128(%rcx), %ymm4
        vmovdqu	160(%rcx), %ymm5
        vmovdqu	192(%rcx), %ymm6
        vmovdqu	224(%rcx), %ymm7
        vpsubw	%ymm0, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm5, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpsubw	%ymm2, %ymm6, %ymm6
        vpsubw	%ymm3, %ymm7, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	%ymm1, 160(%rsi)
        vmovdqu	%ymm2, 192(%rsi)
        vmovdqu	%ymm3, 224(%rsi)
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	288(%rsi), %ymm1
        vmovdqu	320(%rsi), %ymm2
        vmovdqu	352(%rsi), %ymm3
        vmovdqu	256(%rcx), %ymm4
        vmovdqu	288(%rcx), %ymm5
        vmovdqu	320(%rcx), %ymm6
        vmovdqu	352(%rcx), %ymm7
        vpsubw	%ymm0, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm5, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpsubw	%ymm2, %ymm6, %ymm6
        vpsubw	%ymm3, %ymm7, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	%ymm2, 320(%rsi)
        vmovdqu	%ymm3, 352(%rsi)
        vmovdqu	384(%rsi), %ymm0
        vmovdqu	416(%rsi), %ymm1
        vmovdqu	448(%rsi), %ymm2
        vmovdqu	480(%rsi), %ymm3
        vmovdqu	384(%rcx), %ymm4
        vmovdqu	416(%rcx), %ymm5
        vmovdqu	448(%rcx), %ymm6
        vmovdqu	480(%rcx), %ymm7
        vpsubw	%ymm0, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm5, %ymm5
        vpmulhw	%ymm15, %ymm4, %ymm0
        vpmulhw	%ymm15, %ymm5, %ymm1
        vpsraw	$10, %ymm0, %ymm0
        vpsraw	$10, %ymm1, %ymm1
        vpmullw	%ymm14, %ymm0, %ymm0
        vpmullw	%ymm14, %ymm1, %ymm1
        vpsubw	%ymm0, %ymm4, %ymm0
        vpsubw	%ymm1, %ymm5, %ymm1
        vpsubw	%ymm2, %ymm6, %ymm6
        vpsubw	%ymm3, %ymm7, %ymm7
        vpmulhw	%ymm15, %ymm6, %ymm2
        vpmulhw	%ymm15, %ymm7, %ymm3
        vpsraw	$10, %ymm2, %ymm2
        vpsraw	$10, %ymm3, %ymm3
        vpmullw	%ymm14, %ymm2, %ymm2
        vpmullw	%ymm14, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm6, %ymm2
        vpsubw	%ymm3, %ymm7, %ymm3
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	%ymm1, 416(%rsi)
        vmovdqu	%ymm2, 448(%rsi)
        vmovdqu	%ymm3, 480(%rsi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_decapsulate_avx2,.-kyber_decapsulate_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_csubq_avx2
.type	kyber_csubq_avx2,@function
.align	16
kyber_csubq_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_csubq_avx2
.p2align	4
_kyber_csubq_avx2:
#endif /* __APPLE__ */
        vmovdqu	kyber_q(%rip), %ymm12
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vpsubw	%ymm12, %ymm0, %ymm8
        vpsubw	%ymm12, %ymm1, %ymm9
        vpsubw	%ymm12, %ymm2, %ymm10
        vpsubw	%ymm12, %ymm3, %ymm11
        vpsraw	$15, %ymm8, %ymm0
        vpsraw	$15, %ymm9, %ymm1
        vpsraw	$15, %ymm10, %ymm2
        vpsraw	$15, %ymm11, %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpaddw	%ymm10, %ymm2, %ymm2
        vpaddw	%ymm11, %ymm3, %ymm3
        vpsubw	%ymm12, %ymm4, %ymm8
        vpsubw	%ymm12, %ymm5, %ymm9
        vpsubw	%ymm12, %ymm6, %ymm10
        vpsubw	%ymm12, %ymm7, %ymm11
        vpsraw	$15, %ymm8, %ymm4
        vpsraw	$15, %ymm9, %ymm5
        vpsraw	$15, %ymm10, %ymm6
        vpsraw	$15, %ymm11, %ymm7
        vpand	%ymm12, %ymm4, %ymm4
        vpand	%ymm12, %ymm5, %ymm5
        vpand	%ymm12, %ymm6, %ymm6
        vpand	%ymm12, %ymm7, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        vpaddw	%ymm10, %ymm6, %ymm6
        vpaddw	%ymm11, %ymm7, %ymm7
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        vmovdqu	%ymm5, 160(%rdi)
        vmovdqu	%ymm6, 192(%rdi)
        vmovdqu	%ymm7, 224(%rdi)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        vpsubw	%ymm12, %ymm0, %ymm8
        vpsubw	%ymm12, %ymm1, %ymm9
        vpsubw	%ymm12, %ymm2, %ymm10
        vpsubw	%ymm12, %ymm3, %ymm11
        vpsraw	$15, %ymm8, %ymm0
        vpsraw	$15, %ymm9, %ymm1
        vpsraw	$15, %ymm10, %ymm2
        vpsraw	$15, %ymm11, %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpaddw	%ymm10, %ymm2, %ymm2
        vpaddw	%ymm11, %ymm3, %ymm3
        vpsubw	%ymm12, %ymm4, %ymm8
        vpsubw	%ymm12, %ymm5, %ymm9
        vpsubw	%ymm12, %ymm6, %ymm10
        vpsubw	%ymm12, %ymm7, %ymm11
        vpsraw	$15, %ymm8, %ymm4
        vpsraw	$15, %ymm9, %ymm5
        vpsraw	$15, %ymm10, %ymm6
        vpsraw	$15, %ymm11, %ymm7
        vpand	%ymm12, %ymm4, %ymm4
        vpand	%ymm12, %ymm5, %ymm5
        vpand	%ymm12, %ymm6, %ymm6
        vpand	%ymm12, %ymm7, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        vpaddw	%ymm10, %ymm6, %ymm6
        vpaddw	%ymm11, %ymm7, %ymm7
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vmovdqu	%ymm4, 384(%rdi)
        vmovdqu	%ymm5, 416(%rdi)
        vmovdqu	%ymm6, 448(%rdi)
        vmovdqu	%ymm7, 480(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_csubq_avx2,.-kyber_csubq_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_rej_idx:
.quad	0xffffffffffffffff,0xffffffffffffff00
.quad	0xffffffffffffff02,0xffffffffffff0200
.quad	0xffffffffffffff04,0xffffffffffff0400
.quad	0xffffffffffff0402,0xffffffffff040200
.quad	0xffffffffffffff06,0xffffffffffff0600
.quad	0xffffffffffff0602,0xffffffffff060200
.quad	0xffffffffffff0604,0xffffffffff060400
.quad	0xffffffffff060402,0xffffffff06040200
.quad	0xffffffffffffff08,0xffffffffffff0800
.quad	0xffffffffffff0802,0xffffffffff080200
.quad	0xffffffffffff0804,0xffffffffff080400
.quad	0xffffffffff080402,0xffffffff08040200
.quad	0xffffffffffff0806,0xffffffffff080600
.quad	0xffffffffff080602,0xffffffff08060200
.quad	0xffffffffff080604,0xffffffff08060400
.quad	0xffffffff08060402,0xffffff0806040200
.quad	0xffffffffffffff0a,0xffffffffffff0a00
.quad	0xffffffffffff0a02,0xffffffffff0a0200
.quad	0xffffffffffff0a04,0xffffffffff0a0400
.quad	0xffffffffff0a0402,0xffffffff0a040200
.quad	0xffffffffffff0a06,0xffffffffff0a0600
.quad	0xffffffffff0a0602,0xffffffff0a060200
.quad	0xffffffffff0a0604,0xffffffff0a060400
.quad	0xffffffff0a060402,0xffffff0a06040200
.quad	0xffffffffffff0a08,0xffffffffff0a0800
.quad	0xffffffffff0a0802,0xffffffff0a080200
.quad	0xffffffffff0a0804,0xffffffff0a080400
.quad	0xffffffff0a080402,0xffffff0a08040200
.quad	0xffffffffff0a0806,0xffffffff0a080600
.quad	0xffffffff0a080602,0xffffff0a08060200
.quad	0xffffffff0a080604,0xffffff0a08060400
.quad	0xffffff0a08060402,0xffff0a0806040200
.quad	0xffffffffffffff0c,0xffffffffffff0c00
.quad	0xffffffffffff0c02,0xffffffffff0c0200
.quad	0xffffffffffff0c04,0xffffffffff0c0400
.quad	0xffffffffff0c0402,0xffffffff0c040200
.quad	0xffffffffffff0c06,0xffffffffff0c0600
.quad	0xffffffffff0c0602,0xffffffff0c060200
.quad	0xffffffffff0c0604,0xffffffff0c060400
.quad	0xffffffff0c060402,0xffffff0c06040200
.quad	0xffffffffffff0c08,0xffffffffff0c0800
.quad	0xffffffffff0c0802,0xffffffff0c080200
.quad	0xffffffffff0c0804,0xffffffff0c080400
.quad	0xffffffff0c080402,0xffffff0c08040200
.quad	0xffffffffff0c0806,0xffffffff0c080600
.quad	0xffffffff0c080602,0xffffff0c08060200
.quad	0xffffffff0c080604,0xffffff0c08060400
.quad	0xffffff0c08060402,0xffff0c0806040200
.quad	0xffffffffffff0c0a,0xffffffffff0c0a00
.quad	0xffffffffff0c0a02,0xffffffff0c0a0200
.quad	0xffffffffff0c0a04,0xffffffff0c0a0400
.quad	0xffffffff0c0a0402,0xffffff0c0a040200
.quad	0xffffffffff0c0a06,0xffffffff0c0a0600
.quad	0xffffffff0c0a0602,0xffffff0c0a060200
.quad	0xffffffff0c0a0604,0xffffff0c0a060400
.quad	0xffffff0c0a060402,0xffff0c0a06040200
.quad	0xffffffffff0c0a08,0xffffffff0c0a0800
.quad	0xffffffff0c0a0802,0xffffff0c0a080200
.quad	0xffffffff0c0a0804,0xffffff0c0a080400
.quad	0xffffff0c0a080402,0xffff0c0a08040200
.quad	0xffffffff0c0a0806,0xffffff0c0a080600
.quad	0xffffff0c0a080602,0xffff0c0a08060200
.quad	0xffffff0c0a080604,0xffff0c0a08060400
.quad	0xffff0c0a08060402,0xff0c0a0806040200
.quad	0xffffffffffffff0e,0xffffffffffff0e00
.quad	0xffffffffffff0e02,0xffffffffff0e0200
.quad	0xffffffffffff0e04,0xffffffffff0e0400
.quad	0xffffffffff0e0402,0xffffffff0e040200
.quad	0xffffffffffff0e06,0xffffffffff0e0600
.quad	0xffffffffff0e0602,0xffffffff0e060200
.quad	0xffffffffff0e0604,0xffffffff0e060400
.quad	0xffffffff0e060402,0xffffff0e06040200
.quad	0xffffffffffff0e08,0xffffffffff0e0800
.quad	0xffffffffff0e0802,0xffffffff0e080200
.quad	0xffffffffff0e0804,0xffffffff0e080400
.quad	0xffffffff0e080402,0xffffff0e08040200
.quad	0xffffffffff0e0806,0xffffffff0e080600
.quad	0xffffffff0e080602,0xffffff0e08060200
.quad	0xffffffff0e080604,0xffffff0e08060400
.quad	0xffffff0e08060402,0xffff0e0806040200
.quad	0xffffffffffff0e0a,0xffffffffff0e0a00
.quad	0xffffffffff0e0a02,0xffffffff0e0a0200
.quad	0xffffffffff0e0a04,0xffffffff0e0a0400
.quad	0xffffffff0e0a0402,0xffffff0e0a040200
.quad	0xffffffffff0e0a06,0xffffffff0e0a0600
.quad	0xffffffff0e0a0602,0xffffff0e0a060200
.quad	0xffffffff0e0a0604,0xffffff0e0a060400
.quad	0xffffff0e0a060402,0xffff0e0a06040200
.quad	0xffffffffff0e0a08,0xffffffff0e0a0800
.quad	0xffffffff0e0a0802,0xffffff0e0a080200
.quad	0xffffffff0e0a0804,0xffffff0e0a080400
.quad	0xffffff0e0a080402,0xffff0e0a08040200
.quad	0xffffffff0e0a0806,0xffffff0e0a080600
.quad	0xffffff0e0a080602,0xffff0e0a08060200
.quad	0xffffff0e0a080604,0xffff0e0a08060400
.quad	0xffff0e0a08060402,0xff0e0a0806040200
.quad	0xffffffffffff0e0c,0xffffffffff0e0c00
.quad	0xffffffffff0e0c02,0xffffffff0e0c0200
.quad	0xffffffffff0e0c04,0xffffffff0e0c0400
.quad	0xffffffff0e0c0402,0xffffff0e0c040200
.quad	0xffffffffff0e0c06,0xffffffff0e0c0600
.quad	0xffffffff0e0c0602,0xffffff0e0c060200
.quad	0xffffffff0e0c0604,0xffffff0e0c060400
.quad	0xffffff0e0c060402,0xffff0e0c06040200
.quad	0xffffffffff0e0c08,0xffffffff0e0c0800
.quad	0xffffffff0e0c0802,0xffffff0e0c080200
.quad	0xffffffff0e0c0804,0xffffff0e0c080400
.quad	0xffffff0e0c080402,0xffff0e0c08040200
.quad	0xffffffff0e0c0806,0xffffff0e0c080600
.quad	0xffffff0e0c080602,0xffff0e0c08060200
.quad	0xffffff0e0c080604,0xffff0e0c08060400
.quad	0xffff0e0c08060402,0xff0e0c0806040200
.quad	0xffffffffff0e0c0a,0xffffffff0e0c0a00
.quad	0xffffffff0e0c0a02,0xffffff0e0c0a0200
.quad	0xffffffff0e0c0a04,0xffffff0e0c0a0400
.quad	0xffffff0e0c0a0402,0xffff0e0c0a040200
.quad	0xffffffff0e0c0a06,0xffffff0e0c0a0600
.quad	0xffffff0e0c0a0602,0xffff0e0c0a060200
.quad	0xffffff0e0c0a0604,0xffff0e0c0a060400
.quad	0xffff0e0c0a060402,0xff0e0c0a06040200
.quad	0xffffffff0e0c0a08,0xffffff0e0c0a0800
.quad	0xffffff0e0c0a0802,0xffff0e0c0a080200
.quad	0xffffff0e0c0a0804,0xffff0e0c0a080400
.quad	0xffff0e0c0a080402,0xff0e0c0a08040200
.quad	0xffffff0e0c0a0806,0xffff0e0c0a080600
.quad	0xffff0e0c0a080602,0xff0e0c0a08060200
.quad	0xffff0e0c0a080604,0xff0e0c0a08060400
.quad	0xff0e0c0a08060402,0xe0c0a0806040200
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_rej_q:
.quad	0xd010d010d010d01, 0xd010d010d010d01
.quad	0xd010d010d010d01, 0xd010d010d010d01
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_rej_ones:
.quad	0x101010101010101, 0x101010101010101
.quad	0x101010101010101, 0x101010101010101
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_rej_mask:
.quad	0xfff0fff0fff0fff, 0xfff0fff0fff0fff
.quad	0xfff0fff0fff0fff, 0xfff0fff0fff0fff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_rej_shuffle:
.quad	0x504040302010100, 0xb0a0a0908070706
.quad	0x908080706050504, 0xf0e0e0d0c0b0b0a
#ifndef __APPLE__
.text
.globl	kyber_rej_uniform_n_avx2
.type	kyber_rej_uniform_n_avx2,@function
.align	16
kyber_rej_uniform_n_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_rej_uniform_n_avx2
.p2align	4
_kyber_rej_uniform_n_avx2:
#endif /* __APPLE__ */
        pushq	%rbx
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        pushq	%rbp
        movq	%rcx, %r8
        movl	%esi, %eax
        vmovdqu	L_kyber_rej_q(%rip), %ymm6
        vmovdqu	L_kyber_rej_ones(%rip), %ymm7
        vmovdqu	L_kyber_rej_mask(%rip), %ymm8
        vmovdqu	L_kyber_rej_shuffle(%rip), %ymm9
        leaq	L_kyber_rej_idx(%rip), %r9
        movq	$0x1111111111111111, %r14
        movq	$0xe0c0a0806040200, %rbp
        movq	$0x101010101010101, %r13
        vpermq	$0x94, (%rdx), %ymm0
        vpermq	$0x94, 24(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        vpermq	$0x94, 48(%rdx), %ymm0
        vpermq	$0x94, 72(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        vpermq	$0x94, 96(%rdx), %ymm0
        vpermq	$0x94, 120(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        vpermq	$0x94, 144(%rdx), %ymm0
        vpermq	$0x94, 168(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        vpermq	$0x94, 192(%rdx), %ymm0
        vpermq	$0x94, 216(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        vpermq	$0x94, 240(%rdx), %ymm0
        vpermq	$0x94, 264(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        vpermq	$0x94, 288(%rdx), %ymm0
        vpermq	$0x94, 312(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        addq	$0x150, %rdx
        subl	$0x150, %r8d
L_kyber_rej_uniform_n_avx2_start_256:
        vpermq	$0x94, (%rdx), %ymm0
        vpermq	$0x94, 24(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        addq	$48, %rdx
        subl	$48, %r8d
        cmpl	$48, %r8d
        jl	L_kyber_rej_uniform_n_avx2_done_256
        cmpl	$32, %esi
        jge	L_kyber_rej_uniform_n_avx2_start_256
L_kyber_rej_uniform_n_avx2_done_256:
        cmpl	$8, %esi
        jl	L_kyber_rej_uniform_n_avx2_done_128
        cmpl	$12, %r8d
        jl	L_kyber_rej_uniform_n_avx2_done_128
L_kyber_rej_uniform_n_avx2_start_128:
        vmovdqu	(%rdx), %xmm0
        vpshufb	%xmm9, %xmm0, %xmm0
        vpsrlw	$4, %xmm0, %xmm2
        vpblendw	$0xaa, %xmm2, %xmm0, %xmm0
        vpand	%xmm8, %xmm0, %xmm0
        vpcmpgtw	%xmm0, %xmm6, %xmm2
        vpmovmskb	%xmm2, %rbx
        movq	$0x5555, %r10
        pextl	%r10d, %ebx, %ebx
        movq	(%r9,%rbx,8), %xmm3
        vpaddb	%xmm7, %xmm3, %xmm4
        vpunpcklbw	%xmm4, %xmm3, %xmm3
        vpshufb	%xmm3, %xmm0, %xmm0
        vmovdqu	%xmm0, (%rdi)
        popcntl	%ebx, %ecx
        leaq	(%rdi,%rcx,2), %rdi
        subl	%ecx, %esi
        addq	$12, %rdx
        subl	$12, %r8d
        cmpl	$12, %r8d
        jl	L_kyber_rej_uniform_n_avx2_done_128
        cmpl	$8, %esi
        jge	L_kyber_rej_uniform_n_avx2_start_128
L_kyber_rej_uniform_n_avx2_done_128:
        cmpl	$0x00, %r8d
        je	L_kyber_rej_uniform_n_avx2_done_64
        cmpl	$0x00, %esi
        je	L_kyber_rej_uniform_n_avx2_done_64
        movq	$0xfff0fff0fff0fff, %r15
        movq	$0x2000200020002000, %r10
        movq	$0xd010d010d010d01, %r11
        movq	$0x1000100010001000, %r12
L_kyber_rej_uniform_n_avx2_start_64:
        movq	(%rdx), %rcx
        pdepq	%r15, %rcx, %rcx
        cmpw	$0xd01, %cx
        jge	L_kyber_rej_uniform_0_avx2_rej_large_0
        movw	%cx, (%rdi)
        addq	$2, %rdi
        subl	$0x01, %esi
        je	L_kyber_rej_uniform_n_avx2_done_64
L_kyber_rej_uniform_0_avx2_rej_large_0:
        shrq	$16, %rcx
        cmpw	$0xd01, %cx
        jge	L_kyber_rej_uniform_0_avx2_rej_large_1
        movw	%cx, (%rdi)
        addq	$2, %rdi
        subl	$0x01, %esi
        je	L_kyber_rej_uniform_n_avx2_done_64
L_kyber_rej_uniform_0_avx2_rej_large_1:
        shrq	$16, %rcx
        cmpw	$0xd01, %cx
        jge	L_kyber_rej_uniform_0_avx2_rej_large_2
        movw	%cx, (%rdi)
        addq	$2, %rdi
        subl	$0x01, %esi
        je	L_kyber_rej_uniform_n_avx2_done_64
L_kyber_rej_uniform_0_avx2_rej_large_2:
        shrq	$16, %rcx
        cmpw	$0xd01, %cx
        jge	L_kyber_rej_uniform_0_avx2_rej_large_3
        movw	%cx, (%rdi)
        addq	$2, %rdi
        subl	$0x01, %esi
        je	L_kyber_rej_uniform_n_avx2_done_64
L_kyber_rej_uniform_0_avx2_rej_large_3:
        addq	$6, %rdx
        subl	$6, %r8d
        jle	L_kyber_rej_uniform_n_avx2_done_64
        cmpl	$0x00, %esi
        jg	L_kyber_rej_uniform_n_avx2_start_64
L_kyber_rej_uniform_n_avx2_done_64:
        vzeroupper
        subl	%esi, %eax
        popq	%rbp
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        popq	%rbx
        repz retq
#ifndef __APPLE__
.size	kyber_rej_uniform_n_avx2,.-kyber_rej_uniform_n_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_rej_uniform_avx2
.type	kyber_rej_uniform_avx2,@function
.align	16
kyber_rej_uniform_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_rej_uniform_avx2
.p2align	4
_kyber_rej_uniform_avx2:
#endif /* __APPLE__ */
        pushq	%rbx
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        pushq	%rbp
        movq	%rcx, %r8
        movl	%esi, %eax
        cmpl	$0x00, %esi
        je	L_kyber_rej_uniform_avx2_done_64
        cmpl	$8, %esi
        jl	L_kyber_rej_uniform_avx2_done_128
        vmovdqu	L_kyber_rej_q(%rip), %ymm6
        vmovdqu	L_kyber_rej_ones(%rip), %ymm7
        vmovdqu	L_kyber_rej_mask(%rip), %ymm8
        vmovdqu	L_kyber_rej_shuffle(%rip), %ymm9
        leaq	L_kyber_rej_idx(%rip), %r9
        movq	$0x1111111111111111, %r14
        movq	$0xe0c0a0806040200, %rbp
        movq	$0x101010101010101, %r13
        cmpl	$32, %esi
        jl	L_kyber_rej_uniform_avx2_done_256
        vpermq	$0x94, (%rdx), %ymm0
        vpermq	$0x94, 24(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        addq	$48, %rdx
        subl	$48, %r8d
        cmpl	$32, %esi
        jl	L_kyber_rej_uniform_avx2_done_256
        vpermq	$0x94, (%rdx), %ymm0
        vpermq	$0x94, 24(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        addq	$48, %rdx
        subl	$48, %r8d
        cmpl	$32, %esi
        jl	L_kyber_rej_uniform_avx2_done_256
L_kyber_rej_uniform_avx2_start_256:
        vpermq	$0x94, (%rdx), %ymm0
        vpermq	$0x94, 24(%rdx), %ymm1
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpblendw	$0xaa, %ymm2, %ymm0, %ymm0
        vpblendw	$0xaa, %ymm3, %ymm1, %ymm1
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        movq	%rbx, %r11
        movq	%rbx, %r12
        shrq	$16, %r11
        shrq	$24, %r12
        andq	$0xff, %r11
        andq	$0xff, %r12
        movq	(%r9,%r10,8), %xmm2
        movq	(%r9,%rcx,8), %xmm3
        movq	(%r9,%r11,8), %xmm4
        movq	(%r9,%r12,8), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpaddb	%ymm7, %ymm2, %ymm4
        vpaddb	%ymm7, %ymm3, %ymm5
        vpunpcklbw	%ymm4, %ymm2, %ymm2
        vpunpcklbw	%ymm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        movq	%rbx, %r10
        movq	%rbx, %r11
        movq	%rbx, %r12
        andq	$0xff, %rbx
        shrq	$16, %r10
        shrq	$8, %r11
        shrq	$24, %r12
        andq	$0xff, %r10
        andq	$0xff, %r11
        popcntl	%ebx, %ebx
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vmovdqu	%xmm0, (%rdi)
        vextracti128	$0x01, %ymm0, %xmm0
        leaq	(%rdi,%rbx,2), %rdi
        subl	%ebx, %esi
        vmovdqu	%xmm0, (%rdi)
        leaq	(%rdi,%r10,2), %rdi
        subl	%r10d, %esi
        vmovdqu	%xmm1, (%rdi)
        vextracti128	$0x01, %ymm1, %xmm1
        leaq	(%rdi,%r11,2), %rdi
        subl	%r11d, %esi
        vmovdqu	%xmm1, (%rdi)
        leaq	(%rdi,%r12,2), %rdi
        subl	%r12d, %esi
        addq	$48, %rdx
        subl	$48, %r8d
        cmpl	$48, %r8d
        jl	L_kyber_rej_uniform_avx2_done_256
        cmpl	$32, %esi
        jge	L_kyber_rej_uniform_avx2_start_256
L_kyber_rej_uniform_avx2_done_256:
        cmpl	$8, %esi
        jl	L_kyber_rej_uniform_avx2_done_128
        cmpl	$12, %r8d
        jl	L_kyber_rej_uniform_avx2_done_128
L_kyber_rej_uniform_avx2_start_128:
        vmovdqu	(%rdx), %xmm0
        vpshufb	%xmm9, %xmm0, %xmm0
        vpsrlw	$4, %xmm0, %xmm2
        vpblendw	$0xaa, %xmm2, %xmm0, %xmm0
        vpand	%xmm8, %xmm0, %xmm0
        vpcmpgtw	%xmm0, %xmm6, %xmm2
        vpmovmskb	%xmm2, %rbx
        movq	$0x5555, %r10
        pextl	%r10d, %ebx, %ebx
        movq	(%r9,%rbx,8), %xmm3
        vpaddb	%xmm7, %xmm3, %xmm4
        vpunpcklbw	%xmm4, %xmm3, %xmm3
        vpshufb	%xmm3, %xmm0, %xmm0
        vmovdqu	%xmm0, (%rdi)
        popcntl	%ebx, %ecx
        leaq	(%rdi,%rcx,2), %rdi
        subl	%ecx, %esi
        addq	$12, %rdx
        subl	$12, %r8d
        cmpl	$12, %r8d
        jl	L_kyber_rej_uniform_avx2_done_128
        cmpl	$8, %esi
        jge	L_kyber_rej_uniform_avx2_start_128
L_kyber_rej_uniform_avx2_done_128:
        cmpl	$0x00, %r8d
        je	L_kyber_rej_uniform_avx2_done_64
        cmpl	$0x00, %esi
        je	L_kyber_rej_uniform_avx2_done_64
        movq	$0xfff0fff0fff0fff, %r15
        movq	$0x2000200020002000, %r10
        movq	$0xd010d010d010d01, %r11
        movq	$0x1000100010001000, %r12
L_kyber_rej_uniform_avx2_start_64:
        movq	(%rdx), %rcx
        pdepq	%r15, %rcx, %rcx
        cmpw	$0xd01, %cx
        jge	L_kyber_rej_uniform_avx2_rej_large_0
        movw	%cx, (%rdi)
        addq	$2, %rdi
        subl	$0x01, %esi
        je	L_kyber_rej_uniform_avx2_done_64
L_kyber_rej_uniform_avx2_rej_large_0:
        shrq	$16, %rcx
        cmpw	$0xd01, %cx
        jge	L_kyber_rej_uniform_avx2_rej_large_1
        movw	%cx, (%rdi)
        addq	$2, %rdi
        subl	$0x01, %esi
        je	L_kyber_rej_uniform_avx2_done_64
L_kyber_rej_uniform_avx2_rej_large_1:
        shrq	$16, %rcx
        cmpw	$0xd01, %cx
        jge	L_kyber_rej_uniform_avx2_rej_large_2
        movw	%cx, (%rdi)
        addq	$2, %rdi
        subl	$0x01, %esi
        je	L_kyber_rej_uniform_avx2_done_64
L_kyber_rej_uniform_avx2_rej_large_2:
        shrq	$16, %rcx
        cmpw	$0xd01, %cx
        jge	L_kyber_rej_uniform_avx2_rej_large_3
        movw	%cx, (%rdi)
        addq	$2, %rdi
        subl	$0x01, %esi
        je	L_kyber_rej_uniform_avx2_done_64
L_kyber_rej_uniform_avx2_rej_large_3:
        addq	$6, %rdx
        subl	$6, %r8d
        jle	L_kyber_rej_uniform_avx2_done_64
        cmpl	$0x00, %esi
        jg	L_kyber_rej_uniform_avx2_start_64
L_kyber_rej_uniform_avx2_done_64:
        vzeroupper
        subl	%esi, %eax
        popq	%rbp
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        popq	%rbx
        repz retq
#ifndef __APPLE__
.size	kyber_rej_uniform_avx2,.-kyber_rej_uniform_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_mask_249:
.quad	0x24924900249249, 0x24924900249249
.quad	0x24924900249249, 0x24924900249249
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_mask_6db:
.quad	0x6db6db006db6db, 0x6db6db006db6db
.quad	0x6db6db006db6db, 0x6db6db006db6db
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_mask_07:
.quad	0x700000007, 0x700000007
.quad	0x700000007, 0x700000007
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_mask_70:
.quad	0x7000000070000, 0x7000000070000
.quad	0x7000000070000, 0x7000000070000
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_mask_3:
.quad	0x3000300030003, 0x3000300030003
.quad	0x3000300030003, 0x3000300030003
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_shuff:
.quad	0xff050403ff020100, 0xff0b0a09ff080706
.quad	0xff090807ff060504, 0xff0f0e0dff0c0b0a
#ifndef __APPLE__
.text
.globl	kyber_cbd_eta3_avx2
.type	kyber_cbd_eta3_avx2,@function
.align	16
kyber_cbd_eta3_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_cbd_eta3_avx2
.p2align	4
_kyber_cbd_eta3_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_kyber_mask_249(%rip), %ymm8
        vmovdqu	L_kyber_mask_6db(%rip), %ymm9
        vmovdqu	L_kyber_mask_07(%rip), %ymm10
        vmovdqu	L_kyber_mask_70(%rip), %ymm11
        vmovdqu	L_kyber_mask_3(%rip), %ymm12
        vmovdqu	L_kyber_shuff(%rip), %ymm13
        vmovdqu	(%rsi), %ymm0
        vmovdqu	24(%rsi), %ymm1
        vpermq	$0x94, %ymm0, %ymm0
        vpermq	$0x94, %ymm1, %ymm1
        vpshufb	%ymm13, %ymm0, %ymm0
        vpshufb	%ymm13, %ymm1, %ymm1
        vpsrld	$0x01, %ymm0, %ymm2
        vpsrld	$0x01, %ymm1, %ymm3
        vpsrld	$2, %ymm0, %ymm4
        vpsrld	$2, %ymm1, %ymm5
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpand	%ymm8, %ymm4, %ymm4
        vpand	%ymm8, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpaddd	%ymm4, %ymm0, %ymm0
        vpaddd	%ymm5, %ymm1, %ymm1
        vpsrld	$3, %ymm0, %ymm2
        vpsrld	$3, %ymm1, %ymm3
        vpaddd	%ymm9, %ymm0, %ymm0
        vpaddd	%ymm9, %ymm1, %ymm1
        vpsubd	%ymm2, %ymm0, %ymm0
        vpsubd	%ymm3, %ymm1, %ymm1
        vpslld	$10, %ymm0, %ymm2
        vpslld	$10, %ymm1, %ymm3
        vpsrld	$12, %ymm0, %ymm4
        vpsrld	$12, %ymm1, %ymm5
        vpsrld	$2, %ymm0, %ymm6
        vpsrld	$2, %ymm1, %ymm7
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpand	%ymm10, %ymm4, %ymm4
        vpand	%ymm10, %ymm5, %ymm5
        vpand	%ymm11, %ymm6, %ymm6
        vpand	%ymm11, %ymm7, %ymm7
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpaddw	%ymm6, %ymm4, %ymm2
        vpaddw	%ymm7, %ymm5, %ymm3
        vpsubw	%ymm12, %ymm0, %ymm0
        vpsubw	%ymm12, %ymm1, %ymm1
        vpsubw	%ymm12, %ymm2, %ymm2
        vpsubw	%ymm12, %ymm3, %ymm3
        vpunpckldq	%ymm2, %ymm0, %ymm4
        vpunpckldq	%ymm3, %ymm1, %ymm5
        vpunpckhdq	%ymm2, %ymm0, %ymm6
        vpunpckhdq	%ymm3, %ymm1, %ymm7
        vperm2i128	$32, %ymm6, %ymm4, %ymm0
        vperm2i128	$32, %ymm7, %ymm5, %ymm1
        vperm2i128	$49, %ymm6, %ymm4, %ymm2
        vperm2i128	$49, %ymm7, %ymm5, %ymm3
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	48(%rsi), %ymm0
        vmovdqu	72(%rsi), %ymm1
        vpermq	$0x94, %ymm0, %ymm0
        vpermq	$0x94, %ymm1, %ymm1
        vpshufb	%ymm13, %ymm0, %ymm0
        vpshufb	%ymm13, %ymm1, %ymm1
        vpsrld	$0x01, %ymm0, %ymm2
        vpsrld	$0x01, %ymm1, %ymm3
        vpsrld	$2, %ymm0, %ymm4
        vpsrld	$2, %ymm1, %ymm5
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpand	%ymm8, %ymm4, %ymm4
        vpand	%ymm8, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpaddd	%ymm4, %ymm0, %ymm0
        vpaddd	%ymm5, %ymm1, %ymm1
        vpsrld	$3, %ymm0, %ymm2
        vpsrld	$3, %ymm1, %ymm3
        vpaddd	%ymm9, %ymm0, %ymm0
        vpaddd	%ymm9, %ymm1, %ymm1
        vpsubd	%ymm2, %ymm0, %ymm0
        vpsubd	%ymm3, %ymm1, %ymm1
        vpslld	$10, %ymm0, %ymm2
        vpslld	$10, %ymm1, %ymm3
        vpsrld	$12, %ymm0, %ymm4
        vpsrld	$12, %ymm1, %ymm5
        vpsrld	$2, %ymm0, %ymm6
        vpsrld	$2, %ymm1, %ymm7
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpand	%ymm10, %ymm4, %ymm4
        vpand	%ymm10, %ymm5, %ymm5
        vpand	%ymm11, %ymm6, %ymm6
        vpand	%ymm11, %ymm7, %ymm7
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpaddw	%ymm6, %ymm4, %ymm2
        vpaddw	%ymm7, %ymm5, %ymm3
        vpsubw	%ymm12, %ymm0, %ymm0
        vpsubw	%ymm12, %ymm1, %ymm1
        vpsubw	%ymm12, %ymm2, %ymm2
        vpsubw	%ymm12, %ymm3, %ymm3
        vpunpckldq	%ymm2, %ymm0, %ymm4
        vpunpckldq	%ymm3, %ymm1, %ymm5
        vpunpckhdq	%ymm2, %ymm0, %ymm6
        vpunpckhdq	%ymm3, %ymm1, %ymm7
        vperm2i128	$32, %ymm6, %ymm4, %ymm0
        vperm2i128	$32, %ymm7, %ymm5, %ymm1
        vperm2i128	$49, %ymm6, %ymm4, %ymm2
        vperm2i128	$49, %ymm7, %ymm5, %ymm3
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm2, 160(%rdi)
        vmovdqu	%ymm1, 192(%rdi)
        vmovdqu	%ymm3, 224(%rdi)
        vmovdqu	96(%rsi), %ymm0
        vmovdqu	120(%rsi), %ymm1
        vpermq	$0x94, %ymm0, %ymm0
        vpermq	$0x94, %ymm1, %ymm1
        vpshufb	%ymm13, %ymm0, %ymm0
        vpshufb	%ymm13, %ymm1, %ymm1
        vpsrld	$0x01, %ymm0, %ymm2
        vpsrld	$0x01, %ymm1, %ymm3
        vpsrld	$2, %ymm0, %ymm4
        vpsrld	$2, %ymm1, %ymm5
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpand	%ymm8, %ymm4, %ymm4
        vpand	%ymm8, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpaddd	%ymm4, %ymm0, %ymm0
        vpaddd	%ymm5, %ymm1, %ymm1
        vpsrld	$3, %ymm0, %ymm2
        vpsrld	$3, %ymm1, %ymm3
        vpaddd	%ymm9, %ymm0, %ymm0
        vpaddd	%ymm9, %ymm1, %ymm1
        vpsubd	%ymm2, %ymm0, %ymm0
        vpsubd	%ymm3, %ymm1, %ymm1
        vpslld	$10, %ymm0, %ymm2
        vpslld	$10, %ymm1, %ymm3
        vpsrld	$12, %ymm0, %ymm4
        vpsrld	$12, %ymm1, %ymm5
        vpsrld	$2, %ymm0, %ymm6
        vpsrld	$2, %ymm1, %ymm7
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpand	%ymm10, %ymm4, %ymm4
        vpand	%ymm10, %ymm5, %ymm5
        vpand	%ymm11, %ymm6, %ymm6
        vpand	%ymm11, %ymm7, %ymm7
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpaddw	%ymm6, %ymm4, %ymm2
        vpaddw	%ymm7, %ymm5, %ymm3
        vpsubw	%ymm12, %ymm0, %ymm0
        vpsubw	%ymm12, %ymm1, %ymm1
        vpsubw	%ymm12, %ymm2, %ymm2
        vpsubw	%ymm12, %ymm3, %ymm3
        vpunpckldq	%ymm2, %ymm0, %ymm4
        vpunpckldq	%ymm3, %ymm1, %ymm5
        vpunpckhdq	%ymm2, %ymm0, %ymm6
        vpunpckhdq	%ymm3, %ymm1, %ymm7
        vperm2i128	$32, %ymm6, %ymm4, %ymm0
        vperm2i128	$32, %ymm7, %ymm5, %ymm1
        vperm2i128	$49, %ymm6, %ymm4, %ymm2
        vperm2i128	$49, %ymm7, %ymm5, %ymm3
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm2, 288(%rdi)
        vmovdqu	%ymm1, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vmovdqu	144(%rsi), %ymm0
        vmovdqu	168(%rsi), %ymm1
        vpermq	$0x94, %ymm0, %ymm0
        vpermq	$0x94, %ymm1, %ymm1
        vpshufb	%ymm13, %ymm0, %ymm0
        vpshufb	%ymm13, %ymm1, %ymm1
        vpsrld	$0x01, %ymm0, %ymm2
        vpsrld	$0x01, %ymm1, %ymm3
        vpsrld	$2, %ymm0, %ymm4
        vpsrld	$2, %ymm1, %ymm5
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpand	%ymm8, %ymm4, %ymm4
        vpand	%ymm8, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpaddd	%ymm4, %ymm0, %ymm0
        vpaddd	%ymm5, %ymm1, %ymm1
        vpsrld	$3, %ymm0, %ymm2
        vpsrld	$3, %ymm1, %ymm3
        vpaddd	%ymm9, %ymm0, %ymm0
        vpaddd	%ymm9, %ymm1, %ymm1
        vpsubd	%ymm2, %ymm0, %ymm0
        vpsubd	%ymm3, %ymm1, %ymm1
        vpslld	$10, %ymm0, %ymm2
        vpslld	$10, %ymm1, %ymm3
        vpsrld	$12, %ymm0, %ymm4
        vpsrld	$12, %ymm1, %ymm5
        vpsrld	$2, %ymm0, %ymm6
        vpsrld	$2, %ymm1, %ymm7
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpand	%ymm10, %ymm4, %ymm4
        vpand	%ymm10, %ymm5, %ymm5
        vpand	%ymm11, %ymm6, %ymm6
        vpand	%ymm11, %ymm7, %ymm7
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpaddw	%ymm6, %ymm4, %ymm2
        vpaddw	%ymm7, %ymm5, %ymm3
        vpsubw	%ymm12, %ymm0, %ymm0
        vpsubw	%ymm12, %ymm1, %ymm1
        vpsubw	%ymm12, %ymm2, %ymm2
        vpsubw	%ymm12, %ymm3, %ymm3
        vpunpckldq	%ymm2, %ymm0, %ymm4
        vpunpckldq	%ymm3, %ymm1, %ymm5
        vpunpckhdq	%ymm2, %ymm0, %ymm6
        vpunpckhdq	%ymm3, %ymm1, %ymm7
        vperm2i128	$32, %ymm6, %ymm4, %ymm0
        vperm2i128	$32, %ymm7, %ymm5, %ymm1
        vperm2i128	$49, %ymm6, %ymm4, %ymm2
        vperm2i128	$49, %ymm7, %ymm5, %ymm3
        vmovdqu	%ymm0, 384(%rdi)
        vmovdqu	%ymm2, 416(%rdi)
        vmovdqu	%ymm1, 448(%rdi)
        vmovdqu	%ymm3, 480(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_cbd_eta3_avx2,.-kyber_cbd_eta3_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_mask_55:
.quad	0x5555555555555555, 0x5555555555555555
.quad	0x5555555555555555, 0x5555555555555555
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_mask_33:
.quad	0x3333333333333333, 0x3333333333333333
.quad	0x3333333333333333, 0x3333333333333333
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_mask_03:
.quad	0x303030303030303, 0x303030303030303
.quad	0x303030303030303, 0x303030303030303
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_mask_0f:
.quad	0xf0f0f0f0f0f0f0f, 0xf0f0f0f0f0f0f0f
.quad	0xf0f0f0f0f0f0f0f, 0xf0f0f0f0f0f0f0f
#ifndef __APPLE__
.text
.globl	kyber_cbd_eta2_avx2
.type	kyber_cbd_eta2_avx2,@function
.align	16
kyber_cbd_eta2_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_cbd_eta2_avx2
.p2align	4
_kyber_cbd_eta2_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_kyber_mask_55(%rip), %ymm8
        vmovdqu	L_kyber_mask_33(%rip), %ymm9
        vmovdqu	L_kyber_mask_03(%rip), %ymm10
        vmovdqu	L_kyber_mask_0f(%rip), %ymm11
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vpsrlw	$0x01, %ymm0, %ymm2
        vpsrlw	$0x01, %ymm1, %ymm3
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddb	%ymm2, %ymm0, %ymm0
        vpaddb	%ymm3, %ymm1, %ymm1
        vpsrlw	$2, %ymm0, %ymm2
        vpsrlw	$2, %ymm1, %ymm3
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpand	%ymm9, %ymm2, %ymm2
        vpand	%ymm9, %ymm3, %ymm3
        vpaddb	%ymm9, %ymm0, %ymm0
        vpaddb	%ymm9, %ymm1, %ymm1
        vpsubb	%ymm2, %ymm0, %ymm0
        vpsubb	%ymm3, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpand	%ymm11, %ymm0, %ymm0
        vpand	%ymm11, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpsubb	%ymm10, %ymm0, %ymm0
        vpsubb	%ymm10, %ymm1, %ymm1
        vpsubb	%ymm10, %ymm2, %ymm2
        vpsubb	%ymm10, %ymm3, %ymm3
        vpunpcklbw	%ymm2, %ymm0, %ymm4
        vpunpcklbw	%ymm3, %ymm1, %ymm5
        vpunpckhbw	%ymm2, %ymm0, %ymm6
        vpunpckhbw	%ymm3, %ymm1, %ymm7
        vpmovsxbw	%xmm4, %ymm0
        vpmovsxbw	%xmm5, %ymm1
        vextracti128	$0x01, %ymm4, %xmm2
        vextracti128	$0x01, %ymm5, %xmm3
        vpmovsxbw	%xmm2, %ymm2
        vpmovsxbw	%xmm3, %ymm3
        vpmovsxbw	%xmm6, %ymm4
        vpmovsxbw	%xmm7, %ymm5
        vextracti128	$0x01, %ymm6, %xmm6
        vextracti128	$0x01, %ymm7, %xmm7
        vpmovsxbw	%xmm6, %ymm6
        vpmovsxbw	%xmm7, %ymm7
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm4, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm6, 96(%rdi)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm5, 160(%rdi)
        vmovdqu	%ymm3, 192(%rdi)
        vmovdqu	%ymm7, 224(%rdi)
        vmovdqu	64(%rsi), %ymm0
        vmovdqu	96(%rsi), %ymm1
        vpsrlw	$0x01, %ymm0, %ymm2
        vpsrlw	$0x01, %ymm1, %ymm3
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddb	%ymm2, %ymm0, %ymm0
        vpaddb	%ymm3, %ymm1, %ymm1
        vpsrlw	$2, %ymm0, %ymm2
        vpsrlw	$2, %ymm1, %ymm3
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpand	%ymm9, %ymm2, %ymm2
        vpand	%ymm9, %ymm3, %ymm3
        vpaddb	%ymm9, %ymm0, %ymm0
        vpaddb	%ymm9, %ymm1, %ymm1
        vpsubb	%ymm2, %ymm0, %ymm0
        vpsubb	%ymm3, %ymm1, %ymm1
        vpsrlw	$4, %ymm0, %ymm2
        vpsrlw	$4, %ymm1, %ymm3
        vpand	%ymm11, %ymm0, %ymm0
        vpand	%ymm11, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpsubb	%ymm10, %ymm0, %ymm0
        vpsubb	%ymm10, %ymm1, %ymm1
        vpsubb	%ymm10, %ymm2, %ymm2
        vpsubb	%ymm10, %ymm3, %ymm3
        vpunpcklbw	%ymm2, %ymm0, %ymm4
        vpunpcklbw	%ymm3, %ymm1, %ymm5
        vpunpckhbw	%ymm2, %ymm0, %ymm6
        vpunpckhbw	%ymm3, %ymm1, %ymm7
        vpmovsxbw	%xmm4, %ymm0
        vpmovsxbw	%xmm5, %ymm1
        vextracti128	$0x01, %ymm4, %xmm2
        vextracti128	$0x01, %ymm5, %xmm3
        vpmovsxbw	%xmm2, %ymm2
        vpmovsxbw	%xmm3, %ymm3
        vpmovsxbw	%xmm6, %ymm4
        vpmovsxbw	%xmm7, %ymm5
        vextracti128	$0x01, %ymm6, %xmm6
        vextracti128	$0x01, %ymm7, %xmm7
        vpmovsxbw	%xmm6, %ymm6
        vpmovsxbw	%xmm7, %ymm7
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm4, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm6, 352(%rdi)
        vmovdqu	%ymm1, 384(%rdi)
        vmovdqu	%ymm5, 416(%rdi)
        vmovdqu	%ymm3, 448(%rdi)
        vmovdqu	%ymm7, 480(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_cbd_eta2_avx2,.-kyber_cbd_eta2_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_10_avx2_mask:
.value	0x3ff,0x3ff
.value	0x3ff,0x3ff
.value	0x3ff,0x3ff
.value	0x3ff,0x3ff
.value	0x3ff,0x3ff
.value	0x3ff,0x3ff
.value	0x3ff,0x3ff
.value	0x3ff,0x3ff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_compress_10_avx2_shift:
.quad	0x400000104000001, 0x400000104000001
.quad	0x400000104000001, 0x400000104000001
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_compress_10_avx2_shlv:
.quad	0xc, 0xc
.quad	0xc, 0xc
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_10_avx2_shuf:
.value	0x100,0x302
.value	0x804,0xa09
.value	0xc0b,0xffff
.value	0xffff,0xffff
.value	0xa09,0xc0b
.value	0xffff,0xffff
.value	0xffff,0x100
.value	0x302,0x804
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_10_avx2_v:
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_10_avx2_offset:
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_10_avx2_shift12:
.value	0x1000,0x1000
.value	0x1000,0x1000
.value	0x1000,0x1000
.value	0x1000,0x1000
.value	0x1000,0x1000
.value	0x1000,0x1000
.value	0x1000,0x1000
.value	0x1000,0x1000
#ifndef __APPLE__
.text
.globl	kyber_compress_10_avx2
.type	kyber_compress_10_avx2,@function
.align	16
kyber_compress_10_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_compress_10_avx2
.p2align	4
_kyber_compress_10_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rsi), %ymm0
        vmovdqu	L_kyber_compress_10_avx2_mask(%rip), %ymm9
        vmovdqu	L_kyber_compress_10_avx2_shift(%rip), %ymm8
        vmovdqu	L_kyber_compress_10_avx2_shlv(%rip), %ymm10
        vmovdqu	L_kyber_compress_10_avx2_shuf(%rip), %ymm11
        vmovdqu	L_kyber_compress_10_avx2_v(%rip), %ymm6
        vmovdqu	L_kyber_compress_10_avx2_offset(%rip), %ymm12
        vmovdqu	L_kyber_compress_10_avx2_shift12(%rip), %ymm13
        vpsllw	$3, %ymm6, %ymm7
L_kyber_compress_10_avx2_start:
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vpmullw	%ymm7, %ymm0, %ymm2
        vpmullw	%ymm7, %ymm1, %ymm4
        vpaddw	%ymm12, %ymm0, %ymm3
        vpaddw	%ymm12, %ymm1, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm1, %ymm1
        vpmulhuw	%ymm6, %ymm0, %ymm0
        vpmulhuw	%ymm6, %ymm1, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm3, %ymm2, %ymm2
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm2, %ymm2
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm2, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm13, %ymm0, %ymm0
        vpmulhrsw	%ymm13, %ymm1, %ymm1
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpmaddwd	%ymm8, %ymm0, %ymm0
        vpmaddwd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm10, %ymm0, %ymm0
        vpsllvd	%ymm10, %ymm1, %ymm1
        vpsrlq	$12, %ymm0, %ymm0
        vpsrlq	$12, %ymm1, %ymm1
        vpshufb	%ymm11, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm1, %ymm1
        vextracti128	$0x01, %ymm0, %xmm2
        vextracti128	$0x01, %ymm1, %xmm4
        vpblendw	$0xe0, %xmm2, %xmm0, %xmm0
        vpblendw	$0xe0, %xmm4, %xmm1, %xmm1
        vmovdqu	%xmm0, (%rdi)
        vmovdqu	%xmm1, 20(%rdi)
        vmovss	%xmm2, 16(%rdi)
        vmovss	%xmm4, 36(%rdi)
        vmovdqu	64(%rsi), %ymm0
        vmovdqu	96(%rsi), %ymm1
        vpmullw	%ymm7, %ymm0, %ymm2
        vpmullw	%ymm7, %ymm1, %ymm4
        vpaddw	%ymm12, %ymm0, %ymm3
        vpaddw	%ymm12, %ymm1, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm1, %ymm1
        vpmulhuw	%ymm6, %ymm0, %ymm0
        vpmulhuw	%ymm6, %ymm1, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm3, %ymm2, %ymm2
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm2, %ymm2
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm2, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm13, %ymm0, %ymm0
        vpmulhrsw	%ymm13, %ymm1, %ymm1
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpmaddwd	%ymm8, %ymm0, %ymm0
        vpmaddwd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm10, %ymm0, %ymm0
        vpsllvd	%ymm10, %ymm1, %ymm1
        vpsrlq	$12, %ymm0, %ymm0
        vpsrlq	$12, %ymm1, %ymm1
        vpshufb	%ymm11, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm1, %ymm1
        vextracti128	$0x01, %ymm0, %xmm2
        vextracti128	$0x01, %ymm1, %xmm4
        vpblendw	$0xe0, %xmm2, %xmm0, %xmm0
        vpblendw	$0xe0, %xmm4, %xmm1, %xmm1
        vmovdqu	%xmm0, 40(%rdi)
        vmovdqu	%xmm1, 60(%rdi)
        vmovss	%xmm2, 56(%rdi)
        vmovss	%xmm4, 76(%rdi)
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	160(%rsi), %ymm1
        vpmullw	%ymm7, %ymm0, %ymm2
        vpmullw	%ymm7, %ymm1, %ymm4
        vpaddw	%ymm12, %ymm0, %ymm3
        vpaddw	%ymm12, %ymm1, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm1, %ymm1
        vpmulhuw	%ymm6, %ymm0, %ymm0
        vpmulhuw	%ymm6, %ymm1, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm3, %ymm2, %ymm2
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm2, %ymm2
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm2, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm13, %ymm0, %ymm0
        vpmulhrsw	%ymm13, %ymm1, %ymm1
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpmaddwd	%ymm8, %ymm0, %ymm0
        vpmaddwd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm10, %ymm0, %ymm0
        vpsllvd	%ymm10, %ymm1, %ymm1
        vpsrlq	$12, %ymm0, %ymm0
        vpsrlq	$12, %ymm1, %ymm1
        vpshufb	%ymm11, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm1, %ymm1
        vextracti128	$0x01, %ymm0, %xmm2
        vextracti128	$0x01, %ymm1, %xmm4
        vpblendw	$0xe0, %xmm2, %xmm0, %xmm0
        vpblendw	$0xe0, %xmm4, %xmm1, %xmm1
        vmovdqu	%xmm0, 80(%rdi)
        vmovdqu	%xmm1, 100(%rdi)
        vmovss	%xmm2, 96(%rdi)
        vmovss	%xmm4, 116(%rdi)
        vmovdqu	192(%rsi), %ymm0
        vmovdqu	224(%rsi), %ymm1
        vpmullw	%ymm7, %ymm0, %ymm2
        vpmullw	%ymm7, %ymm1, %ymm4
        vpaddw	%ymm12, %ymm0, %ymm3
        vpaddw	%ymm12, %ymm1, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm1, %ymm1
        vpmulhuw	%ymm6, %ymm0, %ymm0
        vpmulhuw	%ymm6, %ymm1, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm3, %ymm2, %ymm2
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm2, %ymm2
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm2, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm13, %ymm0, %ymm0
        vpmulhrsw	%ymm13, %ymm1, %ymm1
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpmaddwd	%ymm8, %ymm0, %ymm0
        vpmaddwd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm10, %ymm0, %ymm0
        vpsllvd	%ymm10, %ymm1, %ymm1
        vpsrlq	$12, %ymm0, %ymm0
        vpsrlq	$12, %ymm1, %ymm1
        vpshufb	%ymm11, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm1, %ymm1
        vextracti128	$0x01, %ymm0, %xmm2
        vextracti128	$0x01, %ymm1, %xmm4
        vpblendw	$0xe0, %xmm2, %xmm0, %xmm0
        vpblendw	$0xe0, %xmm4, %xmm1, %xmm1
        vmovdqu	%xmm0, 120(%rdi)
        vmovdqu	%xmm1, 140(%rdi)
        vmovss	%xmm2, 136(%rdi)
        vmovss	%xmm4, 156(%rdi)
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	288(%rsi), %ymm1
        vpmullw	%ymm7, %ymm0, %ymm2
        vpmullw	%ymm7, %ymm1, %ymm4
        vpaddw	%ymm12, %ymm0, %ymm3
        vpaddw	%ymm12, %ymm1, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm1, %ymm1
        vpmulhuw	%ymm6, %ymm0, %ymm0
        vpmulhuw	%ymm6, %ymm1, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm3, %ymm2, %ymm2
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm2, %ymm2
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm2, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm13, %ymm0, %ymm0
        vpmulhrsw	%ymm13, %ymm1, %ymm1
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpmaddwd	%ymm8, %ymm0, %ymm0
        vpmaddwd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm10, %ymm0, %ymm0
        vpsllvd	%ymm10, %ymm1, %ymm1
        vpsrlq	$12, %ymm0, %ymm0
        vpsrlq	$12, %ymm1, %ymm1
        vpshufb	%ymm11, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm1, %ymm1
        vextracti128	$0x01, %ymm0, %xmm2
        vextracti128	$0x01, %ymm1, %xmm4
        vpblendw	$0xe0, %xmm2, %xmm0, %xmm0
        vpblendw	$0xe0, %xmm4, %xmm1, %xmm1
        vmovdqu	%xmm0, 160(%rdi)
        vmovdqu	%xmm1, 180(%rdi)
        vmovss	%xmm2, 176(%rdi)
        vmovss	%xmm4, 196(%rdi)
        vmovdqu	320(%rsi), %ymm0
        vmovdqu	352(%rsi), %ymm1
        vpmullw	%ymm7, %ymm0, %ymm2
        vpmullw	%ymm7, %ymm1, %ymm4
        vpaddw	%ymm12, %ymm0, %ymm3
        vpaddw	%ymm12, %ymm1, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm1, %ymm1
        vpmulhuw	%ymm6, %ymm0, %ymm0
        vpmulhuw	%ymm6, %ymm1, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm3, %ymm2, %ymm2
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm2, %ymm2
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm2, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm13, %ymm0, %ymm0
        vpmulhrsw	%ymm13, %ymm1, %ymm1
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpmaddwd	%ymm8, %ymm0, %ymm0
        vpmaddwd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm10, %ymm0, %ymm0
        vpsllvd	%ymm10, %ymm1, %ymm1
        vpsrlq	$12, %ymm0, %ymm0
        vpsrlq	$12, %ymm1, %ymm1
        vpshufb	%ymm11, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm1, %ymm1
        vextracti128	$0x01, %ymm0, %xmm2
        vextracti128	$0x01, %ymm1, %xmm4
        vpblendw	$0xe0, %xmm2, %xmm0, %xmm0
        vpblendw	$0xe0, %xmm4, %xmm1, %xmm1
        vmovdqu	%xmm0, 200(%rdi)
        vmovdqu	%xmm1, 220(%rdi)
        vmovss	%xmm2, 216(%rdi)
        vmovss	%xmm4, 236(%rdi)
        vmovdqu	384(%rsi), %ymm0
        vmovdqu	416(%rsi), %ymm1
        vpmullw	%ymm7, %ymm0, %ymm2
        vpmullw	%ymm7, %ymm1, %ymm4
        vpaddw	%ymm12, %ymm0, %ymm3
        vpaddw	%ymm12, %ymm1, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm1, %ymm1
        vpmulhuw	%ymm6, %ymm0, %ymm0
        vpmulhuw	%ymm6, %ymm1, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm3, %ymm2, %ymm2
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm2, %ymm2
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm2, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm13, %ymm0, %ymm0
        vpmulhrsw	%ymm13, %ymm1, %ymm1
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpmaddwd	%ymm8, %ymm0, %ymm0
        vpmaddwd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm10, %ymm0, %ymm0
        vpsllvd	%ymm10, %ymm1, %ymm1
        vpsrlq	$12, %ymm0, %ymm0
        vpsrlq	$12, %ymm1, %ymm1
        vpshufb	%ymm11, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm1, %ymm1
        vextracti128	$0x01, %ymm0, %xmm2
        vextracti128	$0x01, %ymm1, %xmm4
        vpblendw	$0xe0, %xmm2, %xmm0, %xmm0
        vpblendw	$0xe0, %xmm4, %xmm1, %xmm1
        vmovdqu	%xmm0, 240(%rdi)
        vmovdqu	%xmm1, 260(%rdi)
        vmovss	%xmm2, 256(%rdi)
        vmovss	%xmm4, 276(%rdi)
        vmovdqu	448(%rsi), %ymm0
        vmovdqu	480(%rsi), %ymm1
        vpmullw	%ymm7, %ymm0, %ymm2
        vpmullw	%ymm7, %ymm1, %ymm4
        vpaddw	%ymm12, %ymm0, %ymm3
        vpaddw	%ymm12, %ymm1, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm1, %ymm1
        vpmulhuw	%ymm6, %ymm0, %ymm0
        vpmulhuw	%ymm6, %ymm1, %ymm1
        vpsubw	%ymm3, %ymm2, %ymm3
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm3, %ymm2, %ymm2
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm2, %ymm2
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm2, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm13, %ymm0, %ymm0
        vpmulhrsw	%ymm13, %ymm1, %ymm1
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpmaddwd	%ymm8, %ymm0, %ymm0
        vpmaddwd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm10, %ymm0, %ymm0
        vpsllvd	%ymm10, %ymm1, %ymm1
        vpsrlq	$12, %ymm0, %ymm0
        vpsrlq	$12, %ymm1, %ymm1
        vpshufb	%ymm11, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm1, %ymm1
        vextracti128	$0x01, %ymm0, %xmm2
        vextracti128	$0x01, %ymm1, %xmm4
        vpblendw	$0xe0, %xmm2, %xmm0, %xmm0
        vpblendw	$0xe0, %xmm4, %xmm1, %xmm1
        vmovdqu	%xmm0, 280(%rdi)
        vmovdqu	%xmm1, 300(%rdi)
        vmovss	%xmm2, 296(%rdi)
        vmovss	%xmm4, 316(%rdi)
        addq	$0x140, %rdi
        addq	$0x200, %rsi
        subl	$0x01, %edx
        jg	L_kyber_compress_10_avx2_start
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_compress_10_avx2,.-kyber_compress_10_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_decompress_10_avx2_mask:
.long	0x7fe01ff8,0x7fe01ff8,0x7fe01ff8,0x7fe01ff8
.long	0x7fe01ff8,0x7fe01ff8,0x7fe01ff8,0x7fe01ff8
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_decompress_10_avx2_sllv:
.quad	0x4, 0x4
.quad	0x4, 0x4
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_decompress_10_avx2_q:
.long	0xd013404,0xd013404,0xd013404,0xd013404
.long	0xd013404,0xd013404,0xd013404,0xd013404
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_10_avx2_shuf:
.value	0x100,0x201
.value	0x302,0x403
.value	0x605,0x706
.value	0x807,0x908
.value	0x302,0x403
.value	0x504,0x605
.value	0x807,0x908
.value	0xa09,0xb0a
#ifndef __APPLE__
.text
.globl	kyber_decompress_10_avx2
.type	kyber_decompress_10_avx2,@function
.align	16
kyber_decompress_10_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_decompress_10_avx2
.p2align	4
_kyber_decompress_10_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_kyber_decompress_10_avx2_mask(%rip), %ymm4
        vmovdqu	L_kyber_decompress_10_avx2_q(%rip), %ymm5
        vmovdqu	L_kyber_decompress_10_avx2_shuf(%rip), %ymm6
        vmovdqu	L_kyber_decompress_10_avx2_sllv(%rip), %ymm7
L_kyber_decompress_10_avx2_start:
        vpermq	$0x94, (%rsi), %ymm0
        vpermq	$0x94, 20(%rsi), %ymm1
        vpermq	$0x94, 40(%rsi), %ymm2
        vpermq	$0x94, 60(%rsi), %ymm3
        vpshufb	%ymm6, %ymm0, %ymm0
        vpshufb	%ymm6, %ymm1, %ymm1
        vpshufb	%ymm6, %ymm2, %ymm2
        vpshufb	%ymm6, %ymm3, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpsrlw	$0x01, %ymm0, %ymm0
        vpsrlw	$0x01, %ymm1, %ymm1
        vpsrlw	$0x01, %ymm2, %ymm2
        vpsrlw	$0x01, %ymm3, %ymm3
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpand	%ymm4, %ymm2, %ymm2
        vpand	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm5, %ymm0, %ymm0
        vpmulhrsw	%ymm5, %ymm1, %ymm1
        vpmulhrsw	%ymm5, %ymm2, %ymm2
        vpmulhrsw	%ymm5, %ymm3, %ymm3
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vpermq	$0x94, 80(%rsi), %ymm0
        vpermq	$0x94, 100(%rsi), %ymm1
        vpermq	$0x94, 120(%rsi), %ymm2
        vpermq	$0x94, 140(%rsi), %ymm3
        vpshufb	%ymm6, %ymm0, %ymm0
        vpshufb	%ymm6, %ymm1, %ymm1
        vpshufb	%ymm6, %ymm2, %ymm2
        vpshufb	%ymm6, %ymm3, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpsrlw	$0x01, %ymm0, %ymm0
        vpsrlw	$0x01, %ymm1, %ymm1
        vpsrlw	$0x01, %ymm2, %ymm2
        vpsrlw	$0x01, %ymm3, %ymm3
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpand	%ymm4, %ymm2, %ymm2
        vpand	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm5, %ymm0, %ymm0
        vpmulhrsw	%ymm5, %ymm1, %ymm1
        vpmulhrsw	%ymm5, %ymm2, %ymm2
        vpmulhrsw	%ymm5, %ymm3, %ymm3
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, 160(%rdi)
        vmovdqu	%ymm2, 192(%rdi)
        vmovdqu	%ymm3, 224(%rdi)
        vpermq	$0x94, 160(%rsi), %ymm0
        vpermq	$0x94, 180(%rsi), %ymm1
        vpermq	$0x94, 200(%rsi), %ymm2
        vpermq	$0x94, 220(%rsi), %ymm3
        vpshufb	%ymm6, %ymm0, %ymm0
        vpshufb	%ymm6, %ymm1, %ymm1
        vpshufb	%ymm6, %ymm2, %ymm2
        vpshufb	%ymm6, %ymm3, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpsrlw	$0x01, %ymm0, %ymm0
        vpsrlw	$0x01, %ymm1, %ymm1
        vpsrlw	$0x01, %ymm2, %ymm2
        vpsrlw	$0x01, %ymm3, %ymm3
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpand	%ymm4, %ymm2, %ymm2
        vpand	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm5, %ymm0, %ymm0
        vpmulhrsw	%ymm5, %ymm1, %ymm1
        vpmulhrsw	%ymm5, %ymm2, %ymm2
        vpmulhrsw	%ymm5, %ymm3, %ymm3
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vpermq	$0x94, 240(%rsi), %ymm0
        vpermq	$0x94, 260(%rsi), %ymm1
        vpermq	$0x94, 280(%rsi), %ymm2
        vpermq	$0x94, 300(%rsi), %ymm3
        vpshufb	%ymm6, %ymm0, %ymm0
        vpshufb	%ymm6, %ymm1, %ymm1
        vpshufb	%ymm6, %ymm2, %ymm2
        vpshufb	%ymm6, %ymm3, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpsrlw	$0x01, %ymm0, %ymm0
        vpsrlw	$0x01, %ymm1, %ymm1
        vpsrlw	$0x01, %ymm2, %ymm2
        vpsrlw	$0x01, %ymm3, %ymm3
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpand	%ymm4, %ymm2, %ymm2
        vpand	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm5, %ymm0, %ymm0
        vpmulhrsw	%ymm5, %ymm1, %ymm1
        vpmulhrsw	%ymm5, %ymm2, %ymm2
        vpmulhrsw	%ymm5, %ymm3, %ymm3
        vmovdqu	%ymm0, 384(%rdi)
        vmovdqu	%ymm1, 416(%rdi)
        vmovdqu	%ymm2, 448(%rdi)
        vmovdqu	%ymm3, 480(%rdi)
        addq	$0x140, %rsi
        addq	$0x200, %rdi
        subl	$0x01, %edx
        jg	L_kyber_decompress_10_avx2_start
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_decompress_10_avx2,.-kyber_decompress_10_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_11_avx2_v:
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_11_avx2_off:
.value	0x24,0x24
.value	0x24,0x24
.value	0x24,0x24
.value	0x24,0x24
.value	0x24,0x24
.value	0x24,0x24
.value	0x24,0x24
.value	0x24,0x24
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_11_avx2_shift13:
.value	0x2000,0x2000
.value	0x2000,0x2000
.value	0x2000,0x2000
.value	0x2000,0x2000
.value	0x2000,0x2000
.value	0x2000,0x2000
.value	0x2000,0x2000
.value	0x2000,0x2000
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_11_avx2_mask:
.value	0x7ff,0x7ff
.value	0x7ff,0x7ff
.value	0x7ff,0x7ff
.value	0x7ff,0x7ff
.value	0x7ff,0x7ff
.value	0x7ff,0x7ff
.value	0x7ff,0x7ff
.value	0x7ff,0x7ff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_compress_11_avx2_shift:
.quad	0x800000108000001, 0x800000108000001
.quad	0x800000108000001, 0x800000108000001
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_compress_11_avx2_sllvd:
.long	0xa,0x0,0xa,0x0
.long	0xa,0x0,0xa,0x0
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_compress_11_avx2_srlvq:
.quad	0xa, 0x1e
.quad	0xa, 0x1e
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_11_avx2_shuf:
.value	0x100,0x302
.value	0x504,0x706
.value	0x908,0xff0a
.value	0xffff,0xffff
.value	0x605,0x807
.value	0xa09,0xffff
.value	0xffff,0x0
.value	0x201,0x403
#ifndef __APPLE__
.text
.globl	kyber_compress_11_avx2
.type	kyber_compress_11_avx2,@function
.align	16
kyber_compress_11_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_compress_11_avx2
.p2align	4
_kyber_compress_11_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rsi), %ymm0
        vmovdqu	L_kyber_compress_11_avx2_v(%rip), %ymm7
        vmovdqu	L_kyber_compress_11_avx2_off(%rip), %ymm8
        vmovdqu	L_kyber_compress_11_avx2_shift13(%rip), %ymm9
        vmovdqu	L_kyber_compress_11_avx2_mask(%rip), %ymm10
        vmovdqu	L_kyber_compress_11_avx2_shift(%rip), %ymm11
        vmovdqu	L_kyber_compress_11_avx2_sllvd(%rip), %ymm12
        vmovdqu	L_kyber_compress_11_avx2_srlvq(%rip), %ymm13
        vmovdqu	L_kyber_compress_11_avx2_shuf(%rip), %ymm14
        vpsllw	$3, %ymm7, %ymm6
L_kyber_compress_11_avx2_start:
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm3
        vpmullw	%ymm6, %ymm0, %ymm1
        vpmullw	%ymm6, %ymm3, %ymm4
        vpaddw	%ymm8, %ymm0, %ymm2
        vpaddw	%ymm8, %ymm3, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm3, %ymm3
        vpmulhw	%ymm7, %ymm0, %ymm0
        vpmulhw	%ymm7, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm1, %ymm2
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm2, %ymm1, %ymm1
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm1, %ymm1
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm3, %ymm3
        vpmaddwd	%ymm11, %ymm0, %ymm0
        vpmaddwd	%ymm11, %ymm3, %ymm3
        vpsllvd	%ymm12, %ymm0, %ymm0
        vpsllvd	%ymm12, %ymm3, %ymm3
        vpsrldq	$8, %ymm0, %ymm1
        vpsrldq	$8, %ymm3, %ymm4
        vpsrlvq	%ymm13, %ymm0, %ymm0
        vpsrlvq	%ymm13, %ymm3, %ymm3
        vpsllq	$34, %ymm1, %ymm1
        vpsllq	$34, %ymm4, %ymm4
        vpaddq	%ymm1, %ymm0, %ymm0
        vpaddq	%ymm4, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm1
        vextracti128	$0x01, %ymm3, %xmm4
        vpblendvb	%xmm14, %xmm1, %xmm0, %xmm0
        vpblendvb	%xmm14, %xmm4, %xmm3, %xmm3
        vmovdqu	%xmm0, (%rdi)
        vmovq	%xmm1, 16(%rdi)
        vmovdqu	%xmm3, 22(%rdi)
        vmovq	%xmm4, 38(%rdi)
        vmovdqu	64(%rsi), %ymm0
        vmovdqu	96(%rsi), %ymm3
        vpmullw	%ymm6, %ymm0, %ymm1
        vpmullw	%ymm6, %ymm3, %ymm4
        vpaddw	%ymm8, %ymm0, %ymm2
        vpaddw	%ymm8, %ymm3, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm3, %ymm3
        vpmulhw	%ymm7, %ymm0, %ymm0
        vpmulhw	%ymm7, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm1, %ymm2
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm2, %ymm1, %ymm1
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm1, %ymm1
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm3, %ymm3
        vpmaddwd	%ymm11, %ymm0, %ymm0
        vpmaddwd	%ymm11, %ymm3, %ymm3
        vpsllvd	%ymm12, %ymm0, %ymm0
        vpsllvd	%ymm12, %ymm3, %ymm3
        vpsrldq	$8, %ymm0, %ymm1
        vpsrldq	$8, %ymm3, %ymm4
        vpsrlvq	%ymm13, %ymm0, %ymm0
        vpsrlvq	%ymm13, %ymm3, %ymm3
        vpsllq	$34, %ymm1, %ymm1
        vpsllq	$34, %ymm4, %ymm4
        vpaddq	%ymm1, %ymm0, %ymm0
        vpaddq	%ymm4, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm1
        vextracti128	$0x01, %ymm3, %xmm4
        vpblendvb	%xmm14, %xmm1, %xmm0, %xmm0
        vpblendvb	%xmm14, %xmm4, %xmm3, %xmm3
        vmovdqu	%xmm0, 44(%rdi)
        vmovq	%xmm1, 60(%rdi)
        vmovdqu	%xmm3, 66(%rdi)
        vmovq	%xmm4, 82(%rdi)
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	160(%rsi), %ymm3
        vpmullw	%ymm6, %ymm0, %ymm1
        vpmullw	%ymm6, %ymm3, %ymm4
        vpaddw	%ymm8, %ymm0, %ymm2
        vpaddw	%ymm8, %ymm3, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm3, %ymm3
        vpmulhw	%ymm7, %ymm0, %ymm0
        vpmulhw	%ymm7, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm1, %ymm2
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm2, %ymm1, %ymm1
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm1, %ymm1
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm3, %ymm3
        vpmaddwd	%ymm11, %ymm0, %ymm0
        vpmaddwd	%ymm11, %ymm3, %ymm3
        vpsllvd	%ymm12, %ymm0, %ymm0
        vpsllvd	%ymm12, %ymm3, %ymm3
        vpsrldq	$8, %ymm0, %ymm1
        vpsrldq	$8, %ymm3, %ymm4
        vpsrlvq	%ymm13, %ymm0, %ymm0
        vpsrlvq	%ymm13, %ymm3, %ymm3
        vpsllq	$34, %ymm1, %ymm1
        vpsllq	$34, %ymm4, %ymm4
        vpaddq	%ymm1, %ymm0, %ymm0
        vpaddq	%ymm4, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm1
        vextracti128	$0x01, %ymm3, %xmm4
        vpblendvb	%xmm14, %xmm1, %xmm0, %xmm0
        vpblendvb	%xmm14, %xmm4, %xmm3, %xmm3
        vmovdqu	%xmm0, 88(%rdi)
        vmovq	%xmm1, 104(%rdi)
        vmovdqu	%xmm3, 110(%rdi)
        vmovq	%xmm4, 126(%rdi)
        vmovdqu	192(%rsi), %ymm0
        vmovdqu	224(%rsi), %ymm3
        vpmullw	%ymm6, %ymm0, %ymm1
        vpmullw	%ymm6, %ymm3, %ymm4
        vpaddw	%ymm8, %ymm0, %ymm2
        vpaddw	%ymm8, %ymm3, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm3, %ymm3
        vpmulhw	%ymm7, %ymm0, %ymm0
        vpmulhw	%ymm7, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm1, %ymm2
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm2, %ymm1, %ymm1
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm1, %ymm1
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm3, %ymm3
        vpmaddwd	%ymm11, %ymm0, %ymm0
        vpmaddwd	%ymm11, %ymm3, %ymm3
        vpsllvd	%ymm12, %ymm0, %ymm0
        vpsllvd	%ymm12, %ymm3, %ymm3
        vpsrldq	$8, %ymm0, %ymm1
        vpsrldq	$8, %ymm3, %ymm4
        vpsrlvq	%ymm13, %ymm0, %ymm0
        vpsrlvq	%ymm13, %ymm3, %ymm3
        vpsllq	$34, %ymm1, %ymm1
        vpsllq	$34, %ymm4, %ymm4
        vpaddq	%ymm1, %ymm0, %ymm0
        vpaddq	%ymm4, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm1
        vextracti128	$0x01, %ymm3, %xmm4
        vpblendvb	%xmm14, %xmm1, %xmm0, %xmm0
        vpblendvb	%xmm14, %xmm4, %xmm3, %xmm3
        vmovdqu	%xmm0, 132(%rdi)
        vmovq	%xmm1, 148(%rdi)
        vmovdqu	%xmm3, 154(%rdi)
        vmovq	%xmm4, 170(%rdi)
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	288(%rsi), %ymm3
        vpmullw	%ymm6, %ymm0, %ymm1
        vpmullw	%ymm6, %ymm3, %ymm4
        vpaddw	%ymm8, %ymm0, %ymm2
        vpaddw	%ymm8, %ymm3, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm3, %ymm3
        vpmulhw	%ymm7, %ymm0, %ymm0
        vpmulhw	%ymm7, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm1, %ymm2
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm2, %ymm1, %ymm1
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm1, %ymm1
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm3, %ymm3
        vpmaddwd	%ymm11, %ymm0, %ymm0
        vpmaddwd	%ymm11, %ymm3, %ymm3
        vpsllvd	%ymm12, %ymm0, %ymm0
        vpsllvd	%ymm12, %ymm3, %ymm3
        vpsrldq	$8, %ymm0, %ymm1
        vpsrldq	$8, %ymm3, %ymm4
        vpsrlvq	%ymm13, %ymm0, %ymm0
        vpsrlvq	%ymm13, %ymm3, %ymm3
        vpsllq	$34, %ymm1, %ymm1
        vpsllq	$34, %ymm4, %ymm4
        vpaddq	%ymm1, %ymm0, %ymm0
        vpaddq	%ymm4, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm1
        vextracti128	$0x01, %ymm3, %xmm4
        vpblendvb	%xmm14, %xmm1, %xmm0, %xmm0
        vpblendvb	%xmm14, %xmm4, %xmm3, %xmm3
        vmovdqu	%xmm0, 176(%rdi)
        vmovq	%xmm1, 192(%rdi)
        vmovdqu	%xmm3, 198(%rdi)
        vmovq	%xmm4, 214(%rdi)
        vmovdqu	320(%rsi), %ymm0
        vmovdqu	352(%rsi), %ymm3
        vpmullw	%ymm6, %ymm0, %ymm1
        vpmullw	%ymm6, %ymm3, %ymm4
        vpaddw	%ymm8, %ymm0, %ymm2
        vpaddw	%ymm8, %ymm3, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm3, %ymm3
        vpmulhw	%ymm7, %ymm0, %ymm0
        vpmulhw	%ymm7, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm1, %ymm2
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm2, %ymm1, %ymm1
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm1, %ymm1
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm3, %ymm3
        vpmaddwd	%ymm11, %ymm0, %ymm0
        vpmaddwd	%ymm11, %ymm3, %ymm3
        vpsllvd	%ymm12, %ymm0, %ymm0
        vpsllvd	%ymm12, %ymm3, %ymm3
        vpsrldq	$8, %ymm0, %ymm1
        vpsrldq	$8, %ymm3, %ymm4
        vpsrlvq	%ymm13, %ymm0, %ymm0
        vpsrlvq	%ymm13, %ymm3, %ymm3
        vpsllq	$34, %ymm1, %ymm1
        vpsllq	$34, %ymm4, %ymm4
        vpaddq	%ymm1, %ymm0, %ymm0
        vpaddq	%ymm4, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm1
        vextracti128	$0x01, %ymm3, %xmm4
        vpblendvb	%xmm14, %xmm1, %xmm0, %xmm0
        vpblendvb	%xmm14, %xmm4, %xmm3, %xmm3
        vmovdqu	%xmm0, 220(%rdi)
        vmovq	%xmm1, 236(%rdi)
        vmovdqu	%xmm3, 242(%rdi)
        vmovq	%xmm4, 258(%rdi)
        vmovdqu	384(%rsi), %ymm0
        vmovdqu	416(%rsi), %ymm3
        vpmullw	%ymm6, %ymm0, %ymm1
        vpmullw	%ymm6, %ymm3, %ymm4
        vpaddw	%ymm8, %ymm0, %ymm2
        vpaddw	%ymm8, %ymm3, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm3, %ymm3
        vpmulhw	%ymm7, %ymm0, %ymm0
        vpmulhw	%ymm7, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm1, %ymm2
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm2, %ymm1, %ymm1
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm1, %ymm1
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm3, %ymm3
        vpmaddwd	%ymm11, %ymm0, %ymm0
        vpmaddwd	%ymm11, %ymm3, %ymm3
        vpsllvd	%ymm12, %ymm0, %ymm0
        vpsllvd	%ymm12, %ymm3, %ymm3
        vpsrldq	$8, %ymm0, %ymm1
        vpsrldq	$8, %ymm3, %ymm4
        vpsrlvq	%ymm13, %ymm0, %ymm0
        vpsrlvq	%ymm13, %ymm3, %ymm3
        vpsllq	$34, %ymm1, %ymm1
        vpsllq	$34, %ymm4, %ymm4
        vpaddq	%ymm1, %ymm0, %ymm0
        vpaddq	%ymm4, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm1
        vextracti128	$0x01, %ymm3, %xmm4
        vpblendvb	%xmm14, %xmm1, %xmm0, %xmm0
        vpblendvb	%xmm14, %xmm4, %xmm3, %xmm3
        vmovdqu	%xmm0, 264(%rdi)
        vmovq	%xmm1, 280(%rdi)
        vmovdqu	%xmm3, 286(%rdi)
        vmovq	%xmm4, 302(%rdi)
        vmovdqu	448(%rsi), %ymm0
        vmovdqu	480(%rsi), %ymm3
        vpmullw	%ymm6, %ymm0, %ymm1
        vpmullw	%ymm6, %ymm3, %ymm4
        vpaddw	%ymm8, %ymm0, %ymm2
        vpaddw	%ymm8, %ymm3, %ymm5
        vpsllw	$3, %ymm0, %ymm0
        vpsllw	$3, %ymm3, %ymm3
        vpmulhw	%ymm7, %ymm0, %ymm0
        vpmulhw	%ymm7, %ymm3, %ymm3
        vpsubw	%ymm2, %ymm1, %ymm2
        vpsubw	%ymm5, %ymm4, %ymm5
        vpandn	%ymm2, %ymm1, %ymm1
        vpandn	%ymm5, %ymm4, %ymm4
        vpsrlw	$15, %ymm1, %ymm1
        vpsrlw	$15, %ymm4, %ymm4
        vpsubw	%ymm1, %ymm0, %ymm0
        vpsubw	%ymm4, %ymm3, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm3, %ymm3
        vpmaddwd	%ymm11, %ymm0, %ymm0
        vpmaddwd	%ymm11, %ymm3, %ymm3
        vpsllvd	%ymm12, %ymm0, %ymm0
        vpsllvd	%ymm12, %ymm3, %ymm3
        vpsrldq	$8, %ymm0, %ymm1
        vpsrldq	$8, %ymm3, %ymm4
        vpsrlvq	%ymm13, %ymm0, %ymm0
        vpsrlvq	%ymm13, %ymm3, %ymm3
        vpsllq	$34, %ymm1, %ymm1
        vpsllq	$34, %ymm4, %ymm4
        vpaddq	%ymm1, %ymm0, %ymm0
        vpaddq	%ymm4, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm1
        vextracti128	$0x01, %ymm3, %xmm4
        vpblendvb	%xmm14, %xmm1, %xmm0, %xmm0
        vpblendvb	%xmm14, %xmm4, %xmm3, %xmm3
        vmovdqu	%xmm0, 308(%rdi)
        vmovq	%xmm1, 324(%rdi)
        vmovdqu	%xmm3, 330(%rdi)
        vmovq	%xmm4, 346(%rdi)
        addq	$0x160, %rdi
        addq	$0x200, %rsi
        subl	$0x01, %edx
        jg	L_kyber_compress_11_avx2_start
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_compress_11_avx2,.-kyber_compress_11_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_11_avx2_q:
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_11_avx2_shuf:
.value	0x100,0x201
.value	0x302,0x504
.value	0x605,0x706
.value	0x908,0xa09
.value	0x403,0x504
.value	0x605,0x807
.value	0x908,0xa09
.value	0xc0b,0xd0c
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_decompress_11_avx2_sllv:
.long	0x0,0x1,0x0,0x0
.long	0x0,0x1,0x0,0x0
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_decompress_11_avx2_srlv:
.quad	0x0, 0x2
.quad	0x0, 0x2
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_11_avx2_shift:
.value	0x20,0x4
.value	0x1,0x20
.value	0x8,0x1
.value	0x20,0x4
.value	0x20,0x4
.value	0x1,0x20
.value	0x8,0x1
.value	0x20,0x4
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_11_avx2_mask:
.value	0x7ff0,0x7ff0
.value	0x7ff0,0x7ff0
.value	0x7ff0,0x7ff0
.value	0x7ff0,0x7ff0
.value	0x7ff0,0x7ff0
.value	0x7ff0,0x7ff0
.value	0x7ff0,0x7ff0
.value	0x7ff0,0x7ff0
#ifndef __APPLE__
.text
.globl	kyber_decompress_11_avx2
.type	kyber_decompress_11_avx2,@function
.align	16
kyber_decompress_11_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_decompress_11_avx2
.p2align	4
_kyber_decompress_11_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_kyber_decompress_11_avx2_q(%rip), %ymm4
        vmovdqu	L_kyber_decompress_11_avx2_shuf(%rip), %ymm5
        vmovdqu	L_kyber_decompress_11_avx2_sllv(%rip), %ymm6
        vmovdqu	L_kyber_decompress_11_avx2_srlv(%rip), %ymm7
        vmovdqu	L_kyber_decompress_11_avx2_shift(%rip), %ymm8
        vmovdqu	L_kyber_decompress_11_avx2_mask(%rip), %ymm9
L_kyber_decompress_11_avx2_start:
        vpermq	$0x94, (%rsi), %ymm0
        vpermq	$0x94, 22(%rsi), %ymm1
        vpermq	$0x94, 44(%rsi), %ymm2
        vpermq	$0x94, 66(%rsi), %ymm3
        vpshufb	%ymm5, %ymm0, %ymm0
        vpshufb	%ymm5, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm2, %ymm2
        vpshufb	%ymm5, %ymm3, %ymm3
        vpsrlvd	%ymm6, %ymm0, %ymm0
        vpsrlvd	%ymm6, %ymm1, %ymm1
        vpsrlvd	%ymm6, %ymm2, %ymm2
        vpsrlvd	%ymm6, %ymm3, %ymm3
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm1, %ymm1
        vpsrlvq	%ymm7, %ymm2, %ymm2
        vpsrlvq	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm8, %ymm0, %ymm0
        vpmullw	%ymm8, %ymm1, %ymm1
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsrlw	$0x01, %ymm0, %ymm0
        vpsrlw	$0x01, %ymm1, %ymm1
        vpsrlw	$0x01, %ymm2, %ymm2
        vpsrlw	$0x01, %ymm3, %ymm3
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpand	%ymm9, %ymm2, %ymm2
        vpand	%ymm9, %ymm3, %ymm3
        vpmulhrsw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm4, %ymm2, %ymm2
        vpmulhrsw	%ymm4, %ymm3, %ymm3
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vpermq	$0x94, 88(%rsi), %ymm0
        vpermq	$0x94, 110(%rsi), %ymm1
        vpermq	$0x94, 132(%rsi), %ymm2
        vpermq	$0x94, 154(%rsi), %ymm3
        vpshufb	%ymm5, %ymm0, %ymm0
        vpshufb	%ymm5, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm2, %ymm2
        vpshufb	%ymm5, %ymm3, %ymm3
        vpsrlvd	%ymm6, %ymm0, %ymm0
        vpsrlvd	%ymm6, %ymm1, %ymm1
        vpsrlvd	%ymm6, %ymm2, %ymm2
        vpsrlvd	%ymm6, %ymm3, %ymm3
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm1, %ymm1
        vpsrlvq	%ymm7, %ymm2, %ymm2
        vpsrlvq	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm8, %ymm0, %ymm0
        vpmullw	%ymm8, %ymm1, %ymm1
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsrlw	$0x01, %ymm0, %ymm0
        vpsrlw	$0x01, %ymm1, %ymm1
        vpsrlw	$0x01, %ymm2, %ymm2
        vpsrlw	$0x01, %ymm3, %ymm3
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpand	%ymm9, %ymm2, %ymm2
        vpand	%ymm9, %ymm3, %ymm3
        vpmulhrsw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm4, %ymm2, %ymm2
        vpmulhrsw	%ymm4, %ymm3, %ymm3
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, 160(%rdi)
        vmovdqu	%ymm2, 192(%rdi)
        vmovdqu	%ymm3, 224(%rdi)
        vpermq	$0x94, 176(%rsi), %ymm0
        vpermq	$0x94, 198(%rsi), %ymm1
        vpermq	$0x94, 220(%rsi), %ymm2
        vpermq	$0x94, 242(%rsi), %ymm3
        vpshufb	%ymm5, %ymm0, %ymm0
        vpshufb	%ymm5, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm2, %ymm2
        vpshufb	%ymm5, %ymm3, %ymm3
        vpsrlvd	%ymm6, %ymm0, %ymm0
        vpsrlvd	%ymm6, %ymm1, %ymm1
        vpsrlvd	%ymm6, %ymm2, %ymm2
        vpsrlvd	%ymm6, %ymm3, %ymm3
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm1, %ymm1
        vpsrlvq	%ymm7, %ymm2, %ymm2
        vpsrlvq	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm8, %ymm0, %ymm0
        vpmullw	%ymm8, %ymm1, %ymm1
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsrlw	$0x01, %ymm0, %ymm0
        vpsrlw	$0x01, %ymm1, %ymm1
        vpsrlw	$0x01, %ymm2, %ymm2
        vpsrlw	$0x01, %ymm3, %ymm3
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpand	%ymm9, %ymm2, %ymm2
        vpand	%ymm9, %ymm3, %ymm3
        vpmulhrsw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm4, %ymm2, %ymm2
        vpmulhrsw	%ymm4, %ymm3, %ymm3
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vpermq	$0x94, 264(%rsi), %ymm0
        vpermq	$0x94, 286(%rsi), %ymm1
        vpermq	$0x94, 308(%rsi), %ymm2
        vpermq	$0x94, 330(%rsi), %ymm3
        vpshufb	%ymm5, %ymm0, %ymm0
        vpshufb	%ymm5, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm2, %ymm2
        vpshufb	%ymm5, %ymm3, %ymm3
        vpsrlvd	%ymm6, %ymm0, %ymm0
        vpsrlvd	%ymm6, %ymm1, %ymm1
        vpsrlvd	%ymm6, %ymm2, %ymm2
        vpsrlvd	%ymm6, %ymm3, %ymm3
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm1, %ymm1
        vpsrlvq	%ymm7, %ymm2, %ymm2
        vpsrlvq	%ymm7, %ymm3, %ymm3
        vpmullw	%ymm8, %ymm0, %ymm0
        vpmullw	%ymm8, %ymm1, %ymm1
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsrlw	$0x01, %ymm0, %ymm0
        vpsrlw	$0x01, %ymm1, %ymm1
        vpsrlw	$0x01, %ymm2, %ymm2
        vpsrlw	$0x01, %ymm3, %ymm3
        vpand	%ymm9, %ymm0, %ymm0
        vpand	%ymm9, %ymm1, %ymm1
        vpand	%ymm9, %ymm2, %ymm2
        vpand	%ymm9, %ymm3, %ymm3
        vpmulhrsw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm4, %ymm1, %ymm1
        vpmulhrsw	%ymm4, %ymm2, %ymm2
        vpmulhrsw	%ymm4, %ymm3, %ymm3
        vmovdqu	%ymm0, 384(%rdi)
        vmovdqu	%ymm1, 416(%rdi)
        vmovdqu	%ymm2, 448(%rdi)
        vmovdqu	%ymm3, 480(%rdi)
        addq	$0x160, %rsi
        addq	$0x200, %rdi
        subl	$0x01, %edx
        jg	L_kyber_decompress_11_avx2_start
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_decompress_11_avx2,.-kyber_decompress_11_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_4_avx2_mask:
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
.value	0xf,0xf
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_4_avx2_shift:
.value	0x200,0x200
.value	0x200,0x200
.value	0x200,0x200
.value	0x200,0x200
.value	0x200,0x200
.value	0x200,0x200
.value	0x200,0x200
.value	0x200,0x200
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_compress_4_avx2_perm:
.long	0x0,0x4,0x1,0x5
.long	0x2,0x6,0x3,0x7
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_4_avx2_v:
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_4_avx2_shift12:
.value	0x1001,0x1001
.value	0x1001,0x1001
.value	0x1001,0x1001
.value	0x1001,0x1001
.value	0x1001,0x1001
.value	0x1001,0x1001
.value	0x1001,0x1001
.value	0x1001,0x1001
#ifndef __APPLE__
.text
.globl	kyber_compress_4_avx2
.type	kyber_compress_4_avx2,@function
.align	16
kyber_compress_4_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_compress_4_avx2
.p2align	4
_kyber_compress_4_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_kyber_compress_4_avx2_mask(%rip), %ymm8
        vmovdqu	L_kyber_compress_4_avx2_shift(%rip), %ymm9
        vmovdqu	L_kyber_compress_4_avx2_perm(%rip), %ymm10
        vmovdqu	L_kyber_compress_4_avx2_v(%rip), %ymm11
        vmovdqu	L_kyber_compress_4_avx2_shift12(%rip), %ymm12
        vpmulhw	(%rsi), %ymm11, %ymm0
        vpmulhw	32(%rsi), %ymm11, %ymm1
        vpmulhw	64(%rsi), %ymm11, %ymm2
        vpmulhw	96(%rsi), %ymm11, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm1, %ymm1
        vpmulhrsw	%ymm9, %ymm2, %ymm2
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpackuswb	%ymm3, %ymm2, %ymm2
        vpmaddubsw	%ymm12, %ymm0, %ymm0
        vpmaddubsw	%ymm12, %ymm2, %ymm2
        vpackuswb	%ymm2, %ymm0, %ymm0
        vpmulhw	128(%rsi), %ymm11, %ymm4
        vpmulhw	160(%rsi), %ymm11, %ymm5
        vpmulhw	192(%rsi), %ymm11, %ymm6
        vpmulhw	224(%rsi), %ymm11, %ymm7
        vpmulhrsw	%ymm9, %ymm4, %ymm4
        vpmulhrsw	%ymm9, %ymm5, %ymm5
        vpmulhrsw	%ymm9, %ymm6, %ymm6
        vpmulhrsw	%ymm9, %ymm7, %ymm7
        vpand	%ymm8, %ymm4, %ymm4
        vpand	%ymm8, %ymm5, %ymm5
        vpand	%ymm8, %ymm6, %ymm6
        vpand	%ymm8, %ymm7, %ymm7
        vpackuswb	%ymm5, %ymm4, %ymm4
        vpackuswb	%ymm7, %ymm6, %ymm6
        vpmaddubsw	%ymm12, %ymm4, %ymm4
        vpmaddubsw	%ymm12, %ymm6, %ymm6
        vpackuswb	%ymm6, %ymm4, %ymm4
        vpermd	%ymm0, %ymm10, %ymm0
        vpermd	%ymm4, %ymm10, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm4, 32(%rdi)
        vpmulhw	256(%rsi), %ymm11, %ymm0
        vpmulhw	288(%rsi), %ymm11, %ymm1
        vpmulhw	320(%rsi), %ymm11, %ymm2
        vpmulhw	352(%rsi), %ymm11, %ymm3
        vpmulhrsw	%ymm9, %ymm0, %ymm0
        vpmulhrsw	%ymm9, %ymm1, %ymm1
        vpmulhrsw	%ymm9, %ymm2, %ymm2
        vpmulhrsw	%ymm9, %ymm3, %ymm3
        vpand	%ymm8, %ymm0, %ymm0
        vpand	%ymm8, %ymm1, %ymm1
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpackuswb	%ymm3, %ymm2, %ymm2
        vpmaddubsw	%ymm12, %ymm0, %ymm0
        vpmaddubsw	%ymm12, %ymm2, %ymm2
        vpackuswb	%ymm2, %ymm0, %ymm0
        vpmulhw	384(%rsi), %ymm11, %ymm4
        vpmulhw	416(%rsi), %ymm11, %ymm5
        vpmulhw	448(%rsi), %ymm11, %ymm6
        vpmulhw	480(%rsi), %ymm11, %ymm7
        vpmulhrsw	%ymm9, %ymm4, %ymm4
        vpmulhrsw	%ymm9, %ymm5, %ymm5
        vpmulhrsw	%ymm9, %ymm6, %ymm6
        vpmulhrsw	%ymm9, %ymm7, %ymm7
        vpand	%ymm8, %ymm4, %ymm4
        vpand	%ymm8, %ymm5, %ymm5
        vpand	%ymm8, %ymm6, %ymm6
        vpand	%ymm8, %ymm7, %ymm7
        vpackuswb	%ymm5, %ymm4, %ymm4
        vpackuswb	%ymm7, %ymm6, %ymm6
        vpmaddubsw	%ymm12, %ymm4, %ymm4
        vpmaddubsw	%ymm12, %ymm6, %ymm6
        vpackuswb	%ymm6, %ymm4, %ymm4
        vpermd	%ymm0, %ymm10, %ymm0
        vpermd	%ymm4, %ymm10, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm4, 96(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_compress_4_avx2,.-kyber_compress_4_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_decompress_4_avx2_mask:
.long	0xf0000f,0xf0000f,0xf0000f,0xf0000f
.long	0xf0000f,0xf0000f,0xf0000f,0xf0000f
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_decompress_4_avx2_shift:
.long	0x800800,0x800800,0x800800,0x800800
.long	0x800800,0x800800,0x800800,0x800800
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_4_avx2_q:
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_4_avx2_shuf:
.value	0x0,0x0
.value	0x101,0x101
.value	0x202,0x202
.value	0x303,0x303
.value	0x404,0x404
.value	0x505,0x505
.value	0x606,0x606
.value	0x707,0x707
#ifndef __APPLE__
.text
.globl	kyber_decompress_4_avx2
.type	kyber_decompress_4_avx2,@function
.align	16
kyber_decompress_4_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_decompress_4_avx2
.p2align	4
_kyber_decompress_4_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_kyber_decompress_4_avx2_mask(%rip), %ymm4
        vmovdqu	L_kyber_decompress_4_avx2_shift(%rip), %ymm5
        vmovdqu	L_kyber_decompress_4_avx2_shuf(%rip), %ymm6
        vmovdqu	L_kyber_decompress_4_avx2_q(%rip), %ymm7
        vpbroadcastq	(%rsi), %ymm0
        vpbroadcastq	8(%rsi), %ymm1
        vpbroadcastq	16(%rsi), %ymm2
        vpbroadcastq	24(%rsi), %ymm3
        vpshufb	%ymm6, %ymm0, %ymm0
        vpshufb	%ymm6, %ymm1, %ymm1
        vpshufb	%ymm6, %ymm2, %ymm2
        vpshufb	%ymm6, %ymm3, %ymm3
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpand	%ymm4, %ymm2, %ymm2
        vpand	%ymm4, %ymm3, %ymm3
        vpmullw	%ymm5, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm5, %ymm2, %ymm2
        vpmullw	%ymm5, %ymm3, %ymm3
        vpmulhrsw	%ymm7, %ymm0, %ymm0
        vpmulhrsw	%ymm7, %ymm1, %ymm1
        vpmulhrsw	%ymm7, %ymm2, %ymm2
        vpmulhrsw	%ymm7, %ymm3, %ymm3
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vpbroadcastq	32(%rsi), %ymm0
        vpbroadcastq	40(%rsi), %ymm1
        vpbroadcastq	48(%rsi), %ymm2
        vpbroadcastq	56(%rsi), %ymm3
        vpshufb	%ymm6, %ymm0, %ymm0
        vpshufb	%ymm6, %ymm1, %ymm1
        vpshufb	%ymm6, %ymm2, %ymm2
        vpshufb	%ymm6, %ymm3, %ymm3
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpand	%ymm4, %ymm2, %ymm2
        vpand	%ymm4, %ymm3, %ymm3
        vpmullw	%ymm5, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm5, %ymm2, %ymm2
        vpmullw	%ymm5, %ymm3, %ymm3
        vpmulhrsw	%ymm7, %ymm0, %ymm0
        vpmulhrsw	%ymm7, %ymm1, %ymm1
        vpmulhrsw	%ymm7, %ymm2, %ymm2
        vpmulhrsw	%ymm7, %ymm3, %ymm3
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, 160(%rdi)
        vmovdqu	%ymm2, 192(%rdi)
        vmovdqu	%ymm3, 224(%rdi)
        vpbroadcastq	64(%rsi), %ymm0
        vpbroadcastq	72(%rsi), %ymm1
        vpbroadcastq	80(%rsi), %ymm2
        vpbroadcastq	88(%rsi), %ymm3
        vpshufb	%ymm6, %ymm0, %ymm0
        vpshufb	%ymm6, %ymm1, %ymm1
        vpshufb	%ymm6, %ymm2, %ymm2
        vpshufb	%ymm6, %ymm3, %ymm3
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpand	%ymm4, %ymm2, %ymm2
        vpand	%ymm4, %ymm3, %ymm3
        vpmullw	%ymm5, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm5, %ymm2, %ymm2
        vpmullw	%ymm5, %ymm3, %ymm3
        vpmulhrsw	%ymm7, %ymm0, %ymm0
        vpmulhrsw	%ymm7, %ymm1, %ymm1
        vpmulhrsw	%ymm7, %ymm2, %ymm2
        vpmulhrsw	%ymm7, %ymm3, %ymm3
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vpbroadcastq	96(%rsi), %ymm0
        vpbroadcastq	104(%rsi), %ymm1
        vpbroadcastq	112(%rsi), %ymm2
        vpbroadcastq	120(%rsi), %ymm3
        vpshufb	%ymm6, %ymm0, %ymm0
        vpshufb	%ymm6, %ymm1, %ymm1
        vpshufb	%ymm6, %ymm2, %ymm2
        vpshufb	%ymm6, %ymm3, %ymm3
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpand	%ymm4, %ymm2, %ymm2
        vpand	%ymm4, %ymm3, %ymm3
        vpmullw	%ymm5, %ymm0, %ymm0
        vpmullw	%ymm5, %ymm1, %ymm1
        vpmullw	%ymm5, %ymm2, %ymm2
        vpmullw	%ymm5, %ymm3, %ymm3
        vpmulhrsw	%ymm7, %ymm0, %ymm0
        vpmulhrsw	%ymm7, %ymm1, %ymm1
        vpmulhrsw	%ymm7, %ymm2, %ymm2
        vpmulhrsw	%ymm7, %ymm3, %ymm3
        vmovdqu	%ymm0, 384(%rdi)
        vmovdqu	%ymm1, 416(%rdi)
        vmovdqu	%ymm2, 448(%rdi)
        vmovdqu	%ymm3, 480(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_decompress_4_avx2,.-kyber_decompress_4_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_5_avx2_v:
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
.value	0x4ebf,0x4ebf
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_5_avx2_shift:
.value	0x400,0x400
.value	0x400,0x400
.value	0x400,0x400
.value	0x400,0x400
.value	0x400,0x400
.value	0x400,0x400
.value	0x400,0x400
.value	0x400,0x400
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_5_avx2_mask:
.value	0x1f,0x1f
.value	0x1f,0x1f
.value	0x1f,0x1f
.value	0x1f,0x1f
.value	0x1f,0x1f
.value	0x1f,0x1f
.value	0x1f,0x1f
.value	0x1f,0x1f
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_5_avx2_shift1:
.value	0x2001,0x2001
.value	0x2001,0x2001
.value	0x2001,0x2001
.value	0x2001,0x2001
.value	0x2001,0x2001
.value	0x2001,0x2001
.value	0x2001,0x2001
.value	0x2001,0x2001
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_compress_5_avx2_shift2:
.long	0x4000001,0x4000001,0x4000001,0x4000001
.long	0x4000001,0x4000001,0x4000001,0x4000001
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_kyber_compress_5_avx2_shlv:
.quad	0xc, 0xc
.quad	0xc, 0xc
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_compress_5_avx2_shuffle:
.value	0x100,0x302
.value	0xff04,0xffff
.value	0xffff,0x908
.value	0xb0a,0xff0c
.value	0xa09,0xc0b
.value	0xff,0x201
.value	0x403,0xffff
.value	0xffff,0x8ff
#ifndef __APPLE__
.text
.globl	kyber_compress_5_avx2
.type	kyber_compress_5_avx2,@function
.align	16
kyber_compress_5_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_compress_5_avx2
.p2align	4
_kyber_compress_5_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rsi), %ymm0
        vmovdqu	L_kyber_compress_5_avx2_v(%rip), %ymm2
        vmovdqu	L_kyber_compress_5_avx2_shift(%rip), %ymm3
        vmovdqu	L_kyber_compress_5_avx2_mask(%rip), %ymm4
        vmovdqu	L_kyber_compress_5_avx2_shift1(%rip), %ymm5
        vmovdqu	L_kyber_compress_5_avx2_shift2(%rip), %ymm6
        vmovdqu	L_kyber_compress_5_avx2_shlv(%rip), %ymm7
        vmovdqu	L_kyber_compress_5_avx2_shuffle(%rip), %ymm8
        vpmulhw	(%rsi), %ymm2, %ymm0
        vpmulhw	32(%rsi), %ymm2, %ymm1
        vpmulhrsw	%ymm3, %ymm0, %ymm0
        vpmulhrsw	%ymm3, %ymm1, %ymm1
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpmaddubsw	%ymm5, %ymm0, %ymm0
        vpmaddwd	%ymm6, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm1
        vpblendvb	%xmm8, %xmm1, %xmm0, %xmm0
        vmovdqu	%xmm0, (%rdi)
        movss	%xmm1, 16(%rdi)
        vpmulhw	64(%rsi), %ymm2, %ymm0
        vpmulhw	96(%rsi), %ymm2, %ymm1
        vpmulhrsw	%ymm3, %ymm0, %ymm0
        vpmulhrsw	%ymm3, %ymm1, %ymm1
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpmaddubsw	%ymm5, %ymm0, %ymm0
        vpmaddwd	%ymm6, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm1
        vpblendvb	%xmm8, %xmm1, %xmm0, %xmm0
        vmovdqu	%xmm0, 20(%rdi)
        movss	%xmm1, 36(%rdi)
        vpmulhw	128(%rsi), %ymm2, %ymm0
        vpmulhw	160(%rsi), %ymm2, %ymm1
        vpmulhrsw	%ymm3, %ymm0, %ymm0
        vpmulhrsw	%ymm3, %ymm1, %ymm1
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpmaddubsw	%ymm5, %ymm0, %ymm0
        vpmaddwd	%ymm6, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm1
        vpblendvb	%xmm8, %xmm1, %xmm0, %xmm0
        vmovdqu	%xmm0, 40(%rdi)
        movss	%xmm1, 56(%rdi)
        vpmulhw	192(%rsi), %ymm2, %ymm0
        vpmulhw	224(%rsi), %ymm2, %ymm1
        vpmulhrsw	%ymm3, %ymm0, %ymm0
        vpmulhrsw	%ymm3, %ymm1, %ymm1
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpmaddubsw	%ymm5, %ymm0, %ymm0
        vpmaddwd	%ymm6, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm1
        vpblendvb	%xmm8, %xmm1, %xmm0, %xmm0
        vmovdqu	%xmm0, 60(%rdi)
        movss	%xmm1, 76(%rdi)
        vpmulhw	256(%rsi), %ymm2, %ymm0
        vpmulhw	288(%rsi), %ymm2, %ymm1
        vpmulhrsw	%ymm3, %ymm0, %ymm0
        vpmulhrsw	%ymm3, %ymm1, %ymm1
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpmaddubsw	%ymm5, %ymm0, %ymm0
        vpmaddwd	%ymm6, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm1
        vpblendvb	%xmm8, %xmm1, %xmm0, %xmm0
        vmovdqu	%xmm0, 80(%rdi)
        movss	%xmm1, 96(%rdi)
        vpmulhw	320(%rsi), %ymm2, %ymm0
        vpmulhw	352(%rsi), %ymm2, %ymm1
        vpmulhrsw	%ymm3, %ymm0, %ymm0
        vpmulhrsw	%ymm3, %ymm1, %ymm1
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpmaddubsw	%ymm5, %ymm0, %ymm0
        vpmaddwd	%ymm6, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm1
        vpblendvb	%xmm8, %xmm1, %xmm0, %xmm0
        vmovdqu	%xmm0, 100(%rdi)
        movss	%xmm1, 116(%rdi)
        vpmulhw	384(%rsi), %ymm2, %ymm0
        vpmulhw	416(%rsi), %ymm2, %ymm1
        vpmulhrsw	%ymm3, %ymm0, %ymm0
        vpmulhrsw	%ymm3, %ymm1, %ymm1
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpmaddubsw	%ymm5, %ymm0, %ymm0
        vpmaddwd	%ymm6, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm1
        vpblendvb	%xmm8, %xmm1, %xmm0, %xmm0
        vmovdqu	%xmm0, 120(%rdi)
        movss	%xmm1, 136(%rdi)
        vpmulhw	448(%rsi), %ymm2, %ymm0
        vpmulhw	480(%rsi), %ymm2, %ymm1
        vpmulhrsw	%ymm3, %ymm0, %ymm0
        vpmulhrsw	%ymm3, %ymm1, %ymm1
        vpand	%ymm4, %ymm0, %ymm0
        vpand	%ymm4, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpmaddubsw	%ymm5, %ymm0, %ymm0
        vpmaddwd	%ymm6, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsrlvq	%ymm7, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm1
        vpblendvb	%xmm8, %xmm1, %xmm0, %xmm0
        vmovdqu	%xmm0, 140(%rdi)
        movss	%xmm1, 156(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_compress_5_avx2,.-kyber_compress_5_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_5_avx2_q:
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
.value	0xd01,0xd01
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_5_avx2_shuf:
.value	0x0,0x100
.value	0x101,0x201
.value	0x302,0x303
.value	0x403,0x404
.value	0x505,0x605
.value	0x606,0x706
.value	0x807,0x808
.value	0x908,0x909
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_5_avx2_mask:
.value	0x1f,0x3e0
.value	0x7c,0xf80
.value	0x1f0,0x3e
.value	0x7c0,0xfb
.value	0x1f,0x3e0
.value	0x7c,0xf80
.value	0x1f0,0x3e
.value	0x7c0,0xfb
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_decompress_5_avx2_shift:
.value	0x400,0x20
.value	0x100,0x8
.value	0x40,0x200
.value	0x10,0x80
.value	0x400,0x20
.value	0x100,0x8
.value	0x40,0x200
.value	0x10,0x80
#ifndef __APPLE__
.text
.globl	kyber_decompress_5_avx2
.type	kyber_decompress_5_avx2,@function
.align	16
kyber_decompress_5_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_decompress_5_avx2
.p2align	4
_kyber_decompress_5_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_kyber_decompress_5_avx2_q(%rip), %ymm1
        vmovdqu	L_kyber_decompress_5_avx2_shuf(%rip), %ymm2
        vmovdqu	L_kyber_decompress_5_avx2_mask(%rip), %ymm3
        vmovdqu	L_kyber_decompress_5_avx2_shift(%rip), %ymm4
        vbroadcasti128	(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, (%rdi)
        vbroadcasti128	10(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 32(%rdi)
        vbroadcasti128	20(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 64(%rdi)
        vbroadcasti128	30(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 96(%rdi)
        vbroadcasti128	40(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 128(%rdi)
        vbroadcasti128	50(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 160(%rdi)
        vbroadcasti128	60(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 192(%rdi)
        vbroadcasti128	70(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 224(%rdi)
        vbroadcasti128	80(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 256(%rdi)
        vbroadcasti128	90(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 288(%rdi)
        vbroadcasti128	100(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 320(%rdi)
        vbroadcasti128	110(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 352(%rdi)
        vbroadcasti128	120(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 384(%rdi)
        vbroadcasti128	130(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 416(%rdi)
        vbroadcasti128	140(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 448(%rdi)
        vbroadcasti128	150(%rsi), %ymm0
        vpshufb	%ymm2, %ymm0, %ymm0
        vpand	%ymm3, %ymm0, %ymm0
        vpmullw	%ymm4, %ymm0, %ymm0
        vpmulhrsw	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 480(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_decompress_5_avx2,.-kyber_decompress_5_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_from_msg_avx2_shift:
.long	0x3,0x2,0x1,0x0
.long	0x3,0x2,0x1,0x0
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_from_msg_avx2_shuf:
.value	0x100,0x504
.value	0x908,0xd0c
.value	0x302,0x706
.value	0xb0a,0xf0e
.value	0x100,0x504
.value	0x908,0xd0c
.value	0x302,0x706
.value	0xb0a,0xf0e
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_from_msg_avx2_hqs:
.value	0x681,0x681
.value	0x681,0x681
.value	0x681,0x681
.value	0x681,0x681
.value	0x681,0x681
.value	0x681,0x681
.value	0x681,0x681
.value	0x681,0x681
#ifndef __APPLE__
.text
.globl	kyber_from_msg_avx2
.type	kyber_from_msg_avx2,@function
.align	16
kyber_from_msg_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_from_msg_avx2
.p2align	4
_kyber_from_msg_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rsi), %ymm0
        vmovdqu	L_kyber_from_msg_avx2_shift(%rip), %ymm9
        vmovdqu	L_kyber_from_msg_avx2_shuf(%rip), %ymm10
        vmovdqu	L_kyber_from_msg_avx2_hqs(%rip), %ymm11
        vpshufd	$0x00, %ymm0, %ymm4
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpshufb	%ymm10, %ymm4, %ymm4
        vpsllw	$12, %ymm4, %ymm1
        vpsllw	$8, %ymm4, %ymm2
        vpsllw	$4, %ymm4, %ymm3
        vpsraw	$15, %ymm1, %ymm1
        vpsraw	$15, %ymm2, %ymm2
        vpsraw	$15, %ymm3, %ymm3
        vpsraw	$15, %ymm4, %ymm4
        vpand	%ymm11, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpand	%ymm11, %ymm4, %ymm4
        vpunpcklqdq	%ymm2, %ymm1, %ymm5
        vpunpckhqdq	%ymm2, %ymm1, %ymm7
        vpunpcklqdq	%ymm4, %ymm3, %ymm6
        vpunpckhqdq	%ymm4, %ymm3, %ymm8
        vperm2i128	$32, %ymm6, %ymm5, %ymm1
        vperm2i128	$49, %ymm6, %ymm5, %ymm3
        vperm2i128	$32, %ymm8, %ymm7, %ymm2
        vperm2i128	$49, %ymm8, %ymm7, %ymm4
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, 256(%rdi)
        vmovdqu	%ymm4, 288(%rdi)
        vpshufd	$0x55, %ymm0, %ymm4
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpshufb	%ymm10, %ymm4, %ymm4
        vpsllw	$12, %ymm4, %ymm1
        vpsllw	$8, %ymm4, %ymm2
        vpsllw	$4, %ymm4, %ymm3
        vpsraw	$15, %ymm1, %ymm1
        vpsraw	$15, %ymm2, %ymm2
        vpsraw	$15, %ymm3, %ymm3
        vpsraw	$15, %ymm4, %ymm4
        vpand	%ymm11, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpand	%ymm11, %ymm4, %ymm4
        vpunpcklqdq	%ymm2, %ymm1, %ymm5
        vpunpckhqdq	%ymm2, %ymm1, %ymm7
        vpunpcklqdq	%ymm4, %ymm3, %ymm6
        vpunpckhqdq	%ymm4, %ymm3, %ymm8
        vperm2i128	$32, %ymm6, %ymm5, %ymm1
        vperm2i128	$49, %ymm6, %ymm5, %ymm3
        vperm2i128	$32, %ymm8, %ymm7, %ymm2
        vperm2i128	$49, %ymm8, %ymm7, %ymm4
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, 320(%rdi)
        vmovdqu	%ymm4, 352(%rdi)
        vpshufd	$0xaa, %ymm0, %ymm4
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpshufb	%ymm10, %ymm4, %ymm4
        vpsllw	$12, %ymm4, %ymm1
        vpsllw	$8, %ymm4, %ymm2
        vpsllw	$4, %ymm4, %ymm3
        vpsraw	$15, %ymm1, %ymm1
        vpsraw	$15, %ymm2, %ymm2
        vpsraw	$15, %ymm3, %ymm3
        vpsraw	$15, %ymm4, %ymm4
        vpand	%ymm11, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpand	%ymm11, %ymm4, %ymm4
        vpunpcklqdq	%ymm2, %ymm1, %ymm5
        vpunpckhqdq	%ymm2, %ymm1, %ymm7
        vpunpcklqdq	%ymm4, %ymm3, %ymm6
        vpunpckhqdq	%ymm4, %ymm3, %ymm8
        vperm2i128	$32, %ymm6, %ymm5, %ymm1
        vperm2i128	$49, %ymm6, %ymm5, %ymm3
        vperm2i128	$32, %ymm8, %ymm7, %ymm2
        vperm2i128	$49, %ymm8, %ymm7, %ymm4
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, 160(%rdi)
        vmovdqu	%ymm3, 384(%rdi)
        vmovdqu	%ymm4, 416(%rdi)
        vpshufd	$0xff, %ymm0, %ymm4
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpshufb	%ymm10, %ymm4, %ymm4
        vpsllw	$12, %ymm4, %ymm1
        vpsllw	$8, %ymm4, %ymm2
        vpsllw	$4, %ymm4, %ymm3
        vpsraw	$15, %ymm1, %ymm1
        vpsraw	$15, %ymm2, %ymm2
        vpsraw	$15, %ymm3, %ymm3
        vpsraw	$15, %ymm4, %ymm4
        vpand	%ymm11, %ymm1, %ymm1
        vpand	%ymm11, %ymm2, %ymm2
        vpand	%ymm11, %ymm3, %ymm3
        vpand	%ymm11, %ymm4, %ymm4
        vpunpcklqdq	%ymm2, %ymm1, %ymm5
        vpunpckhqdq	%ymm2, %ymm1, %ymm7
        vpunpcklqdq	%ymm4, %ymm3, %ymm6
        vpunpckhqdq	%ymm4, %ymm3, %ymm8
        vperm2i128	$32, %ymm6, %ymm5, %ymm1
        vperm2i128	$49, %ymm6, %ymm5, %ymm3
        vperm2i128	$32, %ymm8, %ymm7, %ymm2
        vperm2i128	$49, %ymm8, %ymm7, %ymm4
        vmovdqu	%ymm1, 192(%rdi)
        vmovdqu	%ymm2, 224(%rdi)
        vmovdqu	%ymm3, 448(%rdi)
        vmovdqu	%ymm4, 480(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_from_msg_avx2,.-kyber_from_msg_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_to_msg_avx2_hqs:
.value	0x680,0x680
.value	0x680,0x680
.value	0x680,0x680
.value	0x680,0x680
.value	0x680,0x680
.value	0x680,0x680
.value	0x680,0x680
.value	0x680,0x680
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_to_msg_avx2_hhqs:
.value	0xfcc1,0xfcc1
.value	0xfcc1,0xfcc1
.value	0xfcc1,0xfcc1
.value	0xfcc1,0xfcc1
.value	0xfcc1,0xfcc1
.value	0xfcc1,0xfcc1
.value	0xfcc1,0xfcc1
.value	0xfcc1,0xfcc1
#ifndef __APPLE__
.text
.globl	kyber_to_msg_avx2
.type	kyber_to_msg_avx2,@function
.align	16
kyber_to_msg_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_to_msg_avx2
.p2align	4
_kyber_to_msg_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_kyber_to_msg_avx2_hqs(%rip), %ymm8
        vmovdqu	L_kyber_to_msg_avx2_hhqs(%rip), %ymm9
        vpsubw	(%rsi), %ymm8, %ymm0
        vpsubw	32(%rsi), %ymm8, %ymm1
        vpsubw	64(%rsi), %ymm8, %ymm2
        vpsubw	96(%rsi), %ymm8, %ymm3
        vpsraw	$15, %ymm0, %ymm4
        vpsraw	$15, %ymm1, %ymm5
        vpsraw	$15, %ymm2, %ymm6
        vpsraw	$15, %ymm3, %ymm7
        vpxor	%ymm4, %ymm0, %ymm0
        vpxor	%ymm5, %ymm1, %ymm1
        vpxor	%ymm6, %ymm2, %ymm2
        vpxor	%ymm7, %ymm3, %ymm3
        vpaddw	%ymm9, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpaddw	%ymm9, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vpacksswb	%ymm1, %ymm0, %ymm0
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm0, %edx
        vpmovmskb	%ymm2, %eax
        movl	%edx, (%rdi)
        movl	%eax, 4(%rdi)
        vpsubw	128(%rsi), %ymm8, %ymm0
        vpsubw	160(%rsi), %ymm8, %ymm1
        vpsubw	192(%rsi), %ymm8, %ymm2
        vpsubw	224(%rsi), %ymm8, %ymm3
        vpsraw	$15, %ymm0, %ymm4
        vpsraw	$15, %ymm1, %ymm5
        vpsraw	$15, %ymm2, %ymm6
        vpsraw	$15, %ymm3, %ymm7
        vpxor	%ymm4, %ymm0, %ymm0
        vpxor	%ymm5, %ymm1, %ymm1
        vpxor	%ymm6, %ymm2, %ymm2
        vpxor	%ymm7, %ymm3, %ymm3
        vpaddw	%ymm9, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpaddw	%ymm9, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vpacksswb	%ymm1, %ymm0, %ymm0
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm0, %edx
        vpmovmskb	%ymm2, %eax
        movl	%edx, 8(%rdi)
        movl	%eax, 12(%rdi)
        vpsubw	256(%rsi), %ymm8, %ymm0
        vpsubw	288(%rsi), %ymm8, %ymm1
        vpsubw	320(%rsi), %ymm8, %ymm2
        vpsubw	352(%rsi), %ymm8, %ymm3
        vpsraw	$15, %ymm0, %ymm4
        vpsraw	$15, %ymm1, %ymm5
        vpsraw	$15, %ymm2, %ymm6
        vpsraw	$15, %ymm3, %ymm7
        vpxor	%ymm4, %ymm0, %ymm0
        vpxor	%ymm5, %ymm1, %ymm1
        vpxor	%ymm6, %ymm2, %ymm2
        vpxor	%ymm7, %ymm3, %ymm3
        vpaddw	%ymm9, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpaddw	%ymm9, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vpacksswb	%ymm1, %ymm0, %ymm0
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm0, %edx
        vpmovmskb	%ymm2, %eax
        movl	%edx, 16(%rdi)
        movl	%eax, 20(%rdi)
        vpsubw	384(%rsi), %ymm8, %ymm0
        vpsubw	416(%rsi), %ymm8, %ymm1
        vpsubw	448(%rsi), %ymm8, %ymm2
        vpsubw	480(%rsi), %ymm8, %ymm3
        vpsraw	$15, %ymm0, %ymm4
        vpsraw	$15, %ymm1, %ymm5
        vpsraw	$15, %ymm2, %ymm6
        vpsraw	$15, %ymm3, %ymm7
        vpxor	%ymm4, %ymm0, %ymm0
        vpxor	%ymm5, %ymm1, %ymm1
        vpxor	%ymm6, %ymm2, %ymm2
        vpxor	%ymm7, %ymm3, %ymm3
        vpaddw	%ymm9, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpaddw	%ymm9, %ymm2, %ymm2
        vpaddw	%ymm9, %ymm3, %ymm3
        vpacksswb	%ymm1, %ymm0, %ymm0
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm0, %edx
        vpmovmskb	%ymm2, %eax
        movl	%edx, 24(%rdi)
        movl	%eax, 28(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_to_msg_avx2,.-kyber_to_msg_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_from_bytes_avx2_shuf:
.value	0x100,0xff02
.value	0x403,0xff05
.value	0x706,0xff08
.value	0xa09,0xff0b
.value	0x504,0xff06
.value	0x807,0xff09
.value	0xb0a,0xff0c
.value	0xe0d,0xff0f
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_from_bytes_avx2_mask:
.long	0xfff,0xfff,0xfff,0xfff
.long	0xfff,0xfff,0xfff,0xfff
#ifndef __APPLE__
.text
.globl	kyber_from_bytes_avx2
.type	kyber_from_bytes_avx2,@function
.align	16
kyber_from_bytes_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_from_bytes_avx2
.p2align	4
_kyber_from_bytes_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rsi), %ymm0
        vmovdqu	L_kyber_from_bytes_avx2_shuf(%rip), %ymm12
        vmovdqu	L_kyber_from_bytes_avx2_mask(%rip), %ymm13
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vmovdqu	64(%rsi), %ymm2
        vmovdqu	96(%rsi), %ymm3
        vmovdqu	128(%rsi), %ymm4
        vmovdqu	160(%rsi), %ymm5
        vpermq	$0xe9, %ymm5, %ymm7
        vpermq	$0x00, %ymm5, %ymm8
        vpermq	$62, %ymm4, %ymm6
        vpermq	$0x40, %ymm4, %ymm9
        vpermq	$3, %ymm3, %ymm5
        vpermq	$0x94, %ymm3, %ymm4
        vpermq	$0xe9, %ymm2, %ymm3
        vpermq	$0x00, %ymm2, %ymm10
        vpermq	$62, %ymm1, %ymm2
        vpermq	$0x40, %ymm1, %ymm11
        vpermq	$3, %ymm0, %ymm1
        vpermq	$0x94, %ymm0, %ymm0
        vpblendd	$0xc0, %ymm8, %ymm6, %ymm6
        vpblendd	$0xfc, %ymm9, %ymm5, %ymm5
        vpblendd	$0xc0, %ymm10, %ymm2, %ymm2
        vpblendd	$0xfc, %ymm11, %ymm1, %ymm1
        vpshufb	%ymm12, %ymm0, %ymm0
        vpshufb	%ymm12, %ymm1, %ymm1
        vpshufb	%ymm12, %ymm2, %ymm2
        vpshufb	%ymm12, %ymm3, %ymm3
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpshufb	%ymm12, %ymm6, %ymm6
        vpshufb	%ymm12, %ymm7, %ymm7
        vpandn	%ymm0, %ymm13, %ymm8
        vpandn	%ymm1, %ymm13, %ymm9
        vpandn	%ymm2, %ymm13, %ymm10
        vpandn	%ymm3, %ymm13, %ymm11
        vpand	%ymm0, %ymm13, %ymm0
        vpand	%ymm1, %ymm13, %ymm1
        vpand	%ymm2, %ymm13, %ymm2
        vpand	%ymm3, %ymm13, %ymm3
        vpslld	$4, %ymm8, %ymm8
        vpslld	$4, %ymm9, %ymm9
        vpslld	$4, %ymm10, %ymm10
        vpslld	$4, %ymm11, %ymm11
        vpor	%ymm8, %ymm0, %ymm0
        vpor	%ymm9, %ymm1, %ymm1
        vpor	%ymm10, %ymm2, %ymm2
        vpor	%ymm11, %ymm3, %ymm3
        vpandn	%ymm4, %ymm13, %ymm8
        vpandn	%ymm5, %ymm13, %ymm9
        vpandn	%ymm6, %ymm13, %ymm10
        vpandn	%ymm7, %ymm13, %ymm11
        vpand	%ymm4, %ymm13, %ymm4
        vpand	%ymm5, %ymm13, %ymm5
        vpand	%ymm6, %ymm13, %ymm6
        vpand	%ymm7, %ymm13, %ymm7
        vpslld	$4, %ymm8, %ymm8
        vpslld	$4, %ymm9, %ymm9
        vpslld	$4, %ymm10, %ymm10
        vpslld	$4, %ymm11, %ymm11
        vpor	%ymm8, %ymm4, %ymm4
        vpor	%ymm9, %ymm5, %ymm5
        vpor	%ymm10, %ymm6, %ymm6
        vpor	%ymm11, %ymm7, %ymm7
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        vmovdqu	%ymm5, 160(%rdi)
        vmovdqu	%ymm6, 192(%rdi)
        vmovdqu	%ymm7, 224(%rdi)
        vmovdqu	192(%rsi), %ymm0
        vmovdqu	224(%rsi), %ymm1
        vmovdqu	256(%rsi), %ymm2
        vmovdqu	288(%rsi), %ymm3
        vmovdqu	320(%rsi), %ymm4
        vmovdqu	352(%rsi), %ymm5
        vpermq	$0xe9, %ymm5, %ymm7
        vpermq	$0x00, %ymm5, %ymm8
        vpermq	$62, %ymm4, %ymm6
        vpermq	$0x40, %ymm4, %ymm9
        vpermq	$3, %ymm3, %ymm5
        vpermq	$0x94, %ymm3, %ymm4
        vpermq	$0xe9, %ymm2, %ymm3
        vpermq	$0x00, %ymm2, %ymm10
        vpermq	$62, %ymm1, %ymm2
        vpermq	$0x40, %ymm1, %ymm11
        vpermq	$3, %ymm0, %ymm1
        vpermq	$0x94, %ymm0, %ymm0
        vpblendd	$0xc0, %ymm8, %ymm6, %ymm6
        vpblendd	$0xfc, %ymm9, %ymm5, %ymm5
        vpblendd	$0xc0, %ymm10, %ymm2, %ymm2
        vpblendd	$0xfc, %ymm11, %ymm1, %ymm1
        vpshufb	%ymm12, %ymm0, %ymm0
        vpshufb	%ymm12, %ymm1, %ymm1
        vpshufb	%ymm12, %ymm2, %ymm2
        vpshufb	%ymm12, %ymm3, %ymm3
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpshufb	%ymm12, %ymm6, %ymm6
        vpshufb	%ymm12, %ymm7, %ymm7
        vpandn	%ymm0, %ymm13, %ymm8
        vpandn	%ymm1, %ymm13, %ymm9
        vpandn	%ymm2, %ymm13, %ymm10
        vpandn	%ymm3, %ymm13, %ymm11
        vpand	%ymm0, %ymm13, %ymm0
        vpand	%ymm1, %ymm13, %ymm1
        vpand	%ymm2, %ymm13, %ymm2
        vpand	%ymm3, %ymm13, %ymm3
        vpslld	$4, %ymm8, %ymm8
        vpslld	$4, %ymm9, %ymm9
        vpslld	$4, %ymm10, %ymm10
        vpslld	$4, %ymm11, %ymm11
        vpor	%ymm8, %ymm0, %ymm0
        vpor	%ymm9, %ymm1, %ymm1
        vpor	%ymm10, %ymm2, %ymm2
        vpor	%ymm11, %ymm3, %ymm3
        vpandn	%ymm4, %ymm13, %ymm8
        vpandn	%ymm5, %ymm13, %ymm9
        vpandn	%ymm6, %ymm13, %ymm10
        vpandn	%ymm7, %ymm13, %ymm11
        vpand	%ymm4, %ymm13, %ymm4
        vpand	%ymm5, %ymm13, %ymm5
        vpand	%ymm6, %ymm13, %ymm6
        vpand	%ymm7, %ymm13, %ymm7
        vpslld	$4, %ymm8, %ymm8
        vpslld	$4, %ymm9, %ymm9
        vpslld	$4, %ymm10, %ymm10
        vpslld	$4, %ymm11, %ymm11
        vpor	%ymm8, %ymm4, %ymm4
        vpor	%ymm9, %ymm5, %ymm5
        vpor	%ymm10, %ymm6, %ymm6
        vpor	%ymm11, %ymm7, %ymm7
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vmovdqu	%ymm4, 384(%rdi)
        vmovdqu	%ymm5, 416(%rdi)
        vmovdqu	%ymm6, 448(%rdi)
        vmovdqu	%ymm7, 480(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_from_bytes_avx2,.-kyber_from_bytes_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_to_bytes_avx2_mask:
.long	0xfff,0xfff,0xfff,0xfff
.long	0xfff,0xfff,0xfff,0xfff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_kyber_to_bytes_avx2_shuf:
.value	0x100,0x402
.value	0x605,0x908
.value	0xc0a,0xe0d
.value	0xffff,0xffff
.value	0x605,0x908
.value	0xc0a,0xe0d
.value	0xffff,0xffff
.value	0x100,0x402
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_kyber_to_bytes_avx2_perm:
.long	0x0,0x1,0x2,0x7
.long	0x4,0x5,0x3,0x6
#ifndef __APPLE__
.text
.globl	kyber_to_bytes_avx2
.type	kyber_to_bytes_avx2,@function
.align	16
kyber_to_bytes_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_to_bytes_avx2
.p2align	4
_kyber_to_bytes_avx2:
#endif /* __APPLE__ */
        vmovdqu	kyber_q(%rip), %ymm12
        vmovdqu	L_kyber_to_bytes_avx2_mask(%rip), %ymm13
        vmovdqu	L_kyber_to_bytes_avx2_shuf(%rip), %ymm14
        vmovdqu	L_kyber_to_bytes_avx2_perm(%rip), %ymm15
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm1
        vmovdqu	64(%rsi), %ymm2
        vmovdqu	96(%rsi), %ymm3
        vmovdqu	128(%rsi), %ymm4
        vmovdqu	160(%rsi), %ymm5
        vmovdqu	192(%rsi), %ymm6
        vmovdqu	224(%rsi), %ymm7
        vpsubw	%ymm12, %ymm0, %ymm8
        vpsubw	%ymm12, %ymm1, %ymm9
        vpsubw	%ymm12, %ymm2, %ymm10
        vpsubw	%ymm12, %ymm3, %ymm11
        vpsraw	$15, %ymm8, %ymm0
        vpsraw	$15, %ymm9, %ymm1
        vpsraw	$15, %ymm10, %ymm2
        vpsraw	$15, %ymm11, %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpaddw	%ymm10, %ymm2, %ymm2
        vpaddw	%ymm11, %ymm3, %ymm3
        vpsubw	%ymm12, %ymm4, %ymm8
        vpsubw	%ymm12, %ymm5, %ymm9
        vpsubw	%ymm12, %ymm6, %ymm10
        vpsubw	%ymm12, %ymm7, %ymm11
        vpsraw	$15, %ymm8, %ymm4
        vpsraw	$15, %ymm9, %ymm5
        vpsraw	$15, %ymm10, %ymm6
        vpsraw	$15, %ymm11, %ymm7
        vpand	%ymm12, %ymm4, %ymm4
        vpand	%ymm12, %ymm5, %ymm5
        vpand	%ymm12, %ymm6, %ymm6
        vpand	%ymm12, %ymm7, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        vpaddw	%ymm10, %ymm6, %ymm6
        vpaddw	%ymm11, %ymm7, %ymm7
        vpsrld	$16, %ymm0, %ymm8
        vpsrld	$16, %ymm1, %ymm9
        vpsrld	$16, %ymm2, %ymm10
        vpsrld	$16, %ymm3, %ymm11
        vpand	%ymm0, %ymm13, %ymm0
        vpand	%ymm1, %ymm13, %ymm1
        vpand	%ymm2, %ymm13, %ymm2
        vpand	%ymm3, %ymm13, %ymm3
        vpslld	$12, %ymm8, %ymm8
        vpslld	$12, %ymm9, %ymm9
        vpslld	$12, %ymm10, %ymm10
        vpslld	$12, %ymm11, %ymm11
        vpor	%ymm8, %ymm0, %ymm0
        vpor	%ymm9, %ymm1, %ymm1
        vpor	%ymm10, %ymm2, %ymm2
        vpor	%ymm11, %ymm3, %ymm3
        vpsrld	$16, %ymm4, %ymm8
        vpsrld	$16, %ymm5, %ymm9
        vpsrld	$16, %ymm6, %ymm10
        vpsrld	$16, %ymm7, %ymm11
        vpand	%ymm4, %ymm13, %ymm4
        vpand	%ymm5, %ymm13, %ymm5
        vpand	%ymm6, %ymm13, %ymm6
        vpand	%ymm7, %ymm13, %ymm7
        vpslld	$12, %ymm8, %ymm8
        vpslld	$12, %ymm9, %ymm9
        vpslld	$12, %ymm10, %ymm10
        vpslld	$12, %ymm11, %ymm11
        vpor	%ymm8, %ymm4, %ymm4
        vpor	%ymm9, %ymm5, %ymm5
        vpor	%ymm10, %ymm6, %ymm6
        vpor	%ymm11, %ymm7, %ymm7
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm1, %ymm1
        vpshufb	%ymm14, %ymm2, %ymm2
        vpshufb	%ymm14, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm4, %ymm4
        vpshufb	%ymm14, %ymm5, %ymm5
        vpshufb	%ymm14, %ymm6, %ymm6
        vpshufb	%ymm14, %ymm7, %ymm7
        vpermd	%ymm0, %ymm15, %ymm0
        vpermd	%ymm1, %ymm15, %ymm1
        vpermd	%ymm2, %ymm15, %ymm2
        vpermd	%ymm3, %ymm15, %ymm3
        vpermd	%ymm4, %ymm15, %ymm4
        vpermd	%ymm5, %ymm15, %ymm5
        vpermd	%ymm6, %ymm15, %ymm6
        vpermd	%ymm7, %ymm15, %ymm7
        vpermq	$2, %ymm6, %ymm8
        vpermq	$0x90, %ymm7, %ymm7
        vpermq	$9, %ymm5, %ymm9
        vpermq	$0x40, %ymm6, %ymm6
        vpermq	$0x00, %ymm5, %ymm5
        vpblendd	$63, %ymm4, %ymm5, %ymm5
        vpermq	$2, %ymm2, %ymm10
        vpermq	$0x90, %ymm3, %ymm4
        vpermq	$9, %ymm1, %ymm11
        vpermq	$0x40, %ymm2, %ymm3
        vpermq	$0x00, %ymm1, %ymm2
        vpblendd	$63, %ymm0, %ymm2, %ymm2
        vpblendd	$3, %ymm8, %ymm7, %ymm7
        vpblendd	$15, %ymm9, %ymm6, %ymm6
        vpblendd	$3, %ymm10, %ymm4, %ymm4
        vpblendd	$15, %ymm11, %ymm3, %ymm3
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 64(%rdi)
        vmovdqu	%ymm5, 96(%rdi)
        vmovdqu	%ymm6, 128(%rdi)
        vmovdqu	%ymm7, 160(%rdi)
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	288(%rsi), %ymm1
        vmovdqu	320(%rsi), %ymm2
        vmovdqu	352(%rsi), %ymm3
        vmovdqu	384(%rsi), %ymm4
        vmovdqu	416(%rsi), %ymm5
        vmovdqu	448(%rsi), %ymm6
        vmovdqu	480(%rsi), %ymm7
        vpsubw	%ymm12, %ymm0, %ymm8
        vpsubw	%ymm12, %ymm1, %ymm9
        vpsubw	%ymm12, %ymm2, %ymm10
        vpsubw	%ymm12, %ymm3, %ymm11
        vpsraw	$15, %ymm8, %ymm0
        vpsraw	$15, %ymm9, %ymm1
        vpsraw	$15, %ymm10, %ymm2
        vpsraw	$15, %ymm11, %ymm3
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpand	%ymm12, %ymm2, %ymm2
        vpand	%ymm12, %ymm3, %ymm3
        vpaddw	%ymm8, %ymm0, %ymm0
        vpaddw	%ymm9, %ymm1, %ymm1
        vpaddw	%ymm10, %ymm2, %ymm2
        vpaddw	%ymm11, %ymm3, %ymm3
        vpsubw	%ymm12, %ymm4, %ymm8
        vpsubw	%ymm12, %ymm5, %ymm9
        vpsubw	%ymm12, %ymm6, %ymm10
        vpsubw	%ymm12, %ymm7, %ymm11
        vpsraw	$15, %ymm8, %ymm4
        vpsraw	$15, %ymm9, %ymm5
        vpsraw	$15, %ymm10, %ymm6
        vpsraw	$15, %ymm11, %ymm7
        vpand	%ymm12, %ymm4, %ymm4
        vpand	%ymm12, %ymm5, %ymm5
        vpand	%ymm12, %ymm6, %ymm6
        vpand	%ymm12, %ymm7, %ymm7
        vpaddw	%ymm8, %ymm4, %ymm4
        vpaddw	%ymm9, %ymm5, %ymm5
        vpaddw	%ymm10, %ymm6, %ymm6
        vpaddw	%ymm11, %ymm7, %ymm7
        vpsrld	$16, %ymm0, %ymm8
        vpsrld	$16, %ymm1, %ymm9
        vpsrld	$16, %ymm2, %ymm10
        vpsrld	$16, %ymm3, %ymm11
        vpand	%ymm0, %ymm13, %ymm0
        vpand	%ymm1, %ymm13, %ymm1
        vpand	%ymm2, %ymm13, %ymm2
        vpand	%ymm3, %ymm13, %ymm3
        vpslld	$12, %ymm8, %ymm8
        vpslld	$12, %ymm9, %ymm9
        vpslld	$12, %ymm10, %ymm10
        vpslld	$12, %ymm11, %ymm11
        vpor	%ymm8, %ymm0, %ymm0
        vpor	%ymm9, %ymm1, %ymm1
        vpor	%ymm10, %ymm2, %ymm2
        vpor	%ymm11, %ymm3, %ymm3
        vpsrld	$16, %ymm4, %ymm8
        vpsrld	$16, %ymm5, %ymm9
        vpsrld	$16, %ymm6, %ymm10
        vpsrld	$16, %ymm7, %ymm11
        vpand	%ymm4, %ymm13, %ymm4
        vpand	%ymm5, %ymm13, %ymm5
        vpand	%ymm6, %ymm13, %ymm6
        vpand	%ymm7, %ymm13, %ymm7
        vpslld	$12, %ymm8, %ymm8
        vpslld	$12, %ymm9, %ymm9
        vpslld	$12, %ymm10, %ymm10
        vpslld	$12, %ymm11, %ymm11
        vpor	%ymm8, %ymm4, %ymm4
        vpor	%ymm9, %ymm5, %ymm5
        vpor	%ymm10, %ymm6, %ymm6
        vpor	%ymm11, %ymm7, %ymm7
        vpshufb	%ymm14, %ymm0, %ymm0
        vpshufb	%ymm14, %ymm1, %ymm1
        vpshufb	%ymm14, %ymm2, %ymm2
        vpshufb	%ymm14, %ymm3, %ymm3
        vpshufb	%ymm14, %ymm4, %ymm4
        vpshufb	%ymm14, %ymm5, %ymm5
        vpshufb	%ymm14, %ymm6, %ymm6
        vpshufb	%ymm14, %ymm7, %ymm7
        vpermd	%ymm0, %ymm15, %ymm0
        vpermd	%ymm1, %ymm15, %ymm1
        vpermd	%ymm2, %ymm15, %ymm2
        vpermd	%ymm3, %ymm15, %ymm3
        vpermd	%ymm4, %ymm15, %ymm4
        vpermd	%ymm5, %ymm15, %ymm5
        vpermd	%ymm6, %ymm15, %ymm6
        vpermd	%ymm7, %ymm15, %ymm7
        vpermq	$2, %ymm6, %ymm8
        vpermq	$0x90, %ymm7, %ymm7
        vpermq	$9, %ymm5, %ymm9
        vpermq	$0x40, %ymm6, %ymm6
        vpermq	$0x00, %ymm5, %ymm5
        vpblendd	$63, %ymm4, %ymm5, %ymm5
        vpermq	$2, %ymm2, %ymm10
        vpermq	$0x90, %ymm3, %ymm4
        vpermq	$9, %ymm1, %ymm11
        vpermq	$0x40, %ymm2, %ymm3
        vpermq	$0x00, %ymm1, %ymm2
        vpblendd	$63, %ymm0, %ymm2, %ymm2
        vpblendd	$3, %ymm8, %ymm7, %ymm7
        vpblendd	$15, %ymm9, %ymm6, %ymm6
        vpblendd	$3, %ymm10, %ymm4, %ymm4
        vpblendd	$15, %ymm11, %ymm3, %ymm3
        vmovdqu	%ymm2, 192(%rdi)
        vmovdqu	%ymm3, 224(%rdi)
        vmovdqu	%ymm4, 256(%rdi)
        vmovdqu	%ymm5, 288(%rdi)
        vmovdqu	%ymm6, 320(%rdi)
        vmovdqu	%ymm7, 352(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_to_bytes_avx2,.-kyber_to_bytes_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_cmp_avx2
.type	kyber_cmp_avx2,@function
.align	16
kyber_cmp_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_cmp_avx2
.p2align	4
_kyber_cmp_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm2, %ymm2, %ymm2
        vpxor	%ymm3, %ymm3, %ymm3
        movl	$0x00, %ecx
        movl	$-1, %r8d
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vpxor	(%rsi), %ymm0, %ymm0
        vpxor	32(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	64(%rdi), %ymm0
        vmovdqu	96(%rdi), %ymm1
        vpxor	64(%rsi), %ymm0, %ymm0
        vpxor	96(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vpxor	128(%rsi), %ymm0, %ymm0
        vpxor	160(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	192(%rdi), %ymm0
        vmovdqu	224(%rdi), %ymm1
        vpxor	192(%rsi), %ymm0, %ymm0
        vpxor	224(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vpxor	256(%rsi), %ymm0, %ymm0
        vpxor	288(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	320(%rdi), %ymm0
        vmovdqu	352(%rdi), %ymm1
        vpxor	320(%rsi), %ymm0, %ymm0
        vpxor	352(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vpxor	384(%rsi), %ymm0, %ymm0
        vpxor	416(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	448(%rdi), %ymm0
        vmovdqu	480(%rdi), %ymm1
        vpxor	448(%rsi), %ymm0, %ymm0
        vpxor	480(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vpxor	512(%rsi), %ymm0, %ymm0
        vpxor	544(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	576(%rdi), %ymm0
        vmovdqu	608(%rdi), %ymm1
        vpxor	576(%rsi), %ymm0, %ymm0
        vpxor	608(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	640(%rdi), %ymm0
        vmovdqu	672(%rdi), %ymm1
        vpxor	640(%rsi), %ymm0, %ymm0
        vpxor	672(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	704(%rdi), %ymm0
        vmovdqu	736(%rdi), %ymm1
        vpxor	704(%rsi), %ymm0, %ymm0
        vpxor	736(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        subl	$0x300, %edx
        jz	L_kyber_cmp_avx2_done
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vpxor	768(%rsi), %ymm0, %ymm0
        vpxor	800(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	832(%rdi), %ymm0
        vmovdqu	864(%rdi), %ymm1
        vpxor	832(%rsi), %ymm0, %ymm0
        vpxor	864(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	896(%rdi), %ymm0
        vmovdqu	928(%rdi), %ymm1
        vpxor	896(%rsi), %ymm0, %ymm0
        vpxor	928(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	960(%rdi), %ymm0
        vmovdqu	992(%rdi), %ymm1
        vpxor	960(%rsi), %ymm0, %ymm0
        vpxor	992(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	1024(%rdi), %ymm0
        vmovdqu	1056(%rdi), %ymm1
        vpxor	1024(%rsi), %ymm0, %ymm0
        vpxor	1056(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        subl	$0x140, %edx
        jz	L_kyber_cmp_avx2_done
        vmovdqu	1088(%rdi), %ymm0
        vmovdqu	1120(%rdi), %ymm1
        vpxor	1088(%rsi), %ymm0, %ymm0
        vpxor	1120(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	1152(%rdi), %ymm0
        vmovdqu	1184(%rdi), %ymm1
        vpxor	1152(%rsi), %ymm0, %ymm0
        vpxor	1184(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	1216(%rdi), %ymm0
        vmovdqu	1248(%rdi), %ymm1
        vpxor	1216(%rsi), %ymm0, %ymm0
        vpxor	1248(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	1280(%rdi), %ymm0
        vmovdqu	1312(%rdi), %ymm1
        vpxor	1280(%rsi), %ymm0, %ymm0
        vpxor	1312(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	1344(%rdi), %ymm0
        vmovdqu	1376(%rdi), %ymm1
        vpxor	1344(%rsi), %ymm0, %ymm0
        vpxor	1376(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	1408(%rdi), %ymm0
        vmovdqu	1440(%rdi), %ymm1
        vpxor	1408(%rsi), %ymm0, %ymm0
        vpxor	1440(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	1472(%rdi), %ymm0
        vmovdqu	1504(%rdi), %ymm1
        vpxor	1472(%rsi), %ymm0, %ymm0
        vpxor	1504(%rsi), %ymm1, %ymm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
L_kyber_cmp_avx2_done:
        vpor	%ymm3, %ymm2, %ymm2
        vptest	%ymm2, %ymm2
        cmovzl	%ecx, %eax
        cmovnzl	%r8d, %eax
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_cmp_avx2,.-kyber_cmp_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_redistribute_21_rand_avx2
.type	kyber_redistribute_21_rand_avx2,@function
.align	16
kyber_redistribute_21_rand_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_redistribute_21_rand_avx2
.p2align	4
_kyber_redistribute_21_rand_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vmovdqu	256(%rdi), %ymm8
        vmovdqu	288(%rdi), %ymm9
        vmovdqu	320(%rdi), %ymm10
        vmovdqu	352(%rdi), %ymm11
        vpunpcklqdq	%ymm1, %ymm0, %ymm12
        vpunpckhqdq	%ymm1, %ymm0, %ymm13
        vpunpcklqdq	%ymm3, %ymm2, %ymm14
        vpunpckhqdq	%ymm3, %ymm2, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm0
        vperm2i128	$32, %ymm15, %ymm13, %ymm1
        vperm2i128	$49, %ymm14, %ymm12, %ymm2
        vperm2i128	$49, %ymm15, %ymm13, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm12
        vpunpckhqdq	%ymm5, %ymm4, %ymm13
        vpunpcklqdq	%ymm7, %ymm6, %ymm14
        vpunpckhqdq	%ymm7, %ymm6, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm4
        vperm2i128	$32, %ymm15, %ymm13, %ymm5
        vperm2i128	$49, %ymm14, %ymm12, %ymm6
        vperm2i128	$49, %ymm15, %ymm13, %ymm7
        vpunpcklqdq	%ymm9, %ymm8, %ymm12
        vpunpckhqdq	%ymm9, %ymm8, %ymm13
        vpunpcklqdq	%ymm11, %ymm10, %ymm14
        vpunpckhqdq	%ymm11, %ymm10, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm8
        vperm2i128	$32, %ymm15, %ymm13, %ymm9
        vperm2i128	$49, %ymm14, %ymm12, %ymm10
        vperm2i128	$49, %ymm15, %ymm13, %ymm11
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm4, 32(%rsi)
        vmovdqu	%ymm8, 64(%rsi)
        vmovdqu	%ymm1, (%rdx)
        vmovdqu	%ymm5, 32(%rdx)
        vmovdqu	%ymm9, 64(%rdx)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm6, 32(%rcx)
        vmovdqu	%ymm10, 64(%rcx)
        vmovdqu	%ymm3, (%r8)
        vmovdqu	%ymm7, 32(%r8)
        vmovdqu	%ymm11, 64(%r8)
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vmovdqu	512(%rdi), %ymm4
        vmovdqu	544(%rdi), %ymm5
        vmovdqu	576(%rdi), %ymm6
        vmovdqu	608(%rdi), %ymm7
        movq	640(%rdi), %rax
        movq	648(%rdi), %r9
        movq	656(%rdi), %r10
        movq	664(%rdi), %r11
        vpunpcklqdq	%ymm1, %ymm0, %ymm12
        vpunpckhqdq	%ymm1, %ymm0, %ymm13
        vpunpcklqdq	%ymm3, %ymm2, %ymm14
        vpunpckhqdq	%ymm3, %ymm2, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm0
        vperm2i128	$32, %ymm15, %ymm13, %ymm1
        vperm2i128	$49, %ymm14, %ymm12, %ymm2
        vperm2i128	$49, %ymm15, %ymm13, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm12
        vpunpckhqdq	%ymm5, %ymm4, %ymm13
        vpunpcklqdq	%ymm7, %ymm6, %ymm14
        vpunpckhqdq	%ymm7, %ymm6, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm4
        vperm2i128	$32, %ymm15, %ymm13, %ymm5
        vperm2i128	$49, %ymm14, %ymm12, %ymm6
        vperm2i128	$49, %ymm15, %ymm13, %ymm7
        vmovdqu	%ymm0, 96(%rsi)
        vmovdqu	%ymm4, 128(%rsi)
        movq	%rax, 160(%rsi)
        vmovdqu	%ymm1, 96(%rdx)
        vmovdqu	%ymm5, 128(%rdx)
        movq	%r9, 160(%rdx)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm6, 128(%rcx)
        movq	%r10, 160(%rcx)
        vmovdqu	%ymm3, 96(%r8)
        vmovdqu	%ymm7, 128(%r8)
        movq	%r11, 160(%r8)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_redistribute_21_rand_avx2,.-kyber_redistribute_21_rand_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_redistribute_17_rand_avx2
.type	kyber_redistribute_17_rand_avx2,@function
.align	16
kyber_redistribute_17_rand_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_redistribute_17_rand_avx2
.p2align	4
_kyber_redistribute_17_rand_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm9
        vpunpcklqdq	%ymm3, %ymm2, %ymm10
        vpunpckhqdq	%ymm3, %ymm2, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm0
        vperm2i128	$32, %ymm11, %ymm9, %ymm1
        vperm2i128	$49, %ymm10, %ymm8, %ymm2
        vperm2i128	$49, %ymm11, %ymm9, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm9
        vpunpcklqdq	%ymm7, %ymm6, %ymm10
        vpunpckhqdq	%ymm7, %ymm6, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm4
        vperm2i128	$32, %ymm11, %ymm9, %ymm5
        vperm2i128	$49, %ymm10, %ymm8, %ymm6
        vperm2i128	$49, %ymm11, %ymm9, %ymm7
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm4, 32(%rsi)
        vmovdqu	%ymm1, (%rdx)
        vmovdqu	%ymm5, 32(%rdx)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm6, 32(%rcx)
        vmovdqu	%ymm3, (%r8)
        vmovdqu	%ymm7, 32(%r8)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        movq	512(%rdi), %rax
        movq	520(%rdi), %r9
        movq	528(%rdi), %r10
        movq	536(%rdi), %r11
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm9
        vpunpcklqdq	%ymm3, %ymm2, %ymm10
        vpunpckhqdq	%ymm3, %ymm2, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm0
        vperm2i128	$32, %ymm11, %ymm9, %ymm1
        vperm2i128	$49, %ymm10, %ymm8, %ymm2
        vperm2i128	$49, %ymm11, %ymm9, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm9
        vpunpcklqdq	%ymm7, %ymm6, %ymm10
        vpunpckhqdq	%ymm7, %ymm6, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm4
        vperm2i128	$32, %ymm11, %ymm9, %ymm5
        vperm2i128	$49, %ymm10, %ymm8, %ymm6
        vperm2i128	$49, %ymm11, %ymm9, %ymm7
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	%ymm4, 96(%rsi)
        movq	%rax, 128(%rsi)
        vmovdqu	%ymm1, 64(%rdx)
        vmovdqu	%ymm5, 96(%rdx)
        movq	%r9, 128(%rdx)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm6, 96(%rcx)
        movq	%r10, 128(%rcx)
        vmovdqu	%ymm3, 64(%r8)
        vmovdqu	%ymm7, 96(%r8)
        movq	%r11, 128(%r8)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_redistribute_17_rand_avx2,.-kyber_redistribute_17_rand_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_redistribute_16_rand_avx2
.type	kyber_redistribute_16_rand_avx2,@function
.align	16
kyber_redistribute_16_rand_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_redistribute_16_rand_avx2
.p2align	4
_kyber_redistribute_16_rand_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm9
        vpunpcklqdq	%ymm3, %ymm2, %ymm10
        vpunpckhqdq	%ymm3, %ymm2, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm0
        vperm2i128	$32, %ymm11, %ymm9, %ymm1
        vperm2i128	$49, %ymm10, %ymm8, %ymm2
        vperm2i128	$49, %ymm11, %ymm9, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm9
        vpunpcklqdq	%ymm7, %ymm6, %ymm10
        vpunpckhqdq	%ymm7, %ymm6, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm4
        vperm2i128	$32, %ymm11, %ymm9, %ymm5
        vperm2i128	$49, %ymm10, %ymm8, %ymm6
        vperm2i128	$49, %ymm11, %ymm9, %ymm7
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm4, 32(%rsi)
        vmovdqu	%ymm1, (%rdx)
        vmovdqu	%ymm5, 32(%rdx)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm6, 32(%rcx)
        vmovdqu	%ymm3, (%r8)
        vmovdqu	%ymm7, 32(%r8)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm9
        vpunpcklqdq	%ymm3, %ymm2, %ymm10
        vpunpckhqdq	%ymm3, %ymm2, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm0
        vperm2i128	$32, %ymm11, %ymm9, %ymm1
        vperm2i128	$49, %ymm10, %ymm8, %ymm2
        vperm2i128	$49, %ymm11, %ymm9, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm9
        vpunpcklqdq	%ymm7, %ymm6, %ymm10
        vpunpckhqdq	%ymm7, %ymm6, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm4
        vperm2i128	$32, %ymm11, %ymm9, %ymm5
        vperm2i128	$49, %ymm10, %ymm8, %ymm6
        vperm2i128	$49, %ymm11, %ymm9, %ymm7
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	%ymm4, 96(%rsi)
        vmovdqu	%ymm1, 64(%rdx)
        vmovdqu	%ymm5, 96(%rdx)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm6, 96(%rcx)
        vmovdqu	%ymm3, 64(%r8)
        vmovdqu	%ymm7, 96(%r8)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_redistribute_16_rand_avx2,.-kyber_redistribute_16_rand_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_redistribute_8_rand_avx2
.type	kyber_redistribute_8_rand_avx2,@function
.align	16
kyber_redistribute_8_rand_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_redistribute_8_rand_avx2
.p2align	4
_kyber_redistribute_8_rand_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm9
        vpunpcklqdq	%ymm3, %ymm2, %ymm10
        vpunpckhqdq	%ymm3, %ymm2, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm0
        vperm2i128	$32, %ymm11, %ymm9, %ymm1
        vperm2i128	$49, %ymm10, %ymm8, %ymm2
        vperm2i128	$49, %ymm11, %ymm9, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm9
        vpunpcklqdq	%ymm7, %ymm6, %ymm10
        vpunpckhqdq	%ymm7, %ymm6, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm4
        vperm2i128	$32, %ymm11, %ymm9, %ymm5
        vperm2i128	$49, %ymm10, %ymm8, %ymm6
        vperm2i128	$49, %ymm11, %ymm9, %ymm7
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm4, 32(%rsi)
        vmovdqu	%ymm1, (%rdx)
        vmovdqu	%ymm5, 32(%rdx)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm6, 32(%rcx)
        vmovdqu	%ymm3, (%r8)
        vmovdqu	%ymm7, 32(%r8)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_redistribute_8_rand_avx2,.-kyber_redistribute_8_rand_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_sha3_parallel_4_r:
.quad	0x1,0x1
.quad	0x1,0x1
.quad	0x8082,0x8082
.quad	0x8082,0x8082
.quad	0x800000000000808a,0x800000000000808a
.quad	0x800000000000808a,0x800000000000808a
.quad	0x8000000080008000,0x8000000080008000
.quad	0x8000000080008000,0x8000000080008000
.quad	0x808b,0x808b
.quad	0x808b,0x808b
.quad	0x80000001,0x80000001
.quad	0x80000001,0x80000001
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000000008009,0x8000000000008009
.quad	0x8000000000008009,0x8000000000008009
.quad	0x8a,0x8a
.quad	0x8a,0x8a
.quad	0x88,0x88
.quad	0x88,0x88
.quad	0x80008009,0x80008009
.quad	0x80008009,0x80008009
.quad	0x8000000a,0x8000000a
.quad	0x8000000a,0x8000000a
.quad	0x8000808b,0x8000808b
.quad	0x8000808b,0x8000808b
.quad	0x800000000000008b,0x800000000000008b
.quad	0x800000000000008b,0x800000000000008b
.quad	0x8000000000008089,0x8000000000008089
.quad	0x8000000000008089,0x8000000000008089
.quad	0x8000000000008003,0x8000000000008003
.quad	0x8000000000008003,0x8000000000008003
.quad	0x8000000000008002,0x8000000000008002
.quad	0x8000000000008002,0x8000000000008002
.quad	0x8000000000000080,0x8000000000000080
.quad	0x8000000000000080,0x8000000000000080
.quad	0x800a,0x800a
.quad	0x800a,0x800a
.quad	0x800000008000000a,0x800000008000000a
.quad	0x800000008000000a,0x800000008000000a
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000000008080,0x8000000000008080
.quad	0x8000000000008080,0x8000000000008080
.quad	0x80000001,0x80000001
.quad	0x80000001,0x80000001
.quad	0x8000000080008008,0x8000000080008008
.quad	0x8000000080008008,0x8000000080008008
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_sha3_128_blockx4_seed_avx2_end_mark:
.quad	0x8000000000000000, 0x8000000000000000
.quad	0x8000000000000000, 0x8000000000000000
#ifndef __APPLE__
.text
.globl	kyber_sha3_128_blocksx4_seed_avx2
.type	kyber_sha3_128_blocksx4_seed_avx2,@function
.align	16
kyber_sha3_128_blocksx4_seed_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_sha3_128_blocksx4_seed_avx2
.p2align	4
_kyber_sha3_128_blocksx4_seed_avx2:
#endif /* __APPLE__ */
        leaq	L_sha3_parallel_4_r(%rip), %rdx
        movq	%rdi, %rax
        movq	%rdi, %rcx
        vpbroadcastq	(%rsi), %ymm15
        addq	$0x80, %rdi
        vpbroadcastq	8(%rsi), %ymm11
        addq	$0x180, %rax
        vpbroadcastq	16(%rsi), %ymm12
        addq	$0x280, %rcx
        vpbroadcastq	24(%rsi), %ymm13
        vmovdqu	L_sha3_128_blockx4_seed_avx2_end_mark(%rip), %ymm5
        vpxor	%ymm6, %ymm6, %ymm6
        vmovdqu	%ymm11, -96(%rdi)
        vmovdqu	%ymm12, -64(%rdi)
        vmovdqu	%ymm13, -32(%rdi)
        vmovdqu	(%rdi), %ymm14
        vmovdqu	%ymm6, 32(%rdi)
        vmovdqu	%ymm6, 64(%rdi)
        vmovdqu	%ymm6, 96(%rdi)
        vmovdqu	%ymm6, 128(%rdi)
        vmovdqu	%ymm6, -96(%rax)
        vmovdqu	%ymm6, -64(%rax)
        vmovdqu	%ymm6, -32(%rax)
        vmovdqu	%ymm6, (%rax)
        vmovdqu	%ymm6, 32(%rax)
        vmovdqu	%ymm6, 64(%rax)
        vmovdqu	%ymm6, 96(%rax)
        vmovdqu	%ymm6, 128(%rax)
        vmovdqu	%ymm6, -96(%rcx)
        vmovdqu	%ymm6, -64(%rcx)
        vmovdqu	%ymm6, -32(%rcx)
        vmovdqu	%ymm5, (%rcx)
        vmovdqu	%ymm6, 32(%rcx)
        vmovdqu	%ymm6, 64(%rcx)
        vmovdqu	%ymm6, 96(%rcx)
        vmovdqu	%ymm6, 128(%rcx)
        vpxor	%ymm5, %ymm15, %ymm10
        # Round 0
        # Calc b[0..4]
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	64(%rdi), %ymm6, %ymm11
        vpxor	(%rax), %ymm7, %ymm12
        vpxor	-64(%rcx), %ymm8, %ymm13
        vpxor	128(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 1
        vpxor	-32(%rdi), %ymm8, %ymm10
        vpxor	-96(%rax), %ymm9, %ymm11
        vpxor	-64(%rax), %ymm5, %ymm12
        vpxor	128(%rax), %ymm6, %ymm13
        vpxor	64(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 2
        vpxor	-96(%rdi), %ymm6, %ymm10
        vpxor	96(%rdi), %ymm7, %ymm11
        vpxor	32(%rax), %ymm8, %ymm12
        vpxor	-32(%rcx), %ymm9, %ymm13
        vpxor	(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, (%rcx)
        # Row 3
        vpxor	(%rdi), %ymm9, %ymm10
        vpxor	32(%rdi), %ymm5, %ymm11
        vpxor	-32(%rax), %ymm6, %ymm12
        vpxor	-96(%rcx), %ymm7, %ymm13
        vpxor	96(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 4
        vpxor	-64(%rdi), %ymm7, %ymm10
        vpxor	128(%rdi), %ymm8, %ymm11
        vpxor	64(%rax), %ymm9, %ymm12
        vpxor	96(%rax), %ymm5, %ymm13
        vpxor	32(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, 32(%rcx)
        # Round 1
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm10, %ymm10
        vpxor	-32(%rdi), %ymm10, %ymm10
        vpxor	(%rdi), %ymm10, %ymm10
        vpxor	32(%rdi), %ymm1, %ymm11
        vpxor	64(%rdi), %ymm11, %ymm11
        vpxor	96(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm2, %ymm12
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm3, %ymm13
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm4, %ymm14
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm14, %ymm14
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-96(%rax), %ymm6, %ymm11
        vpxor	32(%rax), %ymm7, %ymm12
        vpxor	-96(%rcx), %ymm8, %ymm13
        vpxor	32(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	32(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 1
        vpxor	-64(%rcx), %ymm8, %ymm10
        vpxor	64(%rcx), %ymm9, %ymm11
        vpxor	-96(%rdi), %ymm5, %ymm12
        vpxor	32(%rdi), %ymm6, %ymm13
        vpxor	64(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 64(%rax)
        # Row 2
        vpxor	64(%rdi), %ymm6, %ymm10
        vpxor	-64(%rax), %ymm7, %ymm11
        vpxor	-32(%rcx), %ymm8, %ymm12
        vpxor	96(%rcx), %ymm9, %ymm13
        vpxor	-64(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 3
        vpxor	128(%rcx), %ymm9, %ymm10
        vpxor	-32(%rdi), %ymm5, %ymm11
        vpxor	96(%rdi), %ymm6, %ymm12
        vpxor	-32(%rax), %ymm7, %ymm13
        vpxor	96(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 96(%rax)
        # Row 4
        vpxor	(%rax), %ymm7, %ymm10
        vpxor	128(%rax), %ymm8, %ymm11
        vpxor	(%rcx), %ymm9, %ymm12
        vpxor	(%rdi), %ymm5, %ymm13
        vpxor	128(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        # Round 2
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm3, %ymm13
        vpxor	64(%rdi), %ymm10, %ymm10
        vpxor	96(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm11, %ymm11
        vpxor	-32(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-64(%rcx), %ymm10, %ymm10
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	64(%rcx), %ymm6, %ymm11
        vpxor	-32(%rcx), %ymm7, %ymm12
        vpxor	-32(%rax), %ymm8, %ymm13
        vpxor	128(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	64(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 1
        vpxor	-96(%rcx), %ymm8, %ymm10
        vpxor	64(%rax), %ymm9, %ymm11
        vpxor	64(%rdi), %ymm5, %ymm12
        vpxor	-32(%rdi), %ymm6, %ymm13
        vpxor	(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, (%rcx)
        # Row 2
        vpxor	-96(%rax), %ymm6, %ymm10
        vpxor	-96(%rdi), %ymm7, %ymm11
        vpxor	96(%rcx), %ymm8, %ymm12
        vpxor	96(%rax), %ymm9, %ymm13
        vpxor	(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, (%rax)
        # Row 3
        vpxor	32(%rcx), %ymm9, %ymm10
        vpxor	-64(%rcx), %ymm5, %ymm11
        vpxor	-64(%rax), %ymm6, %ymm12
        vpxor	96(%rdi), %ymm7, %ymm13
        vpxor	(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, (%rdi)
        # Row 4
        vpxor	32(%rax), %ymm7, %ymm10
        vpxor	32(%rdi), %ymm8, %ymm11
        vpxor	-64(%rdi), %ymm9, %ymm12
        vpxor	128(%rcx), %ymm5, %ymm13
        vpxor	128(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, 128(%rax)
        # Round 3
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm3, %ymm13
        vpxor	(%rdi), %ymm4, %ymm14
        vpxor	64(%rdi), %ymm2, %ymm12
        vpxor	96(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm14, %ymm14
        vpxor	-96(%rax), %ymm10, %ymm10
        vpxor	-64(%rax), %ymm12, %ymm12
        vpxor	-32(%rax), %ymm13, %ymm13
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm10, %ymm10
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm14, %ymm14
        vpxor	32(%rcx), %ymm10, %ymm10
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	64(%rax), %ymm6, %ymm11
        vpxor	96(%rcx), %ymm7, %ymm12
        vpxor	96(%rdi), %ymm8, %ymm13
        vpxor	128(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	96(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rax)
        # Row 1
        vpxor	-32(%rax), %ymm8, %ymm10
        vpxor	(%rcx), %ymm9, %ymm11
        vpxor	-96(%rax), %ymm5, %ymm12
        vpxor	-64(%rcx), %ymm6, %ymm13
        vpxor	-64(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 2
        vpxor	64(%rcx), %ymm6, %ymm10
        vpxor	64(%rdi), %ymm7, %ymm11
        vpxor	96(%rax), %ymm8, %ymm12
        vpxor	(%rdi), %ymm9, %ymm13
        vpxor	32(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, 32(%rax)
        # Row 3
        vpxor	128(%rdi), %ymm9, %ymm10
        vpxor	-96(%rcx), %ymm5, %ymm11
        vpxor	-96(%rdi), %ymm6, %ymm12
        vpxor	-64(%rax), %ymm7, %ymm13
        vpxor	128(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 4
        vpxor	-32(%rcx), %ymm7, %ymm10
        vpxor	-32(%rdi), %ymm8, %ymm11
        vpxor	(%rax), %ymm9, %ymm12
        vpxor	32(%rcx), %ymm5, %ymm13
        vpxor	32(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 32(%rdi)
        # Round 4
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	64(%rdi), %ymm1, %ymm11
        vpxor	96(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm10, %ymm10
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	-32(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm11, %ymm11
        vpxor	64(%rcx), %ymm10, %ymm10
        vpxor	96(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	(%rcx), %ymm6, %ymm11
        vpxor	96(%rax), %ymm7, %ymm12
        vpxor	-64(%rax), %ymm8, %ymm13
        vpxor	32(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	128(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 1
        vpxor	96(%rdi), %ymm8, %ymm10
        vpxor	-64(%rdi), %ymm9, %ymm11
        vpxor	64(%rcx), %ymm5, %ymm12
        vpxor	-96(%rcx), %ymm6, %ymm13
        vpxor	(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, (%rax)
        # Row 2
        vpxor	64(%rax), %ymm6, %ymm10
        vpxor	-96(%rax), %ymm7, %ymm11
        vpxor	(%rdi), %ymm8, %ymm12
        vpxor	128(%rcx), %ymm9, %ymm13
        vpxor	-32(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 3
        vpxor	128(%rax), %ymm9, %ymm10
        vpxor	-32(%rax), %ymm5, %ymm11
        vpxor	64(%rdi), %ymm6, %ymm12
        vpxor	-96(%rdi), %ymm7, %ymm13
        vpxor	32(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 4
        vpxor	96(%rcx), %ymm7, %ymm10
        vpxor	-64(%rcx), %ymm8, %ymm11
        vpxor	32(%rax), %ymm9, %ymm12
        vpxor	128(%rdi), %ymm5, %ymm13
        vpxor	-32(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, -32(%rdi)
        # Round 5
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm4, %ymm14
        vpxor	64(%rdi), %ymm12, %ymm12
        vpxor	96(%rdi), %ymm10, %ymm10
        vpxor	-96(%rax), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm10, %ymm10
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm11, %ymm11
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-64(%rdi), %ymm6, %ymm11
        vpxor	(%rdi), %ymm7, %ymm12
        vpxor	-96(%rdi), %ymm8, %ymm13
        vpxor	-32(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	160(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 1
        vpxor	-64(%rax), %ymm8, %ymm10
        vpxor	(%rax), %ymm9, %ymm11
        vpxor	64(%rax), %ymm5, %ymm12
        vpxor	-32(%rax), %ymm6, %ymm13
        vpxor	32(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 32(%rax)
        # Row 2
        vpxor	(%rcx), %ymm6, %ymm10
        vpxor	64(%rcx), %ymm7, %ymm11
        vpxor	128(%rcx), %ymm8, %ymm12
        vpxor	32(%rcx), %ymm9, %ymm13
        vpxor	96(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 3
        vpxor	32(%rdi), %ymm9, %ymm10
        vpxor	96(%rdi), %ymm5, %ymm11
        vpxor	-96(%rax), %ymm6, %ymm12
        vpxor	64(%rdi), %ymm7, %ymm13
        vpxor	128(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 4
        vpxor	96(%rax), %ymm7, %ymm10
        vpxor	-96(%rcx), %ymm8, %ymm11
        vpxor	-32(%rcx), %ymm9, %ymm12
        vpxor	128(%rax), %ymm5, %ymm13
        vpxor	-64(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, -64(%rcx)
        # Round 6
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm10, %ymm10
        vpxor	64(%rdi), %ymm13, %ymm13
        vpxor	96(%rdi), %ymm11, %ymm11
        vpxor	128(%rdi), %ymm14, %ymm14
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-64(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm13, %ymm13
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm14, %ymm14
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	(%rax), %ymm6, %ymm11
        vpxor	128(%rcx), %ymm7, %ymm12
        vpxor	64(%rdi), %ymm8, %ymm13
        vpxor	-64(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	192(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 1
        vpxor	-96(%rdi), %ymm8, %ymm10
        vpxor	32(%rax), %ymm9, %ymm11
        vpxor	(%rcx), %ymm5, %ymm12
        vpxor	96(%rdi), %ymm6, %ymm13
        vpxor	-32(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 2
        vpxor	-64(%rdi), %ymm6, %ymm10
        vpxor	64(%rax), %ymm7, %ymm11
        vpxor	32(%rcx), %ymm8, %ymm12
        vpxor	128(%rdi), %ymm9, %ymm13
        vpxor	96(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, 96(%rax)
        # Row 3
        vpxor	-32(%rdi), %ymm9, %ymm10
        vpxor	-64(%rax), %ymm5, %ymm11
        vpxor	64(%rcx), %ymm6, %ymm12
        vpxor	-96(%rax), %ymm7, %ymm13
        vpxor	128(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, 128(%rax)
        # Row 4
        vpxor	(%rdi), %ymm7, %ymm10
        vpxor	-32(%rax), %ymm8, %ymm11
        vpxor	96(%rcx), %ymm9, %ymm12
        vpxor	32(%rdi), %ymm5, %ymm13
        vpxor	-96(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, -96(%rcx)
        # Round 7
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm10, %ymm10
        vpxor	-64(%rdi), %ymm10, %ymm10
        vpxor	-32(%rdi), %ymm10, %ymm10
        vpxor	64(%rdi), %ymm3, %ymm13
        vpxor	96(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm13, %ymm13
        vpxor	-96(%rax), %ymm13, %ymm13
        vpxor	-64(%rax), %ymm1, %ymm11
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm4, %ymm14
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm2, %ymm12
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	32(%rax), %ymm6, %ymm11
        vpxor	32(%rcx), %ymm7, %ymm12
        vpxor	-96(%rax), %ymm8, %ymm13
        vpxor	-96(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	224(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 1
        vpxor	64(%rdi), %ymm8, %ymm10
        vpxor	-32(%rcx), %ymm9, %ymm11
        vpxor	-64(%rdi), %ymm5, %ymm12
        vpxor	-64(%rax), %ymm6, %ymm13
        vpxor	96(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 2
        vpxor	(%rax), %ymm6, %ymm10
        vpxor	(%rcx), %ymm7, %ymm11
        vpxor	128(%rdi), %ymm8, %ymm12
        vpxor	128(%rax), %ymm9, %ymm13
        vpxor	(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, (%rdi)
        # Row 3
        vpxor	-64(%rcx), %ymm9, %ymm10
        vpxor	-96(%rdi), %ymm5, %ymm11
        vpxor	64(%rax), %ymm6, %ymm12
        vpxor	64(%rcx), %ymm7, %ymm13
        vpxor	32(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 4
        vpxor	128(%rcx), %ymm7, %ymm10
        vpxor	96(%rdi), %ymm8, %ymm11
        vpxor	96(%rax), %ymm9, %ymm12
        vpxor	-32(%rdi), %ymm5, %ymm13
        vpxor	-32(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, -32(%rax)
        # Round 8
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm1, %ymm11
        vpxor	-64(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm4, %ymm14
        vpxor	32(%rdi), %ymm14, %ymm14
        vpxor	64(%rdi), %ymm10, %ymm10
        vpxor	128(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm3, %ymm13
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm10, %ymm10
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm11, %ymm11
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-32(%rcx), %ymm6, %ymm11
        vpxor	128(%rdi), %ymm7, %ymm12
        vpxor	64(%rcx), %ymm8, %ymm13
        vpxor	-32(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	256(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, -32(%rax)
        # Row 1
        vpxor	-96(%rax), %ymm8, %ymm10
        vpxor	96(%rcx), %ymm9, %ymm11
        vpxor	(%rax), %ymm5, %ymm12
        vpxor	-96(%rdi), %ymm6, %ymm13
        vpxor	96(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, 96(%rax)
        # Row 2
        vpxor	32(%rax), %ymm6, %ymm10
        vpxor	-64(%rdi), %ymm7, %ymm11
        vpxor	128(%rax), %ymm8, %ymm12
        vpxor	32(%rdi), %ymm9, %ymm13
        vpxor	128(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 3
        vpxor	-96(%rcx), %ymm9, %ymm10
        vpxor	64(%rdi), %ymm5, %ymm11
        vpxor	(%rcx), %ymm6, %ymm12
        vpxor	64(%rax), %ymm7, %ymm13
        vpxor	-32(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 4
        vpxor	32(%rcx), %ymm7, %ymm10
        vpxor	-64(%rax), %ymm8, %ymm11
        vpxor	(%rdi), %ymm9, %ymm12
        vpxor	-64(%rcx), %ymm5, %ymm13
        vpxor	96(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, 96(%rdi)
        # Round 9
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	32(%rdi), %ymm13, %ymm13
        vpxor	64(%rdi), %ymm11, %ymm11
        vpxor	128(%rdi), %ymm2, %ymm12
        vpxor	-96(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm10, %ymm10
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm14, %ymm14
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-96(%rcx), %ymm10, %ymm10
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm11, %ymm11
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	96(%rcx), %ymm6, %ymm11
        vpxor	128(%rax), %ymm7, %ymm12
        vpxor	64(%rax), %ymm8, %ymm13
        vpxor	96(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	288(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 1
        vpxor	64(%rcx), %ymm8, %ymm10
        vpxor	96(%rax), %ymm9, %ymm11
        vpxor	32(%rax), %ymm5, %ymm12
        vpxor	64(%rdi), %ymm6, %ymm13
        vpxor	(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, (%rdi)
        # Row 2
        vpxor	-32(%rcx), %ymm6, %ymm10
        vpxor	(%rax), %ymm7, %ymm11
        vpxor	32(%rdi), %ymm8, %ymm12
        vpxor	-32(%rdi), %ymm9, %ymm13
        vpxor	32(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 3
        vpxor	-32(%rax), %ymm9, %ymm10
        vpxor	-96(%rax), %ymm5, %ymm11
        vpxor	-64(%rdi), %ymm6, %ymm12
        vpxor	(%rcx), %ymm7, %ymm13
        vpxor	-64(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 4
        vpxor	128(%rdi), %ymm7, %ymm10
        vpxor	-96(%rdi), %ymm8, %ymm11
        vpxor	128(%rcx), %ymm9, %ymm12
        vpxor	-96(%rcx), %ymm5, %ymm13
        vpxor	-64(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Round 10
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm2, %ymm12
        vpxor	-32(%rdi), %ymm3, %ymm13
        vpxor	(%rdi), %ymm4, %ymm14
        vpxor	32(%rdi), %ymm12, %ymm12
        vpxor	64(%rdi), %ymm13, %ymm13
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	-96(%rax), %ymm1, %ymm11
        vpxor	-32(%rax), %ymm10, %ymm10
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm11, %ymm11
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm10, %ymm10
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm10, %ymm10
        vpxor	96(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	96(%rax), %ymm6, %ymm11
        vpxor	32(%rdi), %ymm7, %ymm12
        vpxor	(%rcx), %ymm8, %ymm13
        vpxor	-64(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	320(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Row 1
        vpxor	64(%rax), %ymm8, %ymm10
        vpxor	(%rdi), %ymm9, %ymm11
        vpxor	-32(%rcx), %ymm5, %ymm12
        vpxor	-96(%rax), %ymm6, %ymm13
        vpxor	128(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 2
        vpxor	96(%rcx), %ymm6, %ymm10
        vpxor	32(%rax), %ymm7, %ymm11
        vpxor	-32(%rdi), %ymm8, %ymm12
        vpxor	-64(%rcx), %ymm9, %ymm13
        vpxor	128(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 3
        vpxor	96(%rdi), %ymm9, %ymm10
        vpxor	64(%rcx), %ymm5, %ymm11
        vpxor	(%rax), %ymm6, %ymm12
        vpxor	-64(%rdi), %ymm7, %ymm13
        vpxor	-96(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 4
        vpxor	128(%rax), %ymm7, %ymm10
        vpxor	64(%rdi), %ymm8, %ymm11
        vpxor	32(%rcx), %ymm9, %ymm12
        vpxor	-32(%rax), %ymm5, %ymm13
        vpxor	-96(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, -96(%rdi)
        # Round 11
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm12, %ymm12
        vpxor	96(%rdi), %ymm10, %ymm10
        vpxor	128(%rdi), %ymm4, %ymm14
        vpxor	-96(%rax), %ymm13, %ymm13
        vpxor	-64(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm10, %ymm10
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	(%rdi), %ymm6, %ymm11
        vpxor	-32(%rdi), %ymm7, %ymm12
        vpxor	-64(%rdi), %ymm8, %ymm13
        vpxor	-96(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	352(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 1
        vpxor	(%rcx), %ymm8, %ymm10
        vpxor	128(%rcx), %ymm9, %ymm11
        vpxor	96(%rcx), %ymm5, %ymm12
        vpxor	64(%rcx), %ymm6, %ymm13
        vpxor	32(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 2
        vpxor	96(%rax), %ymm6, %ymm10
        vpxor	-32(%rcx), %ymm7, %ymm11
        vpxor	-64(%rcx), %ymm8, %ymm12
        vpxor	-96(%rcx), %ymm9, %ymm13
        vpxor	128(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, 128(%rax)
        # Row 3
        vpxor	-64(%rax), %ymm9, %ymm10
        vpxor	64(%rax), %ymm5, %ymm11
        vpxor	32(%rax), %ymm6, %ymm12
        vpxor	(%rax), %ymm7, %ymm13
        vpxor	-32(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, -32(%rax)
        # Row 4
        vpxor	32(%rdi), %ymm7, %ymm10
        vpxor	-96(%rax), %ymm8, %ymm11
        vpxor	128(%rdi), %ymm9, %ymm12
        vpxor	96(%rdi), %ymm5, %ymm13
        vpxor	64(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 64(%rdi)
        # Round 12
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	-64(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm10, %ymm10
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	128(%rcx), %ymm6, %ymm11
        vpxor	-64(%rcx), %ymm7, %ymm12
        vpxor	(%rax), %ymm8, %ymm13
        vpxor	64(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	384(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 1
        vpxor	-64(%rdi), %ymm8, %ymm10
        vpxor	32(%rcx), %ymm9, %ymm11
        vpxor	96(%rax), %ymm5, %ymm12
        vpxor	64(%rax), %ymm6, %ymm13
        vpxor	128(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 2
        vpxor	(%rdi), %ymm6, %ymm10
        vpxor	96(%rcx), %ymm7, %ymm11
        vpxor	-96(%rcx), %ymm8, %ymm12
        vpxor	-32(%rax), %ymm9, %ymm13
        vpxor	32(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 3
        vpxor	-96(%rdi), %ymm9, %ymm10
        vpxor	(%rcx), %ymm5, %ymm11
        vpxor	-32(%rcx), %ymm6, %ymm12
        vpxor	32(%rax), %ymm7, %ymm13
        vpxor	96(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 4
        vpxor	-32(%rdi), %ymm7, %ymm10
        vpxor	64(%rcx), %ymm8, %ymm11
        vpxor	128(%rax), %ymm9, %ymm12
        vpxor	-64(%rax), %ymm5, %ymm13
        vpxor	-96(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, -96(%rax)
        # Round 13
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm10, %ymm10
        vpxor	-64(%rdi), %ymm10, %ymm10
        vpxor	(%rdi), %ymm10, %ymm10
        vpxor	32(%rdi), %ymm4, %ymm14
        vpxor	64(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	128(%rdi), %ymm14, %ymm14
        vpxor	-32(%rax), %ymm3, %ymm13
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm2, %ymm12
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm1, %ymm11
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm11, %ymm11
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	32(%rcx), %ymm6, %ymm11
        vpxor	-96(%rcx), %ymm7, %ymm12
        vpxor	32(%rax), %ymm8, %ymm13
        vpxor	-96(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	416(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, -96(%rax)
        # Row 1
        vpxor	(%rax), %ymm8, %ymm10
        vpxor	128(%rdi), %ymm9, %ymm11
        vpxor	(%rdi), %ymm5, %ymm12
        vpxor	(%rcx), %ymm6, %ymm13
        vpxor	128(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, 128(%rax)
        # Row 2
        vpxor	128(%rcx), %ymm6, %ymm10
        vpxor	96(%rax), %ymm7, %ymm11
        vpxor	-32(%rax), %ymm8, %ymm12
        vpxor	96(%rdi), %ymm9, %ymm13
        vpxor	-32(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 3
        vpxor	64(%rdi), %ymm9, %ymm10
        vpxor	-64(%rdi), %ymm5, %ymm11
        vpxor	96(%rcx), %ymm6, %ymm12
        vpxor	-32(%rcx), %ymm7, %ymm13
        vpxor	-64(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Row 4
        vpxor	-64(%rcx), %ymm7, %ymm10
        vpxor	64(%rax), %ymm8, %ymm11
        vpxor	32(%rdi), %ymm9, %ymm12
        vpxor	-96(%rdi), %ymm5, %ymm13
        vpxor	64(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, 64(%rcx)
        # Round 14
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	64(%rdi), %ymm10, %ymm10
        vpxor	96(%rdi), %ymm3, %ymm13
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm14, %ymm14
        vpxor	-64(%rax), %ymm14, %ymm14
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm11, %ymm11
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	128(%rdi), %ymm6, %ymm11
        vpxor	-32(%rax), %ymm7, %ymm12
        vpxor	-32(%rcx), %ymm8, %ymm13
        vpxor	64(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	448(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 1
        vpxor	32(%rax), %ymm8, %ymm10
        vpxor	128(%rax), %ymm9, %ymm11
        vpxor	128(%rcx), %ymm5, %ymm12
        vpxor	-64(%rdi), %ymm6, %ymm13
        vpxor	32(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 2
        vpxor	32(%rcx), %ymm6, %ymm10
        vpxor	(%rdi), %ymm7, %ymm11
        vpxor	96(%rdi), %ymm8, %ymm12
        vpxor	-64(%rax), %ymm9, %ymm13
        vpxor	-64(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 3
        vpxor	-96(%rax), %ymm9, %ymm10
        vpxor	(%rax), %ymm5, %ymm11
        vpxor	96(%rax), %ymm6, %ymm12
        vpxor	96(%rcx), %ymm7, %ymm13
        vpxor	-96(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 4
        vpxor	-96(%rcx), %ymm7, %ymm10
        vpxor	(%rcx), %ymm8, %ymm11
        vpxor	-32(%rdi), %ymm9, %ymm12
        vpxor	64(%rdi), %ymm5, %ymm13
        vpxor	64(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, 64(%rax)
        # Round 15
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm2, %ymm12
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm10, %ymm10
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm10, %ymm10
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	128(%rax), %ymm6, %ymm11
        vpxor	96(%rdi), %ymm7, %ymm12
        vpxor	96(%rcx), %ymm8, %ymm13
        vpxor	64(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	480(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, 64(%rax)
        # Row 1
        vpxor	-32(%rcx), %ymm8, %ymm10
        vpxor	32(%rdi), %ymm9, %ymm11
        vpxor	32(%rcx), %ymm5, %ymm12
        vpxor	(%rax), %ymm6, %ymm13
        vpxor	-32(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 2
        vpxor	128(%rdi), %ymm6, %ymm10
        vpxor	128(%rcx), %ymm7, %ymm11
        vpxor	-64(%rax), %ymm8, %ymm12
        vpxor	-96(%rdi), %ymm9, %ymm13
        vpxor	-96(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 3
        vpxor	64(%rcx), %ymm9, %ymm10
        vpxor	32(%rax), %ymm5, %ymm11
        vpxor	(%rdi), %ymm6, %ymm12
        vpxor	96(%rax), %ymm7, %ymm13
        vpxor	64(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 4
        vpxor	-32(%rax), %ymm7, %ymm10
        vpxor	-64(%rdi), %ymm8, %ymm11
        vpxor	-64(%rcx), %ymm9, %ymm12
        vpxor	-96(%rax), %ymm5, %ymm13
        vpxor	(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, (%rcx)
        # Round 16
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm1, %ymm11
        vpxor	64(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm12, %ymm12
        vpxor	128(%rdi), %ymm10, %ymm10
        vpxor	-64(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm10, %ymm10
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	32(%rdi), %ymm6, %ymm11
        vpxor	-64(%rax), %ymm7, %ymm12
        vpxor	96(%rax), %ymm8, %ymm13
        vpxor	(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	512(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, (%rcx)
        # Row 1
        vpxor	96(%rcx), %ymm8, %ymm10
        vpxor	-32(%rdi), %ymm9, %ymm11
        vpxor	128(%rdi), %ymm5, %ymm12
        vpxor	32(%rax), %ymm6, %ymm13
        vpxor	-64(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 2
        vpxor	128(%rax), %ymm6, %ymm10
        vpxor	32(%rcx), %ymm7, %ymm11
        vpxor	-96(%rdi), %ymm8, %ymm12
        vpxor	64(%rdi), %ymm9, %ymm13
        vpxor	-32(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, -32(%rax)
        # Row 3
        vpxor	64(%rax), %ymm9, %ymm10
        vpxor	-32(%rcx), %ymm5, %ymm11
        vpxor	128(%rcx), %ymm6, %ymm12
        vpxor	(%rdi), %ymm7, %ymm13
        vpxor	-96(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, -96(%rax)
        # Row 4
        vpxor	96(%rdi), %ymm7, %ymm10
        vpxor	(%rax), %ymm8, %ymm11
        vpxor	-96(%rcx), %ymm9, %ymm12
        vpxor	64(%rcx), %ymm5, %ymm13
        vpxor	-64(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, -64(%rdi)
        # Round 17
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm11, %ymm11
        vpxor	64(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm4, %ymm14
        vpxor	-64(%rax), %ymm12, %ymm12
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	64(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	128(%rax), %ymm10, %ymm10
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm14, %ymm14
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm10, %ymm10
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-32(%rdi), %ymm6, %ymm11
        vpxor	-96(%rdi), %ymm7, %ymm12
        vpxor	(%rdi), %ymm8, %ymm13
        vpxor	-64(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	544(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 1
        vpxor	96(%rax), %ymm8, %ymm10
        vpxor	-64(%rcx), %ymm9, %ymm11
        vpxor	128(%rax), %ymm5, %ymm12
        vpxor	-32(%rcx), %ymm6, %ymm13
        vpxor	-96(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 2
        vpxor	32(%rdi), %ymm6, %ymm10
        vpxor	128(%rdi), %ymm7, %ymm11
        vpxor	64(%rdi), %ymm8, %ymm12
        vpxor	-96(%rax), %ymm9, %ymm13
        vpxor	96(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 3
        vpxor	(%rcx), %ymm9, %ymm10
        vpxor	96(%rcx), %ymm5, %ymm11
        vpxor	32(%rcx), %ymm6, %ymm12
        vpxor	128(%rcx), %ymm7, %ymm13
        vpxor	64(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 4
        vpxor	-64(%rax), %ymm7, %ymm10
        vpxor	32(%rax), %ymm8, %ymm11
        vpxor	-32(%rax), %ymm9, %ymm12
        vpxor	64(%rax), %ymm5, %ymm13
        vpxor	(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, (%rax)
        # Round 18
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm10, %ymm10
        vpxor	64(%rdi), %ymm12, %ymm12
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm10, %ymm10
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm11, %ymm11
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-64(%rcx), %ymm6, %ymm11
        vpxor	64(%rdi), %ymm7, %ymm12
        vpxor	128(%rcx), %ymm8, %ymm13
        vpxor	(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	576(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, (%rax)
        # Row 1
        vpxor	(%rdi), %ymm8, %ymm10
        vpxor	-96(%rcx), %ymm9, %ymm11
        vpxor	32(%rdi), %ymm5, %ymm12
        vpxor	96(%rcx), %ymm6, %ymm13
        vpxor	-32(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, -32(%rax)
        # Row 2
        vpxor	-32(%rdi), %ymm6, %ymm10
        vpxor	128(%rax), %ymm7, %ymm11
        vpxor	-96(%rax), %ymm8, %ymm12
        vpxor	64(%rcx), %ymm9, %ymm13
        vpxor	-64(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Row 3
        vpxor	-64(%rdi), %ymm9, %ymm10
        vpxor	96(%rax), %ymm5, %ymm11
        vpxor	128(%rdi), %ymm6, %ymm12
        vpxor	32(%rcx), %ymm7, %ymm13
        vpxor	64(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 64(%rax)
        # Row 4
        vpxor	-96(%rdi), %ymm7, %ymm10
        vpxor	-32(%rcx), %ymm8, %ymm11
        vpxor	96(%rdi), %ymm9, %ymm12
        vpxor	(%rcx), %ymm5, %ymm13
        vpxor	32(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, 32(%rax)
        # Round 19
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm10, %ymm10
        vpxor	-32(%rdi), %ymm10, %ymm10
        vpxor	(%rdi), %ymm10, %ymm10
        vpxor	32(%rdi), %ymm2, %ymm12
        vpxor	64(%rdi), %ymm12, %ymm12
        vpxor	128(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-64(%rax), %ymm4, %ymm14
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm1, %ymm11
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	32(%rcx), %ymm3, %ymm13
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-96(%rcx), %ymm6, %ymm11
        vpxor	-96(%rax), %ymm7, %ymm12
        vpxor	32(%rcx), %ymm8, %ymm13
        vpxor	32(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	608(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 32(%rax)
        # Row 1
        vpxor	128(%rcx), %ymm8, %ymm10
        vpxor	-32(%rax), %ymm9, %ymm11
        vpxor	-32(%rdi), %ymm5, %ymm12
        vpxor	96(%rax), %ymm6, %ymm13
        vpxor	96(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 2
        vpxor	-64(%rcx), %ymm6, %ymm10
        vpxor	32(%rdi), %ymm7, %ymm11
        vpxor	64(%rcx), %ymm8, %ymm12
        vpxor	64(%rax), %ymm9, %ymm13
        vpxor	-96(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 3
        vpxor	(%rax), %ymm9, %ymm10
        vpxor	(%rdi), %ymm5, %ymm11
        vpxor	128(%rax), %ymm6, %ymm12
        vpxor	128(%rdi), %ymm7, %ymm13
        vpxor	(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, (%rcx)
        # Row 4
        vpxor	64(%rdi), %ymm7, %ymm10
        vpxor	96(%rcx), %ymm8, %ymm11
        vpxor	-64(%rax), %ymm9, %ymm12
        vpxor	-64(%rdi), %ymm5, %ymm13
        vpxor	-32(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -32(%rcx)
        # Round 20
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm11, %ymm11
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	128(%rdi), %ymm3, %ymm13
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm10, %ymm10
        vpxor	(%rcx), %ymm14, %ymm14
        vpxor	32(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-32(%rax), %ymm6, %ymm11
        vpxor	64(%rcx), %ymm7, %ymm12
        vpxor	128(%rdi), %ymm8, %ymm13
        vpxor	-32(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	640(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 1
        vpxor	32(%rcx), %ymm8, %ymm10
        vpxor	96(%rdi), %ymm9, %ymm11
        vpxor	-64(%rcx), %ymm5, %ymm12
        vpxor	(%rdi), %ymm6, %ymm13
        vpxor	-64(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, -64(%rax)
        # Row 2
        vpxor	-96(%rcx), %ymm6, %ymm10
        vpxor	-32(%rdi), %ymm7, %ymm11
        vpxor	64(%rax), %ymm8, %ymm12
        vpxor	(%rcx), %ymm9, %ymm13
        vpxor	64(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 3
        vpxor	32(%rax), %ymm9, %ymm10
        vpxor	128(%rcx), %ymm5, %ymm11
        vpxor	32(%rdi), %ymm6, %ymm12
        vpxor	128(%rax), %ymm7, %ymm13
        vpxor	-64(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 4
        vpxor	-96(%rax), %ymm7, %ymm10
        vpxor	96(%rax), %ymm8, %ymm11
        vpxor	-96(%rdi), %ymm9, %ymm12
        vpxor	(%rax), %ymm5, %ymm13
        vpxor	96(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, 96(%rcx)
        # Round 21
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm2, %ymm12
        vpxor	64(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm11, %ymm11
        vpxor	128(%rdi), %ymm13, %ymm13
        vpxor	-64(%rax), %ymm14, %ymm14
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm10, %ymm10
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm10, %ymm10
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm10, %ymm10
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	96(%rdi), %ymm6, %ymm11
        vpxor	64(%rax), %ymm7, %ymm12
        vpxor	128(%rax), %ymm8, %ymm13
        vpxor	96(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	672(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 1
        vpxor	128(%rdi), %ymm8, %ymm10
        vpxor	-64(%rax), %ymm9, %ymm11
        vpxor	-96(%rcx), %ymm5, %ymm12
        vpxor	128(%rcx), %ymm6, %ymm13
        vpxor	-96(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 2
        vpxor	-32(%rax), %ymm6, %ymm10
        vpxor	-64(%rcx), %ymm7, %ymm11
        vpxor	(%rcx), %ymm8, %ymm12
        vpxor	-64(%rdi), %ymm9, %ymm13
        vpxor	-96(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -96(%rax)
        # Row 3
        vpxor	-32(%rcx), %ymm9, %ymm10
        vpxor	32(%rcx), %ymm5, %ymm11
        vpxor	-32(%rdi), %ymm6, %ymm12
        vpxor	32(%rdi), %ymm7, %ymm13
        vpxor	(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, (%rax)
        # Row 4
        vpxor	64(%rcx), %ymm7, %ymm10
        vpxor	(%rdi), %ymm8, %ymm11
        vpxor	64(%rdi), %ymm9, %ymm12
        vpxor	32(%rax), %ymm5, %ymm13
        vpxor	96(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, 96(%rax)
        # Round 22
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm13, %ymm13
        vpxor	96(%rdi), %ymm1, %ymm11
        vpxor	128(%rdi), %ymm10, %ymm10
        vpxor	-96(%rax), %ymm14, %ymm14
        vpxor	-64(%rax), %ymm11, %ymm11
        vpxor	-32(%rax), %ymm10, %ymm10
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	-32(%rcx), %ymm10, %ymm10
        vpxor	(%rcx), %ymm12, %ymm12
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm14, %ymm14
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-64(%rax), %ymm6, %ymm11
        vpxor	(%rcx), %ymm7, %ymm12
        vpxor	32(%rdi), %ymm8, %ymm13
        vpxor	96(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	704(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 96(%rax)
        # Row 1
        vpxor	128(%rax), %ymm8, %ymm10
        vpxor	-96(%rdi), %ymm9, %ymm11
        vpxor	-32(%rax), %ymm5, %ymm12
        vpxor	32(%rcx), %ymm6, %ymm13
        vpxor	64(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 2
        vpxor	96(%rdi), %ymm6, %ymm10
        vpxor	-96(%rcx), %ymm7, %ymm11
        vpxor	-64(%rdi), %ymm8, %ymm12
        vpxor	(%rax), %ymm9, %ymm13
        vpxor	64(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 3
        vpxor	96(%rcx), %ymm9, %ymm10
        vpxor	128(%rdi), %ymm5, %ymm11
        vpxor	-64(%rcx), %ymm6, %ymm12
        vpxor	-32(%rdi), %ymm7, %ymm13
        vpxor	32(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, 32(%rax)
        # Row 4
        vpxor	64(%rax), %ymm7, %ymm10
        vpxor	128(%rcx), %ymm8, %ymm11
        vpxor	-96(%rax), %ymm9, %ymm12
        vpxor	-32(%rcx), %ymm5, %ymm13
        vpxor	(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, (%rdi)
        # Round 23
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm1, %ymm11
        vpxor	-64(%rdi), %ymm2, %ymm12
        vpxor	-32(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm13, %ymm13
        vpxor	64(%rdi), %ymm4, %ymm14
        vpxor	96(%rdi), %ymm10, %ymm10
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm11, %ymm11
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm14, %ymm14
        vpxor	128(%rax), %ymm10, %ymm10
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm12, %ymm12
        vpxor	32(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-96(%rdi), %ymm6, %ymm11
        vpxor	-64(%rdi), %ymm7, %ymm12
        vpxor	-32(%rdi), %ymm8, %ymm13
        vpxor	(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	736(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, (%rdi)
        # Row 1
        vpxor	32(%rdi), %ymm8, %ymm10
        vpxor	64(%rdi), %ymm9, %ymm11
        vpxor	96(%rdi), %ymm5, %ymm12
        vpxor	128(%rdi), %ymm6, %ymm13
        vpxor	-96(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, -96(%rax)
        # Row 2
        vpxor	-64(%rax), %ymm6, %ymm10
        vpxor	-32(%rax), %ymm7, %ymm11
        vpxor	(%rax), %ymm8, %ymm12
        vpxor	32(%rax), %ymm9, %ymm13
        vpxor	64(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, 64(%rax)
        # Row 3
        vpxor	96(%rax), %ymm9, %ymm10
        vpxor	128(%rax), %ymm5, %ymm11
        vpxor	-96(%rcx), %ymm6, %ymm12
        vpxor	-64(%rcx), %ymm7, %ymm13
        vpxor	-32(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 4
        vpxor	(%rcx), %ymm7, %ymm10
        vpxor	32(%rcx), %ymm8, %ymm11
        vpxor	64(%rcx), %ymm9, %ymm12
        vpxor	96(%rcx), %ymm5, %ymm13
        vpxor	128(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, 128(%rcx)
        subq	$0x80, %rdi
        vmovdqu	%ymm15, (%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_sha3_128_blocksx4_seed_avx2,.-kyber_sha3_128_blocksx4_seed_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_sha3_256_blockx4_seed_avx2_end_mark:
.quad	0x8000000000000000, 0x8000000000000000
.quad	0x8000000000000000, 0x8000000000000000
#ifndef __APPLE__
.text
.globl	kyber_sha3_256_blocksx4_seed_avx2
.type	kyber_sha3_256_blocksx4_seed_avx2,@function
.align	16
kyber_sha3_256_blocksx4_seed_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_sha3_256_blocksx4_seed_avx2
.p2align	4
_kyber_sha3_256_blocksx4_seed_avx2:
#endif /* __APPLE__ */
        leaq	L_sha3_parallel_4_r(%rip), %rdx
        movq	%rdi, %rax
        movq	%rdi, %rcx
        vpbroadcastq	(%rsi), %ymm15
        addq	$0x80, %rdi
        vpbroadcastq	8(%rsi), %ymm11
        addq	$0x180, %rax
        vpbroadcastq	16(%rsi), %ymm12
        addq	$0x280, %rcx
        vpbroadcastq	24(%rsi), %ymm13
        vmovdqu	L_sha3_256_blockx4_seed_avx2_end_mark(%rip), %ymm5
        vpxor	%ymm6, %ymm6, %ymm6
        vmovdqu	%ymm11, -96(%rdi)
        vmovdqu	%ymm12, -64(%rdi)
        vmovdqu	%ymm13, -32(%rdi)
        vmovdqu	(%rdi), %ymm14
        vmovdqu	%ymm6, 32(%rdi)
        vmovdqu	%ymm6, 64(%rdi)
        vmovdqu	%ymm6, 96(%rdi)
        vmovdqu	%ymm6, 128(%rdi)
        vmovdqu	%ymm6, -96(%rax)
        vmovdqu	%ymm6, -64(%rax)
        vmovdqu	%ymm6, -32(%rax)
        vmovdqu	%ymm6, (%rax)
        vmovdqu	%ymm6, 32(%rax)
        vmovdqu	%ymm6, 64(%rax)
        vmovdqu	%ymm6, 96(%rax)
        vmovdqu	%ymm5, 128(%rax)
        vmovdqu	%ymm6, -96(%rcx)
        vmovdqu	%ymm6, -64(%rcx)
        vmovdqu	%ymm6, -32(%rcx)
        vmovdqu	%ymm6, (%rcx)
        vmovdqu	%ymm6, 32(%rcx)
        vmovdqu	%ymm6, 64(%rcx)
        vmovdqu	%ymm6, 96(%rcx)
        vmovdqu	%ymm6, 128(%rcx)
        vmovdqu	%ymm15, %ymm10
        vpxor	%ymm5, %ymm11, %ymm11
        # Round 0
        # Calc b[0..4]
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	64(%rdi), %ymm6, %ymm11
        vpxor	(%rax), %ymm7, %ymm12
        vpxor	-64(%rcx), %ymm8, %ymm13
        vpxor	128(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 1
        vpxor	-32(%rdi), %ymm8, %ymm10
        vpxor	-96(%rax), %ymm9, %ymm11
        vpxor	-64(%rax), %ymm5, %ymm12
        vpxor	128(%rax), %ymm6, %ymm13
        vpxor	64(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 2
        vpxor	-96(%rdi), %ymm6, %ymm10
        vpxor	96(%rdi), %ymm7, %ymm11
        vpxor	32(%rax), %ymm8, %ymm12
        vpxor	-32(%rcx), %ymm9, %ymm13
        vpxor	(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, (%rcx)
        # Row 3
        vpxor	(%rdi), %ymm9, %ymm10
        vpxor	32(%rdi), %ymm5, %ymm11
        vpxor	-32(%rax), %ymm6, %ymm12
        vpxor	-96(%rcx), %ymm7, %ymm13
        vpxor	96(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 4
        vpxor	-64(%rdi), %ymm7, %ymm10
        vpxor	128(%rdi), %ymm8, %ymm11
        vpxor	64(%rax), %ymm9, %ymm12
        vpxor	96(%rax), %ymm5, %ymm13
        vpxor	32(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, 32(%rcx)
        # Round 1
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm10, %ymm10
        vpxor	-32(%rdi), %ymm10, %ymm10
        vpxor	(%rdi), %ymm10, %ymm10
        vpxor	32(%rdi), %ymm1, %ymm11
        vpxor	64(%rdi), %ymm11, %ymm11
        vpxor	96(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm2, %ymm12
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm3, %ymm13
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm4, %ymm14
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm14, %ymm14
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-96(%rax), %ymm6, %ymm11
        vpxor	32(%rax), %ymm7, %ymm12
        vpxor	-96(%rcx), %ymm8, %ymm13
        vpxor	32(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	32(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 1
        vpxor	-64(%rcx), %ymm8, %ymm10
        vpxor	64(%rcx), %ymm9, %ymm11
        vpxor	-96(%rdi), %ymm5, %ymm12
        vpxor	32(%rdi), %ymm6, %ymm13
        vpxor	64(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 64(%rax)
        # Row 2
        vpxor	64(%rdi), %ymm6, %ymm10
        vpxor	-64(%rax), %ymm7, %ymm11
        vpxor	-32(%rcx), %ymm8, %ymm12
        vpxor	96(%rcx), %ymm9, %ymm13
        vpxor	-64(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 3
        vpxor	128(%rcx), %ymm9, %ymm10
        vpxor	-32(%rdi), %ymm5, %ymm11
        vpxor	96(%rdi), %ymm6, %ymm12
        vpxor	-32(%rax), %ymm7, %ymm13
        vpxor	96(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 96(%rax)
        # Row 4
        vpxor	(%rax), %ymm7, %ymm10
        vpxor	128(%rax), %ymm8, %ymm11
        vpxor	(%rcx), %ymm9, %ymm12
        vpxor	(%rdi), %ymm5, %ymm13
        vpxor	128(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        # Round 2
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm3, %ymm13
        vpxor	64(%rdi), %ymm10, %ymm10
        vpxor	96(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm11, %ymm11
        vpxor	-32(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-64(%rcx), %ymm10, %ymm10
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	64(%rcx), %ymm6, %ymm11
        vpxor	-32(%rcx), %ymm7, %ymm12
        vpxor	-32(%rax), %ymm8, %ymm13
        vpxor	128(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	64(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 1
        vpxor	-96(%rcx), %ymm8, %ymm10
        vpxor	64(%rax), %ymm9, %ymm11
        vpxor	64(%rdi), %ymm5, %ymm12
        vpxor	-32(%rdi), %ymm6, %ymm13
        vpxor	(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, (%rcx)
        # Row 2
        vpxor	-96(%rax), %ymm6, %ymm10
        vpxor	-96(%rdi), %ymm7, %ymm11
        vpxor	96(%rcx), %ymm8, %ymm12
        vpxor	96(%rax), %ymm9, %ymm13
        vpxor	(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, (%rax)
        # Row 3
        vpxor	32(%rcx), %ymm9, %ymm10
        vpxor	-64(%rcx), %ymm5, %ymm11
        vpxor	-64(%rax), %ymm6, %ymm12
        vpxor	96(%rdi), %ymm7, %ymm13
        vpxor	(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, (%rdi)
        # Row 4
        vpxor	32(%rax), %ymm7, %ymm10
        vpxor	32(%rdi), %ymm8, %ymm11
        vpxor	-64(%rdi), %ymm9, %ymm12
        vpxor	128(%rcx), %ymm5, %ymm13
        vpxor	128(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, 128(%rax)
        # Round 3
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm3, %ymm13
        vpxor	(%rdi), %ymm4, %ymm14
        vpxor	64(%rdi), %ymm2, %ymm12
        vpxor	96(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm14, %ymm14
        vpxor	-96(%rax), %ymm10, %ymm10
        vpxor	-64(%rax), %ymm12, %ymm12
        vpxor	-32(%rax), %ymm13, %ymm13
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm10, %ymm10
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm14, %ymm14
        vpxor	32(%rcx), %ymm10, %ymm10
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	64(%rax), %ymm6, %ymm11
        vpxor	96(%rcx), %ymm7, %ymm12
        vpxor	96(%rdi), %ymm8, %ymm13
        vpxor	128(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	96(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rax)
        # Row 1
        vpxor	-32(%rax), %ymm8, %ymm10
        vpxor	(%rcx), %ymm9, %ymm11
        vpxor	-96(%rax), %ymm5, %ymm12
        vpxor	-64(%rcx), %ymm6, %ymm13
        vpxor	-64(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 2
        vpxor	64(%rcx), %ymm6, %ymm10
        vpxor	64(%rdi), %ymm7, %ymm11
        vpxor	96(%rax), %ymm8, %ymm12
        vpxor	(%rdi), %ymm9, %ymm13
        vpxor	32(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, 32(%rax)
        # Row 3
        vpxor	128(%rdi), %ymm9, %ymm10
        vpxor	-96(%rcx), %ymm5, %ymm11
        vpxor	-96(%rdi), %ymm6, %ymm12
        vpxor	-64(%rax), %ymm7, %ymm13
        vpxor	128(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 4
        vpxor	-32(%rcx), %ymm7, %ymm10
        vpxor	-32(%rdi), %ymm8, %ymm11
        vpxor	(%rax), %ymm9, %ymm12
        vpxor	32(%rcx), %ymm5, %ymm13
        vpxor	32(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 32(%rdi)
        # Round 4
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	64(%rdi), %ymm1, %ymm11
        vpxor	96(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm10, %ymm10
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	-32(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm11, %ymm11
        vpxor	64(%rcx), %ymm10, %ymm10
        vpxor	96(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	(%rcx), %ymm6, %ymm11
        vpxor	96(%rax), %ymm7, %ymm12
        vpxor	-64(%rax), %ymm8, %ymm13
        vpxor	32(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	128(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 1
        vpxor	96(%rdi), %ymm8, %ymm10
        vpxor	-64(%rdi), %ymm9, %ymm11
        vpxor	64(%rcx), %ymm5, %ymm12
        vpxor	-96(%rcx), %ymm6, %ymm13
        vpxor	(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, (%rax)
        # Row 2
        vpxor	64(%rax), %ymm6, %ymm10
        vpxor	-96(%rax), %ymm7, %ymm11
        vpxor	(%rdi), %ymm8, %ymm12
        vpxor	128(%rcx), %ymm9, %ymm13
        vpxor	-32(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 3
        vpxor	128(%rax), %ymm9, %ymm10
        vpxor	-32(%rax), %ymm5, %ymm11
        vpxor	64(%rdi), %ymm6, %ymm12
        vpxor	-96(%rdi), %ymm7, %ymm13
        vpxor	32(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 4
        vpxor	96(%rcx), %ymm7, %ymm10
        vpxor	-64(%rcx), %ymm8, %ymm11
        vpxor	32(%rax), %ymm9, %ymm12
        vpxor	128(%rdi), %ymm5, %ymm13
        vpxor	-32(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, -32(%rdi)
        # Round 5
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm4, %ymm14
        vpxor	64(%rdi), %ymm12, %ymm12
        vpxor	96(%rdi), %ymm10, %ymm10
        vpxor	-96(%rax), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm10, %ymm10
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm11, %ymm11
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-64(%rdi), %ymm6, %ymm11
        vpxor	(%rdi), %ymm7, %ymm12
        vpxor	-96(%rdi), %ymm8, %ymm13
        vpxor	-32(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	160(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 1
        vpxor	-64(%rax), %ymm8, %ymm10
        vpxor	(%rax), %ymm9, %ymm11
        vpxor	64(%rax), %ymm5, %ymm12
        vpxor	-32(%rax), %ymm6, %ymm13
        vpxor	32(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 32(%rax)
        # Row 2
        vpxor	(%rcx), %ymm6, %ymm10
        vpxor	64(%rcx), %ymm7, %ymm11
        vpxor	128(%rcx), %ymm8, %ymm12
        vpxor	32(%rcx), %ymm9, %ymm13
        vpxor	96(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 3
        vpxor	32(%rdi), %ymm9, %ymm10
        vpxor	96(%rdi), %ymm5, %ymm11
        vpxor	-96(%rax), %ymm6, %ymm12
        vpxor	64(%rdi), %ymm7, %ymm13
        vpxor	128(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 4
        vpxor	96(%rax), %ymm7, %ymm10
        vpxor	-96(%rcx), %ymm8, %ymm11
        vpxor	-32(%rcx), %ymm9, %ymm12
        vpxor	128(%rax), %ymm5, %ymm13
        vpxor	-64(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, -64(%rcx)
        # Round 6
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm10, %ymm10
        vpxor	64(%rdi), %ymm13, %ymm13
        vpxor	96(%rdi), %ymm11, %ymm11
        vpxor	128(%rdi), %ymm14, %ymm14
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-64(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm13, %ymm13
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm14, %ymm14
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	(%rax), %ymm6, %ymm11
        vpxor	128(%rcx), %ymm7, %ymm12
        vpxor	64(%rdi), %ymm8, %ymm13
        vpxor	-64(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	192(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 1
        vpxor	-96(%rdi), %ymm8, %ymm10
        vpxor	32(%rax), %ymm9, %ymm11
        vpxor	(%rcx), %ymm5, %ymm12
        vpxor	96(%rdi), %ymm6, %ymm13
        vpxor	-32(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 2
        vpxor	-64(%rdi), %ymm6, %ymm10
        vpxor	64(%rax), %ymm7, %ymm11
        vpxor	32(%rcx), %ymm8, %ymm12
        vpxor	128(%rdi), %ymm9, %ymm13
        vpxor	96(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, 96(%rax)
        # Row 3
        vpxor	-32(%rdi), %ymm9, %ymm10
        vpxor	-64(%rax), %ymm5, %ymm11
        vpxor	64(%rcx), %ymm6, %ymm12
        vpxor	-96(%rax), %ymm7, %ymm13
        vpxor	128(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, 128(%rax)
        # Row 4
        vpxor	(%rdi), %ymm7, %ymm10
        vpxor	-32(%rax), %ymm8, %ymm11
        vpxor	96(%rcx), %ymm9, %ymm12
        vpxor	32(%rdi), %ymm5, %ymm13
        vpxor	-96(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, -96(%rcx)
        # Round 7
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm10, %ymm10
        vpxor	-64(%rdi), %ymm10, %ymm10
        vpxor	-32(%rdi), %ymm10, %ymm10
        vpxor	64(%rdi), %ymm3, %ymm13
        vpxor	96(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm13, %ymm13
        vpxor	-96(%rax), %ymm13, %ymm13
        vpxor	-64(%rax), %ymm1, %ymm11
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm4, %ymm14
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm2, %ymm12
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	32(%rax), %ymm6, %ymm11
        vpxor	32(%rcx), %ymm7, %ymm12
        vpxor	-96(%rax), %ymm8, %ymm13
        vpxor	-96(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	224(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 1
        vpxor	64(%rdi), %ymm8, %ymm10
        vpxor	-32(%rcx), %ymm9, %ymm11
        vpxor	-64(%rdi), %ymm5, %ymm12
        vpxor	-64(%rax), %ymm6, %ymm13
        vpxor	96(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 2
        vpxor	(%rax), %ymm6, %ymm10
        vpxor	(%rcx), %ymm7, %ymm11
        vpxor	128(%rdi), %ymm8, %ymm12
        vpxor	128(%rax), %ymm9, %ymm13
        vpxor	(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, (%rdi)
        # Row 3
        vpxor	-64(%rcx), %ymm9, %ymm10
        vpxor	-96(%rdi), %ymm5, %ymm11
        vpxor	64(%rax), %ymm6, %ymm12
        vpxor	64(%rcx), %ymm7, %ymm13
        vpxor	32(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 4
        vpxor	128(%rcx), %ymm7, %ymm10
        vpxor	96(%rdi), %ymm8, %ymm11
        vpxor	96(%rax), %ymm9, %ymm12
        vpxor	-32(%rdi), %ymm5, %ymm13
        vpxor	-32(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, -32(%rax)
        # Round 8
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm1, %ymm11
        vpxor	-64(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm4, %ymm14
        vpxor	32(%rdi), %ymm14, %ymm14
        vpxor	64(%rdi), %ymm10, %ymm10
        vpxor	128(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm3, %ymm13
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm10, %ymm10
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm11, %ymm11
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-32(%rcx), %ymm6, %ymm11
        vpxor	128(%rdi), %ymm7, %ymm12
        vpxor	64(%rcx), %ymm8, %ymm13
        vpxor	-32(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	256(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, -32(%rax)
        # Row 1
        vpxor	-96(%rax), %ymm8, %ymm10
        vpxor	96(%rcx), %ymm9, %ymm11
        vpxor	(%rax), %ymm5, %ymm12
        vpxor	-96(%rdi), %ymm6, %ymm13
        vpxor	96(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, 96(%rax)
        # Row 2
        vpxor	32(%rax), %ymm6, %ymm10
        vpxor	-64(%rdi), %ymm7, %ymm11
        vpxor	128(%rax), %ymm8, %ymm12
        vpxor	32(%rdi), %ymm9, %ymm13
        vpxor	128(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 3
        vpxor	-96(%rcx), %ymm9, %ymm10
        vpxor	64(%rdi), %ymm5, %ymm11
        vpxor	(%rcx), %ymm6, %ymm12
        vpxor	64(%rax), %ymm7, %ymm13
        vpxor	-32(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 4
        vpxor	32(%rcx), %ymm7, %ymm10
        vpxor	-64(%rax), %ymm8, %ymm11
        vpxor	(%rdi), %ymm9, %ymm12
        vpxor	-64(%rcx), %ymm5, %ymm13
        vpxor	96(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, 96(%rdi)
        # Round 9
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	32(%rdi), %ymm13, %ymm13
        vpxor	64(%rdi), %ymm11, %ymm11
        vpxor	128(%rdi), %ymm2, %ymm12
        vpxor	-96(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm10, %ymm10
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm14, %ymm14
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-96(%rcx), %ymm10, %ymm10
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm11, %ymm11
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	96(%rcx), %ymm6, %ymm11
        vpxor	128(%rax), %ymm7, %ymm12
        vpxor	64(%rax), %ymm8, %ymm13
        vpxor	96(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	288(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 1
        vpxor	64(%rcx), %ymm8, %ymm10
        vpxor	96(%rax), %ymm9, %ymm11
        vpxor	32(%rax), %ymm5, %ymm12
        vpxor	64(%rdi), %ymm6, %ymm13
        vpxor	(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, (%rdi)
        # Row 2
        vpxor	-32(%rcx), %ymm6, %ymm10
        vpxor	(%rax), %ymm7, %ymm11
        vpxor	32(%rdi), %ymm8, %ymm12
        vpxor	-32(%rdi), %ymm9, %ymm13
        vpxor	32(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 3
        vpxor	-32(%rax), %ymm9, %ymm10
        vpxor	-96(%rax), %ymm5, %ymm11
        vpxor	-64(%rdi), %ymm6, %ymm12
        vpxor	(%rcx), %ymm7, %ymm13
        vpxor	-64(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 4
        vpxor	128(%rdi), %ymm7, %ymm10
        vpxor	-96(%rdi), %ymm8, %ymm11
        vpxor	128(%rcx), %ymm9, %ymm12
        vpxor	-96(%rcx), %ymm5, %ymm13
        vpxor	-64(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Round 10
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm2, %ymm12
        vpxor	-32(%rdi), %ymm3, %ymm13
        vpxor	(%rdi), %ymm4, %ymm14
        vpxor	32(%rdi), %ymm12, %ymm12
        vpxor	64(%rdi), %ymm13, %ymm13
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	-96(%rax), %ymm1, %ymm11
        vpxor	-32(%rax), %ymm10, %ymm10
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm11, %ymm11
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm10, %ymm10
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm10, %ymm10
        vpxor	96(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	96(%rax), %ymm6, %ymm11
        vpxor	32(%rdi), %ymm7, %ymm12
        vpxor	(%rcx), %ymm8, %ymm13
        vpxor	-64(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	320(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Row 1
        vpxor	64(%rax), %ymm8, %ymm10
        vpxor	(%rdi), %ymm9, %ymm11
        vpxor	-32(%rcx), %ymm5, %ymm12
        vpxor	-96(%rax), %ymm6, %ymm13
        vpxor	128(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 2
        vpxor	96(%rcx), %ymm6, %ymm10
        vpxor	32(%rax), %ymm7, %ymm11
        vpxor	-32(%rdi), %ymm8, %ymm12
        vpxor	-64(%rcx), %ymm9, %ymm13
        vpxor	128(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 3
        vpxor	96(%rdi), %ymm9, %ymm10
        vpxor	64(%rcx), %ymm5, %ymm11
        vpxor	(%rax), %ymm6, %ymm12
        vpxor	-64(%rdi), %ymm7, %ymm13
        vpxor	-96(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 4
        vpxor	128(%rax), %ymm7, %ymm10
        vpxor	64(%rdi), %ymm8, %ymm11
        vpxor	32(%rcx), %ymm9, %ymm12
        vpxor	-32(%rax), %ymm5, %ymm13
        vpxor	-96(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, -96(%rdi)
        # Round 11
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm12, %ymm12
        vpxor	96(%rdi), %ymm10, %ymm10
        vpxor	128(%rdi), %ymm4, %ymm14
        vpxor	-96(%rax), %ymm13, %ymm13
        vpxor	-64(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm10, %ymm10
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	(%rdi), %ymm6, %ymm11
        vpxor	-32(%rdi), %ymm7, %ymm12
        vpxor	-64(%rdi), %ymm8, %ymm13
        vpxor	-96(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	352(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 1
        vpxor	(%rcx), %ymm8, %ymm10
        vpxor	128(%rcx), %ymm9, %ymm11
        vpxor	96(%rcx), %ymm5, %ymm12
        vpxor	64(%rcx), %ymm6, %ymm13
        vpxor	32(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 2
        vpxor	96(%rax), %ymm6, %ymm10
        vpxor	-32(%rcx), %ymm7, %ymm11
        vpxor	-64(%rcx), %ymm8, %ymm12
        vpxor	-96(%rcx), %ymm9, %ymm13
        vpxor	128(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, 128(%rax)
        # Row 3
        vpxor	-64(%rax), %ymm9, %ymm10
        vpxor	64(%rax), %ymm5, %ymm11
        vpxor	32(%rax), %ymm6, %ymm12
        vpxor	(%rax), %ymm7, %ymm13
        vpxor	-32(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, -32(%rax)
        # Row 4
        vpxor	32(%rdi), %ymm7, %ymm10
        vpxor	-96(%rax), %ymm8, %ymm11
        vpxor	128(%rdi), %ymm9, %ymm12
        vpxor	96(%rdi), %ymm5, %ymm13
        vpxor	64(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 64(%rdi)
        # Round 12
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	-64(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm10, %ymm10
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	128(%rcx), %ymm6, %ymm11
        vpxor	-64(%rcx), %ymm7, %ymm12
        vpxor	(%rax), %ymm8, %ymm13
        vpxor	64(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	384(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 1
        vpxor	-64(%rdi), %ymm8, %ymm10
        vpxor	32(%rcx), %ymm9, %ymm11
        vpxor	96(%rax), %ymm5, %ymm12
        vpxor	64(%rax), %ymm6, %ymm13
        vpxor	128(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 2
        vpxor	(%rdi), %ymm6, %ymm10
        vpxor	96(%rcx), %ymm7, %ymm11
        vpxor	-96(%rcx), %ymm8, %ymm12
        vpxor	-32(%rax), %ymm9, %ymm13
        vpxor	32(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 3
        vpxor	-96(%rdi), %ymm9, %ymm10
        vpxor	(%rcx), %ymm5, %ymm11
        vpxor	-32(%rcx), %ymm6, %ymm12
        vpxor	32(%rax), %ymm7, %ymm13
        vpxor	96(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 4
        vpxor	-32(%rdi), %ymm7, %ymm10
        vpxor	64(%rcx), %ymm8, %ymm11
        vpxor	128(%rax), %ymm9, %ymm12
        vpxor	-64(%rax), %ymm5, %ymm13
        vpxor	-96(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, -96(%rax)
        # Round 13
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm10, %ymm10
        vpxor	-64(%rdi), %ymm10, %ymm10
        vpxor	(%rdi), %ymm10, %ymm10
        vpxor	32(%rdi), %ymm4, %ymm14
        vpxor	64(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	128(%rdi), %ymm14, %ymm14
        vpxor	-32(%rax), %ymm3, %ymm13
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm2, %ymm12
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm1, %ymm11
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm11, %ymm11
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	32(%rcx), %ymm6, %ymm11
        vpxor	-96(%rcx), %ymm7, %ymm12
        vpxor	32(%rax), %ymm8, %ymm13
        vpxor	-96(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	416(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, -96(%rax)
        # Row 1
        vpxor	(%rax), %ymm8, %ymm10
        vpxor	128(%rdi), %ymm9, %ymm11
        vpxor	(%rdi), %ymm5, %ymm12
        vpxor	(%rcx), %ymm6, %ymm13
        vpxor	128(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, 128(%rax)
        # Row 2
        vpxor	128(%rcx), %ymm6, %ymm10
        vpxor	96(%rax), %ymm7, %ymm11
        vpxor	-32(%rax), %ymm8, %ymm12
        vpxor	96(%rdi), %ymm9, %ymm13
        vpxor	-32(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 3
        vpxor	64(%rdi), %ymm9, %ymm10
        vpxor	-64(%rdi), %ymm5, %ymm11
        vpxor	96(%rcx), %ymm6, %ymm12
        vpxor	-32(%rcx), %ymm7, %ymm13
        vpxor	-64(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Row 4
        vpxor	-64(%rcx), %ymm7, %ymm10
        vpxor	64(%rax), %ymm8, %ymm11
        vpxor	32(%rdi), %ymm9, %ymm12
        vpxor	-96(%rdi), %ymm5, %ymm13
        vpxor	64(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, 64(%rcx)
        # Round 14
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	64(%rdi), %ymm10, %ymm10
        vpxor	96(%rdi), %ymm3, %ymm13
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm14, %ymm14
        vpxor	-64(%rax), %ymm14, %ymm14
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm11, %ymm11
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	128(%rdi), %ymm6, %ymm11
        vpxor	-32(%rax), %ymm7, %ymm12
        vpxor	-32(%rcx), %ymm8, %ymm13
        vpxor	64(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	448(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 1
        vpxor	32(%rax), %ymm8, %ymm10
        vpxor	128(%rax), %ymm9, %ymm11
        vpxor	128(%rcx), %ymm5, %ymm12
        vpxor	-64(%rdi), %ymm6, %ymm13
        vpxor	32(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 2
        vpxor	32(%rcx), %ymm6, %ymm10
        vpxor	(%rdi), %ymm7, %ymm11
        vpxor	96(%rdi), %ymm8, %ymm12
        vpxor	-64(%rax), %ymm9, %ymm13
        vpxor	-64(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 3
        vpxor	-96(%rax), %ymm9, %ymm10
        vpxor	(%rax), %ymm5, %ymm11
        vpxor	96(%rax), %ymm6, %ymm12
        vpxor	96(%rcx), %ymm7, %ymm13
        vpxor	-96(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 4
        vpxor	-96(%rcx), %ymm7, %ymm10
        vpxor	(%rcx), %ymm8, %ymm11
        vpxor	-32(%rdi), %ymm9, %ymm12
        vpxor	64(%rdi), %ymm5, %ymm13
        vpxor	64(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, 64(%rax)
        # Round 15
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm2, %ymm12
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm10, %ymm10
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm10, %ymm10
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	128(%rax), %ymm6, %ymm11
        vpxor	96(%rdi), %ymm7, %ymm12
        vpxor	96(%rcx), %ymm8, %ymm13
        vpxor	64(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	480(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, 64(%rax)
        # Row 1
        vpxor	-32(%rcx), %ymm8, %ymm10
        vpxor	32(%rdi), %ymm9, %ymm11
        vpxor	32(%rcx), %ymm5, %ymm12
        vpxor	(%rax), %ymm6, %ymm13
        vpxor	-32(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 2
        vpxor	128(%rdi), %ymm6, %ymm10
        vpxor	128(%rcx), %ymm7, %ymm11
        vpxor	-64(%rax), %ymm8, %ymm12
        vpxor	-96(%rdi), %ymm9, %ymm13
        vpxor	-96(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 3
        vpxor	64(%rcx), %ymm9, %ymm10
        vpxor	32(%rax), %ymm5, %ymm11
        vpxor	(%rdi), %ymm6, %ymm12
        vpxor	96(%rax), %ymm7, %ymm13
        vpxor	64(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 4
        vpxor	-32(%rax), %ymm7, %ymm10
        vpxor	-64(%rdi), %ymm8, %ymm11
        vpxor	-64(%rcx), %ymm9, %ymm12
        vpxor	-96(%rax), %ymm5, %ymm13
        vpxor	(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, (%rcx)
        # Round 16
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm1, %ymm11
        vpxor	64(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm12, %ymm12
        vpxor	128(%rdi), %ymm10, %ymm10
        vpxor	-64(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm10, %ymm10
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	32(%rdi), %ymm6, %ymm11
        vpxor	-64(%rax), %ymm7, %ymm12
        vpxor	96(%rax), %ymm8, %ymm13
        vpxor	(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	512(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, (%rcx)
        # Row 1
        vpxor	96(%rcx), %ymm8, %ymm10
        vpxor	-32(%rdi), %ymm9, %ymm11
        vpxor	128(%rdi), %ymm5, %ymm12
        vpxor	32(%rax), %ymm6, %ymm13
        vpxor	-64(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 2
        vpxor	128(%rax), %ymm6, %ymm10
        vpxor	32(%rcx), %ymm7, %ymm11
        vpxor	-96(%rdi), %ymm8, %ymm12
        vpxor	64(%rdi), %ymm9, %ymm13
        vpxor	-32(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, -32(%rax)
        # Row 3
        vpxor	64(%rax), %ymm9, %ymm10
        vpxor	-32(%rcx), %ymm5, %ymm11
        vpxor	128(%rcx), %ymm6, %ymm12
        vpxor	(%rdi), %ymm7, %ymm13
        vpxor	-96(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, -96(%rax)
        # Row 4
        vpxor	96(%rdi), %ymm7, %ymm10
        vpxor	(%rax), %ymm8, %ymm11
        vpxor	-96(%rcx), %ymm9, %ymm12
        vpxor	64(%rcx), %ymm5, %ymm13
        vpxor	-64(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, -64(%rdi)
        # Round 17
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm11, %ymm11
        vpxor	64(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm4, %ymm14
        vpxor	-64(%rax), %ymm12, %ymm12
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	64(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	128(%rax), %ymm10, %ymm10
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm14, %ymm14
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm10, %ymm10
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-32(%rdi), %ymm6, %ymm11
        vpxor	-96(%rdi), %ymm7, %ymm12
        vpxor	(%rdi), %ymm8, %ymm13
        vpxor	-64(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	544(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 1
        vpxor	96(%rax), %ymm8, %ymm10
        vpxor	-64(%rcx), %ymm9, %ymm11
        vpxor	128(%rax), %ymm5, %ymm12
        vpxor	-32(%rcx), %ymm6, %ymm13
        vpxor	-96(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 2
        vpxor	32(%rdi), %ymm6, %ymm10
        vpxor	128(%rdi), %ymm7, %ymm11
        vpxor	64(%rdi), %ymm8, %ymm12
        vpxor	-96(%rax), %ymm9, %ymm13
        vpxor	96(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 3
        vpxor	(%rcx), %ymm9, %ymm10
        vpxor	96(%rcx), %ymm5, %ymm11
        vpxor	32(%rcx), %ymm6, %ymm12
        vpxor	128(%rcx), %ymm7, %ymm13
        vpxor	64(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 4
        vpxor	-64(%rax), %ymm7, %ymm10
        vpxor	32(%rax), %ymm8, %ymm11
        vpxor	-32(%rax), %ymm9, %ymm12
        vpxor	64(%rax), %ymm5, %ymm13
        vpxor	(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, (%rax)
        # Round 18
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm10, %ymm10
        vpxor	64(%rdi), %ymm12, %ymm12
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm10, %ymm10
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm11, %ymm11
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-64(%rcx), %ymm6, %ymm11
        vpxor	64(%rdi), %ymm7, %ymm12
        vpxor	128(%rcx), %ymm8, %ymm13
        vpxor	(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	576(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, (%rax)
        # Row 1
        vpxor	(%rdi), %ymm8, %ymm10
        vpxor	-96(%rcx), %ymm9, %ymm11
        vpxor	32(%rdi), %ymm5, %ymm12
        vpxor	96(%rcx), %ymm6, %ymm13
        vpxor	-32(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, -32(%rax)
        # Row 2
        vpxor	-32(%rdi), %ymm6, %ymm10
        vpxor	128(%rax), %ymm7, %ymm11
        vpxor	-96(%rax), %ymm8, %ymm12
        vpxor	64(%rcx), %ymm9, %ymm13
        vpxor	-64(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Row 3
        vpxor	-64(%rdi), %ymm9, %ymm10
        vpxor	96(%rax), %ymm5, %ymm11
        vpxor	128(%rdi), %ymm6, %ymm12
        vpxor	32(%rcx), %ymm7, %ymm13
        vpxor	64(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 64(%rax)
        # Row 4
        vpxor	-96(%rdi), %ymm7, %ymm10
        vpxor	-32(%rcx), %ymm8, %ymm11
        vpxor	96(%rdi), %ymm9, %ymm12
        vpxor	(%rcx), %ymm5, %ymm13
        vpxor	32(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, 32(%rax)
        # Round 19
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm10, %ymm10
        vpxor	-32(%rdi), %ymm10, %ymm10
        vpxor	(%rdi), %ymm10, %ymm10
        vpxor	32(%rdi), %ymm2, %ymm12
        vpxor	64(%rdi), %ymm12, %ymm12
        vpxor	128(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-64(%rax), %ymm4, %ymm14
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm1, %ymm11
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	32(%rcx), %ymm3, %ymm13
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-96(%rcx), %ymm6, %ymm11
        vpxor	-96(%rax), %ymm7, %ymm12
        vpxor	32(%rcx), %ymm8, %ymm13
        vpxor	32(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	608(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 32(%rax)
        # Row 1
        vpxor	128(%rcx), %ymm8, %ymm10
        vpxor	-32(%rax), %ymm9, %ymm11
        vpxor	-32(%rdi), %ymm5, %ymm12
        vpxor	96(%rax), %ymm6, %ymm13
        vpxor	96(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 2
        vpxor	-64(%rcx), %ymm6, %ymm10
        vpxor	32(%rdi), %ymm7, %ymm11
        vpxor	64(%rcx), %ymm8, %ymm12
        vpxor	64(%rax), %ymm9, %ymm13
        vpxor	-96(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 3
        vpxor	(%rax), %ymm9, %ymm10
        vpxor	(%rdi), %ymm5, %ymm11
        vpxor	128(%rax), %ymm6, %ymm12
        vpxor	128(%rdi), %ymm7, %ymm13
        vpxor	(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, (%rcx)
        # Row 4
        vpxor	64(%rdi), %ymm7, %ymm10
        vpxor	96(%rcx), %ymm8, %ymm11
        vpxor	-64(%rax), %ymm9, %ymm12
        vpxor	-64(%rdi), %ymm5, %ymm13
        vpxor	-32(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -32(%rcx)
        # Round 20
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm11, %ymm11
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	128(%rdi), %ymm3, %ymm13
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm10, %ymm10
        vpxor	(%rcx), %ymm14, %ymm14
        vpxor	32(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-32(%rax), %ymm6, %ymm11
        vpxor	64(%rcx), %ymm7, %ymm12
        vpxor	128(%rdi), %ymm8, %ymm13
        vpxor	-32(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	640(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 1
        vpxor	32(%rcx), %ymm8, %ymm10
        vpxor	96(%rdi), %ymm9, %ymm11
        vpxor	-64(%rcx), %ymm5, %ymm12
        vpxor	(%rdi), %ymm6, %ymm13
        vpxor	-64(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, -64(%rax)
        # Row 2
        vpxor	-96(%rcx), %ymm6, %ymm10
        vpxor	-32(%rdi), %ymm7, %ymm11
        vpxor	64(%rax), %ymm8, %ymm12
        vpxor	(%rcx), %ymm9, %ymm13
        vpxor	64(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 3
        vpxor	32(%rax), %ymm9, %ymm10
        vpxor	128(%rcx), %ymm5, %ymm11
        vpxor	32(%rdi), %ymm6, %ymm12
        vpxor	128(%rax), %ymm7, %ymm13
        vpxor	-64(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 4
        vpxor	-96(%rax), %ymm7, %ymm10
        vpxor	96(%rax), %ymm8, %ymm11
        vpxor	-96(%rdi), %ymm9, %ymm12
        vpxor	(%rax), %ymm5, %ymm13
        vpxor	96(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, 96(%rcx)
        # Round 21
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm2, %ymm12
        vpxor	64(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm11, %ymm11
        vpxor	128(%rdi), %ymm13, %ymm13
        vpxor	-64(%rax), %ymm14, %ymm14
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm10, %ymm10
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm10, %ymm10
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm10, %ymm10
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	96(%rdi), %ymm6, %ymm11
        vpxor	64(%rax), %ymm7, %ymm12
        vpxor	128(%rax), %ymm8, %ymm13
        vpxor	96(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	672(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 1
        vpxor	128(%rdi), %ymm8, %ymm10
        vpxor	-64(%rax), %ymm9, %ymm11
        vpxor	-96(%rcx), %ymm5, %ymm12
        vpxor	128(%rcx), %ymm6, %ymm13
        vpxor	-96(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 2
        vpxor	-32(%rax), %ymm6, %ymm10
        vpxor	-64(%rcx), %ymm7, %ymm11
        vpxor	(%rcx), %ymm8, %ymm12
        vpxor	-64(%rdi), %ymm9, %ymm13
        vpxor	-96(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -96(%rax)
        # Row 3
        vpxor	-32(%rcx), %ymm9, %ymm10
        vpxor	32(%rcx), %ymm5, %ymm11
        vpxor	-32(%rdi), %ymm6, %ymm12
        vpxor	32(%rdi), %ymm7, %ymm13
        vpxor	(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, (%rax)
        # Row 4
        vpxor	64(%rcx), %ymm7, %ymm10
        vpxor	(%rdi), %ymm8, %ymm11
        vpxor	64(%rdi), %ymm9, %ymm12
        vpxor	32(%rax), %ymm5, %ymm13
        vpxor	96(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, 96(%rax)
        # Round 22
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm13, %ymm13
        vpxor	96(%rdi), %ymm1, %ymm11
        vpxor	128(%rdi), %ymm10, %ymm10
        vpxor	-96(%rax), %ymm14, %ymm14
        vpxor	-64(%rax), %ymm11, %ymm11
        vpxor	-32(%rax), %ymm10, %ymm10
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	-32(%rcx), %ymm10, %ymm10
        vpxor	(%rcx), %ymm12, %ymm12
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm14, %ymm14
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-64(%rax), %ymm6, %ymm11
        vpxor	(%rcx), %ymm7, %ymm12
        vpxor	32(%rdi), %ymm8, %ymm13
        vpxor	96(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	704(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 96(%rax)
        # Row 1
        vpxor	128(%rax), %ymm8, %ymm10
        vpxor	-96(%rdi), %ymm9, %ymm11
        vpxor	-32(%rax), %ymm5, %ymm12
        vpxor	32(%rcx), %ymm6, %ymm13
        vpxor	64(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 2
        vpxor	96(%rdi), %ymm6, %ymm10
        vpxor	-96(%rcx), %ymm7, %ymm11
        vpxor	-64(%rdi), %ymm8, %ymm12
        vpxor	(%rax), %ymm9, %ymm13
        vpxor	64(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 3
        vpxor	96(%rcx), %ymm9, %ymm10
        vpxor	128(%rdi), %ymm5, %ymm11
        vpxor	-64(%rcx), %ymm6, %ymm12
        vpxor	-32(%rdi), %ymm7, %ymm13
        vpxor	32(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, 32(%rax)
        # Row 4
        vpxor	64(%rax), %ymm7, %ymm10
        vpxor	128(%rcx), %ymm8, %ymm11
        vpxor	-96(%rax), %ymm9, %ymm12
        vpxor	-32(%rcx), %ymm5, %ymm13
        vpxor	(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, (%rdi)
        # Round 23
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm1, %ymm11
        vpxor	-64(%rdi), %ymm2, %ymm12
        vpxor	-32(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm13, %ymm13
        vpxor	64(%rdi), %ymm4, %ymm14
        vpxor	96(%rdi), %ymm10, %ymm10
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm11, %ymm11
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm14, %ymm14
        vpxor	128(%rax), %ymm10, %ymm10
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm12, %ymm12
        vpxor	32(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-96(%rdi), %ymm6, %ymm11
        vpxor	-64(%rdi), %ymm7, %ymm12
        vpxor	-32(%rdi), %ymm8, %ymm13
        vpxor	(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	736(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, (%rdi)
        # Row 1
        vpxor	32(%rdi), %ymm8, %ymm10
        vpxor	64(%rdi), %ymm9, %ymm11
        vpxor	96(%rdi), %ymm5, %ymm12
        vpxor	128(%rdi), %ymm6, %ymm13
        vpxor	-96(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, -96(%rax)
        # Row 2
        vpxor	-64(%rax), %ymm6, %ymm10
        vpxor	-32(%rax), %ymm7, %ymm11
        vpxor	(%rax), %ymm8, %ymm12
        vpxor	32(%rax), %ymm9, %ymm13
        vpxor	64(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, 64(%rax)
        # Row 3
        vpxor	96(%rax), %ymm9, %ymm10
        vpxor	128(%rax), %ymm5, %ymm11
        vpxor	-96(%rcx), %ymm6, %ymm12
        vpxor	-64(%rcx), %ymm7, %ymm13
        vpxor	-32(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 4
        vpxor	(%rcx), %ymm7, %ymm10
        vpxor	32(%rcx), %ymm8, %ymm11
        vpxor	64(%rcx), %ymm9, %ymm12
        vpxor	96(%rcx), %ymm5, %ymm13
        vpxor	128(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, 128(%rcx)
        subq	$0x80, %rdi
        vmovdqu	%ymm15, (%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_sha3_256_blocksx4_seed_avx2,.-kyber_sha3_256_blocksx4_seed_avx2
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#endif /* WOLFSSL_WC_KYBER */

#if defined(__linux__) && defined(__ELF__)
.section	.note.GNU-stack,"",%progbits
#endif
