/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.devapi;

import com.mysql.cj.api.x.InsertStatement;
import com.mysql.cj.api.x.Result;
import com.mysql.cj.core.io.StatementExecuteOk;
import com.mysql.cj.mysqlx.InsertParams;
import com.mysql.cj.mysqlx.devapi.TableImpl;
import com.mysql.cj.mysqlx.devapi.UpdateResult;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class InsertStatementImpl
implements InsertStatement {
    private TableImpl table;
    private InsertParams insertParams = new InsertParams();

    InsertStatementImpl(TableImpl table, String[] fields) {
        this.table = table;
        this.insertParams.setProjection(fields);
    }

    InsertStatementImpl(TableImpl table, Map<String, Object> fieldsAndValues) {
        this.table = table;
        this.insertParams.setFieldsAndValues(fieldsAndValues);
    }

    @Override
    public Result execute() {
        StatementExecuteOk ok = this.table.getSession().getMysqlxSession().insertRows(this.table.getSchema().getName(), this.table.getName(), this.insertParams);
        return new UpdateResult(ok, null);
    }

    @Override
    public CompletableFuture<Result> executeAsync() {
        CompletableFuture<StatementExecuteOk> okF = this.table.getSession().getMysqlxSession().asyncInsertRows(this.table.getSchema().getName(), this.table.getName(), this.insertParams);
        return okF.thenApply(ok -> new UpdateResult((StatementExecuteOk)ok, null));
    }

    @Override
    public InsertStatement values(List<Object> row) {
        this.insertParams.addRow(row);
        return this;
    }
}

