/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


// CodeTables.cpp

//********************************************************************
//********************************************************************

#include <string.h>
#include "stdafx.h"
#include "rout_own.h"
#include "ligas.h"

static void ChangeUserFontToAscii();
static void fromcp1250_to_cp852();	// 05.09.2000 E.P.

//********************************************************************
/***************************/
/*********** ISO ***********/
/***************************/

// european - no actual
static uchar iso_euro[257]={
/*0*/    "@@@@@@@@@@@@@@@@"
/*1*/    "@@@@@@@@@@@@@@@@"
/*2*/		 " !\"#$%&'()*+,-./"
/*3*/		 "0123456789:;<=>?"
/*4*/		 "@ABCDEFGHIJKLMNO"
/*5*/		 "PQRSTUVWXYZ[\\]^-"
/*6*/		 "`abcdefghijklmno"
/*7*/		 "pqrstuvwxyz{|}~ "
/*8*/    "                "
/*9*/    "     *   T      "
/*A*/    "      # C< R"
/*B*/    "       >   "
/*C*/    "\xB0\xB1\xB2\xB3\xB4\xB5\xB6\xB7\xB8\xB9\xBA\xBB\xBC\xBD\xBE\xBF"
/*D*/    "\xC0\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xCA\xCB\xCC\xCD\xCE\xCF"
/*E*/    "\xD0\xD1\xD2\xD3\xD4\xD5\xD6\xD7\xD8\xD9\xDA\xDB\xDC\xDD\xDE\xDF"
/*F*/    "\xE0\xE1\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xEA\xEB\xEC\xED\xEE\xEF"
      };

// cyrillic - actual 09-10-1996
static uchar iso_cyr[257]={
/*0*/    "@@@@@@@@@@@@@@@@"
/*1*/    "@@@@@@@@@@@@@@@@"
/*2*/		 " !\"#$%&'()*+,-./"
/*3*/		 "0123456789:;<=>?"
/*4*/		 "@ABCDEFGHIJKLMNO"
/*5*/		 "PQRSTUVWXYZ[\\]^-"
/*6*/		 "`abcdefghijklmno"
/*7*/		 "pqrstuvwxyz{|}~ "
/*8*/    "           "
/*9*/    "    *   T  \xff"
/*A*/    "     #C< R"
/*B*/    "      >  "
/*C*/    "\xB0\xB1\xB2\xB3\xB4\xB5\xB6\xB7\xB8\xB9\xBA\xBB\xBC\xBD\xBE\xBF"
/*D*/    "\xC0\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8\xC9\xCA\xCB\xCC\xCD\xCE\xCF"
/*E*/    "\xD0\xD1\xD2\xD3\xD4\xD5\xD6\xD7\xD8\xD9\xDA\xDB\xDC\xDD\xDE\xDF"
/*F*/    "\xE0\xE1\xE2\xE3\xE4\xE5\xE6\xE7\xE8\xE9\xEA\xEB\xEC\xED\xEE\xEF"
      };

// ISO8859-2 (Latin 2)   
static uchar iso_ce[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/* 0*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/* 1*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/* 2*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/* 3*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/* 4*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/* 5*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/* 6*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/* 7*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/* 8*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0xa9,0x8b,0xa6,0xab,0xae,0xac,
/* 9*/ 0x90,0x91,0x92,0x93,0x94,0xB0,0x96,0x97,0x98,0x99,0xb9,0x9b,0xb6,0xbb,0xbe,0xbc,
/* a*/ 0xB9,0xa1,0xa2,0xa3,0xa4,0xa1,0xa6,0xa7,0xa8,0xa9,0x8C,0xab,0x9C,0xad,0xae,0xaf,
/* b*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb1,0xba,0xbb,0xa5,0xbd,0xb5,0xbf,
/* c*/ 0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* d*/ 0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/* e*/ 0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* f*/ 0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};

// ISO8859-4 (Latin 4)   
static uchar iso_baltic[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/*00*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/*10*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/*20*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/*30*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/*40*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/*50*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/*60*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/*70*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/*80*/  ' ',0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c, 168, 183, 184,
/*90*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c, 175, 178,0x9f,
/*a0*/ 0xa0,0xa1, ' ', ' ',0xa4,0xa5, ' ',0xa7, 216, ' ', 163, ' ', ' ', 198,0xae,0xaf,
/*b0*/ 0xb0, ' ', ' ',0xb3,0xb4,0xb5, ' ', ' ', 248, ' ', 179, ' ', ' ', ' ', ' ', 230,
/*c0*/  161, 199, 192, ' ',0xc4,0xc5, 202, 170,0xc8,0xc9, ' ', 204, 171, 211, 207, 166,
/*d0*/  138, ' ',0xd2, ' ', 210,0xd5,0xd6,0xd7, 217, ' ', ' ', 222,0xdc, ' ', 174,0xdf,
/*e0*/  177, 231, 224, ' ',0xe4,0xe5, 234, 186,0xe8,0xe9, ' ', 236, 187, 243, 239, 182,
/*f0*/  185, ' ', 241, ' ', 242,0xf5,0xf6,0xf7, 249, ' ', ' ', 254,0xfc, ' ', 190,0xff};

// ISO8859-9 (Latin 5)   
//    1:1. 20.05.2002 E.P.
static uchar iso_turkish[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/*00*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/*10*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/*20*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/*30*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/*40*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/*50*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/*60*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/*70*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/*80*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/*90*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/*a0*/ 0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0x9C,0xad,0xae,0xaf,
/*b0*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/*c0*/ 0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/*d0*/ 0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/*e0*/ 0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/*f0*/ 0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};

static puchar iso_table[PUMA_LANG_TOTAL]={
  iso_euro,		// LANG_ENGLISH    0
  iso_euro,		// LANG_GERMAN     1
  iso_euro,		// LANG_FRENCH     2
  iso_cyr,		// LANG_RUSSIAN    3
  iso_euro,		// LANG_SWEDISH    4
  iso_euro,		// LANG_SPANISH    5
  iso_euro,		// LANG_ITALIAN    6
  iso_cyr,		// LANG_RUS/ENG    7
  iso_cyr,		// LANG_UKRAINIAN  8
  iso_cyr,		// LANG_SERBIAN    9
  iso_ce,		// LANG_CROATIAN   10
  iso_ce,		// LANG_POLISH     11
  iso_euro,		// LANG_DANISH     12
  iso_euro,		// LANG_PORTUGUESE 13
  iso_euro,		// LANG_DUTCH      14
  iso_cyr,		// LANG_DIG		   15
  iso_cyr,		// LANG_UZBEK      16
  iso_cyr,		// LANG_KAZ        17
  iso_cyr,		// LANG_KAZ_ENG    18
  iso_ce,		// LANG_CZECH	   19
  iso_ce,		// LANG_ROMAN	   20
  iso_ce,		// LANG_HUNGAR	   21
  iso_cyr,		// LANG_BULGAR	   22
  iso_ce,		// LANG_SLOVENIAN  23	// 25.05.2001 E.P.
  iso_baltic,	// LANG_LATVIAN	   24
  iso_baltic,	// LANG_LITHUANIAN 25
  iso_baltic,	// LANG_ESTONIAN   26
  iso_turkish	// LANG_TURKISH	   27
};

/**********************************/
/************* ANSI ***************/
/**********************************/
// european actual
static uchar ansi_euro[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/* 0*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/* 1*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/* 2*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/* 3*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/* 4*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/* 5*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/* 6*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/* 7*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/* 8*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 9*/ 0x90,0x91,0x92,0x93,0x94,0xB0,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a*/ 0xB9,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0x8C,0xab,0x9C,0xad,0xae,0xaf,
/* b*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/* c*/ 0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* d*/ 0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/* e*/ 0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* f*/ 0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};

// cirillic - actual
static uchar ansi_cyr[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/* 0*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/* 1*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/* 2*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/* 3*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/* 4*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/* 5*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/* 6*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/* 7*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/* 8*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 9*/ 0x90,0x91,0x92,0x93,0x94,0xB0,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a*/ 0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
/* b*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/* c*/ 0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* d*/ 0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/* e*/ 0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* f*/ 0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff
            };

// WIN FRENCH : bullet = 0xB0
static uchar ansi_euro_win_french[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/* 0*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/* 1*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/* 2*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/* 3*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/* 4*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/* 5*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/* 6*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/* 7*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/* 8*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 9*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a*/ 0xB9,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0x8C,0xab,0x9C,0xad,0xae,0xaf,
/* b*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/* c*/ 0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* d*/ 0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/* e*/ 0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* f*/ 0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};

// cirillic - actual
static uchar ansi_cyr_win_french[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/* 0*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/* 1*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/* 2*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/* 3*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/* 4*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/* 5*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/* 6*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/* 7*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/* 8*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 9*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a*/ 0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0xac,0xad,0xae,0xaf,
/* b*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/* c*/ 0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* d*/ 0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/* e*/ 0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* f*/ 0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff
            };

// Windows cp1257   
//    1:1. 11.07.2001 E.P.
static uchar ansi_baltic[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/*00*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/*10*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/*20*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/*30*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/*40*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/*50*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/*60*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/*70*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/*80*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/*90*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/*a0*/ 0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0x9C,0xad,0xae,0xaf,
/*b0*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/*c0*/ 0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/*d0*/ 0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/*e0*/ 0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/*f0*/ 0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};

// Windows cp1254   
//    1:1. 20.05.2002 E.P.
static uchar ansi_turkish[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/*00*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/*10*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/*20*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/*30*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/*40*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/*50*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/*60*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/*70*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/*80*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/*90*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/*a0*/ 0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0x9C,0xad,0xae,0xaf,
/*b0*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/*c0*/ 0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/*d0*/ 0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/*e0*/ 0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/*f0*/ 0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};

static puchar ansi_table[PUMA_LANG_TOTAL]={
  ansi_euro,	// LANG_ENGLISH    0
  ansi_euro,    // LANG_GERMAN     1
  ansi_euro,    // LANG_FRENCH     2
  ansi_cyr,     // LANG_RUSSIAN    3
  ansi_euro,    // LANG_SWEDISH    4
  ansi_euro,    // LANG_SPANISH    5
  ansi_euro,    // LANG_ITALIAN    6
  ansi_cyr,     // LANG_RUS/ENG    7
  ansi_cyr,     // LANG_UKRAINIAN  8
  ansi_cyr,     // LANG_SERBIAN    9
  ansi_euro,    // LANG_CROATIAN   10
  ansi_euro,    // LANG_POLISH     11
  ansi_euro,    // LANG_DANISH     12
  ansi_euro,    // LANG_PORTUGUESE 13
  ansi_euro,    // LANG_DUTCH      14
  ansi_euro,	// LANG_DIG		   15
  ansi_cyr,     // LANG_UZBEK      16
  ansi_cyr,     // LANG_KAZ        17
  ansi_cyr,     // LANG_KAZ_ENG    18
  ansi_euro,	// LANG_CZECH	   19	// 05.09.2000 E.P.
  ansi_euro,	// LANG_ROMAN	   20
  ansi_euro,	// LANG_HUNGAR	   21
  ansi_cyr,		// LANG_BULGAR	   22
  ansi_euro,	// LANG_SLOVENIAN  23	// 25.05.2001 E.P.
  ansi_baltic,	// LANG_LATVIAN	   24
  ansi_baltic,	// LANG_LITHUANIAN 25
  ansi_baltic,	// LANG_ESTONIAN   26
  ansi_turkish	// LANG_TURKISH	   27
};

/**********************************/
/************** ASCII *************/
/**********************************/
// european actual
static uchar ascii_euro[257]={
/*0*/    "                "
/*1*/    "                "
/*2*/    "\x20!\"#$%&'()*+,-./"
/*3*/    "0123456789:;<=>?"
/*4*/    "@ABCDEFGHIJKLMNO"
/*5*/    "PQRSTUVWXYZ[\\]^-"
/*6*/    "`abcdefghijklmno"
/*7*/    "pqrstuvwxyz{|}~\x20"
/*8*/    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
/*9*/    "\x20\x20\x20\x20\x20\xFe\x20\x20\x20\x54\x20\x20\x20\x20\x20\x20"
/*A*/    "\xA8\xAD\x20\x20\x20\x20\x20\x20\x20\x43\x20\x3C\x20\xAF\x52\x22"
/*B*/    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x3E\x20\x20\x20\x20"
/*C*/    "\xb7\xb5\xb6 \xd4\xd2\xd3\xde\xd6\xd7\xd8"
/*D*/    "\x20\x20\xe3\xe0\xe2\x20\x20\x20\xeb\xe9\xea\x20\x20"
/*E*/    "\x20"
/*F*/    "\x20\x20\x20\x20\x20\x20\x20\x20"
      };

// cirillic actual
static uchar ascii_cyr[257]={
/*0*/    "@@@@@@@@@@@@@@@@"     //    ࠦ
/*1*/    "@@@@@@@@@@@@@@@@"     //
/*2*/    " !\"#$%&'()*+,-./"
/*3*/		 "0123456789:;<=>?"
/*4*/		 "@ABCDEFGHIJKLMNO"
/*5*/		 "PQRSTUVWXYZ[\\]^-"
/*6*/		 "`abcdefghijklmno"
/*7*/    "pqrstuvwxyz{|}~\x20"
/*8*/    "\xD3\x20\x20\x20\x20\x20\x20\x20\x20\x20\xCD\x20\xCB\x20\xD2\xCA"
/*9*/    "\xD4\x20\x20\x20\x20\xFE\x20\x20\x20\x54\xC4\x20\xC2\x20\xD1\xC1"
/*A*/    "\x20\x20\x20\x4A\x20\xF2\x20\x23\xF0\x43\xF4\x3C\x20\xAF\x52\xF8"
/*B*/    "\x20\x20\xF6\xF7\xF3\x20\x20\x20\xF1\x20\xF5\x3E\x6A\x20\x20\xF9"
/*C*/    "" // ...
/*D*/    "" // ...
/*E*/    "" // ...
/*F*/    "" // ...
      };

// central european actual
// cp1250 => cp852
static uchar ascii_ce[257]={
/*0*/    "@@@@@@@@@@@@@@@@"     //    ࠦ
/*1*/    "@@@@@@@@@@@@@@@@"     //
/*2*/    " !\"#$%&'()*+,-./"
/*3*/		 "0123456789:;<=>?"
/*4*/		 "@ABCDEFGHIJKLMNO"
/*5*/		 "PQRSTUVWXYZ[\\]^-"
/*6*/		 "`abcdefghijklmno"
/*7*/    "pqrstuvwxyz{|}~\x20"
/*           0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F */
/*8*/    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xE6\x20\x97\x20\xA6\x8D"
/*9*/    "\x20\x20\x20\x20\x20\xFE\x20\x20\x20\x54\xE7\x20\x98\x20\xA7\xAB"
/*A*/    "\x20\x20\x20\x9D\x20\xA4\x20\x23\x20\x43\xF4\x3C\x20\xAF\x52\xBD"
/*B*/    "\x20\x20\xF6\x88\xF3\x20\x20\x20\x20\xA5\xF5\x3E\x20\x20\x20\xBE"
/*C*/    "\x20\x20\x20\x20\x20\x20\x8F\x20\xAC\x20\xA8\x20\x20\x20\x20\x20"
/*D*/    "\xD1\xE3\x20\xE0\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
/*E*/    "\x20\x20\x20\x20\x20\x20\x86\x20\x9F\x20\xA9\x20\x20\x20\x20\x20"
/*F*/    "\xD0\xE4\x20\xA2\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
/*           0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F */
      };

// DOS  cp775   
static uchar ascii_baltic[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/*00*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/*10*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/*20*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/*30*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/*40*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/*50*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/*60*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/*70*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/*80*/  'e', ' ', ',', ' ', 247, ' ', ' ', ' ', ' ', ' ', ' ', '<', ' ', ' ', ' ', ' ',
/*90*/  ' ','\'', 239, 242, 166, 250, '-', 196, ' ', ' ', ' ', '>', ' ', ' ', ' ', ' ',
/*a0*/  ' ', ' ', 150, 156, 159, ' ', 167, 245, 157, 168, 138, 174, 170, 240, 169, 146,
/*b0*/  248, 241, 253, 252,'\'', 230, 244, 250, 155, 251, 139, 175, 172, 171, 243, 145,
/*c0*/  181, 189, 160, 128, 142, 143, 183, 237, 182, 144, 141, 184, 149, 232, 161, 234,
/*d0*/  190, 227, 238, 224, 226, 229, 153, 158, 198, 173, 151, 199, 154, 163, 207, 225,
/*e0*/  208, 212, 131, 135, 132, 134, 210, 137, 209, 130, 165, 211, 133, 233, 140, 235,
/*f0*/  213, 231, 236, 162, 147, 228, 148, 246, 214, 136, 152, 215, 129, 164, 216, 250};

// DOS  cp857   . 20.05.2002 E.P.
static uchar ascii_turkish[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/*00*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/*10*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/*20*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/*30*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/*40*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/*50*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/*60*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/*70*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/*80*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/*90*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/*a0*/ 0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0x9C,0xad,0xae,0xaf,
/*b0*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/*c0*/ 0xc0,0xc1, 182,0xc3,0xc4,0xc5,0xc6, 128,0xc8,0xc9,0xca,0xcb,0xcc,0xcd, 215,0xcf,
/*d0*/  166,0xd1,0xd2,0xd3,0xd4,0xd5, 153,0xd7,0xd8,0xd9,0xda, 234, 154, 152, 158,0xdf,
/*e0*/ 0xe0,0xe1, 131,0xe3,0xe4,0xe5,0xe6, 135,0xe8,0xe9,0xea,0xeb,0xec,0xed, 140,0xef,
/*f0*/  167,0xf1,0xf2,0xf3,0xf4,0xf5, 148,0xf7,0xf8,0xf9,0xfa, 150, 129, 141, 159,0xff};


static puchar ascii_table[PUMA_LANG_TOTAL]={
  ascii_euro,    // LANG_ENGLISH    0
  ascii_euro,    // LANG_GERMAN     1
  ascii_euro,    // LANG_FRENCH     2
  ascii_cyr,     // LANG_RUSSIAN    3
  ascii_euro,    // LANG_SWEDISH    4
  ascii_euro,    // LANG_SPANISH    5
  ascii_euro,    // LANG_ITALIAN    6
  ascii_cyr,     // LANG_RUS/ENG    7
  ascii_cyr,     // LANG_UKRAINIAN  8
  ascii_cyr,     // LANG_SERBIAN    9
  ascii_ce,      // LANG_CROATIAN   10
  ascii_ce,      // LANG_POLISH     11
  ascii_euro,    // LANG_DANISH     12
  ascii_euro,    // LANG_PORTUGUESE 13
  ascii_euro,    // LANG_DUTCH      14
  ascii_euro, 	 // LANG_DIG		15
  ascii_cyr,     // LANG_UZBEK      16
  ascii_cyr,     // LANG_KAZ        17
  ascii_cyr,     // LANG_KAZ_ENG    18
  ascii_ce,		 // LANG_CZECH	    19	// 05.09.2000 E.P.
  ascii_ce,		 // LANG_ROMAN	    20
  ascii_ce,		 // LANG_HUNGAR	    21
  ascii_cyr,	 // LANG_BULGAR	    22
  ascii_ce,		 // LANG_SLOVENIAN  23	// 25.05.2001 E.P.
  ascii_baltic,  // LANG_LATVIAN	24
  ascii_baltic,  // LANG_LITHUANIAN 25
  ascii_baltic,  // LANG_ESTONIAN   26
  ascii_turkish	 // LANG_TURKISH	27
};

// KOI8-R

static uchar koi8r_cyr[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/* 0*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/* 1*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/* 2*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/* 3*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/* 4*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/* 5*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/* 6*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/* 7*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/* 8*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 9*/ 0x90,0x91,0x92,0x93,0x94,0x94,0x96,0x97,0x98,0x54,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a*/ 0xa0,0xBC,0xBD,0xa3,0xa4,0xB2,0xa6,0xa7,0xB3,0xa9,0xB4,0x3C,0xac,0xad,0xae,0xB7,
/* b*/ 0xb0,0xb1,0xb2,0xb3,0xB1,0xb5,0xb6,0xb7,0xA3,0xBE,0xA4,0x3E,0xbc,0xbd,0xbe,0xA7,
/* c*/ 0xE1,0xE2,0xF7,0xE7,0xE4,0xE5,0xF6,0xFA,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,0xF0,
/* d*/ 0xF2,0xF3,0xF4,0xF5,0xE6,0xE8,0xE3,0xFE,0xFB,0xFD,0xFF,0xF9,0xF8,0xFC,0xE0,0xF1,
/* e*/ 0xC1,0xC2,0xD7,0xC7,0xC4,0xC5,0xD6,0xDA,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,0xD0,
/* f*/ 0xD2,0xD3,0xD4,0xD5,0xC6,0xC8,0xC3,0xDE,0xDB,0xDD,0xDF,0xD9,0xD8,0xDC,0xC0,0xD1
            };

static puchar koi8r_table[PUMA_LANG_TOTAL]={
  koi8r_cyr,     // LANG_ENGLISH    0
  ansi_euro,     // LANG_GERMAN     1
  ansi_euro,     // LANG_FRENCH     2
  koi8r_cyr,     // LANG_RUSSIAN    3
  ansi_euro,     // LANG_SWEDISH    4
  ansi_euro,     // LANG_SPANISH    5
  ansi_euro,     // LANG_ITALIAN    6
  koi8r_cyr,     // LANG_RUS/ENG    7
  koi8r_cyr,     // LANG_UKRAINIAN  8
  ansi_euro,     // LANG_SERBIAN    9
  ansi_euro,     // LANG_CROATIAN   10
  ansi_euro,     // LANG_POLISH     11
  ansi_euro,     // LANG_DANISH     12
  ansi_euro,     // LANG_PORTUGUESE 13
  ansi_euro,     // LANG_DUTCH      14
  koi8r_cyr,	 // LANG_DIG		15
  koi8r_cyr,     // LANG_UZBEK      16
  koi8r_cyr,     // LANG_KAZ        17
  koi8r_cyr,     // LANG_KAZ_ENG    18
  ansi_euro,	 // LANG_CZECH	    19
  ansi_euro,	 // LANG_ROMAN	    20
  ansi_euro,	 // LANG_HUNGAR	    21
  ascii_cyr,	 // LANG_BULGAR	    22
  ansi_euro,	 // LANG_SLOVENIAN  23
  ansi_baltic,   // LANG_LATVIAN	24
  ansi_baltic,   // LANG_LITHUANIAN 25
  ansi_baltic,   // LANG_ESTONIAN   26
  ansi_turkish   // LANG_TURKISH	27
};

/**************************************/
/************* MACINTOSH **************/
/**************************************/

static uchar mac_euro[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/* 0*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/* 1*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/* 2*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/* 3*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/* 4*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/* 5*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/* 6*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/* 7*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/* 8*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/* 9*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/* a*/ 0xB9,0xa1,0xa2,0xa3,0xa4,0xB0,0xa6,0xa7,0xa8,0xa9,0x8C,0xab,0x9C,0xad,0xae,0xaf,
/* b*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/* c*/ 0xc0,0xc1,0xc2,0xc3,0xc4,0xc5,0xc6,0xc7,0xc8,0xc9,0xca,0xcb,0xcc,0xcd,0xce,0xcf,
/* d*/ 0xd0,0xd1,0xd2,0xd3,0xd4,0xd5,0xd6,0xd7,0xd8,0xd9,0xda,0xdb,0xdc,0xdd,0xde,0xdf,
/* e*/ 0xe0,0xe1,0xe2,0xe3,0xe4,0xe5,0xe6,0xe7,0xe8,0xe9,0xea,0xeb,0xec,0xed,0xee,0xef,
/* f*/ 0xf0,0xf1,0xf2,0xf3,0xf4,0xf5,0xf6,0xf7,0xf8,0xf9,0xfa,0xfb,0xfc,0xfd,0xfe,0xff};

/*
Windows cp1257 => Mac OS Central European
		for Estonian, Latvian, Lithuanian
*/
static uchar mac_baltic[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/*00*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/*10*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/*20*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/*30*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/*40*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/*50*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/*60*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/*70*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/*80*/  ' ', ' ', ',', ' ', 227, 201, 160, ' ', ' ', ' ', ' ', 220, ' ', 172, 255, ' ',
/*90*/  ' ', 212, 213, 210, 211, 165, 208, 209, ' ', 170, ' ', 221, ' ', ' ', ' ', ' ',
/*a0*/  ' ', ' ', ' ', ' ', ' ', ' ', ' ', 164, ' ',0xa9, 223, 199, ' ', '-', 168, ' ',
/*b0*/  161, ' ', ' ', ' ', 213, ' ', 166, ' ', ' ', ' ', 224, 200, ' ', ' ', ' ', ' ',
/*c0*/  132, 175, 129, 140, 128, ' ', 162, 148, 137, 131, 143, 150, 254, 181, 177, 185,
/*d0*/  225, 193, 191, 238, 207, 205, 133, ' ', 246, 252, 229, 237, 134, 251, 235, 167,
/*e0*/  136, 176, 130, 141, 138, ' ', 171, 149, 139, 142, 144, 152, 174, 250, 180, 186,
/*f0*/  228, 196, 192, 151, 216, 155, 154, 214, 247, 184, 230, 240, 159,0xfd, 236, ' '};

// Mac Turkish (cp 10081)   . 20.05.2002 E.P.
static uchar mac_turkish[257]={
/*       0    1    2    3    4    5    6    7   8    9    a    b    c    d    e    f  */
/*00*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
/*10*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
/*20*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
/*30*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,
/*40*/ 0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,
/*50*/ 0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5a,0x5b,0x5c,0x5d,0x5e,0x5f,
/*60*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,
/*70*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7a,0x7b,0x7c,0x7d,0x7e,0x7f,
/*80*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8a,0x8b,0x8c,0x8d,0x8e,0x8f,
/*90*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9a,0x9b,0x9c,0x9d,0x9e,0x9f,
/*a0*/ 0xa0,0xa1,0xa2,0xa3,0xa4,0xa5,0xa6,0xa7,0xa8,0xa9,0xaa,0xab,0x9C,0xad,0xae,0xaf,
/*b0*/ 0xb0,0xb1,0xb2,0xb3,0xb4,0xb5,0xb6,0xb7,0xb8,0xb9,0xba,0xbb,0xbc,0xbd,0xbe,0xbf,
/*c0*/ 0xc0,0xc1, 229,0xc3,0xc4,0xc5,0xc6, 130,0xc8,0xc9,0xca,0xcb,0xcc,0xcd, 235,0xcf,
/*d0*/  218,0xd1,0xd2,0xd3,0xd4,0xd5, 133,0xd7,0xd8,0xd9,0xda, 243, 134, 220, 222,0xdf,
/*e0*/ 0xe0,0xe1, 137,0xe3,0xe4,0xe5,0xe6, 141,0xe8,0xe9,0xea,0xeb,0xec,0xed, 148,0xef,
/*f0*/  219,0xf1,0xf2,0xf3,0xf4,0xf5, 154,0xf7,0xf8,0xf9,0xfa, 158, 159, 221, 223,0xff};

static puchar mac_table[PUMA_LANG_TOTAL]={
  mac_euro,    // LANG_ENGLISH    0
  mac_euro,    // LANG_GERMAN     1
  mac_euro,    // LANG_FRENCH     2
  mac_euro,    // LANG_RUSSIAN    3
  mac_euro,    // LANG_SWEDISH    4
  mac_euro,    // LANG_SPANISH    5
  mac_euro,    // LANG_ITALIAN    6
  mac_euro,    // LANG_RUS/ENG    7
  mac_euro,    // LANG_UKRAINIAN  8
  mac_euro,    // LANG_SERBIAN    9
  mac_euro,    // LANG_CROATIAN   10
  mac_euro,    // LANG_POLISH     11
  mac_euro,    // LANG_DANISH     12
  mac_euro,    // LANG_PORTUGUESE 13
  mac_euro,    // LANG_DUTCH      14
  mac_euro,    // LANG_DIG		  15
  mac_euro,    // LANG_UZBEK      16
  mac_euro,    // LANG_KAZ        17
  mac_euro,	   // LANG_KAZ_ENG    18
  mac_euro,    // LANG_CZECH	  19	// 10.07.2001 E.P.
  mac_euro,    // LANG_ROMAN	  20
  mac_euro,    // LANG_HUNGAR	  21
  mac_euro,	   // LANG_BULGAR	  22
  mac_euro,    // LANG_SLOVENIAN  23	// 25.05.2001 E.P.
  mac_baltic,  // LANG_LATVIAN	  24
  mac_baltic,  // LANG_LITHUANIAN 25
  mac_baltic,  // LANG_ESTONIAN   26
  mac_turkish  // LANG_TURKISH	  27
};

static uchar **code_table[] = {
  ascii_table,
  ansi_table,
  koi8r_table,
  iso_table,
  mac_table
  };
//********************************************************************
Bool UpdateActiveCodeTable()
{
//      " - "

	//   code_table[]
	long indexCodeTable = 1;
	switch(gActiveCode)
		{
		case ROUT_CODE_ASCII: indexCodeTable  = 0; break;
		case ROUT_CODE_ANSI:  indexCodeTable  = 1; break;
		case ROUT_CODE_KOI8R: indexCodeTable  = 2; break;
		case ROUT_CODE_ISO:   indexCodeTable  = 3; break;
		case ROUT_CODE_UTF8:   indexCodeTable  = 1; break; // use ansi code table, convert to utf8 later
		}

	gActiveCodeTable = code_table[indexCodeTable ][gLanguage];
	if ( !gActiveCodeTable )
		{
		NOT_IMPLEMENTED;
		return FALSE;
		}
	//   ASCIII    
	if (gActiveCode == ROUT_CODE_ASCII)
		{
		//    
		//  . 17.10.98  E.P.
		static uchar saveTable_cyr[256] = {0};
		static uchar wasHere = 0;

		if (!wasHere)
			{
			memcpy(saveTable_cyr,  ascii_cyr,  256);
			wasHere=1;
			}
		else
			{
			memcpy(ascii_cyr,  saveTable_cyr,  256);
			}

		// Change ascii_cyr for Uzbek language. 06.05.98 E.P.
		if (langUzbek)
			{
			//     [TigerToUserCharSet] REC6UZB.DAT
			if ( gCountTigerToUserCharSet )
				ChangeUserFontToAscii();
			else  //    "PANDA Courier UZ"  DOS-
				{
				// Argument is in "PANDA Courier UZ" coding for Uzbek.
				// Value is in Uzbek DOS Lexicon coding.
				// PANDA --> ASCII
				ascii_cyr[140]=242;   // UZBEK_UU
				ascii_cyr[156]=243;   // UZBEK_u
				ascii_cyr[138]=244;   // UZBEK_KK
				ascii_cyr[154]=245;   // UZBEK_k
				ascii_cyr[128]=246;   // UZBEK_GG
				ascii_cyr[144]=247;   // UZBEK_g
				ascii_cyr[141]=248;   // UZBEK_XX
				ascii_cyr[157]=249;   // UZBEK_x
				}
			}

		//   . 05.09.2000 E.P.
		long codePage = GetCodePage();
		if (codePage == 852)
			fromcp1250_to_cp852();

		// Change ascii_cyr for Kazakh language. 17.08.98 E.P.
		if (langKaz)
			{
			//     [TigerToUserCharSet] REC6KAZ.DAT
			if ( gCountTigerToUserCharSet )
				ChangeUserFontToAscii();
			else
				{
				// Argument is in "Usual New Kazakh" font coding.
				// Value is in KeyKaz DOS driver coding.
				// "Usual New Kazakh"--> DOS
				ascii_cyr[162]=240;   // KAZ_AA
				ascii_cyr[173]=241;   // KAZ_GG
				ascii_cyr[188]=242;   // KAZ_KK
				ascii_cyr[168]=243;   // KAZ_NN
				ascii_cyr[164]=244;   // KAZ_OO
				ascii_cyr[184]=245;   // KAZ_YY1
				ascii_cyr[176]=246;   // KAZ_YY2
				ascii_cyr[190]=247;   // KAZ_HH
				ascii_cyr[161]=248;   // KAZ_a
				ascii_cyr[172]=249;   // KAZ_g
				ascii_cyr[186]=250;   // KAZ_k
				ascii_cyr[166]=251;   // KAZ_n
				ascii_cyr[163]=252;   // KAZ_o
				ascii_cyr[181]=253;   // KAZ_y1
				ascii_cyr[175]=254;   // KAZ_y2
				ascii_cyr[189]='h';   // KAZ_h
				}
			}
		}

	//   Windows  
	// ,   
	if (gWinFrench)
		{
		gActiveCodeTable[0x91/*KEY_D5*/] = 0xd5;
		gActiveCodeTable[0x92/*KEY_D7*/] = 0xd7;
		gActiveCodeTable[0x93/*KEY_D8*/] = 0xd8;
		}

	return TRUE;

}
//********************************************************************
static void ChangeUserFontToAscii()
{
long index;
long code1,code2,code3;

// For Uzbek and Kazakh. 17.10.98.   E.P.

for (index=0;index < gCountTigerToUserCharSet; index++ )
    {
    code1 = gTigerToUserCharSet[0][index];  // Tiger
    code2 = gTigerToUserCharSet[1][index];  // Windows
    code3 = gTigerToUserCharSet[2][index];  // DOS

    // Argument is in Windows font coding.
    // Value is in DOS coding.
    // Windows -> DOS
    ascii_cyr[ code2 ] = (Byte)code3;
    }
}
//*************************************************************************
long GetCodePage()
{
/*
	  :

	437		DOS USA
	850		DOS Multilingual
	1251	Windows ANSI
	1250	Windows EE
	852		DOS USA
	866		Russian DOS
	865		Nordic DOS
	1257	Baltic Windows
	775		Baltic DOS
	1254	Turkish Windows
	857		Turkish DOS

*/

static long cp_ascii[PUMA_LANG_TOTAL]={
	850,	// LANG_ENGLISH    0
	850,	// LANG_GERMAN     1
	850,  	// LANG_FRENCH     2
	866,  	// LANG_RUSSIAN    3
	865,  	// LANG_SWEDISH    4
	850,  	// LANG_SPANISH    5
	850,  	// LANG_ITALIAN    6
	866, 	// LANG_RUS/ENG    7
	866,  	// LANG_UKRAINIAN  8
	866,  	// LANG_SERBIAN    9
	852,  	// LANG_CROATIAN   10
	852,  	// LANG_POLISH     11
	865,  	// LANG_DANISH     12
	850,  	// LANG_PORTUGUESE 13
	850,  	// LANG_DUTCH      14
	850,  	// LANG_DIG		   15
	866,  	// LANG_UZBEK      16
	866,  	// LANG_KAZ        17
	866,  	// LANG_KAZ_ENG    18
	852,	// LANG_CZECH	   19	// 05.09.2000 E.
	852,	// LANG_ROMAN	   20
	852,	// LANG_HUNGAR	   21
	866,    // LANG_BULGAR	   22
	852,	// LANG_SLOVENIAN  23	// 25.05.2001 E.
	775,	// LANG_LATVIAN	   24
	775,	// LANG_LITHUANIAN 25
	775,	// LANG_ESTONIAN   26
	875		// LANG_TURKISH	   27
};

static long cp_ansi[PUMA_LANG_TOTAL]={
	1252,	// LANG_ENGLISH    0
	1252,	// LANG_GERMAN     1
	1252,  	// LANG_FRENCH     2
	1251,  	// LANG_RUSSIAN    3
	1252,  	// LANG_SWEDISH    4
	1252,  	// LANG_SPANISH    5
	1252,  	// LANG_ITALIAN    6
	1251, 	// LANG_RUS/ENG    7
	1251,  	// LANG_UKRAINIAN  8
	1251,  	// LANG_SERBIAN    9
	1250,  	// LANG_CROATIAN   10
	1250,  	// LANG_POLISH     11
	1252,  	// LANG_DANISH     12
	1252,  	// LANG_PORTUGUESE 13
	1252,  	// LANG_DUTCH      14
	1251,  	// LANG_DIG		   15
	1251,  	// LANG_UZBEK      16
	1251,  	// LANG_KAZ        17
	1251,  	// LANG_KAZ_ENG    18
	1250,	// LANG_CZECH	   19	// 05.09.2000 E.P.
	1250,	// LANG_ROMAN	   20
	1250,	// LANG_HUNGAR	   21
	1251,	// LANG_BULGAR	   22
	1250,	// LANG_SLOVENIAN  23	// 25.05.2001 E.P.
	1257,	// LANG_LATVIAN	   24
	1257,	// LANG_LITHUANIAN 25
	1257,	// LANG_ESTONIAN   26
	1254	// LANG_TURKISH	   27
};

	if(gActiveCode == ROUT_CODE_ASCII)
		return cp_ascii[gLanguage];
	else
		return cp_ansi[gLanguage];
}
//*************************************************************************
void fromcp1250_to_cp852()	// 05.09.2000 E.P.
{
	 //   cp1250  cp852

typedef struct {uchar from; uchar to;} CP_TO_CP; // 05.09.2000 E.P.
CP_TO_CP tab[] = {

{CROAT_D ,					209},	{CROAT_d ,					208},
{POLISH_LL,					157},	{POLISH_l,					136},

{AA_right_accent,			180},	{a_right_accent,			160},
{AA_2dot_accent,			142},	{a_2dot_accent,				132},
{AA_bottom_accent_latin,	164},	{a_bottom_accent_latin,		165},
{AA_semicircle,				198},	{a_semicircle,				199},
{AA_roof_accent,			182},	{a_roof_accent,				131},
{CC_right_accent,			143},	{c_right_accent,			134},
{CC_inv_roof,				172},	{c_inv_roof,				159},
{DD_inv_roof,				210},	{d_inv_roof,				212},
{EE_right_accent,			144},	{e_right_accent,			130},
{EE_bottom_accent_latin,	168},	{e_bottom_accent_latin,		169},
{EE_inv_roof,				183},	{e_inv_roof,				216},
{II_right_accent,			214},	{i_right_accent,			161},
{II_roof_accent,			215},	{i_roof_accent,				140},
{NN_right_accent,			227},	{n_right_accent,			228},
{NN_inv_roof,				213},	{n_inv_roof,				229},
{OO_right_accent,			224},	{o_right_accent,			162},
{OO_roof_accent,			226},	{o_roof_accent,				147},
{OO_2dot_accent,			153},	{o_2dot_accent,				148},
{OO_double_right,			138},	{o_double_right,			139},
{RR_inv_roof,				252},	{r_inv_roof,				253},

{SS_right_accent,			151},	{s_right_accent,			152},
{SS_inv_roof_latin,			230},	{s_inv_roof_latin,			231},
{SS_bottom_accent_latin,	184},	{s_bottom_accent_latin,		173},
{TT_inv_roof,				155},	{t_inv_roof,				156},
{TT_bottom_accent,			221},	{t_bottom_accent,			238},
{UU_right_accent,			233},	{u_right_accent,			163},
{UU_2dot_accent,			154},	{u_2dot_accent,				129},
{UU_double_right,			235},	{u_double_right,			251},
{UU_circle_accent,			222},	{u_circle_accent,			133},
{YY_right_accent,			237},	{y_right_accent,			236},
{ZZ_right_accent,			141},	{z_right_accent,			171},
{ZZ_dot_accent,				189},	{z_dot_accent,				190},
{ZZ_inv_roof_latin,			166},	{z_inv_roof_latin,			167},

0};

	for (CP_TO_CP *p = tab; p->from; p++)
		ascii_ce[p->from] = p->to;

}
//*************************************************************************

#include "utf8-tables.h"

/* 
 * Return a NULL terminated string of UTF-8 characters
 * corresponding to the given character and Windows
 * codepage.
 */

const char * getUTF8Str(const unsigned char in, const int codepage) {
  switch(codepage) {
  case 1250 : return win1250_to_utf8[in];
  case 1251 : return win1251_to_utf8[in];
  case 1252 : return win1252_to_utf8[in];
  case 1254 : return win1254_to_utf8[in];
  case 1257 : return win1257_to_utf8[in];
  default : return "?";
  }
}
