/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;
import SharpTools.CellRange;
import SharpTools.SharpTableModel;
import SharpTools.SharpTools;

public class SharpClipboard {
    private String text;
    private CellRange source;

    public SharpClipboard(SharpTableModel model, CellRange range, boolean isCut) {
        this.text = model.toString(range, false);
        this.source = range;
        if (isCut) {
            model.clearRange(range);
        }
    }

    public CellRange getRange(SharpTableModel model, CellPoint corner) {
        int rowLimit = model.getRowCount() - 1;
        int colLimit = model.getColumnCount() - 1;
        int rowMax = corner.getRow() + this.source.getHeight() - 1;
        int colMax = corner.getCol() + this.source.getWidth() - 1;
        if (corner.getRow() < SharpTools.baseRow || corner.getCol() < SharpTools.baseCol) {
            return null;
        }
        return new CellRange(corner, new CellPoint(Math.min(rowMax, rowLimit), Math.min(colMax, colLimit)));
    }

    public void paste(SharpTableModel table, CellPoint corner) {
        CellRange range = this.getRange(table, corner);
        this.paste(table, range);
    }

    public void paste(SharpTableModel table, CellRange range) {
        if (range != null) {
            int rowOff = range.getStartRow() - this.source.getStartRow();
            int colOff = range.getStartCol() - this.source.getStartCol();
            table.fromString(this.text, rowOff, colOff, range);
        }
    }

    public CellRange getSource() {
        return this.source;
    }

    public void setSource(CellRange x) {
        this.source = x;
    }

    public String toString() {
        return this.text;
    }
}

