/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.ctrlview.bidim;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.io.Serializable;

public class Line
implements Serializable {
    private Point p1;
    private Point p2;
    private int thickness;
    private byte alignment;
    private Polygon line;
    public static final byte LEFT = 0;
    public static final byte CENTER = 1;
    public static final byte RIGHT = 2;

    public Line() {
        this(new Point(), new Point(), 1, 1);
    }

    public Line(Point point, Point point2, int n, byte by) {
        this.p1 = point;
        this.p2 = point2;
        this.thickness = n;
        this.alignment = by;
        this.computeLine();
    }

    public void setP1(Point point) {
        this.p1 = point;
        this.computeLine();
    }

    public Point getP1() {
        return this.p1;
    }

    public void setP2(Point point) {
        this.p2 = point;
        this.computeLine();
    }

    public Point getP2() {
        return this.p2;
    }

    public void setAlignment(byte by) {
        this.alignment = by;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setThickness(int n) {
        this.thickness = n;
        this.computeLine();
    }

    public int getThickness() {
        return this.thickness;
    }

    public void draw(Graphics graphics) {
        graphics.fillPolygon(this.line);
    }

    public Polygon getLine() {
        return this.line;
    }

    private void computeLine() {
        this.line = new Polygon();
        Point point = new Point(this.p2.x - this.p1.x, this.p2.y - this.p1.y);
        float f = -point.y;
        float f2 = point.x;
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        f = f / f3 * (float)this.thickness;
        f2 = f2 / f3 * (float)this.thickness;
        switch (this.alignment) {
            case 2: {
                this.line.addPoint(this.p1.x, this.p1.y);
                this.line.addPoint(this.p2.x, this.p2.y);
                this.line.addPoint(Math.round((float)this.p2.x - f), Math.round((float)this.p2.y - f2));
                this.line.addPoint(Math.round((float)this.p1.x - f), Math.round((float)this.p1.y - f2));
                break;
            }
            case 1: {
                float f4 = f / 2.0f;
                float f5 = f2 / 2.0f;
                this.line.addPoint(Math.round((float)this.p1.x - f4), Math.round((float)this.p1.y - f5));
                this.line.addPoint(Math.round((float)this.p2.x - f4), Math.round((float)this.p2.y - f5));
                this.line.addPoint(Math.round((float)this.p2.x + f4), Math.round((float)this.p2.y + f5));
                this.line.addPoint(Math.round((float)this.p1.x + f4), Math.round((float)this.p1.y + f5));
                break;
            }
            case 0: {
                this.line.addPoint(this.p1.x, this.p1.y);
                this.line.addPoint(this.p2.x, this.p2.y);
                this.line.addPoint(Math.round((float)this.p2.x + f), Math.round((float)this.p2.y + f2));
                this.line.addPoint(Math.round((float)this.p1.x + f), Math.round((float)this.p1.y + f2));
            }
        }
    }
}

