/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.Interface;
import org.jmol.api.JmolBioResolver;
import org.jmol.api.SymmetryInterface;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIndexIterator;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.AtomIteratorWithinSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondCollection;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Molecule;
import org.jmol.modelset.Polymer;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Eigen;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.util.TriangleData;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public abstract class ModelCollection
extends BondCollection {
    protected BitSet bsSymmetry;
    protected String modelSetName;
    protected Model[] models = new Model[1];
    protected int modelCount;
    SymmetryInterface[] unitCells;
    protected int[] modelNumbers = new int[1];
    protected int[] modelFileNumbers = new int[1];
    protected String[] modelNumbersForAtomLabel = new String[1];
    protected String[] modelNames = new String[1];
    protected String[] frameTitles = new String[1];
    protected BitSet[] elementsPresent;
    protected boolean isXYZ;
    protected boolean isPDB;
    private Properties modelSetProperties;
    private Hashtable modelSetAuxiliaryInfo;
    protected Group[] groups;
    protected int groupCount;
    protected int baseGroupIndex = 0;
    private int structureCount = 0;
    private Structure[] structures = new Structure[10];
    protected boolean haveBioClasses = true;
    protected JmolBioResolver jbr = null;
    protected boolean someModelsHaveSymmetry;
    protected boolean someModelsHaveAromaticBonds;
    protected boolean someModelsHaveFractionalCoordinates;
    protected Molecule[] molecules = new Molecule[4];
    protected int moleculeCount;
    private final Matrix3f matTemp = new Matrix3f();
    private final Matrix3f matInv = new Matrix3f();
    private final Point3f ptTemp = new Point3f();
    private final Point3f averageAtomPoint = new Point3f();
    private boolean isBbcageDefault;
    private BitSet bboxModels;
    private BitSet bboxAtoms;
    private final BoxInfo boxInfo = new BoxInfo();
    protected Vector stateScripts;
    private int thisStateModel;
    protected Vector trajectorySteps;
    private static final String[] pdbRecords = new String[]{"ATOM  ", "MODEL ", "HETATM"};
    private BitSet bsTemp;
    private BitSet selectedMolecules;
    private int selectedMoleculeCount;
    private AtomIteratorWithinModel withinModelIterator;
    private AtomIteratorWithinSet withinAtomSetIterator;
    protected BitSet bsAll;
    private static float defaultHbondMax = 3.25f;
    private static float hbondMin = 2.5f;
    boolean proteinStructureTainted;
    private SymmetryInterface symTemp;

    public ModelCollection() {
        this.boxInfo.setBbcage(1.0f);
        this.stateScripts = new Vector();
        this.thisStateModel = 0;
        this.bsTemp = new BitSet();
        this.selectedMolecules = new BitSet();
        this.proteinStructureTainted = false;
    }

    protected void merge(ModelSet modelSet) {
        for (int i = 0; i < modelSet.modelCount; ++i) {
            Model model = this.models[i] = modelSet.models[i];
            model.modelSet = (ModelSet)this;
            for (int j = 0; j < model.chainCount; ++j) {
                model.chains[j].setModelSet(model.modelSet);
            }
            this.stateScripts = modelSet.stateScripts;
            this.proteinStructureTainted = modelSet.proteinStructureTainted;
            this.thisStateModel = -1;
        }
        super.merge(modelSet);
    }

    protected void releaseModelSet() {
        this.models = null;
        this.bsSymmetry = null;
        this.bsAll = null;
        this.unitCells = null;
        this.withinModelIterator = null;
        this.withinAtomSetIterator = null;
        super.releaseModelSet();
    }

    public String getModelSetName() {
        return this.modelSetName;
    }

    public Model[] getModels() {
        return this.models;
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public SymmetryInterface[] getCellInfos() {
        return this.unitCells;
    }

    public SymmetryInterface getUnitCell(int n) {
        return this.unitCells != null && n >= 0 && n < this.unitCells.length ? this.unitCells[n] : null;
    }

    public Vector getPlaneIntersection(int n, Point4f point4f, float f, int n2, int n3) {
        Object object;
        Point3f[] point3fArray = null;
        switch (n) {
            case 1614417984: {
                object = this.getUnitCell(n3);
                if (object == null) {
                    return null;
                }
                point3fArray = object.getCanonicalCopy(f);
                break;
            }
            case 1679429641: {
                point3fArray = this.boxInfo.getCanonicalCopy(f);
            }
        }
        object = new Vector();
        ((Vector)object).add(point3fArray);
        return TriangleData.intersectPlane(point4f, (Vector)object, n2);
    }

    public String getModelName(int n) {
        return this.modelCount < 1 ? "" : (n >= 0 ? this.modelNames[n] : this.modelNumbersForAtomLabel[-1 - n]);
    }

    public String getModelTitle(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "title");
    }

    public String getModelFileName(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "fileName");
    }

    public void setFrameTitle(BitSet bitSet, String string) {
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            this.frameTitles[n] = string;
            n = bitSet.nextSetBit(n + 1);
        }
    }

    public String getFrameTitle(int n) {
        return n >= 0 && n < this.modelCount ? this.frameTitles[n] : "";
    }

    public String getModelNumberForAtomLabel(int n) {
        return this.modelNumbersForAtomLabel[n];
    }

    protected void calculatePolymers(BitSet bitSet) {
        if (this.jbr == null) {
            return;
        }
        if (bitSet != null) {
            this.jbr.clearBioPolymers(this.groups, this.groupCount, bitSet);
        }
        boolean bl = !this.viewer.getPdbLoadInfo(1);
        for (int i = this.baseGroupIndex; i < this.groupCount; ++i) {
            Polymer polymer = this.jbr.buildBioPolymer(this.groups[i], this.groups, i, bl);
            if (polymer == null) continue;
            this.addBioPolymerToModel(polymer, this.groups[i].getModel());
        }
    }

    protected void addBioPolymerToModel(Polymer polymer, Model model) {
        if (model.bioPolymers.length == 0 || polymer == null) {
            model.bioPolymers = new Polymer[8];
        }
        if (polymer == null) {
            model.bioPolymerCount = 0;
            return;
        }
        if (model.bioPolymerCount == model.bioPolymers.length) {
            model.bioPolymers = (Polymer[])ArrayUtil.doubleLength(model.bioPolymers);
        }
        polymer.bioPolymerIndexInModel = model.bioPolymerCount;
        model.bioPolymers[model.bioPolymerCount++] = polymer;
    }

    public float[] getNotionalUnitcell() {
        return this.unitCells == null || this.unitCells[0] == null ? null : this.unitCells[0].getNotionalUnitCell();
    }

    public boolean setCrystallographicDefaults() {
        return !this.isPDB && this.someModelsHaveSymmetry && this.someModelsHaveFractionalCoordinates;
    }

    public Point3f getAverageAtomPoint() {
        return this.averageAtomPoint;
    }

    public Point3f getBoundBoxCenter(int n) {
        if (this.isJmolDataFrame(n)) {
            return new Point3f();
        }
        return this.boxInfo.getBoundBoxCenter();
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.boxInfo.getBoundBoxCornerVector();
    }

    public Point3fi[] getBboxVertices() {
        return this.boxInfo.getBboxVertices();
    }

    public Hashtable getBoundBoxInfo() {
        return this.boxInfo.getBoundBoxInfo();
    }

    public BitSet getBoundBoxModels() {
        return this.bboxModels;
    }

    public void setBoundBox(Point3f point3f, Point3f point3f2, boolean bl, float f) {
        if (point3f != null && point3f.distance(point3f2) == 0.0f) {
            return;
        }
        this.isBbcageDefault = false;
        this.bboxModels = null;
        this.bboxAtoms = null;
        this.boxInfo.setBoundBox(point3f, point3f2, bl, f);
    }

    public String getBoundBoxCommand(boolean bl) {
        if (!bl && this.bboxAtoms != null) {
            return "boundbox " + Escape.escape(this.bboxAtoms);
        }
        this.ptTemp.set(this.boxInfo.getBoundBoxCenter());
        Vector3f vector3f = this.boxInfo.getBoundBoxCornerVector();
        String string = bl ? "boundbox " + Escape.escape(this.ptTemp) + " " + Escape.escape(vector3f) + "\n#or\n" : "";
        this.ptTemp.sub(vector3f);
        string = string + "boundbox corners " + Escape.escape(this.ptTemp) + " ";
        this.ptTemp.scaleAdd(2.0f, vector3f, this.ptTemp);
        float f = Math.abs(8.0f * vector3f.x * vector3f.y * vector3f.z);
        string = string + Escape.escape(this.ptTemp) + " # volume = " + f;
        return string;
    }

    public int getDefaultVdwType(int n) {
        return !this.models[n].isPDB ? 5 : (this.models[n].hydrogenCount == 0 ? 4 : 5);
    }

    public boolean setRotationRadius(int n, float f) {
        if (this.isJmolDataFrame(n)) {
            this.models[n].defaultRotationRadius = f;
            return false;
        }
        return true;
    }

    public float calcRotationRadius(int n, Point3f point3f) {
        if (this.isJmolDataFrame(n)) {
            float f = this.models[n].defaultRotationRadius;
            return f == 0.0f ? 10.0f : f;
        }
        float f = 0.0f;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (this.isJmolDataFrame(this.atoms[n2])) {
                n = this.atoms[n2].modelIndex;
                while (n2 >= 0 && this.atoms[n2].modelIndex == n) {
                    --n2;
                }
                continue;
            }
            Atom atom = this.atoms[n2];
            float f2 = point3f.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (!(f3 > f)) continue;
            f = f3;
        }
        return f == 0.0f ? 10.0f : f;
    }

    public void calcBoundBoxDimensions(BitSet bitSet, float f) {
        if (bitSet != null && bitSet.nextSetBit(0) < 0) {
            bitSet = null;
        }
        if (bitSet == null && this.isBbcageDefault || this.atomCount < 2) {
            return;
        }
        this.bboxAtoms = BitSetUtil.copy(bitSet);
        this.bboxModels = this.getModelBitSet(this.bboxAtoms, false);
        if (this.calcAtomsMinMax(bitSet, this.boxInfo) == this.atomCount) {
            this.isBbcageDefault = true;
        }
        if (bitSet == null) {
            this.averageAtomPoint.set(this.getAtomSetCenter(null));
            if (this.unitCells != null) {
                this.calcUnitCellMinMax();
            }
        }
        this.boxInfo.setBbcage(f);
    }

    public BoxInfo getBoxInfo(BitSet bitSet, float f) {
        if (bitSet == null) {
            return this.boxInfo;
        }
        BoxInfo boxInfo = new BoxInfo();
        this.calcAtomsMinMax(bitSet, boxInfo);
        boxInfo.setBbcage(f);
        return boxInfo;
    }

    public int calcAtomsMinMax(BitSet bitSet, BoxInfo boxInfo) {
        int n;
        boxInfo.reset();
        int n2 = 0;
        boolean bl = bitSet == null;
        int n3 = n = bl ? this.atomCount - 1 : bitSet.nextSetBit(0);
        while (n3 >= 0) {
            ++n2;
            if (!this.isJmolDataFrame(this.atoms[n3])) {
                boxInfo.addBoundBoxPoint(this.atoms[n3]);
            }
            n3 = bl ? n3 - 1 : bitSet.nextSetBit(n3 + 1);
        }
        return n2;
    }

    private void calcUnitCellMinMax() {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.unitCells[i].getCoordinatesAreFractional()) continue;
            Point3f[] point3fArray = this.unitCells[i].getUnitCellVertices();
            for (int j = 0; j < 8; ++j) {
                this.boxInfo.addBoundBoxPoint(point3fArray[j]);
            }
        }
    }

    public float calcRotationRadius(BitSet bitSet) {
        Point3f point3f = this.getAtomSetCenter(bitSet);
        float f = 0.0f;
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.atoms[n];
            float f2 = point3f.distance(atom);
            float f3 = f2 + this.getRadiusVdwJmol(atom);
            if (f3 > f) {
                f = f3;
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return f == 0.0f ? 10.0f : f;
    }

    public Point3f[][] getCenterAndPoints(Vector vector, boolean bl) {
        BitSet bitSet;
        BitSet bitSet2;
        int n = bl ? 1 : 0;
        int n2 = vector.size();
        while (--n2 >= 0) {
            BitSet[] bitSetArray = (BitSet[])vector.get(n2);
            bitSet2 = bitSetArray[0];
            bitSet = bitSetArray[1];
            n += Math.min(bitSet2.cardinality(), bitSet.cardinality());
        }
        Point3f[][] point3fArray = new Point3f[2][n];
        if (bl) {
            point3fArray[0][0] = new Point3f();
            point3fArray[1][0] = new Point3f();
        }
        int n3 = vector.size();
        while (--n3 >= 0) {
            BitSet[] bitSetArray = (BitSet[])vector.get(n3);
            bitSet2 = bitSetArray[0];
            bitSet = bitSetArray[1];
            int n4 = bitSet2.nextSetBit(0);
            int n5 = bitSet.nextSetBit(0);
            while (n4 >= 0 && n5 >= 0) {
                point3fArray[0][--n] = this.atoms[n4];
                point3fArray[1][n] = this.atoms[n5];
                if (bl) {
                    point3fArray[0][0].add(this.atoms[n4]);
                    point3fArray[1][0].add(this.atoms[n5]);
                }
                n4 = bitSet2.nextSetBit(n4 + 1);
                n5 = bitSet.nextSetBit(n5 + 1);
            }
        }
        if (bl) {
            point3fArray[0][0].scale(1.0f / (float)(point3fArray[0].length - 1));
            point3fArray[1][0].scale(1.0f / (float)(point3fArray[0].length - 1));
        }
        return point3fArray;
    }

    public Quaternion calculateQuaternionRotation(Point3f[][] point3fArray, float[] fArray) {
        Object object;
        Object object2;
        Quaternion quaternion = new Quaternion();
        if (point3fArray.length == 1) {
            return quaternion;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n = point3fArray[0].length - 1;
        int n2 = n + 1;
        while (--n2 >= 1) {
            object2 = point3fArray[0][n2];
            object = point3fArray[1][n2];
            if (object2 instanceof Atom) {
                Logger.info(" atom 1 " + ((Atom)object2).getInfo() + "\tatom 2 " + ((Atom)object).getInfo());
            }
            Point3f point3f = new Point3f((Point3f)object2);
            point3f.sub(point3fArray[0][0]);
            Point3f point3f2 = new Point3f((Point3f)object);
            point3f2.sub(point3fArray[0][1]);
            d += (double)point3f.x * (double)point3f2.x;
            d2 += (double)point3f.x * (double)point3f2.y;
            d3 += (double)point3f.x * (double)point3f2.z;
            d4 += (double)point3f.y * (double)point3f2.x;
            d5 += (double)point3f.y * (double)point3f2.y;
            d6 += (double)point3f.y * (double)point3f2.z;
            d7 += (double)point3f.z * (double)point3f2.x;
            d8 += (double)point3f.z * (double)point3f2.y;
            d9 += (double)point3f.z * (double)point3f2.z;
        }
        if (n < 2) {
            return quaternion;
        }
        this.getRmsd(point3fArray, quaternion, fArray, 1);
        double[][] dArray = new double[4][4];
        dArray[0][0] = d + d5 + d9;
        double d10 = d6 - d8;
        dArray[1][0] = d10;
        dArray[0][1] = d10;
        double d11 = d7 - d3;
        dArray[2][0] = d11;
        dArray[0][2] = d11;
        double d12 = d2 - d4;
        dArray[3][0] = d12;
        dArray[0][3] = d12;
        dArray[1][1] = d - d5 - d9;
        double d13 = d2 + d4;
        dArray[2][1] = d13;
        dArray[1][2] = d13;
        double d14 = d7 + d3;
        dArray[3][1] = d14;
        dArray[1][3] = d14;
        dArray[2][2] = -d + d5 - d9;
        double d15 = d6 + d8;
        dArray[3][2] = d15;
        dArray[2][3] = d15;
        dArray[3][3] = -d - d5 + d9;
        object2 = new Eigen(dArray);
        object = ((Eigen)object2).getEigenvectorsFloatTransposed()[3];
        quaternion = new Quaternion(new Point4f((float)object[1], (float)object[2], (float)object[3], (float)object[0]));
        this.getRmsd(point3fArray, quaternion, fArray, 0);
        return quaternion;
    }

    private void getRmsd(Point3f[][] point3fArray, Quaternion quaternion, float[] fArray, int n) {
        float f;
        double d = 0.0;
        double d2 = 0.0;
        int n2 = point3fArray[0].length - 1;
        Point3f point3f = new Point3f();
        int n3 = n2 + 1;
        while (--n3 >= 1) {
            point3f.set(point3fArray[0][n3]);
            point3f.sub(point3fArray[0][0]);
            quaternion.transform(point3f, point3f);
            point3f.add(point3fArray[1][0]);
            double d3 = point3f.distance(point3fArray[1][n3]);
            d += d3;
            d2 += d3 * d3;
        }
        fArray[n] = f = (float)((int)(100.0 * Math.sqrt((d2 - d * d / (double)n2) / (double)(n2 - 1)))) / 100.0f;
    }

    public Point3f getAtomSetCenter(BitSet bitSet) {
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        int n = 0;
        if (bitSet != null) {
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                if (!this.isJmolDataFrame(this.atoms[n2])) {
                    ++n;
                    point3f.add(this.atoms[n2]);
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        }
        if (n > 0) {
            point3f.scale(1.0f / (float)n);
        }
        return point3f;
    }

    public void setAtomProperty(BitSet bitSet, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        super.setAtomProperty(bitSet, n, n2, f, string, fArray, stringArray);
        if ((n == 1095763988 || n == 1632634889) && this.viewer.getSmartAromatic()) {
            this.assignAromaticBonds();
        }
    }

    public StateScript addStateScript(String string, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string2, boolean bl, boolean bl2) {
        if (bl) {
            int n = this.viewer.getCurrentModelIndex();
            if (this.thisStateModel != n) {
                string = "frame " + (n < 0 ? "" + n : this.getModelNumberDotted(n)) + ";\n  " + string;
            }
            this.thisStateModel = n;
        } else {
            this.thisStateModel = -1;
        }
        StateScript stateScript = new StateScript(this.thisStateModel, string, bitSet, bitSet2, bitSet3, string2, bl2);
        if (stateScript.isValid()) {
            this.stateScripts.addElement(stateScript);
        }
        return stateScript;
    }

    protected void defineStructure(int n, String string, String string2, int n2, int n3, char c, int n4, char c2, char c3, int n5, char c4) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength(this.structures, this.structureCount + 10);
        }
        this.structures[this.structureCount++] = new Structure(n, string, string2, n2, n3, c, Group.getSeqcode(n4, c2), c3, Group.getSeqcode(n5, c4));
    }

    protected void calculateStructuresAllExcept(BitSet bitSet, boolean bl) {
        this.freezeModels();
        int n = this.modelCount;
        while (--n >= 0) {
            if (!this.models[n].isPDB || bitSet.get(n)) continue;
            this.models[n].calculateStructures();
        }
        this.setStructureIds();
        if (bl) {
            this.propagateSecondaryStructure();
        }
    }

    public void setProteinType(BitSet bitSet, byte by) {
        short s;
        int n;
        int n2 = -1;
        int n3 = -1;
        BitSet bitSet2 = new BitSet();
        int n4 = bitSet.nextSetBit(0);
        while (n4 >= 0) {
            if (n3 != n4 - 1) {
                n2 = -1;
            }
            n2 = this.atoms[n4].group.setProteinStructureType(by, n2);
            n = this.atoms[n4].modelIndex;
            bitSet2.set(n);
            this.models[n].structureTainted = true;
            this.proteinStructureTainted = true;
            n3 = n4 = this.atoms[n4].group.lastAtomIndex;
            n4 = bitSet.nextSetBit(n4 + 1);
        }
        int[] nArray = new int[this.modelCount];
        n = 0;
        while (n < this.atomCount) {
            s = this.atoms[n].modelIndex;
            if (!bitSet2.get(s)) {
                n = this.models[s].firstAtomIndex + this.models[s].atomCount;
                continue;
            }
            n3 = this.atoms[n].getStrucNo();
            if (n3 < 1000 && n3 > nArray[s]) {
                nArray[s] = n3;
            }
            n = this.atoms[n].group.lastAtomIndex + 1;
        }
        n = 0;
        while (n < this.atomCount) {
            s = this.atoms[n].modelIndex;
            if (!bitSet2.get(s)) {
                n = this.models[s].firstAtomIndex + this.models[s].atomCount;
                continue;
            }
            if (this.atoms[n].getStrucNo() > 1000) {
                short s2 = s;
                int n5 = nArray[s2] + 1;
                nArray[s2] = n5;
                this.atoms[n].group.setProteinStructureId(n5);
            }
            n = this.atoms[n].group.lastAtomIndex + 1;
        }
    }

    private void freezeModels() {
        int n = this.modelCount;
        while (--n >= 0) {
            int n2;
            Model model = this.models[n];
            model.chains = (Chain[])ArrayUtil.setLength(model.chains, model.chainCount);
            model.groupCount = -1;
            model.getGroupCount();
            for (n2 = 0; n2 < model.chainCount; ++n2) {
                model.chains[n2].groups = (Group[])ArrayUtil.setLength(model.chains[n2].groups, model.chains[n2].groupCount);
            }
            model.bioPolymers = (Polymer[])ArrayUtil.setLength(model.bioPolymers, model.bioPolymerCount);
            n2 = model.bioPolymerCount;
            while (--n2 >= 0) {
                model.bioPolymers[n2].freeze();
            }
        }
    }

    public BitSet setConformation(BitSet bitSet) {
        BitSet bitSet2 = this.getModelBitSet(bitSet, false);
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            this.models[n].setConformation(bitSet);
            n = bitSet2.nextSetBit(n + 1);
        }
        return bitSet;
    }

    public BitSet getConformation(int n, int n2, boolean bl) {
        BitSet bitSet = new BitSet();
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            int n4;
            if (n3 != n && n >= 0 || (n4 = this.getAltLocCountInModel(n3)) == 0 || n2 >= n4) continue;
            String string = this.getAltLocListInModel(n3);
            BitSet bitSet2 = this.getModelAtomBitSet(n3, true);
            if (n2 >= 0) {
                int n5 = n4;
                while (--n5 >= 0) {
                    if (n5 == n2) continue;
                    bitSet2.andNot(this.getAtomBits(0x10001F, string.substring(n5, n5 + 1)));
                }
            }
            if (bitSet2.nextSetBit(0) < 0) continue;
            bitSet.or(bitSet2);
            if (!bl) continue;
            this.models[n3].setConformation(bitSet2);
        }
        return bitSet;
    }

    public Hashtable getHeteroList(int n) {
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            Hashtable hashtable2;
            if (n >= 0 && n2 != n || (hashtable2 = (Hashtable)this.getModelAuxiliaryInfo(n2, "hetNames")) == null) continue;
            bl = true;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtable.put(string, hashtable2.get(string));
            }
        }
        return bl ? hashtable : (Hashtable)this.getModelSetAuxiliaryInfo("hetNames");
    }

    protected void setModelSetProperties(Properties properties) {
        this.modelSetProperties = properties;
    }

    protected void setModelSetAuxiliaryInfo(Hashtable hashtable) {
        this.modelSetAuxiliaryInfo = hashtable;
    }

    public Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSetAuxiliaryInfo;
    }

    public String getModelSetProperty(String string) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(string);
    }

    public Object getModelSetAuxiliaryInfo(String string) {
        return this.modelSetAuxiliaryInfo == null ? null : this.modelSetAuxiliaryInfo.get(string);
    }

    protected boolean getModelSetAuxiliaryInfoBoolean(String string) {
        return this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(string) && (Boolean)this.modelSetAuxiliaryInfo.get(string) != false;
    }

    protected int getTrajectoryCount() {
        return this.trajectorySteps == null ? 0 : this.trajectorySteps.size();
    }

    public int getTrajectoryIndex(int n) {
        return this.models[n].trajectoryBaseIndex;
    }

    public boolean isTrajectory(int n) {
        return this.models[n].isTrajectory;
    }

    public boolean isTrajectory(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        int n = nArray[0];
        for (int i = 1; i <= n; ++i) {
            int n2 = nArray[i];
            if (n2 < 0 || !this.models[this.atoms[n2].modelIndex].isTrajectory) continue;
            return true;
        }
        return false;
    }

    public BitSet getModelBitSet(BitSet bitSet, boolean bl) {
        int n;
        BitSet bitSet2 = new BitSet();
        short s = 0;
        boolean bl2 = bitSet == null;
        int n2 = n = bl2 ? 0 : bitSet.nextSetBit(0);
        while (n2 >= 0 && n2 < this.atomCount) {
            s = this.atoms[n2].modelIndex;
            bitSet2.set(s);
            if (bl) {
                int n3 = this.models[s].trajectoryBaseIndex;
                for (int i = 0; i < this.modelCount; ++i) {
                    if (this.models[i].trajectoryBaseIndex != n3) continue;
                    bitSet2.set(i);
                }
            }
            n2 = this.models[s].firstAtomIndex + this.models[s].atomCount - 1;
            n2 = bl2 ? n2 + 1 : bitSet.nextSetBit(n2 + 1);
        }
        return bitSet2;
    }

    public BitSet getIterativeModels(boolean bl) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            if (!bl && this.isJmolDataFrame(i) || this.models[i].trajectoryBaseIndex != i) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public void selectDisplayedTrajectories(BitSet bitSet) {
        for (int i = 0; i < this.modelCount; ++i) {
            if (!this.models[i].isTrajectory || this.atoms[this.models[i].firstAtomIndex].modelIndex == i) continue;
            bitSet.clear(i);
        }
    }

    public String getModelNumberDotted(int n) {
        return this.modelCount < 1 || n < 0 ? "" : Escape.escapeModelFileNumber(this.modelFileNumbers[n]);
    }

    public int getModelNumber(int n) {
        return this.modelNumbers[n];
    }

    public int getModelFileNumber(int n) {
        return this.modelFileNumbers[n];
    }

    public Properties getModelProperties(int n) {
        return this.models[n].properties;
    }

    public String getModelProperty(int n, String string) {
        Properties properties = this.models[n].properties;
        return properties == null ? null : properties.getProperty(string);
    }

    public Hashtable getModelAuxiliaryInfo(int n) {
        return n < 0 ? null : this.models[n].auxiliaryInfo;
    }

    public void setModelAuxiliaryInfo(int n, Object object, Object object2) {
        this.models[n].auxiliaryInfo.put(object, object2);
    }

    public Object getModelAuxiliaryInfo(int n, String string) {
        if (n < 0) {
            return null;
        }
        return this.models[n].auxiliaryInfo.get(string);
    }

    protected boolean getModelAuxiliaryInfoBoolean(int n, String string) {
        Hashtable hashtable = this.models[n].auxiliaryInfo;
        return hashtable != null && hashtable.containsKey(string) && (Boolean)hashtable.get(string) != false;
    }

    protected int getModelAuxiliaryInfoInt(int n, String string) {
        Hashtable hashtable = this.models[n].auxiliaryInfo;
        if (hashtable != null && hashtable.containsKey(string)) {
            return (Integer)hashtable.get(string);
        }
        return Integer.MIN_VALUE;
    }

    public int getInsertionCountInModel(int n) {
        return this.models[n].nInsertions;
    }

    public String getModelFileType(int n) {
        return (String)this.getModelAuxiliaryInfo(n, "fileType");
    }

    public static int modelFileNumberFromFloat(float f) {
        int n;
        int n2 = (int)f;
        for (n = (int)(((double)(f - (float)n2) + 1.0E-5) * 10000.0); n != 0 && n % 10 == 0; n /= 10) {
        }
        return n2 * 1000000 + n;
    }

    public int getAltLocCountInModel(int n) {
        return this.models[n].nAltLocs;
    }

    private void propagateSecondaryStructure() {
        int n = this.structureCount;
        while (--n >= 0) {
            Structure structure = this.structures[n];
            this.models[structure.modelIndex].addSecondaryStructure(structure.type, structure.structureID, structure.serialID, structure.strandCount, structure.startChainID, structure.startSeqcode, structure.endChainID, structure.endSeqcode);
        }
    }

    public int getChainCount(boolean bl) {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getChainCount(bl);
        }
        return n;
    }

    public int getBioPolymerCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (this.models[n2].isTrajectory && this.models[n2].trajectoryBaseIndex != n2) continue;
            n += this.models[n2].getBioPolymerCount();
        }
        return n;
    }

    public int getBioPolymerCountInModel(int n) {
        if (n < 0) {
            return this.getBioPolymerCount();
        }
        if (this.models[n].isTrajectory && this.models[n].trajectoryBaseIndex != n) {
            return 0;
        }
        return this.models[n].getBioPolymerCount();
    }

    public void getPolymerPointsAndVectors(BitSet bitSet, Vector vector) {
        boolean bl = this.viewer.getTraceAlpha();
        float f = this.viewer.getSheetSmoothing();
        int n = 0x7FFFFFFE;
        for (int i = 0; i < this.modelCount; ++i) {
            int n2 = this.models[i].getBioPolymerCount();
            for (int j = 0; j < n2; ++j) {
                n = this.models[i].getBioPolymer(j).getPolymerPointsAndVectors(n, bitSet, vector, bl, f);
            }
        }
    }

    public void recalculateLeadMidpointsAndWingVectors(int n) {
        if (n < 0) {
            for (int i = 0; i < this.modelCount; ++i) {
                this.recalculateLeadMidpointsAndWingVectors(i);
            }
            return;
        }
        int n2 = this.models[n].getBioPolymerCount();
        for (int i = 0; i < n2; ++i) {
            this.models[n].getBioPolymer(i).recalculateLeadMidpointsAndWingVectors();
        }
    }

    public Point3f[] getPolymerLeadMidPoints(int n, int n2) {
        return this.models[n].getBioPolymer(n2).getLeadMidpoints();
    }

    public int getChainCountInModel(int n, boolean bl) {
        if (n < 0) {
            return this.getChainCount(bl);
        }
        return this.models[n].getChainCount(bl);
    }

    public int getGroupCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getGroupCount();
        }
        return n;
    }

    public int getGroupCountInModel(int n) {
        if (n < 0) {
            return this.getGroupCount();
        }
        return this.models[n].getGroupCount();
    }

    public void calcSelectedGroupsCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedGroupsCount(bitSet);
        }
    }

    public void calcSelectedMonomersCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedMonomersCount(bitSet);
        }
    }

    public void calcHydrogenBonds(BitSet bitSet, BitSet bitSet2) {
        int n = this.modelCount;
        while (--n >= 0) {
            if (this.models[n].trajectoryBaseIndex != n) continue;
            this.clearCalculatedHydrogenBonds(n, bitSet);
            this.models[n].calcHydrogenBonds(bitSet, bitSet2);
        }
    }

    public void calculateStraightness() {
        if (this.getHaveStraightness()) {
            return;
        }
        char c = 'S';
        char c2 = this.viewer.getQuaternionFrame();
        int n = this.viewer.getHelixStep();
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            Model model = this.models[n2];
            int n3 = model.getBioPolymerCount();
            for (int i = 0; i < n3; ++i) {
                model.bioPolymers[i].getPdbData(this.viewer, c, c2, n, 2, false, null, null, null, null, false, new BitSet());
            }
        }
        this.setHaveStraightness(true);
    }

    public Quaternion[] getAtomGroupQuaternions(BitSet bitSet, int n, char c) {
        int n2 = 0;
        Vector<Quaternion> vector = new Vector<Quaternion>();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0 && n2 < n) {
            block7: {
                Quaternion quaternion;
                Group group;
                block6: {
                    group = this.atoms[n3].group;
                    quaternion = group.getQuaternion(c);
                    if (quaternion != null) break block6;
                    if (group.seqcode == Integer.MIN_VALUE) {
                        quaternion = group.getQuaternionFrame(this.atoms);
                    }
                    if (quaternion == null) break block7;
                }
                vector.add(quaternion);
                n3 = group.lastAtomIndex;
            }
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        Quaternion[] quaternionArray = new Quaternion[vector.size()];
        for (int i = 0; i < quaternionArray.length; ++i) {
            quaternionArray[i] = (Quaternion)vector.get(i);
        }
        return quaternionArray;
    }

    public String getPdbAtomData(BitSet bitSet) {
        if (this.atomCount == 0) {
            return "";
        }
        short s = this.atoms[0].modelIndex;
        short s2 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = s != this.atoms[this.atomCount - 1].modelIndex;
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.atoms[n];
            if (bl && atom.modelIndex != s2) {
                if (s2 != -1) {
                    stringBuffer.append("ENDMDL\n");
                }
                s2 = atom.modelIndex;
                stringBuffer.append("MODEL     " + (s2 + 1) + "\n");
            }
            if (!this.models[atom.modelIndex].isPDB) {
                stringBuffer.append(LabelToken.formatLabel(this.viewer, atom, "HETATM%5i %-4a%1AUNK %1c   1%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]  \n"));
            } else if (atom.isHetero()) {
                stringBuffer.append(LabelToken.formatLabel(this.viewer, atom, "HETATM%5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]  \n"));
            } else {
                stringBuffer.append(LabelToken.formatLabel(this.viewer, atom, "ATOM  %5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2[symbol]  \n"));
            }
            n = bitSet.nextSetBit(n + 1);
        }
        if (bl) {
            stringBuffer.append("ENDMDL\n");
        }
        return stringBuffer.toString();
    }

    public String getPdbData(int n, String string, BitSet bitSet, boolean bl) {
        char c;
        char c2;
        if (this.isJmolDataFrame(n)) {
            n = this.getJmolDataSourceFrame(n);
        }
        if (n < 0) {
            return "";
        }
        if (!this.models[n].isPDB) {
            return null;
        }
        Model model = this.models[n];
        char c3 = c2 = string.length() > 11 && string.indexOf("quaternion ") >= 0 ? (char)string.charAt(11) : (char)'R';
        char c4 = c2 != 'R' ? (char)'r' : (c = string.length() > 13 && string.indexOf("ramachandran ") >= 0 ? (char)string.charAt(13) : (char)'R');
        if (c == 'r') {
            c = this.viewer.getQuaternionFrame();
        }
        int n2 = this.viewer.getHelixStep();
        int n3 = string.indexOf("diff") < 0 ? 0 : (string.indexOf("2") < 0 ? 1 : 2);
        boolean bl2 = string.indexOf("draw") >= 0;
        BitSet bitSet2 = this.getModelAtomBitSet(n, false);
        int n4 = model.getBioPolymerCount();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        BitSet bitSet3 = new BitSet();
        for (int i = 0; i < n4; ++i) {
            model.bioPolymers[i].getPdbData(this.viewer, c2, c, n2, n3, bl2, bitSet2, stringBuffer, stringBuffer2, bitSet, i == 0, bitSet3);
        }
        stringBuffer.append(stringBuffer2);
        String string2 = stringBuffer.toString();
        if (bl2 || string2.length() == 0) {
            return string2;
        }
        String string3 = "REMARK   6 Jmol PDB-encoded data: " + string + ";";
        if (c2 != 'R') {
            string3 = string3 + "  quaternionFrame = \"" + c + "\"";
        }
        string3 = string3 + "\nREMARK   6 Jmol Version " + Viewer.getJmolVersion();
        bitSet.and(bitSet2);
        string3 = string3 + "\n\n" + this.getProteinStructureState(bitSet3, false, c2 == 'R', true);
        return string3 + string2;
    }

    public boolean isJmolDataFrame(int n) {
        return n >= 0 && n < this.modelCount && this.models[n].jmolData != null;
    }

    private boolean isJmolDataFrame(Atom atom) {
        return this.models[atom.modelIndex].jmolData != null;
    }

    public void setJmolDataFrame(String string, int n, int n2) {
        Model model = this.models[string == null ? this.models[n2].dataSourceFrame : n];
        if (string == null) {
            string = this.models[n2].jmolFrameType;
        }
        if (n >= 0) {
            if (model.dataFrames == null) {
                model.dataFrames = new Hashtable();
            }
            this.models[n2].dataSourceFrame = n;
            this.models[n2].jmolFrameType = string;
            model.dataFrames.put(string, new Integer(n2));
        }
        if (string.startsWith("quaternion") && string.indexOf("deriv") < 0) {
            string = string.substring(0, string.indexOf(" "));
            model.dataFrames.put(string, new Integer(n2));
        }
    }

    public int getJmolDataFrameIndex(int n, String string) {
        if (this.models[n].dataFrames == null) {
            return -1;
        }
        Integer n2 = (Integer)this.models[n].dataFrames.get(string);
        return n2 == null ? -1 : n2;
    }

    protected void clearDataFrameReference(int n) {
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable hashtable = this.models[i].dataFrames;
            if (hashtable == null) continue;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                if ((Integer)hashtable.get(k) != n) continue;
                hashtable.remove(k);
            }
        }
    }

    public String getJmolFrameType(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].jmolFrameType : "modelSet";
    }

    public int getJmolDataSourceFrame(int n) {
        return n >= 0 && n < this.modelCount ? this.models[n].dataSourceFrame : -1;
    }

    public void saveModelOrientation(int n, StateManager.Orientation orientation) {
        this.models[n].orientation = orientation;
    }

    public StateManager.Orientation getModelOrientation(int n) {
        return this.models[n].orientation;
    }

    private String getFullPDBHeader(int n) {
        if (n < 0) {
            return "";
        }
        String string = (String)this.getModelAuxiliaryInfo(n, "fileHeader");
        if (string != null) {
            return string;
        }
        string = this.viewer.getCurrentFileAsString();
        int n2 = string.length();
        int n3 = pdbRecords.length;
        block4: while (--n3 >= 0) {
            String string2 = pdbRecords[n3];
            int n4 = string.startsWith(string2) ? 0 : string.indexOf("\n" + string2);
            switch (n4) {
                case -1: {
                    continue block4;
                }
                case 0: {
                    this.setModelAuxiliaryInfo(n, "fileHeader", "");
                    return "";
                }
            }
            if (n4 >= n2) continue;
            n2 = ++n4;
        }
        string = string.substring(0, n2);
        this.setModelAuxiliaryInfo(n, "fileHeader", string);
        return string;
    }

    public String getPDBHeader(int n) {
        return this.isPDB ? this.getFullPDBHeader(n) : this.getFileHeader(n);
    }

    public String getFileHeader(int n) {
        if (n < 0) {
            return "";
        }
        if (this.isPDB) {
            return this.getFullPDBHeader(n);
        }
        String string = (String)this.getModelAuxiliaryInfo(n, "fileHeader");
        if (string == null) {
            string = this.modelSetName;
        }
        if (string != null) {
            return string;
        }
        return "no header information found";
    }

    public Hashtable getModelInfo(BitSet bitSet) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("modelSetName", this.modelSetName);
        hashtable.put("modelCount", new Integer(this.modelCount));
        hashtable.put("modelSetHasVibrationVectors", this.modelSetHasVibrationVectors());
        if (this.modelSetProperties != null) {
            hashtable.put("modelSetProperties", this.modelSetProperties);
        }
        hashtable.put("modelCountSelected", new Integer(BitSetUtil.cardinalityOf(bitSet)));
        hashtable.put("modelsSelected", bitSet);
        Vector vector = new Vector();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("_ipt", new Integer(n));
            hashtable2.put("num", new Integer(this.getModelNumber(n)));
            hashtable2.put("file_model", this.getModelNumberDotted(n));
            hashtable2.put("name", this.getModelName(n));
            String string = this.getModelTitle(n);
            if (string != null) {
                hashtable2.put("title", string);
            }
            if ((string = this.getModelFileName(n)) != null) {
                hashtable2.put("file", string);
            }
            hashtable2.put("vibrationVectors", this.modelHasVibrationVectors(n));
            hashtable2.put("atomCount", new Integer(this.getAtomCountInModel(n)));
            hashtable2.put("bondCount", new Integer(this.getBondCountInModel(n)));
            hashtable2.put("groupCount", new Integer(this.getGroupCountInModel(n)));
            hashtable2.put("polymerCount", new Integer(this.models[n].getBioPolymerCount()));
            hashtable2.put("chainCount", new Integer(this.getChainCountInModel(n, true)));
            if (this.models[n].properties != null) {
                hashtable2.put("modelProperties", this.models[n].properties);
            }
            vector.addElement(hashtable2);
            n = bitSet.nextSetBit(n + 1);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public int getAltLocIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getAltLocListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public int getInsertionCodeIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getInsertionListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public String getAltLocListInModel(int n) {
        if (n < 0) {
            return "";
        }
        String string = (String)this.getModelAuxiliaryInfo(n, "altLocs");
        return string == null ? "" : string;
    }

    private String getInsertionListInModel(int n) {
        String string = (String)this.getModelAuxiliaryInfo(n, "insertionCodes");
        return string == null ? "" : string;
    }

    public int getModelSymmetryCount(int n) {
        String[] stringArray;
        if (this.unitCells == null || this.unitCells[n] == null || (stringArray = this.unitCells[n].getSymmetryOperations()) == null) {
            return this.models[n].biosymmetryCount;
        }
        return stringArray.length;
    }

    public String getSymmetryOperation(int n, String string, int n2, Point3f point3f, Point3f point3f2, String string2) {
        Hashtable hashtable = this.getSpaceGroupInfo(n, string, n2, point3f, point3f2, string2);
        if (hashtable == null) {
            return "";
        }
        Object[][] objectArray = (Object[][])hashtable.get("operations");
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        --n2;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || n2 >= 0 && n2 != i) continue;
            if (string2 != null) {
                return (String)objectArray[i][3];
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            if (n2 < 0) {
                stringBuffer.append(i + 1).append("\t");
            }
            stringBuffer.append(objectArray[i][0]).append("\t").append(objectArray[i][2]);
        }
        if (stringBuffer.length() == 0 && string2 != null) {
            stringBuffer.append("draw " + string2 + "* delete");
        }
        return stringBuffer.toString();
    }

    public int[] getModelCellRange(int n) {
        if (this.unitCells == null) {
            return null;
        }
        return this.unitCells[n].getCellRange();
    }

    public boolean modelHasVibrationVectors(int n) {
        if (this.vibrationVectors != null) {
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                if (n >= 0 && this.atoms[n2].modelIndex != n || this.vibrationVectors[n2] == null || !(this.vibrationVectors[n2].length() > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public BitSet getElementsPresentBitSet(int n) {
        if (n >= 0) {
            return this.elementsPresent[n];
        }
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            bitSet.or(this.elementsPresent[i]);
        }
        return bitSet;
    }

    private String getSymmetryInfoAsString(int n) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        return symmetryInterface == null ? "no symmetry information" : symmetryInterface.getSymmetryInfoString();
    }

    public void toCartesian(int n, Point3f point3f) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        if (symmetryInterface != null) {
            symmetryInterface.toCartesian(point3f);
        }
    }

    public void toFractional(int n, Point3f point3f) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        if (symmetryInterface != null) {
            symmetryInterface.toFractional(point3f);
        }
    }

    public void toUnitCell(int n, Point3f point3f, Point3f point3f2) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        if (symmetryInterface != null) {
            this.unitCells[n].toUnitCell(point3f, point3f2);
        }
    }

    public boolean setUnitCellOffset(int n, Point3f point3f) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        if (symmetryInterface == null) {
            return false;
        }
        symmetryInterface.setUnitCellOffset(point3f);
        return true;
    }

    public boolean setUnitCellOffset(int n, int n2) {
        SymmetryInterface symmetryInterface = this.getUnitCell(n);
        if (symmetryInterface == null) {
            return false;
        }
        symmetryInterface.setOffset(n2);
        return true;
    }

    public Vector getMoleculeInfo(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.moleculeCount; ++i) {
            this.bsTemp = BitSetUtil.copy(bitSet);
            this.bsTemp.and(this.molecules[i].atomList);
            if (this.bsTemp.length() <= 0) continue;
            vector.addElement(this.molecules[i].getInfo());
        }
        return vector;
    }

    public int getMoleculeIndex(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].indexInModel;
        }
        return 0;
    }

    public void rotateAtoms(Matrix3f matrix3f, Matrix3f matrix3f2, BitSet bitSet, boolean bl, Point3f point3f, boolean bl2) {
        this.bspf = null;
        BitSet bitSet2 = bl ? this.getMoleculeBitSet(bitSet) : BitSetUtil.copy(bitSet);
        this.matInv.set(matrix3f2);
        this.matInv.invert();
        this.ptTemp.set(0.0f, 0.0f, 0.0f);
        this.matTemp.mul(matrix3f, matrix3f2);
        this.matTemp.mul(this.matInv, this.matTemp);
        int n = 0;
        int n2 = bitSet2.nextSetBit(0);
        while (n2 >= 0) {
            if (bl2) {
                this.atoms[n2].sub(point3f);
                this.matTemp.transform(this.atoms[n2]);
                this.atoms[n2].add(point3f);
            } else {
                this.ptTemp.add(this.atoms[n2]);
                this.matTemp.transform(this.atoms[n2]);
                this.ptTemp.sub(this.atoms[n2]);
            }
            this.taint(n2, (byte)2);
            ++n;
            n2 = bitSet2.nextSetBit(n2 + 1);
        }
        if (n == 0) {
            return;
        }
        if (!bl2) {
            this.ptTemp.scale(1.0f / (float)n);
            n2 = bitSet2.nextSetBit(0);
            while (n2 >= 0) {
                this.atoms[n2].add(this.ptTemp);
                n2 = bitSet2.nextSetBit(n2 + 1);
            }
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
    }

    public BitSet getMoleculeBitSet(BitSet bitSet) {
        int n;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BitSet bitSet2 = BitSetUtil.copy(bitSet);
        BitSet bitSet3 = BitSetUtil.copy(bitSet);
        while ((n = bitSet3.length()) > 0) {
            this.bsTemp = this.getMoleculeBitSet(n - 1);
            bitSet3.andNot(this.bsTemp);
            bitSet2.or(this.bsTemp);
        }
        return bitSet2;
    }

    public BitSet getMoleculeBitSet(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    public void invertSelected(Point3f point3f, Point4f point4f, BitSet bitSet) {
        this.bspf = null;
        if (point3f != null) {
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                float f = (point3f.x - this.atoms[n].x) * 2.0f;
                float f2 = (point3f.y - this.atoms[n].y) * 2.0f;
                float f3 = (point3f.z - this.atoms[n].z) * 2.0f;
                this.setAtomCoordRelative(n, f, f2, f3);
                n = bitSet.nextSetBit(n + 1);
            }
            return;
        }
        Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
        vector3f.normalize();
        float f = (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            float f4 = -Measure.distanceToPlane(point4f, f, (Point3f)this.atoms[n]) * 2.0f;
            float f5 = vector3f.x * f4;
            float f6 = vector3f.y * f4;
            float f7 = vector3f.z * f4;
            this.setAtomCoordRelative(n, f5, f6, f7);
            n = bitSet.nextSetBit(n + 1);
        }
    }

    public Vector3f getModelDipole(int n) {
        if (n < 0) {
            return null;
        }
        Vector3f vector3f = (Vector3f)this.getModelAuxiliaryInfo(n, "dipole");
        if (vector3f == null) {
            vector3f = (Vector3f)this.getModelAuxiliaryInfo(n, "DIPOLE_VEC");
        }
        return vector3f;
    }

    public Vector3f calculateMolecularDipole(int n) {
        if (this.partialCharges == null || n < 0) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].modelIndex != n) continue;
            float f3 = this.partialCharges[i];
            if (f3 < 0.0f) {
                ++n3;
                f2 += f3;
                vector3f2.scaleAdd(f3, this.atoms[i], vector3f2);
                continue;
            }
            if (!(f3 > 0.0f)) continue;
            ++n2;
            f += f3;
            vector3f.scaleAdd(f3, this.atoms[i], vector3f);
        }
        if (n3 == 0 || n2 == 0) {
            return null;
        }
        vector3f.scale(1.0f / f);
        vector3f2.scale(1.0f / f2);
        vector3f.sub(vector3f2);
        Logger.warn("CalculateMolecularDipole: this is an approximate result -- needs checking");
        vector3f.scale(f * 4.8f);
        return vector3f;
    }

    public int getMoleculeCountInModel(int n) {
        int n2 = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        if (n < 0) {
            return this.moleculeCount;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (n != i) continue;
            n2 += this.models[i].moleculeCount;
        }
        return n2;
    }

    public void calcSelectedMoleculesCount(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        this.selectedMoleculeCount = 0;
        for (int i = 0; i < this.moleculeCount; ++i) {
            BitSetUtil.copy(bitSet, this.bsTemp);
            this.bsTemp.and(this.molecules[i].atomList);
            if (this.bsTemp.length() <= 0) continue;
            this.selectedMolecules.set(i);
            ++this.selectedMoleculeCount;
        }
    }

    public Molecule[] getMolecules() {
        if (this.moleculeCount > 0) {
            return this.molecules;
        }
        if (this.molecules == null) {
            this.molecules = new Molecule[4];
        }
        this.moleculeCount = 0;
        BitSet bitSet = new BitSet(this.atomCount);
        BitSet bitSet2 = new BitSet(this.atomCount);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        Model model = null;
        for (int i = 0; i < this.atomCount; ++i) {
            if (bitSet.get(i) || bitSet2.get(i)) continue;
            n2 = this.atoms[i].modelIndex;
            if (n2 != n) {
                n3 = -1;
                model = this.models[n2];
                model.firstMolecule = this.moleculeCount;
                n4 = this.moleculeCount - 1;
                n = n2;
            }
            ++n3;
            bitSet2 = this.getBranchBitSet(i, -1);
            bitSet.or(bitSet2);
            if (this.moleculeCount == this.molecules.length) {
                this.molecules = (Molecule[])ArrayUtil.setLength(this.molecules, this.moleculeCount * 2);
            }
            this.molecules[this.moleculeCount] = new Molecule((ModelSet)this, this.moleculeCount, i, bitSet2, n, n3);
            model.moleculeCount = this.moleculeCount++ - n4;
        }
        return this.molecules;
    }

    public BitSet getBranchBitSet(int n, int n2) {
        BitSet bitSet = new BitSet(this.atomCount);
        if (n < 0) {
            return bitSet;
        }
        BitSet bitSet2 = this.getModelAtomBitSet(this.atoms[n].modelIndex, true);
        if (n2 >= 0) {
            bitSet2.clear(n2);
        }
        this.getCovalentlyConnectedBitSet(this.atoms[n], bitSet, bitSet2);
        return bitSet;
    }

    private void getCovalentlyConnectedBitSet(Atom atom, BitSet bitSet, BitSet bitSet2) {
        int n = atom.index;
        if (!bitSet2.get(n)) {
            return;
        }
        bitSet2.clear(n);
        bitSet.set(n);
        if (atom.bonds == null) {
            return;
        }
        int n2 = atom.bonds.length;
        while (--n2 >= 0) {
            Bond bond = atom.bonds[n2];
            if ((bond.order & 0x7800) != 0) continue;
            this.getCovalentlyConnectedBitSet(bond.getOtherAtom(atom), bitSet, bitSet2);
        }
    }

    public boolean hasCalculatedHBonds(BitSet bitSet) {
        BitSet bitSet2 = this.getModelBitSet(bitSet, false);
        int n = bitSet2.nextSetBit(0);
        while (n >= 0) {
            if (this.models[this.atoms[n].modelIndex].hasCalculatedHBonds) {
                return true;
            }
            n = bitSet2.nextSetBit(n + 1);
        }
        return false;
    }

    public void clearCalculatedHydrogenBonds(int n, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n2 = 0;
        this.models[n].hasCalculatedHBonds = false;
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            Bond bond = this.bonds[n3];
            if (n >= 0 && this.models[bond.atom1.modelIndex].trajectoryBaseIndex != n || (bond.order & 0x7000) == 0) continue;
            if (bitSet != null && !bitSet.get(bond.atom1.index)) {
                this.models[n].hasCalculatedHBonds = true;
                continue;
            }
            bitSet2.set(n3);
            ++n2;
        }
        if (n2 > 0) {
            this.deleteBonds(bitSet2, false);
        }
    }

    protected void initializeBspf() {
        if (this.bspf == null) {
            if (Logger.debugging) {
                Logger.startTimer();
            }
            this.bspf = new Bspf(3);
            Logger.debug("sequential bspt order");
            int n = this.atomCount;
            while (--n >= 0) {
                Atom atom = this.atoms[n];
                this.bspf.addTuple(this.models[atom.modelIndex].trajectoryBaseIndex, atom);
            }
            if (Logger.debugging) {
                Logger.checkTimer("Time to build bspf");
                this.bspf.stats();
            }
        }
    }

    protected void initializeBspt(int n) {
        if (this.bspf.isInitialized(n)) {
            return;
        }
        this.bspf.initialize(n, this.atoms, this.getModelAtomBitSet(n, false));
    }

    public AtomIndexIterator getWithinAtomSetIterator(int n, float f, BitSet bitSet, boolean bl, boolean bl2) {
        this.initializeBspf();
        int n2 = this.atoms[n].modelIndex;
        n2 = this.models[n2].trajectoryBaseIndex;
        this.initializeBspt(n2);
        if (this.withinAtomSetIterator == null) {
            this.withinAtomSetIterator = new AtomIteratorWithinSet();
        }
        this.withinAtomSetIterator.initialize(this.bspf, n2, n, this.atoms[n], f, bitSet, bl, bl2 ? this.models[n2].firstAtomIndex : 0);
        return this.withinAtomSetIterator;
    }

    public AtomIndexIterator getWithinModelIterator(Atom atom, float f) {
        return this.getWithinModelIterator(atom.modelIndex, atom, f);
    }

    private AtomIndexIterator getWithinModelIterator(int n, Point3f point3f, float f) {
        this.initializeBspf();
        n = this.models[n].trajectoryBaseIndex;
        this.initializeBspt(n);
        if (this.withinModelIterator == null) {
            this.withinModelIterator = new AtomIteratorWithinModel();
        }
        this.withinModelIterator.initialize(this.bspf, n, point3f, f);
        return this.withinModelIterator;
    }

    public int getBondCountInModel(int n) {
        return n < 0 ? this.bondCount : this.models[n].getBondCount();
    }

    public void setAtomCoordRelative(Point3f point3f, BitSet bitSet) {
        this.setAtomCoordRelative(bitSet, point3f.x, point3f.y, point3f.z);
        this.recalculatePositionDependentQuantities();
    }

    public void setAtomCoord(BitSet bitSet, int n, Object object) {
        super.setAtomCoord(bitSet, n, object);
        switch (n) {
            case 1112541206: 
            case 1112541207: 
            case 1112541208: 
            case 1146095629: {
                break;
            }
            default: {
                this.recalculatePositionDependentQuantities();
            }
        }
    }

    private void recalculatePositionDependentQuantities() {
        if (this.getHaveStraightness()) {
            this.calculateStraightness();
        }
        this.recalculateLeadMidpointsAndWingVectors(-1);
    }

    public int calculateStruts(BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3;
        this.makeConnections(0.0f, Float.MAX_VALUE, 32768, 0, bitSet, bitSet2, null, false);
        int n = bitSet.nextSetBit(0);
        if (n < 0) {
            return 0;
        }
        short s = this.atoms[n].modelIndex;
        Model model = this.models[s];
        if (!model.isPDB) {
            return 0;
        }
        Vector<Atom> vector = new Vector<Atom>();
        Atom atom = null;
        if (bitSet.equals(bitSet2)) {
            bitSet3 = bitSet;
        } else {
            bitSet3 = BitSetUtil.copy(bitSet);
            bitSet3.or(bitSet2);
        }
        bitSet3.and(this.getModelAtomBitSet(s, false));
        int n2 = bitSet3.nextSetBit(0);
        while (n2 >= 0) {
            if (this.atoms[n2].isVisible(0) && this.atoms[n2].getSpecialAtomID() == 2 && this.atoms[n2].getGroupID() != 5) {
                atom = this.atoms[n2];
                vector.add(atom);
            }
            n2 = bitSet3.nextSetBit(n2 + 1);
        }
        if (vector.size() == 0) {
            return 0;
        }
        float f = this.viewer.getStrutLengthMaximum();
        short s2 = (short)(this.viewer.getStrutDefaultRadius() * 2000.0f);
        int n3 = this.viewer.getStrutSpacingMinimum();
        boolean bl = this.viewer.getStrutsMultiple();
        Vector vector2 = model.getBioPolymer(atom.getPolymerIndexInModel()).calculateStruts((ModelSet)this, this.atoms, bitSet, bitSet2, vector, f, n3, bl);
        for (int i = 0; i < vector2.size(); ++i) {
            Object[] objectArray = (Object[])vector2.get(i);
            this.bondAtoms((Atom)objectArray[0], (Atom)objectArray[1], 32768, s2, null);
        }
        return vector2.size();
    }

    public int getAtomCountInModel(int n) {
        return n < 0 ? this.atomCount : this.models[n].atomCount;
    }

    public BitSet getModelAtomBitSet(int n, boolean bl) {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = n < 0 ? this.bsAll : this.models[n].bsAtoms;
        if (bitSet == null) {
            bitSet = this.bsAll = BitSetUtil.setAll(this.atomCount);
        }
        return bl ? BitSetUtil.copy(bitSet) : bitSet;
    }

    public BitSet getAtomBits(int n, Object object) {
        switch (n) {
            default: {
                return super.getAtomBits(n, object);
            }
            case 1095761934: {
                return this.getMoleculeBitSet((BitSet)object);
            }
            case 1679429641: {
                BoxInfo boxInfo = this.getBoxInfo((BitSet)object, 1.0f);
                BitSet bitSet = this.getAtomsWithin(boxInfo.getBoundBoxCornerVector().length() + 1.0E-4f, boxInfo.getBoundBoxCenter(), null, -1);
                int n2 = bitSet.nextSetBit(0);
                while (n2 >= 0) {
                    if (!boxInfo.isWithin(this.atoms[n2])) {
                        bitSet.clear(n2);
                    }
                    n2 = bitSet.nextSetBit(n2 + 1);
                }
                return bitSet;
            }
            case 1048615: {
                int[] nArray = (int[])object;
                int n3 = nArray[0];
                int n4 = nArray[1];
                char c = (char)nArray[2];
                BitSet bitSet = new BitSet();
                boolean bl = this.viewer.getChainCaseSensitive();
                if (!bl) {
                    c = Character.toUpperCase(c);
                }
                int n5 = this.modelCount;
                while (--n5 >= 0) {
                    this.models[n5].selectSeqcodeRange(n3, n4, c, bitSet, bl);
                }
                return bitSet;
            }
            case 3145753: {
                BitSet bitSet = new BitSet(this.atomCount);
                short s = -1;
                int n6 = 0;
                int n7 = this.atomCount;
                block10: while (--n7 >= 0) {
                    Atom atom = this.atoms[n7];
                    BitSet bitSet2 = atom.getAtomSymmetry();
                    if (bitSet2 == null) continue;
                    if (atom.modelIndex != s) {
                        s = atom.modelIndex;
                        if (this.getModelCellRange(s) == null) continue;
                        n6 = this.getModelSymmetryCount(s);
                    }
                    int n8 = 0;
                    int n9 = n6;
                    while (--n9 >= 0) {
                        if (!bitSet2.get(n9) || ++n8 <= 1) continue;
                        bitSet.set(n7);
                        continue block10;
                    }
                }
                return bitSet;
            }
            case 1089470477: {
                return BitSetUtil.copy(this.bsSymmetry == null ? (this.bsSymmetry = new BitSet(this.atomCount)) : this.bsSymmetry);
            }
            case 1614417984: 
        }
        BitSet bitSet = new BitSet();
        SymmetryInterface symmetryInterface = this.viewer.getCurrentUnitCell();
        if (symmetryInterface == null) {
            return bitSet;
        }
        Point3f point3f = new Point3f(1.0f, 1.0f, 1.0f);
        int n10 = this.atomCount;
        while (--n10 >= 0) {
            if (!this.isInLatticeCell(n10, point3f)) continue;
            bitSet.set(n10);
        }
        return bitSet;
    }

    public BitSet getAtomsWithin(float f, BitSet bitSet, boolean bl) {
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = this.getIterativeModels(false);
        float f2 = f * f;
        int n = 0;
        if (bl) {
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                int n3 = this.modelCount;
                while (--n3 >= 0) {
                    if (!bitSet3.get(n3)) continue;
                    if (f < 0.0f) {
                        this.getAtomsWithin(-f, this.atoms[n2], bitSet2, -1);
                        this.getAtomsWithin(f, this.atoms[n2].getFractionalUnitCoord(true), bitSet2, -1);
                        continue;
                    }
                    AtomIndexIterator atomIndexIterator = this.getWithinModelIterator(n3, this.atoms[n2], f);
                    while (atomIndexIterator.hasNext()) {
                        n = atomIndexIterator.next();
                        if (n < 0 || !(atomIndexIterator.foundDistance2() <= f2)) continue;
                        bitSet2.set(n);
                    }
                }
                n2 = bitSet.nextSetBit(n2 + 1);
            }
        } else {
            int n4 = bitSet.nextSetBit(0);
            while (n4 >= 0) {
                if (f < 0.0f) {
                    this.getAtomsWithin(-f, this.atoms[n4], bitSet2, this.atoms[n4].modelIndex);
                    this.getAtomsWithin(f, this.atoms[n4], bitSet2, this.atoms[n4].modelIndex);
                } else {
                    AtomIndexIterator atomIndexIterator = this.getWithinModelIterator(this.atoms[n4], f);
                    while (atomIndexIterator.hasNext()) {
                        n = atomIndexIterator.next();
                        if (n < 0 || !(atomIndexIterator.foundDistance2() <= f2)) continue;
                        bitSet2.set(n);
                    }
                }
                n4 = bitSet.nextSetBit(n4 + 1);
            }
        }
        return bitSet2;
    }

    public BitSet getAtomsWithin(float f, Point3f point3f, BitSet bitSet, int n) {
        if (bitSet == null) {
            bitSet = new BitSet();
        }
        if (f < 0.0f) {
            f = -f;
            Point3f point3f2 = new Point3f();
            Point3f point3f3 = new Point3f();
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                Atom atom = this.atoms[n2];
                if (n >= 0 && this.atoms[n2].modelIndex != n || bitSet.get(n2) || !(atom.getFractionalUnitDistance(point3f, point3f2, point3f3) <= f)) continue;
                bitSet.set(atom.index);
            }
            return bitSet;
        }
        BitSet bitSet2 = this.getIterativeModels(false);
        float f2 = f * f;
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            if (!bitSet2.get(n3)) continue;
            AtomIndexIterator atomIndexIterator = this.getWithinModelIterator(n3, point3f, f);
            while (atomIndexIterator.hasNext()) {
                int n4 = atomIndexIterator.next();
                if (n4 < 0 || !(atomIndexIterator.foundDistance2() <= f2)) continue;
                bitSet.set(n4);
            }
        }
        return bitSet;
    }

    public BitSet getSequenceBits(String string, BitSet bitSet) {
        String string2 = "";
        int n = string.length();
        BitSet bitSet2 = new BitSet();
        if (n == 0) {
            return bitSet2;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            int n2 = this.getBioPolymerCountInModel(i);
            block1: for (int j = 0; j < n2; ++j) {
                string2 = this.models[i].getBioPolymer(j).getSequence();
                int n3 = -1;
                while (true) {
                    ++n3;
                    if ((n3 = string2.indexOf(string, n3)) < 0) continue block1;
                    this.models[i].getBioPolymer(j).getPolymerSequenceAtoms(i, j, n3, n, bitSet, bitSet2);
                }
            }
        }
        return bitSet2;
    }

    public void deleteBonds(BitSet bitSet, boolean bl) {
        if (!bl) {
            BitSet bitSet2 = new BitSet();
            BitSet bitSet3 = new BitSet();
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bitSet2.clear();
                bitSet3.clear();
                bitSet2.set(this.bonds[n].getAtomIndex1());
                bitSet3.set(this.bonds[n].getAtomIndex2());
                this.addStateScript("connect ", null, bitSet2, bitSet3, "delete", false, true);
                n = bitSet.nextSetBit(n + 1);
            }
        }
        super.deleteBonds(bitSet, bl);
    }

    protected int[] makeConnections(float f, float f2, int n, int n2, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        boolean bl2;
        boolean bl3 = n == 65535;
        boolean bl4 = n == 2048;
        boolean bl5 = n == 131071;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        float f3 = f * f;
        float f4 = f2 * f2;
        switch (n2) {
            case 0: {
                return this.deleteConnections(f, f2, n, bitSet, bitSet2, bl, bl5, f3, f4);
            }
            case 0x4000000E: {
                if (n != 515) {
                    return this.autoBond(n, bitSet, bitSet2, bitSet3, bl, bl4);
                }
                bl7 = true;
                bl9 = true;
                break;
            }
            case 5: {
                bl6 = true;
                break;
            }
            case 1073741934: {
                bl7 = true;
                break;
            }
            case 1073741864: {
                bl8 = true;
            }
        }
        if (bl5) {
            n = 1;
        }
        this.defaultCovalentMad = this.viewer.getMadBond();
        boolean bl10 = f < 0.0f;
        boolean bl11 = bl2 = f2 < 0.0f;
        if (bl10) {
            f = -f;
        }
        if (bl2) {
            f2 = -f2;
        }
        short s = this.getDefaultMadFromOrder(n);
        int n3 = 0;
        int n4 = 0;
        Bond bond = null;
        int n5 = bl ? 1 : this.atomCount;
        Atom atom = null;
        Atom atom2 = null;
        float f5 = 0.0f;
        float f6 = 0.0f;
        short s2 = (short)(n | 0x20000);
        int n6 = bitSet.nextSetBit(0);
        while (n6 >= 0) {
            if (bl) {
                bond = this.bonds[n6];
                atom = bond.atom1;
                atom2 = bond.atom2;
            } else {
                atom = this.atoms[n6];
            }
            int n7 = n5;
            while (--n7 >= 0) {
                if (!bl) {
                    if (n7 == n6 || !bitSet2.get(n7)) continue;
                    atom2 = this.atoms[n7];
                    if (atom.modelIndex != atom2.modelIndex || atom.alternateLocationID != atom2.alternateLocationID && atom.alternateLocationID != '\u0000' && atom2.alternateLocationID != '\u0000') continue;
                    bond = atom.getBond(atom2);
                }
                if (bond == null && (bl6 || bl7) || bond != null && bl8) continue;
                float f7 = atom.distanceSquared(atom2);
                if (bl10 || bl2) {
                    f5 = atom.distance(atom2);
                    f6 = atom.getBondingRadiusFloat() + atom2.getBondingRadiusFloat();
                }
                if ((!bl10 ? f7 < f3 : f5 < f6 * f) || (!bl2 ? f7 > f4 : f5 > f6 * f2)) continue;
                if (bond != null) {
                    if (!bl6 && !bl3) {
                        bond.setOrder(n);
                        this.bsAromatic.clear(bond.index);
                    }
                    if (bl6 && !bl3 && n != bond.order && s2 != bond.order && (!bl4 || !bond.isHydrogen())) continue;
                    bitSet3.set(bond.index);
                    ++n4;
                    continue;
                }
                bitSet3.set(this.bondAtoms((Atom)atom, (Atom)atom2, (int)n, (short)s, (BitSet)bitSet3).index);
                ++n3;
            }
            n6 = bitSet.nextSetBit(n6 + 1);
        }
        if (bl9) {
            this.assignAromaticBonds(true, bitSet3);
        }
        if (!bl6) {
            ((ModelSet)this).setShapeSize(1, Integer.MIN_VALUE, null, bitSet3);
        }
        return new int[]{n3, n4};
    }

    /*
     * Enabled aggressive block sorting
     */
    public int autoBond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        BitSet bitSet5;
        int n;
        boolean bl;
        if (this.atomCount == 0) {
            return 0;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.viewer.getBondTolerance();
        float f2 = this.viewer.getMinBondDistance();
        float f3 = f2 * f2;
        short s = this.viewer.getMadBond();
        int n2 = 0;
        this.initializeBspf();
        if (Logger.debugging) {
            Logger.startTimer();
        }
        short s2 = -1;
        boolean bl2 = bl = bitSet == null;
        if (bl) {
            n = 0;
            bitSet5 = null;
        } else {
            if (bitSet.equals(bitSet2)) {
                bitSet5 = bitSet;
            } else {
                bitSet5 = BitSetUtil.copy(bitSet);
                bitSet5.or(bitSet2);
            }
            n = bitSet5.nextSetBit(0);
        }
        CubeIterator cubeIterator = null;
        int n3 = n;
        while (true) {
            block11: {
                boolean bl3;
                float f4;
                Atom atom;
                boolean bl4;
                boolean bl5;
                block14: {
                    block10: {
                        block12: {
                            short s3;
                            block13: {
                                if (n3 < 0 || n3 >= this.atomCount) break block10;
                                bl5 = bl || bitSet.get(n3);
                                bl4 = bl || bitSet2.get(n3);
                                atom = this.atoms[n3];
                                if (atom.isDeleted()) break block11;
                                s3 = atom.modelIndex;
                                if (s3 == s2) break block12;
                                s2 = s3;
                                if (!this.isJmolDataFrame(s3)) break block13;
                                n3 = this.models[s3].firstAtomIndex + this.models[s3].atomCount - 1;
                                break block11;
                            }
                            this.initializeBspt(s3);
                            cubeIterator = this.bspf.getCubeIterator(s3);
                        }
                        if ((f4 = atom.getBondingRadiusFloat()) == 0.0f) break block11;
                        bl3 = bitSet3 != null && bitSet3.get(n3);
                        float f5 = f4 + this.maxBondingRadius + f;
                        cubeIterator.initializeHemisphere(atom, f5);
                        break block14;
                    }
                    if (Logger.debugging) {
                        Logger.checkTimer("Time to autoBond");
                    }
                    return n2;
                }
                while (cubeIterator.hasMoreElements()) {
                    short s4;
                    boolean bl6;
                    Atom atom2 = (Atom)cubeIterator.nextElement();
                    if (atom2 == atom || atom2.isDeleted()) continue;
                    int n4 = atom2.index;
                    boolean bl7 = bl || bitSet.get(n4);
                    boolean bl8 = bl6 = bl || bitSet2.get(n4);
                    if (!bl7 && !bl6 || (!bl5 || !bl6) && (!bl4 || !bl7) || bl3 && bitSet3.get(n4) || (s4 = this.getBondOrder(atom, f4, atom2, atom2.getBondingRadiusFloat(), cubeIterator.foundDistance2(), f3, f)) <= 0 || !this.checkValencesAndBond(atom, atom2, s4, s, bitSet4)) continue;
                    ++n2;
                }
                cubeIterator.release();
            }
            n3 = bl ? n3 + 1 : bitSet5.nextSetBit(n3 + 1);
        }
    }

    private int[] autoBond(int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, boolean bl2) {
        if (bl) {
            BitSet bitSet4 = bitSet;
            bitSet = new BitSet();
            bitSet2 = new BitSet();
            int n2 = bitSet4.nextSetBit(0);
            while (n2 >= 0) {
                bitSet.set(this.bonds[n2].atom1.index);
                bitSet2.set(this.bonds[n2].atom2.index);
                n2 = bitSet4.nextSetBit(n2 + 1);
            }
        }
        if (bl2) {
            this.initializeBspf();
            return new int[]{this.autoHbond(bitSet, bitSet2, bitSet3, 0.0f, 0.0f), 0};
        }
        return new int[]{this.autoBond(bitSet, bitSet2, null, bitSet3), 0};
    }

    private static boolean checkMinAttachedAngle(Atom atom, Atom atom2, float f, Vector3f vector3f, Vector3f vector3f2) {
        vector3f.sub(atom, atom2);
        return ModelCollection.checkMinAttachedAngle(atom, atom.getBonds(), atom2, f, vector3f, vector3f2) && ModelCollection.checkMinAttachedAngle(atom2, atom2.getBonds(), atom, f, vector3f, vector3f2);
    }

    private static boolean checkMinAttachedAngle(Atom atom, Bond[] bondArray, Atom atom2, float f, Vector3f vector3f, Vector3f vector3f2) {
        if (bondArray != null) {
            int n = bondArray.length;
            while (--n >= 0) {
                if (!bondArray[n].isCovalent()) continue;
                vector3f2.sub(atom, bondArray[n].getOtherAtom(atom));
                if (!(vector3f2.angle(vector3f) < f)) continue;
                return false;
            }
        }
        vector3f.scale(-1.0f);
        return true;
    }

    protected int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, float f, float f2) {
        if (f <= 0.0f) {
            f = defaultHbondMax;
        }
        float f3 = f * f;
        float f4 = hbondMin * hbondMin;
        int n = 0;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        if (Logger.debugging) {
            Logger.startTimer();
        }
        short s = -1;
        BitSet bitSet4 = new BitSet();
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (this.atoms[n2].getSpecialAtomID() != 4) continue;
            bitSet4.set(n2);
        }
        n2 = this.atomCount;
        while (--n2 >= 0) {
            Atom atom = this.atoms[n2];
            short s2 = atom.getElementNumber();
            if (s2 != 7 && s2 != 8) continue;
            boolean bl = bitSet4.get(n2);
            if (atom.modelIndex != s) {
                s = atom.modelIndex;
                this.initializeBspt(s);
            }
            CubeIterator cubeIterator = this.bspf.getCubeIterator(atom.modelIndex);
            cubeIterator.initializeHemisphere(atom, f);
            while (cubeIterator.hasMoreElements()) {
                Atom atom2 = (Atom)cubeIterator.nextElement();
                short s3 = atom2.getElementNumber();
                if (s3 != 7 && s3 != 8 || atom2 == atom || cubeIterator.foundDistance2() < f4 || cubeIterator.foundDistance2() > f3 || atom.isBonded(atom2) || bl && bitSet4.get(atom2.index) || f2 > 0.0f && !ModelCollection.checkMinAttachedAngle(atom, atom2, f2, vector3f, vector3f2)) continue;
                this.getOrAddBond(atom, atom2, 2048, (short)1, this.bsPseudoHBonds);
                ++n;
            }
            cubeIterator.release();
        }
        ((ModelSet)this).setShapeSize(1, Integer.MIN_VALUE, null, this.bsPseudoHBonds);
        if (Logger.debugging) {
            Logger.checkTimer("Time to hbond");
        }
        return n;
    }

    void setStructureIds() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            int n5;
            int n6 = this.atoms[i].modelIndex;
            n3 = n6;
            if (n6 != n4) {
                n = 0;
                n4 = n3;
                n2 = -1;
            }
            if ((n5 = this.atoms[i].getStrucNo()) == n2 || n5 == 0) continue;
            this.atoms[i].getGroup().setProteinStructureId(++n);
            n2 = n;
        }
    }

    public String getProteinStructureState(BitSet bitSet, boolean bl, boolean bl2, boolean bl3) {
        int n;
        BitSet bitSet2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        BitSet bitSet3 = null;
        if (bl) {
            if (!this.proteinStructureTainted) {
                return "";
            }
            bitSet3 = new BitSet();
            for (n = 0; n < this.atomCount; ++n) {
                if (!this.models[this.atoms[n].modelIndex].isStructureTainted()) continue;
                bitSet3.set(n);
            }
            bitSet3.set(this.atomCount);
        }
        for (n = 0; n <= this.atomCount; ++n) {
            char c;
            if (n != this.atomCount && bitSet != null && !bitSet.get(n) || bl && !bitSet3.get(n)) continue;
            n3 = 0;
            if (n == this.atomCount || (n3 = this.atoms[n].getStrucNo()) != n5) {
                if (bitSet2 != null) {
                    if (n2 == 3 || n2 == 1 || n2 == 2) {
                        ++n8;
                        if (bitSet == null) {
                            c = this.atoms[n4].modelIndex;
                            stringBuffer.append("  structure ").append(JmolConstants.getProteinStructureName(n2)).append(" ").append(Escape.escape(bitSet2)).append("    \t# model=").append(this.getModelNumberDotted(c)).append(" & (").append(n6).append(" - ").append(n7).append(");\n");
                        } else {
                            StringBuffer stringBuffer5;
                            String string6;
                            switch (n2) {
                                case 3: {
                                    int n12 = ++n9;
                                    if (string == null || bl3) {
                                        string = TextFormat.formatString("%3N %3N", "N", n12);
                                    }
                                    string6 = "HELIX  %ID %3GROUPA %1CA %4RESA  %3GROUPB %1CB %4RESB";
                                    stringBuffer5 = stringBuffer3;
                                    break;
                                }
                                case 2: {
                                    int n12 = ++n11;
                                    if (string == null || bl3) {
                                        string = TextFormat.formatString("%3N %3A 0", "N", n12);
                                        string = TextFormat.formatString(string, "A", "S" + n12);
                                    }
                                    string6 = "SHEET  %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                    stringBuffer5 = stringBuffer4;
                                    break;
                                }
                                default: {
                                    int n12 = ++n10;
                                    if (string == null || bl3) {
                                        string = TextFormat.formatString("%3N %3N", "N", n12);
                                    }
                                    string6 = "TURN   %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                                    stringBuffer5 = stringBuffer2;
                                }
                            }
                            string6 = TextFormat.formatString(string6, "ID", string);
                            string6 = TextFormat.formatString(string6, "GROUPA", string2);
                            string6 = TextFormat.formatString(string6, "CA", string4);
                            string6 = TextFormat.formatString(string6, "RESA", n6);
                            string6 = TextFormat.formatString(string6, "GROUPB", string3);
                            string6 = TextFormat.formatString(string6, "CB", string5);
                            string6 = TextFormat.formatString(string6, "RESB", n7);
                            stringBuffer5.append(string6);
                            if (!bl3) {
                                stringBuffer5.append(" strucno= ").append(n5);
                            }
                            stringBuffer5.append("\n");
                        }
                    }
                    bitSet2 = null;
                }
                if (n3 == 0 || bitSet != null && bl2 && (Float.isNaN(this.atoms[n].getGroupPhi()) || Float.isNaN(this.atoms[n].getGroupPsi()))) continue;
            }
            if ((c = this.atoms[n].getChainID()) == '\u0000') {
                c = ' ';
            }
            if (bitSet2 == null) {
                bitSet2 = new BitSet();
                n6 = this.atoms[n].getResno();
                string2 = this.atoms[n].getGroup3(false);
                string4 = "" + c;
            }
            n2 = this.atoms[n].getProteinStructureType();
            string = this.atoms[n].getProteinStructureTag();
            bitSet2.set(n);
            n5 = n3;
            n7 = this.atoms[n].getResno();
            string3 = this.atoms[n].getGroup3(false);
            string5 = "" + c;
            n4 = n;
        }
        if (n8 > 0) {
            stringBuffer.append("\n");
        }
        return bitSet == null ? stringBuffer.toString() : stringBuffer3.append(stringBuffer4).append(stringBuffer2).append(stringBuffer).toString();
    }

    public String getModelInfoAsString() {
        StringBuffer stringBuffer = new StringBuffer("model count = ");
        stringBuffer.append(this.modelCount).append("\nmodelSetHasVibrationVectors:").append(this.modelSetHasVibrationVectors());
        if (this.modelSetProperties == null) {
            stringBuffer.append("\nProperties: null");
        } else {
            Enumeration<?> enumeration = this.modelSetProperties.propertyNames();
            stringBuffer.append("\nProperties:");
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append("\n ").append(string).append("=").append(this.modelSetProperties.getProperty(string));
            }
        }
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append("\n").append(i).append(":").append(this.getModelNumberDotted(i)).append(":").append(this.getModelName(i)).append(":").append(this.getModelTitle(i)).append("\nmodelHasVibrationVectors:").append(this.modelHasVibrationVectors(i));
        }
        return stringBuffer.toString();
    }

    public String getSymmetryInfoAsString() {
        StringBuffer stringBuffer = new StringBuffer("Symmetry Information:");
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append("\nmodel #").append(this.getModelNumberDotted(i)).append("; name=").append(this.getModelName(i)).append("\n").append(this.getSymmetryInfoAsString(i));
        }
        return stringBuffer.toString();
    }

    public BitSet getAtomsConnected(float f, float f2, int n, BitSet bitSet) {
        int n2;
        int n3;
        BitSet bitSet2 = new BitSet();
        int[] nArray = new int[this.atomCount];
        boolean bl = n == 30720;
        boolean bl2 = n == 65535;
        for (n3 = 0; n3 < this.bondCount; ++n3) {
            Bond bond = this.bonds[n3];
            if (!bl2 && !bond.is(n) && (!bl || !bond.isHydrogen())) continue;
            if (bitSet.get(bond.atom1.index)) {
                n2 = bond.atom2.index;
                nArray[n2] = nArray[n2] + 1;
                bitSet2.set(n2);
            }
            if (!bitSet.get(bond.atom2.index)) continue;
            n2 = bond.atom1.index;
            nArray[n2] = nArray[n2] + 1;
            bitSet2.set(n2);
        }
        n3 = f == 0.0f ? 1 : 0;
        n2 = this.atomCount;
        while (--n2 >= 0) {
            int n4 = nArray[n2];
            if ((float)n4 < f || (float)n4 > f2) {
                bitSet2.clear(n2);
                continue;
            }
            if (n3 == 0 || n4 != 0) continue;
            bitSet2.set(n2);
        }
        return bitSet2;
    }

    public String getModelExtract(BitSet bitSet) {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[this.atomCount];
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            nArray[n3] = ++n;
            this.getAtomRecordMOL(stringBuffer2, n3);
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        for (n3 = 0; n3 < this.bondCount; ++n3) {
            Bond bond = this.bonds[n3];
            if (!bitSet.get(bond.atom1.index) || !bitSet.get(bond.atom2.index) || bond.isHydrogen()) continue;
            this.getBondRecordMOL(stringBuffer2, n3, nArray);
            ++n2;
        }
        if (n > 999 || n2 > 999) {
            Logger.error("ModelManager.java::getModel: ERROR atom/bond overflow");
            return "";
        }
        TextFormat.rFill(stringBuffer, "   ", "" + n);
        TextFormat.rFill(stringBuffer, "   ", "" + n2);
        stringBuffer.append("  0  0  0\n");
        stringBuffer.append(stringBuffer2);
        return stringBuffer.toString();
    }

    private void getAtomRecordMOL(StringBuffer stringBuffer, int n) {
        TextFormat.rFill(stringBuffer, "          ", TextFormat.safeTruncate(this.getAtomX(n), 9));
        TextFormat.rFill(stringBuffer, "          ", TextFormat.safeTruncate(this.getAtomY(n), 9));
        TextFormat.rFill(stringBuffer, "          ", TextFormat.safeTruncate(this.getAtomZ(n), 9));
        stringBuffer.append(" ").append((this.getElementSymbol(n) + "  ").substring(0, 2)).append("\n");
    }

    private void getBondRecordMOL(StringBuffer stringBuffer, int n, int[] nArray) {
        Bond bond = this.bonds[n];
        TextFormat.rFill(stringBuffer, "   ", "" + nArray[bond.atom1.index]);
        TextFormat.rFill(stringBuffer, "   ", "" + nArray[bond.atom2.index]);
        int n2 = bond.getValence();
        if (n2 > 3) {
            n2 = 1;
        }
        switch (bond.order & 0xFFFDFFFF) {
            case 515: {
                n2 = 4;
                break;
            }
            case 66: {
                n2 = 5;
                break;
            }
            case 513: {
                n2 = 6;
                break;
            }
            case 514: {
                n2 = 7;
            }
        }
        stringBuffer.append("  ").append(n2).append("\n");
    }

    public String getChimeInfo(int n, BitSet bitSet) {
        int n2;
        if (n != 1073741911) {
            return super.getChimeInfo(n, bitSet);
        }
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        if (this.models[0].isPDB) {
            stringBuffer.append("\nMolecule name ....... " + this.getModelSetAuxiliaryInfo("COMPND"));
            stringBuffer.append("\nSecondary Structure . PDB Data Records");
            stringBuffer.append("\nBrookhaven Code ..... " + this.modelSetName);
            n2 = this.modelCount;
            while (--n2 >= 0) {
                n3 += this.models[n2].getChainCount(false);
            }
            stringBuffer.append("\nNumber of Chains .... " + n3);
            n3 = 0;
            n2 = this.modelCount;
            while (--n2 >= 0) {
                n3 += this.models[n2].getGroupCount(false);
            }
            n4 = 0;
            n2 = this.modelCount;
            while (--n2 >= 0) {
                n4 += this.models[n2].getGroupCount(true);
            }
            stringBuffer.append("\nNumber of Groups .... " + n3);
            if (n4 > 0) {
                stringBuffer.append(" (" + n4 + ")");
            }
            n2 = this.atomCount;
            while (--n2 >= 0) {
                if (!this.atoms[n2].isHetero()) continue;
                ++n4;
            }
        }
        stringBuffer.append("\nNumber of Atoms ..... " + (this.atomCount - n4));
        if (n4 > 0) {
            stringBuffer.append(" (" + n4 + ")");
        }
        stringBuffer.append("\nNumber of Bonds ..... " + this.bondCount);
        stringBuffer.append("\nNumber of Models ...... " + this.modelCount);
        if (this.models[0].isPDB) {
            n2 = 0;
            int n5 = 0;
            int n6 = 0;
            if (this.structures != null) {
                int n7 = this.structureCount;
                while (--n7 >= 0) {
                    switch (this.structures[n7].type) {
                        case 3: {
                            ++n2;
                            break;
                        }
                        case 2: {
                            ++n5;
                            break;
                        }
                        case 1: {
                            ++n6;
                        }
                    }
                }
            }
            stringBuffer.append("\nNumber of Helices ... " + n2);
            stringBuffer.append("\nNumber of Strands ... " + n5);
            stringBuffer.append("\nNumber of Turns ..... " + n6);
        }
        return stringBuffer.append('\n').toString().substring(1);
    }

    public String getModelFileInfo(BitSet bitSet) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            String string = this.getModelNumberDotted(i);
            stringBuffer.append("\n\nfile[\"").append(string).append("\"] = ").append(Escape.escape(this.getModelFileName(i))).append("\ntitle[\"").append(string).append("\"] = ").append(Escape.escape(this.getModelTitle(i))).append("\nname[\"").append(string).append("\"] = ").append(Escape.escape(this.getModelName(i)));
        }
        return stringBuffer.toString();
    }

    public Hashtable getAuxiliaryInfo(BitSet bitSet) {
        Hashtable hashtable = this.getModelSetAuxiliaryInfo();
        if (hashtable == null) {
            return hashtable;
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.modelCount; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            Hashtable hashtable2 = this.getModelAuxiliaryInfo(i);
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public Vector getAllAtomInfo(BitSet bitSet) {
        Vector<Hashtable> vector = new Vector<Hashtable>();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            vector.addElement(this.getAtomInfoLong(n));
            n = bitSet.nextSetBit(n + 1);
        }
        return vector;
    }

    public void getAtomIdentityInfo(int n, Hashtable hashtable) {
        hashtable.put("_ipt", new Integer(n));
        hashtable.put("atomIndex", new Integer(n));
        hashtable.put("atomno", new Integer(this.getAtomNumber(n)));
        hashtable.put("info", this.getAtomInfo(n, null));
        hashtable.put("sym", this.getElementSymbol(n));
    }

    private Hashtable getAtomInfoLong(int n) {
        Atom atom = this.atoms[n];
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        this.getAtomIdentityInfo(n, hashtable);
        hashtable.put("element", this.getElementName(n));
        hashtable.put("elemno", new Integer(this.getElementNumber(n)));
        hashtable.put("x", new Float(this.getAtomX(n)));
        hashtable.put("y", new Float(this.getAtomY(n)));
        hashtable.put("z", new Float(this.getAtomZ(n)));
        hashtable.put("coord", new Point3f(atom));
        if (this.vibrationVectors != null && this.vibrationVectors[n] != null) {
            hashtable.put("vibVector", new Vector3f(this.vibrationVectors[n]));
        }
        hashtable.put("bondCount", new Integer(atom.getCovalentBondCount()));
        hashtable.put("radius", new Float((double)atom.getRasMolRadius() / 120.0));
        hashtable.put("model", atom.getModelNumberForLabel());
        hashtable.put("visible", this.atoms[n].isVisible(0));
        hashtable.put("clickabilityFlags", new Integer(atom.clickabilityFlags));
        hashtable.put("visibilityFlags", new Integer(atom.shapeVisibilityFlags));
        hashtable.put("spacefill", new Float(atom.getRadius()));
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(atom.colixAtom));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", new Integer(atom.colixAtom));
        boolean bl = atom.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        hashtable.put("formalCharge", new Integer(atom.getFormalCharge()));
        hashtable.put("partialCharge", new Float(atom.getPartialCharge()));
        float f = (float)atom.getSurfaceDistance100() / 100.0f;
        if (f >= 0.0f) {
            hashtable.put("surfaceDistance", new Float(f));
        }
        if (this.models[atom.modelIndex].isPDB) {
            hashtable.put("resname", atom.getGroup3(false));
            int n2 = atom.getSeqNumber();
            char c = atom.getInsertionCode();
            if (n2 > 0) {
                hashtable.put("resno", new Integer(n2));
            }
            if (c != '\u0000') {
                hashtable.put("insertionCode", "" + c);
            }
            char c2 = atom.getChainID();
            hashtable.put("name", this.getAtomName(n));
            hashtable.put("chain", c2 == '\u0000' ? "" : "" + c2);
            hashtable.put("atomID", new Integer(atom.getSpecialAtomID()));
            hashtable.put("groupID", new Integer(atom.getGroupID()));
            if (atom.alternateLocationID != '\u0000') {
                hashtable.put("altLocation", "" + atom.alternateLocationID);
            }
            hashtable.put("structure", new Integer(atom.getProteinStructureType()));
            hashtable.put("polymerLength", new Integer(atom.getPolymerLength()));
            hashtable.put("occupancy", new Integer(atom.getOccupancy100()));
            int n3 = atom.getBfactor100();
            hashtable.put("temp", new Integer(n3 / 100));
        }
        return hashtable;
    }

    public Vector getAllBondInfo(BitSet bitSet) {
        Vector<Hashtable> vector = new Vector<Hashtable>();
        int n = bitSet.cardinality() == 1 ? bitSet.nextSetBit(0) : -1;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!(n >= 0 ? this.bonds[i].atom1.index == n || this.bonds[i].atom2.index == n : bitSet.get(this.bonds[i].atom1.index) && bitSet.get(this.bonds[i].atom2.index))) continue;
            vector.addElement(this.getBondInfo(i));
        }
        return vector;
    }

    private Hashtable getBondInfo(int n) {
        Bond bond = this.bonds[n];
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("_bpt", new Integer(n));
        Hashtable hashtable2 = new Hashtable();
        this.getAtomIdentityInfo(atom.index, hashtable2);
        Hashtable hashtable3 = new Hashtable();
        this.getAtomIdentityInfo(atom2.index, hashtable3);
        hashtable.put("atom1", hashtable2);
        hashtable.put("atom2", hashtable3);
        hashtable.put("order", new Float(JmolConstants.getBondOrderNumberFromOrder(this.bonds[n].order)));
        hashtable.put("radius", new Float((double)bond.mad / 2000.0));
        hashtable.put("length_Ang", new Float(atom.distance(atom2)));
        hashtable.put("visible", bond.shapeVisibilityFlags != 0);
        String string = Escape.escapeColor(this.viewer.getColorArgbOrGray(bond.colix));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", new Integer(bond.colix));
        boolean bl = bond.isTranslucent();
        if (bl) {
            hashtable.put("translucent", bl);
        }
        return hashtable;
    }

    public Hashtable getAllChainInfo(BitSet bitSet) {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            Vector vector2 = this.getChainInfo(i, bitSet);
            if (vector2.size() <= 0) continue;
            hashtable2.put("modelIndex", new Integer(i));
            hashtable2.put("chains", vector2);
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    private Vector getChainInfo(int n, BitSet bitSet) {
        Model model = this.models[n];
        int n2 = model.getChainCount(true);
        Vector vector = new Vector();
        for (int i = 0; i < n2; ++i) {
            Chain chain = model.getChain(i);
            Vector vector2 = new Vector();
            int n3 = chain.getGroupCount();
            Hashtable hashtable = new Hashtable();
            for (int j = 0; j < n3; ++j) {
                Group group = chain.getGroup(j);
                if (!bitSet.get(group.firstAtomIndex)) continue;
                Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                hashtable2.put("groupIndex", new Integer(j));
                hashtable2.put("groupID", new Short(group.getGroupID()));
                String string = group.getSeqcodeString();
                if (string != null) {
                    hashtable2.put("seqCode", string);
                }
                hashtable2.put("_apt1", new Integer(group.firstAtomIndex));
                hashtable2.put("_apt2", new Integer(group.lastAtomIndex));
                hashtable2.put("atomInfo1", this.getAtomInfo(group.firstAtomIndex, null));
                hashtable2.put("atomInfo2", this.getAtomInfo(group.lastAtomIndex, null));
                hashtable2.put("visibilityFlags", new Integer(group.shapeVisibilityFlags));
                vector2.addElement(hashtable2);
            }
            if (vector2.isEmpty()) continue;
            hashtable.put("residues", vector2);
            vector.addElement(hashtable);
        }
        return vector;
    }

    public Hashtable getAllPolymerInfo(BitSet bitSet) {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        for (int i = 0; i < this.modelCount; ++i) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            Vector<Hashtable> vector2 = new Vector<Hashtable>();
            int n = this.models[i].getBioPolymerCount();
            for (int j = 0; j < n; ++j) {
                Hashtable hashtable3 = this.models[i].getBioPolymer(j).getPolymerInfo(bitSet);
                if (hashtable3.isEmpty()) continue;
                vector2.addElement(hashtable3);
            }
            if (vector2.size() <= 0) continue;
            hashtable2.put("modelIndex", new Integer(i));
            hashtable2.put("polymers", vector2);
            vector.addElement(hashtable2);
        }
        hashtable.put("models", vector);
        return hashtable;
    }

    public String getUnitCellInfoText() {
        int n = this.viewer.getCurrentModelIndex();
        if (n < 0) {
            return "no single current model";
        }
        if (this.unitCells == null) {
            return "not applicable";
        }
        return this.unitCells[n].getUnitCellInfo();
    }

    public Hashtable getSpaceGroupInfo(int n, String string, int n2, Point3f point3f, Point3f point3f2, String string2) {
        Object object;
        String string3 = null;
        Hashtable hashtable = null;
        SymmetryInterface symmetryInterface = null;
        Object[][] objectArray = null;
        if (string == null) {
            if (n <= 0) {
                n = this.viewer.getCurrentModelIndex();
            }
            if (n < 0) {
                string3 = "no single current model";
            } else if (this.unitCells == null || this.unitCells[n] == null) {
                string3 = "not applicable";
            }
            if (string3 != null) {
                hashtable = new Hashtable();
                hashtable.put("spaceGroupInfo", string3);
                hashtable.put("symmetryInfo", "");
                return hashtable;
            }
            if (point3f == null && string2 == null && n2 != 0) {
                hashtable = (Hashtable)this.getModelAuxiliaryInfo(n, "spaceGroupInfo");
            }
            if (hashtable != null) {
                return hashtable;
            }
            hashtable = new Hashtable();
            if (point3f == null && string2 == null) {
                this.setModelAuxiliaryInfo(n, "spaceGroupInfo", hashtable);
            }
            symmetryInterface = this.unitCells[n];
            string = symmetryInterface.getSpaceGroupName();
            object = this.unitCells[n].getSymmetryOperations();
            if (object == null) {
                string3 = "\n no symmetry operations employed";
            } else {
                this.getSymTemp(true);
                this.symTemp.setSpaceGroup(false);
                string3 = "\n" + ((String[])object).length + " symmetry operations employed:";
                objectArray = new Object[((String[])object).length][];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    int n3 = this.symTemp.addSpaceGroupOperation("=" + object[i], i + 1);
                    if (n3 < 0) continue;
                    Object[] objectArray2 = objectArray[i] = n2 > 0 && n2 - 1 != n3 ? null : this.symTemp.getSymmetryOperationDescription(n3, symmetryInterface, point3f, point3f2, string2);
                    if (objectArray[i] == null) continue;
                    string3 = string3 + "\n" + (i + 1) + "\t" + objectArray[i][0] + "\t" + objectArray[i][2];
                }
            }
        } else {
            hashtable = new Hashtable();
        }
        hashtable.put("spaceGroupName", string);
        this.getSymTemp(true);
        object = this.symTemp.getSpaceGroupInfo(string, symmetryInterface);
        if (objectArray != null) {
            hashtable.put("operations", objectArray);
            hashtable.put("symmetryInfo", string3);
        }
        if (object == null) {
            object = "could not identify space group from name: " + string + "\nformat: show spacegroup \"2\" or \"P 2c\" " + "or \"C m m m\" or \"x, y, z;-x ,-y, -z\"";
        }
        hashtable.put("spaceGroupInfo", object);
        return hashtable;
    }

    public Object getSymmetryInfo(BitSet bitSet, String string, int n, Point3f point3f, Point3f point3f2, String string2, int n2) {
        int n3;
        int n4 = -1;
        if (bitSet == null) {
            n4 = this.viewer.getCurrentModelIndex();
            if (n4 < 0) {
                return "";
            }
            bitSet = this.getModelAtomBitSet(n4, false);
        }
        if ((n3 = bitSet.nextSetBit(0)) < 0) {
            return "";
        }
        n4 = this.atoms[n3].modelIndex;
        SymmetryInterface symmetryInterface = this.getUnitCell(n4);
        if (symmetryInterface == null) {
            return "";
        }
        if (point3f2 != null) {
            return this.getSymmetryOperation(n4, null, n, point3f, point3f2, string2 == null ? "sym" : string2);
        }
        if (string == null) {
            String[] stringArray = symmetryInterface.getSymmetryOperations();
            if (stringArray == null || n == 0 || Math.abs(n) > stringArray.length) {
                return "";
            }
            string = n > 0 ? stringArray[n - 1] : stringArray[-1 - n];
        } else {
            n = 0;
        }
        this.getSymTemp(false);
        this.symTemp.setSpaceGroup(false);
        int n5 = this.symTemp.addSpaceGroupOperation((n < 0 ? "!" : "=") + string, Math.abs(n));
        if (n5 < 0) {
            return "";
        }
        this.symTemp.setUnitCell(symmetryInterface.getNotionalUnitCell());
        point3f = new Point3f(point3f == null ? this.atoms[n3] : point3f);
        if (n2 == 135266314) {
            symmetryInterface.toFractional(point3f);
            if (Float.isNaN(point3f.x)) {
                return "";
            }
            Point3f point3f3 = new Point3f();
            this.symTemp.newSpaceGroupPoint(n5, point3f, point3f3, 0, 0, 0);
            this.symTemp.toCartesian(point3f3);
            return point3f3;
        }
        Object[] objectArray = this.symTemp.getSymmetryOperationDescription(n5, symmetryInterface, point3f, point3f2, string2 == null ? "sym" : string2);
        int n6 = (Integer)objectArray[9];
        switch (n2) {
            case 0x8100001: {
                return objectArray;
            }
            case 6: {
                String[] stringArray = new String[]{(String)objectArray[0], (String)objectArray[1], (String)objectArray[2], Escape.escape((Vector3f)objectArray[4]), Escape.escape((Vector3f)objectArray[5]), Escape.escape((Point3f)objectArray[6]), Escape.escape((Point3f)objectArray[7]), Escape.escape((Vector3f)objectArray[8]), "" + objectArray[9], "" + Escape.escape((Matrix4f)objectArray[10])};
                return stringArray;
            }
            case 1073741911: {
                return objectArray[0];
            }
            default: {
                return objectArray[2];
            }
            case 135184: {
                return objectArray[3];
            }
            case 1073742019: {
                return objectArray[5];
            }
            case 12289: {
                return objectArray[6];
            }
            case 135266314: {
                return objectArray[7];
            }
            case 135266313: 
            case 0x4000000F: {
                return n6 == 0 == (n2 == 135266313) ? (Vector3f)objectArray[8] : null;
            }
            case 135266311: {
                return objectArray[9];
            }
            case 11: 
        }
        return objectArray[10];
    }

    private void getSymTemp(boolean bl) {
        if (this.symTemp == null || bl) {
            this.symTemp = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
    }

    protected void deleteModel(int n, int n2, int n3, BitSet bitSet, BitSet bitSet2) {
        int n4;
        if (n < 0) {
            this.bspf = null;
            this.bsAll = null;
            this.molecules = null;
            this.withinModelIterator = null;
            this.withinAtomSetIterator = null;
            this.isBbcageDefault = false;
            this.calcBoundBoxDimensions(null, 1.0f);
            return;
        }
        this.modelNumbers = (int[])ArrayUtil.deleteElements(this.modelNumbers, n, 1);
        this.modelFileNumbers = (int[])ArrayUtil.deleteElements(this.modelFileNumbers, n, 1);
        this.modelNumbersForAtomLabel = (String[])ArrayUtil.deleteElements(this.modelNumbersForAtomLabel, n, 1);
        this.modelNames = (String[])ArrayUtil.deleteElements(this.modelNames, n, 1);
        this.frameTitles = (String[])ArrayUtil.deleteElements(this.frameTitles, n, 1);
        this.thisStateModel = -1;
        int n5 = 0;
        int n6 = this.structureCount;
        while (--n6 >= 0) {
            if (this.structures[n6].modelIndex > n) {
                --this.structures[n6].modelIndex;
                continue;
            }
            if (this.structures[n6].modelIndex != n) break;
            this.structures = (Structure[])ArrayUtil.deleteElements(this.structures, n6, 1);
            ++n5;
        }
        this.structureCount -= n5;
        String[] stringArray = (String[])this.getModelSetAuxiliaryInfo("group3Lists");
        int[][] nArray = (int[][])this.getModelSetAuxiliaryInfo("group3Counts");
        int n7 = n + 1;
        if (stringArray != null && stringArray[n7] != null) {
            n4 = stringArray[n7].length() / 6;
            while (--n4 >= 0) {
                if (nArray[n7][n4] <= 0) continue;
                int[] nArray2 = nArray[0];
                int n8 = n4;
                nArray2[n8] = nArray2[n8] - nArray[n7][n4];
                if (nArray[0][n4] != 0) continue;
                stringArray[0] = stringArray[0].substring(0, n4 * 6) + ",[" + stringArray[0].substring(n4 * 6 + 2);
            }
        }
        if (stringArray != null) {
            this.modelSetAuxiliaryInfo.put("group3Lists", ArrayUtil.deleteElements(stringArray, n, 1));
            this.modelSetAuxiliaryInfo.put("group3Counts", ArrayUtil.deleteElements(nArray, n, 1));
        }
        if (this.unitCells != null) {
            n4 = this.modelCount;
            while (--n4 > n) {
                this.unitCells[n4].setModelIndex(this.unitCells[n4].getModelIndex() - 1);
            }
            this.unitCells = (SymmetryInterface[])ArrayUtil.deleteElements(this.unitCells, n, 1);
        }
        n4 = this.stateScripts.size();
        while (--n4 >= 0) {
            if (((StateScript)this.stateScripts.get(n4)).deleteAtoms(n, bitSet2, bitSet)) continue;
            this.stateScripts.removeElementAt(n4);
        }
        this.deleteModelAtoms(n2, n3, bitSet);
        this.viewer.deleteModelAtoms(n2, n3, bitSet);
    }

    public String getMoInfo(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            int n2;
            Hashtable hashtable;
            if (n >= 0 && i != n || (hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(i, "moData")) == null) continue;
            Vector vector = (Vector)hashtable.get("mos");
            int n3 = n2 = vector == null ? 0 : vector.size();
            if (n2 == 0) continue;
            int n4 = n2;
            while (--n4 >= 0) {
                String string;
                Float f;
                String string2;
                Hashtable hashtable2 = (Hashtable)vector.get(n4);
                String string3 = (String)hashtable2.get("type");
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = (String)hashtable2.get("energyUnits")) == null) {
                    string2 = "";
                }
                if ((f = (Float)hashtable2.get("occupancy")) != null) {
                    string3 = "occupancy " + f.floatValue() + " " + string3;
                }
                if ((string = (String)hashtable2.get("symmetry")) != null) {
                    string3 = string3 + string;
                }
                stringBuffer.append(TextFormat.sprintf("model %-2s;  mo %-2i # energy %-8.3f %s %s\n", new Object[]{this.getModelNumberDotted(i), new Integer(n4 + 1), hashtable2.get("energy"), string2, string3}));
            }
        }
        return stringBuffer.toString();
    }

    private static class Structure {
        String typeName;
        byte type;
        char startChainID;
        int startSeqcode;
        char endChainID;
        int endSeqcode;
        int modelIndex;
        String structureID;
        int serialID;
        int strandCount;

        Structure(int n, String string, String string2, int n2, int n3, char c, int n4, char c2, int n5) {
            this.modelIndex = n;
            this.typeName = string;
            this.structureID = string2;
            this.strandCount = n3;
            this.serialID = n2;
            this.startChainID = c;
            this.startSeqcode = n4;
            this.endChainID = c2;
            this.endSeqcode = n5;
            this.type = "helix".equals(string) ? (byte)3 : ("sheet".equals(string) ? (byte)2 : ("turn".equals(string) ? (byte)1 : 0));
        }
    }

    public static class StateScript {
        private int modelIndex;
        private BitSet bsBonds;
        private BitSet bsAtoms1;
        private BitSet bsAtoms2;
        private String script1;
        private String script2;
        boolean postDefinitions;

        StateScript(int n, String string, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, String string2, boolean bl) {
            this.modelIndex = n;
            this.script1 = string;
            this.bsBonds = bitSet;
            this.bsAtoms1 = bitSet2;
            this.bsAtoms2 = bitSet3;
            this.script2 = string2;
            this.postDefinitions = bl;
        }

        public boolean isValid() {
            return !(this.script1 == null || this.script1.length() <= 0 || this.bsBonds != null && this.bsBonds.nextSetBit(0) < 0 || this.bsAtoms1 != null && this.bsAtoms1.nextSetBit(0) < 0 || this.bsAtoms2 != null && this.bsAtoms2.nextSetBit(0) < 0);
        }

        public String toString() {
            String string;
            if (!this.isValid()) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.script1);
            if (this.bsBonds != null) {
                stringBuffer.append(" ").append(Escape.escape(this.bsBonds, false));
            }
            if (this.bsAtoms1 != null) {
                stringBuffer.append(" ").append(Escape.escape(this.bsAtoms1));
            }
            if (this.bsAtoms2 != null) {
                stringBuffer.append(" ").append(Escape.escape(this.bsAtoms2));
            }
            if (this.script2 != null) {
                stringBuffer.append(" ").append(this.script2);
            }
            if (!(string = stringBuffer.toString()).endsWith(";")) {
                string = string + ";";
            }
            return string;
        }

        public boolean isConnect() {
            return this.script1.indexOf("connect") == 0;
        }

        public boolean deleteAtoms(int n, BitSet bitSet, BitSet bitSet2) {
            if (n == this.modelIndex) {
                return true;
            }
            if (n < this.modelIndex) {
                return false;
            }
            BitSetUtil.deleteBits(this.bsBonds, bitSet);
            BitSetUtil.deleteBits(this.bsAtoms1, bitSet2);
            BitSetUtil.deleteBits(this.bsAtoms2, bitSet2);
            return this.isValid();
        }

        public void setModelIndex(int n) {
            this.modelIndex = n;
        }
    }
}

