/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Parser;

class ApbsReader
extends VolumeFileReader {
    ApbsReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.isAngstroms = true;
        this.nSurfaces = 1;
    }

    protected void readParameters() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer(this.skipComments(false));
        while (this.line != null && this.line.length() == 0) {
            this.readLine();
        }
        this.jvxlFileHeaderBuffer.append("APBS OpenDx DATA ").append(this.line).append("\n");
        this.jvxlFileHeaderBuffer.append("see http://apbs.sourceforge.net\n");
        String string = this.readLine();
        String[] stringArray = Parser.getTokens(string);
        if (stringArray.length >= 4) {
            this.volumetricOrigin.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
        }
        VolumeFileReader.checkAtomLine(this.isXLowToHigh, this.isAngstroms, stringArray[0], string, this.jvxlFileHeaderBuffer);
        this.readVoxelVector(0);
        this.readVoxelVector(1);
        this.readVoxelVector(2);
        this.readLine();
        stringArray = this.getTokens();
        for (int i = 0; i < 3; ++i) {
            this.voxelCounts[i] = this.parseInt(stringArray[i + 5]);
        }
        this.readLine();
    }
}

