/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.util.xml.XmlWriter;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.dialogs.EditConditionals;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.LineEditDialog;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.structures.Coordinates;

public class PrimitiveLineObject
extends ConstructionObject
implements PointonObject {
    protected double X1;
    protected double Y1;
    protected double DX;
    protected double DY;
    protected PointObject P1;
    PointObject[] Dep;
    int NDep;
    boolean Partial = false;
    double k1;
    double k2;
    boolean k12valid = false;

    public PrimitiveLineObject(Construction construction) {
        super(construction);
        this.setColor(this.ColorIndex);
    }

    public String getTag() {
        return "Line";
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        double d2;
        double d3;
        double d4;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        double d5 = (zirkelCanvas.minX() + zirkelCanvas.maxX()) / 2.0;
        double d6 = (zirkelCanvas.minY() + zirkelCanvas.maxY()) / 2.0;
        double d7 = (d5 - this.X1) * this.DY - (d6 - this.Y1) * this.DX;
        double d8 = d5 - d7 * this.DY;
        double d9 = d6 + d7 * this.DX;
        double d10 = Math.max(zirkelCanvas.maxX() - zirkelCanvas.minX(), zirkelCanvas.maxY() - zirkelCanvas.minY());
        if (Math.abs(d7) > d10) {
            return;
        }
        double d11 = (d8 - this.X1) * this.DX + (d9 - this.Y1) * this.DY;
        this.k1 = d11 - d10;
        this.k2 = d11 + d10;
        this.k12valid = true;
        if (this.Partial && this.Dep != null && !zirkelCanvas.showHidden()) {
            d4 = (zirkelCanvas.maxX() - zirkelCanvas.minX()) / 20.0;
            d3 = -d4;
            d2 = d4;
            if (this.Dep != null) {
                for (int i = 0; i < this.NDep; ++i) {
                    if (!this.Dep[i].valid() || this.Dep[i].mustHide(zirkelCanvas)) continue;
                    double d12 = this.project(this.Dep[i].getX(), this.Dep[i].getY());
                    if (d12 - d4 < d3) {
                        d3 = d12 - d4;
                        continue;
                    }
                    if (!(d12 + d4 > d2)) continue;
                    d2 = d12 + d4;
                }
            }
            if (this.k1 < d3) {
                this.k1 = d3;
            }
            if (this.k2 > d2) {
                this.k2 = d2;
            }
        }
        d4 = zirkelCanvas.col(this.X1 + this.k1 * this.DX);
        d3 = zirkelCanvas.col(this.X1 + this.k2 * this.DX);
        d2 = zirkelCanvas.row(this.Y1 + this.k1 * this.DY);
        double d13 = zirkelCanvas.row(this.Y1 + this.k2 * this.DY);
        if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
            ((MyGraphics13)myGraphics).drawMarkerLine(d4, d2, d3, d13);
        }
        myGraphics.setColor(this);
        myGraphics.drawLine(d4, d2, d3, d13, this);
        String string = this.getDisplayText();
        if (!string.equals("")) {
            myGraphics.setLabelColor(this);
            this.setFont(myGraphics);
            this.DisplaysText = true;
            if (this.KeepClose) {
                double d14 = this.YcOffset < 0.0 ? 1.0 : -1.0;
                this.drawLabel(myGraphics, string, zirkelCanvas, this.X1 + this.XcOffset * this.DX, this.Y1 + this.XcOffset * this.DY, d14 * this.DX, d14 * this.DY, 0.0, 0.0);
            } else {
                this.drawLabel(myGraphics, string, zirkelCanvas, d8 + d10 / 5.0 * this.DX, d9 + d10 / 5.0 * this.DY, this.DX, this.DY, this.XcOffset, this.YcOffset);
            }
        }
    }

    public boolean canKeepClose() {
        return true;
    }

    public void setKeepClose(double d2, double d3) {
        this.KeepClose = true;
        this.XcOffset = (d2 - this.X1) * this.DX + (d3 - this.Y1) * this.DY;
        this.YcOffset = (d2 - this.X1) * this.DY - (d3 - this.Y1) * this.DX;
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        double d2 = zirkelCanvas.x(n);
        double d3 = zirkelCanvas.y(n2);
        double d4 = (d2 - this.X1) * this.DY - (d3 - this.Y1) * this.DX;
        this.Value = Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d4) - zirkelCanvas.col(zirkelCanvas.minX()));
        return this.Value < zirkelCanvas.selectionSize() * 2.0;
    }

    public boolean onlynearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        return false;
    }

    public static Coordinates intersect(PrimitiveLineObject primitiveLineObject, PrimitiveLineObject primitiveLineObject2) {
        double d2 = -primitiveLineObject.DX * primitiveLineObject2.DY + primitiveLineObject.DY * primitiveLineObject2.DX;
        if (Math.abs(d2) < 1.0E-10) {
            return null;
        }
        double d3 = (-(primitiveLineObject2.X1 - primitiveLineObject.X1) * primitiveLineObject2.DY + (primitiveLineObject2.Y1 - primitiveLineObject.Y1) * primitiveLineObject2.DX) / d2;
        return new Coordinates(primitiveLineObject.X1 + d3 * primitiveLineObject.DX, primitiveLineObject.Y1 + d3 * primitiveLineObject.DY);
    }

    public static Coordinates intersect(PrimitiveLineObject primitiveLineObject, PrimitiveCircleObject primitiveCircleObject) {
        double d2 = primitiveCircleObject.getX();
        double d3 = primitiveCircleObject.getY();
        double d4 = primitiveCircleObject.getR();
        double d5 = (d2 - primitiveLineObject.X1) * primitiveLineObject.DY - (d3 - primitiveLineObject.Y1) * primitiveLineObject.DX;
        if (Math.abs(d5) > d4 + 1.0E-10) {
            return null;
        }
        double d6 = d4 * d4 - d5 * d5;
        d6 = d6 > 0.0 ? Math.sqrt(d6) : 0.0;
        return new Coordinates((d2 -= d5 * primitiveLineObject.DY) + d6 * primitiveLineObject.DX, (d3 += d5 * primitiveLineObject.DX) + d6 * primitiveLineObject.DY, d2 - d6 * primitiveLineObject.DX, d3 - d6 * primitiveLineObject.DY);
    }

    public double getDX() {
        return this.DX;
    }

    public double getDY() {
        return this.DY;
    }

    public double getX() {
        return this.X1;
    }

    public double getY() {
        return this.Y1;
    }

    public void edit(ZirkelCanvas zirkelCanvas) {
        LineEditDialog lineEditDialog = new LineEditDialog(zirkelCanvas.getFrame(), this);
        lineEditDialog.setVisible(true);
        zirkelCanvas.getConstruction().updateCircleDep();
        zirkelCanvas.repaint();
        if (lineEditDialog.wantsMore()) {
            new EditConditionals(zirkelCanvas.getFrame(), this);
            this.validate();
        }
    }

    public String getEquation() {
        double d2 = this.DX;
        double d3 = -this.DY;
        double d4 = d2 * this.Y1 + d3 * this.X1;
        if (d4 < 0.0) {
            d4 = -d4;
            d3 = -d3;
            d2 = -d2;
        }
        if (Math.abs(d3) < 1.0E-10 && d2 < 0.0) {
            d4 = -d4;
            d3 = -d3;
            d2 = -d2;
        } else if (Math.abs(d2) < 1.0E-10 && d3 < 0.0) {
            d4 = -d4;
            d3 = -d3;
            d2 = -d2;
        }
        String string = this.helpDisplayValue(true, d3, "x");
        return string + this.helpDisplayValue(string.equals(""), d2, "y") + "=" + (Math.abs(d4) < 1.0E-10 ? "0" : this.helpDisplayNumber(true, d4));
    }

    public boolean contains(double d2, double d3) {
        return true;
    }

    public void printArgs(XmlWriter xmlWriter) {
        if (this.Partial) {
            xmlWriter.printArg("partial", "true");
        }
    }

    public double project(double d2, double d3) {
        return (d2 - this.X1) * this.DX + (d3 - this.Y1) * this.DY;
    }

    public boolean equals(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof PrimitiveLineObject) || !constructionObject.valid()) {
            return false;
        }
        PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)constructionObject;
        return this.equals(this.DX * primitiveLineObject.DY - this.DY * primitiveLineObject.DX, 0.0) && this.equals((this.X1 - primitiveLineObject.X1) * this.DY - (this.Y1 - primitiveLineObject.Y1) * this.DX, 0.0);
    }

    public PointObject getP1() {
        return this.P1;
    }

    public Enumeration points() {
        return this.depending();
    }

    public boolean locallyLike(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof PrimitiveLineObject)) {
            return false;
        }
        return this.equals(this.DX, ((PrimitiveLineObject)constructionObject).DX) && this.equals(this.DY, ((PrimitiveLineObject)constructionObject).DY) || this.equals(-this.DX, ((PrimitiveLineObject)constructionObject).DX) && this.equals(-this.DY, ((PrimitiveLineObject)constructionObject).DY);
    }

    public boolean isPartial() {
        return this.Partial;
    }

    public void setPartial(boolean bl) {
        if (this.Partial == bl) {
            return;
        }
        this.Partial = bl;
        if (bl) {
            this.Dep = new PointObject[16];
            this.NDep = 0;
        } else {
            this.Dep = null;
        }
    }

    public void addDep(PointObject pointObject) {
        if (!this.Partial || this.Dep == null || this.NDep >= this.Dep.length) {
            return;
        }
        this.Dep[this.NDep++] = pointObject;
    }

    public void clearCircleDep() {
        this.NDep = 0;
    }

    public void project(PointObject pointObject) {
        double d2 = this.project(pointObject.getX(), pointObject.getY());
        pointObject.setXY(this.getX() + d2 * this.getDX(), this.getY() + d2 * this.getDY());
        pointObject.setA(d2);
    }

    public void project(PointObject pointObject, double d2) {
        pointObject.setXY(this.getX() + d2 * this.getDX(), this.getY() + d2 * this.getDY());
    }

    public boolean canInteresectWith(ConstructionObject constructionObject) {
        return true;
    }
}

