// -*- coding: utf-8 -*-
//file mendeleiev.c

#include "chemeq.h"
// not i18nalized ?
#define N_(a) a

/* data taken from https://www.nist.gov/system/files/documents/2019/12/10/nist_periodictable_july2019.pdf
NIST SP 966 (July 2019)
« NIST web pages are provided as a public service by the National Institute of Standards and Technology (NIST). 
With the exception of material marked as copyrighted, information presented on NIST sites are considered public 
information and may be distributed or copied. 
Use of appropriate byline/photo/image credits is requested. » 
*/
struct table_entry table [] = {
  {{N_("Hydrogen"), "H", "1", "1.008"}},
  {{N_("Helium"), "He", "2", "4.0026"}},

  {{N_("Lithium"), "Li", "3", "6.940"}},
  {{N_("Beryllium"), "Be", "4", "9.0122"}},
  {{N_("Boron"), "B", "5", "10.810"}},
  {{N_("Carbon"), "C", "6", "12.011"}},
  {{N_("Nitrogen"), "N", "7", "14.007"}},
  {{N_("Oxygen"), "O", "8", "15.999"}},
  {{N_("Fluorine"), "F", "9", "18.998"}},
  {{N_("Neon"), "Ne", "10", "20.180"}},

  {{N_("Sodium"), "Na", "11", "22.990"}},
  {{N_("Magnesium"), "Mg", "12", "24.305"}},
  {{N_("Aluminum"), "Al", "13", "26.982"}},
  {{N_("Silicon"), "Si", "14", "28.085"}},
  {{N_("Phosphorus"), "P", "15", "30.974"}},
  {{N_("Sulfur"), "S", "16", "32.060"}},
  {{N_("Chlorine"), "Cl", "17", "35.450"}},
  {{N_("Argon"), "Ar", "18", "39.948"}},

  {{N_("Potassium"), "K", "19", "39.098"}},
  {{N_("Calcium"), "Ca", "20", "40.078"}},
  {{N_("Scandium"), "Sc", "21", "44.956"}},
  {{N_("Titanium"), "Ti", "22", "47.867"}},
  {{N_("Vanadium"), "V", "23", "50.942"}},
  {{N_("Chromium"), "Cr", "24", "51.996"}},
  {{N_("Manganese"), "Mn", "25", "54.938"}},
  {{N_("Iron"), "Fe", "26", "55.845"}},
  {{N_("Cobalt"), "Co", "27", "58.933"}},
  {{N_("Nickel"), "Ni", "28", "58.693"}},
  {{N_("Copper"), "Cu", "29", "63.546"}},
  {{N_("Zinc"), "Zn", "30", "65.380"}},
  {{N_("Gallium"), "Ga", "31", "69.723"}},
  {{N_("Germanium"), "Ge", "32", "72.630"}},
  {{N_("Arsenic"), "As", "33", "74.922"}},
  {{N_("Selenium"), "Se", "34", "78.971"}},
  {{N_("Bromine"), "Br", "35", "79.904"}},
  {{N_("Krypton"), "Kr", "36", "83.798"}},

  {{N_("Rubidium"), "Rb", "37", "85.468"}},
  {{N_("Strontium"), "Sr", "38", "87.620"}},
  {{N_("Yttrium"), "Y", "39", "88.906"}},
  {{N_("Zirconium"), "Zr", "40", "91.224"}},
  {{N_("Niobium"), "Nb", "41", "92.906"}},
  {{N_("Molybdenum"), "Mo", "42", "95.950"}},
  {{N_("Technetium"), "Tc", "43", "97.000"}},
  {{N_("Ruthenium"), "Ru", "44", "101.070"}},
  {{N_("Rhodium"), "Rh", "45", "102.910"}},
  {{N_("Palladium"), "Pd", "46", "106.420"}},
  {{N_("Silver"), "Ag", "47", "107.870"}},
  {{N_("Cadmium"), "Cd", "48", "112.410"}},
  {{N_("Indium"), "In", "49", "114.820"}},
  {{N_("Tin"), "Sn", "50", "118.710"}},
  {{N_("Antimony"), "Sb", "51", "121.760"}},
  {{N_("Tellurium"), "Te", "52", "127.600"}},
  {{N_("Iodine"), "I", "53", "126.900"}},
  {{N_("Xenon"), "Xe", "54", "131.290"}},

  {{N_("Cesium"), "Cs", "55", "132.910"}},
  {{N_("Barium"), "Ba", "56", "137.330"}},

  {{N_("Lanthanum"), "La", "57", "138.910"}},
  {{N_("Cerium"), "Ce", "58", "140.120"}},
  {{N_("Praseodymium"), "Pr", "59", "140.910"}},
  {{N_("Neodymium"), "Nd", "60", "144.240"}},
  {{N_("Promethium"), "Pm", "61", "145.000"}},
  {{N_("Samarium"), "Sm", "62", "150.360"}},
  {{N_("Europium"), "Eu", "63", "151.960"}},
  {{N_("Gadolinium"), "Gd", "64", "157.250"}},
  {{N_("Terbium"), "Tb", "65", "158.930"}},
  {{N_("Dysprosium"), "Dy", "66", "162.500"}},
  {{N_("Holmium"), "Ho", "67", "164.930"}},
  {{N_("Erbium"), "Er", "68", "167.260"}},
  {{N_("Thulium"), "Tm", "69", "168.930"}},
  {{N_("Ytterbium"), "Yb", "70", "173.050"}},
  {{N_("Lutetium"), "Lu", "71", "174.970"}},

  {{N_("Hafnium"), "Hf", "72", "178.49"}},
  {{N_("Tantalum"), "Ta", "73", "180.95"}},
  {{N_("Tungsten"), "W", "74", "183.84"}},
  {{N_("Rhenium"), "Re", "75", "186.21"}},
  {{N_("Osmium"), "Os", "76", "190.23"}},
  {{N_("Iridium"), "Ir", "77", "192.22"}},
  {{N_("Platinum"), "Pt", "78", "195.08"}},
  {{N_("Gold"), "Au", "79", "196.97"}},
  {{N_("Mercury"), "Hg", "80", "200.59"}},
  {{N_("Thallium"), "Tl", "81", "204.38"}},
  {{N_("Lead"), "Pb", "82", "207.20"}},
  {{N_("Bismuth"), "Bi", "83", "208.98"}},
  {{N_("Polonium"), "Po", "84", "209.00"}},
  {{N_("Astatine"), "At", "85", "210.00"}},
  {{N_("Radon"), "Rn", "86", "222.00"}},

  {{N_("Francium"), "Fr", "87", "223.00"}},
  {{N_("Radium"), "Ra", "88", "226.00"}},

  {{N_("Actinium"), "Ac", "89", "227.000"}},
  {{N_("Thorium"), "Th", "90", "232.040"}},
  {{N_("Protactinium"), "Pa", "91", "231.040"}},
  {{N_("Uranium"), "U", "92", "238.030"}},
  {{N_("Neptunium"), "Np", "93", "237.000"}},
  {{N_("Plutonium"), "Pu", "94", "244.000"}},
  {{N_("Americium"), "Am", "95", "243.000"}},
  {{N_("Curium"), "Cm", "96", "247.000"}},
  {{N_("Berkelium"), "Bk", "97", "247.000"}},
  {{N_("Californium"), "Cf", "98", "251.000"}},
  {{N_("Einsteinium"), "Es", "99", "252.000"}},
  {{N_("Fermium"), "Fm", "100", "257.000"}},
  {{N_("Mendelevium"), "Md", "101", "258.000"}},
  {{N_("Nobelium"), "No", "102", "259.000"}},
  {{N_("Lawrencium"), "Lr", "103", "266.000"}},

  {{N_("Rutherfordium"), "Rf", "104", "267.000"}},
  {{N_("Dubnium"), "Db", "105", "268.000"}},
  {{N_("Seaborgium"), "Sg", "106", "269.000"}},
  {{N_("Bohrium"), "Bh", "107", "270.000"}},
  {{N_("Hassium"), "Hs", "108", "269.000"}},
  {{N_("Meitnerium"), "Mt", "109", "278.000"}},
  {{N_("Darmstadtium"), "Ds", "110", "281.000"}},
  {{N_("Roentgenium"), "Rg", "111", "282.000"}},
  {{N_("Copernicium"), "Cn", "112", "285.000"}},
  {{N_("Nihonium"), "Nh", "113", "286.000"}},
  {{N_("Flerovium"), "Fl", "114", "289.000"}},
  {{N_("Moscovium"), "Mc", "115", "289.000"}},
  {{N_("Livermorium"), "Lv", "116", "293.000"}},
  {{N_("Tennessine"), "Ts", "117", "294.000"}},
  {{N_("Oganesson"), "Og", "118", "294.000"}},
  {{(char *)NULL}}
};
