/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.opensolaris.os.dtrace.AggregationValue;
import org.opensolaris.os.dtrace.Record;
import org.opensolaris.os.dtrace.Tuple;

public final class AggregationRecord
implements Record,
Serializable {
    static final long serialVersionUID = -4367614268579702616L;
    private Tuple tuple;
    private AggregationValue value;
    private int ordinal;

    public AggregationRecord(Tuple tupleKey, AggregationValue recordValue) {
        this.tuple = tupleKey;
        this.value = recordValue;
        this.validate();
    }

    public AggregationRecord(Tuple tupleKey, AggregationValue recordValue, int n) {
        this.tuple = tupleKey;
        this.value = recordValue;
        this.ordinal = n;
        this.validate();
    }

    private final void validate() {
        if (this.tuple == null) {
            throw new NullPointerException("key is null");
        }
        if (this.value == null) {
            throw new NullPointerException("value is null");
        }
        if (this.ordinal < 0) {
            throw new IllegalArgumentException("ordinal is negative");
        }
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public AggregationValue getValue() {
        return this.value;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    void setOrdinal(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("ordinal is negative");
        }
        this.ordinal = n;
    }

    public boolean equals(Object o) {
        if (o instanceof AggregationRecord) {
            AggregationRecord r = (AggregationRecord)o;
            return this.tuple.equals(r.tuple) && this.value.equals(r.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.tuple.hashCode();
        hash = 37 * hash + this.value.hashCode();
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(AggregationRecord.class.getName());
        buf.append("[tuple = ");
        buf.append(this.tuple);
        buf.append(", value = ");
        buf.append(this.value);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(AggregationRecord.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"tuple", "value", "ordinal"}){

                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

