#include <stdio.h>
/* Independent tests for arithmetic instruction from MIPS32 MSA ASE instruction
   set */

unsigned long long data[32] = {
   0x0000000000000000ull, 0x0000000000000000ull,
   0xffffffffffffffffull, 0xffffffffffffffffull,
   0x0000000080000000ull, 0x8000000000000000ull,
   0x8000800080008000ull, 0x7fff7fff7fff7fffull,
   0x8080808080808080ull, 0x8080808080808080ull,
   0x7070707070707070ull, 0x7070707070707070ull,
   0x7f7f7f7f7f7f7f7full, 0x7f7f7f7f7f7f7f7full,
   0x0706050403020100ull, 0x0f0e0d0c0b0a0908ull,
   0x77665544332211ffull, 0xeeddccbbaa998877ull,
   0x0000000000000001ull, 0x00000000000001ffull,
   0x0000000000000001ull, 0x00000000000000ffull,
   0xffffffffffffffffull, 0x0000000000000000ull,
   0x0000000100000001ull, 0x0000000100000001ull,
   0x1234567890abcdefull, 0xfedbca9876543210ull,
   0x0403020114131211ull, 0x2423222134333231ull,
   0x8483828194939291ull, 0xa4a3a2a1b4b3b2b1ull,
};

unsigned long long out[2];

#define TEST_2R(instruction, offset, WD, WS)                           \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD", $"#WS"\n\t"                                 \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS" "#WD":"                          \
          " %016llx%016llx  "#WS": %016llx%016llx\n",                  \
          out[1], out[0], data[offset / 8 + 1], data[offset / 8]);     \
}

#define TEST_3R(instruction, offset1, offset2, WD, WS, WT)             \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset1"($t0)\n\t"                               \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset1"($t0)\n\t"                               \
      "ld.d $"#WT", "#offset2"($t0)\n\t"                               \
      instruction" $"#WD", $"#WS", $"#WT"\n\t"                         \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", $"#WT" "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx  "#WT": "            \
          "%016llx%016llx\n", out[1], out[0], data[offset1 / 8 + 1],   \
          data[offset1 / 8], data[offset2 / 8 + 1], data[offset2 / 8]);\
}

#define TEST_BIT(instruction, offset, WD, WS, n)                       \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD", $"#WS", "#n"\n\t"                           \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", "#n" "#WD":"                    \
          " %016llx%016llx  "#WS": %016llx%016llx\n",                  \
          out[1], out[0], data[offset / 8 + 1], data[offset / 8]);     \
}

#define TEST_I8(instruction, offset, WD, WS, imm)                      \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD", $"#WS", "#imm"\n\t"                         \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", "#imm" "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx\n",                  \
          out[1], out[0], data[offset / 8 + 1], data[offset / 8]);     \
}

int main(int argc, char **argv) {
#if defined(__mips_msa)
   TEST_2R("nloc.b",   0, w0,  w27);
   TEST_2R("nloc.b",   8, w1,  w31);
   TEST_2R("nloc.b",  16, w2,  w10);
   TEST_2R("nloc.b",  24, w3,  w23);
   TEST_2R("nloc.b",  32, w4,  w19);
   TEST_2R("nloc.b",  40, w5,  w23);
   TEST_2R("nloc.b",  48, w6,  w16);
   TEST_2R("nloc.b",  56, w7,  w12);
   TEST_2R("nloc.b",  64, w8,  w14);
   TEST_2R("nloc.b",  72, w9,  w11);
   TEST_2R("nloc.b",  80, w10, w10);
   TEST_2R("nloc.b",  88, w11, w25);
   TEST_2R("nloc.b",  96, w12, w14);
   TEST_2R("nloc.b", 104, w13, w13);
   TEST_2R("nloc.b", 112, w14, w22);
   TEST_2R("nloc.b", 120, w15, w4);
   TEST_2R("nloc.b", 128, w16, w19);
   TEST_2R("nloc.b", 136, w17, w18);
   TEST_2R("nloc.b", 144, w18, w23);
   TEST_2R("nloc.b", 152, w19, w28);
   TEST_2R("nloc.b", 160, w20, w8);
   TEST_2R("nloc.b", 168, w21, w6);
   TEST_2R("nloc.b", 176, w22, w6);
   TEST_2R("nloc.b", 184, w23, w15);
   TEST_2R("nloc.b", 192, w24, w20);
   TEST_2R("nloc.b", 200, w25, w3);
   TEST_2R("nloc.b", 208, w26, w13);
   TEST_2R("nloc.b", 216, w27, w25);
   TEST_2R("nloc.b", 224, w28, w19);
   TEST_2R("nloc.b", 232, w29, w7);
   TEST_2R("nloc.b", 240, w30, w14);
   TEST_2R("nloc.b", 144, w31, w18);
   TEST_2R("nloc.h",   0, w0,  w31);
   TEST_2R("nloc.h",   8, w1,  w7);
   TEST_2R("nloc.h",  16, w2,  w11);
   TEST_2R("nloc.h",  24, w3,  w5);
   TEST_2R("nloc.h",  32, w4,  w19);
   TEST_2R("nloc.h",  40, w5,  w18);
   TEST_2R("nloc.h",  48, w6,  w20);
   TEST_2R("nloc.h",  56, w7,  w14);
   TEST_2R("nloc.h",  64, w8,  w4);
   TEST_2R("nloc.h",  72, w9,  w23);
   TEST_2R("nloc.h",  80, w10, w10);
   TEST_2R("nloc.h",  88, w11, w16);
   TEST_2R("nloc.h",  96, w12, w23);
   TEST_2R("nloc.h", 104, w13, w13);
   TEST_2R("nloc.h", 112, w14, w22);
   TEST_2R("nloc.h", 120, w15, w19);
   TEST_2R("nloc.h", 128, w16, w23);
   TEST_2R("nloc.h", 136, w17, w15);
   TEST_2R("nloc.h", 144, w18, w13);
   TEST_2R("nloc.h", 152, w19, w1);
   TEST_2R("nloc.h", 160, w20, w31);
   TEST_2R("nloc.h", 168, w21, w31);
   TEST_2R("nloc.h", 176, w22, w21);
   TEST_2R("nloc.h", 184, w23, w29);
   TEST_2R("nloc.h", 192, w24, w30);
   TEST_2R("nloc.h", 200, w25, w10);
   TEST_2R("nloc.h", 208, w26, w4);
   TEST_2R("nloc.h", 216, w27, w3);
   TEST_2R("nloc.h", 224, w28, w25);
   TEST_2R("nloc.h", 232, w29, w17);
   TEST_2R("nloc.h", 240, w30, w2);
   TEST_2R("nloc.h", 216, w31, w25);
   TEST_2R("nloc.w",   0, w0,  w7);
   TEST_2R("nloc.w",   8, w1,  w28);
   TEST_2R("nloc.w",  16, w2,  w28);
   TEST_2R("nloc.w",  24, w3,  w16);
   TEST_2R("nloc.w",  32, w4,  w14);
   TEST_2R("nloc.w",  40, w5,  w15);
   TEST_2R("nloc.w",  48, w6,  w30);
   TEST_2R("nloc.w",  56, w7,  w31);
   TEST_2R("nloc.w",  64, w8,  w4);
   TEST_2R("nloc.w",  72, w9,  w11);
   TEST_2R("nloc.w",  80, w10, w10);
   TEST_2R("nloc.w",  88, w11, w21);
   TEST_2R("nloc.w",  96, w12, w15);
   TEST_2R("nloc.w", 104, w13, w13);
   TEST_2R("nloc.w", 112, w14, w12);
   TEST_2R("nloc.w", 120, w15, w16);
   TEST_2R("nloc.w", 128, w16, w18);
   TEST_2R("nloc.w", 136, w17, w22);
   TEST_2R("nloc.w", 144, w18, w19);
   TEST_2R("nloc.w", 152, w19, w13);
   TEST_2R("nloc.w", 160, w20, w17);
   TEST_2R("nloc.w", 168, w21, w7);
   TEST_2R("nloc.w", 176, w22, w7);
   TEST_2R("nloc.w", 184, w23, w14);
   TEST_2R("nloc.w", 192, w24, w14);
   TEST_2R("nloc.w", 200, w25, w10);
   TEST_2R("nloc.w", 208, w26, w9);
   TEST_2R("nloc.w", 216, w27, w26);
   TEST_2R("nloc.w", 224, w28, w5);
   TEST_2R("nloc.w", 232, w29, w7);
   TEST_2R("nloc.w", 240, w30, w1);
   TEST_2R("nloc.w",  40, w31, w1);
   TEST_2R("nloc.d",   0, w0,  w23);
   TEST_2R("nloc.d",   8, w1,  w10);
   TEST_2R("nloc.d",  16, w2,  w14);
   TEST_2R("nloc.d",  24, w3,  w10);
   TEST_2R("nloc.d",  32, w4,  w3);
   TEST_2R("nloc.d",  40, w5,  w25);
   TEST_2R("nloc.d",  48, w6,  w25);
   TEST_2R("nloc.d",  56, w7,  w4);
   TEST_2R("nloc.d",  64, w8,  w1);
   TEST_2R("nloc.d",  72, w9,  w12);
   TEST_2R("nloc.d",  80, w10, w10);
   TEST_2R("nloc.d",  88, w11, w5);
   TEST_2R("nloc.d",  96, w12, w31);
   TEST_2R("nloc.d", 104, w13, w13);
   TEST_2R("nloc.d", 112, w14, w11);
   TEST_2R("nloc.d", 120, w15, w26);
   TEST_2R("nloc.d", 128, w16, w24);
   TEST_2R("nloc.d", 136, w17, w26);
   TEST_2R("nloc.d", 144, w18, w13);
   TEST_2R("nloc.d", 152, w19, w15);
   TEST_2R("nloc.d", 160, w20, w19);
   TEST_2R("nloc.d", 168, w21, w19);
   TEST_2R("nloc.d", 176, w22, w28);
   TEST_2R("nloc.d", 184, w23, w30);
   TEST_2R("nloc.d", 192, w24, w9);
   TEST_2R("nloc.d", 200, w25, w5);
   TEST_2R("nloc.d", 208, w26, w14);
   TEST_2R("nloc.d", 216, w27, w31);
   TEST_2R("nloc.d", 224, w28, w9);
   TEST_2R("nloc.d", 232, w29, w31);
   TEST_2R("nloc.d", 240, w30, w25);
   TEST_2R("nloc.d", 120, w31, w0);
   TEST_2R("nlzc.b",   0, w0,  w16);
   TEST_2R("nlzc.b",   8, w1,  w12);
   TEST_2R("nlzc.b",  16, w2,  w13);
   TEST_2R("nlzc.b",  24, w3,  w8);
   TEST_2R("nlzc.b",  32, w4,  w6);
   TEST_2R("nlzc.b",  40, w5,  w13);
   TEST_2R("nlzc.b",  48, w6,  w18);
   TEST_2R("nlzc.b",  56, w7,  w7);
   TEST_2R("nlzc.b",  64, w8,  w7);
   TEST_2R("nlzc.b",  72, w9,  w8);
   TEST_2R("nlzc.b",  80, w10, w19);
   TEST_2R("nlzc.b",  88, w11, w5);
   TEST_2R("nlzc.b",  96, w12, w21);
   TEST_2R("nlzc.b", 104, w13, w11);
   TEST_2R("nlzc.b", 112, w14, w26);
   TEST_2R("nlzc.b", 120, w15, w15);
   TEST_2R("nlzc.b", 128, w16, w0);
   TEST_2R("nlzc.b", 136, w17, w16);
   TEST_2R("nlzc.b", 144, w18, w13);
   TEST_2R("nlzc.b", 152, w19, w12);
   TEST_2R("nlzc.b", 160, w20, w7);
   TEST_2R("nlzc.b", 168, w21, w27);
   TEST_2R("nlzc.b", 176, w22, w30);
   TEST_2R("nlzc.b", 184, w23, w7);
   TEST_2R("nlzc.b", 192, w24, w14);
   TEST_2R("nlzc.b", 200, w25, w0);
   TEST_2R("nlzc.b", 208, w26, w25);
   TEST_2R("nlzc.b", 216, w27, w3);
   TEST_2R("nlzc.b", 224, w28, w12);
   TEST_2R("nlzc.b", 232, w29, w24);
   TEST_2R("nlzc.b", 240, w30, w24);
   TEST_2R("nlzc.b",  40, w31, w16);
   TEST_2R("nlzc.h",   0, w0,  w26);
   TEST_2R("nlzc.h",   8, w1,  w9);
   TEST_2R("nlzc.h",  16, w2,  w12);
   TEST_2R("nlzc.h",  24, w3,  w28);
   TEST_2R("nlzc.h",  32, w4,  w6);
   TEST_2R("nlzc.h",  40, w5,  w8);
   TEST_2R("nlzc.h",  48, w6,  w25);
   TEST_2R("nlzc.h",  56, w7,  w7);
   TEST_2R("nlzc.h",  64, w8,  w17);
   TEST_2R("nlzc.h",  72, w9,  w29);
   TEST_2R("nlzc.h",  80, w10, w27);
   TEST_2R("nlzc.h",  88, w11, w20);
   TEST_2R("nlzc.h",  96, w12, w3);
   TEST_2R("nlzc.h", 104, w13, w27);
   TEST_2R("nlzc.h", 112, w14, w5);
   TEST_2R("nlzc.h", 120, w15, w15);
   TEST_2R("nlzc.h", 128, w16, w6);
   TEST_2R("nlzc.h", 136, w17, w8);
   TEST_2R("nlzc.h", 144, w18, w6);
   TEST_2R("nlzc.h", 152, w19, w5);
   TEST_2R("nlzc.h", 160, w20, w8);
   TEST_2R("nlzc.h", 168, w21, w25);
   TEST_2R("nlzc.h", 176, w22, w15);
   TEST_2R("nlzc.h", 184, w23, w31);
   TEST_2R("nlzc.h", 192, w24, w4);
   TEST_2R("nlzc.h", 200, w25, w2);
   TEST_2R("nlzc.h", 208, w26, w24);
   TEST_2R("nlzc.h", 216, w27, w10);
   TEST_2R("nlzc.h", 224, w28, w23);
   TEST_2R("nlzc.h", 232, w29, w28);
   TEST_2R("nlzc.h", 240, w30, w12);
   TEST_2R("nlzc.h",  16, w31, w0);
   TEST_2R("nlzc.w",   0, w0,  w6);
   TEST_2R("nlzc.w",   8, w1,  w25);
   TEST_2R("nlzc.w",  16, w2,  w22);
   TEST_2R("nlzc.w",  24, w3,  w26);
   TEST_2R("nlzc.w",  32, w4,  w22);
   TEST_2R("nlzc.w",  40, w5,  w17);
   TEST_2R("nlzc.w",  48, w6,  w20);
   TEST_2R("nlzc.w",  56, w7,  w7);
   TEST_2R("nlzc.w",  64, w8,  w26);
   TEST_2R("nlzc.w",  72, w9,  w3);
   TEST_2R("nlzc.w",  80, w10, w29);
   TEST_2R("nlzc.w",  88, w11, w21);
   TEST_2R("nlzc.w",  96, w12, w18);
   TEST_2R("nlzc.w", 104, w13, w31);
   TEST_2R("nlzc.w", 112, w14, w8);
   TEST_2R("nlzc.w", 120, w15, w15);
   TEST_2R("nlzc.w", 128, w16, w15);
   TEST_2R("nlzc.w", 136, w17, w5);
   TEST_2R("nlzc.w", 144, w18, w26);
   TEST_2R("nlzc.w", 152, w19, w0);
   TEST_2R("nlzc.w", 160, w20, w13);
   TEST_2R("nlzc.w", 168, w21, w26);
   TEST_2R("nlzc.w", 176, w22, w29);
   TEST_2R("nlzc.w", 184, w23, w1);
   TEST_2R("nlzc.w", 192, w24, w9);
   TEST_2R("nlzc.w", 200, w25, w5);
   TEST_2R("nlzc.w", 208, w26, w2);
   TEST_2R("nlzc.w", 216, w27, w14);
   TEST_2R("nlzc.w", 224, w28, w20);
   TEST_2R("nlzc.w", 232, w29, w12);
   TEST_2R("nlzc.w", 240, w30, w18);
   TEST_2R("nlzc.w",  24, w31, w12);
   TEST_2R("nlzc.d",   0, w0,  w17);
   TEST_2R("nlzc.d",   8, w1,  w21);
   TEST_2R("nlzc.d",  16, w2,  w1);
   TEST_2R("nlzc.d",  24, w3,  w27);
   TEST_2R("nlzc.d",  32, w4,  w20);
   TEST_2R("nlzc.d",  40, w5,  w1);
   TEST_2R("nlzc.d",  48, w6,  w19);
   TEST_2R("nlzc.d",  56, w7,  w7);
   TEST_2R("nlzc.d",  64, w8,  w25);
   TEST_2R("nlzc.d",  72, w9,  w1);
   TEST_2R("nlzc.d",  80, w10, w31);
   TEST_2R("nlzc.d",  88, w11, w0);
   TEST_2R("nlzc.d",  96, w12, w7);
   TEST_2R("nlzc.d", 104, w13, w25);
   TEST_2R("nlzc.d", 112, w14, w3);
   TEST_2R("nlzc.d", 120, w15, w15);
   TEST_2R("nlzc.d", 128, w16, w8);
   TEST_2R("nlzc.d", 136, w17, w23);
   TEST_2R("nlzc.d", 144, w18, w3);
   TEST_2R("nlzc.d", 152, w19, w31);
   TEST_2R("nlzc.d", 160, w20, w19);
   TEST_2R("nlzc.d", 168, w21, w14);
   TEST_2R("nlzc.d", 176, w22, w0);
   TEST_2R("nlzc.d", 184, w23, w17);
   TEST_2R("nlzc.d", 192, w24, w5);
   TEST_2R("nlzc.d", 200, w25, w28);
   TEST_2R("nlzc.d", 208, w26, w30);
   TEST_2R("nlzc.d", 216, w27, w31);
   TEST_2R("nlzc.d", 224, w28, w8);
   TEST_2R("nlzc.d", 232, w29, w2);
   TEST_2R("nlzc.d", 240, w30, w2);
   TEST_2R("nlzc.d", 224, w31, w24);
   TEST_2R("pcnt.b",   0, w0,  w14);
   TEST_2R("pcnt.b",   8, w1,  w15);
   TEST_2R("pcnt.b",  16, w2,  w7);
   TEST_2R("pcnt.b",  24, w3,  w13);
   TEST_2R("pcnt.b",  32, w4,  w4);
   TEST_2R("pcnt.b",  40, w5,  w24);
   TEST_2R("pcnt.b",  48, w6,  w9);
   TEST_2R("pcnt.b",  56, w7,  w24);
   TEST_2R("pcnt.b",  64, w8,  w16);
   TEST_2R("pcnt.b",  72, w9,  w7);
   TEST_2R("pcnt.b",  80, w10, w21);
   TEST_2R("pcnt.b",  88, w11, w26);
   TEST_2R("pcnt.b",  96, w12, w19);
   TEST_2R("pcnt.b", 104, w13, w17);
   TEST_2R("pcnt.b", 112, w14, w11);
   TEST_2R("pcnt.b", 120, w15, w15);
   TEST_2R("pcnt.b", 128, w16, w7);
   TEST_2R("pcnt.b", 136, w17, w7);
   TEST_2R("pcnt.b", 144, w18, w27);
   TEST_2R("pcnt.b", 152, w19, w4);
   TEST_2R("pcnt.b", 160, w20, w27);
   TEST_2R("pcnt.b", 168, w21, w1);
   TEST_2R("pcnt.b", 176, w22, w13);
   TEST_2R("pcnt.b", 184, w23, w5);
   TEST_2R("pcnt.b", 192, w24, w5);
   TEST_2R("pcnt.b", 200, w25, w30);
   TEST_2R("pcnt.b", 208, w26, w23);
   TEST_2R("pcnt.b", 216, w27, w12);
   TEST_2R("pcnt.b", 224, w28, w0);
   TEST_2R("pcnt.b", 232, w29, w26);
   TEST_2R("pcnt.b", 240, w30, w29);
   TEST_2R("pcnt.b", 200, w31, w19);
   TEST_2R("pcnt.h",   0, w0,  w15);
   TEST_2R("pcnt.h",   8, w1,  w6);
   TEST_2R("pcnt.h",  16, w2,  w14);
   TEST_2R("pcnt.h",  24, w3,  w18);
   TEST_2R("pcnt.h",  32, w4,  w4);
   TEST_2R("pcnt.h",  40, w5,  w31);
   TEST_2R("pcnt.h",  48, w6,  w20);
   TEST_2R("pcnt.h",  56, w7,  w2);
   TEST_2R("pcnt.h",  64, w8,  w15);
   TEST_2R("pcnt.h",  72, w9,  w1);
   TEST_2R("pcnt.h",  80, w10, w18);
   TEST_2R("pcnt.h",  88, w11, w24);
   TEST_2R("pcnt.h",  96, w12, w21);
   TEST_2R("pcnt.h", 104, w13, w31);
   TEST_2R("pcnt.h", 112, w14, w3);
   TEST_2R("pcnt.h", 120, w15, w15);
   TEST_2R("pcnt.h", 128, w16, w0);
   TEST_2R("pcnt.h", 136, w17, w20);
   TEST_2R("pcnt.h", 144, w18, w10);
   TEST_2R("pcnt.h", 152, w19, w29);
   TEST_2R("pcnt.h", 160, w20, w9);
   TEST_2R("pcnt.h", 168, w21, w29);
   TEST_2R("pcnt.h", 176, w22, w9);
   TEST_2R("pcnt.h", 184, w23, w28);
   TEST_2R("pcnt.h", 192, w24, w20);
   TEST_2R("pcnt.h", 200, w25, w19);
   TEST_2R("pcnt.h", 208, w26, w30);
   TEST_2R("pcnt.h", 216, w27, w19);
   TEST_2R("pcnt.h", 224, w28, w0);
   TEST_2R("pcnt.h", 232, w29, w8);
   TEST_2R("pcnt.h", 240, w30, w0);
   TEST_2R("pcnt.h", 208, w31, w19);
   TEST_2R("pcnt.w",   0, w0,  w12);
   TEST_2R("pcnt.w",   8, w1,  w27);
   TEST_2R("pcnt.w",  16, w2,  w21);
   TEST_2R("pcnt.w",  24, w3,  w2);
   TEST_2R("pcnt.w",  32, w4,  w4);
   TEST_2R("pcnt.w",  40, w5,  w8);
   TEST_2R("pcnt.w",  48, w6,  w27);
   TEST_2R("pcnt.w",  56, w7,  w8);
   TEST_2R("pcnt.w",  64, w8,  w11);
   TEST_2R("pcnt.w",  72, w9,  w20);
   TEST_2R("pcnt.w",  80, w10, w4);
   TEST_2R("pcnt.w",  88, w11, w10);
   TEST_2R("pcnt.w",  96, w12, w29);
   TEST_2R("pcnt.w", 104, w13, w31);
   TEST_2R("pcnt.w", 112, w14, w11);
   TEST_2R("pcnt.w", 120, w15, w15);
   TEST_2R("pcnt.w", 128, w16, w23);
   TEST_2R("pcnt.w", 136, w17, w13);
   TEST_2R("pcnt.w", 144, w18, w27);
   TEST_2R("pcnt.w", 152, w19, w29);
   TEST_2R("pcnt.w", 160, w20, w7);
   TEST_2R("pcnt.w", 168, w21, w15);
   TEST_2R("pcnt.w", 176, w22, w30);
   TEST_2R("pcnt.w", 184, w23, w5);
   TEST_2R("pcnt.w", 192, w24, w27);
   TEST_2R("pcnt.w", 200, w25, w31);
   TEST_2R("pcnt.w", 208, w26, w15);
   TEST_2R("pcnt.w", 216, w27, w11);
   TEST_2R("pcnt.w", 224, w28, w22);
   TEST_2R("pcnt.w", 232, w29, w18);
   TEST_2R("pcnt.w", 240, w30, w1);
   TEST_2R("pcnt.w",  24, w31, w23);
   TEST_2R("pcnt.d",   0, w0,  w18);
   TEST_2R("pcnt.d",   8, w1,  w19);
   TEST_2R("pcnt.d",  16, w2,  w16);
   TEST_2R("pcnt.d",  24, w3,  w8);
   TEST_2R("pcnt.d",  32, w4,  w4);
   TEST_2R("pcnt.d",  40, w5,  w24);
   TEST_2R("pcnt.d",  48, w6,  w20);
   TEST_2R("pcnt.d",  56, w7,  w27);
   TEST_2R("pcnt.d",  64, w8,  w22);
   TEST_2R("pcnt.d",  72, w9,  w21);
   TEST_2R("pcnt.d",  80, w10, w11);
   TEST_2R("pcnt.d",  88, w11, w15);
   TEST_2R("pcnt.d",  96, w12, w2);
   TEST_2R("pcnt.d", 104, w13, w10);
   TEST_2R("pcnt.d", 112, w14, w2);
   TEST_2R("pcnt.d", 120, w15, w15);
   TEST_2R("pcnt.d", 128, w16, w6);
   TEST_2R("pcnt.d", 136, w17, w14);
   TEST_2R("pcnt.d", 144, w18, w31);
   TEST_2R("pcnt.d", 152, w19, w27);
   TEST_2R("pcnt.d", 160, w20, w15);
   TEST_2R("pcnt.d", 168, w21, w15);
   TEST_2R("pcnt.d", 176, w22, w1);
   TEST_2R("pcnt.d", 184, w23, w1);
   TEST_2R("pcnt.d", 192, w24, w27);
   TEST_2R("pcnt.d", 200, w25, w8);
   TEST_2R("pcnt.d", 208, w26, w21);
   TEST_2R("pcnt.d", 216, w27, w9);
   TEST_2R("pcnt.d", 224, w28, w23);
   TEST_2R("pcnt.d", 232, w29, w12);
   TEST_2R("pcnt.d", 240, w30, w25);
   TEST_2R("pcnt.d", 128, w31, w5);
   TEST_3R("bclr.b",   0,  24, w0,  w10, w18);
   TEST_3R("bclr.b",   8,  96, w1,  w30, w2);
   TEST_3R("bclr.b",  16,  48, w2,  w13, w12);
   TEST_3R("bclr.b",  24,  80, w3,  w19, w13);
   TEST_3R("bclr.b",  32, 104, w4,  w15, w19);
   TEST_3R("bclr.b",  40, 168, w5,  w22, w8);
   TEST_3R("bclr.b",  48, 224, w6,  w0,  w30);
   TEST_3R("bclr.b",  56, 152, w7,  w12, w3);
   TEST_3R("bclr.b",  64, 152, w8,  w20, w26);
   TEST_3R("bclr.b",  72,   8, w9,  w27, w17);
   TEST_3R("bclr.b",  80,  40, w10, w5,  w4);
   TEST_3R("bclr.b",  88, 144, w11, w3,  w6);
   TEST_3R("bclr.b",  96, 200, w12, w17, w18);
   TEST_3R("bclr.b", 104, 152, w13, w4,  w0);
   TEST_3R("bclr.b", 112, 136, w14, w19, w11);
   TEST_3R("bclr.b", 120,  72, w15, w27, w21);
   TEST_3R("bclr.b", 128,  48, w16, w25, w22);
   TEST_3R("bclr.b", 136,  40, w17, w28, w16);
   TEST_3R("bclr.b", 144, 192, w18, w4,  w11);
   TEST_3R("bclr.b", 152, 216, w19, w19, w0);
   TEST_3R("bclr.b", 160, 128, w20, w5,  w0);
   TEST_3R("bclr.b", 168, 160, w21, w9,  w9);
   TEST_3R("bclr.b", 176,  32, w22, w22, w22);
   TEST_3R("bclr.b", 184, 184, w23, w26, w23);
   TEST_3R("bclr.b", 192, 136, w24, w30, w25);
   TEST_3R("bclr.b", 200, 168, w25, w18, w12);
   TEST_3R("bclr.b", 208, 232, w26, w28, w7);
   TEST_3R("bclr.b", 216,  48, w27, w6,  w0);
   TEST_3R("bclr.b", 224,  64, w28, w29, w20);
   TEST_3R("bclr.b", 232,  24, w29, w1,  w31);
   TEST_3R("bclr.b", 240, 104, w30, w1,  w27);
   TEST_3R("bclr.b",  64,   0, w31, w7,  w28);
   TEST_3R("bclr.h",   0, 152, w0,  w2,  w19);
   TEST_3R("bclr.h",   8, 120, w1,  w27, w17);
   TEST_3R("bclr.h",  16,  24, w2,  w20, w30);
   TEST_3R("bclr.h",  24, 176, w3,  w0,  w23);
   TEST_3R("bclr.h",  32, 184, w4,  w7,  w28);
   TEST_3R("bclr.h",  40,  48, w5,  w8,  w25);
   TEST_3R("bclr.h",  48, 128, w6,  w28, w0);
   TEST_3R("bclr.h",  56,   0, w7,  w27, w8);
   TEST_3R("bclr.h",  64, 160, w8,  w11, w15);
   TEST_3R("bclr.h",  72,   0, w9,  w27, w31);
   TEST_3R("bclr.h",  80, 144, w10, w14, w9);
   TEST_3R("bclr.h",  88,  64, w11, w0,  w17);
   TEST_3R("bclr.h",  96, 144, w12, w30, w5);
   TEST_3R("bclr.h", 104, 232, w13, w2,  w26);
   TEST_3R("bclr.h", 112,  72, w14, w21, w2);
   TEST_3R("bclr.h", 120, 216, w15, w26, w30);
   TEST_3R("bclr.h", 128, 144, w16, w0,  w25);
   TEST_3R("bclr.h", 136,  56, w17, w8,  w15);
   TEST_3R("bclr.h", 144,  88, w18, w23, w2);
   TEST_3R("bclr.h", 152, 112, w19, w19, w22);
   TEST_3R("bclr.h", 160,  16, w20, w8,  w31);
   TEST_3R("bclr.h", 168, 192, w21, w8,  w8);
   TEST_3R("bclr.h", 176,  88, w22, w22, w22);
   TEST_3R("bclr.h", 184, 200, w23, w6,  w23);
   TEST_3R("bclr.h", 192,  24, w24, w18, w28);
   TEST_3R("bclr.h", 200,  24, w25, w31, w22);
   TEST_3R("bclr.h", 208, 208, w26, w20, w24);
   TEST_3R("bclr.h", 216, 184, w27, w14, w22);
   TEST_3R("bclr.h", 224, 208, w28, w14, w15);
   TEST_3R("bclr.h", 232, 144, w29, w23, w30);
   TEST_3R("bclr.h", 240, 232, w30, w14, w0);
   TEST_3R("bclr.h",  80,   0, w31, w5,  w23);
   TEST_3R("bclr.w",   0,  32, w0,  w31, w10);
   TEST_3R("bclr.w",   8, 112, w1,  w11, w16);
   TEST_3R("bclr.w",  16, 144, w2,  w29, w12);
   TEST_3R("bclr.w",  24,  48, w3,  w28, w2);
   TEST_3R("bclr.w",  32,  16, w4,  w16, w26);
   TEST_3R("bclr.w",  40,  80, w5,  w30, w16);
   TEST_3R("bclr.w",  48,  48, w6,  w13, w31);
   TEST_3R("bclr.w",  56, 200, w7,  w4,  w30);
   TEST_3R("bclr.w",  64,  64, w8,  w18, w30);
   TEST_3R("bclr.w",  72,  64, w9,  w23, w22);
   TEST_3R("bclr.w",  80,   8, w10, w28, w21);
   TEST_3R("bclr.w",  88, 216, w11, w17, w0);
   TEST_3R("bclr.w",  96,   8, w12, w4,  w30);
   TEST_3R("bclr.w", 104, 168, w13, w22, w26);
   TEST_3R("bclr.w", 112, 184, w14, w6,  w11);
   TEST_3R("bclr.w", 120, 104, w15, w13, w9);
   TEST_3R("bclr.w", 128,   8, w16, w3,  w22);
   TEST_3R("bclr.w", 136, 144, w17, w26, w6);
   TEST_3R("bclr.w", 144, 208, w18, w13, w4);
   TEST_3R("bclr.w", 152, 168, w19, w19, w4);
   TEST_3R("bclr.w", 160, 168, w20, w24, w0);
   TEST_3R("bclr.w", 168, 208, w21, w22, w22);
   TEST_3R("bclr.w", 176,  96, w22, w22, w22);
   TEST_3R("bclr.w", 184, 176, w23, w5,  w23);
   TEST_3R("bclr.w", 192,  56, w24, w14, w0);
   TEST_3R("bclr.w", 200,  96, w25, w8,  w29);
   TEST_3R("bclr.w", 208, 160, w26, w19, w21);
   TEST_3R("bclr.w", 216, 176, w27, w29, w30);
   TEST_3R("bclr.w", 224, 120, w28, w19, w6);
   TEST_3R("bclr.w", 232,  32, w29, w14, w12);
   TEST_3R("bclr.w", 240, 112, w30, w27, w16);
   TEST_3R("bclr.w", 168,  48, w31, w11, w13);
   TEST_3R("bclr.d",   0, 136, w0,  w3,  w18);
   TEST_3R("bclr.d",   8, 232, w1,  w8,  w24);
   TEST_3R("bclr.d",  16,  64, w2,  w20, w1);
   TEST_3R("bclr.d",  24,  72, w3,  w6,  w20);
   TEST_3R("bclr.d",  32, 184, w4,  w6,  w17);
   TEST_3R("bclr.d",  40, 176, w5,  w9,  w31);
   TEST_3R("bclr.d",  48, 208, w6,  w19, w11);
   TEST_3R("bclr.d",  56,  88, w7,  w14, w28);
   TEST_3R("bclr.d",  64, 232, w8,  w13, w7);
   TEST_3R("bclr.d",  72,  56, w9,  w13, w1);
   TEST_3R("bclr.d",  80,  16, w10, w31, w12);
   TEST_3R("bclr.d",  88,   8, w11, w7,  w4);
   TEST_3R("bclr.d",  96, 192, w12, w27, w5);
   TEST_3R("bclr.d", 104,  24, w13, w2,  w26);
   TEST_3R("bclr.d", 112, 216, w14, w8,  w11);
   TEST_3R("bclr.d", 120,  16, w15, w18, w16);
   TEST_3R("bclr.d", 128, 160, w16, w25, w3);
   TEST_3R("bclr.d", 136,  40, w17, w16, w15);
   TEST_3R("bclr.d", 144, 144, w18, w31, w22);
   TEST_3R("bclr.d", 152,  64, w19, w19, w12);
   TEST_3R("bclr.d", 160, 208, w20, w16, w12);
   TEST_3R("bclr.d", 168,  96, w21, w20, w20);
   TEST_3R("bclr.d", 176, 200, w22, w22, w22);
   TEST_3R("bclr.d", 184, 104, w23, w1,  w23);
   TEST_3R("bclr.d", 192, 208, w24, w13, w20);
   TEST_3R("bclr.d", 200,  72, w25, w7,  w3);
   TEST_3R("bclr.d", 208, 232, w26, w19, w11);
   TEST_3R("bclr.d", 216,  96, w27, w3,  w18);
   TEST_3R("bclr.d", 224,  48, w28, w7,  w5);
   TEST_3R("bclr.d", 232, 208, w29, w24, w20);
   TEST_3R("bclr.d", 240, 112, w30, w23, w10);
   TEST_3R("bclr.d", 208,  80, w31, w4,  w2);
   TEST_3R("binsl.b",   0, 200, w0,  w10, w18);
   TEST_3R("binsl.b",   8, 128, w1,  w30, w3);
   TEST_3R("binsl.b",  16,  32, w2,  w1,  w29);
   TEST_3R("binsl.b",  24, 200, w3,  w12, w3);
   TEST_3R("binsl.b",  32, 168, w4,  w25, w31);
   TEST_3R("binsl.b",  40,  96, w5,  w5,  w5);
   TEST_3R("binsl.b",  48, 216, w6,  w4,  w1);
   TEST_3R("binsl.b",  56,  64, w7,  w25, w17);
   TEST_3R("binsl.b",  64, 176, w8,  w8,  w3);
   TEST_3R("binsl.b",  72, 136, w9,  w20, w5);
   TEST_3R("binsl.b",  80, 192, w10, w4,  w11);
   TEST_3R("binsl.b",  88, 120, w11, w7,  w24);
   TEST_3R("binsl.b",  96, 232, w12, w26, w19);
   TEST_3R("binsl.b", 104,  64, w13, w29, w29);
   TEST_3R("binsl.b", 112, 104, w14, w28, w26);
   TEST_3R("binsl.b", 120, 160, w15, w8,  w3);
   TEST_3R("binsl.b", 128,  88, w16, w7,  w4);
   TEST_3R("binsl.b", 136, 144, w17, w29, w5);
   TEST_3R("binsl.b", 144, 200, w18, w13, w8);
   TEST_3R("binsl.b", 152, 208, w19, w1,  w14);
   TEST_3R("binsl.b", 160, 160, w20, w5,  w25);
   TEST_3R("binsl.b", 168, 160, w21, w12, w17);
   TEST_3R("binsl.b", 176, 152, w22, w6,  w5);
   TEST_3R("binsl.b", 184, 112, w23, w4,  w27);
   TEST_3R("binsl.b", 192, 216, w24, w30, w6);
   TEST_3R("binsl.b", 200,  80, w25, w1,  w11);
   TEST_3R("binsl.b", 208,  48, w26, w17, w15);
   TEST_3R("binsl.b", 216, 112, w27, w3,  w12);
   TEST_3R("binsl.b", 224, 112, w28, w6,  w25);
   TEST_3R("binsl.b", 232,  40, w29, w30, w26);
   TEST_3R("binsl.b", 240,  16, w30, w0,  w31);
   TEST_3R("binsl.b", 112, 104, w31, w20, w12);
   TEST_3R("binsl.h",   0,  24, w0,  w18, w13);
   TEST_3R("binsl.h",   8,  16, w1,  w22, w8);
   TEST_3R("binsl.h",  16,   0, w2,  w21, w15);
   TEST_3R("binsl.h",  24, 152, w3,  w22, w3);
   TEST_3R("binsl.h",  32,  40, w4,  w27, w8);
   TEST_3R("binsl.h",  40, 120, w5,  w5,  w5);
   TEST_3R("binsl.h",  48, 112, w6,  w11, w22);
   TEST_3R("binsl.h",  56,  96, w7,  w17, w15);
   TEST_3R("binsl.h",  64,  24, w8,  w8,  w15);
   TEST_3R("binsl.h",  72, 200, w9,  w19, w16);
   TEST_3R("binsl.h",  80, 144, w10, w4,  w21);
   TEST_3R("binsl.h",  88, 144, w11, w9,  w8);
   TEST_3R("binsl.h",  96, 104, w12, w24, w30);
   TEST_3R("binsl.h", 104,  16, w13, w19, w19);
   TEST_3R("binsl.h", 112,  48, w14, w18, w10);
   TEST_3R("binsl.h", 120, 200, w15, w13, w18);
   TEST_3R("binsl.h", 128,   0, w16, w10, w29);
   TEST_3R("binsl.h", 136,  96, w17, w15, w14);
   TEST_3R("binsl.h", 144, 232, w18, w4,  w29);
   TEST_3R("binsl.h", 152, 192, w19, w23, w13);
   TEST_3R("binsl.h", 160,  56, w20, w1,  w18);
   TEST_3R("binsl.h", 168,  64, w21, w20, w27);
   TEST_3R("binsl.h", 176,  80, w22, w20, w19);
   TEST_3R("binsl.h", 184, 208, w23, w28, w0);
   TEST_3R("binsl.h", 192,  24, w24, w20, w18);
   TEST_3R("binsl.h", 200, 136, w25, w5,  w31);
   TEST_3R("binsl.h", 208,  40, w26, w0,  w10);
   TEST_3R("binsl.h", 216, 216, w27, w17, w25);
   TEST_3R("binsl.h", 224, 136, w28, w18, w30);
   TEST_3R("binsl.h", 232,  64, w29, w28, w21);
   TEST_3R("binsl.h", 240, 224, w30, w16, w23);
   TEST_3R("binsl.h",  72,   0, w31, w26, w11);
   TEST_3R("binsl.w",   0,  24, w0,  w31, w21);
   TEST_3R("binsl.w",   8, 232, w1,  w27, w22);
   TEST_3R("binsl.w",  16,  24, w2,  w15, w8);
   TEST_3R("binsl.w",  24, 216, w3,  w21, w3);
   TEST_3R("binsl.w",  32, 192, w4,  w12, w21);
   TEST_3R("binsl.w",  40,  88, w5,  w5,  w5);
   TEST_3R("binsl.w",  48, 176, w6,  w7,  w11);
   TEST_3R("binsl.w",  56,  72, w7,  w25, w9);
   TEST_3R("binsl.w",  64, 136, w8,  w8,  w21);
   TEST_3R("binsl.w",  72,   0, w9,  w16, w6);
   TEST_3R("binsl.w",  80, 128, w10, w24, w0);
   TEST_3R("binsl.w",  88,  16, w11, w26, w0);
   TEST_3R("binsl.w",  96,  48, w12, w7,  w27);
   TEST_3R("binsl.w", 104,   8, w13, w6,  w6);
   TEST_3R("binsl.w", 112, 208, w14, w18, w0);
   TEST_3R("binsl.w", 120, 168, w15, w30, w21);
   TEST_3R("binsl.w", 128, 192, w16, w7,  w28);
   TEST_3R("binsl.w", 136, 232, w17, w26, w21);
   TEST_3R("binsl.w", 144,   8, w18, w21, w11);
   TEST_3R("binsl.w", 152, 128, w19, w5,  w17);
   TEST_3R("binsl.w", 160,  16, w20, w29, w17);
   TEST_3R("binsl.w", 168, 192, w21, w24, w28);
   TEST_3R("binsl.w", 176, 200, w22, w8,  w3);
   TEST_3R("binsl.w", 184,  88, w23, w14, w9);
   TEST_3R("binsl.w", 192, 224, w24, w28, w26);
   TEST_3R("binsl.w", 200, 152, w25, w26, w15);
   TEST_3R("binsl.w", 208, 104, w26, w1,  w12);
   TEST_3R("binsl.w", 216, 224, w27, w1,  w13);
   TEST_3R("binsl.w", 224, 160, w28, w12, w9);
   TEST_3R("binsl.w", 232, 136, w29, w28, w19);
   TEST_3R("binsl.w", 240, 184, w30, w15, w11);
   TEST_3R("binsl.w", 160, 232, w31, w3,  w19);
   TEST_3R("binsl.d",   0,   8, w0,  w1,  w24);
   TEST_3R("binsl.d",   8,  48, w1,  w30, w20);
   TEST_3R("binsl.d",  16, 176, w2,  w17, w14);
   TEST_3R("binsl.d",  24, 176, w3,  w12, w3);
   TEST_3R("binsl.d",  32, 232, w4,  w1,  w28);
   TEST_3R("binsl.d",  40,   0, w5,  w5,  w5);
   TEST_3R("binsl.d",  48,  56, w6,  w9,  w28);
   TEST_3R("binsl.d",  56, 216, w7,  w18, w13);
   TEST_3R("binsl.d",  64,  40, w8,  w8,  w5);
   TEST_3R("binsl.d",  72,  96, w9,  w30, w17);
   TEST_3R("binsl.d",  80,  96, w10, w1,  w4);
   TEST_3R("binsl.d",  88, 152, w11, w19, w6);
   TEST_3R("binsl.d",  96,  80, w12, w31, w4);
   TEST_3R("binsl.d", 104,  32, w13, w5,  w5);
   TEST_3R("binsl.d", 112,  80, w14, w15, w26);
   TEST_3R("binsl.d", 120, 232, w15, w31, w28);
   TEST_3R("binsl.d", 128,   0, w16, w11, w31);
   TEST_3R("binsl.d", 136, 232, w17, w7,  w14);
   TEST_3R("binsl.d", 144, 208, w18, w25, w27);
   TEST_3R("binsl.d", 152, 192, w19, w30, w23);
   TEST_3R("binsl.d", 160,  16, w20, w15, w29);
   TEST_3R("binsl.d", 168, 120, w21, w20, w18);
   TEST_3R("binsl.d", 176, 232, w22, w26, w31);
   TEST_3R("binsl.d", 184,  24, w23, w30, w0);
   TEST_3R("binsl.d", 192, 120, w24, w19, w16);
   TEST_3R("binsl.d", 200, 144, w25, w20, w15);
   TEST_3R("binsl.d", 208, 104, w26, w18, w19);
   TEST_3R("binsl.d", 216,  24, w27, w1,  w17);
   TEST_3R("binsl.d", 224, 120, w28, w29, w25);
   TEST_3R("binsl.d", 232, 168, w29, w20, w30);
   TEST_3R("binsl.d", 240,  40, w30, w17, w5);
   TEST_3R("binsl.d",   0, 144, w31, w4,  w30);
   TEST_3R("binsr.b",   0, 152, w0,  w20, w12);
   TEST_3R("binsr.b",   8,   8, w1,  w3,  w0);
   TEST_3R("binsr.b",  16, 224, w2,  w30, w19);
   TEST_3R("binsr.b",  24, 200, w3,  w31, w21);
   TEST_3R("binsr.b",  32, 176, w4,  w26, w4);
   TEST_3R("binsr.b",  40,   0, w5,  w17, w19);
   TEST_3R("binsr.b",  48,  80, w6,  w15, w27);
   TEST_3R("binsr.b",  56, 168, w7,  w20, w20);
   TEST_3R("binsr.b",  64,  72, w8,  w27, w19);
   TEST_3R("binsr.b",  72,  96, w9,  w31, w10);
   TEST_3R("binsr.b",  80,  24, w10, w3,  w30);
   TEST_3R("binsr.b",  88, 184, w11, w23, w6);
   TEST_3R("binsr.b",  96, 200, w12, w11, w20);
   TEST_3R("binsr.b", 104,  24, w13, w31, w27);
   TEST_3R("binsr.b", 112, 224, w14, w20, w19);
   TEST_3R("binsr.b", 120,  64, w15, w6,  w4);
   TEST_3R("binsr.b", 128, 192, w16, w12, w19);
   TEST_3R("binsr.b", 136, 120, w17, w3,  w8);
   TEST_3R("binsr.b", 144,  64, w18, w31, w27);
   TEST_3R("binsr.b", 152,  40, w19, w30, w5);
   TEST_3R("binsr.b", 160,  80, w20, w20, w1);
   TEST_3R("binsr.b", 168, 184, w21, w20, w24);
   TEST_3R("binsr.b", 176,   8, w22, w27, w18);
   TEST_3R("binsr.b", 184,  56, w23, w23, w23);
   TEST_3R("binsr.b", 192, 104, w24, w11, w25);
   TEST_3R("binsr.b", 200, 232, w25, w3,  w13);
   TEST_3R("binsr.b", 208,  16, w26, w21, w19);
   TEST_3R("binsr.b", 216, 192, w27, w26, w31);
   TEST_3R("binsr.b", 224, 200, w28, w26, w2);
   TEST_3R("binsr.b", 232, 200, w29, w19, w1);
   TEST_3R("binsr.b", 240, 216, w30, w26, w31);
   TEST_3R("binsr.b",  88, 176, w31, w4,  w0);
   TEST_3R("binsr.h",   0, 192, w0,  w24, w15);
   TEST_3R("binsr.h",   8,  16, w1,  w11, w9);
   TEST_3R("binsr.h",  16, 120, w2,  w22, w13);
   TEST_3R("binsr.h",  24, 152, w3,  w15, w11);
   TEST_3R("binsr.h",  32, 120, w4,  w2,  w4);
   TEST_3R("binsr.h",  40,  80, w5,  w8,  w1);
   TEST_3R("binsr.h",  48, 152, w6,  w2,  w3);
   TEST_3R("binsr.h",  56, 144, w7,  w21, w21);
   TEST_3R("binsr.h",  64, 224, w8,  w22, w15);
   TEST_3R("binsr.h",  72, 144, w9,  w19, w5);
   TEST_3R("binsr.h",  80, 144, w10, w12, w29);
   TEST_3R("binsr.h",  88, 152, w11, w31, w8);
   TEST_3R("binsr.h",  96, 104, w12, w2,  w30);
   TEST_3R("binsr.h", 104, 104, w13, w16, w23);
   TEST_3R("binsr.h", 112, 168, w14, w27, w5);
   TEST_3R("binsr.h", 120, 112, w15, w7,  w13);
   TEST_3R("binsr.h", 128,   0, w16, w9,  w3);
   TEST_3R("binsr.h", 136, 120, w17, w5,  w8);
   TEST_3R("binsr.h", 144, 208, w18, w21, w13);
   TEST_3R("binsr.h", 152, 112, w19, w8,  w18);
   TEST_3R("binsr.h", 160, 136, w20, w20, w15);
   TEST_3R("binsr.h", 168, 160, w21, w20, w24);
   TEST_3R("binsr.h", 176,   8, w22, w2,  w6);
   TEST_3R("binsr.h", 184,   8, w23, w23, w23);
   TEST_3R("binsr.h", 192, 184, w24, w1,  w19);
   TEST_3R("binsr.h", 200, 168, w25, w9,  w1);
   TEST_3R("binsr.h", 208, 176, w26, w18, w17);
   TEST_3R("binsr.h", 216,  88, w27, w25, w22);
   TEST_3R("binsr.h", 224, 224, w28, w23, w11);
   TEST_3R("binsr.h", 232,  40, w29, w9,  w20);
   TEST_3R("binsr.h", 240,  88, w30, w14, w8);
   TEST_3R("binsr.h", 152, 160, w31, w23, w28);
   TEST_3R("binsr.w",   0, 184, w0,  w19, w7);
   TEST_3R("binsr.w",   8, 200, w1,  w25, w21);
   TEST_3R("binsr.w",  16,  24, w2,  w27, w9);
   TEST_3R("binsr.w",  24, 200, w3,  w4,  w10);
   TEST_3R("binsr.w",  32, 184, w4,  w22, w4);
   TEST_3R("binsr.w",  40,  32, w5,  w12, w15);
   TEST_3R("binsr.w",  48, 200, w6,  w23, w7);
   TEST_3R("binsr.w",  56,  32, w7,  w14, w14);
   TEST_3R("binsr.w",  64, 120, w8,  w17, w24);
   TEST_3R("binsr.w",  72, 112, w9,  w25, w17);
   TEST_3R("binsr.w",  80,  32, w10, w22, w2);
   TEST_3R("binsr.w",  88, 160, w11, w9,  w15);
   TEST_3R("binsr.w",  96,  88, w12, w31, w28);
   TEST_3R("binsr.w", 104,  32, w13, w8,  w1);
   TEST_3R("binsr.w", 112,  88, w14, w19, w23);
   TEST_3R("binsr.w", 120, 120, w15, w31, w7);
   TEST_3R("binsr.w", 128, 200, w16, w22, w14);
   TEST_3R("binsr.w", 136, 152, w17, w5,  w30);
   TEST_3R("binsr.w", 144, 208, w18, w29, w28);
   TEST_3R("binsr.w", 152, 232, w19, w14, w18);
   TEST_3R("binsr.w", 160, 208, w20, w20, w16);
   TEST_3R("binsr.w", 168,  64, w21, w5,  w25);
   TEST_3R("binsr.w", 176, 232, w22, w7,  w24);
   TEST_3R("binsr.w", 184,  16, w23, w23, w23);
   TEST_3R("binsr.w", 192,  96, w24, w0,  w7);
   TEST_3R("binsr.w", 200,  56, w25, w18, w26);
   TEST_3R("binsr.w", 208, 160, w26, w31, w25);
   TEST_3R("binsr.w", 216, 192, w27, w30, w16);
   TEST_3R("binsr.w", 224, 128, w28, w25, w21);
   TEST_3R("binsr.w", 232, 184, w29, w6,  w18);
   TEST_3R("binsr.w", 240, 120, w30, w12, w0);
   TEST_3R("binsr.w",  56, 208, w31, w8,  w16);
   TEST_3R("binsr.d",   0, 224, w0,  w9,  w20);
   TEST_3R("binsr.d",   8,   8, w1,  w2,  w19);
   TEST_3R("binsr.d",  16, 144, w2,  w26, w0);
   TEST_3R("binsr.d",  24, 112, w3,  w20, w30);
   TEST_3R("binsr.d",  32, 208, w4,  w13, w4);
   TEST_3R("binsr.d",  40,  32, w5,  w18, w29);
   TEST_3R("binsr.d",  48,  32, w6,  w12, w18);
   TEST_3R("binsr.d",  56, 192, w7,  w18, w18);
   TEST_3R("binsr.d",  64, 176, w8,  w20, w30);
   TEST_3R("binsr.d",  72,  64, w9,  w20, w6);
   TEST_3R("binsr.d",  80,  56, w10, w6,  w19);
   TEST_3R("binsr.d",  88, 112, w11, w27, w7);
   TEST_3R("binsr.d",  96, 128, w12, w14, w1);
   TEST_3R("binsr.d", 104,  32, w13, w8,  w1);
   TEST_3R("binsr.d", 112,  24, w14, w28, w31);
   TEST_3R("binsr.d", 120, 232, w15, w9,  w2);
   TEST_3R("binsr.d", 128, 136, w16, w7,  w24);
   TEST_3R("binsr.d", 136,   8, w17, w25, w31);
   TEST_3R("binsr.d", 144,  56, w18, w30, w19);
   TEST_3R("binsr.d", 152,  32, w19, w2,  w7);
   TEST_3R("binsr.d", 160, 232, w20, w20, w23);
   TEST_3R("binsr.d", 168, 216, w21, w19, w9);
   TEST_3R("binsr.d", 176, 120, w22, w21, w23);
   TEST_3R("binsr.d", 184, 192, w23, w23, w23);
   TEST_3R("binsr.d", 192, 104, w24, w31, w29);
   TEST_3R("binsr.d", 200, 136, w25, w27, w28);
   TEST_3R("binsr.d", 208, 136, w26, w4,  w30);
   TEST_3R("binsr.d", 216,  32, w27, w11, w22);
   TEST_3R("binsr.d", 224, 160, w28, w5,  w21);
   TEST_3R("binsr.d", 232,  88, w29, w3,  w8);
   TEST_3R("binsr.d", 240, 120, w30, w5,  w16);
   TEST_3R("binsr.d",  16, 184, w31, w28, w30);
   TEST_3R("bneg.b",   0, 216, w0,  w6,  w30);
   TEST_3R("bneg.b",   8,  40, w1,  w3,  w13);
   TEST_3R("bneg.b",  16, 200, w2,  w31, w8);
   TEST_3R("bneg.b",  24, 232, w3,  w29, w1);
   TEST_3R("bneg.b",  32,  72, w4,  w19, w5);
   TEST_3R("bneg.b",  40,  48, w5,  w8,  w6);
   TEST_3R("bneg.b",  48,  80, w6,  w16, w6);
   TEST_3R("bneg.b",  56, 208, w7,  w7,  w7);
   TEST_3R("bneg.b",  64, 144, w8,  w0,  w28);
   TEST_3R("bneg.b",  72,  32, w9,  w30, w11);
   TEST_3R("bneg.b",  80, 192, w10, w10, w5);
   TEST_3R("bneg.b",  88, 232, w11, w10, w3);
   TEST_3R("bneg.b",  96, 168, w12, w8,  w0);
   TEST_3R("bneg.b", 104,  40, w13, w21, w24);
   TEST_3R("bneg.b", 112, 104, w14, w29, w21);
   TEST_3R("bneg.b", 120, 168, w15, w30, w29);
   TEST_3R("bneg.b", 128, 192, w16, w4,  w10);
   TEST_3R("bneg.b", 136,   0, w17, w10, w26);
   TEST_3R("bneg.b", 144, 112, w18, w11, w15);
   TEST_3R("bneg.b", 152, 160, w19, w7,  w1);
   TEST_3R("bneg.b", 160, 232, w20, w19, w5);
   TEST_3R("bneg.b", 168,  72, w21, w8,  w15);
   TEST_3R("bneg.b", 176,   8, w22, w4,  w23);
   TEST_3R("bneg.b", 184,  96, w23, w2,  w12);
   TEST_3R("bneg.b", 192, 152, w24, w0,  w9);
   TEST_3R("bneg.b", 200,  72, w25, w26, w7);
   TEST_3R("bneg.b", 208,  64, w26, w8,  w11);
   TEST_3R("bneg.b", 216, 104, w27, w29, w21);
   TEST_3R("bneg.b", 224, 232, w28, w3,  w0);
   TEST_3R("bneg.b", 232, 136, w29, w10, w8);
   TEST_3R("bneg.b", 240,  40, w30, w15, w15);
   TEST_3R("bneg.b", 144, 112, w31, w19, w25);
   TEST_3R("bneg.h",   0,   0, w0,  w7,  w25);
   TEST_3R("bneg.h",   8, 104, w1,  w10, w5);
   TEST_3R("bneg.h",  16, 136, w2,  w10, w14);
   TEST_3R("bneg.h",  24,  80, w3,  w4,  w21);
   TEST_3R("bneg.h",  32,  16, w4,  w12, w1);
   TEST_3R("bneg.h",  40, 128, w5,  w10, w22);
   TEST_3R("bneg.h",  48, 144, w6,  w13, w6);
   TEST_3R("bneg.h",  56, 232, w7,  w7,  w7);
   TEST_3R("bneg.h",  64, 136, w8,  w23, w31);
   TEST_3R("bneg.h",  72, 216, w9,  w6,  w26);
   TEST_3R("bneg.h",  80, 104, w10, w10, w0);
   TEST_3R("bneg.h",  88, 160, w11, w1,  w7);
   TEST_3R("bneg.h",  96,  88, w12, w26, w29);
   TEST_3R("bneg.h", 104, 168, w13, w31, w26);
   TEST_3R("bneg.h", 112, 136, w14, w13, w19);
   TEST_3R("bneg.h", 120, 184, w15, w3,  w5);
   TEST_3R("bneg.h", 128,   0, w16, w4,  w26);
   TEST_3R("bneg.h", 136, 208, w17, w26, w12);
   TEST_3R("bneg.h", 144, 184, w18, w17, w11);
   TEST_3R("bneg.h", 152, 200, w19, w16, w23);
   TEST_3R("bneg.h", 160, 152, w20, w10, w23);
   TEST_3R("bneg.h", 168,  96, w21, w8,  w24);
   TEST_3R("bneg.h", 176,  48, w22, w13, w19);
   TEST_3R("bneg.h", 184, 216, w23, w28, w18);
   TEST_3R("bneg.h", 192, 160, w24, w21, w0);
   TEST_3R("bneg.h", 200, 184, w25, w18, w3);
   TEST_3R("bneg.h", 208,  96, w26, w28, w7);
   TEST_3R("bneg.h", 216, 136, w27, w16, w1);
   TEST_3R("bneg.h", 224,  56, w28, w18, w19);
   TEST_3R("bneg.h", 232, 224, w29, w11, w3);
   TEST_3R("bneg.h", 240,  56, w30, w10, w10);
   TEST_3R("bneg.h", 160, 224, w31, w24, w10);
   TEST_3R("bneg.w",   0, 176, w0,  w17, w3);
   TEST_3R("bneg.w",   8, 160, w1,  w21, w31);
   TEST_3R("bneg.w",  16, 144, w2,  w20, w22);
   TEST_3R("bneg.w",  24, 200, w3,  w6,  w25);
   TEST_3R("bneg.w",  32,  64, w4,  w3,  w0);
   TEST_3R("bneg.w",  40,  80, w5,  w19, w2);
   TEST_3R("bneg.w",  48, 176, w6,  w5,  w6);
   TEST_3R("bneg.w",  56,   8, w7,  w7,  w7);
   TEST_3R("bneg.w",  64, 104, w8,  w16, w24);
   TEST_3R("bneg.w",  72, 112, w9,  w27, w6);
   TEST_3R("bneg.w",  80,  88, w10, w10, w5);
   TEST_3R("bneg.w",  88, 168, w11, w5,  w22);
   TEST_3R("bneg.w",  96,  72, w12, w9,  w11);
   TEST_3R("bneg.w", 104,  48, w13, w0,  w18);
   TEST_3R("bneg.w", 112,   0, w14, w7,  w25);
   TEST_3R("bneg.w", 120,   0, w15, w6,  w28);
   TEST_3R("bneg.w", 128, 144, w16, w23, w15);
   TEST_3R("bneg.w", 136,  80, w17, w8,  w21);
   TEST_3R("bneg.w", 144,  16, w18, w2,  w5);
   TEST_3R("bneg.w", 152, 224, w19, w30, w0);
   TEST_3R("bneg.w", 160,  80, w20, w19, w5);
   TEST_3R("bneg.w", 168,  16, w21, w24, w27);
   TEST_3R("bneg.w", 176,  96, w22, w2,  w7);
   TEST_3R("bneg.w", 184,  64, w23, w2,  w7);
   TEST_3R("bneg.w", 192,   8, w24, w14, w12);
   TEST_3R("bneg.w", 200,   8, w25, w20, w8);
   TEST_3R("bneg.w", 208, 152, w26, w11, w24);
   TEST_3R("bneg.w", 216, 112, w27, w19, w13);
   TEST_3R("bneg.w", 224,   0, w28, w22, w18);
   TEST_3R("bneg.w", 232, 232, w29, w20, w19);
   TEST_3R("bneg.w", 240, 120, w30, w7,  w7);
   TEST_3R("bneg.w", 200,  16, w31, w28, w0);
   TEST_3R("bneg.d",   0,  64, w0,  w2,  w27);
   TEST_3R("bneg.d",   8,   0, w1,  w4,  w2);
   TEST_3R("bneg.d",  16, 160, w2,  w28, w16);
   TEST_3R("bneg.d",  24,  24, w3,  w5,  w4);
   TEST_3R("bneg.d",  32,  96, w4,  w30, w15);
   TEST_3R("bneg.d",  40, 168, w5,  w9,  w3);
   TEST_3R("bneg.d",  48, 120, w6,  w28, w6);
   TEST_3R("bneg.d",  56,  48, w7,  w7,  w7);
   TEST_3R("bneg.d",  64,  16, w8,  w15, w13);
   TEST_3R("bneg.d",  72, 128, w9,  w21, w11);
   TEST_3R("bneg.d",  80,  24, w10, w10, w21);
   TEST_3R("bneg.d",  88, 168, w11, w4,  w23);
   TEST_3R("bneg.d",  96, 168, w12, w4,  w27);
   TEST_3R("bneg.d", 104,  40, w13, w24, w23);
   TEST_3R("bneg.d", 112, 208, w14, w24, w28);
   TEST_3R("bneg.d", 120,  96, w15, w0,  w26);
   TEST_3R("bneg.d", 128, 160, w16, w1,  w4);
   TEST_3R("bneg.d", 136, 152, w17, w14, w0);
   TEST_3R("bneg.d", 144, 168, w18, w14, w16);
   TEST_3R("bneg.d", 152,  56, w19, w1,  w25);
   TEST_3R("bneg.d", 160, 176, w20, w13, w30);
   TEST_3R("bneg.d", 168, 120, w21, w12, w3);
   TEST_3R("bneg.d", 176, 192, w22, w7,  w5);
   TEST_3R("bneg.d", 184, 112, w23, w31, w29);
   TEST_3R("bneg.d", 192,  80, w24, w23, w25);
   TEST_3R("bneg.d", 200,  48, w25, w24, w20);
   TEST_3R("bneg.d", 208, 208, w26, w25, w24);
   TEST_3R("bneg.d", 216, 232, w27, w7,  w24);
   TEST_3R("bneg.d", 224, 168, w28, w22, w8);
   TEST_3R("bneg.d", 232,  96, w29, w23, w1);
   TEST_3R("bneg.d", 240, 192, w30, w4,  w4);
   TEST_3R("bneg.d",  32,  96, w31, w27, w17);
   TEST_3R("bset.b",   0, 168, w0,  w10, w8);
   TEST_3R("bset.b",   8,  80, w1,  w12, w25);
   TEST_3R("bset.b",  16,  72, w2,  w12, w18);
   TEST_3R("bset.b",  24, 208, w3,  w16, w26);
   TEST_3R("bset.b",  32,  72, w4,  w15, w16);
   TEST_3R("bset.b",  40, 224, w5,  w24, w7);
   TEST_3R("bset.b",  48,  48, w6,  w0,  w12);
   TEST_3R("bset.b",  56,  16, w7,  w27, w29);
   TEST_3R("bset.b",  64, 168, w8,  w0,  w21);
   TEST_3R("bset.b",  72, 176, w9,  w11, w16);
   TEST_3R("bset.b",  80,  40, w10, w10, w19);
   TEST_3R("bset.b",  88, 128, w11, w9,  w11);
   TEST_3R("bset.b",  96, 216, w12, w8,  w2);
   TEST_3R("bset.b", 104, 168, w13, w20, w21);
   TEST_3R("bset.b", 112, 136, w14, w4,  w15);
   TEST_3R("bset.b", 120, 216, w15, w20, w31);
   TEST_3R("bset.b", 128,  72, w16, w12, w6);
   TEST_3R("bset.b", 136, 120, w17, w12, w18);
   TEST_3R("bset.b", 144, 136, w18, w7,  w15);
   TEST_3R("bset.b", 152, 184, w19, w8,  w4);
   TEST_3R("bset.b", 160,   0, w20, w19, w21);
   TEST_3R("bset.b", 168, 104, w21, w7,  w17);
   TEST_3R("bset.b", 176,  48, w22, w28, w25);
   TEST_3R("bset.b", 184,   0, w23, w6,  w13);
   TEST_3R("bset.b", 192, 200, w24, w24, w24);
   TEST_3R("bset.b", 200, 216, w25, w18, w20);
   TEST_3R("bset.b", 208,  72, w26, w6,  w19);
   TEST_3R("bset.b", 216,  56, w27, w18, w18);
   TEST_3R("bset.b", 224, 120, w28, w5,  w31);
   TEST_3R("bset.b", 232, 152, w29, w18, w6);
   TEST_3R("bset.b", 240, 128, w30, w17, w14);
   TEST_3R("bset.b", 112, 208, w31, w14, w2);
   TEST_3R("bset.h",   0, 224, w0,  w9,  w6);
   TEST_3R("bset.h",   8, 144, w1,  w5,  w31);
   TEST_3R("bset.h",  16, 144, w2,  w11, w12);
   TEST_3R("bset.h",  24, 216, w3,  w10, w30);
   TEST_3R("bset.h",  32, 168, w4,  w6,  w28);
   TEST_3R("bset.h",  40,  80, w5,  w23, w22);
   TEST_3R("bset.h",  48, 224, w6,  w22, w2);
   TEST_3R("bset.h",  56, 152, w7,  w28, w29);
   TEST_3R("bset.h",  64,  16, w8,  w11, w29);
   TEST_3R("bset.h",  72, 136, w9,  w13, w18);
   TEST_3R("bset.h",  80, 120, w10, w10, w22);
   TEST_3R("bset.h",  88,  40, w11, w26, w11);
   TEST_3R("bset.h",  96,  80, w12, w23, w11);
   TEST_3R("bset.h", 104, 208, w13, w4,  w0);
   TEST_3R("bset.h", 112,  64, w14, w2,  w10);
   TEST_3R("bset.h", 120, 112, w15, w7,  w6);
   TEST_3R("bset.h", 128, 200, w16, w30, w28);
   TEST_3R("bset.h", 136,  64, w17, w20, w30);
   TEST_3R("bset.h", 144, 216, w18, w16, w28);
   TEST_3R("bset.h", 152, 112, w19, w27, w25);
   TEST_3R("bset.h", 160, 120, w20, w8,  w12);
   TEST_3R("bset.h", 168, 112, w21, w30, w4);
   TEST_3R("bset.h", 176,  16, w22, w25, w28);
   TEST_3R("bset.h", 184,   0, w23, w0,  w2);
   TEST_3R("bset.h", 192, 208, w24, w24, w24);
   TEST_3R("bset.h", 200,  56, w25, w12, w7);
   TEST_3R("bset.h", 208, 128, w26, w18, w14);
   TEST_3R("bset.h", 216, 136, w27, w15, w15);
   TEST_3R("bset.h", 224, 200, w28, w27, w13);
   TEST_3R("bset.h", 232,  48, w29, w12, w9);
   TEST_3R("bset.h", 240, 168, w30, w7,  w3);
   TEST_3R("bset.h", 152, 160, w31, w16, w15);
   TEST_3R("bset.w",   0, 232, w0,  w19, w27);
   TEST_3R("bset.w",   8,  24, w1,  w15, w29);
   TEST_3R("bset.w",  16,  24, w2,  w15, w31);
   TEST_3R("bset.w",  24, 208, w3,  w18, w11);
   TEST_3R("bset.w",  32,  24, w4,  w27, w29);
   TEST_3R("bset.w",  40, 160, w5,  w3,  w12);
   TEST_3R("bset.w",  48, 128, w6,  w30, w26);
   TEST_3R("bset.w",  56,  56, w7,  w10, w3);
   TEST_3R("bset.w",  64,  96, w8,  w18, w6);
   TEST_3R("bset.w",  72,  24, w9,  w2,  w21);
   TEST_3R("bset.w",  80, 216, w10, w10, w16);
   TEST_3R("bset.w",  88, 232, w11, w20, w11);
   TEST_3R("bset.w",  96,  16, w12, w24, w17);
   TEST_3R("bset.w", 104,  40, w13, w8,  w16);
   TEST_3R("bset.w", 112,   8, w14, w26, w27);
   TEST_3R("bset.w", 120, 144, w15, w21, w24);
   TEST_3R("bset.w", 128,  72, w16, w24, w5);
   TEST_3R("bset.w", 136,  80, w17, w23, w31);
   TEST_3R("bset.w", 144, 136, w18, w1,  w2);
   TEST_3R("bset.w", 152,  48, w19, w9,  w0);
   TEST_3R("bset.w", 160,  48, w20, w30, w24);
   TEST_3R("bset.w", 168, 152, w21, w7,  w12);
   TEST_3R("bset.w", 176,  40, w22, w0,  w29);
   TEST_3R("bset.w", 184, 200, w23, w8,  w13);
   TEST_3R("bset.w", 192,  64, w24, w24, w24);
   TEST_3R("bset.w", 200, 128, w25, w8,  w17);
   TEST_3R("bset.w", 208, 144, w26, w1,  w24);
   TEST_3R("bset.w", 216,  64, w27, w6,  w6);
   TEST_3R("bset.w", 224, 152, w28, w7,  w5);
   TEST_3R("bset.w", 232,  48, w29, w8,  w7);
   TEST_3R("bset.w", 240, 160, w30, w28, w16);
   TEST_3R("bset.w", 160, 184, w31, w17, w15);
   TEST_3R("bset.d",   0, 192, w0,  w22, w10);
   TEST_3R("bset.d",   8,   0, w1,  w22, w7);
   TEST_3R("bset.d",  16, 200, w2,  w30, w21);
   TEST_3R("bset.d",  24, 152, w3,  w0,  w29);
   TEST_3R("bset.d",  32, 144, w4,  w24, w30);
   TEST_3R("bset.d",  40,  88, w5,  w8,  w4);
   TEST_3R("bset.d",  48,   0, w6,  w15, w9);
   TEST_3R("bset.d",  56, 168, w7,  w23, w17);
   TEST_3R("bset.d",  64, 200, w8,  w19, w1);
   TEST_3R("bset.d",  72, 152, w9,  w5,  w16);
   TEST_3R("bset.d",  80, 144, w10, w10, w28);
   TEST_3R("bset.d",  88,  96, w11, w22, w11);
   TEST_3R("bset.d",  96, 208, w12, w29, w30);
   TEST_3R("bset.d", 104,  48, w13, w28, w19);
   TEST_3R("bset.d", 112, 208, w14, w28, w16);
   TEST_3R("bset.d", 120, 200, w15, w20, w8);
   TEST_3R("bset.d", 128,   8, w16, w19, w21);
   TEST_3R("bset.d", 136, 160, w17, w29, w26);
   TEST_3R("bset.d", 144,  16, w18, w14, w4);
   TEST_3R("bset.d", 152,  48, w19, w15, w27);
   TEST_3R("bset.d", 160,  64, w20, w31, w24);
   TEST_3R("bset.d", 168, 112, w21, w22, w10);
   TEST_3R("bset.d", 176, 112, w22, w20, w18);
   TEST_3R("bset.d", 184, 120, w23, w7,  w6);
   TEST_3R("bset.d", 192, 144, w24, w24, w24);
   TEST_3R("bset.d", 200, 224, w25, w17, w6);
   TEST_3R("bset.d", 208, 120, w26, w14, w22);
   TEST_3R("bset.d", 216,  32, w27, w23, w23);
   TEST_3R("bset.d", 224,  64, w28, w5,  w20);
   TEST_3R("bset.d", 232,  56, w29, w20, w7);
   TEST_3R("bset.d", 240, 192, w30, w20, w7);
   TEST_3R("bset.d", 128,  64, w31, w27, w29);
   TEST_3R("sll.b",   0, 120, w0,  w9,  w0);
   TEST_3R("sll.b",   8, 152, w1,  w15, w2);
   TEST_3R("sll.b",  16, 152, w2,  w22, w4);
   TEST_3R("sll.b",  24,  72, w3,  w3,  w16);
   TEST_3R("sll.b",  32, 104, w4,  w22, w7);
   TEST_3R("sll.b",  40,   8, w5,  w19, w12);
   TEST_3R("sll.b",  48, 192, w6,  w0,  w7);
   TEST_3R("sll.b",  56,  24, w7,  w21, w14);
   TEST_3R("sll.b",  64,  88, w8,  w16, w11);
   TEST_3R("sll.b",  72, 232, w9,  w16, w28);
   TEST_3R("sll.b",  80,  40, w10, w17, w20);
   TEST_3R("sll.b",  88,  72, w11, w14, w3);
   TEST_3R("sll.b",  96,  72, w12, w29, w25);
   TEST_3R("sll.b", 104, 152, w13, w26, w9);
   TEST_3R("sll.b", 112, 128, w14, w17, w16);
   TEST_3R("sll.b", 120, 144, w15, w4,  w28);
   TEST_3R("sll.b", 128,  40, w16, w10, w29);
   TEST_3R("sll.b", 136, 136, w17, w17, w17);
   TEST_3R("sll.b", 144, 160, w18, w25, w2);
   TEST_3R("sll.b", 152,   0, w19, w5,  w0);
   TEST_3R("sll.b", 160, 144, w20, w4,  w13);
   TEST_3R("sll.b", 168,  64, w21, w23, w8);
   TEST_3R("sll.b", 176, 136, w22, w17, w7);
   TEST_3R("sll.b", 184, 120, w23, w26, w0);
   TEST_3R("sll.b", 192, 224, w24, w11, w11);
   TEST_3R("sll.b", 200,   8, w25, w31, w7);
   TEST_3R("sll.b", 208, 160, w26, w9,  w4);
   TEST_3R("sll.b", 216, 104, w27, w8,  w22);
   TEST_3R("sll.b", 224, 144, w28, w1,  w25);
   TEST_3R("sll.b", 232, 224, w29, w7,  w12);
   TEST_3R("sll.b", 240,  80, w30, w27, w16);
   TEST_3R("sll.b", 224,  72, w31, w8,  w2);
   TEST_3R("sll.h",   0, 216, w0,  w18, w0);
   TEST_3R("sll.h",   8, 104, w1,  w23, w29);
   TEST_3R("sll.h",  16, 232, w2,  w24, w19);
   TEST_3R("sll.h",  24, 200, w3,  w3,  w24);
   TEST_3R("sll.h",  32, 200, w4,  w6,  w1);
   TEST_3R("sll.h",  40,  96, w5,  w26, w9);
   TEST_3R("sll.h",  48, 232, w6,  w7,  w11);
   TEST_3R("sll.h",  56, 152, w7,  w24, w18);
   TEST_3R("sll.h",  64,  72, w8,  w9,  w13);
   TEST_3R("sll.h",  72, 136, w9,  w14, w22);
   TEST_3R("sll.h",  80,  40, w10, w6,  w31);
   TEST_3R("sll.h",  88, 144, w11, w30, w28);
   TEST_3R("sll.h",  96, 112, w12, w22, w21);
   TEST_3R("sll.h", 104, 216, w13, w19, w25);
   TEST_3R("sll.h", 112,  88, w14, w12, w19);
   TEST_3R("sll.h", 120,  16, w15, w2,  w26);
   TEST_3R("sll.h", 128, 152, w16, w18, w21);
   TEST_3R("sll.h", 136,   8, w17, w17, w17);
   TEST_3R("sll.h", 144, 232, w18, w2,  w21);
   TEST_3R("sll.h", 152, 176, w19, w24, w2);
   TEST_3R("sll.h", 160,  88, w20, w31, w2);
   TEST_3R("sll.h", 168, 104, w21, w29, w30);
   TEST_3R("sll.h", 176, 176, w22, w19, w30);
   TEST_3R("sll.h", 184,  40, w23, w0,  w12);
   TEST_3R("sll.h", 192, 184, w24, w15, w15);
   TEST_3R("sll.h", 200,  72, w25, w18, w7);
   TEST_3R("sll.h", 208,  72, w26, w12, w10);
   TEST_3R("sll.h", 216, 224, w27, w30, w31);
   TEST_3R("sll.h", 224,  88, w28, w25, w1);
   TEST_3R("sll.h", 232, 200, w29, w2,  w26);
   TEST_3R("sll.h", 240, 224, w30, w21, w25);
   TEST_3R("sll.h", 216,  40, w31, w1,  w22);
   TEST_3R("sll.w",   0,  32, w0,  w9,  w0);
   TEST_3R("sll.w",   8, 160, w1,  w11, w15);
   TEST_3R("sll.w",  16,  32, w2,  w23, w14);
   TEST_3R("sll.w",  24, 160, w3,  w3,  w15);
   TEST_3R("sll.w",  32,  24, w4,  w24, w10);
   TEST_3R("sll.w",  40, 120, w5,  w2,  w21);
   TEST_3R("sll.w",  48,  96, w6,  w1,  w11);
   TEST_3R("sll.w",  56, 192, w7,  w3,  w22);
   TEST_3R("sll.w",  64, 216, w8,  w29, w4);
   TEST_3R("sll.w",  72,  88, w9,  w22, w20);
   TEST_3R("sll.w",  80, 184, w10, w12, w3);
   TEST_3R("sll.w",  88, 128, w11, w21, w5);
   TEST_3R("sll.w",  96, 120, w12, w4,  w7);
   TEST_3R("sll.w", 104, 168, w13, w18, w25);
   TEST_3R("sll.w", 112,  48, w14, w18, w17);
   TEST_3R("sll.w", 120,   8, w15, w30, w20);
   TEST_3R("sll.w", 128, 176, w16, w8,  w21);
   TEST_3R("sll.w", 136, 200, w17, w17, w17);
   TEST_3R("sll.w", 144,  32, w18, w24, w26);
   TEST_3R("sll.w", 152,   8, w19, w21, w30);
   TEST_3R("sll.w", 160, 208, w20, w11, w19);
   TEST_3R("sll.w", 168,  24, w21, w23, w22);
   TEST_3R("sll.w", 176, 160, w22, w12, w27);
   TEST_3R("sll.w", 184, 152, w23, w16, w2);
   TEST_3R("sll.w", 192, 152, w24, w2,  w2);
   TEST_3R("sll.w", 200, 232, w25, w4,  w20);
   TEST_3R("sll.w", 208,  16, w26, w8,  w18);
   TEST_3R("sll.w", 216,  80, w27, w0,  w26);
   TEST_3R("sll.w", 224, 184, w28, w4,  w5);
   TEST_3R("sll.w", 232,  16, w29, w30, w21);
   TEST_3R("sll.w", 240, 224, w30, w28, w0);
   TEST_3R("sll.w", 160, 224, w31, w15, w6);
   TEST_3R("sll.d",   0, 144, w0,  w20, w0);
   TEST_3R("sll.d",   8,  16, w1,  w0,  w21);
   TEST_3R("sll.d",  16,  48, w2,  w3,  w0);
   TEST_3R("sll.d",  24, 224, w3,  w3,  w30);
   TEST_3R("sll.d",  32, 232, w4,  w27, w11);
   TEST_3R("sll.d",  40,   8, w5,  w14, w12);
   TEST_3R("sll.d",  48,  80, w6,  w8,  w3);
   TEST_3R("sll.d",  56, 216, w7,  w14, w18);
   TEST_3R("sll.d",  64,  72, w8,  w3,  w22);
   TEST_3R("sll.d",  72,  72, w9,  w3,  w6);
   TEST_3R("sll.d",  80, 112, w10, w9,  w14);
   TEST_3R("sll.d",  88, 224, w11, w29, w2);
   TEST_3R("sll.d",  96,  16, w12, w18, w6);
   TEST_3R("sll.d", 104, 144, w13, w18, w2);
   TEST_3R("sll.d", 112, 224, w14, w9,  w3);
   TEST_3R("sll.d", 120, 200, w15, w26, w16);
   TEST_3R("sll.d", 128, 216, w16, w29, w1);
   TEST_3R("sll.d", 136,  72, w17, w17, w17);
   TEST_3R("sll.d", 144, 176, w18, w16, w17);
   TEST_3R("sll.d", 152, 136, w19, w28, w20);
   TEST_3R("sll.d", 160,  88, w20, w23, w30);
   TEST_3R("sll.d", 168,  56, w21, w23, w27);
   TEST_3R("sll.d", 176, 160, w22, w24, w14);
   TEST_3R("sll.d", 184, 208, w23, w28, w0);
   TEST_3R("sll.d", 192,  80, w24, w31, w31);
   TEST_3R("sll.d", 200,  32, w25, w13, w27);
   TEST_3R("sll.d", 208, 112, w26, w7,  w11);
   TEST_3R("sll.d", 216,  88, w27, w5,  w13);
   TEST_3R("sll.d", 224,  24, w28, w20, w29);
   TEST_3R("sll.d", 232,  16, w29, w26, w25);
   TEST_3R("sll.d", 240, 208, w30, w7,  w16);
   TEST_3R("sll.d",  72, 184, w31, w1,  w8);
   TEST_3R("sra.b",   0, 120, w0,  w0,  w0);
   TEST_3R("sra.b",   8, 120, w1,  w17, w1);
   TEST_3R("sra.b",  16,  72, w2,  w11, w9);
   TEST_3R("sra.b",  24, 104, w3,  w27, w16);
   TEST_3R("sra.b",  32, 112, w4,  w11, w21);
   TEST_3R("sra.b",  40,  96, w5,  w9,  w10);
   TEST_3R("sra.b",  48,   8, w6,  w23, w4);
   TEST_3R("sra.b",  56,  24, w7,  w26, w11);
   TEST_3R("sra.b",  64, 144, w8,  w27, w13);
   TEST_3R("sra.b",  72, 224, w9,  w24, w11);
   TEST_3R("sra.b",  80, 232, w10, w10, w2);
   TEST_3R("sra.b",  88, 184, w11, w3,  w13);
   TEST_3R("sra.b",  96,  72, w12, w31, w16);
   TEST_3R("sra.b", 104, 104, w13, w8,  w4);
   TEST_3R("sra.b", 112, 216, w14, w22, w15);
   TEST_3R("sra.b", 120, 184, w15, w12, w24);
   TEST_3R("sra.b", 128,   8, w16, w0,  w28);
   TEST_3R("sra.b", 136,  40, w17, w10, w8);
   TEST_3R("sra.b", 144, 192, w18, w6,  w21);
   TEST_3R("sra.b", 152, 176, w19, w30, w0);
   TEST_3R("sra.b", 160, 232, w20, w0,  w12);
   TEST_3R("sra.b", 168,  40, w21, w14, w9);
   TEST_3R("sra.b", 176, 160, w22, w30, w18);
   TEST_3R("sra.b", 184,  24, w23, w11, w22);
   TEST_3R("sra.b", 192, 112, w24, w2,  w5);
   TEST_3R("sra.b", 200, 168, w25, w14, w30);
   TEST_3R("sra.b", 208,   8, w26, w14, w27);
   TEST_3R("sra.b", 216,  48, w27, w24, w3);
   TEST_3R("sra.b", 224, 112, w28, w30, w24);
   TEST_3R("sra.b", 232,  88, w29, w28, w28);
   TEST_3R("sra.b", 240, 208, w30, w12, w29);
   TEST_3R("sra.b",  72, 152, w31, w5,  w11);
   TEST_3R("sra.h",   0, 216, w0,  w0,  w0);
   TEST_3R("sra.h",   8, 232, w1,  w31, w1);
   TEST_3R("sra.h",  16, 128, w2,  w20, w21);
   TEST_3R("sra.h",  24, 120, w3,  w22, w27);
   TEST_3R("sra.h",  32,  56, w4,  w5,  w25);
   TEST_3R("sra.h",  40,  32, w5,  w19, w7);
   TEST_3R("sra.h",  48, 104, w6,  w15, w31);
   TEST_3R("sra.h",  56,  64, w7,  w21, w30);
   TEST_3R("sra.h",  64,  24, w8,  w11, w26);
   TEST_3R("sra.h",  72,   8, w9,  w23, w12);
   TEST_3R("sra.h",  80,  24, w10, w10, w2);
   TEST_3R("sra.h",  88, 224, w11, w25, w22);
   TEST_3R("sra.h",  96, 208, w12, w15, w11);
   TEST_3R("sra.h", 104,  72, w13, w10, w7);
   TEST_3R("sra.h", 112, 168, w14, w3,  w2);
   TEST_3R("sra.h", 120, 152, w15, w10, w23);
   TEST_3R("sra.h", 128,  48, w16, w9,  w19);
   TEST_3R("sra.h", 136,  80, w17, w0,  w30);
   TEST_3R("sra.h", 144, 200, w18, w9,  w21);
   TEST_3R("sra.h", 152, 168, w19, w21, w17);
   TEST_3R("sra.h", 160,   0, w20, w15, w10);
   TEST_3R("sra.h", 168,  96, w21, w9,  w0);
   TEST_3R("sra.h", 176, 184, w22, w24, w11);
   TEST_3R("sra.h", 184, 136, w23, w2,  w19);
   TEST_3R("sra.h", 192, 184, w24, w5,  w21);
   TEST_3R("sra.h", 200,  96, w25, w15, w12);
   TEST_3R("sra.h", 208,  40, w26, w24, w28);
   TEST_3R("sra.h", 216, 128, w27, w0,  w29);
   TEST_3R("sra.h", 224, 184, w28, w2,  w6);
   TEST_3R("sra.h", 232, 216, w29, w27, w27);
   TEST_3R("sra.h", 240, 104, w30, w29, w23);
   TEST_3R("sra.h",  48, 128, w31, w7,  w20);
   TEST_3R("sra.w",   0,   8, w0,  w0,  w0);
   TEST_3R("sra.w",   8, 112, w1,  w19, w1);
   TEST_3R("sra.w",  16,   8, w2,  w14, w6);
   TEST_3R("sra.w",  24, 192, w3,  w19, w27);
   TEST_3R("sra.w",  32, 168, w4,  w2,  w7);
   TEST_3R("sra.w",  40, 208, w5,  w26, w4);
   TEST_3R("sra.w",  48, 216, w6,  w26, w1);
   TEST_3R("sra.w",  56,  40, w7,  w28, w10);
   TEST_3R("sra.w",  64, 200, w8,  w2,  w15);
   TEST_3R("sra.w",  72, 144, w9,  w15, w14);
   TEST_3R("sra.w",  80, 224, w10, w10, w23);
   TEST_3R("sra.w",  88, 216, w11, w13, w10);
   TEST_3R("sra.w",  96,  96, w12, w27, w16);
   TEST_3R("sra.w", 104,  56, w13, w14, w11);
   TEST_3R("sra.w", 112, 104, w14, w16, w18);
   TEST_3R("sra.w", 120, 192, w15, w11, w22);
   TEST_3R("sra.w", 128,  40, w16, w5,  w23);
   TEST_3R("sra.w", 136,  88, w17, w2,  w30);
   TEST_3R("sra.w", 144, 144, w18, w26, w1);
   TEST_3R("sra.w", 152, 224, w19, w9,  w14);
   TEST_3R("sra.w", 160,  72, w20, w24, w16);
   TEST_3R("sra.w", 168, 112, w21, w13, w29);
   TEST_3R("sra.w", 176,   0, w22, w6,  w25);
   TEST_3R("sra.w", 184,  24, w23, w30, w7);
   TEST_3R("sra.w", 192,  16, w24, w28, w0);
   TEST_3R("sra.w", 200,  88, w25, w3,  w22);
   TEST_3R("sra.w", 208, 136, w26, w8,  w14);
   TEST_3R("sra.w", 216, 224, w27, w10, w12);
   TEST_3R("sra.w", 224,   0, w28, w4,  w13);
   TEST_3R("sra.w", 232,  56, w29, w14, w14);
   TEST_3R("sra.w", 240,  56, w30, w21, w6);
   TEST_3R("sra.w", 160, 216, w31, w30, w19);
   TEST_3R("sra.d",   0, 184, w0,  w0,  w0);
   TEST_3R("sra.d",   8, 160, w1,  w2,  w1);
   TEST_3R("sra.d",  16, 192, w2,  w23, w10);
   TEST_3R("sra.d",  24,   0, w3,  w19, w2);
   TEST_3R("sra.d",  32,  80, w4,  w26, w5);
   TEST_3R("sra.d",  40, 208, w5,  w19, w13);
   TEST_3R("sra.d",  48, 144, w6,  w27, w24);
   TEST_3R("sra.d",  56, 216, w7,  w29, w28);
   TEST_3R("sra.d",  64, 152, w8,  w1,  w10);
   TEST_3R("sra.d",  72, 208, w9,  w22, w16);
   TEST_3R("sra.d",  80, 128, w10, w10, w20);
   TEST_3R("sra.d",  88, 184, w11, w16, w5);
   TEST_3R("sra.d",  96, 224, w12, w19, w24);
   TEST_3R("sra.d", 104,  56, w13, w29, w24);
   TEST_3R("sra.d", 112, 144, w14, w31, w25);
   TEST_3R("sra.d", 120,  80, w15, w4,  w16);
   TEST_3R("sra.d", 128,  32, w16, w17, w21);
   TEST_3R("sra.d", 136, 200, w17, w9,  w6);
   TEST_3R("sra.d", 144, 136, w18, w6,  w5);
   TEST_3R("sra.d", 152, 176, w19, w16, w0);
   TEST_3R("sra.d", 160,  24, w20, w1,  w7);
   TEST_3R("sra.d", 168,  24, w21, w4,  w24);
   TEST_3R("sra.d", 176, 192, w22, w1,  w11);
   TEST_3R("sra.d", 184,  56, w23, w22, w8);
   TEST_3R("sra.d", 192, 168, w24, w30, w7);
   TEST_3R("sra.d", 200, 232, w25, w0,  w11);
   TEST_3R("sra.d", 208, 136, w26, w22, w28);
   TEST_3R("sra.d", 216,  64, w27, w6,  w19);
   TEST_3R("sra.d", 224, 208, w28, w12, w25);
   TEST_3R("sra.d", 232,  56, w29, w28, w28);
   TEST_3R("sra.d", 240,  96, w30, w7,  w29);
   TEST_3R("sra.d",  72,  72, w31, w1,  w2);
   TEST_3R("srar.b",   0,  48, w0,  w12, w5);
   TEST_3R("srar.b",   8,  40, w1,  w19, w13);
   TEST_3R("srar.b",  16, 104, w2,  w30, w5);
   TEST_3R("srar.b",  24, 168, w3,  w3,  w3);
   TEST_3R("srar.b",  32, 208, w4,  w4,  w18);
   TEST_3R("srar.b",  40, 152, w5,  w0,  w8);
   TEST_3R("srar.b",  48,  72, w6,  w30, w11);
   TEST_3R("srar.b",  56, 208, w7,  w24, w18);
   TEST_3R("srar.b",  64, 216, w8,  w25, w19);
   TEST_3R("srar.b",  72, 152, w9,  w18, w19);
   TEST_3R("srar.b",  80, 112, w10, w22, w9);
   TEST_3R("srar.b",  88, 168, w11, w2,  w14);
   TEST_3R("srar.b",  96, 208, w12, w21, w27);
   TEST_3R("srar.b", 104,  80, w13, w19, w0);
   TEST_3R("srar.b", 112, 160, w14, w13, w18);
   TEST_3R("srar.b", 120,  80, w15, w14, w23);
   TEST_3R("srar.b", 128, 200, w16, w26, w22);
   TEST_3R("srar.b", 136, 216, w17, w3,  w14);
   TEST_3R("srar.b", 144,  48, w18, w10, w7);
   TEST_3R("srar.b", 152,  64, w19, w18, w25);
   TEST_3R("srar.b", 160, 104, w20, w30, w15);
   TEST_3R("srar.b", 168, 232, w21, w4,  w17);
   TEST_3R("srar.b", 176, 192, w22, w1,  w22);
   TEST_3R("srar.b", 184,  32, w23, w22, w25);
   TEST_3R("srar.b", 192,  72, w24, w25, w6);
   TEST_3R("srar.b", 200, 192, w25, w16, w16);
   TEST_3R("srar.b", 208, 136, w26, w31, w16);
   TEST_3R("srar.b", 216, 160, w27, w21, w18);
   TEST_3R("srar.b", 224, 184, w28, w25, w10);
   TEST_3R("srar.b", 232, 120, w29, w15, w3);
   TEST_3R("srar.b", 240, 232, w30, w13, w18);
   TEST_3R("srar.b",  16, 224, w31, w17, w3);
   TEST_3R("srar.h",   0,  24, w0,  w9,  w12);
   TEST_3R("srar.h",   8, 104, w1,  w2,  w9);
   TEST_3R("srar.h",  16,  72, w2,  w18, w29);
   TEST_3R("srar.h",  24,  64, w3,  w3,  w3);
   TEST_3R("srar.h",  32, 120, w4,  w4,  w12);
   TEST_3R("srar.h",  40, 160, w5,  w30, w31);
   TEST_3R("srar.h",  48,  56, w6,  w23, w27);
   TEST_3R("srar.h",  56, 112, w7,  w1,  w10);
   TEST_3R("srar.h",  64,  48, w8,  w15, w24);
   TEST_3R("srar.h",  72, 176, w9,  w10, w6);
   TEST_3R("srar.h",  80, 168, w10, w28, w16);
   TEST_3R("srar.h",  88, 200, w11, w4,  w18);
   TEST_3R("srar.h",  96,  72, w12, w6,  w27);
   TEST_3R("srar.h", 104, 144, w13, w24, w25);
   TEST_3R("srar.h", 112, 144, w14, w26, w5);
   TEST_3R("srar.h", 120, 176, w15, w24, w4);
   TEST_3R("srar.h", 128,   0, w16, w15, w0);
   TEST_3R("srar.h", 136, 224, w17, w16, w10);
   TEST_3R("srar.h", 144,  32, w18, w31, w2);
   TEST_3R("srar.h", 152,  88, w19, w9,  w12);
   TEST_3R("srar.h", 160, 104, w20, w9,  w8);
   TEST_3R("srar.h", 168,  32, w21, w12, w3);
   TEST_3R("srar.h", 176,  24, w22, w8,  w22);
   TEST_3R("srar.h", 184,  40, w23, w10, w1);
   TEST_3R("srar.h", 192,  56, w24, w5,  w6);
   TEST_3R("srar.h", 200,   8, w25, w29, w29);
   TEST_3R("srar.h", 208,  72, w26, w0,  w13);
   TEST_3R("srar.h", 216,  48, w27, w16, w29);
   TEST_3R("srar.h", 224, 168, w28, w17, w29);
   TEST_3R("srar.h", 232, 160, w29, w20, w6);
   TEST_3R("srar.h", 240, 200, w30, w16, w12);
   TEST_3R("srar.h", 168, 176, w31, w5,  w24);
   TEST_3R("srar.w",   0,  64, w0,  w11, w13);
   TEST_3R("srar.w",   8, 112, w1,  w21, w14);
   TEST_3R("srar.w",  16,  40, w2,  w26, w20);
   TEST_3R("srar.w",  24, 152, w3,  w3,  w3);
   TEST_3R("srar.w",  32, 152, w4,  w4,  w31);
   TEST_3R("srar.w",  40,  16, w5,  w10, w16);
   TEST_3R("srar.w",  48,  56, w6,  w0,  w1);
   TEST_3R("srar.w",  56, 224, w7,  w24, w21);
   TEST_3R("srar.w",  64,  96, w8,  w28, w20);
   TEST_3R("srar.w",  72,  72, w9,  w8,  w12);
   TEST_3R("srar.w",  80, 112, w10, w0,  w17);
   TEST_3R("srar.w",  88, 144, w11, w30, w9);
   TEST_3R("srar.w",  96,  48, w12, w10, w27);
   TEST_3R("srar.w", 104, 112, w13, w9,  w19);
   TEST_3R("srar.w", 112,   8, w14, w9,  w24);
   TEST_3R("srar.w", 120, 184, w15, w25, w27);
   TEST_3R("srar.w", 128, 152, w16, w26, w3);
   TEST_3R("srar.w", 136, 128, w17, w0,  w31);
   TEST_3R("srar.w", 144, 176, w18, w22, w7);
   TEST_3R("srar.w", 152, 160, w19, w18, w7);
   TEST_3R("srar.w", 160, 208, w20, w22, w19);
   TEST_3R("srar.w", 168,  72, w21, w31, w20);
   TEST_3R("srar.w", 176,  72, w22, w10, w22);
   TEST_3R("srar.w", 184, 176, w23, w13, w19);
   TEST_3R("srar.w", 192, 184, w24, w14, w28);
   TEST_3R("srar.w", 200, 208, w25, w21, w21);
   TEST_3R("srar.w", 208,  48, w26, w4,  w15);
   TEST_3R("srar.w", 216, 112, w27, w7,  w31);
   TEST_3R("srar.w", 224,  40, w28, w6,  w2);
   TEST_3R("srar.w", 232,  24, w29, w13, w18);
   TEST_3R("srar.w", 240, 128, w30, w20, w16);
   TEST_3R("srar.w", 192,   8, w31, w20, w16);
   TEST_3R("srar.d",   0, 184, w0,  w26, w11);
   TEST_3R("srar.d",   8, 168, w1,  w13, w14);
   TEST_3R("srar.d",  16, 160, w2,  w10, w9);
   TEST_3R("srar.d",  24,  72, w3,  w3,  w3);
   TEST_3R("srar.d",  32, 216, w4,  w4,  w0);
   TEST_3R("srar.d",  40,  80, w5,  w15, w17);
   TEST_3R("srar.d",  48,  16, w6,  w14, w2);
   TEST_3R("srar.d",  56, 112, w7,  w16, w10);
   TEST_3R("srar.d",  64,  32, w8,  w3,  w4);
   TEST_3R("srar.d",  72, 168, w9,  w23, w21);
   TEST_3R("srar.d",  80,  56, w10, w11, w5);
   TEST_3R("srar.d",  88, 168, w11, w31, w21);
   TEST_3R("srar.d",  96,  80, w12, w3,  w21);
   TEST_3R("srar.d", 104,  40, w13, w10, w22);
   TEST_3R("srar.d", 112, 136, w14, w3,  w5);
   TEST_3R("srar.d", 120, 112, w15, w3,  w19);
   TEST_3R("srar.d", 128, 232, w16, w9,  w3);
   TEST_3R("srar.d", 136,   8, w17, w28, w6);
   TEST_3R("srar.d", 144,  48, w18, w4,  w29);
   TEST_3R("srar.d", 152, 104, w19, w8,  w9);
   TEST_3R("srar.d", 160, 232, w20, w8,  w19);
   TEST_3R("srar.d", 168, 120, w21, w22, w3);
   TEST_3R("srar.d", 176, 104, w22, w3,  w22);
   TEST_3R("srar.d", 184,  96, w23, w1,  w16);
   TEST_3R("srar.d", 192,  48, w24, w6,  w14);
   TEST_3R("srar.d", 200, 136, w25, w15, w15);
   TEST_3R("srar.d", 208,  72, w26, w29, w3);
   TEST_3R("srar.d", 216, 232, w27, w30, w1);
   TEST_3R("srar.d", 224,  16, w28, w17, w9);
   TEST_3R("srar.d", 232, 144, w29, w15, w0);
   TEST_3R("srar.d", 240,  56, w30, w11, w21);
   TEST_3R("srar.d", 136, 200, w31, w14, w0);
   TEST_3R("srl.b",   0, 184, w0,  w1,  w2);
   TEST_3R("srl.b",   8, 152, w1,  w31, w4);
   TEST_3R("srl.b",  16,  48, w2,  w2,  w2);
   TEST_3R("srl.b",  24,  64, w3,  w13, w24);
   TEST_3R("srl.b",  32,  56, w4,  w27, w9);
   TEST_3R("srl.b",  40,   8, w5,  w19, w24);
   TEST_3R("srl.b",  48, 192, w6,  w19, w26);
   TEST_3R("srl.b",  56, 224, w7,  w8,  w19);
   TEST_3R("srl.b",  64, 232, w8,  w15, w8);
   TEST_3R("srl.b",  72, 232, w9,  w10, w27);
   TEST_3R("srl.b",  80,  24, w10, w19, w22);
   TEST_3R("srl.b",  88,  72, w11, w21, w0);
   TEST_3R("srl.b",  96,  64, w12, w12, w20);
   TEST_3R("srl.b", 104,  32, w13, w5,  w22);
   TEST_3R("srl.b", 112, 104, w14, w29, w26);
   TEST_3R("srl.b", 120,  80, w15, w6,  w7);
   TEST_3R("srl.b", 128, 224, w16, w31, w17);
   TEST_3R("srl.b", 136, 216, w17, w25, w7);
   TEST_3R("srl.b", 144, 176, w18, w12, w10);
   TEST_3R("srl.b", 152, 152, w19, w27, w9);
   TEST_3R("srl.b", 160,  80, w20, w23, w21);
   TEST_3R("srl.b", 168, 176, w21, w13, w1);
   TEST_3R("srl.b", 176, 136, w22, w14, w13);
   TEST_3R("srl.b", 184, 128, w23, w18, w1);
   TEST_3R("srl.b", 192, 112, w24, w15, w27);
   TEST_3R("srl.b", 200, 192, w25, w21, w2);
   TEST_3R("srl.b", 208,  48, w26, w20, w19);
   TEST_3R("srl.b", 216, 184, w27, w14, w14);
   TEST_3R("srl.b", 224, 128, w28, w1,  w26);
   TEST_3R("srl.b", 232,  72, w29, w5,  w22);
   TEST_3R("srl.b", 240,  16, w30, w20, w13);
   TEST_3R("srl.b",  24, 208, w31, w21, w26);
   TEST_3R("srl.h",   0,  32, w0,  w8,  w18);
   TEST_3R("srl.h",   8, 160, w1,  w27, w4);
   TEST_3R("srl.h",  16, 216, w2,  w2,  w2);
   TEST_3R("srl.h",  24,  96, w3,  w19, w18);
   TEST_3R("srl.h",  32, 160, w4,  w8,  w20);
   TEST_3R("srl.h",  40, 216, w5,  w29, w8);
   TEST_3R("srl.h",  48, 120, w6,  w11, w2);
   TEST_3R("srl.h",  56,  88, w7,  w5,  w17);
   TEST_3R("srl.h",  64,  80, w8,  w22, w8);
   TEST_3R("srl.h",  72, 168, w9,  w8,  w25);
   TEST_3R("srl.h",  80,  64, w10, w3,  w30);
   TEST_3R("srl.h",  88,  80, w11, w16, w29);
   TEST_3R("srl.h",  96, 144, w12, w12, w20);
   TEST_3R("srl.h", 104,  16, w13, w6,  w7);
   TEST_3R("srl.h", 112, 104, w14, w23, w16);
   TEST_3R("srl.h", 120, 160, w15, w27, w13);
   TEST_3R("srl.h", 128, 160, w16, w5,  w24);
   TEST_3R("srl.h", 136, 128, w17, w29, w13);
   TEST_3R("srl.h", 144, 208, w18, w25, w3);
   TEST_3R("srl.h", 152,  16, w19, w1,  w29);
   TEST_3R("srl.h", 160,  88, w20, w4,  w27);
   TEST_3R("srl.h", 168, 176, w21, w16, w12);
   TEST_3R("srl.h", 176, 152, w22, w0,  w25);
   TEST_3R("srl.h", 184,  64, w23, w8,  w0);
   TEST_3R("srl.h", 192, 128, w24, w28, w15);
   TEST_3R("srl.h", 200,  24, w25, w31, w21);
   TEST_3R("srl.h", 208, 136, w26, w5,  w6);
   TEST_3R("srl.h", 216, 232, w27, w19, w19);
   TEST_3R("srl.h", 224, 200, w28, w19, w22);
   TEST_3R("srl.h", 232,  96, w29, w21, w19);
   TEST_3R("srl.h", 240,  56, w30, w25, w15);
   TEST_3R("srl.h", 112, 232, w31, w9,  w27);
   TEST_3R("srl.w",   0, 136, w0,  w27, w23);
   TEST_3R("srl.w",   8, 208, w1,  w3,  w23);
   TEST_3R("srl.w",  16,   8, w2,  w2,  w2);
   TEST_3R("srl.w",  24,  16, w3,  w19, w0);
   TEST_3R("srl.w",  32,  40, w4,  w19, w21);
   TEST_3R("srl.w",  40,  56, w5,  w24, w27);
   TEST_3R("srl.w",  48,  24, w6,  w11, w3);
   TEST_3R("srl.w",  56,  16, w7,  w2,  w18);
   TEST_3R("srl.w",  64, 192, w8,  w21, w8);
   TEST_3R("srl.w",  72, 120, w9,  w26, w4);
   TEST_3R("srl.w",  80, 120, w10, w3,  w31);
   TEST_3R("srl.w",  88, 184, w11, w3,  w27);
   TEST_3R("srl.w",  96,  56, w12, w12, w0);
   TEST_3R("srl.w", 104,  72, w13, w7,  w16);
   TEST_3R("srl.w", 112, 200, w14, w26, w16);
   TEST_3R("srl.w", 120,   8, w15, w13, w5);
   TEST_3R("srl.w", 128, 176, w16, w6,  w0);
   TEST_3R("srl.w", 136, 112, w17, w3,  w27);
   TEST_3R("srl.w", 144,   8, w18, w21, w28);
   TEST_3R("srl.w", 152, 104, w19, w24, w22);
   TEST_3R("srl.w", 160, 200, w20, w19, w25);
   TEST_3R("srl.w", 168, 200, w21, w11, w29);
   TEST_3R("srl.w", 176, 128, w22, w27, w29);
   TEST_3R("srl.w", 184, 208, w23, w2,  w13);
   TEST_3R("srl.w", 192, 168, w24, w28, w30);
   TEST_3R("srl.w", 200,  48, w25, w10, w3);
   TEST_3R("srl.w", 208, 224, w26, w16, w4);
   TEST_3R("srl.w", 216, 128, w27, w1,  w1);
   TEST_3R("srl.w", 224, 152, w28, w30, w21);
   TEST_3R("srl.w", 232, 112, w29, w26, w30);
   TEST_3R("srl.w", 240, 200, w30, w16, w11);
   TEST_3R("srl.w",  64, 160, w31, w10, w24);
   TEST_3R("srl.d",   0,  32, w0,  w14, w4);
   TEST_3R("srl.d",   8, 112, w1,  w16, w17);
   TEST_3R("srl.d",  16,  24, w2,  w2,  w2);
   TEST_3R("srl.d",  24,  96, w3,  w15, w2);
   TEST_3R("srl.d",  32,   0, w4,  w19, w21);
   TEST_3R("srl.d",  40,   8, w5,  w23, w24);
   TEST_3R("srl.d",  48, 120, w6,  w30, w23);
   TEST_3R("srl.d",  56, 120, w7,  w27, w17);
   TEST_3R("srl.d",  64, 176, w8,  w16, w8);
   TEST_3R("srl.d",  72,  88, w9,  w7,  w24);
   TEST_3R("srl.d",  80,  32, w10, w31, w12);
   TEST_3R("srl.d",  88,  48, w11, w0,  w26);
   TEST_3R("srl.d",  96, 232, w12, w12, w7);
   TEST_3R("srl.d", 104,  24, w13, w8,  w14);
   TEST_3R("srl.d", 112, 232, w14, w24, w17);
   TEST_3R("srl.d", 120, 112, w15, w11, w6);
   TEST_3R("srl.d", 128, 120, w16, w2,  w31);
   TEST_3R("srl.d", 136, 120, w17, w0,  w22);
   TEST_3R("srl.d", 144, 112, w18, w28, w7);
   TEST_3R("srl.d", 152, 216, w19, w12, w9);
   TEST_3R("srl.d", 160,  24, w20, w5,  w21);
   TEST_3R("srl.d", 168,  88, w21, w17, w8);
   TEST_3R("srl.d", 176, 192, w22, w11, w31);
   TEST_3R("srl.d", 184, 160, w23, w22, w8);
   TEST_3R("srl.d", 192, 160, w24, w14, w0);
   TEST_3R("srl.d", 200,   8, w25, w29, w11);
   TEST_3R("srl.d", 208,  40, w26, w19, w13);
   TEST_3R("srl.d", 216, 152, w27, w18, w18);
   TEST_3R("srl.d", 224,  72, w28, w0,  w14);
   TEST_3R("srl.d", 232,  64, w29, w7,  w5);
   TEST_3R("srl.d", 240, 216, w30, w17, w4);
   TEST_3R("srl.d", 232,  72, w31, w6,  w2);
   TEST_3R("srlr.b",   0, 168, w0,  w0,  w0);
   TEST_3R("srlr.b",   8, 168, w1,  w22, w24);
   TEST_3R("srlr.b",  16, 168, w2,  w22, w29);
   TEST_3R("srlr.b",  24,  40, w3,  w1,  w8);
   TEST_3R("srlr.b",  32,  40, w4,  w14, w18);
   TEST_3R("srlr.b",  40, 128, w5,  w28, w28);
   TEST_3R("srlr.b",  48,  24, w6,  w13, w5);
   TEST_3R("srlr.b",  56, 168, w7,  w19, w27);
   TEST_3R("srlr.b",  64, 160, w8,  w23, w22);
   TEST_3R("srlr.b",  72, 160, w9,  w25, w2);
   TEST_3R("srlr.b",  80,  88, w10, w25, w26);
   TEST_3R("srlr.b",  88,  96, w11, w30, w8);
   TEST_3R("srlr.b",  96,  72, w12, w22, w4);
   TEST_3R("srlr.b", 104, 232, w13, w19, w30);
   TEST_3R("srlr.b", 112,   8, w14, w27, w14);
   TEST_3R("srlr.b", 120, 168, w15, w11, w13);
   TEST_3R("srlr.b", 128,  88, w16, w7,  w31);
   TEST_3R("srlr.b", 136, 120, w17, w13, w25);
   TEST_3R("srlr.b", 144,   0, w18, w8,  w3);
   TEST_3R("srlr.b", 152,   8, w19, w31, w20);
   TEST_3R("srlr.b", 160,  72, w20, w1,  w21);
   TEST_3R("srlr.b", 168, 176, w21, w3,  w19);
   TEST_3R("srlr.b", 176, 216, w22, w8,  w9);
   TEST_3R("srlr.b", 184, 136, w23, w23, w3);
   TEST_3R("srlr.b", 192,  40, w24, w6,  w0);
   TEST_3R("srlr.b", 200, 112, w25, w18, w12);
   TEST_3R("srlr.b", 208, 192, w26, w30, w19);
   TEST_3R("srlr.b", 216, 184, w27, w23, w0);
   TEST_3R("srlr.b", 224,  96, w28, w3,  w9);
   TEST_3R("srlr.b", 232,  48, w29, w6,  w8);
   TEST_3R("srlr.b", 240,  40, w30, w2,  w9);
   TEST_3R("srlr.b", 104, 120, w31, w23, w5);
   TEST_3R("srlr.h",   0,  88, w0,  w0,  w0);
   TEST_3R("srlr.h",   8,  64, w1,  w22, w19);
   TEST_3R("srlr.h",  16, 112, w2,  w25, w16);
   TEST_3R("srlr.h",  24, 184, w3,  w26, w9);
   TEST_3R("srlr.h",  32, 176, w4,  w6,  w15);
   TEST_3R("srlr.h",  40, 112, w5,  w25, w25);
   TEST_3R("srlr.h",  48,  64, w6,  w30, w26);
   TEST_3R("srlr.h",  56, 160, w7,  w1,  w3);
   TEST_3R("srlr.h",  64,  88, w8,  w7,  w11);
   TEST_3R("srlr.h",  72, 112, w9,  w20, w22);
   TEST_3R("srlr.h",  80,  88, w10, w25, w4);
   TEST_3R("srlr.h",  88, 200, w11, w2,  w26);
   TEST_3R("srlr.h",  96,  88, w12, w18, w20);
   TEST_3R("srlr.h", 104,  16, w13, w9,  w14);
   TEST_3R("srlr.h", 112, 112, w14, w19, w14);
   TEST_3R("srlr.h", 120,  88, w15, w6,  w26);
   TEST_3R("srlr.h", 128,  16, w16, w27, w25);
   TEST_3R("srlr.h", 136,   8, w17, w14, w26);
   TEST_3R("srlr.h", 144,  64, w18, w3,  w2);
   TEST_3R("srlr.h", 152,  88, w19, w14, w11);
   TEST_3R("srlr.h", 160, 144, w20, w5,  w12);
   TEST_3R("srlr.h", 168,  48, w21, w9,  w22);
   TEST_3R("srlr.h", 176,  24, w22, w4,  w20);
   TEST_3R("srlr.h", 184, 192, w23, w23, w24);
   TEST_3R("srlr.h", 192, 216, w24, w1,  w6);
   TEST_3R("srlr.h", 200, 160, w25, w20, w26);
   TEST_3R("srlr.h", 208,  88, w26, w15, w7);
   TEST_3R("srlr.h", 216,  88, w27, w8,  w15);
   TEST_3R("srlr.h", 224, 120, w28, w2,  w25);
   TEST_3R("srlr.h", 232,   8, w29, w4,  w15);
   TEST_3R("srlr.h", 240,  16, w30, w16, w25);
   TEST_3R("srlr.h",  16,  64, w31, w28, w10);
   TEST_3R("srlr.w",   0, 120, w0,  w0,  w0);
   TEST_3R("srlr.w",   8, 208, w1,  w7,  w26);
   TEST_3R("srlr.w",  16, 120, w2,  w10, w27);
   TEST_3R("srlr.w",  24, 144, w3,  w4,  w16);
   TEST_3R("srlr.w",  32, 136, w4,  w5,  w31);
   TEST_3R("srlr.w",  40,  48, w5,  w1,  w1);
   TEST_3R("srlr.w",  48, 216, w6,  w28, w11);
   TEST_3R("srlr.w",  56,  40, w7,  w22, w24);
   TEST_3R("srlr.w",  64, 168, w8,  w5,  w20);
   TEST_3R("srlr.w",  72, 104, w9,  w30, w20);
   TEST_3R("srlr.w",  80, 168, w10, w26, w30);
   TEST_3R("srlr.w",  88,  96, w11, w28, w12);
   TEST_3R("srlr.w",  96,  88, w12, w22, w18);
   TEST_3R("srlr.w", 104,  64, w13, w18, w30);
   TEST_3R("srlr.w", 112,   0, w14, w2,  w14);
   TEST_3R("srlr.w", 120,  16, w15, w7,  w1);
   TEST_3R("srlr.w", 128, 168, w16, w9,  w8);
   TEST_3R("srlr.w", 136,  40, w17, w20, w4);
   TEST_3R("srlr.w", 144, 112, w18, w31, w9);
   TEST_3R("srlr.w", 152,  64, w19, w29, w7);
   TEST_3R("srlr.w", 160,  64, w20, w23, w2);
   TEST_3R("srlr.w", 168, 192, w21, w4,  w30);
   TEST_3R("srlr.w", 176, 160, w22, w23, w21);
   TEST_3R("srlr.w", 184, 128, w23, w23, w21);
   TEST_3R("srlr.w", 192, 120, w24, w17, w23);
   TEST_3R("srlr.w", 200,  88, w25, w22, w30);
   TEST_3R("srlr.w", 208, 112, w26, w8,  w7);
   TEST_3R("srlr.w", 216, 224, w27, w22, w28);
   TEST_3R("srlr.w", 224,  32, w28, w27, w9);
   TEST_3R("srlr.w", 232, 128, w29, w4,  w10);
   TEST_3R("srlr.w", 240,  88, w30, w12, w31);
   TEST_3R("srlr.w",   8,  88, w31, w14, w19);
   TEST_3R("srlr.d",   0, 192, w0,  w0,  w0);
   TEST_3R("srlr.d",   8,  24, w1,  w19, w7);
   TEST_3R("srlr.d",  16, 152, w2,  w8,  w24);
   TEST_3R("srlr.d",  24, 104, w3,  w17, w14);
   TEST_3R("srlr.d",  32,  96, w4,  w27, w22);
   TEST_3R("srlr.d",  40, 216, w5,  w13, w13);
   TEST_3R("srlr.d",  48, 168, w6,  w1,  w17);
   TEST_3R("srlr.d",  56, 232, w7,  w10, w20);
   TEST_3R("srlr.d",  64, 144, w8,  w20, w24);
   TEST_3R("srlr.d",  72, 144, w9,  w12, w6);
   TEST_3R("srlr.d",  80, 104, w10, w8,  w19);
   TEST_3R("srlr.d",  88,  96, w11, w28, w20);
   TEST_3R("srlr.d",  96,  88, w12, w4,  w29);
   TEST_3R("srlr.d", 104, 216, w13, w4,  w14);
   TEST_3R("srlr.d", 112, 184, w14, w2,  w14);
   TEST_3R("srlr.d", 120,  64, w15, w0,  w7);
   TEST_3R("srlr.d", 128, 184, w16, w13, w9);
   TEST_3R("srlr.d", 136, 200, w17, w21, w19);
   TEST_3R("srlr.d", 144, 112, w18, w1,  w8);
   TEST_3R("srlr.d", 152,  88, w19, w26, w28);
   TEST_3R("srlr.d", 160, 160, w20, w0,  w3);
   TEST_3R("srlr.d", 168,  64, w21, w19, w31);
   TEST_3R("srlr.d", 176,  96, w22, w8,  w1);
   TEST_3R("srlr.d", 184, 136, w23, w23, w5);
   TEST_3R("srlr.d", 192, 224, w24, w10, w19);
   TEST_3R("srlr.d", 200, 224, w25, w12, w29);
   TEST_3R("srlr.d", 208,  80, w26, w20, w21);
   TEST_3R("srlr.d", 216, 224, w27, w29, w8);
   TEST_3R("srlr.d", 224, 136, w28, w26, w9);
   TEST_3R("srlr.d", 232, 192, w29, w11, w3);
   TEST_3R("srlr.d", 240, 168, w30, w8,  w4);
   TEST_3R("srlr.d", 192,   0, w31, w14, w23);
   TEST_BIT("bclri.b",   0, w0,  w1,  7);
   TEST_BIT("bclri.b",   8, w1,  w27, 0);
   TEST_BIT("bclri.b",  16, w2,  w21, 1);
   TEST_BIT("bclri.b",  24, w3,  w2,  2);
   TEST_BIT("bclri.b",  32, w4,  w20, 3);
   TEST_BIT("bclri.b",  40, w5,  w31, 4);
   TEST_BIT("bclri.b",  48, w6,  w28, 5);
   TEST_BIT("bclri.b",  56, w7,  w2,  6);
   TEST_BIT("bclri.b",  64, w8,  w13, 7);
   TEST_BIT("bclri.b",  72, w9,  w28, 0);
   TEST_BIT("bclri.b",  80, w10, w13, 1);
   TEST_BIT("bclri.b",  88, w11, w4,  2);
   TEST_BIT("bclri.b",  96, w12, w4,  3);
   TEST_BIT("bclri.b", 104, w13, w8,  4);
   TEST_BIT("bclri.b", 112, w14, w13, 5);
   TEST_BIT("bclri.b", 120, w15, w20, 6);
   TEST_BIT("bclri.b", 128, w16, w22, 7);
   TEST_BIT("bclri.b", 136, w17, w29, 0);
   TEST_BIT("bclri.b", 144, w18, w9,  1);
   TEST_BIT("bclri.b", 152, w19, w8,  2);
   TEST_BIT("bclri.b", 160, w20, w11, 3);
   TEST_BIT("bclri.b", 168, w21, w10, 4);
   TEST_BIT("bclri.b", 176, w22, w19, 5);
   TEST_BIT("bclri.b", 184, w23, w23, 6);
   TEST_BIT("bclri.b", 192, w24, w24, 7);
   TEST_BIT("bclri.b", 200, w25, w16, 0);
   TEST_BIT("bclri.b", 208, w26, w0,  1);
   TEST_BIT("bclri.b", 216, w27, w17, 2);
   TEST_BIT("bclri.b", 224, w28, w16, 3);
   TEST_BIT("bclri.b", 232, w29, w9,  4);
   TEST_BIT("bclri.b", 240, w30, w17, 5);
   TEST_BIT("bclri.b", 208, w31, w30, 6);
   TEST_BIT("bclri.h",   0, w0,  w25, 15);
   TEST_BIT("bclri.h",   8, w1,  w22, 0);
   TEST_BIT("bclri.h",  16, w2,  w31, 1);
   TEST_BIT("bclri.h",  24, w3,  w17, 2);
   TEST_BIT("bclri.h",  32, w4,  w29, 3);
   TEST_BIT("bclri.h",  40, w5,  w27, 4);
   TEST_BIT("bclri.h",  48, w6,  w17, 5);
   TEST_BIT("bclri.h",  56, w7,  w2,  6);
   TEST_BIT("bclri.h",  64, w8,  w0,  7);
   TEST_BIT("bclri.h",  72, w9,  w5,  8);
   TEST_BIT("bclri.h",  80, w10, w7,  9);
   TEST_BIT("bclri.h",  88, w11, w22, 10);
   TEST_BIT("bclri.h",  96, w12, w9,  11);
   TEST_BIT("bclri.h", 104, w13, w2,  12);
   TEST_BIT("bclri.h", 112, w14, w5,  13);
   TEST_BIT("bclri.h", 120, w15, w23, 14);
   TEST_BIT("bclri.h", 128, w16, w28, 15);
   TEST_BIT("bclri.h", 136, w17, w20, 0);
   TEST_BIT("bclri.h", 144, w18, w12, 1);
   TEST_BIT("bclri.h", 152, w19, w21, 2);
   TEST_BIT("bclri.h", 160, w20, w4,  3);
   TEST_BIT("bclri.h", 168, w21, w31, 4);
   TEST_BIT("bclri.h", 176, w22, w21, 5);
   TEST_BIT("bclri.h", 184, w23, w23, 6);
   TEST_BIT("bclri.h", 192, w24, w24, 7);
   TEST_BIT("bclri.h", 200, w25, w22, 8);
   TEST_BIT("bclri.h", 208, w26, w3,  9);
   TEST_BIT("bclri.h", 216, w27, w21, 10);
   TEST_BIT("bclri.h", 224, w28, w17, 11);
   TEST_BIT("bclri.h", 232, w29, w27, 12);
   TEST_BIT("bclri.h", 240, w30, w19, 13);
   TEST_BIT("bclri.h",  64, w31, w17, 14);
   TEST_BIT("bclri.w",   0, w0,  w8,  31);
   TEST_BIT("bclri.w",   8, w1,  w13, 0);
   TEST_BIT("bclri.w",  16, w2,  w11, 1);
   TEST_BIT("bclri.w",  24, w3,  w2,  2);
   TEST_BIT("bclri.w",  32, w4,  w7,  3);
   TEST_BIT("bclri.w",  40, w5,  w19, 4);
   TEST_BIT("bclri.w",  48, w6,  w24, 5);
   TEST_BIT("bclri.w",  56, w7,  w11, 6);
   TEST_BIT("bclri.w",  64, w8,  w19, 7);
   TEST_BIT("bclri.w",  72, w9,  w0,  8);
   TEST_BIT("bclri.w",  80, w10, w28, 9);
   TEST_BIT("bclri.w",  88, w11, w1,  10);
   TEST_BIT("bclri.w",  96, w12, w1,  11);
   TEST_BIT("bclri.w", 104, w13, w8,  12);
   TEST_BIT("bclri.w", 112, w14, w26, 13);
   TEST_BIT("bclri.w", 120, w15, w12, 14);
   TEST_BIT("bclri.w", 128, w16, w3,  15);
   TEST_BIT("bclri.w", 136, w17, w23, 16);
   TEST_BIT("bclri.w", 144, w18, w11, 17);
   TEST_BIT("bclri.w", 152, w19, w1,  18);
   TEST_BIT("bclri.w", 160, w20, w23, 19);
   TEST_BIT("bclri.w", 168, w21, w31, 20);
   TEST_BIT("bclri.w", 176, w22, w2,  21);
   TEST_BIT("bclri.w", 184, w23, w23, 22);
   TEST_BIT("bclri.w", 192, w24, w24, 23);
   TEST_BIT("bclri.w", 200, w25, w3,  24);
   TEST_BIT("bclri.w", 208, w26, w8,  25);
   TEST_BIT("bclri.w", 216, w27, w30, 26);
   TEST_BIT("bclri.w", 224, w28, w13, 27);
   TEST_BIT("bclri.w", 232, w29, w7,  28);
   TEST_BIT("bclri.w", 240, w30, w19, 29);
   TEST_BIT("bclri.w",  24, w31, w14, 30);
   TEST_BIT("bclri.d",   0, w0,  w3,  63);
   TEST_BIT("bclri.d",   8, w1,  w7,  0);
   TEST_BIT("bclri.d",  16, w2,  w18, 1);
   TEST_BIT("bclri.d",  24, w3,  w19, 2);
   TEST_BIT("bclri.d",  32, w4,  w14, 3);
   TEST_BIT("bclri.d",  40, w5,  w10, 4);
   TEST_BIT("bclri.d",  48, w6,  w13, 5);
   TEST_BIT("bclri.d",  56, w7,  w25, 6);
   TEST_BIT("bclri.d",  64, w8,  w15, 7);
   TEST_BIT("bclri.d",  72, w9,  w7,  8);
   TEST_BIT("bclri.d",  80, w10, w31, 9);
   TEST_BIT("bclri.d",  88, w11, w27, 10);
   TEST_BIT("bclri.d",  96, w12, w24, 11);
   TEST_BIT("bclri.d", 104, w13, w17, 12);
   TEST_BIT("bclri.d", 112, w14, w30, 13);
   TEST_BIT("bclri.d", 120, w15, w7,  14);
   TEST_BIT("bclri.d", 128, w16, w20, 15);
   TEST_BIT("bclri.d", 136, w17, w21, 16);
   TEST_BIT("bclri.d", 144, w18, w1,  17);
   TEST_BIT("bclri.d", 152, w19, w25, 18);
   TEST_BIT("bclri.d", 160, w20, w4,  19);
   TEST_BIT("bclri.d", 168, w21, w23, 20);
   TEST_BIT("bclri.d", 176, w22, w17, 21);
   TEST_BIT("bclri.d", 184, w23, w23, 22);
   TEST_BIT("bclri.d", 192, w24, w24, 23);
   TEST_BIT("bclri.d", 200, w25, w16, 24);
   TEST_BIT("bclri.d", 208, w26, w18, 25);
   TEST_BIT("bclri.d", 216, w27, w12, 26);
   TEST_BIT("bclri.d", 224, w28, w9,  27);
   TEST_BIT("bclri.d", 232, w29, w16, 28);
   TEST_BIT("bclri.d", 240, w30, w24, 29);
   TEST_BIT("bclri.d", 208, w31, w27, 30);
   TEST_BIT("binsli.b",   0, w0,  w12, 3);
   TEST_BIT("binsli.b",   8, w1,  w16, 4);
   TEST_BIT("binsli.b",  16, w2,  w25, 5);
   TEST_BIT("binsli.b",  24, w3,  w8,  6);
   TEST_BIT("binsli.b",  32, w4,  w5,  7);
   TEST_BIT("binsli.b",  40, w5,  w5,  0);
   TEST_BIT("binsli.b",  48, w6,  w6,  1);
   TEST_BIT("binsli.b",  56, w7,  w21, 2);
   TEST_BIT("binsli.b",  64, w8,  w12, 3);
   TEST_BIT("binsli.b",  72, w9,  w4,  4);
   TEST_BIT("binsli.b",  80, w10, w20, 5);
   TEST_BIT("binsli.b",  88, w11, w2,  6);
   TEST_BIT("binsli.b",  96, w12, w18, 7);
   TEST_BIT("binsli.b", 104, w13, w8,  0);
   TEST_BIT("binsli.b", 112, w14, w30, 1);
   TEST_BIT("binsli.b", 120, w15, w7,  2);
   TEST_BIT("binsli.b", 128, w16, w27, 3);
   TEST_BIT("binsli.b", 136, w17, w8,  4);
   TEST_BIT("binsli.b", 144, w18, w1,  5);
   TEST_BIT("binsli.b", 152, w19, w9,  6);
   TEST_BIT("binsli.b", 160, w20, w1,  7);
   TEST_BIT("binsli.b", 168, w21, w22, 0);
   TEST_BIT("binsli.b", 176, w22, w3,  1);
   TEST_BIT("binsli.b", 184, w23, w27, 2);
   TEST_BIT("binsli.b", 192, w24, w2,  3);
   TEST_BIT("binsli.b", 200, w25, w15, 4);
   TEST_BIT("binsli.b", 208, w26, w6,  5);
   TEST_BIT("binsli.b", 216, w27, w2,  6);
   TEST_BIT("binsli.b", 224, w28, w14, 7);
   TEST_BIT("binsli.b", 232, w29, w30, 0);
   TEST_BIT("binsli.b", 240, w30, w25, 1);
   TEST_BIT("binsli.b",  24, w31, w30, 2);
   TEST_BIT("binsli.h",   0, w0,  w26, 3);
   TEST_BIT("binsli.h",   8, w1,  w13, 4);
   TEST_BIT("binsli.h",  16, w2,  w4,  5);
   TEST_BIT("binsli.h",  24, w3,  w18, 6);
   TEST_BIT("binsli.h",  32, w4,  w8,  7);
   TEST_BIT("binsli.h",  40, w5,  w5,  8);
   TEST_BIT("binsli.h",  48, w6,  w6,  9);
   TEST_BIT("binsli.h",  56, w7,  w4,  10);
   TEST_BIT("binsli.h",  64, w8,  w22, 11);
   TEST_BIT("binsli.h",  72, w9,  w29, 12);
   TEST_BIT("binsli.h",  80, w10, w26, 13);
   TEST_BIT("binsli.h",  88, w11, w25, 14);
   TEST_BIT("binsli.h",  96, w12, w23, 15);
   TEST_BIT("binsli.h", 104, w13, w6,  0);
   TEST_BIT("binsli.h", 112, w14, w12, 1);
   TEST_BIT("binsli.h", 120, w15, w13, 2);
   TEST_BIT("binsli.h", 128, w16, w25, 3);
   TEST_BIT("binsli.h", 136, w17, w4,  4);
   TEST_BIT("binsli.h", 144, w18, w28, 5);
   TEST_BIT("binsli.h", 152, w19, w0,  6);
   TEST_BIT("binsli.h", 160, w20, w23, 7);
   TEST_BIT("binsli.h", 168, w21, w28, 8);
   TEST_BIT("binsli.h", 176, w22, w8,  9);
   TEST_BIT("binsli.h", 184, w23, w3,  10);
   TEST_BIT("binsli.h", 192, w24, w5,  11);
   TEST_BIT("binsli.h", 200, w25, w20, 12);
   TEST_BIT("binsli.h", 208, w26, w17, 13);
   TEST_BIT("binsli.h", 216, w27, w19, 14);
   TEST_BIT("binsli.h", 224, w28, w26, 15);
   TEST_BIT("binsli.h", 232, w29, w16, 0);
   TEST_BIT("binsli.h", 240, w30, w0,  1);
   TEST_BIT("binsli.h", 216, w31, w13, 2);
   TEST_BIT("binsli.w",   0, w0,  w5,  3);
   TEST_BIT("binsli.w",   8, w1,  w20, 4);
   TEST_BIT("binsli.w",  16, w2,  w11, 5);
   TEST_BIT("binsli.w",  24, w3,  w2,  6);
   TEST_BIT("binsli.w",  32, w4,  w17, 7);
   TEST_BIT("binsli.w",  40, w5,  w5,  8);
   TEST_BIT("binsli.w",  48, w6,  w6,  9);
   TEST_BIT("binsli.w",  56, w7,  w1,  10);
   TEST_BIT("binsli.w",  64, w8,  w29, 11);
   TEST_BIT("binsli.w",  72, w9,  w28, 12);
   TEST_BIT("binsli.w",  80, w10, w7,  13);
   TEST_BIT("binsli.w",  88, w11, w5,  14);
   TEST_BIT("binsli.w",  96, w12, w8,  15);
   TEST_BIT("binsli.w", 104, w13, w17, 16);
   TEST_BIT("binsli.w", 112, w14, w15, 17);
   TEST_BIT("binsli.w", 120, w15, w29, 18);
   TEST_BIT("binsli.w", 128, w16, w31, 19);
   TEST_BIT("binsli.w", 136, w17, w31, 20);
   TEST_BIT("binsli.w", 144, w18, w19, 21);
   TEST_BIT("binsli.w", 152, w19, w11, 22);
   TEST_BIT("binsli.w", 160, w20, w15, 23);
   TEST_BIT("binsli.w", 168, w21, w26, 24);
   TEST_BIT("binsli.w", 176, w22, w16, 25);
   TEST_BIT("binsli.w", 184, w23, w22, 26);
   TEST_BIT("binsli.w", 192, w24, w2,  27);
   TEST_BIT("binsli.w", 200, w25, w31, 28);
   TEST_BIT("binsli.w", 208, w26, w0,  29);
   TEST_BIT("binsli.w", 216, w27, w4,  30);
   TEST_BIT("binsli.w", 224, w28, w8,  31);
   TEST_BIT("binsli.w", 232, w29, w27, 0);
   TEST_BIT("binsli.w", 240, w30, w3,  1);
   TEST_BIT("binsli.w", 216, w31, w23, 2);
   TEST_BIT("binsli.d",   0, w0,  w22, 3);
   TEST_BIT("binsli.d",   8, w1,  w29, 4);
   TEST_BIT("binsli.d",  16, w2,  w16, 5);
   TEST_BIT("binsli.d",  24, w3,  w19, 6);
   TEST_BIT("binsli.d",  32, w4,  w18, 7);
   TEST_BIT("binsli.d",  40, w5,  w5,  8);
   TEST_BIT("binsli.d",  48, w6,  w6,  9);
   TEST_BIT("binsli.d",  56, w7,  w2,  10);
   TEST_BIT("binsli.d",  64, w8,  w7,  11);
   TEST_BIT("binsli.d",  72, w9,  w11, 12);
   TEST_BIT("binsli.d",  80, w10, w16, 13);
   TEST_BIT("binsli.d",  88, w11, w26, 14);
   TEST_BIT("binsli.d",  96, w12, w30, 15);
   TEST_BIT("binsli.d", 104, w13, w8,  16);
   TEST_BIT("binsli.d", 112, w14, w19, 17);
   TEST_BIT("binsli.d", 120, w15, w3,  18);
   TEST_BIT("binsli.d", 128, w16, w12, 19);
   TEST_BIT("binsli.d", 136, w17, w1,  20);
   TEST_BIT("binsli.d", 144, w18, w15, 21);
   TEST_BIT("binsli.d", 152, w19, w11, 22);
   TEST_BIT("binsli.d", 160, w20, w7,  23);
   TEST_BIT("binsli.d", 168, w21, w0,  24);
   TEST_BIT("binsli.d", 176, w22, w11, 25);
   TEST_BIT("binsli.d", 184, w23, w27, 26);
   TEST_BIT("binsli.d", 192, w24, w12, 27);
   TEST_BIT("binsli.d", 200, w25, w17, 28);
   TEST_BIT("binsli.d", 208, w26, w19, 29);
   TEST_BIT("binsli.d", 216, w27, w11, 30);
   TEST_BIT("binsli.d", 224, w28, w17, 31);
   TEST_BIT("binsli.d", 232, w29, w25, 32);
   TEST_BIT("binsli.d", 240, w30, w1,  33);
   TEST_BIT("binsli.d",  48, w31, w14, 34);
   TEST_BIT("binsri.b",   0, w0,  w1,  7);
   TEST_BIT("binsri.b",   8, w1,  w1,  0);
   TEST_BIT("binsri.b",  16, w2,  w1,  1);
   TEST_BIT("binsri.b",  24, w3,  w1,  2);
   TEST_BIT("binsri.b",  32, w4,  w9,  3);
   TEST_BIT("binsri.b",  40, w5,  w10, 4);
   TEST_BIT("binsri.b",  48, w6,  w21, 5);
   TEST_BIT("binsri.b",  56, w7,  w17, 6);
   TEST_BIT("binsri.b",  64, w8,  w7,  7);
   TEST_BIT("binsri.b",  72, w9,  w26, 0);
   TEST_BIT("binsri.b",  80, w10, w26, 1);
   TEST_BIT("binsri.b",  88, w11, w22, 2);
   TEST_BIT("binsri.b",  96, w12, w12, 3);
   TEST_BIT("binsri.b", 104, w13, w19, 4);
   TEST_BIT("binsri.b", 112, w14, w1,  5);
   TEST_BIT("binsri.b", 120, w15, w2,  6);
   TEST_BIT("binsri.b", 128, w16, w18, 7);
   TEST_BIT("binsri.b", 136, w17, w5,  0);
   TEST_BIT("binsri.b", 144, w18, w4,  1);
   TEST_BIT("binsri.b", 152, w19, w20, 2);
   TEST_BIT("binsri.b", 160, w20, w28, 3);
   TEST_BIT("binsri.b", 168, w21, w26, 4);
   TEST_BIT("binsri.b", 176, w22, w16, 5);
   TEST_BIT("binsri.b", 184, w23, w6,  6);
   TEST_BIT("binsri.b", 192, w24, w11, 7);
   TEST_BIT("binsri.b", 200, w25, w15, 0);
   TEST_BIT("binsri.b", 208, w26, w2,  1);
   TEST_BIT("binsri.b", 216, w27, w7,  2);
   TEST_BIT("binsri.b", 224, w28, w14, 3);
   TEST_BIT("binsri.b", 232, w29, w28, 4);
   TEST_BIT("binsri.b", 240, w30, w31, 5);
   TEST_BIT("binsri.b",  24, w31, w3,  6);
   TEST_BIT("binsri.h",   0, w0,  w18, 15);
   TEST_BIT("binsri.h",   8, w1,  w1,  0);
   TEST_BIT("binsri.h",  16, w2,  w6,  1);
   TEST_BIT("binsri.h",  24, w3,  w9,  2);
   TEST_BIT("binsri.h",  32, w4,  w2,  3);
   TEST_BIT("binsri.h",  40, w5,  w28, 4);
   TEST_BIT("binsri.h",  48, w6,  w1,  5);
   TEST_BIT("binsri.h",  56, w7,  w18, 6);
   TEST_BIT("binsri.h",  64, w8,  w26, 7);
   TEST_BIT("binsri.h",  72, w9,  w25, 8);
   TEST_BIT("binsri.h",  80, w10, w17, 9);
   TEST_BIT("binsri.h",  88, w11, w31, 10);
   TEST_BIT("binsri.h",  96, w12, w12, 11);
   TEST_BIT("binsri.h", 104, w13, w8,  12);
   TEST_BIT("binsri.h", 112, w14, w30, 13);
   TEST_BIT("binsri.h", 120, w15, w11, 14);
   TEST_BIT("binsri.h", 128, w16, w30, 15);
   TEST_BIT("binsri.h", 136, w17, w11, 0);
   TEST_BIT("binsri.h", 144, w18, w11, 1);
   TEST_BIT("binsri.h", 152, w19, w28, 2);
   TEST_BIT("binsri.h", 160, w20, w29, 3);
   TEST_BIT("binsri.h", 168, w21, w15, 4);
   TEST_BIT("binsri.h", 176, w22, w17, 5);
   TEST_BIT("binsri.h", 184, w23, w3,  6);
   TEST_BIT("binsri.h", 192, w24, w1,  7);
   TEST_BIT("binsri.h", 200, w25, w24, 8);
   TEST_BIT("binsri.h", 208, w26, w28, 9);
   TEST_BIT("binsri.h", 216, w27, w2,  10);
   TEST_BIT("binsri.h", 224, w28, w11, 11);
   TEST_BIT("binsri.h", 232, w29, w16, 12);
   TEST_BIT("binsri.h", 240, w30, w4,  13);
   TEST_BIT("binsri.h", 112, w31, w20, 14);
   TEST_BIT("binsri.w",   0, w0,  w9,  15);
   TEST_BIT("binsri.w",   8, w1,  w1,  16);
   TEST_BIT("binsri.w",  16, w2,  w5,  17);
   TEST_BIT("binsri.w",  24, w3,  w2,  18);
   TEST_BIT("binsri.w",  32, w4,  w16, 19);
   TEST_BIT("binsri.w",  40, w5,  w21, 20);
   TEST_BIT("binsri.w",  48, w6,  w27, 21);
   TEST_BIT("binsri.w",  56, w7,  w3,  22);
   TEST_BIT("binsri.w",  64, w8,  w17, 23);
   TEST_BIT("binsri.w",  72, w9,  w18, 24);
   TEST_BIT("binsri.w",  80, w10, w0,  25);
   TEST_BIT("binsri.w",  88, w11, w16, 26);
   TEST_BIT("binsri.w",  96, w12, w12, 27);
   TEST_BIT("binsri.w", 104, w13, w0,  28);
   TEST_BIT("binsri.w", 112, w14, w2,  29);
   TEST_BIT("binsri.w", 120, w15, w9,  30);
   TEST_BIT("binsri.w", 128, w16, w11, 31);
   TEST_BIT("binsri.w", 136, w17, w31, 0);
   TEST_BIT("binsri.w", 144, w18, w2,  1);
   TEST_BIT("binsri.w", 152, w19, w25, 2);
   TEST_BIT("binsri.w", 160, w20, w9,  3);
   TEST_BIT("binsri.w", 168, w21, w31, 4);
   TEST_BIT("binsri.w", 176, w22, w26, 5);
   TEST_BIT("binsri.w", 184, w23, w14, 6);
   TEST_BIT("binsri.w", 192, w24, w16, 7);
   TEST_BIT("binsri.w", 200, w25, w12, 8);
   TEST_BIT("binsri.w", 208, w26, w3,  9);
   TEST_BIT("binsri.w", 216, w27, w15, 10);
   TEST_BIT("binsri.w", 224, w28, w24, 11);
   TEST_BIT("binsri.w", 232, w29, w19, 12);
   TEST_BIT("binsri.w", 240, w30, w31, 13);
   TEST_BIT("binsri.w", 120, w31, w16, 14);
   TEST_BIT("binsri.d",   0, w0,  w16, 47);
   TEST_BIT("binsri.d",   8, w1,  w1,  48);
   TEST_BIT("binsri.d",  16, w2,  w21, 49);
   TEST_BIT("binsri.d",  24, w3,  w31, 50);
   TEST_BIT("binsri.d",  32, w4,  w5,  51);
   TEST_BIT("binsri.d",  40, w5,  w29, 52);
   TEST_BIT("binsri.d",  48, w6,  w24, 53);
   TEST_BIT("binsri.d",  56, w7,  w30, 54);
   TEST_BIT("binsri.d",  64, w8,  w30, 55);
   TEST_BIT("binsri.d",  72, w9,  w11, 56);
   TEST_BIT("binsri.d",  80, w10, w23, 57);
   TEST_BIT("binsri.d",  88, w11, w20, 58);
   TEST_BIT("binsri.d",  96, w12, w12, 59);
   TEST_BIT("binsri.d", 104, w13, w16, 60);
   TEST_BIT("binsri.d", 112, w14, w7,  61);
   TEST_BIT("binsri.d", 120, w15, w16, 62);
   TEST_BIT("binsri.d", 128, w16, w25, 63);
   TEST_BIT("binsri.d", 136, w17, w28, 0);
   TEST_BIT("binsri.d", 144, w18, w30, 1);
   TEST_BIT("binsri.d", 152, w19, w30, 2);
   TEST_BIT("binsri.d", 160, w20, w22, 3);
   TEST_BIT("binsri.d", 168, w21, w31, 4);
   TEST_BIT("binsri.d", 176, w22, w26, 5);
   TEST_BIT("binsri.d", 184, w23, w13, 6);
   TEST_BIT("binsri.d", 192, w24, w16, 7);
   TEST_BIT("binsri.d", 200, w25, w22, 8);
   TEST_BIT("binsri.d", 208, w26, w25, 9);
   TEST_BIT("binsri.d", 216, w27, w16, 10);
   TEST_BIT("binsri.d", 224, w28, w4,  11);
   TEST_BIT("binsri.d", 232, w29, w13, 12);
   TEST_BIT("binsri.d", 240, w30, w8,  13);
   TEST_BIT("binsri.d", 216, w31, w15, 14);
   TEST_BIT("bnegi.b",   0, w0,  w16, 4);
   TEST_BIT("bnegi.b",   8, w1,  w6,  5);
   TEST_BIT("bnegi.b",  16, w2,  w14, 6);
   TEST_BIT("bnegi.b",  24, w3,  w31, 7);
   TEST_BIT("bnegi.b",  32, w4,  w27, 0);
   TEST_BIT("bnegi.b",  40, w5,  w14, 1);
   TEST_BIT("bnegi.b",  48, w6,  w31, 2);
   TEST_BIT("bnegi.b",  56, w7,  w19, 3);
   TEST_BIT("bnegi.b",  64, w8,  w23, 4);
   TEST_BIT("bnegi.b",  72, w9,  w20, 5);
   TEST_BIT("bnegi.b",  80, w10, w22, 6);
   TEST_BIT("bnegi.b",  88, w11, w11, 7);
   TEST_BIT("bnegi.b",  96, w12, w0,  0);
   TEST_BIT("bnegi.b", 104, w13, w25, 1);
   TEST_BIT("bnegi.b", 112, w14, w31, 2);
   TEST_BIT("bnegi.b", 120, w15, w27, 3);
   TEST_BIT("bnegi.b", 128, w16, w7,  4);
   TEST_BIT("bnegi.b", 136, w17, w20, 5);
   TEST_BIT("bnegi.b", 144, w18, w25, 6);
   TEST_BIT("bnegi.b", 152, w19, w7,  7);
   TEST_BIT("bnegi.b", 160, w20, w6,  0);
   TEST_BIT("bnegi.b", 168, w21, w12, 1);
   TEST_BIT("bnegi.b", 176, w22, w22, 2);
   TEST_BIT("bnegi.b", 184, w23, w12, 3);
   TEST_BIT("bnegi.b", 192, w24, w7,  4);
   TEST_BIT("bnegi.b", 200, w25, w18, 5);
   TEST_BIT("bnegi.b", 208, w26, w15, 6);
   TEST_BIT("bnegi.b", 216, w27, w19, 7);
   TEST_BIT("bnegi.b", 224, w28, w6,  0);
   TEST_BIT("bnegi.b", 232, w29, w31, 1);
   TEST_BIT("bnegi.b", 240, w30, w26, 2);
   TEST_BIT("bnegi.b", 144, w31, w6,  3);
   TEST_BIT("bnegi.h",   0, w0,  w29, 12);
   TEST_BIT("bnegi.h",   8, w1,  w31, 13);
   TEST_BIT("bnegi.h",  16, w2,  w26, 14);
   TEST_BIT("bnegi.h",  24, w3,  w29, 15);
   TEST_BIT("bnegi.h",  32, w4,  w7,  0);
   TEST_BIT("bnegi.h",  40, w5,  w17, 1);
   TEST_BIT("bnegi.h",  48, w6,  w27, 2);
   TEST_BIT("bnegi.h",  56, w7,  w14, 3);
   TEST_BIT("bnegi.h",  64, w8,  w16, 4);
   TEST_BIT("bnegi.h",  72, w9,  w22, 5);
   TEST_BIT("bnegi.h",  80, w10, w3,  6);
   TEST_BIT("bnegi.h",  88, w11, w11, 7);
   TEST_BIT("bnegi.h",  96, w12, w28, 8);
   TEST_BIT("bnegi.h", 104, w13, w12, 9);
   TEST_BIT("bnegi.h", 112, w14, w15, 10);
   TEST_BIT("bnegi.h", 120, w15, w19, 11);
   TEST_BIT("bnegi.h", 128, w16, w0,  12);
   TEST_BIT("bnegi.h", 136, w17, w18, 13);
   TEST_BIT("bnegi.h", 144, w18, w22, 14);
   TEST_BIT("bnegi.h", 152, w19, w13, 15);
   TEST_BIT("bnegi.h", 160, w20, w2,  0);
   TEST_BIT("bnegi.h", 168, w21, w24, 1);
   TEST_BIT("bnegi.h", 176, w22, w22, 2);
   TEST_BIT("bnegi.h", 184, w23, w11, 3);
   TEST_BIT("bnegi.h", 192, w24, w20, 4);
   TEST_BIT("bnegi.h", 200, w25, w10, 5);
   TEST_BIT("bnegi.h", 208, w26, w23, 6);
   TEST_BIT("bnegi.h", 216, w27, w8,  7);
   TEST_BIT("bnegi.h", 224, w28, w24, 8);
   TEST_BIT("bnegi.h", 232, w29, w31, 9);
   TEST_BIT("bnegi.h", 240, w30, w24, 10);
   TEST_BIT("bnegi.h", 200, w31, w28, 11);
   TEST_BIT("bnegi.w",   0, w0,  w15, 12);
   TEST_BIT("bnegi.w",   8, w1,  w0,  13);
   TEST_BIT("bnegi.w",  16, w2,  w25, 14);
   TEST_BIT("bnegi.w",  24, w3,  w8,  15);
   TEST_BIT("bnegi.w",  32, w4,  w3,  16);
   TEST_BIT("bnegi.w",  40, w5,  w9,  17);
   TEST_BIT("bnegi.w",  48, w6,  w20, 18);
   TEST_BIT("bnegi.w",  56, w7,  w13, 19);
   TEST_BIT("bnegi.w",  64, w8,  w23, 20);
   TEST_BIT("bnegi.w",  72, w9,  w16, 21);
   TEST_BIT("bnegi.w",  80, w10, w31, 22);
   TEST_BIT("bnegi.w",  88, w11, w11, 23);
   TEST_BIT("bnegi.w",  96, w12, w24, 24);
   TEST_BIT("bnegi.w", 104, w13, w11, 25);
   TEST_BIT("bnegi.w", 112, w14, w20, 26);
   TEST_BIT("bnegi.w", 120, w15, w28, 27);
   TEST_BIT("bnegi.w", 128, w16, w7,  28);
   TEST_BIT("bnegi.w", 136, w17, w25, 29);
   TEST_BIT("bnegi.w", 144, w18, w17, 30);
   TEST_BIT("bnegi.w", 152, w19, w25, 31);
   TEST_BIT("bnegi.w", 160, w20, w1,  0);
   TEST_BIT("bnegi.w", 168, w21, w19, 1);
   TEST_BIT("bnegi.w", 176, w22, w22, 2);
   TEST_BIT("bnegi.w", 184, w23, w2,  3);
   TEST_BIT("bnegi.w", 192, w24, w30, 4);
   TEST_BIT("bnegi.w", 200, w25, w8,  5);
   TEST_BIT("bnegi.w", 208, w26, w17, 6);
   TEST_BIT("bnegi.w", 216, w27, w21, 7);
   TEST_BIT("bnegi.w", 224, w28, w0,  8);
   TEST_BIT("bnegi.w", 232, w29, w1,  9);
   TEST_BIT("bnegi.w", 240, w30, w17, 10);
   TEST_BIT("bnegi.w",   0, w31, w5,  11);
   TEST_BIT("bnegi.d",   0, w0,  w12, 44);
   TEST_BIT("bnegi.d",   8, w1,  w25, 45);
   TEST_BIT("bnegi.d",  16, w2,  w6,  46);
   TEST_BIT("bnegi.d",  24, w3,  w5,  47);
   TEST_BIT("bnegi.d",  32, w4,  w8,  48);
   TEST_BIT("bnegi.d",  40, w5,  w26, 49);
   TEST_BIT("bnegi.d",  48, w6,  w8,  50);
   TEST_BIT("bnegi.d",  56, w7,  w9,  51);
   TEST_BIT("bnegi.d",  64, w8,  w4,  52);
   TEST_BIT("bnegi.d",  72, w9,  w3,  53);
   TEST_BIT("bnegi.d",  80, w10, w21, 54);
   TEST_BIT("bnegi.d",  88, w11, w11, 55);
   TEST_BIT("bnegi.d",  96, w12, w25, 56);
   TEST_BIT("bnegi.d", 104, w13, w7,  57);
   TEST_BIT("bnegi.d", 112, w14, w3,  58);
   TEST_BIT("bnegi.d", 120, w15, w31, 59);
   TEST_BIT("bnegi.d", 128, w16, w10, 60);
   TEST_BIT("bnegi.d", 136, w17, w24, 61);
   TEST_BIT("bnegi.d", 144, w18, w8,  62);
   TEST_BIT("bnegi.d", 152, w19, w26, 63);
   TEST_BIT("bnegi.d", 160, w20, w31, 0);
   TEST_BIT("bnegi.d", 168, w21, w1,  1);
   TEST_BIT("bnegi.d", 176, w22, w22, 2);
   TEST_BIT("bnegi.d", 184, w23, w9,  3);
   TEST_BIT("bnegi.d", 192, w24, w17, 4);
   TEST_BIT("bnegi.d", 200, w25, w26, 5);
   TEST_BIT("bnegi.d", 208, w26, w18, 6);
   TEST_BIT("bnegi.d", 216, w27, w10, 7);
   TEST_BIT("bnegi.d", 224, w28, w18, 8);
   TEST_BIT("bnegi.d", 232, w29, w25, 9);
   TEST_BIT("bnegi.d", 240, w30, w23, 10);
   TEST_BIT("bnegi.d", 112, w31, w7,  11);
   TEST_BIT("bseti.b",   0, w0,  w9,  7);
   TEST_BIT("bseti.b",   8, w1,  w18, 0);
   TEST_BIT("bseti.b",  16, w2,  w17, 1);
   TEST_BIT("bseti.b",  24, w3,  w7,  2);
   TEST_BIT("bseti.b",  32, w4,  w1,  3);
   TEST_BIT("bseti.b",  40, w5,  w9,  4);
   TEST_BIT("bseti.b",  48, w6,  w27, 5);
   TEST_BIT("bseti.b",  56, w7,  w11, 6);
   TEST_BIT("bseti.b",  64, w8,  w7,  7);
   TEST_BIT("bseti.b",  72, w9,  w23, 0);
   TEST_BIT("bseti.b",  80, w10, w18, 1);
   TEST_BIT("bseti.b",  88, w11, w25, 2);
   TEST_BIT("bseti.b",  96, w12, w13, 3);
   TEST_BIT("bseti.b", 104, w13, w7,  4);
   TEST_BIT("bseti.b", 112, w14, w10, 5);
   TEST_BIT("bseti.b", 120, w15, w18, 6);
   TEST_BIT("bseti.b", 128, w16, w12, 7);
   TEST_BIT("bseti.b", 136, w17, w12, 0);
   TEST_BIT("bseti.b", 144, w18, w23, 1);
   TEST_BIT("bseti.b", 152, w19, w25, 2);
   TEST_BIT("bseti.b", 160, w20, w25, 3);
   TEST_BIT("bseti.b", 168, w21, w16, 4);
   TEST_BIT("bseti.b", 176, w22, w13, 5);
   TEST_BIT("bseti.b", 184, w23, w31, 6);
   TEST_BIT("bseti.b", 192, w24, w24, 7);
   TEST_BIT("bseti.b", 200, w25, w19, 0);
   TEST_BIT("bseti.b", 208, w26, w10, 1);
   TEST_BIT("bseti.b", 216, w27, w27, 2);
   TEST_BIT("bseti.b", 224, w28, w24, 3);
   TEST_BIT("bseti.b", 232, w29, w8,  4);
   TEST_BIT("bseti.b", 240, w30, w27, 5);
   TEST_BIT("bseti.b", 168, w31, w15, 6);
   TEST_BIT("bseti.h",   0, w0,  w9,  15);
   TEST_BIT("bseti.h",   8, w1,  w6,  0);
   TEST_BIT("bseti.h",  16, w2,  w7,  1);
   TEST_BIT("bseti.h",  24, w3,  w12, 2);
   TEST_BIT("bseti.h",  32, w4,  w24, 3);
   TEST_BIT("bseti.h",  40, w5,  w19, 4);
   TEST_BIT("bseti.h",  48, w6,  w26, 5);
   TEST_BIT("bseti.h",  56, w7,  w20, 6);
   TEST_BIT("bseti.h",  64, w8,  w19, 7);
   TEST_BIT("bseti.h",  72, w9,  w29, 8);
   TEST_BIT("bseti.h",  80, w10, w5,  9);
   TEST_BIT("bseti.h",  88, w11, w10, 10);
   TEST_BIT("bseti.h",  96, w12, w29, 11);
   TEST_BIT("bseti.h", 104, w13, w15, 12);
   TEST_BIT("bseti.h", 112, w14, w9,  13);
   TEST_BIT("bseti.h", 120, w15, w21, 14);
   TEST_BIT("bseti.h", 128, w16, w0,  15);
   TEST_BIT("bseti.h", 136, w17, w6,  0);
   TEST_BIT("bseti.h", 144, w18, w22, 1);
   TEST_BIT("bseti.h", 152, w19, w7,  2);
   TEST_BIT("bseti.h", 160, w20, w28, 3);
   TEST_BIT("bseti.h", 168, w21, w19, 4);
   TEST_BIT("bseti.h", 176, w22, w26, 5);
   TEST_BIT("bseti.h", 184, w23, w15, 6);
   TEST_BIT("bseti.h", 192, w24, w24, 7);
   TEST_BIT("bseti.h", 200, w25, w16, 8);
   TEST_BIT("bseti.h", 208, w26, w11, 9);
   TEST_BIT("bseti.h", 216, w27, w27, 10);
   TEST_BIT("bseti.h", 224, w28, w1,  11);
   TEST_BIT("bseti.h", 232, w29, w24, 12);
   TEST_BIT("bseti.h", 240, w30, w28, 13);
   TEST_BIT("bseti.h",  96, w31, w10, 14);
   TEST_BIT("bseti.w",   0, w0,  w31, 31);
   TEST_BIT("bseti.w",   8, w1,  w2,  0);
   TEST_BIT("bseti.w",  16, w2,  w10, 1);
   TEST_BIT("bseti.w",  24, w3,  w31, 2);
   TEST_BIT("bseti.w",  32, w4,  w31, 3);
   TEST_BIT("bseti.w",  40, w5,  w11, 4);
   TEST_BIT("bseti.w",  48, w6,  w17, 5);
   TEST_BIT("bseti.w",  56, w7,  w27, 6);
   TEST_BIT("bseti.w",  64, w8,  w19, 7);
   TEST_BIT("bseti.w",  72, w9,  w6,  8);
   TEST_BIT("bseti.w",  80, w10, w23, 9);
   TEST_BIT("bseti.w",  88, w11, w0,  10);
   TEST_BIT("bseti.w",  96, w12, w9,  11);
   TEST_BIT("bseti.w", 104, w13, w11, 12);
   TEST_BIT("bseti.w", 112, w14, w8,  13);
   TEST_BIT("bseti.w", 120, w15, w17, 14);
   TEST_BIT("bseti.w", 128, w16, w20, 15);
   TEST_BIT("bseti.w", 136, w17, w16, 16);
   TEST_BIT("bseti.w", 144, w18, w30, 17);
   TEST_BIT("bseti.w", 152, w19, w8,  18);
   TEST_BIT("bseti.w", 160, w20, w15, 19);
   TEST_BIT("bseti.w", 168, w21, w11, 20);
   TEST_BIT("bseti.w", 176, w22, w26, 21);
   TEST_BIT("bseti.w", 184, w23, w0,  22);
   TEST_BIT("bseti.w", 192, w24, w24, 23);
   TEST_BIT("bseti.w", 200, w25, w29, 24);
   TEST_BIT("bseti.w", 208, w26, w0,  25);
   TEST_BIT("bseti.w", 216, w27, w27, 26);
   TEST_BIT("bseti.w", 224, w28, w24, 27);
   TEST_BIT("bseti.w", 232, w29, w18, 28);
   TEST_BIT("bseti.w", 240, w30, w16, 29);
   TEST_BIT("bseti.w", 192, w31, w14, 30);
   TEST_BIT("bseti.d",   0, w0,  w31, 63);
   TEST_BIT("bseti.d",   8, w1,  w19, 0);
   TEST_BIT("bseti.d",  16, w2,  w21, 1);
   TEST_BIT("bseti.d",  24, w3,  w31, 2);
   TEST_BIT("bseti.d",  32, w4,  w2,  3);
   TEST_BIT("bseti.d",  40, w5,  w31, 4);
   TEST_BIT("bseti.d",  48, w6,  w31, 5);
   TEST_BIT("bseti.d",  56, w7,  w4,  6);
   TEST_BIT("bseti.d",  64, w8,  w19, 7);
   TEST_BIT("bseti.d",  72, w9,  w11, 8);
   TEST_BIT("bseti.d",  80, w10, w23, 9);
   TEST_BIT("bseti.d",  88, w11, w27, 10);
   TEST_BIT("bseti.d",  96, w12, w3,  11);
   TEST_BIT("bseti.d", 104, w13, w0,  12);
   TEST_BIT("bseti.d", 112, w14, w8,  13);
   TEST_BIT("bseti.d", 120, w15, w27, 14);
   TEST_BIT("bseti.d", 128, w16, w22, 15);
   TEST_BIT("bseti.d", 136, w17, w21, 16);
   TEST_BIT("bseti.d", 144, w18, w25, 17);
   TEST_BIT("bseti.d", 152, w19, w24, 18);
   TEST_BIT("bseti.d", 160, w20, w22, 19);
   TEST_BIT("bseti.d", 168, w21, w19, 20);
   TEST_BIT("bseti.d", 176, w22, w3,  21);
   TEST_BIT("bseti.d", 184, w23, w27, 22);
   TEST_BIT("bseti.d", 192, w24, w24, 23);
   TEST_BIT("bseti.d", 200, w25, w10, 24);
   TEST_BIT("bseti.d", 208, w26, w8,  25);
   TEST_BIT("bseti.d", 216, w27, w27, 26);
   TEST_BIT("bseti.d", 224, w28, w3,  27);
   TEST_BIT("bseti.d", 232, w29, w27, 28);
   TEST_BIT("bseti.d", 240, w30, w10, 29);
   TEST_BIT("bseti.d", 232, w31, w20, 30);
   TEST_BIT("slli.b",   0, w0,  w1,  0);
   TEST_BIT("slli.b",   8, w1,  w21, 1);
   TEST_BIT("slli.b",  16, w2,  w8,  2);
   TEST_BIT("slli.b",  24, w3,  w13, 3);
   TEST_BIT("slli.b",  32, w4,  w14, 4);
   TEST_BIT("slli.b",  40, w5,  w0,  5);
   TEST_BIT("slli.b",  48, w6,  w26, 6);
   TEST_BIT("slli.b",  56, w7,  w24, 7);
   TEST_BIT("slli.b",  64, w8,  w4,  0);
   TEST_BIT("slli.b",  72, w9,  w19, 1);
   TEST_BIT("slli.b",  80, w10, w14, 2);
   TEST_BIT("slli.b",  88, w11, w25, 3);
   TEST_BIT("slli.b",  96, w12, w12, 4);
   TEST_BIT("slli.b", 104, w13, w19, 5);
   TEST_BIT("slli.b", 112, w14, w16, 6);
   TEST_BIT("slli.b", 120, w15, w27, 7);
   TEST_BIT("slli.b", 128, w16, w5,  0);
   TEST_BIT("slli.b", 136, w17, w24, 1);
   TEST_BIT("slli.b", 144, w18, w31, 2);
   TEST_BIT("slli.b", 152, w19, w28, 3);
   TEST_BIT("slli.b", 160, w20, w30, 4);
   TEST_BIT("slli.b", 168, w21, w3,  5);
   TEST_BIT("slli.b", 176, w22, w20, 6);
   TEST_BIT("slli.b", 184, w23, w28, 7);
   TEST_BIT("slli.b", 192, w24, w1,  0);
   TEST_BIT("slli.b", 200, w25, w26, 1);
   TEST_BIT("slli.b", 208, w26, w26, 2);
   TEST_BIT("slli.b", 216, w27, w3,  3);
   TEST_BIT("slli.b", 224, w28, w4,  4);
   TEST_BIT("slli.b", 232, w29, w3,  5);
   TEST_BIT("slli.b", 240, w30, w18, 6);
   TEST_BIT("slli.b", 216, w31, w4,  7);
   TEST_BIT("slli.h",   0, w0,  w9,  0);
   TEST_BIT("slli.h",   8, w1,  w8,  1);
   TEST_BIT("slli.h",  16, w2,  w10, 2);
   TEST_BIT("slli.h",  24, w3,  w8,  3);
   TEST_BIT("slli.h",  32, w4,  w12, 4);
   TEST_BIT("slli.h",  40, w5,  w27, 5);
   TEST_BIT("slli.h",  48, w6,  w25, 6);
   TEST_BIT("slli.h",  56, w7,  w24, 7);
   TEST_BIT("slli.h",  64, w8,  w1,  8);
   TEST_BIT("slli.h",  72, w9,  w25, 9);
   TEST_BIT("slli.h",  80, w10, w27, 10);
   TEST_BIT("slli.h",  88, w11, w14, 11);
   TEST_BIT("slli.h",  96, w12, w12, 12);
   TEST_BIT("slli.h", 104, w13, w4,  13);
   TEST_BIT("slli.h", 112, w14, w13, 14);
   TEST_BIT("slli.h", 120, w15, w7,  15);
   TEST_BIT("slli.h", 128, w16, w5,  0);
   TEST_BIT("slli.h", 136, w17, w26, 1);
   TEST_BIT("slli.h", 144, w18, w30, 2);
   TEST_BIT("slli.h", 152, w19, w26, 3);
   TEST_BIT("slli.h", 160, w20, w15, 4);
   TEST_BIT("slli.h", 168, w21, w24, 5);
   TEST_BIT("slli.h", 176, w22, w14, 6);
   TEST_BIT("slli.h", 184, w23, w13, 7);
   TEST_BIT("slli.h", 192, w24, w28, 8);
   TEST_BIT("slli.h", 200, w25, w31, 9);
   TEST_BIT("slli.h", 208, w26, w26, 10);
   TEST_BIT("slli.h", 216, w27, w10, 11);
   TEST_BIT("slli.h", 224, w28, w21, 12);
   TEST_BIT("slli.h", 232, w29, w13, 13);
   TEST_BIT("slli.h", 240, w30, w22, 14);
   TEST_BIT("slli.h",  72, w31, w16, 15);
   TEST_BIT("slli.w",   0, w0,  w21, 16);
   TEST_BIT("slli.w",   8, w1,  w6,  17);
   TEST_BIT("slli.w",  16, w2,  w18, 18);
   TEST_BIT("slli.w",  24, w3,  w31, 19);
   TEST_BIT("slli.w",  32, w4,  w18, 20);
   TEST_BIT("slli.w",  40, w5,  w16, 21);
   TEST_BIT("slli.w",  48, w6,  w20, 22);
   TEST_BIT("slli.w",  56, w7,  w29, 23);
   TEST_BIT("slli.w",  64, w8,  w16, 24);
   TEST_BIT("slli.w",  72, w9,  w12, 25);
   TEST_BIT("slli.w",  80, w10, w23, 26);
   TEST_BIT("slli.w",  88, w11, w25, 27);
   TEST_BIT("slli.w",  96, w12, w12, 28);
   TEST_BIT("slli.w", 104, w13, w6,  29);
   TEST_BIT("slli.w", 112, w14, w1,  30);
   TEST_BIT("slli.w", 120, w15, w24, 31);
   TEST_BIT("slli.w", 128, w16, w11, 0);
   TEST_BIT("slli.w", 136, w17, w19, 1);
   TEST_BIT("slli.w", 144, w18, w31, 2);
   TEST_BIT("slli.w", 152, w19, w15, 3);
   TEST_BIT("slli.w", 160, w20, w28, 4);
   TEST_BIT("slli.w", 168, w21, w12, 5);
   TEST_BIT("slli.w", 176, w22, w9,  6);
   TEST_BIT("slli.w", 184, w23, w7,  7);
   TEST_BIT("slli.w", 192, w24, w22, 8);
   TEST_BIT("slli.w", 200, w25, w17, 9);
   TEST_BIT("slli.w", 208, w26, w26, 10);
   TEST_BIT("slli.w", 216, w27, w6,  11);
   TEST_BIT("slli.w", 224, w28, w16, 12);
   TEST_BIT("slli.w", 232, w29, w4,  13);
   TEST_BIT("slli.w", 240, w30, w14, 14);
   TEST_BIT("slli.w",  32, w31, w4,  15);
   TEST_BIT("slli.d",   0, w0,  w16, 48);
   TEST_BIT("slli.d",   8, w1,  w21, 49);
   TEST_BIT("slli.d",  16, w2,  w15, 50);
   TEST_BIT("slli.d",  24, w3,  w13, 51);
   TEST_BIT("slli.d",  32, w4,  w6,  52);
   TEST_BIT("slli.d",  40, w5,  w24, 53);
   TEST_BIT("slli.d",  48, w6,  w12, 54);
   TEST_BIT("slli.d",  56, w7,  w2,  55);
   TEST_BIT("slli.d",  64, w8,  w6,  56);
   TEST_BIT("slli.d",  72, w9,  w24, 57);
   TEST_BIT("slli.d",  80, w10, w24, 58);
   TEST_BIT("slli.d",  88, w11, w2,  59);
   TEST_BIT("slli.d",  96, w12, w12, 60);
   TEST_BIT("slli.d", 104, w13, w15, 61);
   TEST_BIT("slli.d", 112, w14, w0,  62);
   TEST_BIT("slli.d", 120, w15, w20, 63);
   TEST_BIT("slli.d", 128, w16, w24, 0);
   TEST_BIT("slli.d", 136, w17, w20, 1);
   TEST_BIT("slli.d", 144, w18, w14, 2);
   TEST_BIT("slli.d", 152, w19, w22, 3);
   TEST_BIT("slli.d", 160, w20, w17, 4);
   TEST_BIT("slli.d", 168, w21, w24, 5);
   TEST_BIT("slli.d", 176, w22, w25, 6);
   TEST_BIT("slli.d", 184, w23, w1,  7);
   TEST_BIT("slli.d", 192, w24, w15, 8);
   TEST_BIT("slli.d", 200, w25, w19, 9);
   TEST_BIT("slli.d", 208, w26, w26, 10);
   TEST_BIT("slli.d", 216, w27, w31, 11);
   TEST_BIT("slli.d", 224, w28, w13, 12);
   TEST_BIT("slli.d", 232, w29, w12, 13);
   TEST_BIT("slli.d", 240, w30, w12, 14);
   TEST_BIT("slli.d", 128, w31, w3,  15);
   TEST_BIT("srai.b",   0, w0,  w16, 4);
   TEST_BIT("srai.b",   8, w1,  w26, 5);
   TEST_BIT("srai.b",  16, w2,  w21, 6);
   TEST_BIT("srai.b",  24, w3,  w11, 7);
   TEST_BIT("srai.b",  32, w4,  w4,  0);
   TEST_BIT("srai.b",  40, w5,  w15, 1);
   TEST_BIT("srai.b",  48, w6,  w4,  2);
   TEST_BIT("srai.b",  56, w7,  w26, 3);
   TEST_BIT("srai.b",  64, w8,  w22, 4);
   TEST_BIT("srai.b",  72, w9,  w17, 5);
   TEST_BIT("srai.b",  80, w10, w12, 6);
   TEST_BIT("srai.b",  88, w11, w29, 7);
   TEST_BIT("srai.b",  96, w12, w27, 0);
   TEST_BIT("srai.b", 104, w13, w20, 1);
   TEST_BIT("srai.b", 112, w14, w25, 2);
   TEST_BIT("srai.b", 120, w15, w27, 3);
   TEST_BIT("srai.b", 128, w16, w1,  4);
   TEST_BIT("srai.b", 136, w17, w6,  5);
   TEST_BIT("srai.b", 144, w18, w0,  6);
   TEST_BIT("srai.b", 152, w19, w24, 7);
   TEST_BIT("srai.b", 160, w20, w14, 0);
   TEST_BIT("srai.b", 168, w21, w20, 1);
   TEST_BIT("srai.b", 176, w22, w21, 2);
   TEST_BIT("srai.b", 184, w23, w2,  3);
   TEST_BIT("srai.b", 192, w24, w0,  4);
   TEST_BIT("srai.b", 200, w25, w24, 5);
   TEST_BIT("srai.b", 208, w26, w26, 6);
   TEST_BIT("srai.b", 216, w27, w19, 7);
   TEST_BIT("srai.b", 224, w28, w13, 0);
   TEST_BIT("srai.b", 232, w29, w0,  1);
   TEST_BIT("srai.b", 240, w30, w14, 2);
   TEST_BIT("srai.b", 120, w31, w20, 3);
   TEST_BIT("srai.h",   0, w0,  w23, 12);
   TEST_BIT("srai.h",   8, w1,  w11, 13);
   TEST_BIT("srai.h",  16, w2,  w20, 14);
   TEST_BIT("srai.h",  24, w3,  w29, 15);
   TEST_BIT("srai.h",  32, w4,  w4,  0);
   TEST_BIT("srai.h",  40, w5,  w13, 1);
   TEST_BIT("srai.h",  48, w6,  w8,  2);
   TEST_BIT("srai.h",  56, w7,  w18, 3);
   TEST_BIT("srai.h",  64, w8,  w28, 4);
   TEST_BIT("srai.h",  72, w9,  w17, 5);
   TEST_BIT("srai.h",  80, w10, w25, 6);
   TEST_BIT("srai.h",  88, w11, w10, 7);
   TEST_BIT("srai.h",  96, w12, w0,  8);
   TEST_BIT("srai.h", 104, w13, w18, 9);
   TEST_BIT("srai.h", 112, w14, w12, 10);
   TEST_BIT("srai.h", 120, w15, w31, 11);
   TEST_BIT("srai.h", 128, w16, w20, 12);
   TEST_BIT("srai.h", 136, w17, w11, 13);
   TEST_BIT("srai.h", 144, w18, w22, 14);
   TEST_BIT("srai.h", 152, w19, w30, 15);
   TEST_BIT("srai.h", 160, w20, w24, 0);
   TEST_BIT("srai.h", 168, w21, w28, 1);
   TEST_BIT("srai.h", 176, w22, w26, 2);
   TEST_BIT("srai.h", 184, w23, w26, 3);
   TEST_BIT("srai.h", 192, w24, w20, 4);
   TEST_BIT("srai.h", 200, w25, w27, 5);
   TEST_BIT("srai.h", 208, w26, w26, 6);
   TEST_BIT("srai.h", 216, w27, w14, 7);
   TEST_BIT("srai.h", 224, w28, w13, 8);
   TEST_BIT("srai.h", 232, w29, w25, 9);
   TEST_BIT("srai.h", 240, w30, w15, 10);
   TEST_BIT("srai.h",  96, w31, w2,  11);
   TEST_BIT("srai.w",   0, w0,  w14, 28);
   TEST_BIT("srai.w",   8, w1,  w29, 29);
   TEST_BIT("srai.w",  16, w2,  w28, 30);
   TEST_BIT("srai.w",  24, w3,  w1,  31);
   TEST_BIT("srai.w",  32, w4,  w4,  0);
   TEST_BIT("srai.w",  40, w5,  w9,  1);
   TEST_BIT("srai.w",  48, w6,  w7,  2);
   TEST_BIT("srai.w",  56, w7,  w4,  3);
   TEST_BIT("srai.w",  64, w8,  w22, 4);
   TEST_BIT("srai.w",  72, w9,  w16, 5);
   TEST_BIT("srai.w",  80, w10, w4,  6);
   TEST_BIT("srai.w",  88, w11, w5,  7);
   TEST_BIT("srai.w",  96, w12, w18, 8);
   TEST_BIT("srai.w", 104, w13, w2,  9);
   TEST_BIT("srai.w", 112, w14, w7,  10);
   TEST_BIT("srai.w", 120, w15, w8,  11);
   TEST_BIT("srai.w", 128, w16, w4,  12);
   TEST_BIT("srai.w", 136, w17, w2,  13);
   TEST_BIT("srai.w", 144, w18, w1,  14);
   TEST_BIT("srai.w", 152, w19, w26, 15);
   TEST_BIT("srai.w", 160, w20, w11, 16);
   TEST_BIT("srai.w", 168, w21, w12, 17);
   TEST_BIT("srai.w", 176, w22, w4,  18);
   TEST_BIT("srai.w", 184, w23, w9,  19);
   TEST_BIT("srai.w", 192, w24, w1,  20);
   TEST_BIT("srai.w", 200, w25, w30, 21);
   TEST_BIT("srai.w", 208, w26, w26, 22);
   TEST_BIT("srai.w", 216, w27, w17, 23);
   TEST_BIT("srai.w", 224, w28, w31, 24);
   TEST_BIT("srai.w", 232, w29, w5,  25);
   TEST_BIT("srai.w", 240, w30, w4,  26);
   TEST_BIT("srai.w",  24, w31, w17, 27);
   TEST_BIT("srai.d",   0, w0,  w9,  28);
   TEST_BIT("srai.d",   8, w1,  w11, 29);
   TEST_BIT("srai.d",  16, w2,  w8,  30);
   TEST_BIT("srai.d",  24, w3,  w12, 31);
   TEST_BIT("srai.d",  32, w4,  w4,  32);
   TEST_BIT("srai.d",  40, w5,  w8,  33);
   TEST_BIT("srai.d",  48, w6,  w7,  34);
   TEST_BIT("srai.d",  56, w7,  w10, 35);
   TEST_BIT("srai.d",  64, w8,  w7,  36);
   TEST_BIT("srai.d",  72, w9,  w11, 37);
   TEST_BIT("srai.d",  80, w10, w5,  38);
   TEST_BIT("srai.d",  88, w11, w17, 39);
   TEST_BIT("srai.d",  96, w12, w22, 40);
   TEST_BIT("srai.d", 104, w13, w15, 41);
   TEST_BIT("srai.d", 112, w14, w15, 42);
   TEST_BIT("srai.d", 120, w15, w13, 43);
   TEST_BIT("srai.d", 128, w16, w7,  44);
   TEST_BIT("srai.d", 136, w17, w26, 45);
   TEST_BIT("srai.d", 144, w18, w0,  46);
   TEST_BIT("srai.d", 152, w19, w26, 47);
   TEST_BIT("srai.d", 160, w20, w10, 48);
   TEST_BIT("srai.d", 168, w21, w29, 49);
   TEST_BIT("srai.d", 176, w22, w0,  50);
   TEST_BIT("srai.d", 184, w23, w31, 51);
   TEST_BIT("srai.d", 192, w24, w20, 52);
   TEST_BIT("srai.d", 200, w25, w21, 53);
   TEST_BIT("srai.d", 208, w26, w26, 54);
   TEST_BIT("srai.d", 216, w27, w6,  55);
   TEST_BIT("srai.d", 224, w28, w2,  56);
   TEST_BIT("srai.d", 232, w29, w11, 57);
   TEST_BIT("srai.d", 240, w30, w20, 58);
   TEST_BIT("srai.d",  40, w31, w29, 59);
   TEST_BIT("srari.b",   0, w0,  w24, 0);
   TEST_BIT("srari.b",   8, w1,  w13, 1);
   TEST_BIT("srari.b",  16, w2,  w26, 2);
   TEST_BIT("srari.b",  24, w3,  w25, 3);
   TEST_BIT("srari.b",  32, w4,  w13, 4);
   TEST_BIT("srari.b",  40, w5,  w12, 5);
   TEST_BIT("srari.b",  48, w6,  w11, 6);
   TEST_BIT("srari.b",  56, w7,  w19, 7);
   TEST_BIT("srari.b",  64, w8,  w13, 0);
   TEST_BIT("srari.b",  72, w9,  w23, 1);
   TEST_BIT("srari.b",  80, w10, w4,  2);
   TEST_BIT("srari.b",  88, w11, w17, 3);
   TEST_BIT("srari.b",  96, w12, w12, 4);
   TEST_BIT("srari.b", 104, w13, w6,  5);
   TEST_BIT("srari.b", 112, w14, w26, 6);
   TEST_BIT("srari.b", 120, w15, w15, 7);
   TEST_BIT("srari.b", 128, w16, w23, 0);
   TEST_BIT("srari.b", 136, w17, w8,  1);
   TEST_BIT("srari.b", 144, w18, w6,  2);
   TEST_BIT("srari.b", 152, w19, w26, 3);
   TEST_BIT("srari.b", 160, w20, w23, 4);
   TEST_BIT("srari.b", 168, w21, w11, 5);
   TEST_BIT("srari.b", 176, w22, w19, 6);
   TEST_BIT("srari.b", 184, w23, w16, 7);
   TEST_BIT("srari.b", 192, w24, w11, 0);
   TEST_BIT("srari.b", 200, w25, w11, 1);
   TEST_BIT("srari.b", 208, w26, w1,  2);
   TEST_BIT("srari.b", 216, w27, w19, 3);
   TEST_BIT("srari.b", 224, w28, w21, 4);
   TEST_BIT("srari.b", 232, w29, w21, 5);
   TEST_BIT("srari.b", 240, w30, w15, 6);
   TEST_BIT("srari.b", 232, w31, w5,  7);
   TEST_BIT("srari.h",   0, w0,  w14, 8);
   TEST_BIT("srari.h",   8, w1,  w4,  9);
   TEST_BIT("srari.h",  16, w2,  w0,  10);
   TEST_BIT("srari.h",  24, w3,  w20, 11);
   TEST_BIT("srari.h",  32, w4,  w8,  12);
   TEST_BIT("srari.h",  40, w5,  w28, 13);
   TEST_BIT("srari.h",  48, w6,  w5,  14);
   TEST_BIT("srari.h",  56, w7,  w3,  15);
   TEST_BIT("srari.h",  64, w8,  w22, 0);
   TEST_BIT("srari.h",  72, w9,  w19, 1);
   TEST_BIT("srari.h",  80, w10, w8,  2);
   TEST_BIT("srari.h",  88, w11, w2,  3);
   TEST_BIT("srari.h",  96, w12, w12, 4);
   TEST_BIT("srari.h", 104, w13, w14, 5);
   TEST_BIT("srari.h", 112, w14, w3,  6);
   TEST_BIT("srari.h", 120, w15, w15, 7);
   TEST_BIT("srari.h", 128, w16, w17, 8);
   TEST_BIT("srari.h", 136, w17, w10, 9);
   TEST_BIT("srari.h", 144, w18, w28, 10);
   TEST_BIT("srari.h", 152, w19, w1,  11);
   TEST_BIT("srari.h", 160, w20, w6,  12);
   TEST_BIT("srari.h", 168, w21, w23, 13);
   TEST_BIT("srari.h", 176, w22, w2,  14);
   TEST_BIT("srari.h", 184, w23, w9,  15);
   TEST_BIT("srari.h", 192, w24, w12, 0);
   TEST_BIT("srari.h", 200, w25, w9,  1);
   TEST_BIT("srari.h", 208, w26, w9,  2);
   TEST_BIT("srari.h", 216, w27, w8,  3);
   TEST_BIT("srari.h", 224, w28, w6,  4);
   TEST_BIT("srari.h", 232, w29, w3,  5);
   TEST_BIT("srari.h", 240, w30, w10, 6);
   TEST_BIT("srari.h", 216, w31, w9,  7);
   TEST_BIT("srari.w",   0, w0,  w19, 24);
   TEST_BIT("srari.w",   8, w1,  w4,  25);
   TEST_BIT("srari.w",  16, w2,  w26, 26);
   TEST_BIT("srari.w",  24, w3,  w28, 27);
   TEST_BIT("srari.w",  32, w4,  w30, 28);
   TEST_BIT("srari.w",  40, w5,  w9,  29);
   TEST_BIT("srari.w",  48, w6,  w11, 30);
   TEST_BIT("srari.w",  56, w7,  w21, 31);
   TEST_BIT("srari.w",  64, w8,  w14, 0);
   TEST_BIT("srari.w",  72, w9,  w24, 1);
   TEST_BIT("srari.w",  80, w10, w4,  2);
   TEST_BIT("srari.w",  88, w11, w14, 3);
   TEST_BIT("srari.w",  96, w12, w12, 4);
   TEST_BIT("srari.w", 104, w13, w23, 5);
   TEST_BIT("srari.w", 112, w14, w3,  6);
   TEST_BIT("srari.w", 120, w15, w15, 7);
   TEST_BIT("srari.w", 128, w16, w7,  8);
   TEST_BIT("srari.w", 136, w17, w29, 9);
   TEST_BIT("srari.w", 144, w18, w27, 10);
   TEST_BIT("srari.w", 152, w19, w9,  11);
   TEST_BIT("srari.w", 160, w20, w6,  12);
   TEST_BIT("srari.w", 168, w21, w2,  13);
   TEST_BIT("srari.w", 176, w22, w7,  14);
   TEST_BIT("srari.w", 184, w23, w7,  15);
   TEST_BIT("srari.w", 192, w24, w26, 16);
   TEST_BIT("srari.w", 200, w25, w27, 17);
   TEST_BIT("srari.w", 208, w26, w0,  18);
   TEST_BIT("srari.w", 216, w27, w1,  19);
   TEST_BIT("srari.w", 224, w28, w14, 20);
   TEST_BIT("srari.w", 232, w29, w24, 21);
   TEST_BIT("srari.w", 240, w30, w31, 22);
   TEST_BIT("srari.w", 104, w31, w27, 23);
   TEST_BIT("srari.d",   0, w0,  w24, 56);
   TEST_BIT("srari.d",   8, w1,  w10, 57);
   TEST_BIT("srari.d",  16, w2,  w12, 58);
   TEST_BIT("srari.d",  24, w3,  w31, 59);
   TEST_BIT("srari.d",  32, w4,  w6,  60);
   TEST_BIT("srari.d",  40, w5,  w6,  61);
   TEST_BIT("srari.d",  48, w6,  w24, 62);
   TEST_BIT("srari.d",  56, w7,  w3,  63);
   TEST_BIT("srari.d",  64, w8,  w13, 0);
   TEST_BIT("srari.d",  72, w9,  w28, 1);
   TEST_BIT("srari.d",  80, w10, w29, 2);
   TEST_BIT("srari.d",  88, w11, w26, 3);
   TEST_BIT("srari.d",  96, w12, w12, 4);
   TEST_BIT("srari.d", 104, w13, w3,  5);
   TEST_BIT("srari.d", 112, w14, w15, 6);
   TEST_BIT("srari.d", 120, w15, w15, 7);
   TEST_BIT("srari.d", 128, w16, w30, 8);
   TEST_BIT("srari.d", 136, w17, w4,  9);
   TEST_BIT("srari.d", 144, w18, w15, 10);
   TEST_BIT("srari.d", 152, w19, w12, 11);
   TEST_BIT("srari.d", 160, w20, w15, 12);
   TEST_BIT("srari.d", 168, w21, w31, 13);
   TEST_BIT("srari.d", 176, w22, w23, 14);
   TEST_BIT("srari.d", 184, w23, w11, 15);
   TEST_BIT("srari.d", 192, w24, w22, 16);
   TEST_BIT("srari.d", 200, w25, w18, 17);
   TEST_BIT("srari.d", 208, w26, w4,  18);
   TEST_BIT("srari.d", 216, w27, w31, 19);
   TEST_BIT("srari.d", 224, w28, w14, 20);
   TEST_BIT("srari.d", 232, w29, w24, 21);
   TEST_BIT("srari.d", 240, w30, w29, 22);
   TEST_BIT("srari.d",  64, w31, w24, 23);
   TEST_BIT("srli.b",   0, w0,  w20, 4);
   TEST_BIT("srli.b",   8, w1,  w19, 5);
   TEST_BIT("srli.b",  16, w2,  w3,  6);
   TEST_BIT("srli.b",  24, w3,  w3,  7);
   TEST_BIT("srli.b",  32, w4,  w9,  0);
   TEST_BIT("srli.b",  40, w5,  w15, 1);
   TEST_BIT("srli.b",  48, w6,  w6,  2);
   TEST_BIT("srli.b",  56, w7,  w1,  3);
   TEST_BIT("srli.b",  64, w8,  w25, 4);
   TEST_BIT("srli.b",  72, w9,  w17, 5);
   TEST_BIT("srli.b",  80, w10, w28, 6);
   TEST_BIT("srli.b",  88, w11, w16, 7);
   TEST_BIT("srli.b",  96, w12, w21, 0);
   TEST_BIT("srli.b", 104, w13, w21, 1);
   TEST_BIT("srli.b", 112, w14, w12, 2);
   TEST_BIT("srli.b", 120, w15, w25, 3);
   TEST_BIT("srli.b", 128, w16, w19, 4);
   TEST_BIT("srli.b", 136, w17, w8,  5);
   TEST_BIT("srli.b", 144, w18, w14, 6);
   TEST_BIT("srli.b", 152, w19, w27, 7);
   TEST_BIT("srli.b", 160, w20, w13, 0);
   TEST_BIT("srli.b", 168, w21, w8,  1);
   TEST_BIT("srli.b", 176, w22, w20, 2);
   TEST_BIT("srli.b", 184, w23, w16, 3);
   TEST_BIT("srli.b", 192, w24, w25, 4);
   TEST_BIT("srli.b", 200, w25, w4,  5);
   TEST_BIT("srli.b", 208, w26, w1,  6);
   TEST_BIT("srli.b", 216, w27, w31, 7);
   TEST_BIT("srli.b", 224, w28, w26, 0);
   TEST_BIT("srli.b", 232, w29, w26, 1);
   TEST_BIT("srli.b", 240, w30, w0,  2);
   TEST_BIT("srli.b", 112, w31, w9,  3);
   TEST_BIT("srli.h",   0, w0,  w17, 12);
   TEST_BIT("srli.h",   8, w1,  w31, 13);
   TEST_BIT("srli.h",  16, w2,  w22, 14);
   TEST_BIT("srli.h",  24, w3,  w3,  15);
   TEST_BIT("srli.h",  32, w4,  w8,  0);
   TEST_BIT("srli.h",  40, w5,  w6,  1);
   TEST_BIT("srli.h",  48, w6,  w6,  2);
   TEST_BIT("srli.h",  56, w7,  w13, 3);
   TEST_BIT("srli.h",  64, w8,  w5,  4);
   TEST_BIT("srli.h",  72, w9,  w29, 5);
   TEST_BIT("srli.h",  80, w10, w30, 6);
   TEST_BIT("srli.h",  88, w11, w16, 7);
   TEST_BIT("srli.h",  96, w12, w4,  8);
   TEST_BIT("srli.h", 104, w13, w20, 9);
   TEST_BIT("srli.h", 112, w14, w5,  10);
   TEST_BIT("srli.h", 120, w15, w29, 11);
   TEST_BIT("srli.h", 128, w16, w24, 12);
   TEST_BIT("srli.h", 136, w17, w15, 13);
   TEST_BIT("srli.h", 144, w18, w25, 14);
   TEST_BIT("srli.h", 152, w19, w9,  15);
   TEST_BIT("srli.h", 160, w20, w19, 0);
   TEST_BIT("srli.h", 168, w21, w29, 1);
   TEST_BIT("srli.h", 176, w22, w21, 2);
   TEST_BIT("srli.h", 184, w23, w10, 3);
   TEST_BIT("srli.h", 192, w24, w16, 4);
   TEST_BIT("srli.h", 200, w25, w4,  5);
   TEST_BIT("srli.h", 208, w26, w5,  6);
   TEST_BIT("srli.h", 216, w27, w18, 7);
   TEST_BIT("srli.h", 224, w28, w18, 8);
   TEST_BIT("srli.h", 232, w29, w31, 9);
   TEST_BIT("srli.h", 240, w30, w28, 10);
   TEST_BIT("srli.h",  96, w31, w4,  11);
   TEST_BIT("srli.w",   0, w0,  w19, 28);
   TEST_BIT("srli.w",   8, w1,  w27, 29);
   TEST_BIT("srli.w",  16, w2,  w17, 30);
   TEST_BIT("srli.w",  24, w3,  w3,  31);
   TEST_BIT("srli.w",  32, w4,  w17, 0);
   TEST_BIT("srli.w",  40, w5,  w15, 1);
   TEST_BIT("srli.w",  48, w6,  w6,  2);
   TEST_BIT("srli.w",  56, w7,  w25, 3);
   TEST_BIT("srli.w",  64, w8,  w6,  4);
   TEST_BIT("srli.w",  72, w9,  w24, 5);
   TEST_BIT("srli.w",  80, w10, w12, 6);
   TEST_BIT("srli.w",  88, w11, w24, 7);
   TEST_BIT("srli.w",  96, w12, w19, 8);
   TEST_BIT("srli.w", 104, w13, w21, 9);
   TEST_BIT("srli.w", 112, w14, w19, 10);
   TEST_BIT("srli.w", 120, w15, w17, 11);
   TEST_BIT("srli.w", 128, w16, w27, 12);
   TEST_BIT("srli.w", 136, w17, w6,  13);
   TEST_BIT("srli.w", 144, w18, w9,  14);
   TEST_BIT("srli.w", 152, w19, w25, 15);
   TEST_BIT("srli.w", 160, w20, w31, 16);
   TEST_BIT("srli.w", 168, w21, w24, 17);
   TEST_BIT("srli.w", 176, w22, w27, 18);
   TEST_BIT("srli.w", 184, w23, w1,  19);
   TEST_BIT("srli.w", 192, w24, w17, 20);
   TEST_BIT("srli.w", 200, w25, w31, 21);
   TEST_BIT("srli.w", 208, w26, w17, 22);
   TEST_BIT("srli.w", 216, w27, w8,  23);
   TEST_BIT("srli.w", 224, w28, w9,  24);
   TEST_BIT("srli.w", 232, w29, w20, 25);
   TEST_BIT("srli.w", 240, w30, w14, 26);
   TEST_BIT("srli.w", 120, w31, w16, 27);
   TEST_BIT("srli.d",   0, w0,  w22, 60);
   TEST_BIT("srli.d",   8, w1,  w5,  61);
   TEST_BIT("srli.d",  16, w2,  w1,  62);
   TEST_BIT("srli.d",  24, w3,  w3,  63);
   TEST_BIT("srli.d",  32, w4,  w13, 0);
   TEST_BIT("srli.d",  40, w5,  w26, 1);
   TEST_BIT("srli.d",  48, w6,  w6,  2);
   TEST_BIT("srli.d",  56, w7,  w27, 3);
   TEST_BIT("srli.d",  64, w8,  w22, 4);
   TEST_BIT("srli.d",  72, w9,  w29, 5);
   TEST_BIT("srli.d",  80, w10, w20, 6);
   TEST_BIT("srli.d",  88, w11, w8,  7);
   TEST_BIT("srli.d",  96, w12, w17, 8);
   TEST_BIT("srli.d", 104, w13, w18, 9);
   TEST_BIT("srli.d", 112, w14, w16, 10);
   TEST_BIT("srli.d", 120, w15, w23, 11);
   TEST_BIT("srli.d", 128, w16, w1,  12);
   TEST_BIT("srli.d", 136, w17, w19, 13);
   TEST_BIT("srli.d", 144, w18, w4,  14);
   TEST_BIT("srli.d", 152, w19, w28, 15);
   TEST_BIT("srli.d", 160, w20, w4,  16);
   TEST_BIT("srli.d", 168, w21, w19, 17);
   TEST_BIT("srli.d", 176, w22, w26, 18);
   TEST_BIT("srli.d", 184, w23, w14, 19);
   TEST_BIT("srli.d", 192, w24, w26, 20);
   TEST_BIT("srli.d", 200, w25, w24, 21);
   TEST_BIT("srli.d", 208, w26, w5,  22);
   TEST_BIT("srli.d", 216, w27, w31, 23);
   TEST_BIT("srli.d", 224, w28, w11, 24);
   TEST_BIT("srli.d", 232, w29, w18, 25);
   TEST_BIT("srli.d", 240, w30, w4,  26);
   TEST_BIT("srli.d", 192, w31, w2,  27);
   TEST_BIT("srlri.b",   0, w0,  w4,  2);
   TEST_BIT("srlri.b",   8, w1,  w31, 3);
   TEST_BIT("srlri.b",  16, w2,  w16, 4);
   TEST_BIT("srlri.b",  24, w3,  w28, 5);
   TEST_BIT("srlri.b",  32, w4,  w22, 6);
   TEST_BIT("srlri.b",  40, w5,  w5,  7);
   TEST_BIT("srlri.b",  48, w6,  w30, 0);
   TEST_BIT("srlri.b",  56, w7,  w6,  1);
   TEST_BIT("srlri.b",  64, w8,  w13, 2);
   TEST_BIT("srlri.b",  72, w9,  w22, 3);
   TEST_BIT("srlri.b",  80, w10, w6,  4);
   TEST_BIT("srlri.b",  88, w11, w31, 5);
   TEST_BIT("srlri.b",  96, w12, w11, 6);
   TEST_BIT("srlri.b", 104, w13, w2,  7);
   TEST_BIT("srlri.b", 112, w14, w15, 0);
   TEST_BIT("srlri.b", 120, w15, w17, 1);
   TEST_BIT("srlri.b", 128, w16, w18, 2);
   TEST_BIT("srlri.b", 136, w17, w18, 3);
   TEST_BIT("srlri.b", 144, w18, w28, 4);
   TEST_BIT("srlri.b", 152, w19, w24, 5);
   TEST_BIT("srlri.b", 160, w20, w28, 6);
   TEST_BIT("srlri.b", 168, w21, w13, 7);
   TEST_BIT("srlri.b", 176, w22, w27, 0);
   TEST_BIT("srlri.b", 184, w23, w27, 1);
   TEST_BIT("srlri.b", 192, w24, w6,  2);
   TEST_BIT("srlri.b", 200, w25, w24, 3);
   TEST_BIT("srlri.b", 208, w26, w6,  4);
   TEST_BIT("srlri.b", 216, w27, w15, 5);
   TEST_BIT("srlri.b", 224, w28, w9,  6);
   TEST_BIT("srlri.b", 232, w29, w7,  7);
   TEST_BIT("srlri.b", 240, w30, w6,  0);
   TEST_BIT("srlri.b", 160, w31, w31, 1);
   TEST_BIT("srlri.h",   0, w0,  w21, 10);
   TEST_BIT("srlri.h",   8, w1,  w7,  11);
   TEST_BIT("srlri.h",  16, w2,  w0,  12);
   TEST_BIT("srlri.h",  24, w3,  w21, 13);
   TEST_BIT("srlri.h",  32, w4,  w3,  14);
   TEST_BIT("srlri.h",  40, w5,  w5,  15);
   TEST_BIT("srlri.h",  48, w6,  w5,  0);
   TEST_BIT("srlri.h",  56, w7,  w14, 1);
   TEST_BIT("srlri.h",  64, w8,  w3,  2);
   TEST_BIT("srlri.h",  72, w9,  w8,  3);
   TEST_BIT("srlri.h",  80, w10, w17, 4);
   TEST_BIT("srlri.h",  88, w11, w26, 5);
   TEST_BIT("srlri.h",  96, w12, w1,  6);
   TEST_BIT("srlri.h", 104, w13, w3,  7);
   TEST_BIT("srlri.h", 112, w14, w27, 8);
   TEST_BIT("srlri.h", 120, w15, w30, 9);
   TEST_BIT("srlri.h", 128, w16, w18, 10);
   TEST_BIT("srlri.h", 136, w17, w4,  11);
   TEST_BIT("srlri.h", 144, w18, w17, 12);
   TEST_BIT("srlri.h", 152, w19, w0,  13);
   TEST_BIT("srlri.h", 160, w20, w27, 14);
   TEST_BIT("srlri.h", 168, w21, w26, 15);
   TEST_BIT("srlri.h", 176, w22, w3,  0);
   TEST_BIT("srlri.h", 184, w23, w8,  1);
   TEST_BIT("srlri.h", 192, w24, w7,  2);
   TEST_BIT("srlri.h", 200, w25, w8,  3);
   TEST_BIT("srlri.h", 208, w26, w15, 4);
   TEST_BIT("srlri.h", 216, w27, w28, 5);
   TEST_BIT("srlri.h", 224, w28, w10, 6);
   TEST_BIT("srlri.h", 232, w29, w8,  7);
   TEST_BIT("srlri.h", 240, w30, w25, 8);
   TEST_BIT("srlri.h", 104, w31, w31, 9);
   TEST_BIT("srlri.w",   0, w0,  w24, 26);
   TEST_BIT("srlri.w",   8, w1,  w29, 27);
   TEST_BIT("srlri.w",  16, w2,  w9,  28);
   TEST_BIT("srlri.w",  24, w3,  w18, 29);
   TEST_BIT("srlri.w",  32, w4,  w28, 30);
   TEST_BIT("srlri.w",  40, w5,  w5,  31);
   TEST_BIT("srlri.w",  48, w6,  w10, 0);
   TEST_BIT("srlri.w",  56, w7,  w25, 1);
   TEST_BIT("srlri.w",  64, w8,  w29, 2);
   TEST_BIT("srlri.w",  72, w9,  w16, 3);
   TEST_BIT("srlri.w",  80, w10, w3,  4);
   TEST_BIT("srlri.w",  88, w11, w28, 5);
   TEST_BIT("srlri.w",  96, w12, w31, 6);
   TEST_BIT("srlri.w", 104, w13, w6,  7);
   TEST_BIT("srlri.w", 112, w14, w23, 8);
   TEST_BIT("srlri.w", 120, w15, w24, 9);
   TEST_BIT("srlri.w", 128, w16, w15, 10);
   TEST_BIT("srlri.w", 136, w17, w21, 11);
   TEST_BIT("srlri.w", 144, w18, w14, 12);
   TEST_BIT("srlri.w", 152, w19, w15, 13);
   TEST_BIT("srlri.w", 160, w20, w31, 14);
   TEST_BIT("srlri.w", 168, w21, w16, 15);
   TEST_BIT("srlri.w", 176, w22, w9,  16);
   TEST_BIT("srlri.w", 184, w23, w9,  17);
   TEST_BIT("srlri.w", 192, w24, w6,  18);
   TEST_BIT("srlri.w", 200, w25, w12, 19);
   TEST_BIT("srlri.w", 208, w26, w11, 20);
   TEST_BIT("srlri.w", 216, w27, w12, 21);
   TEST_BIT("srlri.w", 224, w28, w15, 22);
   TEST_BIT("srlri.w", 232, w29, w17, 23);
   TEST_BIT("srlri.w", 240, w30, w4,  24);
   TEST_BIT("srlri.w",  96, w31, w31, 25);
   TEST_BIT("srlri.d",   0, w0,  w3,  26);
   TEST_BIT("srlri.d",   8, w1,  w4,  27);
   TEST_BIT("srlri.d",  16, w2,  w0,  28);
   TEST_BIT("srlri.d",  24, w3,  w5,  29);
   TEST_BIT("srlri.d",  32, w4,  w0,  30);
   TEST_BIT("srlri.d",  40, w5,  w5,  31);
   TEST_BIT("srlri.d",  48, w6,  w9,  32);
   TEST_BIT("srlri.d",  56, w7,  w5,  33);
   TEST_BIT("srlri.d",  64, w8,  w17, 34);
   TEST_BIT("srlri.d",  72, w9,  w21, 35);
   TEST_BIT("srlri.d",  80, w10, w5,  36);
   TEST_BIT("srlri.d",  88, w11, w22, 37);
   TEST_BIT("srlri.d",  96, w12, w20, 38);
   TEST_BIT("srlri.d", 104, w13, w7,  39);
   TEST_BIT("srlri.d", 112, w14, w18, 40);
   TEST_BIT("srlri.d", 120, w15, w25, 41);
   TEST_BIT("srlri.d", 128, w16, w24, 42);
   TEST_BIT("srlri.d", 136, w17, w13, 43);
   TEST_BIT("srlri.d", 144, w18, w10, 44);
   TEST_BIT("srlri.d", 152, w19, w8,  45);
   TEST_BIT("srlri.d", 160, w20, w1,  46);
   TEST_BIT("srlri.d", 168, w21, w18, 47);
   TEST_BIT("srlri.d", 176, w22, w28, 48);
   TEST_BIT("srlri.d", 184, w23, w25, 49);
   TEST_BIT("srlri.d", 192, w24, w8,  50);
   TEST_BIT("srlri.d", 200, w25, w26, 51);
   TEST_BIT("srlri.d", 208, w26, w28, 52);
   TEST_BIT("srlri.d", 216, w27, w10, 53);
   TEST_BIT("srlri.d", 224, w28, w30, 54);
   TEST_BIT("srlri.d", 232, w29, w24, 55);
   TEST_BIT("srlri.d", 240, w30, w15, 56);
   TEST_BIT("srlri.d", 176, w31, w31, 57);
   TEST_I8("andi.b",   0, w0,  w20, 8);
   TEST_I8("andi.b",   8, w1,  w30, 255);
   TEST_I8("andi.b",  16, w2,  w23, 104);
   TEST_I8("andi.b",  24, w3,  w13, 140);
   TEST_I8("andi.b",  32, w4,  w7,  7);
   TEST_I8("andi.b",  40, w5,  w22, 104);
   TEST_I8("andi.b",  48, w6,  w21, 141);
   TEST_I8("andi.b",  56, w7,  w26, 111);
   TEST_I8("andi.b",  64, w8,  w12, 123);
   TEST_I8("andi.b",  72, w9,  w31, 240);
   TEST_I8("andi.b",  80, w10, w19, 248);
   TEST_I8("andi.b",  88, w11, w17, 248);
   TEST_I8("andi.b",  96, w12, w12, 169);
   TEST_I8("andi.b", 104, w13, w1,  118);
   TEST_I8("andi.b", 112, w14, w20, 93);
   TEST_I8("andi.b", 120, w15, w3,  52);
   TEST_I8("andi.b", 128, w16, w28, 50);
   TEST_I8("andi.b", 136, w17, w27, 204);
   TEST_I8("andi.b", 144, w18, w9,  25);
   TEST_I8("andi.b", 152, w19, w19, 96);
   TEST_I8("andi.b", 160, w20, w24, 80);
   TEST_I8("andi.b", 168, w21, w12, 153);
   TEST_I8("andi.b", 176, w22, w9,  97);
   TEST_I8("andi.b", 184, w23, w1,  227);
   TEST_I8("andi.b", 192, w24, w1,  55);
   TEST_I8("andi.b", 200, w25, w13, 155);
   TEST_I8("andi.b", 208, w26, w1,  119);
   TEST_I8("andi.b", 216, w27, w29, 183);
   TEST_I8("andi.b", 224, w28, w9,  45);
   TEST_I8("andi.b", 232, w29, w22, 18);
   TEST_I8("andi.b", 240, w30, w15, 114);
   TEST_I8("andi.b", 144, w31, w7,  194);
   TEST_I8("bmnzi.b",   0, w0,  w12, 13);
   TEST_I8("bmnzi.b",   8, w1,  w13, 68);
   TEST_I8("bmnzi.b",  16, w2,  w27, 223);
   TEST_I8("bmnzi.b",  24, w3,  w28, 217);
   TEST_I8("bmnzi.b",  32, w4,  w19, 177);
   TEST_I8("bmnzi.b",  40, w5,  w0,  178);
   TEST_I8("bmnzi.b",  48, w6,  w18, 124);
   TEST_I8("bmnzi.b",  56, w7,  w4,  172);
   TEST_I8("bmnzi.b",  64, w8,  w8,  102);
   TEST_I8("bmnzi.b",  72, w9,  w0,  114);
   TEST_I8("bmnzi.b",  80, w10, w17, 158);
   TEST_I8("bmnzi.b",  88, w11, w11, 9);
   TEST_I8("bmnzi.b",  96, w12, w11, 240);
   TEST_I8("bmnzi.b", 104, w13, w7,  207);
   TEST_I8("bmnzi.b", 112, w14, w3,  38);
   TEST_I8("bmnzi.b", 120, w15, w28, 39);
   TEST_I8("bmnzi.b", 128, w16, w13, 157);
   TEST_I8("bmnzi.b", 136, w17, w31, 204);
   TEST_I8("bmnzi.b", 144, w18, w3,  112);
   TEST_I8("bmnzi.b", 152, w19, w16, 214);
   TEST_I8("bmnzi.b", 160, w20, w16, 72);
   TEST_I8("bmnzi.b", 168, w21, w2,  7);
   TEST_I8("bmnzi.b", 176, w22, w11, 179);
   TEST_I8("bmnzi.b", 184, w23, w8,  218);
   TEST_I8("bmnzi.b", 192, w24, w19, 253);
   TEST_I8("bmnzi.b", 200, w25, w26, 249);
   TEST_I8("bmnzi.b", 208, w26, w20, 166);
   TEST_I8("bmnzi.b", 216, w27, w14, 5);
   TEST_I8("bmnzi.b", 224, w28, w26, 224);
   TEST_I8("bmnzi.b", 232, w29, w10, 104);
   TEST_I8("bmnzi.b", 240, w30, w0,  100);
   TEST_I8("bmnzi.b", 192, w31, w9,  254);
   TEST_I8("bmzi.b",   0, w0,  w26, 252);
   TEST_I8("bmzi.b",   8, w1,  w1,  128);
   TEST_I8("bmzi.b",  16, w2,  w26, 172);
   TEST_I8("bmzi.b",  24, w3,  w19, 42);
   TEST_I8("bmzi.b",  32, w4,  w4,  249);
   TEST_I8("bmzi.b",  40, w5,  w24, 254);
   TEST_I8("bmzi.b",  48, w6,  w18, 222);
   TEST_I8("bmzi.b",  56, w7,  w28, 70);
   TEST_I8("bmzi.b",  64, w8,  w28, 170);
   TEST_I8("bmzi.b",  72, w9,  w5,  240);
   TEST_I8("bmzi.b",  80, w10, w9,  145);
   TEST_I8("bmzi.b",  88, w11, w13, 186);
   TEST_I8("bmzi.b",  96, w12, w8,  182);
   TEST_I8("bmzi.b", 104, w13, w8,  12);
   TEST_I8("bmzi.b", 112, w14, w20, 54);
   TEST_I8("bmzi.b", 120, w15, w19, 206);
   TEST_I8("bmzi.b", 128, w16, w2,  160);
   TEST_I8("bmzi.b", 136, w17, w5,  28);
   TEST_I8("bmzi.b", 144, w18, w12, 25);
   TEST_I8("bmzi.b", 152, w19, w6,  222);
   TEST_I8("bmzi.b", 160, w20, w23, 116);
   TEST_I8("bmzi.b", 168, w21, w8,  140);
   TEST_I8("bmzi.b", 176, w22, w3,  2);
   TEST_I8("bmzi.b", 184, w23, w25, 209);
   TEST_I8("bmzi.b", 192, w24, w6,  244);
   TEST_I8("bmzi.b", 200, w25, w28, 15);
   TEST_I8("bmzi.b", 208, w26, w11, 41);
   TEST_I8("bmzi.b", 216, w27, w11, 33);
   TEST_I8("bmzi.b", 224, w28, w8,  95);
   TEST_I8("bmzi.b", 232, w29, w1,  72);
   TEST_I8("bmzi.b", 240, w30, w31, 218);
   TEST_I8("bmzi.b", 208, w31, w19, 90);
   TEST_I8("bseli.b",   0, w0,  w17, 179);
   TEST_I8("bseli.b",   8, w1,  w1,  39);
   TEST_I8("bseli.b",  16, w2,  w15, 107);
   TEST_I8("bseli.b",  24, w3,  w23, 228);
   TEST_I8("bseli.b",  32, w4,  w0,  98);
   TEST_I8("bseli.b",  40, w5,  w1,  141);
   TEST_I8("bseli.b",  48, w6,  w0,  94);
   TEST_I8("bseli.b",  56, w7,  w9,  198);
   TEST_I8("bseli.b",  64, w8,  w3,  86);
   TEST_I8("bseli.b",  72, w9,  w29, 202);
   TEST_I8("bseli.b",  80, w10, w31, 215);
   TEST_I8("bseli.b",  88, w11, w16, 138);
   TEST_I8("bseli.b",  96, w12, w4,  25);
   TEST_I8("bseli.b", 104, w13, w15, 246);
   TEST_I8("bseli.b", 112, w14, w20, 86);
   TEST_I8("bseli.b", 120, w15, w26, 215);
   TEST_I8("bseli.b", 128, w16, w8,  183);
   TEST_I8("bseli.b", 136, w17, w23, 224);
   TEST_I8("bseli.b", 144, w18, w5,  228);
   TEST_I8("bseli.b", 152, w19, w19, 167);
   TEST_I8("bseli.b", 160, w20, w29, 169);
   TEST_I8("bseli.b", 168, w21, w7,  13);
   TEST_I8("bseli.b", 176, w22, w30, 165);
   TEST_I8("bseli.b", 184, w23, w8,  100);
   TEST_I8("bseli.b", 192, w24, w2,  90);
   TEST_I8("bseli.b", 200, w25, w22, 176);
   TEST_I8("bseli.b", 208, w26, w16, 135);
   TEST_I8("bseli.b", 216, w27, w24, 62);
   TEST_I8("bseli.b", 224, w28, w15, 31);
   TEST_I8("bseli.b", 232, w29, w20, 3);
   TEST_I8("bseli.b", 240, w30, w28, 68);
   TEST_I8("bseli.b", 176, w31, w5,  37);
   TEST_I8("nori.b",   0, w0,  w10, 103);
   TEST_I8("nori.b",   8, w1,  w15, 221);
   TEST_I8("nori.b",  16, w2,  w7,  45);
   TEST_I8("nori.b",  24, w3,  w21, 69);
   TEST_I8("nori.b",  32, w4,  w6,  148);
   TEST_I8("nori.b",  40, w5,  w24, 170);
   TEST_I8("nori.b",  48, w6,  w8,  173);
   TEST_I8("nori.b",  56, w7,  w4,  138);
   TEST_I8("nori.b",  64, w8,  w5,  61);
   TEST_I8("nori.b",  72, w9,  w2,  149);
   TEST_I8("nori.b",  80, w10, w7,  81);
   TEST_I8("nori.b",  88, w11, w14, 103);
   TEST_I8("nori.b",  96, w12, w11, 45);
   TEST_I8("nori.b", 104, w13, w24, 122);
   TEST_I8("nori.b", 112, w14, w29, 5);
   TEST_I8("nori.b", 120, w15, w17, 176);
   TEST_I8("nori.b", 128, w16, w25, 93);
   TEST_I8("nori.b", 136, w17, w30, 79);
   TEST_I8("nori.b", 144, w18, w8,  102);
   TEST_I8("nori.b", 152, w19, w5,  51);
   TEST_I8("nori.b", 160, w20, w26, 106);
   TEST_I8("nori.b", 168, w21, w21, 181);
   TEST_I8("nori.b", 176, w22, w16, 32);
   TEST_I8("nori.b", 184, w23, w29, 184);
   TEST_I8("nori.b", 192, w24, w31, 249);
   TEST_I8("nori.b", 200, w25, w21, 254);
   TEST_I8("nori.b", 208, w26, w6,  174);
   TEST_I8("nori.b", 216, w27, w31, 12);
   TEST_I8("nori.b", 224, w28, w28, 157);
   TEST_I8("nori.b", 232, w29, w16, 101);
   TEST_I8("nori.b", 240, w30, w14, 106);
   TEST_I8("nori.b", 128, w31, w14, 4);
   TEST_I8("ori.b",   0, w0,  w10, 192);
   TEST_I8("ori.b",   8, w1,  w2,  43);
   TEST_I8("ori.b",  16, w2,  w25, 50);
   TEST_I8("ori.b",  24, w3,  w24, 249);
   TEST_I8("ori.b",  32, w4,  w6,  81);
   TEST_I8("ori.b",  40, w5,  w18, 33);
   TEST_I8("ori.b",  48, w6,  w14, 16);
   TEST_I8("ori.b",  56, w7,  w16, 254);
   TEST_I8("ori.b",  64, w8,  w5,  20);
   TEST_I8("ori.b",  72, w9,  w4,  222);
   TEST_I8("ori.b",  80, w10, w19, 64);
   TEST_I8("ori.b",  88, w11, w9,  0);
   TEST_I8("ori.b",  96, w12, w11, 186);
   TEST_I8("ori.b", 104, w13, w3,  114);
   TEST_I8("ori.b", 112, w14, w0,  216);
   TEST_I8("ori.b", 120, w15, w15, 134);
   TEST_I8("ori.b", 128, w16, w11, 167);
   TEST_I8("ori.b", 136, w17, w25, 183);
   TEST_I8("ori.b", 144, w18, w9,  182);
   TEST_I8("ori.b", 152, w19, w14, 202);
   TEST_I8("ori.b", 160, w20, w18, 168);
   TEST_I8("ori.b", 168, w21, w5,  113);
   TEST_I8("ori.b", 176, w22, w4,  221);
   TEST_I8("ori.b", 184, w23, w14, 128);
   TEST_I8("ori.b", 192, w24, w10, 96);
   TEST_I8("ori.b", 200, w25, w31, 222);
   TEST_I8("ori.b", 208, w26, w5,  150);
   TEST_I8("ori.b", 216, w27, w12, 238);
   TEST_I8("ori.b", 224, w28, w4,  80);
   TEST_I8("ori.b", 232, w29, w26, 194);
   TEST_I8("ori.b", 240, w30, w4,  50);
   TEST_I8("ori.b",  96, w31, w31, 12);
   TEST_I8("xori.b",   0, w0,  w27, 253);
   TEST_I8("xori.b",   8, w1,  w27, 217);
   TEST_I8("xori.b",  16, w2,  w2,  59);
   TEST_I8("xori.b",  24, w3,  w2,  25);
   TEST_I8("xori.b",  32, w4,  w7,  175);
   TEST_I8("xori.b",  40, w5,  w19, 157);
   TEST_I8("xori.b",  48, w6,  w23, 238);
   TEST_I8("xori.b",  56, w7,  w17, 176);
   TEST_I8("xori.b",  64, w8,  w21, 226);
   TEST_I8("xori.b",  72, w9,  w2,  160);
   TEST_I8("xori.b",  80, w10, w13, 251);
   TEST_I8("xori.b",  88, w11, w6,  83);
   TEST_I8("xori.b",  96, w12, w22, 45);
   TEST_I8("xori.b", 104, w13, w17, 187);
   TEST_I8("xori.b", 112, w14, w11, 74);
   TEST_I8("xori.b", 120, w15, w26, 241);
   TEST_I8("xori.b", 128, w16, w24, 91);
   TEST_I8("xori.b", 136, w17, w6,  180);
   TEST_I8("xori.b", 144, w18, w22, 4);
   TEST_I8("xori.b", 152, w19, w16, 38);
   TEST_I8("xori.b", 160, w20, w18, 198);
   TEST_I8("xori.b", 168, w21, w0,  193);
   TEST_I8("xori.b", 176, w22, w6,  144);
   TEST_I8("xori.b", 184, w23, w19, 123);
   TEST_I8("xori.b", 192, w24, w14, 110);
   TEST_I8("xori.b", 200, w25, w24, 148);
   TEST_I8("xori.b", 208, w26, w10, 209);
   TEST_I8("xori.b", 216, w27, w5,  192);
   TEST_I8("xori.b", 224, w28, w25, 197);
   TEST_I8("xori.b", 232, w29, w9,  235);
   TEST_I8("xori.b", 240, w30, w30, 86);
   TEST_I8("xori.b",  64, w31, w18, 105);
   TEST_3R("and.v",   0, 136, w0,  w2,  w20);
   TEST_3R("and.v",   8, 104, w1,  w16, w8);
   TEST_3R("and.v",  16,   8, w2,  w2,  w2);
   TEST_3R("and.v",  24,  96, w3,  w22, w16);
   TEST_3R("and.v",  32, 152, w4,  w29, w1);
   TEST_3R("and.v",  40, 208, w5,  w9,  w2);
   TEST_3R("and.v",  48, 232, w6,  w12, w7);
   TEST_3R("and.v",  56, 160, w7,  w6,  w18);
   TEST_3R("and.v",  64,  64, w8,  w29, w4);
   TEST_3R("and.v",  72, 208, w9,  w6,  w24);
   TEST_3R("and.v",  80, 152, w10, w21, w3);
   TEST_3R("and.v",  88, 224, w11, w23, w11);
   TEST_3R("and.v",  96,  24, w12, w22, w7);
   TEST_3R("and.v", 104, 208, w13, w18, w16);
   TEST_3R("and.v", 112, 176, w14, w2,  w3);
   TEST_3R("and.v", 120, 216, w15, w15, w3);
   TEST_3R("and.v", 128,  56, w16, w28, w5);
   TEST_3R("and.v", 136,  56, w17, w8,  w12);
   TEST_3R("and.v", 144,  56, w18, w14, w14);
   TEST_3R("and.v", 152,  48, w19, w31, w11);
   TEST_3R("and.v", 160, 104, w20, w18, w17);
   TEST_3R("and.v", 168,  24, w21, w7,  w6);
   TEST_3R("and.v", 176, 128, w22, w15, w29);
   TEST_3R("and.v", 184, 112, w23, w5,  w20);
   TEST_3R("and.v", 192, 120, w24, w21, w10);
   TEST_3R("and.v", 200, 144, w25, w28, w29);
   TEST_3R("and.v", 208,  80, w26, w24, w2);
   TEST_3R("and.v", 216, 136, w27, w0,  w15);
   TEST_3R("and.v", 224, 104, w28, w15, w14);
   TEST_3R("and.v", 232, 136, w29, w26, w17);
   TEST_3R("and.v", 240,  16, w30, w12, w13);
   TEST_3R("and.v",  64,  48, w31, w18, w11);
   TEST_3R("bmnz.v",   0, 232, w0,  w10, w31);
   TEST_3R("bmnz.v",   8, 224, w1,  w1,  w1);
   TEST_3R("bmnz.v",  16,   8, w2,  w28, w5);
   TEST_3R("bmnz.v",  24,  88, w3,  w20, w7);
   TEST_3R("bmnz.v",  32,  96, w4,  w21, w22);
   TEST_3R("bmnz.v",  40,  40, w5,  w4,  w11);
   TEST_3R("bmnz.v",  48, 160, w6,  w22, w10);
   TEST_3R("bmnz.v",  56, 168, w7,  w8,  w29);
   TEST_3R("bmnz.v",  64, 184, w8,  w25, w13);
   TEST_3R("bmnz.v",  72, 128, w9,  w16, w2);
   TEST_3R("bmnz.v",  80,  80, w10, w31, w12);
   TEST_3R("bmnz.v",  88, 224, w11, w7,  w16);
   TEST_3R("bmnz.v",  96,  64, w12, w8,  w21);
   TEST_3R("bmnz.v", 104, 184, w13, w1,  w10);
   TEST_3R("bmnz.v", 112,  72, w14, w4,  w4);
   TEST_3R("bmnz.v", 120, 120, w15, w14, w16);
   TEST_3R("bmnz.v", 128, 224, w16, w4,  w22);
   TEST_3R("bmnz.v", 136, 224, w17, w7,  w30);
   TEST_3R("bmnz.v", 144, 160, w18, w22, w23);
   TEST_3R("bmnz.v", 152,  48, w19, w5,  w8);
   TEST_3R("bmnz.v", 160, 104, w20, w10, w7);
   TEST_3R("bmnz.v", 168, 216, w21, w15, w21);
   TEST_3R("bmnz.v", 176,  56, w22, w31, w15);
   TEST_3R("bmnz.v", 184,   0, w23, w23, w7);
   TEST_3R("bmnz.v", 192, 136, w24, w13, w9);
   TEST_3R("bmnz.v", 200, 216, w25, w23, w13);
   TEST_3R("bmnz.v", 208, 216, w26, w6,  w29);
   TEST_3R("bmnz.v", 216,  80, w27, w10, w19);
   TEST_3R("bmnz.v", 224, 176, w28, w18, w17);
   TEST_3R("bmnz.v", 232,  96, w29, w8,  w9);
   TEST_3R("bmnz.v", 240,  24, w30, w13, w17);
   TEST_3R("bmnz.v", 128,  48, w31, w24, w7);
   TEST_3R("bmz.v",   0, 184, w0,  w27, w0);
   TEST_3R("bmz.v",   8,   0, w1,  w23, w9);
   TEST_3R("bmz.v",  16, 184, w2,  w5,  w6);
   TEST_3R("bmz.v",  24,  64, w3,  w2,  w15);
   TEST_3R("bmz.v",  32, 176, w4,  w22, w15);
   TEST_3R("bmz.v",  40, 200, w5,  w7,  w3);
   TEST_3R("bmz.v",  48,  88, w6,  w16, w24);
   TEST_3R("bmz.v",  56,  16, w7,  w7,  w7);
   TEST_3R("bmz.v",  64, 168, w8,  w16, w21);
   TEST_3R("bmz.v",  72,  56, w9,  w23, w28);
   TEST_3R("bmz.v",  80, 120, w10, w30, w18);
   TEST_3R("bmz.v",  88, 192, w11, w13, w4);
   TEST_3R("bmz.v",  96,  40, w12, w18, w9);
   TEST_3R("bmz.v", 104, 104, w13, w29, w12);
   TEST_3R("bmz.v", 112, 128, w14, w18, w18);
   TEST_3R("bmz.v", 120,  72, w15, w27, w26);
   TEST_3R("bmz.v", 128, 136, w16, w30, w9);
   TEST_3R("bmz.v", 136, 152, w17, w22, w6);
   TEST_3R("bmz.v", 144,  80, w18, w6,  w27);
   TEST_3R("bmz.v", 152,  16, w19, w29, w23);
   TEST_3R("bmz.v", 160,  16, w20, w28, w10);
   TEST_3R("bmz.v", 168, 208, w21, w9,  w23);
   TEST_3R("bmz.v", 176, 184, w22, w22, w13);
   TEST_3R("bmz.v", 184, 160, w23, w19, w11);
   TEST_3R("bmz.v", 192, 112, w24, w3,  w23);
   TEST_3R("bmz.v", 200, 120, w25, w5,  w18);
   TEST_3R("bmz.v", 208, 224, w26, w14, w16);
   TEST_3R("bmz.v", 216, 184, w27, w8,  w6);
   TEST_3R("bmz.v", 224, 216, w28, w4,  w12);
   TEST_3R("bmz.v", 232,   8, w29, w25, w10);
   TEST_3R("bmz.v", 240, 168, w30, w13, w6);
   TEST_3R("bmz.v", 224,  32, w31, w1,  w15);
   TEST_3R("bsel.v",   0,  80, w0,  w27, w5);
   TEST_3R("bsel.v",   8,   8, w1,  w18, w8);
   TEST_3R("bsel.v",  16, 120, w2,  w5,  w4);
   TEST_3R("bsel.v",  24,   0, w3,  w21, w10);
   TEST_3R("bsel.v",  32, 144, w4,  w28, w23);
   TEST_3R("bsel.v",  40, 136, w5,  w8,  w31);
   TEST_3R("bsel.v",  48,  24, w6,  w18, w30);
   TEST_3R("bsel.v",  56,  40, w7,  w24, w8);
   TEST_3R("bsel.v",  64,  32, w8,  w7,  w9);
   TEST_3R("bsel.v",  72, 160, w9,  w4,  w24);
   TEST_3R("bsel.v",  80,  88, w10, w23, w19);
   TEST_3R("bsel.v",  88,   0, w11, w14, w6);
   TEST_3R("bsel.v",  96, 152, w12, w9,  w11);
   TEST_3R("bsel.v", 104, 176, w13, w19, w0);
   TEST_3R("bsel.v", 112,  24, w14, w6,  w28);
   TEST_3R("bsel.v", 120,  64, w15, w15, w28);
   TEST_3R("bsel.v", 128,  64, w16, w9,  w12);
   TEST_3R("bsel.v", 136, 144, w17, w7,  w9);
   TEST_3R("bsel.v", 144,   0, w18, w15, w7);
   TEST_3R("bsel.v", 152, 168, w19, w24, w24);
   TEST_3R("bsel.v", 160,  88, w20, w27, w17);
   TEST_3R("bsel.v", 168, 160, w21, w19, w21);
   TEST_3R("bsel.v", 176, 184, w22, w27, w1);
   TEST_3R("bsel.v", 184, 112, w23, w31, w10);
   TEST_3R("bsel.v", 192, 224, w24, w7,  w30);
   TEST_3R("bsel.v", 200, 208, w25, w26, w4);
   TEST_3R("bsel.v", 208,  32, w26, w4,  w0);
   TEST_3R("bsel.v", 216, 216, w27, w13, w12);
   TEST_3R("bsel.v", 224,  32, w28, w28, w28);
   TEST_3R("bsel.v", 232,  64, w29, w21, w31);
   TEST_3R("bsel.v", 240,   8, w30, w29, w22);
   TEST_3R("bsel.v", 112,  72, w31, w5,  w18);
   TEST_3R("nor.v",   0,  64, w0,  w29, w30);
   TEST_3R("nor.v",   8,   8, w1,  w18, w6);
   TEST_3R("nor.v",  16,   0, w2,  w8,  w0);
   TEST_3R("nor.v",  24,  32, w3,  w27, w5);
   TEST_3R("nor.v",  32, 144, w4,  w18, w31);
   TEST_3R("nor.v",  40, 144, w5,  w5,  w5);
   TEST_3R("nor.v",  48,  16, w6,  w21, w21);
   TEST_3R("nor.v",  56,  16, w7,  w12, w18);
   TEST_3R("nor.v",  64, 168, w8,  w9,  w23);
   TEST_3R("nor.v",  72,  56, w9,  w23, w28);
   TEST_3R("nor.v",  80, 192, w10, w9,  w27);
   TEST_3R("nor.v",  88, 128, w11, w6,  w26);
   TEST_3R("nor.v",  96, 144, w12, w25, w0);
   TEST_3R("nor.v", 104,  16, w13, w1,  w0);
   TEST_3R("nor.v", 112,  56, w14, w28, w5);
   TEST_3R("nor.v", 120,  40, w15, w24, w16);
   TEST_3R("nor.v", 128, 136, w16, w13, w17);
   TEST_3R("nor.v", 136,   0, w17, w31, w8);
   TEST_3R("nor.v", 144,   0, w18, w18, w22);
   TEST_3R("nor.v", 152,  56, w19, w11, w18);
   TEST_3R("nor.v", 160, 128, w20, w21, w14);
   TEST_3R("nor.v", 168,  16, w21, w27, w8);
   TEST_3R("nor.v", 176, 168, w22, w20, w8);
   TEST_3R("nor.v", 184, 192, w23, w22, w8);
   TEST_3R("nor.v", 192,   8, w24, w18, w14);
   TEST_3R("nor.v", 200,  80, w25, w1,  w6);
   TEST_3R("nor.v", 208, 136, w26, w18, w5);
   TEST_3R("nor.v", 216, 168, w27, w3,  w17);
   TEST_3R("nor.v", 224, 192, w28, w11, w5);
   TEST_3R("nor.v", 232, 192, w29, w28, w17);
   TEST_3R("nor.v", 240, 112, w30, w27, w6);
   TEST_3R("nor.v",  40, 144, w31, w14, w31);
   TEST_3R("or.v",   0,   0, w0,  w12, w28);
   TEST_3R("or.v",   8,   8, w1,  w30, w10);
   TEST_3R("or.v",  16, 200, w2,  w0,  w16);
   TEST_3R("or.v",  24,  96, w3,  w18, w21);
   TEST_3R("or.v",  32,  32, w4,  w21, w6);
   TEST_3R("or.v",  40, 128, w5,  w5,  w5);
   TEST_3R("or.v",  48,  56, w6,  w12, w28);
   TEST_3R("or.v",  56,  96, w7,  w27, w23);
   TEST_3R("or.v",  64,   0, w8,  w31, w5);
   TEST_3R("or.v",  72, 120, w9,  w10, w26);
   TEST_3R("or.v",  80, 184, w10, w26, w6);
   TEST_3R("or.v",  88, 160, w11, w26, w5);
   TEST_3R("or.v",  96,  80, w12, w3,  w5);
   TEST_3R("or.v", 104, 104, w13, w12, w23);
   TEST_3R("or.v", 112,   0, w14, w2,  w12);
   TEST_3R("or.v", 120, 120, w15, w5,  w12);
   TEST_3R("or.v", 128,  72, w16, w11, w11);
   TEST_3R("or.v", 136,  88, w17, w25, w7);
   TEST_3R("or.v", 144, 224, w18, w28, w6);
   TEST_3R("or.v", 152,  64, w19, w0,  w19);
   TEST_3R("or.v", 160,  56, w20, w14, w27);
   TEST_3R("or.v", 168, 120, w21, w9,  w1);
   TEST_3R("or.v", 176, 224, w22, w22, w3);
   TEST_3R("or.v", 184, 200, w23, w12, w6);
   TEST_3R("or.v", 192, 144, w24, w0,  w18);
   TEST_3R("or.v", 200, 168, w25, w10, w21);
   TEST_3R("or.v", 208,  16, w26, w22, w6);
   TEST_3R("or.v", 216, 112, w27, w15, w13);
   TEST_3R("or.v", 224, 208, w28, w11, w19);
   TEST_3R("or.v", 232, 208, w29, w11, w3);
   TEST_3R("or.v", 240,  24, w30, w6,  w18);
   TEST_3R("or.v",  24, 160, w31, w8,  w26);
   TEST_3R("xor.v",   0,  56, w0,  w17, w14);
   TEST_3R("xor.v",   8, 128, w1,  w11, w9);
   TEST_3R("xor.v",  16, 152, w2,  w1,  w15);
   TEST_3R("xor.v",  24, 136, w3,  w16, w28);
   TEST_3R("xor.v",  32, 104, w4,  w27, w15);
   TEST_3R("xor.v",  40, 192, w5,  w7,  w18);
   TEST_3R("xor.v",  48, 224, w6,  w13, w4);
   TEST_3R("xor.v",  56, 176, w7,  w7,  w7);
   TEST_3R("xor.v",  64,  80, w8,  w31, w0);
   TEST_3R("xor.v",  72, 184, w9,  w6,  w7);
   TEST_3R("xor.v",  80,  72, w10, w13, w1);
   TEST_3R("xor.v",  88, 128, w11, w31, w15);
   TEST_3R("xor.v",  96, 136, w12, w10, w24);
   TEST_3R("xor.v", 104,  48, w13, w12, w7);
   TEST_3R("xor.v", 112,  56, w14, w28, w3);
   TEST_3R("xor.v", 120,  40, w15, w24, w18);
   TEST_3R("xor.v", 128, 232, w16, w31, w5);
   TEST_3R("xor.v", 136,  88, w17, w12, w9);
   TEST_3R("xor.v", 144, 104, w18, w2,  w8);
   TEST_3R("xor.v", 152, 128, w19, w6,  w14);
   TEST_3R("xor.v", 160, 128, w20, w4,  w28);
   TEST_3R("xor.v", 168,   0, w21, w30, w27);
   TEST_3R("xor.v", 176, 120, w22, w4,  w5);
   TEST_3R("xor.v", 184, 192, w23, w15, w17);
   TEST_3R("xor.v", 192,  72, w24, w2,  w14);
   TEST_3R("xor.v", 200,  96, w25, w30, w25);
   TEST_3R("xor.v", 208,  40, w26, w26, w29);
   TEST_3R("xor.v", 216, 152, w27, w5,  w2);
   TEST_3R("xor.v", 224,  72, w28, w17, w17);
   TEST_3R("xor.v", 232,  80, w29, w7,  w19);
   TEST_3R("xor.v", 240,   0, w30, w22, w25);
   TEST_3R("xor.v", 128, 184, w31, w12, w29);
#else
   printf("This test requires MSA extension.\n");
#endif
   return 0;
}
