## TFSA-2023-016: Seg fault in `tf.raw_ops.Print`

### CVE Number
CVE-2023-25660

### Impact
When the parameter `summarize` of `tf.raw_ops.Print` is zero, the new method `SummarizeArray<bool>` will reference to a nullptr, leading to a seg fault.

```python
import tensorflow as tf

tf.raw_ops.Print(input =  tf.constant([1, 1, 1, 1],dtype=tf.int32),
                            data =  [[False, False, False, False], [False], [False, False, False]],
                            message =  'tmp/I',
                            first_n = 100,
                            summarize = 0)
```

### Patches
We have patched the issue in GitHub commit [6d423b8bcc9aa9f5554dc988c1c16d038b508df1](https://github.com/tensorflow/tensorflow/commit/6d423b8bcc9aa9f5554dc988c1c16d038b508df1).

The fix will be included in TensorFlow 2.12. We will also cherrypick this commit on TensorFlow 2.11.1.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Yu Tian of Qihoo 360 AIVul Team
