//#define XERR
#include "screening.ih"

void Screening::addRound(LineInfo const &lineInfo)
{
    Round round(d_modalities.modalityIDs());

    auto in = Parser::extract(lineInfo, round);   // extracts the age

    if (not in)
        return;

    if (not increasingAge(round))
    {
        Err::msg(Err::ROUND_AGES_DONT_INC) << endl;
        return;
    }

    string modality;
    while (in >> modality)
    {
        Err::Context context;

        if (uint16_t idx = d_modalities.find(modality); idx == ~0U)
            context = Err::UNDEFINED_MODALITY;
        else
        {
            if (round.add(idx))
                continue;

            context = Err::MODALITY_REPEATED;
        }

        Err::msg(context) << endl;
        return;
    }

    d_roundVect.push_back(move(round));
}
