unit PlotWin;
{(c) Ning Hu 2001-2002}
{***************************************************}
{ Plot Form for NyqIDE                              }
{***************************************************}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ExtCtrls, ComCtrls, Printers,
  sgr_def, sgr_data,
  MMSystem, Spin, sgr_mark, ImgList, Main;

Type
  TPlotChild = class(TForm)
    PlotMenu: TMainMenu;
    mbCopy: TMenuItem;
    mCopyPlotDIB: TMenuItem;
    mCopyPlotMF: TMenuItem;
    StatusBar: TStatusBar;
    mbView: TMenuItem;
    mSetLimits: TMenuItem;
    NMenu: TMenuItem;
    mbZoom: TMenuItem;
    mZH: TMenuItem;
    mZV: TMenuItem;
    mZB: TMenuItem;
    mZN: TMenuItem;
    mShowpoints: TMenuItem;
    mShowlines: TMenuItem;
    QLine: Tsp_XYLine;
    mAxisproperties: TMenuItem;
    XYPlot: Tsp_XYPlot;
    BGImage: TImage;
    PointImageList: TImageList;
    mCustomdrawpoint: TMenuItem;
    X0LineMarker: Tsp_LineMarker;
    PopupMenu: TPopupMenu;
    mbCopyPopup: TMenuItem;
    mCopyPlotDIBPopup: TMenuItem;
    mCopyPlotMFPopup: TMenuItem;
    mbViewPopup: TMenuItem;
    mSetLimitsPopup: TMenuItem;
    mAxispropertiesPopup: TMenuItem;
    NPopup: TMenuItem;
    mShowpointsPopup: TMenuItem;
    mShowlinesPopup: TMenuItem;
    mCustomdrawpointPopup: TMenuItem;
    mbZoomPopup: TMenuItem;
    mZNPopup: TMenuItem;
    mZHPopup: TMenuItem;
    mZVPopup: TMenuItem;
    mZBPopup: TMenuItem;

    procedure FormCreate(Sender: TObject);

    procedure XYPlotMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure XYPlotAxisZoom(Sender: Tsp_Axis; var min, max: Double;
      var CanZoom: Boolean);
    procedure XYPlotFieldDraw(Sender: TObject);

    procedure mCopyPlotMFClick(Sender: TObject);
    procedure mCopyPlotDIBClick(Sender: TObject);

    procedure mSetLimitsClick(Sender: TObject);
    procedure mAxispropertiesClick(Sender: TObject);
    procedure mShowpointsClick(Sender: TObject);
    procedure mShowlinesClick(Sender: TObject);

    procedure mZVClick(Sender: TObject);
    procedure mZHClick(Sender: TObject);
    procedure mZBClick(Sender: TObject);
    procedure mZNClick(Sender: TObject);

    procedure QLineDrawCustomPoint(const XYLine: Tsp_XYLine; const xv,
      yv: Double; x, y: Integer);
    procedure mCustomdrawpointClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  protected
    { Public declarations }
   Scrolling, AbortScroll:boolean;
   procedure ShowHint(Sender: TObject);
{   procedure StartScan;}
  end;

var
  PlotChild: TPlotChild;

IMPLEMENTATION

uses AxisLmtsDlg, AxisPrptsDlg;

{$R *.DFM}

procedure TPlotChild.FormCreate(Sender: TObject);
begin //FormCreate
  FAxisPrptsDlg := TFAxisPrptsDlg.Create(Self);
  FAxisLmtsDlg := TFAxisLmtsDlg.Create(Self);
end;  //FormCreate

procedure TPlotChild.ShowHint(Sender: TObject);
begin
 StatusBar.Panels[1].Text:=GetLongHint(PlotChild.Hint);
end;


//click mouse on plot to see points values
procedure TPlotChild.XYPlotMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 with StatusBar, XYPlot do
  Panels[0].Text:=Format(' X=%7.4f  Y=%7.4f',
  [BottomAxis.P2V(X), LeftAxis.P2V(Y)])
end;


var sparse:byte;
//
// Example of Draw customs points
procedure TPlotChild.QLineDrawCustomPoint(const XYLine: Tsp_XYLine;
  const xv, yv: Double; x, y: Integer);
var xe,ye:integer;
begin
 with XYLine do begin
   with PointImageList do
    Draw(XYLine.Canvas, x-width div 2, y-height div 2, 0);
   if not(DrawingLegendMarker) then begin
     inc(sparse);
     if sparse>3 then with XYLine.Canvas do
     begin
       sparse:=0;
       Font:=Plot.Font;
       xe:=x-1;
       ye:=y-PointAttr.VSize-6;
       MoveTo(x-1,y-1); LineTo(xe,ye);
       dec(ye,abs(Font.Height));
       TextOut(xe-2, ye, Format('%7.4f',[yv]));
     end;
   end;
 end;
end;


procedure TPlotChild.XYPlotFieldDraw(Sender: TObject);
//OnFieldDraw handler draws bitmap texture
var BGBMP:TBitmap; w,h:integer;
begin
  sparse:=0; //it is for custom points draw
  BGBMP:=BGImage.Picture.Bitmap;
  with Sender as Tsp_xyPlot do
  with DCanvas, FieldRect do
  begin
      h:=Top;
      repeat
        w:=Left;
        repeat
          Draw(w,h, BGBMP);
          inc(w, BGBMP.Width);
        until w>Right;
        inc(h, BGBMP.Height);
      until h>Bottom
  end
end;

//disable zoom RightAxis and TopAxis - we don't use them
procedure TPlotChild.XYPlotAxisZoom(Sender: Tsp_Axis; var min, max: Double;
  var CanZoom: Boolean);
begin
 with XYPlot do
  if (Sender=RightAxis) or (Sender=TopAxis) then CanZoom:=False;
end;

{* Menu handlers *}

//Copy

procedure TPlotChild.mCopyPlotMFClick(Sender: TObject);
begin
 XYPlot.CopyToClipboardMetafile;
end;

procedure TPlotChild.mCopyPlotDIBClick(Sender: TObject);
begin
 XYPlot.CopyToClipboardBitmap;
end;

//View

procedure TPlotChild.mSetLimitsClick(Sender: TObject);
begin
 SetPlotLimits(XYPlot);
end;

procedure TPlotChild.mAxispropertiesClick(Sender: TObject);
begin
 SetAxisProperties(XYPlot);
end;

procedure TPlotChild.mShowpointsClick(Sender: TObject);
var pon:boolean; j:integer;
begin
 pon:=not(Sender as TMenuItem).Checked;
 (Sender as TMenuItem).Checked:=pon;
 for j:=0 to XYPlot.SeriesCount-1 do
   with XYPlot.Series[j] as Tsp_XYLine do PointAttr.Visible:=pon;
end;

procedure TPlotChild.mShowlinesClick(Sender: TObject);
var pon:boolean; j:integer;
begin
 pon:=not(Sender as TMenuItem).Checked;
 (Sender as TMenuItem).Checked:=pon;
 for j:=0 to XYPlot.SeriesCount-1 do
   with XYPlot.Series[j] as Tsp_XYLine do LineAttr.Visible:=pon;
end;

procedure TPlotChild.mCustomdrawpointClick(Sender: TObject);
begin
  mCustomdrawpoint.Checked:=not mCustomdrawpoint.Checked;
  if mCustomdrawpoint.Checked then QLine.PointAttr.Kind:=ptCustom
  else QLine.PointAttr.Kind:=ptEllipse;
end;

//Zoom

procedure TPlotChild.mZNClick(Sender: TObject);
begin
 mZN.Checked :=True;
 if mZN.Checked then XYPlot.Zoom:=zpdNone;
end;

procedure TPlotChild.mZHClick(Sender: TObject);
begin
 mZH.Checked:=True;
 if mZH.Checked then XYPlot.Zoom:=zpdHorizontal;
end;

procedure TPlotChild.mZVClick(Sender: TObject);
begin
 mZV.Checked:=True;
 if mZV.Checked then XYPlot.Zoom:=zpdVertical
end;

procedure TPlotChild.mZBClick(Sender: TObject);
begin
 mZB.Checked:=True;
 if mZB.Checked then XYPlot.Zoom:=zpdBoth;
end;

procedure TPlotChild.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if MainForm.MDIChildCount = 1 then
   with MainForm do
    begin
      StatusLine.Panels[1].Text := '';
      SetModified(false);
      MainForm.MenuEnabled(false);
      MainForm.FileCloseItem.Enabled := false;
      MainForm.FileCloseAllItem.Enabled := false;
    end;
  Action := caFree;
end;

procedure TPlotChild.FormActivate(Sender: TObject);
begin
  MainForm.MenuEnabled(false);
  MainForm.StatusLine.Panels[1].Text := '';
  MainForm.SetModified(false);
end;

END.
