/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.chefproject.convert.ContentContainerConverter;
import org.chefproject.core.ContentCollection;
import org.chefproject.core.ContentCollectionEdit;
import org.chefproject.core.ContentResource;
import org.chefproject.core.ContentResourceEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.service.component.BaseContentService;
import org.chefproject.service.component.BaseDbSingleStorage;
import org.chefproject.util.Sql;
import org.chefproject.util.Validator;

public class DbCachedContentService
extends BaseContentService {
    protected String m_collectionTableName = "CONTENT_COLLECTION";
    protected String m_resourceTableName = "CONTENT_RESOURCE";
    protected String m_resourceBodyTableName = "CONTENT_RESOURCE_BODY_BINARY";
    protected boolean m_locksInDb = true;
    protected static final String[] FIELDS = new String[]{"IN_COLLECTION"};

    public void init() throws InitializationException {
        this.m_collectionTableName = this.getProperties().getProperty("collectionTable", this.m_collectionTableName);
        this.m_resourceTableName = this.getProperties().getProperty("resourceTable", this.m_resourceTableName);
        this.m_resourceBodyTableName = this.getProperties().getProperty("resourceBodyTable", this.m_resourceBodyTableName);
        this.m_locksInDb = new Boolean(this.getProperties().getProperty("locks-db", "true"));
        boolean containerCoversion = new Boolean(this.getProperties().getProperty("containerConversion", "false"));
        super.init();
        if (containerCoversion) {
            ContentContainerConverter.convert();
        }
        Log.info("chef", this + ".init(): collection table: " + this.m_collectionTableName + " resource table: " + this.m_resourceTableName + " resource body table: " + this.m_resourceBodyTableName);
    }

    protected BaseContentService.Storage newStorage() {
        return new DbStorage(new BaseContentService.CollectionStorageUser(), new BaseContentService.ResourceStorageUser());
    }

    protected class DbStorage
    implements BaseContentService.Storage {
        protected BaseDbSingleStorage m_collectionStore = null;
        protected BaseDbSingleStorage m_resourceStore = null;

        public DbStorage(StorageUser collectionUser, StorageUser resourceUser) {
            this.m_collectionStore = new BaseDbSingleStorage(DbCachedContentService.this.m_collectionTableName, "COLLECTION_ID", FIELDS, DbCachedContentService.this.m_locksInDb, "collection", collectionUser);
            this.m_resourceStore = new BaseDbSingleStorage(DbCachedContentService.this.m_resourceTableName, "RESOURCE_ID", FIELDS, DbCachedContentService.this.m_locksInDb, "resource", resourceUser);
        }

        public void open() {
            this.m_collectionStore.open();
            this.m_resourceStore.open();
        }

        public void close() {
            this.m_collectionStore.close();
            this.m_resourceStore.close();
        }

        public boolean checkCollection(String id) {
            return this.m_collectionStore.checkResource(id);
        }

        public ContentCollection getCollection(String id) {
            return (ContentCollection)this.m_collectionStore.getResource(id);
        }

        public List getCollections(ContentCollection collection) {
            String target = collection.getId();
            String sqlWhere = "WHERE IN_COLLECTION='" + target + "'";
            List rv = this.m_collectionStore.getSelectedResourcesWhere(sqlWhere);
            return rv;
        }

        public ContentCollectionEdit putCollection(String id) {
            return (ContentCollectionEdit)this.m_collectionStore.putResource(id, null);
        }

        public ContentCollectionEdit editCollection(String id) {
            return (ContentCollectionEdit)this.m_collectionStore.editResource(id);
        }

        public void commitCollection(ContentCollectionEdit edit) {
            this.m_collectionStore.commitResource(edit);
        }

        public void cancelCollection(ContentCollectionEdit edit) {
            this.m_collectionStore.cancelResource(edit);
        }

        public void removeCollection(ContentCollectionEdit edit) {
            this.m_collectionStore.removeResource(edit);
        }

        public boolean checkResource(String id) {
            return this.m_resourceStore.checkResource(id);
        }

        public ContentResource getResource(String id) {
            return (ContentResource)this.m_resourceStore.getResource(id);
        }

        public List getResources(ContentCollection collection) {
            String target = collection.getId();
            String sqlWhere = "WHERE IN_COLLECTION='" + target + "'";
            List rv = this.m_resourceStore.getSelectedResourcesWhere(sqlWhere);
            return rv;
        }

        public ContentResourceEdit putResource(String id) {
            return (ContentResourceEdit)this.m_resourceStore.putResource(id, null);
        }

        public ContentResourceEdit editResource(String id) {
            return (ContentResourceEdit)this.m_resourceStore.editResource(id);
        }

        public void commitResource(ContentResourceEdit edit) {
            byte[] body = ((BaseContentService.BaseResourceEdit)edit).m_body;
            ((BaseContentService.BaseResourceEdit)edit).m_body = null;
            this.m_resourceStore.commitResource(edit);
            if (body != null) {
                this.putResourceBody(edit, body);
            }
        }

        public void cancelResource(ContentResourceEdit edit) {
            byte[] body = ((BaseContentService.BaseResourceEdit)edit).m_body;
            ((BaseContentService.BaseResourceEdit)edit).m_body = null;
            this.m_resourceStore.cancelResource(edit);
        }

        public void removeResource(ContentResourceEdit edit) {
            byte[] body = ((BaseContentService.BaseResourceEdit)edit).m_body;
            ((BaseContentService.BaseResourceEdit)edit).m_body = null;
            this.m_resourceStore.removeResource(edit);
        }

        public byte[] getResourceBody(ContentResource resource) {
            if (((BaseContentService.BaseResourceEdit)resource).m_contentLength <= 0) {
                Log.warn("chef", this + ".getResourceBody(): non-positive content length: " + ((BaseContentService.BaseResourceEdit)resource).m_contentLength + "  id: " + resource.getId());
                return null;
            }
            String sql = "select BODY from " + DbCachedContentService.this.m_resourceBodyTableName + " where ( RESOURCE_ID = '" + Validator.escapeSql(resource.getId()) + "' )";
            byte[] body = new byte[((BaseContentService.BaseResourceEdit)resource).m_contentLength];
            Sql.dbReadBinary(sql, body);
            return body;
        }

        public void putResourceBody(ContentResourceEdit resource, byte[] body) {
            if (body == null || body.length == 0) {
                return;
            }
            String statement = "delete from " + DbCachedContentService.this.m_resourceBodyTableName + " where resource_id = " + "'" + Validator.escapeSql(resource.getId()) + "'";
            Sql.dbWrite(statement);
            statement = "insert into " + DbCachedContentService.this.m_resourceBodyTableName + " (RESOURCE_ID, BODY)" + " values ( " + "'" + Validator.escapeSql(resource.getId()) + "'" + ", ? )";
            Sql.dbWriteBinary(statement, body, 0, body.length);
        }
    }
}

