/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.turbine.util.FormMessage;

public class FormMessages {
    private Hashtable forms_messages = new Hashtable();
    private Hashtable fields_messages = new Hashtable();
    private Hashtable messages_fields = new Hashtable();
    private Hashtable forms_fields = new Hashtable();

    public void setMessage(String formName, String fieldName, long returnCode) {
        this.setMessage(formName, fieldName, String.valueOf(returnCode));
    }

    public void setMessage(String formName, String fieldName, String messageName) {
        fieldName = formName + "-" + fieldName;
        this.addValue(this.forms_messages, formName, messageName);
        this.addValue(this.fields_messages, fieldName, messageName);
        this.addValue(this.messages_fields, messageName, fieldName);
        this.addValue(this.forms_fields, formName, fieldName);
    }

    private void addValue(Hashtable table, String key, String value) {
        if (!table.containsKey(key)) {
            Vector<String> values = new Vector<String>();
            values.addElement(value);
            table.put(key, values);
        } else {
            Vector values = (Vector)table.get(key);
            if (!values.contains(value)) {
                values.addElement(value);
            }
        }
    }

    private final Vector getValues(Hashtable table, String key) {
        return (Vector)table.get(key);
    }

    public FormMessage[] getFormMessages(String formName) {
        Vector messages = this.getValues(this.forms_messages, formName);
        if (messages != null) {
            FormMessage[] result = new FormMessage[messages.size()];
            int i = 0;
            while (i < messages.size()) {
                result[i] = new FormMessage(formName);
                String messageName = (String)messages.elementAt(i);
                result[i].setMessage(messageName);
                Vector fields = this.getValues(this.messages_fields, messageName);
                int j = 0;
                while (j < fields.size()) {
                    String fieldName = (String)fields.elementAt(j);
                    if (this.formHasField(formName, fieldName)) {
                        result[i].setFieldName(fieldName);
                    }
                    ++j;
                }
                ++i;
            }
            return result;
        }
        return null;
    }

    public FormMessage[] getFormMessages(String formName, String fieldName) {
        String key = formName + "-" + fieldName;
        Vector messages = this.getValues(this.fields_messages, key);
        if (messages != null) {
            FormMessage[] result = new FormMessage[messages.size()];
            int i = 0;
            while (i < messages.size()) {
                result[i] = new FormMessage(formName, fieldName);
                String messageName = (String)messages.elementAt(i);
                result[i].setMessage(messageName);
                ++i;
            }
            return result;
        }
        return null;
    }

    private boolean formHasField(String formName, String fieldName) {
        Vector fields = this.getValues(this.forms_fields, formName);
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            if (!fieldName.equals(iter.next().toString())) continue;
            return true;
        }
        return false;
    }
}

