[comment {-*- Tcl -*- xowish manpage}]

[include version.inc]
[manpage_begin xowish 1 [vset VERSION]]

[copyright { 2014 Stefan Sobernig <stefan.sobernig@wu.ac.at>, Gustaf Neumann <gustaf.neumann@wu.ac.at>; available under the Creative Commons Attribution 3.0 Austria license (CC BY 3.0 AT).}]

[titledesc {Simple windowing shell containing NSF/XOTcl2 interpreter}]
[moddesc {Command-line interface}]

[description]

[list_begin definitions]

[call [syscmd "xowish"] [opt [arg fileName]]]

[syscmd "xowish"] is a shell-like application including Tcl and the XOTcl2 as well as the Tk toolkit. [syscmd "xowish"] creates a main window and, then, reads commands from its standard input or from [arg fileName] and evaluates them.  If invoked without [arg fileName], then it runs in REPL mode, reading commands from standard input. [syscmd "xowish"] will continue processing commands until all windows have been deleted or until end-of-file is reached on standard input.

[para] 

[syscmd "xowish"] can be used like [syscmd "wish"] to make XOTcl2 scripts directly invocable from the shell, by providing the following first line ("shebang") in the respective script:

[example {
	#! /usr/bin/env xowish 
}]

A (more portable) alternative is:

[example_begin]
	#! /bin/sh
	# the next line restarts using xowish \
	    exec xowish "$0" "$@"
[example_end]

[list_end]

[manpage_end]
