const analyze = require('rollup-plugin-analyzer');
const cleanup = require('rollup-plugin-cleanup');
const json = require('@rollup/plugin-json');
const resolve = require('@rollup/plugin-node-resolve').default;
const terser = require('rollup-plugin-terser').terser;
const pkg = require('./package.json');

const input = 'src/index.js';

const banner = `/*!
 * Chart.js v${pkg.version}
 * ${pkg.homepage}
 * (c) ${(new Date(process.env.SOURCE_DATE_EPOCH ? (process.env.SOURCE_DATE_EPOCH * 1000) : new Date().getTime())).getFullYear()} Chart.js Contributors
 * Released under the MIT License
 */`;

module.exports = [
  // UMD builds
  // dist/chart.min.js
  // dist/chart.js
  {
    input,
    plugins: [
      json(),
      resolve(),
      cleanup({
        sourcemap: true
      }),
      analyze({summaryOnly: true})
    ],
    output: {
      name: 'Chart',
      file: 'dist/chart.js',
      banner,
      format: 'umd',
      indent: false,
    },
  },
  {
    input,
    plugins: [
      json(),
      resolve(),
      terser({
        output: {
          preamble: banner
        }
      }),
    ],
    output: {
      name: 'Chart',
      file: 'dist/chart.min.js',
      format: 'umd',
      indent: false,
    },
  },

  // ES6 builds
  // dist/chart.mjs
  // helpers/*.js
  {
    input: {
      'dist/chart': 'src/index.esm.js',
      'dist/helpers': 'src/helpers/index.js'
    },
    plugins: [
      json(),
      resolve(),
      cleanup({
        sourcemap: true
      }),
    ],
    output: {
      dir: './',
      chunkFileNames: 'dist/chunks/[name].mjs',
      entryFileNames: '[name].mjs',
      banner,
      format: 'esm',
      indent: false,
    },
  },

  // Legacy ES6 builds for backwards compatibility. Remove for Chart.js 4.0
  // dist/chart.esm.js
  // helpers/*.js
  {
    input: {
      'dist/chart.esm': 'src/index.esm.js',
      'dist/helpers.esm': 'src/helpers/index.js'
    },
    plugins: [
      json(),
      resolve(),
      cleanup({
        sourcemap: true
      }),
    ],
    output: {
      dir: './',
      chunkFileNames: 'dist/chunks/[name].js',
      banner,
      format: 'esm',
      indent: false,
    },
  },
];
