# Create an Array

## From a JSON String

### Basic Example

@snippet api/bsoncxx/examples/bson_documents/create_array/json_basic.cpp Example

### With Extended JSON

@snippet api/bsoncxx/examples/bson_documents/create_array/json_extended.cpp Example

### With a Sub-Document

@snippet api/bsoncxx/examples/bson_documents/create_array/json_sub_document.cpp Example

### With a Sub-Array

@snippet api/bsoncxx/examples/bson_documents/create_array/json_sub_array.cpp Example

### With a User-Defined Literal

@snippet api/bsoncxx/examples/bson_documents/create_array/json_udl.cpp Example

## Using the Basic Builder

### Basic Example

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_basic.cpp Example

### With make_document

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_make_document.cpp Example

### With concatenate

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_concatenate.cpp Example

### With Multiple Appends

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_append.cpp Example

### To Create Multiple Documents

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_reset.cpp Example

### With a Value Type

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_value_type.cpp Example

### With a BSON Type

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_bson_type.cpp Example

### With a BSON Value

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_bson_value.cpp Example

### With a Sub-Document

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_sub_document.cpp Example

### With Multiple Sub-Document Appends

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_sub_document_append.cpp Example

### With a Sub-Array

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_sub_array.cpp Example

### With Multiple Sub-Array Appends

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_sub_array_append.cpp Example

## From Raw Bytes

### As a View

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_raw_view.cpp Example

### As a Value

@snippet api/bsoncxx/examples/bson_documents/create_array/builder_raw_value.cpp Example
