#!/bin/python2.7

import os

timezones = []
directory = '/usr/share/zoneinfo/'

for root, directories, filenames in os.walk(directory):
    for filename in filenames:
        if filename.endswith('.tab'):
            continue

        if filename.endswith('.zi'):
            continue

        if filename == 'leapseconds':
            continue

        if filename == 'posixrules':
            continue

        zone = os.path.join(root[len(directory):], filename)

        if zone.startswith("posix/"):
            continue

        if zone.startswith("right/"):
            continue

        timezones.append(zone)


timezones = sorted(list(set(timezones)))

tztable = open("tztable.h", "w")
tztable.write("//This file was generated by the zonetabconversion.py script\n")
tztable.write("static const char* olsonTimezones[] = {\n")

tztable.write('    "')
tztable.write('",\n    "'.join(timezones))
tztable.write('"\n};\n')
tztable.write('\n')
tztable.write('static const long unsigned int numOlsonTimezones = sizeof olsonTimezones / sizeof *olsonTimezones;\n')
tztable.write("\n")
