/*
 * Copyright (c) 2008, Aaron Digulla
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Aaron Digulla nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
package de.pdark.decentxml;

public class TextUtils
{
    /** Convert a text into a valid ISO-Latin-1 Java string constant */
    public static String escapeJavaString (String s)
    {
        if (s == null)
            return "null";
        
        StringBuilder buffer = new StringBuilder ();
        buffer.append ('"');
        for (int i=0; i<s.length (); i++)
        {
            char c = s.charAt (i);
            switch (c)
            {
            case '\n': buffer.append ("\\n"); break;
            case '\r': buffer.append ("\\r"); break;
            case '\t': buffer.append ("\\t"); break;
            case '"': buffer.append ("\\\""); break;
            default:
                if (c < 16)
                {
                    buffer.append ("\\u000");
                    buffer.append (Integer.toHexString (c));
                }
                else if (c < 32 || (c >= 128 && c < 161))
                {
                    buffer.append ("\\u00");
                    buffer.append (Integer.toHexString (c));
                }
                else if (c > 256 && c < 0x1000)
                {
                    buffer.append ("\\u0");
                    buffer.append (Integer.toHexString (c));
                }
                else if (c >= 0x1000)
                {
                    buffer.append ("\\u");
                    buffer.append (Integer.toHexString (c));
                }
                else
                    buffer.append (c);
            }
        }
        buffer.append ('"');
        return buffer.toString ();
    }
}
