/* ----- pow/inv25519, derived from supercop/crypto_pow/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <lib25519.h>
#include "lib25519_test.h"

#define fail ((ok = 0),printf)
static const char *pow_inv25519_checksums[] = {
  "ad2062946e82718da820226504991a85c5fe56bdbff959c1313f837ee13b37be",
  "59b3045a01e1fca2a86a0280aee8b985c5e040afdc0d3e85ed87eb97a46a4dd6",
} ;

static void (*crypto_pow)(unsigned char *,const unsigned char *);
#define crypto_pow_BYTES lib25519_pow_inv25519_BYTES

static void *storage_pow_inv25519_q;
static unsigned char *test_pow_inv25519_q;
static void *storage_pow_inv25519_p;
static unsigned char *test_pow_inv25519_p;
static void *storage_pow_inv25519_q2;
static unsigned char *test_pow_inv25519_q2;
static void *storage_pow_inv25519_p2;
static unsigned char *test_pow_inv25519_p2;

#define precomputed_pow_inv25519_NUM 296

static const unsigned char precomputed_pow_inv25519_q_0[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_0[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_1[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_1[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_2[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_2[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_3[] = {73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_pow_inv25519_p_3[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_4[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_pow_inv25519_p_4[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_5[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_pow_inv25519_p_5[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_6[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_pow_inv25519_p_6[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_7[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_pow_inv25519_p_7[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_8[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_pow_inv25519_p_8[] = {8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_9[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_pow_inv25519_p_9[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_10[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_pow_inv25519_p_10[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_11[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_pow_inv25519_p_11[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_12[] = {68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_pow_inv25519_p_12[] = {12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_13[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_pow_inv25519_p_13[] = {13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_14[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_pow_inv25519_p_14[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_15[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_pow_inv25519_p_15[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_16[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_pow_inv25519_p_16[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_17[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_pow_inv25519_p_17[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_18[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35};
static const unsigned char precomputed_pow_inv25519_p_18[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_19[] = {20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47};
static const unsigned char precomputed_pow_inv25519_p_19[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_20[] = {92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70};
static const unsigned char precomputed_pow_inv25519_p_20[] = {20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_21[] = {47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12};
static const unsigned char precomputed_pow_inv25519_p_21[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_22[] = {19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29};
static const unsigned char precomputed_pow_inv25519_p_22[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_23[] = {195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111};
static const unsigned char precomputed_pow_inv25519_p_23[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_24[] = {162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58};
static const unsigned char precomputed_pow_inv25519_p_24[] = {24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_25[] = {30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5};
static const unsigned char precomputed_pow_inv25519_p_25[] = {25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_26[] = {124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93};
static const unsigned char precomputed_pow_inv25519_p_26[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_27[] = {6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23};
static const unsigned char precomputed_pow_inv25519_p_27[] = {27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_28[] = {21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105};
static const unsigned char precomputed_pow_inv25519_p_28[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_29[] = {189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35};
static const unsigned char precomputed_pow_inv25519_p_29[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_30[] = {232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_pow_inv25519_p_30[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_31[] = {104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78};
static const unsigned char precomputed_pow_inv25519_p_31[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_q_32[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_pow_inv25519_p_32[] = {224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_pow_inv25519_q_33[] = {38,221,244,121,160,140,135,138,91,246,171,251,42,229,30,53,137,92,183,112,97,134,244,149,52,224,229,52,101,97,145,127};
static const unsigned char precomputed_pow_inv25519_p_33[] = {93,11,17,172,237,85,188,115,119,16,223,201,212,27,197,64,137,178,244,179,157,47,164,117,22,93,38,107,152,98,219,3};
static const unsigned char precomputed_pow_inv25519_q_34[] = {31,73,133,189,148,129,160,37,174,162,214,165,201,252,137,0,218,176,230,165,23,126,230,255,196,214,236,207,2,77,81,37};
static const unsigned char precomputed_pow_inv25519_p_34[] = {129,156,209,97,216,127,230,10,196,93,131,132,8,72,64,192,105,34,102,132,50,137,243,123,140,203,186,159,122,99,243,5};
static const unsigned char precomputed_pow_inv25519_q_35[] = {19,82,242,135,133,161,110,239,185,137,126,205,221,147,170,22,90,141,0,210,119,232,26,163,149,111,118,253,222,3,226,73};
static const unsigned char precomputed_pow_inv25519_p_35[] = {38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5};
static const unsigned char precomputed_pow_inv25519_q_36[] = {166,52,194,117,195,131,147,130,49,176,243,246,89,219,228,148,224,102,213,222,219,41,109,11,190,118,174,188,216,106,209,7};
static const unsigned char precomputed_pow_inv25519_p_36[] = {241,83,53,187,193,212,174,9,91,104,0,113,237,209,237,22,148,228,44,251,112,52,5,238,132,246,185,178,166,111,115,6};
static const unsigned char precomputed_pow_inv25519_q_37[] = {64,83,70,138,197,143,41,181,1,61,160,174,192,213,164,235,142,132,203,134,232,145,182,128,27,160,170,67,19,240,15,76};
static const unsigned char precomputed_pow_inv25519_p_37[] = {18,224,16,248,231,39,70,45,164,115,44,162,53,252,179,95,2,27,27,175,27,137,178,112,130,229,197,157,121,62,86,7};
static const unsigned char precomputed_pow_inv25519_q_38[] = {61,237,173,151,232,124,229,83,142,240,16,116,25,67,58,230,223,197,172,201,53,68,215,224,68,88,216,73,128,27,86,102};
static const unsigned char precomputed_pow_inv25519_p_38[] = {194,182,111,24,203,182,215,90,236,39,243,118,38,38,194,23,129,253,47,15,169,145,119,89,206,112,13,89,22,153,145,8};
static const unsigned char precomputed_pow_inv25519_q_39[] = {79,136,214,213,186,148,59,147,202,128,21,64,171,141,222,175,233,198,247,208,187,227,246,47,84,98,142,3,140,220,155,104};
static const unsigned char precomputed_pow_inv25519_p_39[] = {147,51,243,23,109,22,116,225,167,164,124,223,197,41,98,238,117,177,164,47,181,37,180,135,79,242,51,29,115,141,98,14};
static const unsigned char precomputed_pow_inv25519_q_40[] = {185,216,110,172,45,205,198,159,142,243,151,169,151,195,36,173,182,208,242,83,225,213,58,26,140,107,163,60,166,34,213,122};
static const unsigned char precomputed_pow_inv25519_p_40[] = {89,46,240,193,138,63,158,190,180,203,64,132,82,50,71,171,123,216,172,8,77,178,79,47,185,39,160,188,151,34,173,14};
static const unsigned char precomputed_pow_inv25519_q_41[] = {52,192,155,149,157,69,10,35,45,123,136,36,198,171,92,77,61,235,133,155,107,234,184,43,148,43,78,72,236,127,77,1};
static const unsigned char precomputed_pow_inv25519_p_41[] = {40,12,236,4,15,64,117,117,178,230,19,71,19,19,53,18,49,14,105,80,148,246,106,11,48,194,189,8,254,67,5,16};
static const unsigned char precomputed_pow_inv25519_q_42[] = {8,234,10,87,166,164,61,70,11,230,67,7,129,10,190,96,223,225,34,242,217,231,116,111,105,145,107,181,110,7,188,75};
static const unsigned char precomputed_pow_inv25519_p_42[] = {226,201,13,23,87,255,179,198,122,236,86,21,27,53,231,55,3,212,2,105,232,68,167,199,168,213,242,58,121,163,88,16};
static const unsigned char precomputed_pow_inv25519_q_43[] = {252,236,57,250,166,229,172,78,226,121,142,145,209,165,31,76,181,206,99,67,25,29,185,105,201,93,213,246,132,121,178,46};
static const unsigned char precomputed_pow_inv25519_p_43[] = {195,82,178,226,156,181,31,63,226,89,157,119,162,33,68,89,2,238,250,158,169,215,75,100,121,252,214,208,192,209,207,16};
static const unsigned char precomputed_pow_inv25519_q_44[] = {153,117,135,100,29,207,138,247,147,39,254,150,219,28,79,248,19,76,43,171,33,194,44,19,22,157,198,93,162,18,218,106};
static const unsigned char precomputed_pow_inv25519_p_44[] = {62,201,173,102,22,52,130,75,143,176,41,3,70,250,182,70,220,18,105,64,77,107,233,159,157,35,169,41,102,215,53,17};
static const unsigned char precomputed_pow_inv25519_q_45[] = {57,223,157,125,238,224,147,49,254,234,178,208,159,240,225,64,132,52,197,214,65,81,250,170,171,134,212,82,97,17,143,57};
static const unsigned char precomputed_pow_inv25519_p_45[] = {147,246,106,224,201,236,94,37,219,83,4,251,201,149,209,68,14,88,2,140,90,210,82,209,250,61,250,245,196,119,203,26};
static const unsigned char precomputed_pow_inv25519_q_46[] = {123,212,179,176,52,203,182,207,40,108,123,109,127,207,180,121,253,77,50,4,27,72,51,207,112,244,196,13,208,89,48,125};
static const unsigned char precomputed_pow_inv25519_p_46[] = {74,200,238,22,199,37,200,128,148,15,80,145,16,3,161,120,84,71,251,230,95,47,35,235,115,144,13,114,36,110,152,28};
static const unsigned char precomputed_pow_inv25519_q_47[] = {86,220,213,222,72,124,82,5,213,248,34,204,214,253,164,251,177,11,65,6,226,153,121,182,210,190,64,10,88,14,13,43};
static const unsigned char precomputed_pow_inv25519_p_47[] = {160,225,228,246,105,56,121,30,159,138,77,105,238,152,39,107,135,216,88,143,45,42,48,113,178,206,104,225,13,18,88,30};
static const unsigned char precomputed_pow_inv25519_q_48[] = {222,250,103,37,175,182,130,65,162,45,72,167,27,141,5,219,173,216,146,111,157,137,38,20,53,154,250,237,253,72,140,28};
static const unsigned char precomputed_pow_inv25519_p_48[] = {102,55,216,186,113,33,217,104,153,8,118,119,100,78,9,161,155,124,8,45,174,155,49,119,195,219,238,82,200,146,135,30};
static const unsigned char precomputed_pow_inv25519_q_49[] = {183,98,239,209,78,92,190,97,188,253,134,65,208,227,201,65,240,85,75,192,135,66,252,186,18,230,191,68,201,128,7,82};
static const unsigned char precomputed_pow_inv25519_p_49[] = {151,17,196,2,87,132,196,237,216,35,128,12,206,236,145,70,248,205,163,114,199,5,70,56,57,215,52,143,116,213,125,32};
static const unsigned char precomputed_pow_inv25519_q_50[] = {137,66,22,136,66,175,64,253,202,146,254,187,66,23,123,156,58,120,188,62,152,88,156,206,64,111,227,2,43,57,111,69};
static const unsigned char precomputed_pow_inv25519_p_50[] = {222,136,183,18,240,91,145,161,198,8,75,171,135,11,12,122,93,247,51,12,29,154,254,236,131,63,162,197,202,127,229,36};
static const unsigned char precomputed_pow_inv25519_q_51[] = {163,122,63,119,3,151,5,212,188,30,80,65,104,9,118,149,121,77,179,29,167,6,121,68,20,203,120,37,24,177,88,49};
static const unsigned char precomputed_pow_inv25519_p_51[] = {71,203,163,127,61,162,83,158,17,109,46,29,186,163,167,133,48,164,87,132,47,234,224,217,22,54,128,190,165,114,54,40};
static const unsigned char precomputed_pow_inv25519_q_52[] = {56,226,92,118,151,194,129,204,37,225,15,244,57,216,81,219,121,73,114,239,129,93,102,147,174,164,240,101,116,121,20,8};
static const unsigned char precomputed_pow_inv25519_p_52[] = {99,192,3,80,181,231,34,241,240,111,140,60,187,151,28,5,108,137,69,184,99,88,162,117,43,41,29,38,60,137,45,41};
static const unsigned char precomputed_pow_inv25519_q_53[] = {223,183,166,239,48,31,130,116,116,213,206,52,173,119,219,186,152,3,115,75,165,101,149,137,53,78,253,172,172,134,204,22};
static const unsigned char precomputed_pow_inv25519_p_53[] = {147,132,37,198,44,214,20,254,65,84,134,32,250,107,231,206,116,145,140,241,95,160,187,244,243,122,162,135,196,58,176,44};
static const unsigned char precomputed_pow_inv25519_q_54[] = {101,171,79,128,35,224,66,21,99,25,159,196,245,236,13,244,223,24,155,47,0,8,164,106,111,169,154,42,127,39,154,32};
static const unsigned char precomputed_pow_inv25519_p_54[] = {182,159,33,218,36,54,82,116,237,96,1,129,26,204,104,165,41,254,232,139,115,90,99,197,130,11,71,157,9,165,9,50};
static const unsigned char precomputed_pow_inv25519_q_55[] = {60,71,103,7,132,234,55,209,32,107,75,14,162,135,37,217,36,215,112,162,8,0,165,37,116,10,2,107,239,105,15,44};
static const unsigned char precomputed_pow_inv25519_p_55[] = {114,233,7,56,117,61,113,42,219,47,222,196,187,179,103,150,132,19,88,35,101,124,46,111,170,44,145,221,251,228,49,51};
static const unsigned char precomputed_pow_inv25519_q_56[] = {120,48,72,22,125,57,58,161,110,110,133,193,209,44,210,149,126,151,247,43,137,146,69,87,217,126,123,71,34,181,180,41};
static const unsigned char precomputed_pow_inv25519_p_56[] = {129,202,111,146,254,13,201,8,16,17,251,195,170,42,79,164,254,44,214,204,94,5,255,146,68,197,70,111,210,104,118,52};
static const unsigned char precomputed_pow_inv25519_q_57[] = {26,234,188,172,72,26,124,128,66,220,35,67,32,250,233,98,180,240,142,120,38,245,98,68,87,247,130,59,42,107,59,102};
static const unsigned char precomputed_pow_inv25519_p_57[] = {14,25,214,142,146,214,128,244,9,127,35,0,152,86,204,178,194,68,100,30,69,101,220,141,133,105,202,131,69,103,144,52};
static const unsigned char precomputed_pow_inv25519_q_58[] = {87,227,76,166,177,115,247,116,70,93,201,181,94,78,216,36,244,172,46,34,177,17,8,6,214,230,219,224,179,76,121,123};
static const unsigned char precomputed_pow_inv25519_p_58[] = {97,91,49,148,88,12,82,159,80,25,159,170,103,125,25,97,50,97,37,247,53,231,178,41,192,229,37,88,105,87,131,53};
static const unsigned char precomputed_pow_inv25519_q_59[] = {247,116,252,18,43,132,167,183,1,40,32,155,43,255,203,237,11,9,60,95,92,99,181,125,155,84,13,23,190,90,109,120};
static const unsigned char precomputed_pow_inv25519_p_59[] = {80,220,254,202,182,2,43,205,234,179,239,143,144,151,179,219,73,11,24,224,170,180,219,236,77,25,42,150,70,252,236,53};
static const unsigned char precomputed_pow_inv25519_q_60[] = {25,81,186,29,90,22,34,66,129,41,152,231,153,155,246,70,108,195,67,53,45,126,6,236,70,61,233,207,56,126,191,67};
static const unsigned char precomputed_pow_inv25519_p_60[] = {15,107,97,219,29,24,83,131,60,191,127,75,0,87,25,142,104,111,192,12,72,223,132,235,116,235,119,37,25,174,94,54};
static const unsigned char precomputed_pow_inv25519_q_61[] = {128,12,149,140,116,186,133,136,238,4,7,76,128,24,44,7,32,8,97,255,209,208,246,68,147,223,143,19,17,152,219,26};
static const unsigned char precomputed_pow_inv25519_p_61[] = {95,235,188,21,7,218,30,39,173,117,137,120,82,227,47,225,213,187,57,139,194,14,221,177,217,128,254,43,252,35,130,55};
static const unsigned char precomputed_pow_inv25519_q_62[] = {44,252,229,127,155,27,91,26,34,187,23,211,87,55,95,37,86,36,46,145,164,68,237,53,14,109,181,57,104,233,232,46};
static const unsigned char precomputed_pow_inv25519_p_62[] = {33,158,20,26,13,160,220,36,224,154,184,232,223,120,118,59,52,76,244,10,223,92,109,197,53,78,56,236,34,166,235,56};
static const unsigned char precomputed_pow_inv25519_q_63[] = {246,169,6,227,244,135,36,153,153,180,43,150,213,82,228,200,25,224,132,223,114,42,238,88,133,171,232,76,139,176,32,37};
static const unsigned char precomputed_pow_inv25519_p_63[] = {82,132,241,36,117,25,9,104,119,241,135,180,34,67,21,3,178,207,125,108,103,19,65,132,188,57,50,69,54,29,245,58};
static const unsigned char precomputed_pow_inv25519_q_64[] = {233,161,230,75,99,10,248,239,134,179,75,112,5,184,9,150,164,194,77,105,9,62,177,27,220,255,121,153,166,197,196,14};
static const unsigned char precomputed_pow_inv25519_p_64[] = {78,140,20,224,52,27,201,36,89,209,174,149,72,194,147,130,41,13,38,56,78,70,49,142,114,20,58,180,74,226,70,61};
static const unsigned char precomputed_pow_inv25519_q_65[] = {10,175,30,186,99,204,243,120,203,70,66,90,131,167,0,32,126,65,92,129,132,11,117,118,170,34,208,91,216,226,223,66};
static const unsigned char precomputed_pow_inv25519_p_65[] = {138,245,193,250,5,5,97,181,241,120,249,83,158,60,19,176,141,136,110,14,187,255,222,14,136,207,86,173,56,42,64,67};
static const unsigned char precomputed_pow_inv25519_q_66[] = {113,101,139,242,230,170,63,23,240,172,125,206,13,249,18,91,234,177,30,206,94,173,181,169,117,42,108,207,40,26,209,61};
static const unsigned char precomputed_pow_inv25519_p_66[] = {6,217,177,199,21,112,114,132,244,3,229,76,43,143,128,239,244,213,43,17,92,87,242,48,39,140,145,94,200,1,133,67};
static const unsigned char precomputed_pow_inv25519_q_67[] = {171,26,203,222,6,85,103,210,224,27,211,48,141,214,146,10,136,83,2,40,31,239,213,59,57,124,216,115,62,224,175,89};
static const unsigned char precomputed_pow_inv25519_p_67[] = {247,225,74,212,231,250,151,164,161,154,159,172,20,204,251,209,176,144,38,181,66,69,13,80,80,173,202,184,221,127,239,70};
static const unsigned char precomputed_pow_inv25519_q_68[] = {204,107,141,96,205,160,154,128,57,30,225,94,158,123,47,156,116,66,2,71,134,159,89,50,95,21,82,240,2,251,112,40};
static const unsigned char precomputed_pow_inv25519_p_68[] = {238,49,5,74,218,128,248,183,44,230,125,170,22,211,254,66,212,58,210,44,24,188,82,184,114,120,217,46,98,1,111,74};
static const unsigned char precomputed_pow_inv25519_q_69[] = {226,145,63,94,151,88,160,212,211,138,37,204,192,45,231,173,191,161,182,15,154,32,44,216,245,254,159,75,249,101,252,60};
static const unsigned char precomputed_pow_inv25519_p_69[] = {146,204,227,148,117,91,30,160,102,89,96,24,211,48,38,147,31,14,146,155,210,151,224,150,193,8,137,112,0,191,54,76};
static const unsigned char precomputed_pow_inv25519_q_70[] = {24,0,179,212,28,171,145,205,100,98,74,136,173,166,5,71,245,245,134,228,226,81,250,177,85,93,34,216,87,56,39,8};
static const unsigned char precomputed_pow_inv25519_p_70[] = {210,202,220,164,246,20,113,100,180,12,151,155,88,88,88,145,232,83,65,207,203,112,134,14,206,120,161,44,178,247,76,79};
static const unsigned char precomputed_pow_inv25519_q_71[] = {124,187,175,19,110,205,24,229,223,52,182,185,61,183,101,187,33,36,136,71,247,139,158,124,21,82,165,203,138,93,137,87};
static const unsigned char precomputed_pow_inv25519_p_71[] = {255,73,130,191,221,80,59,217,184,28,130,67,82,52,14,70,154,222,20,67,247,149,40,129,54,201,105,110,239,159,95,80};
static const unsigned char precomputed_pow_inv25519_q_72[] = {198,198,211,121,255,219,233,129,21,15,70,214,117,210,246,255,141,73,177,65,9,198,234,94,196,241,32,208,245,146,188,115};
static const unsigned char precomputed_pow_inv25519_p_72[] = {139,249,139,242,180,114,253,231,63,42,190,37,169,162,179,81,193,126,98,185,1,76,62,17,143,53,76,176,138,212,238,81};
static const unsigned char precomputed_pow_inv25519_q_73[] = {58,85,123,151,193,188,6,23,14,144,215,82,124,64,185,14,61,224,129,70,177,145,124,171,48,115,158,228,40,88,226,119};
static const unsigned char precomputed_pow_inv25519_p_73[] = {47,163,188,90,33,133,4,135,193,239,35,48,111,132,3,67,53,104,115,61,241,83,172,241,49,30,77,80,53,164,132,86};
static const unsigned char precomputed_pow_inv25519_q_74[] = {224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_pow_inv25519_p_74[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_pow_inv25519_q_75[] = {240,44,29,72,44,33,188,97,152,219,129,79,124,138,167,64,144,200,229,60,6,3,242,73,196,157,70,161,25,6,89,17};
static const unsigned char precomputed_pow_inv25519_p_75[] = {111,10,86,115,2,46,170,54,148,52,250,47,50,56,43,7,216,138,19,111,126,8,39,124,220,10,24,40,198,115,160,92};
static const unsigned char precomputed_pow_inv25519_q_76[] = {36,66,230,237,167,158,139,23,31,250,125,86,224,127,46,232,226,180,215,204,34,96,249,42,199,166,207,107,147,129,146,123};
static const unsigned char precomputed_pow_inv25519_p_76[] = {170,223,157,23,236,62,32,108,24,248,79,7,102,172,52,177,222,29,19,7,3,17,152,104,5,178,63,61,253,161,227,95};
static const unsigned char precomputed_pow_inv25519_q_77[] = {98,218,163,46,248,246,95,42,196,92,16,252,105,79,233,115,249,87,128,31,207,51,90,86,246,189,111,79,124,228,140,10};
static const unsigned char precomputed_pow_inv25519_p_77[] = {187,201,42,73,246,165,102,43,122,7,159,244,24,84,225,192,11,129,148,42,208,164,22,129,133,144,163,118,103,85,204,96};
static const unsigned char precomputed_pow_inv25519_q_78[] = {122,211,53,191,141,31,35,162,90,37,77,135,241,82,64,222,160,108,43,134,121,118,172,103,15,160,201,241,51,217,64,28};
static const unsigned char precomputed_pow_inv25519_p_78[] = {142,149,157,28,5,201,173,174,133,174,98,68,117,157,25,87,59,175,211,196,165,241,116,163,212,99,99,133,123,48,111,102};
static const unsigned char precomputed_pow_inv25519_q_79[] = {145,8,253,77,245,5,120,31,74,60,119,213,196,168,200,250,125,18,48,99,3,110,27,113,160,14,220,76,165,239,65,32};
static const unsigned char precomputed_pow_inv25519_p_79[] = {125,212,64,236,173,27,166,51,72,55,177,70,196,58,53,4,38,199,138,229,115,240,42,58,41,57,15,0,28,63,21,108};
static const unsigned char precomputed_pow_inv25519_q_80[] = {37,94,195,214,119,156,42,247,187,218,195,228,212,126,144,11,226,177,229,62,100,157,41,250,74,199,49,99,76,76,56,21};
static const unsigned char precomputed_pow_inv25519_p_80[] = {237,197,109,47,77,179,144,100,157,130,214,51,210,10,226,76,215,202,65,22,131,42,185,219,128,57,32,227,252,255,132,108};
static const unsigned char precomputed_pow_inv25519_q_81[] = {203,165,234,77,253,45,200,2,126,15,141,112,82,28,182,95,73,13,130,89,202,6,194,120,69,171,129,243,86,140,179,104};
static const unsigned char precomputed_pow_inv25519_p_81[] = {125,45,159,13,208,200,222,43,12,33,0,254,227,97,97,32,232,25,53,199,145,219,119,66,145,110,82,242,17,249,163,118};
static const unsigned char precomputed_pow_inv25519_q_82[] = {250,175,158,192,173,162,118,136,152,75,129,43,252,232,27,56,147,20,108,184,122,112,9,22,249,193,34,179,116,82,243,13};
static const unsigned char precomputed_pow_inv25519_p_82[] = {218,124,213,86,252,123,194,102,72,95,152,194,239,155,120,87,147,101,181,39,136,178,213,63,208,88,239,217,88,229,237,119};
static const unsigned char precomputed_pow_inv25519_q_83[] = {139,217,27,238,113,28,242,233,76,16,196,238,215,96,153,61,0,64,134,198,20,205,154,208,84,164,135,54,153,95,4,126};
static const unsigned char precomputed_pow_inv25519_p_83[] = {189,68,80,58,53,159,69,72,96,63,22,164,219,217,177,104,30,162,150,170,40,227,107,49,103,70,18,244,141,182,4,120};
static const unsigned char precomputed_pow_inv25519_q_84[] = {50,64,140,178,127,243,229,133,181,245,231,178,255,28,163,116,143,244,167,202,224,102,167,125,23,128,31,132,114,244,143,96};
static const unsigned char precomputed_pow_inv25519_p_84[] = {141,86,94,148,247,167,7,64,21,249,20,82,26,95,159,145,129,43,67,188,112,24,28,197,142,0,147,152,108,232,246,120};
static const unsigned char precomputed_pow_inv25519_q_85[] = {68,2,137,26,149,197,182,41,179,89,168,46,148,42,174,46,105,67,5,236,229,53,91,235,166,66,164,68,226,71,196,20};
static const unsigned char precomputed_pow_inv25519_p_85[] = {109,105,188,79,1,147,89,93,3,188,177,189,165,192,94,147,244,7,23,147,84,125,168,186,44,88,176,120,191,227,206,121};
static const unsigned char precomputed_pow_inv25519_q_86[] = {218,173,13,120,122,94,145,16,70,118,129,50,34,108,85,233,165,114,255,45,136,23,229,92,106,144,137,2,33,252,29,54};
static const unsigned char precomputed_pow_inv25519_p_86[] = {199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122};
static const unsigned char precomputed_pow_inv25519_q_87[] = {230,33,152,96,68,5,80,48,41,141,126,170,102,237,107,144,102,211,248,193,103,55,52,34,219,94,12,203,154,12,80,103};
static const unsigned char precomputed_pow_inv25519_p_87[] = {16,144,21,200,119,145,159,194,55,138,26,190,154,139,72,46,187,132,134,43,89,106,125,20,10,208,228,120,140,13,108,123};
static const unsigned char precomputed_pow_inv25519_q_88[] = {19,44,152,227,217,20,167,250,84,55,67,224,45,145,57,180,192,170,237,160,232,123,136,47,197,82,40,170,162,17,184,49};
static const unsigned char precomputed_pow_inv25519_p_88[] = {5,97,68,33,155,166,192,59,217,105,121,61,195,81,22,19,33,196,102,252,161,11,78,213,178,193,220,63,254,134,221,124};
static const unsigned char precomputed_pow_inv25519_q_89[] = {148,135,170,165,51,197,56,93,128,90,55,248,90,88,150,59,254,77,206,190,194,65,214,56,198,175,24,104,8,181,243,44};
static const unsigned char precomputed_pow_inv25519_p_89[] = {174,123,183,169,128,93,4,127,95,144,172,90,27,196,103,169,70,105,66,180,68,78,96,240,173,118,98,214,113,217,176,127};
static const unsigned char precomputed_pow_inv25519_q_90[] = {226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68};
static const unsigned char precomputed_pow_inv25519_p_90[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_91[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_pow_inv25519_p_91[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_92[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69};
static const unsigned char precomputed_pow_inv25519_p_92[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_93[] = {34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115};
static const unsigned char precomputed_pow_inv25519_p_93[] = {227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_94[] = {219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56};
static const unsigned char precomputed_pow_inv25519_p_94[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_95[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79};
static const unsigned char precomputed_pow_inv25519_p_95[] = {229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_96[] = {96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91};
static const unsigned char precomputed_pow_inv25519_p_96[] = {230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_97[] = {82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21};
static const unsigned char precomputed_pow_inv25519_p_97[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_98[] = {87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_pow_inv25519_p_98[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_99[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31};
static const unsigned char precomputed_pow_inv25519_p_99[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_100[] = {164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42};
static const unsigned char precomputed_pow_inv25519_p_100[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_101[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_101[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_102[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_p_102[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_103[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_103[] = {237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_104[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_104[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_105[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_105[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_106[] = {73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_pow_inv25519_p_106[] = {240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_107[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_pow_inv25519_p_107[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_108[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_pow_inv25519_p_108[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_109[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_pow_inv25519_p_109[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_110[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_pow_inv25519_p_110[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_111[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_pow_inv25519_p_111[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_112[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_pow_inv25519_p_112[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_113[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_pow_inv25519_p_113[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_114[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_pow_inv25519_p_114[] = {248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_115[] = {68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_pow_inv25519_p_115[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_116[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_pow_inv25519_p_116[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_117[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_pow_inv25519_p_117[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_118[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_pow_inv25519_p_118[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_119[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_pow_inv25519_p_119[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_120[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_pow_inv25519_p_120[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_121[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35};
static const unsigned char precomputed_pow_inv25519_p_121[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_q_122[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_122[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_123[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_123[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_124[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_124[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_125[] = {73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_pow_inv25519_p_125[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_126[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_pow_inv25519_p_126[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_127[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_pow_inv25519_p_127[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_128[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_pow_inv25519_p_128[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_129[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_pow_inv25519_p_129[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_130[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_pow_inv25519_p_130[] = {8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_131[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_pow_inv25519_p_131[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_132[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_pow_inv25519_p_132[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_133[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_pow_inv25519_p_133[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_134[] = {68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_pow_inv25519_p_134[] = {12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_135[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_pow_inv25519_p_135[] = {13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_136[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_pow_inv25519_p_136[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_137[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_pow_inv25519_p_137[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_138[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_pow_inv25519_p_138[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_139[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_pow_inv25519_p_139[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_140[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35};
static const unsigned char precomputed_pow_inv25519_p_140[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_141[] = {20,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,47};
static const unsigned char precomputed_pow_inv25519_p_141[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_142[] = {92,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,70};
static const unsigned char precomputed_pow_inv25519_p_142[] = {20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_143[] = {47,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12,195,48,12};
static const unsigned char precomputed_pow_inv25519_p_143[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_144[] = {19,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,29};
static const unsigned char precomputed_pow_inv25519_p_144[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_145[] = {195,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111,122,211,155,222,244,166,55,189,233,77,111};
static const unsigned char precomputed_pow_inv25519_p_145[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_146[] = {162,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,58};
static const unsigned char precomputed_pow_inv25519_p_146[] = {24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_147[] = {30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,133,235,81,184,30,5};
static const unsigned char precomputed_pow_inv25519_p_147[] = {25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_148[] = {124,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,157,216,137,93};
static const unsigned char precomputed_pow_inv25519_p_148[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_149[] = {6,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,151,208,94,66,123,9,237,37,180,23};
static const unsigned char precomputed_pow_inv25519_p_149[] = {27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_150[] = {21,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,105};
static const unsigned char precomputed_pow_inv25519_p_150[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_151[] = {189,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35,44,247,52,194,114,79,35};
static const unsigned char precomputed_pow_inv25519_p_151[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_152[] = {232,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,238,46};
static const unsigned char precomputed_pow_inv25519_p_152[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_153[] = {104,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,206,57,231,156,115,78};
static const unsigned char precomputed_pow_inv25519_p_153[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_pow_inv25519_q_154[] = {255,18,128,72,228,210,22,236,211,24,133,166,9,89,225,162,36,191,150,60,252,28,47,47,158,5,5,216,186,24,207,103};
static const unsigned char precomputed_pow_inv25519_p_154[] = {205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128};
static const unsigned char precomputed_pow_inv25519_q_155[] = {119,103,199,145,13,212,68,180,32,154,11,70,33,64,99,183,127,26,61,109,5,129,168,139,16,89,194,52,24,154,5,41};
static const unsigned char precomputed_pow_inv25519_p_155[] = {160,37,10,26,225,245,150,67,90,82,89,131,201,239,182,175,225,228,27,31,200,10,216,0,158,161,240,56,190,37,98,129};
static const unsigned char precomputed_pow_inv25519_q_156[] = {1,148,159,247,183,146,107,28,108,130,211,75,103,155,178,82,249,162,224,151,203,209,46,231,108,64,61,45,150,202,45,0};
static const unsigned char precomputed_pow_inv25519_p_156[] = {126,193,215,50,203,125,133,127,196,72,203,3,172,168,69,4,124,66,128,137,155,138,79,62,12,209,148,182,155,150,234,132};
static const unsigned char precomputed_pow_inv25519_q_157[] = {99,139,94,252,32,74,144,89,201,238,12,147,88,178,109,115,251,249,27,173,176,90,202,53,157,93,69,69,158,207,96,85};
static const unsigned char precomputed_pow_inv25519_p_157[] = {214,187,57,121,219,7,180,245,79,199,28,235,3,229,24,162,210,72,140,56,149,230,163,235,193,41,191,151,78,2,170,133};
static const unsigned char precomputed_pow_inv25519_q_158[] = {249,65,66,22,31,224,118,102,169,219,18,109,120,237,101,211,149,123,65,235,107,9,99,16,84,18,117,37,154,188,46,103};
static const unsigned char precomputed_pow_inv25519_p_158[] = {19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133};
static const unsigned char precomputed_pow_inv25519_q_159[] = {184,10,155,17,51,214,119,30,59,251,85,113,123,29,15,114,107,99,233,184,99,141,154,85,48,88,114,7,174,248,1,43};
static const unsigned char precomputed_pow_inv25519_p_159[] = {62,21,89,26,242,137,228,142,221,218,26,139,122,9,150,190,211,255,231,171,115,79,10,216,158,142,92,214,120,151,143,136};
static const unsigned char precomputed_pow_inv25519_q_160[] = {183,19,131,62,107,60,139,25,159,81,252,127,241,150,167,10,86,224,76,177,199,197,197,80,104,31,181,26,122,42,200,107};
static const unsigned char precomputed_pow_inv25519_p_160[] = {81,108,252,226,91,123,2,58,201,115,182,53,216,106,226,19,255,189,15,42,27,210,228,103,255,63,80,6,101,105,24,137};
static const unsigned char precomputed_pow_inv25519_q_161[] = {239,161,210,117,214,15,240,116,5,0,54,223,151,211,12,138,144,42,18,214,168,102,214,85,16,247,188,192,117,63,57,1};
static const unsigned char precomputed_pow_inv25519_p_161[] = {110,167,30,114,238,200,91,206,189,246,80,143,240,154,158,29,237,114,89,30,86,41,243,89,252,236,82,177,174,134,206,142};
static const unsigned char precomputed_pow_inv25519_q_162[] = {61,54,212,216,74,218,83,219,62,35,165,95,17,3,73,161,75,101,254,69,125,245,244,141,119,123,245,253,111,14,25,93};
static const unsigned char precomputed_pow_inv25519_p_162[] = {223,178,224,94,39,7,12,55,105,205,4,119,36,114,140,55,63,97,181,199,242,8,236,220,146,170,18,174,209,107,101,143};
static const unsigned char precomputed_pow_inv25519_q_163[] = {220,221,46,159,19,71,130,150,192,107,243,94,161,132,21,7,54,106,156,135,175,130,59,60,200,36,73,123,86,75,50,15};
static const unsigned char precomputed_pow_inv25519_p_163[] = {27,248,18,51,151,208,228,149,143,27,140,249,190,131,118,98,48,85,214,237,106,115,9,75,148,22,7,29,151,218,7,144};
static const unsigned char precomputed_pow_inv25519_q_164[] = {99,164,73,245,216,117,26,54,100,89,185,145,92,75,162,224,247,89,82,97,42,146,188,162,234,188,53,50,205,27,164,125};
static const unsigned char precomputed_pow_inv25519_p_164[] = {28,72,94,40,137,202,51,69,198,88,34,49,16,78,17,30,21,240,75,177,180,86,175,148,58,181,236,40,244,45,62,146};
static const unsigned char precomputed_pow_inv25519_q_165[] = {200,172,196,243,100,101,206,90,55,146,193,161,10,181,97,24,25,169,142,207,183,245,50,177,35,33,223,137,121,214,8,11};
static const unsigned char precomputed_pow_inv25519_p_165[] = {158,186,152,57,234,203,74,33,92,196,150,65,216,222,226,127,191,18,161,191,239,44,29,43,240,246,221,186,114,111,63,151};
static const unsigned char precomputed_pow_inv25519_q_166[] = {27,50,144,247,44,248,235,222,217,45,60,206,47,125,224,19,173,200,182,17,66,77,178,222,9,208,215,92,217,235,16,51};
static const unsigned char precomputed_pow_inv25519_p_166[] = {250,195,130,230,38,225,2,225,206,208,205,149,59,249,120,21,49,202,81,229,137,184,10,137,242,202,97,38,245,188,212,151};
static const unsigned char precomputed_pow_inv25519_q_167[] = {186,241,50,238,253,46,48,201,94,82,83,204,249,196,0,182,83,208,171,167,81,86,62,151,251,33,215,165,135,188,241,83};
static const unsigned char precomputed_pow_inv25519_p_167[] = {54,117,120,76,28,202,80,109,96,30,159,160,217,89,62,54,1,69,113,116,99,75,17,217,85,101,142,201,51,2,101,152};
static const unsigned char precomputed_pow_inv25519_q_168[] = {177,22,78,2,251,64,132,103,11,6,223,232,100,240,122,253,31,213,144,42,88,64,152,99,119,1,85,61,153,42,246,28};
static const unsigned char precomputed_pow_inv25519_p_168[] = {149,177,114,234,252,75,142,235,123,59,172,102,243,44,203,193,27,157,41,154,123,24,157,151,153,191,27,29,59,251,18,154};
static const unsigned char precomputed_pow_inv25519_q_169[] = {87,151,81,173,173,39,155,66,15,101,16,184,251,55,76,209,228,154,157,212,35,136,110,6,9,206,124,153,240,250,51,21};
static const unsigned char precomputed_pow_inv25519_p_169[] = {102,100,56,74,188,101,169,164,35,169,187,217,141,243,3,55,161,77,32,41,110,158,111,3,56,227,131,126,230,180,45,155};
static const unsigned char precomputed_pow_inv25519_q_170[] = {26,237,10,109,22,27,15,145,91,164,252,40,180,129,77,1,209,54,255,9,230,144,68,179,94,150,255,52,26,192,119,12};
static const unsigned char precomputed_pow_inv25519_p_170[] = {67,192,36,40,3,194,139,15,233,18,214,181,68,174,148,224,232,149,109,38,74,153,50,14,188,66,236,205,202,241,226,157};
static const unsigned char precomputed_pow_inv25519_q_171[] = {10,112,77,248,215,20,81,248,239,85,249,63,227,118,43,8,62,101,27,56,86,116,15,149,157,61,205,251,137,165,102,37};
static const unsigned char precomputed_pow_inv25519_p_171[] = {66,173,58,243,101,117,198,170,56,209,211,188,81,55,42,168,124,219,190,185,49,16,182,103,120,142,68,168,211,236,170,161};
static const unsigned char precomputed_pow_inv25519_q_172[] = {124,192,215,171,163,91,214,7,214,103,28,62,221,11,42,56,169,24,161,174,234,129,174,74,144,189,57,77,183,143,230,54};
static const unsigned char precomputed_pow_inv25519_p_172[] = {214,158,46,187,158,227,121,43,148,253,243,11,84,196,151,224,248,8,133,187,199,38,200,165,82,79,87,227,252,32,75,163};
static const unsigned char precomputed_pow_inv25519_q_173[] = {1,253,23,133,180,163,138,250,3,6,56,24,193,174,56,245,134,226,111,175,140,177,93,247,195,15,184,46,27,183,168,84};
static const unsigned char precomputed_pow_inv25519_p_173[] = {183,25,105,23,254,22,118,190,172,248,135,177,162,56,80,228,241,77,155,50,49,40,189,53,222,77,10,195,159,180,36,169};
static const unsigned char precomputed_pow_inv25519_q_174[] = {25,127,208,50,168,132,165,21,56,59,46,58,37,56,196,112,79,108,118,165,211,183,6,64,229,168,173,55,122,100,74,77};
static const unsigned char precomputed_pow_inv25519_p_174[] = {192,74,224,195,102,131,154,194,42,115,141,84,75,168,130,177,203,227,246,119,46,128,66,54,254,220,160,138,57,28,88,169};
static const unsigned char precomputed_pow_inv25519_q_175[] = {225,186,121,98,173,21,21,215,110,75,191,20,71,113,25,23,202,27,131,16,127,51,113,82,20,236,251,108,6,13,170,112};
static const unsigned char precomputed_pow_inv25519_p_175[] = {57,236,93,48,192,237,101,125,11,22,182,131,135,237,215,120,196,89,208,70,90,68,155,140,49,154,250,205,35,42,34,171};
static const unsigned char precomputed_pow_inv25519_q_176[] = {48,45,229,134,192,180,23,34,163,128,199,99,190,108,58,236,202,55,204,18,197,103,175,253,182,237,16,122,224,228,25,51};
static const unsigned char precomputed_pow_inv25519_p_176[] = {34,164,149,255,137,15,71,180,197,252,42,2,169,202,248,32,183,77,134,43,105,218,92,204,154,157,143,56,212,103,51,172};
static const unsigned char precomputed_pow_inv25519_q_177[] = {218,53,247,81,139,46,27,171,129,162,207,255,164,59,252,164,108,253,4,12,247,226,70,241,122,188,72,211,252,122,178,13};
static const unsigned char precomputed_pow_inv25519_p_177[] = {86,30,104,181,170,61,38,192,4,54,101,16,25,25,44,81,66,135,114,62,180,143,156,81,136,143,16,207,57,45,167,173};
static const unsigned char precomputed_pow_inv25519_q_178[] = {170,226,249,137,116,167,226,120,193,243,124,147,88,138,15,162,48,71,145,111,254,119,63,233,128,23,10,92,67,118,30,30};
static const unsigned char precomputed_pow_inv25519_p_178[] = {91,245,72,216,90,199,134,172,165,93,168,104,67,11,211,223,41,7,195,248,1,92,138,40,187,117,230,81,86,91,26,174};
static const unsigned char precomputed_pow_inv25519_q_179[] = {16,203,185,193,38,83,190,92,116,115,246,106,35,158,198,3,90,188,79,129,38,19,63,45,251,135,198,66,86,155,225,121};
static const unsigned char precomputed_pow_inv25519_p_179[] = {151,141,223,224,103,64,134,109,9,122,230,95,229,166,153,94,19,16,90,73,179,141,203,36,65,81,227,10,205,31,125,174};
static const unsigned char precomputed_pow_inv25519_q_180[] = {209,40,101,130,26,183,234,127,32,20,146,116,8,112,194,56,141,99,210,83,17,213,186,22,156,223,63,106,4,205,119,120};
static const unsigned char precomputed_pow_inv25519_p_180[] = {113,11,129,179,36,154,147,133,7,238,233,76,251,81,65,246,52,129,24,169,217,110,172,227,54,251,102,134,122,59,118,176};
static const unsigned char precomputed_pow_inv25519_q_181[] = {44,211,20,43,212,157,190,57,72,130,253,234,26,138,128,90,95,4,179,17,35,81,110,212,39,183,62,124,81,174,211,111};
static const unsigned char precomputed_pow_inv25519_p_181[] = {56,220,154,85,84,3,159,223,248,143,175,199,155,173,14,212,145,152,55,74,49,90,203,199,112,120,39,138,239,31,10,177};
static const unsigned char precomputed_pow_inv25519_q_182[] = {44,36,50,74,131,169,121,80,198,48,15,109,17,179,219,187,206,100,32,234,143,15,167,198,211,146,163,181,67,145,34,30};
static const unsigned char precomputed_pow_inv25519_p_182[] = {135,104,144,71,33,194,33,133,3,24,60,117,215,178,87,97,114,162,126,199,73,119,145,178,104,158,203,9,101,140,123,179};
static const unsigned char precomputed_pow_inv25519_q_183[] = {65,202,102,109,103,80,115,84,86,255,69,144,130,156,246,146,171,184,205,92,6,56,1,209,45,189,61,184,217,216,238,107};
static const unsigned char precomputed_pow_inv25519_p_183[] = {253,164,38,103,254,232,227,99,197,120,216,11,141,6,80,149,82,139,5,14,109,151,171,95,140,120,105,222,29,75,225,179};
static const unsigned char precomputed_pow_inv25519_q_184[] = {92,107,139,15,200,95,209,61,18,98,255,105,11,30,179,203,165,173,126,12,101,216,5,82,113,163,14,42,63,71,54,95};
static const unsigned char precomputed_pow_inv25519_p_184[] = {16,6,32,40,247,87,109,57,38,33,228,150,230,17,242,15,173,193,172,63,190,117,181,169,233,173,88,122,190,157,147,180};
static const unsigned char precomputed_pow_inv25519_q_185[] = {92,183,137,31,254,74,14,236,77,43,136,33,36,188,185,136,35,197,175,200,235,28,59,241,185,27,235,124,94,75,147,7};
static const unsigned char precomputed_pow_inv25519_p_185[] = {220,96,255,75,79,6,125,48,182,249,141,55,159,169,209,228,80,104,66,94,114,158,242,122,235,91,168,124,40,195,178,181};
static const unsigned char precomputed_pow_inv25519_q_186[] = {172,154,20,26,177,187,189,219,238,205,20,135,222,148,10,180,45,77,167,230,85,220,108,93,190,152,222,115,194,46,238,38};
static const unsigned char precomputed_pow_inv25519_p_186[] = {49,227,89,1,60,152,183,120,89,158,57,84,116,231,55,213,6,81,44,123,127,232,229,121,133,50,184,254,130,13,213,183};
static const unsigned char precomputed_pow_inv25519_q_187[] = {194,21,95,5,118,195,213,133,77,184,255,154,248,106,211,69,190,97,64,75,113,2,168,123,145,239,139,148,112,167,185,35};
static const unsigned char precomputed_pow_inv25519_p_187[] = {196,226,59,10,69,172,238,59,12,106,114,210,55,110,197,177,226,149,26,253,22,198,190,45,156,32,60,94,30,193,155,190};
static const unsigned char precomputed_pow_inv25519_q_188[] = {32,117,101,93,21,29,45,200,131,115,0,171,69,249,81,151,27,172,135,163,158,170,85,244,177,208,78,112,29,130,208,1};
static const unsigned char precomputed_pow_inv25519_p_188[] = {46,212,240,212,71,186,251,161,145,114,228,149,106,116,148,58,17,73,40,233,26,110,117,88,47,188,22,112,183,65,205,191};
static const unsigned char precomputed_pow_inv25519_q_189[] = {107,175,215,13,154,66,2,195,79,10,245,244,111,49,54,97,158,174,22,157,61,39,123,146,193,47,231,23,119,172,49,68};
static const unsigned char precomputed_pow_inv25519_p_189[] = {108,115,168,221,29,29,10,110,178,191,144,33,98,69,158,179,107,50,30,217,56,235,99,100,137,115,187,170,108,225,145,192};
static const unsigned char precomputed_pow_inv25519_q_190[] = {218,44,117,234,3,221,97,148,64,22,1,104,162,171,212,147,56,101,247,120,8,181,246,246,147,242,168,40,240,191,81,91};
static const unsigned char precomputed_pow_inv25519_p_190[] = {88,23,254,127,125,50,108,114,175,73,57,176,55,155,159,156,225,178,180,167,133,57,53,105,82,105,36,21,156,137,88,193};
static const unsigned char precomputed_pow_inv25519_q_191[] = {215,89,254,152,127,20,89,20,92,33,137,154,119,181,225,180,43,64,75,37,242,39,86,167,15,137,5,170,48,126,146,76};
static const unsigned char precomputed_pow_inv25519_p_191[] = {13,161,208,73,87,241,51,97,97,233,39,57,195,242,131,151,162,177,26,48,254,248,44,92,233,228,68,233,92,67,161,193};
static const unsigned char precomputed_pow_inv25519_q_192[] = {146,95,192,36,105,238,38,17,66,210,53,159,29,45,172,13,19,239,216,103,210,227,95,146,76,141,226,75,237,224,140,45};
static const unsigned char precomputed_pow_inv25519_p_192[] = {55,80,74,36,97,26,143,182,137,191,36,191,100,77,67,3,107,215,201,77,181,94,138,165,44,14,150,247,29,118,206,193};
static const unsigned char precomputed_pow_inv25519_q_193[] = {229,167,235,58,38,253,227,229,144,252,65,147,155,192,1,200,234,201,60,53,72,205,125,195,152,107,147,58,133,244,226,57};
static const unsigned char precomputed_pow_inv25519_p_193[] = {46,145,77,66,148,249,125,134,154,224,31,41,99,28,127,185,90,83,173,89,42,15,229,221,132,185,57,226,109,127,221,195};
static const unsigned char precomputed_pow_inv25519_q_194[] = {88,244,110,33,254,212,210,200,74,219,192,138,123,42,22,161,158,67,146,169,244,26,194,146,134,59,88,139,28,13,232,113};
static const unsigned char precomputed_pow_inv25519_p_194[] = {174,142,95,26,102,77,10,180,133,149,255,236,89,72,70,235,43,152,127,141,53,255,3,202,240,70,104,183,125,242,114,196};
static const unsigned char precomputed_pow_inv25519_q_195[] = {64,221,81,158,3,36,181,87,193,60,136,163,35,100,143,129,179,228,250,156,164,142,21,4,77,93,75,0,244,129,177,40};
static const unsigned char precomputed_pow_inv25519_p_195[] = {144,124,64,244,223,107,164,210,14,118,122,26,192,45,89,87,111,104,108,123,107,244,184,92,115,236,27,64,129,228,241,199};
static const unsigned char precomputed_pow_inv25519_q_196[] = {99,201,196,169,55,97,250,40,141,136,16,157,64,175,118,170,88,177,140,160,7,30,114,150,4,66,180,241,24,77,251,24};
static const unsigned char precomputed_pow_inv25519_p_196[] = {172,37,106,178,186,134,115,186,94,177,212,105,200,72,126,162,183,252,84,234,71,113,123,115,27,145,22,179,65,52,126,200};
static const unsigned char precomputed_pow_inv25519_q_197[] = {174,170,250,224,154,6,139,55,176,83,195,77,81,163,12,64,169,193,158,42,136,115,151,254,220,204,20,51,143,148,100,67};
static const unsigned char precomputed_pow_inv25519_p_197[] = {242,131,4,146,239,149,68,63,138,77,104,43,251,247,136,71,173,80,18,182,27,74,218,145,119,152,217,220,241,59,214,200};
static const unsigned char precomputed_pow_inv25519_q_198[] = {30,77,35,14,207,56,225,204,214,84,214,43,10,5,131,1,232,164,48,194,28,249,10,221,177,149,235,251,97,74,211,10};
static const unsigned char precomputed_pow_inv25519_p_198[] = {108,209,156,236,156,166,225,245,1,255,55,161,87,186,87,163,186,173,58,130,239,62,58,38,221,97,184,184,72,35,198,201};
static const unsigned char precomputed_pow_inv25519_q_199[] = {107,245,0,118,252,117,202,19,202,116,222,202,138,82,165,96,61,18,186,171,168,23,115,16,230,51,114,68,15,167,254,10};
static const unsigned char precomputed_pow_inv25519_p_199[] = {178,234,83,79,237,151,116,195,96,77,61,52,122,69,7,81,11,193,156,118,222,117,126,243,15,14,208,220,120,72,211,204};
static const unsigned char precomputed_pow_inv25519_q_200[] = {214,120,72,144,158,69,169,197,194,31,128,253,42,9,89,244,196,88,93,126,65,2,167,187,5,242,252,242,184,214,242,5};
static const unsigned char precomputed_pow_inv25519_p_200[] = {204,131,141,157,131,216,59,249,236,247,255,242,5,235,227,226,14,130,40,32,228,224,200,76,162,5,173,143,35,248,18,207};
static const unsigned char precomputed_pow_inv25519_q_201[] = {47,76,234,34,222,81,77,135,195,76,208,112,156,219,20,178,30,155,71,83,60,90,163,191,143,71,145,161,191,195,87,15};
static const unsigned char precomputed_pow_inv25519_p_201[] = {35,5,252,51,253,104,202,78,1,55,89,199,130,119,215,153,228,235,211,185,24,49,168,133,15,191,16,243,69,249,102,209};
static const unsigned char precomputed_pow_inv25519_q_202[] = {58,222,210,172,117,119,57,61,224,20,29,150,221,44,144,70,140,51,231,175,210,153,37,88,146,194,225,169,73,158,19,113};
static const unsigned char precomputed_pow_inv25519_p_202[] = {236,192,151,177,212,242,244,63,100,18,73,46,25,215,142,32,185,134,95,138,231,167,29,123,189,146,175,242,71,212,160,210};
static const unsigned char precomputed_pow_inv25519_q_203[] = {250,236,86,132,69,38,205,167,12,237,206,138,141,97,254,200,84,201,57,37,204,224,28,138,118,116,237,160,16,107,229,5};
static const unsigned char precomputed_pow_inv25519_p_203[] = {244,123,195,157,46,59,3,176,45,171,88,28,63,64,60,158,176,233,111,81,205,205,200,253,20,53,42,25,236,248,6,211};
static const unsigned char precomputed_pow_inv25519_q_204[] = {70,94,251,66,100,123,54,49,59,133,51,209,145,175,125,17,204,29,7,212,133,213,29,183,143,195,185,173,47,3,222,85};
static const unsigned char precomputed_pow_inv25519_p_204[] = {250,190,87,147,129,35,208,208,243,3,97,112,183,206,100,81,148,116,102,25,203,54,44,111,84,135,214,181,143,175,51,212};
static const unsigned char precomputed_pow_inv25519_q_205[] = {131,210,117,143,82,41,161,167,161,158,111,95,35,69,168,11,197,154,116,202,90,82,255,64,166,92,246,17,178,212,91,67};
static const unsigned char precomputed_pow_inv25519_p_205[] = {214,76,88,159,6,174,51,81,248,78,106,177,236,186,192,219,15,190,150,146,53,178,114,58,92,104,251,202,20,7,53,214};
static const unsigned char precomputed_pow_inv25519_q_206[] = {157,55,39,243,142,130,111,45,166,84,112,203,27,239,172,76,214,75,31,106,240,173,202,191,74,78,251,83,156,95,158,43};
static const unsigned char precomputed_pow_inv25519_p_206[] = {244,140,114,244,62,170,41,248,47,225,143,61,151,206,239,48,118,198,17,125,73,82,89,168,186,241,36,23,150,83,109,214};
static const unsigned char precomputed_pow_inv25519_q_207[] = {87,207,2,124,244,96,162,120,146,89,164,148,95,183,218,84,166,224,100,150,225,179,52,188,200,94,137,234,35,31,9,3};
static const unsigned char precomputed_pow_inv25519_p_207[] = {76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215};
static const unsigned char precomputed_pow_inv25519_q_208[] = {162,220,223,48,214,174,3,100,223,97,188,82,171,187,14,131,68,24,30,37,238,210,191,242,76,102,108,1,27,62,67,0};
static const unsigned char precomputed_pow_inv25519_p_208[] = {139,115,46,248,73,231,193,130,253,199,47,18,242,136,178,77,224,246,139,248,167,75,84,143,72,149,87,254,161,252,22,217};
static const unsigned char precomputed_pow_inv25519_q_209[] = {30,123,115,55,197,27,49,167,26,61,86,4,186,21,50,55,147,200,8,105,28,242,64,218,157,1,113,131,215,111,207,111};
static const unsigned char precomputed_pow_inv25519_p_209[] = {93,88,227,37,114,65,2,2,202,140,162,68,186,54,73,105,10,189,55,176,194,12,242,71,98,179,159,127,78,41,232,221};
static const unsigned char precomputed_pow_inv25519_q_210[] = {119,12,187,139,37,59,1,93,187,48,178,41,39,84,133,181,224,15,62,13,53,161,23,77,89,10,6,206,230,145,233,84};
static const unsigned char precomputed_pow_inv25519_p_210[] = {143,142,107,198,237,68,83,189,7,239,167,232,157,187,159,139,177,161,94,141,23,17,47,115,237,6,59,132,12,168,110,223};
static const unsigned char precomputed_pow_inv25519_q_211[] = {244,146,147,38,236,43,58,202,100,24,224,35,134,96,36,251,137,254,123,44,1,78,253,67,213,155,22,127,86,117,55,113};
static const unsigned char precomputed_pow_inv25519_p_211[] = {22,46,135,210,121,177,182,90,213,250,68,254,13,187,98,28,198,232,133,160,89,202,235,65,61,199,204,207,44,54,181,223};
static const unsigned char precomputed_pow_inv25519_q_212[] = {136,220,123,37,85,109,34,40,194,73,21,222,241,128,141,227,72,46,31,43,36,254,235,144,206,97,253,136,172,31,194,111};
static const unsigned char precomputed_pow_inv25519_p_212[] = {35,238,173,80,157,134,161,13,214,74,174,154,61,187,55,219,216,57,244,57,107,141,22,183,40,187,178,130,223,175,253,223};
static const unsigned char precomputed_pow_inv25519_q_213[] = {131,33,61,243,99,20,154,34,215,107,210,27,150,102,170,27,7,217,146,76,109,111,189,253,67,210,93,36,75,209,72,86};
static const unsigned char precomputed_pow_inv25519_p_213[] = {135,41,111,62,134,23,247,181,64,139,85,137,237,245,175,152,106,177,57,133,253,184,141,40,45,4,212,79,52,174,254,223};
static const unsigned char precomputed_pow_inv25519_q_214[] = {247,154,210,2,116,207,58,196,149,233,253,154,162,199,226,96,240,183,87,121,236,7,252,165,160,114,145,199,44,124,246,118};
static const unsigned char precomputed_pow_inv25519_p_214[] = {210,123,212,47,191,41,21,215,166,78,180,73,218,218,5,4,10,253,18,3,94,228,96,173,112,39,183,132,46,217,2,224};
static const unsigned char precomputed_pow_inv25519_q_215[] = {153,123,171,215,228,176,169,26,86,118,67,64,128,172,246,201,4,70,71,252,163,227,127,42,24,49,155,199,77,129,4,45};
static const unsigned char precomputed_pow_inv25519_p_215[] = {232,64,0,7,2,215,145,253,104,71,120,112,176,10,157,243,134,72,12,11,14,242,103,82,237,168,70,157,242,247,10,224};
static const unsigned char precomputed_pow_inv25519_q_216[] = {102,56,102,102,190,156,31,135,141,175,224,246,95,126,250,255,95,195,96,39,9,143,141,99,172,48,106,85,180,81,171,105};
static const unsigned char precomputed_pow_inv25519_p_216[] = {27,151,33,144,144,198,124,112,170,187,16,189,113,255,84,221,81,127,37,17,143,58,64,32,63,1,169,157,31,50,214,234};
static const unsigned char precomputed_pow_inv25519_q_217[] = {13,25,54,57,100,228,51,49,195,8,83,158,55,126,92,14,44,9,29,168,137,83,213,19,194,203,51,242,110,168,217,123};
static const unsigned char precomputed_pow_inv25519_p_217[] = {133,78,53,177,58,165,28,169,160,156,74,247,22,18,110,17,171,95,48,187,254,210,138,117,179,157,48,108,6,186,193,235};
static const unsigned char precomputed_pow_inv25519_q_218[] = {126,111,105,209,219,21,23,61,189,188,198,71,33,4,103,204,17,238,164,23,50,76,21,77,119,218,251,72,121,47,196,16};
static const unsigned char precomputed_pow_inv25519_p_218[] = {25,216,239,98,90,43,174,36,141,165,171,161,236,144,0,188,173,204,147,113,37,224,186,252,199,176,246,185,163,33,96,236};
static const unsigned char precomputed_pow_inv25519_q_219[] = {154,191,14,215,80,28,117,152,174,124,147,150,211,165,123,33,244,66,101,67,128,44,23,64,71,244,213,17,103,240,254,44};
static const unsigned char precomputed_pow_inv25519_p_219[] = {213,243,48,11,157,197,31,38,25,41,241,11,72,102,114,49,205,71,48,159,37,11,204,163,154,127,238,77,137,218,185,236};
static const unsigned char precomputed_pow_inv25519_q_220[] = {89,145,129,24,248,62,149,212,214,140,43,190,89,228,1,213,214,167,111,57,89,200,78,150,104,191,130,246,83,119,194,71};
static const unsigned char precomputed_pow_inv25519_p_220[] = {168,188,69,201,152,212,193,230,142,199,30,182,79,33,156,162,216,59,153,29,99,172,127,139,16,93,159,100,40,94,29,239};
static const unsigned char precomputed_pow_inv25519_q_221[] = {242,118,80,48,12,130,98,141,232,17,141,251,79,212,185,116,63,245,235,89,160,19,152,149,206,94,219,197,89,73,22,2};
static const unsigned char precomputed_pow_inv25519_p_221[] = {149,33,93,182,34,43,131,42,7,185,191,233,56,97,255,161,24,75,9,111,70,63,117,14,41,111,225,237,10,11,132,240};
static const unsigned char precomputed_pow_inv25519_q_222[] = {239,138,220,36,139,47,198,44,90,0,48,81,44,12,104,228,54,9,240,224,5,20,247,183,178,146,78,154,237,252,122,7};
static const unsigned char precomputed_pow_inv25519_p_222[] = {190,57,20,188,220,113,68,236,247,124,46,122,44,228,172,184,241,46,202,132,38,79,248,49,26,159,251,67,32,15,212,245};
static const unsigned char precomputed_pow_inv25519_q_223[] = {60,113,93,225,240,169,197,176,14,86,252,209,74,154,11,127,32,135,115,151,143,37,124,35,150,114,120,154,23,216,167,39};
static const unsigned char precomputed_pow_inv25519_p_223[] = {180,50,28,164,12,27,60,90,16,84,200,202,112,144,207,37,183,210,179,165,89,2,57,211,178,44,72,179,209,50,225,245};
static const unsigned char precomputed_pow_inv25519_q_224[] = {23,180,18,131,215,44,27,48,91,253,165,223,233,204,200,233,114,107,194,7,218,183,23,167,130,77,48,18,162,130,204,16};
static const unsigned char precomputed_pow_inv25519_p_224[] = {170,254,96,130,76,58,108,247,243,157,78,32,139,192,145,181,120,149,66,18,48,255,179,45,248,153,25,250,125,241,185,247};
static const unsigned char precomputed_pow_inv25519_q_225[] = {231,235,59,35,147,122,136,163,184,162,214,191,159,112,70,221,175,159,182,89,172,92,124,5,118,13,239,84,174,235,227,40};
static const unsigned char precomputed_pow_inv25519_p_225[] = {180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250};
static const unsigned char precomputed_pow_inv25519_q_226[] = {89,198,80,48,244,56,47,214,227,188,88,156,193,94,9,89,75,209,109,178,3,109,160,247,107,98,103,234,213,41,188,13};
static const unsigned char precomputed_pow_inv25519_p_226[] = {91,94,189,239,65,25,164,16,97,157,57,15,98,46,197,53,97,137,208,106,56,113,72,246,21,174,146,118,48,34,127,250};
static const unsigned char precomputed_pow_inv25519_q_227[] = {120,109,244,14,120,248,5,253,209,142,9,226,88,17,109,141,148,174,208,247,226,254,102,22,49,239,234,213,17,172,70,17};
static const unsigned char precomputed_pow_inv25519_p_227[] = {168,56,27,159,191,8,6,120,33,137,112,137,74,90,42,223,96,94,197,77,20,87,240,251,40,205,31,126,97,161,79,252};
static const unsigned char precomputed_pow_inv25519_q_228[] = {20,179,156,100,59,90,228,162,230,74,170,58,239,231,51,159,90,52,134,152,179,190,187,121,146,54,2,136,4,16,81,100};
static const unsigned char precomputed_pow_inv25519_p_228[] = {168,232,248,183,162,21,22,250,43,70,55,127,62,205,17,69,125,80,249,69,191,37,72,39,7,122,11,134,30,177,89,253};
static const unsigned char precomputed_pow_inv25519_q_229[] = {19,160,110,39,86,191,120,66,143,156,210,157,236,183,79,168,239,218,176,4,252,132,170,55,119,151,50,59,110,207,54,8};
static const unsigned char precomputed_pow_inv25519_p_229[] = {239,116,12,234,4,82,0,178,159,114,155,225,154,162,111,134,127,181,234,121,180,60,229,249,105,134,250,147,212,174,170,253};
static const unsigned char precomputed_pow_inv25519_q_230[] = {149,77,244,53,53,179,126,41,219,42,231,103,64,15,240,173,90,157,174,130,89,199,42,206,228,212,76,252,106,140,56,21};
static const unsigned char precomputed_pow_inv25519_p_230[] = {19,137,17,15,242,181,77,55,255,2,106,123,184,194,112,245,204,230,90,240,209,188,209,175,61,67,172,143,75,148,1,255};
static const unsigned char precomputed_pow_inv25519_q_231[] = {1,181,30,167,122,145,55,57,251,166,148,170,197,8,104,79,141,210,253,40,34,8,85,24,41,74,122,67,62,236,0,24};
static const unsigned char precomputed_pow_inv25519_p_231[] = {89,63,37,111,54,84,103,221,103,152,61,93,47,225,181,222,152,84,107,66,201,189,152,146,246,137,153,114,219,135,105,255};
static const unsigned char precomputed_pow_inv25519_q_232[] = {95,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11,182,96,11};
static const unsigned char precomputed_pow_inv25519_p_232[] = {192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_233[] = {109,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,49};
static const unsigned char precomputed_pow_inv25519_p_233[] = {193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_234[] = {78,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,244,5,125,65,95,208,23,116};
static const unsigned char precomputed_pow_inv25519_p_234[] = {194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_235[] = {223,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,121,158,231,57};
static const unsigned char precomputed_pow_inv25519_p_235[] = {195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_236[] = {123,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12,206,199,224,124,12};
static const unsigned char precomputed_pow_inv25519_p_236[] = {196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_237[] = {191,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,92};
static const unsigned char precomputed_pow_inv25519_p_237[] = {197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_238[] = {246,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,150,111,249,22};
static const unsigned char precomputed_pow_inv25519_p_238[] = {198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_239[] = {227,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,40,175,161,188,134,242,26,202,107,104};
static const unsigned char precomputed_pow_inv25519_p_239[] = {199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_240[] = {237,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34,159,117,131,41,242,89,55,152,34};
static const unsigned char precomputed_pow_inv25519_p_240[] = {200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_241[] = {50,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,46};
static const unsigned char precomputed_pow_inv25519_p_241[] = {201,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_242[] = {114,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,197,87,124,69};
static const unsigned char precomputed_pow_inv25519_p_242[] = {202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_243[] = {208,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,210,18};
static const unsigned char precomputed_pow_inv25519_p_243[] = {203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_244[] = {139,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108,178,201,38,155,108};
static const unsigned char precomputed_pow_inv25519_p_244[] = {204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_245[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,19};
static const unsigned char precomputed_pow_inv25519_p_245[] = {205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_246[] = {133,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49,198,24,99,140,49};
static const unsigned char precomputed_pow_inv25519_p_246[] = {206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_247[] = {5,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,81};
static const unsigned char precomputed_pow_inv25519_p_247[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_248[] = {48,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,220,211,8,203,61,141,176,92};
static const unsigned char precomputed_pow_inv25519_p_248[] = {208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_249[] = {216,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,22};
static const unsigned char precomputed_pow_inv25519_p_249[] = {209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_250[] = {231,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104,47,161,189,132,246,18,218,75,104};
static const unsigned char precomputed_pow_inv25519_p_250[] = {210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_251[] = {113,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,98,39,118,34};
static const unsigned char precomputed_pow_inv25519_p_251[] = {211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_252[] = {207,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122,20,174,71,225,122};
static const unsigned char precomputed_pow_inv25519_p_252[] = {212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_253[] = {75,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,69};
static const unsigned char precomputed_pow_inv25519_p_253[] = {213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_254[] = {42,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,144,133,44,100,33,11,89,200,66,22,178,16};
static const unsigned char precomputed_pow_inv25519_p_254[] = {214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_255[] = {218,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,98};
static const unsigned char precomputed_pow_inv25519_p_255[] = {215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_256[] = {190,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,243,60,207,115};
static const unsigned char precomputed_pow_inv25519_p_256[] = {216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_257[] = {145,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,57};
static const unsigned char precomputed_pow_inv25519_p_257[] = {217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_258[] = {217,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80,94,67,121,13,229,53,148,215,80};
static const unsigned char precomputed_pow_inv25519_p_258[] = {218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_259[] = {100,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,92};
static const unsigned char precomputed_pow_inv25519_p_259[] = {219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_260[] = {160,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,165,37};
static const unsigned char precomputed_pow_inv25519_p_260[] = {220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_261[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,39};
static const unsigned char precomputed_pow_inv25519_p_261[] = {221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_262[] = {29,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34};
static const unsigned char precomputed_pow_inv25519_p_262[] = {222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_263[] = {176,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,45};
static const unsigned char precomputed_pow_inv25519_p_263[] = {223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_264[] = {226,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,196,78,236,68};
static const unsigned char precomputed_pow_inv25519_p_264[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_265[] = {169,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,10};
static const unsigned char precomputed_pow_inv25519_p_265[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_266[] = {199,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69,23,93,116,209,69};
static const unsigned char precomputed_pow_inv25519_p_266[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_267[] = {34,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,115};
static const unsigned char precomputed_pow_inv25519_p_267[] = {227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_268[] = {219,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56};
static const unsigned char precomputed_pow_inv25519_p_268[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_269[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,79};
static const unsigned char precomputed_pow_inv25519_p_269[] = {229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_270[] = {96,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,219,182,109,91};
static const unsigned char precomputed_pow_inv25519_p_270[] = {230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_271[] = {82,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,21};
static const unsigned char precomputed_pow_inv25519_p_271[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_272[] = {87,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102};
static const unsigned char precomputed_pow_inv25519_p_272[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_273[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,31};
static const unsigned char precomputed_pow_inv25519_p_273[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_274[] = {164,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,42};
static const unsigned char precomputed_pow_inv25519_p_274[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_275[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_275[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_276[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_pow_inv25519_p_276[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_277[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_277[] = {237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_278[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_pow_inv25519_p_278[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_279[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,63};
static const unsigned char precomputed_pow_inv25519_p_279[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_280[] = {73,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85};
static const unsigned char precomputed_pow_inv25519_p_280[] = {240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_281[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,95};
static const unsigned char precomputed_pow_inv25519_p_281[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_282[] = {150,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,153,25};
static const unsigned char precomputed_pow_inv25519_p_282[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_283[] = {155,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,170,106};
static const unsigned char precomputed_pow_inv25519_p_283[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_284[] = {141,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36};
static const unsigned char precomputed_pow_inv25519_p_284[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_285[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,47};
static const unsigned char precomputed_pow_inv25519_p_285[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_286[] = {18,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,199,113,28,71};
static const unsigned char precomputed_pow_inv25519_p_286[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_287[] = {203,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,12};
static const unsigned char precomputed_pow_inv25519_p_287[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_288[] = {38,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,186,232,162,139,46,58};
static const unsigned char precomputed_pow_inv25519_p_288[] = {248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_289[] = {68,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,117};
static const unsigned char precomputed_pow_inv25519_p_289[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_290[] = {11,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59,177,19,59};
static const unsigned char precomputed_pow_inv25519_p_290[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_291[] = {61,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,146,36,73,82};
static const unsigned char precomputed_pow_inv25519_p_291[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_292[] = {208,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,221,93};
static const unsigned char precomputed_pow_inv25519_p_292[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_293[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,87};
static const unsigned char precomputed_pow_inv25519_p_293[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_294[] = {77,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90,90};
static const unsigned char precomputed_pow_inv25519_p_294[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_pow_inv25519_q_295[] = {137,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,227,56,142,35};
static const unsigned char precomputed_pow_inv25519_p_295[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};

static const struct {
  const unsigned char *q;
  long long qsize;
  const unsigned char *p;
  long long psize;
} precomputed_pow_inv25519[precomputed_pow_inv25519_NUM] = {
  {
    precomputed_pow_inv25519_q_0,32,
    precomputed_pow_inv25519_p_0,32,
  },
  {
    precomputed_pow_inv25519_q_1,32,
    precomputed_pow_inv25519_p_1,32,
  },
  {
    precomputed_pow_inv25519_q_2,32,
    precomputed_pow_inv25519_p_2,32,
  },
  {
    precomputed_pow_inv25519_q_3,32,
    precomputed_pow_inv25519_p_3,32,
  },
  {
    precomputed_pow_inv25519_q_4,32,
    precomputed_pow_inv25519_p_4,32,
  },
  {
    precomputed_pow_inv25519_q_5,32,
    precomputed_pow_inv25519_p_5,32,
  },
  {
    precomputed_pow_inv25519_q_6,32,
    precomputed_pow_inv25519_p_6,32,
  },
  {
    precomputed_pow_inv25519_q_7,32,
    precomputed_pow_inv25519_p_7,32,
  },
  {
    precomputed_pow_inv25519_q_8,32,
    precomputed_pow_inv25519_p_8,32,
  },
  {
    precomputed_pow_inv25519_q_9,32,
    precomputed_pow_inv25519_p_9,32,
  },
  {
    precomputed_pow_inv25519_q_10,32,
    precomputed_pow_inv25519_p_10,32,
  },
  {
    precomputed_pow_inv25519_q_11,32,
    precomputed_pow_inv25519_p_11,32,
  },
  {
    precomputed_pow_inv25519_q_12,32,
    precomputed_pow_inv25519_p_12,32,
  },
  {
    precomputed_pow_inv25519_q_13,32,
    precomputed_pow_inv25519_p_13,32,
  },
  {
    precomputed_pow_inv25519_q_14,32,
    precomputed_pow_inv25519_p_14,32,
  },
  {
    precomputed_pow_inv25519_q_15,32,
    precomputed_pow_inv25519_p_15,32,
  },
  {
    precomputed_pow_inv25519_q_16,32,
    precomputed_pow_inv25519_p_16,32,
  },
  {
    precomputed_pow_inv25519_q_17,32,
    precomputed_pow_inv25519_p_17,32,
  },
  {
    precomputed_pow_inv25519_q_18,32,
    precomputed_pow_inv25519_p_18,32,
  },
  {
    precomputed_pow_inv25519_q_19,32,
    precomputed_pow_inv25519_p_19,32,
  },
  {
    precomputed_pow_inv25519_q_20,32,
    precomputed_pow_inv25519_p_20,32,
  },
  {
    precomputed_pow_inv25519_q_21,32,
    precomputed_pow_inv25519_p_21,32,
  },
  {
    precomputed_pow_inv25519_q_22,32,
    precomputed_pow_inv25519_p_22,32,
  },
  {
    precomputed_pow_inv25519_q_23,32,
    precomputed_pow_inv25519_p_23,32,
  },
  {
    precomputed_pow_inv25519_q_24,32,
    precomputed_pow_inv25519_p_24,32,
  },
  {
    precomputed_pow_inv25519_q_25,32,
    precomputed_pow_inv25519_p_25,32,
  },
  {
    precomputed_pow_inv25519_q_26,32,
    precomputed_pow_inv25519_p_26,32,
  },
  {
    precomputed_pow_inv25519_q_27,32,
    precomputed_pow_inv25519_p_27,32,
  },
  {
    precomputed_pow_inv25519_q_28,32,
    precomputed_pow_inv25519_p_28,32,
  },
  {
    precomputed_pow_inv25519_q_29,32,
    precomputed_pow_inv25519_p_29,32,
  },
  {
    precomputed_pow_inv25519_q_30,32,
    precomputed_pow_inv25519_p_30,32,
  },
  {
    precomputed_pow_inv25519_q_31,32,
    precomputed_pow_inv25519_p_31,32,
  },
  {
    precomputed_pow_inv25519_q_32,32,
    precomputed_pow_inv25519_p_32,32,
  },
  {
    precomputed_pow_inv25519_q_33,32,
    precomputed_pow_inv25519_p_33,32,
  },
  {
    precomputed_pow_inv25519_q_34,32,
    precomputed_pow_inv25519_p_34,32,
  },
  {
    precomputed_pow_inv25519_q_35,32,
    precomputed_pow_inv25519_p_35,32,
  },
  {
    precomputed_pow_inv25519_q_36,32,
    precomputed_pow_inv25519_p_36,32,
  },
  {
    precomputed_pow_inv25519_q_37,32,
    precomputed_pow_inv25519_p_37,32,
  },
  {
    precomputed_pow_inv25519_q_38,32,
    precomputed_pow_inv25519_p_38,32,
  },
  {
    precomputed_pow_inv25519_q_39,32,
    precomputed_pow_inv25519_p_39,32,
  },
  {
    precomputed_pow_inv25519_q_40,32,
    precomputed_pow_inv25519_p_40,32,
  },
  {
    precomputed_pow_inv25519_q_41,32,
    precomputed_pow_inv25519_p_41,32,
  },
  {
    precomputed_pow_inv25519_q_42,32,
    precomputed_pow_inv25519_p_42,32,
  },
  {
    precomputed_pow_inv25519_q_43,32,
    precomputed_pow_inv25519_p_43,32,
  },
  {
    precomputed_pow_inv25519_q_44,32,
    precomputed_pow_inv25519_p_44,32,
  },
  {
    precomputed_pow_inv25519_q_45,32,
    precomputed_pow_inv25519_p_45,32,
  },
  {
    precomputed_pow_inv25519_q_46,32,
    precomputed_pow_inv25519_p_46,32,
  },
  {
    precomputed_pow_inv25519_q_47,32,
    precomputed_pow_inv25519_p_47,32,
  },
  {
    precomputed_pow_inv25519_q_48,32,
    precomputed_pow_inv25519_p_48,32,
  },
  {
    precomputed_pow_inv25519_q_49,32,
    precomputed_pow_inv25519_p_49,32,
  },
  {
    precomputed_pow_inv25519_q_50,32,
    precomputed_pow_inv25519_p_50,32,
  },
  {
    precomputed_pow_inv25519_q_51,32,
    precomputed_pow_inv25519_p_51,32,
  },
  {
    precomputed_pow_inv25519_q_52,32,
    precomputed_pow_inv25519_p_52,32,
  },
  {
    precomputed_pow_inv25519_q_53,32,
    precomputed_pow_inv25519_p_53,32,
  },
  {
    precomputed_pow_inv25519_q_54,32,
    precomputed_pow_inv25519_p_54,32,
  },
  {
    precomputed_pow_inv25519_q_55,32,
    precomputed_pow_inv25519_p_55,32,
  },
  {
    precomputed_pow_inv25519_q_56,32,
    precomputed_pow_inv25519_p_56,32,
  },
  {
    precomputed_pow_inv25519_q_57,32,
    precomputed_pow_inv25519_p_57,32,
  },
  {
    precomputed_pow_inv25519_q_58,32,
    precomputed_pow_inv25519_p_58,32,
  },
  {
    precomputed_pow_inv25519_q_59,32,
    precomputed_pow_inv25519_p_59,32,
  },
  {
    precomputed_pow_inv25519_q_60,32,
    precomputed_pow_inv25519_p_60,32,
  },
  {
    precomputed_pow_inv25519_q_61,32,
    precomputed_pow_inv25519_p_61,32,
  },
  {
    precomputed_pow_inv25519_q_62,32,
    precomputed_pow_inv25519_p_62,32,
  },
  {
    precomputed_pow_inv25519_q_63,32,
    precomputed_pow_inv25519_p_63,32,
  },
  {
    precomputed_pow_inv25519_q_64,32,
    precomputed_pow_inv25519_p_64,32,
  },
  {
    precomputed_pow_inv25519_q_65,32,
    precomputed_pow_inv25519_p_65,32,
  },
  {
    precomputed_pow_inv25519_q_66,32,
    precomputed_pow_inv25519_p_66,32,
  },
  {
    precomputed_pow_inv25519_q_67,32,
    precomputed_pow_inv25519_p_67,32,
  },
  {
    precomputed_pow_inv25519_q_68,32,
    precomputed_pow_inv25519_p_68,32,
  },
  {
    precomputed_pow_inv25519_q_69,32,
    precomputed_pow_inv25519_p_69,32,
  },
  {
    precomputed_pow_inv25519_q_70,32,
    precomputed_pow_inv25519_p_70,32,
  },
  {
    precomputed_pow_inv25519_q_71,32,
    precomputed_pow_inv25519_p_71,32,
  },
  {
    precomputed_pow_inv25519_q_72,32,
    precomputed_pow_inv25519_p_72,32,
  },
  {
    precomputed_pow_inv25519_q_73,32,
    precomputed_pow_inv25519_p_73,32,
  },
  {
    precomputed_pow_inv25519_q_74,32,
    precomputed_pow_inv25519_p_74,32,
  },
  {
    precomputed_pow_inv25519_q_75,32,
    precomputed_pow_inv25519_p_75,32,
  },
  {
    precomputed_pow_inv25519_q_76,32,
    precomputed_pow_inv25519_p_76,32,
  },
  {
    precomputed_pow_inv25519_q_77,32,
    precomputed_pow_inv25519_p_77,32,
  },
  {
    precomputed_pow_inv25519_q_78,32,
    precomputed_pow_inv25519_p_78,32,
  },
  {
    precomputed_pow_inv25519_q_79,32,
    precomputed_pow_inv25519_p_79,32,
  },
  {
    precomputed_pow_inv25519_q_80,32,
    precomputed_pow_inv25519_p_80,32,
  },
  {
    precomputed_pow_inv25519_q_81,32,
    precomputed_pow_inv25519_p_81,32,
  },
  {
    precomputed_pow_inv25519_q_82,32,
    precomputed_pow_inv25519_p_82,32,
  },
  {
    precomputed_pow_inv25519_q_83,32,
    precomputed_pow_inv25519_p_83,32,
  },
  {
    precomputed_pow_inv25519_q_84,32,
    precomputed_pow_inv25519_p_84,32,
  },
  {
    precomputed_pow_inv25519_q_85,32,
    precomputed_pow_inv25519_p_85,32,
  },
  {
    precomputed_pow_inv25519_q_86,32,
    precomputed_pow_inv25519_p_86,32,
  },
  {
    precomputed_pow_inv25519_q_87,32,
    precomputed_pow_inv25519_p_87,32,
  },
  {
    precomputed_pow_inv25519_q_88,32,
    precomputed_pow_inv25519_p_88,32,
  },
  {
    precomputed_pow_inv25519_q_89,32,
    precomputed_pow_inv25519_p_89,32,
  },
  {
    precomputed_pow_inv25519_q_90,32,
    precomputed_pow_inv25519_p_90,32,
  },
  {
    precomputed_pow_inv25519_q_91,32,
    precomputed_pow_inv25519_p_91,32,
  },
  {
    precomputed_pow_inv25519_q_92,32,
    precomputed_pow_inv25519_p_92,32,
  },
  {
    precomputed_pow_inv25519_q_93,32,
    precomputed_pow_inv25519_p_93,32,
  },
  {
    precomputed_pow_inv25519_q_94,32,
    precomputed_pow_inv25519_p_94,32,
  },
  {
    precomputed_pow_inv25519_q_95,32,
    precomputed_pow_inv25519_p_95,32,
  },
  {
    precomputed_pow_inv25519_q_96,32,
    precomputed_pow_inv25519_p_96,32,
  },
  {
    precomputed_pow_inv25519_q_97,32,
    precomputed_pow_inv25519_p_97,32,
  },
  {
    precomputed_pow_inv25519_q_98,32,
    precomputed_pow_inv25519_p_98,32,
  },
  {
    precomputed_pow_inv25519_q_99,32,
    precomputed_pow_inv25519_p_99,32,
  },
  {
    precomputed_pow_inv25519_q_100,32,
    precomputed_pow_inv25519_p_100,32,
  },
  {
    precomputed_pow_inv25519_q_101,32,
    precomputed_pow_inv25519_p_101,32,
  },
  {
    precomputed_pow_inv25519_q_102,32,
    precomputed_pow_inv25519_p_102,32,
  },
  {
    precomputed_pow_inv25519_q_103,32,
    precomputed_pow_inv25519_p_103,32,
  },
  {
    precomputed_pow_inv25519_q_104,32,
    precomputed_pow_inv25519_p_104,32,
  },
  {
    precomputed_pow_inv25519_q_105,32,
    precomputed_pow_inv25519_p_105,32,
  },
  {
    precomputed_pow_inv25519_q_106,32,
    precomputed_pow_inv25519_p_106,32,
  },
  {
    precomputed_pow_inv25519_q_107,32,
    precomputed_pow_inv25519_p_107,32,
  },
  {
    precomputed_pow_inv25519_q_108,32,
    precomputed_pow_inv25519_p_108,32,
  },
  {
    precomputed_pow_inv25519_q_109,32,
    precomputed_pow_inv25519_p_109,32,
  },
  {
    precomputed_pow_inv25519_q_110,32,
    precomputed_pow_inv25519_p_110,32,
  },
  {
    precomputed_pow_inv25519_q_111,32,
    precomputed_pow_inv25519_p_111,32,
  },
  {
    precomputed_pow_inv25519_q_112,32,
    precomputed_pow_inv25519_p_112,32,
  },
  {
    precomputed_pow_inv25519_q_113,32,
    precomputed_pow_inv25519_p_113,32,
  },
  {
    precomputed_pow_inv25519_q_114,32,
    precomputed_pow_inv25519_p_114,32,
  },
  {
    precomputed_pow_inv25519_q_115,32,
    precomputed_pow_inv25519_p_115,32,
  },
  {
    precomputed_pow_inv25519_q_116,32,
    precomputed_pow_inv25519_p_116,32,
  },
  {
    precomputed_pow_inv25519_q_117,32,
    precomputed_pow_inv25519_p_117,32,
  },
  {
    precomputed_pow_inv25519_q_118,32,
    precomputed_pow_inv25519_p_118,32,
  },
  {
    precomputed_pow_inv25519_q_119,32,
    precomputed_pow_inv25519_p_119,32,
  },
  {
    precomputed_pow_inv25519_q_120,32,
    precomputed_pow_inv25519_p_120,32,
  },
  {
    precomputed_pow_inv25519_q_121,32,
    precomputed_pow_inv25519_p_121,32,
  },
  {
    precomputed_pow_inv25519_q_122,32,
    precomputed_pow_inv25519_p_122,32,
  },
  {
    precomputed_pow_inv25519_q_123,32,
    precomputed_pow_inv25519_p_123,32,
  },
  {
    precomputed_pow_inv25519_q_124,32,
    precomputed_pow_inv25519_p_124,32,
  },
  {
    precomputed_pow_inv25519_q_125,32,
    precomputed_pow_inv25519_p_125,32,
  },
  {
    precomputed_pow_inv25519_q_126,32,
    precomputed_pow_inv25519_p_126,32,
  },
  {
    precomputed_pow_inv25519_q_127,32,
    precomputed_pow_inv25519_p_127,32,
  },
  {
    precomputed_pow_inv25519_q_128,32,
    precomputed_pow_inv25519_p_128,32,
  },
  {
    precomputed_pow_inv25519_q_129,32,
    precomputed_pow_inv25519_p_129,32,
  },
  {
    precomputed_pow_inv25519_q_130,32,
    precomputed_pow_inv25519_p_130,32,
  },
  {
    precomputed_pow_inv25519_q_131,32,
    precomputed_pow_inv25519_p_131,32,
  },
  {
    precomputed_pow_inv25519_q_132,32,
    precomputed_pow_inv25519_p_132,32,
  },
  {
    precomputed_pow_inv25519_q_133,32,
    precomputed_pow_inv25519_p_133,32,
  },
  {
    precomputed_pow_inv25519_q_134,32,
    precomputed_pow_inv25519_p_134,32,
  },
  {
    precomputed_pow_inv25519_q_135,32,
    precomputed_pow_inv25519_p_135,32,
  },
  {
    precomputed_pow_inv25519_q_136,32,
    precomputed_pow_inv25519_p_136,32,
  },
  {
    precomputed_pow_inv25519_q_137,32,
    precomputed_pow_inv25519_p_137,32,
  },
  {
    precomputed_pow_inv25519_q_138,32,
    precomputed_pow_inv25519_p_138,32,
  },
  {
    precomputed_pow_inv25519_q_139,32,
    precomputed_pow_inv25519_p_139,32,
  },
  {
    precomputed_pow_inv25519_q_140,32,
    precomputed_pow_inv25519_p_140,32,
  },
  {
    precomputed_pow_inv25519_q_141,32,
    precomputed_pow_inv25519_p_141,32,
  },
  {
    precomputed_pow_inv25519_q_142,32,
    precomputed_pow_inv25519_p_142,32,
  },
  {
    precomputed_pow_inv25519_q_143,32,
    precomputed_pow_inv25519_p_143,32,
  },
  {
    precomputed_pow_inv25519_q_144,32,
    precomputed_pow_inv25519_p_144,32,
  },
  {
    precomputed_pow_inv25519_q_145,32,
    precomputed_pow_inv25519_p_145,32,
  },
  {
    precomputed_pow_inv25519_q_146,32,
    precomputed_pow_inv25519_p_146,32,
  },
  {
    precomputed_pow_inv25519_q_147,32,
    precomputed_pow_inv25519_p_147,32,
  },
  {
    precomputed_pow_inv25519_q_148,32,
    precomputed_pow_inv25519_p_148,32,
  },
  {
    precomputed_pow_inv25519_q_149,32,
    precomputed_pow_inv25519_p_149,32,
  },
  {
    precomputed_pow_inv25519_q_150,32,
    precomputed_pow_inv25519_p_150,32,
  },
  {
    precomputed_pow_inv25519_q_151,32,
    precomputed_pow_inv25519_p_151,32,
  },
  {
    precomputed_pow_inv25519_q_152,32,
    precomputed_pow_inv25519_p_152,32,
  },
  {
    precomputed_pow_inv25519_q_153,32,
    precomputed_pow_inv25519_p_153,32,
  },
  {
    precomputed_pow_inv25519_q_154,32,
    precomputed_pow_inv25519_p_154,32,
  },
  {
    precomputed_pow_inv25519_q_155,32,
    precomputed_pow_inv25519_p_155,32,
  },
  {
    precomputed_pow_inv25519_q_156,32,
    precomputed_pow_inv25519_p_156,32,
  },
  {
    precomputed_pow_inv25519_q_157,32,
    precomputed_pow_inv25519_p_157,32,
  },
  {
    precomputed_pow_inv25519_q_158,32,
    precomputed_pow_inv25519_p_158,32,
  },
  {
    precomputed_pow_inv25519_q_159,32,
    precomputed_pow_inv25519_p_159,32,
  },
  {
    precomputed_pow_inv25519_q_160,32,
    precomputed_pow_inv25519_p_160,32,
  },
  {
    precomputed_pow_inv25519_q_161,32,
    precomputed_pow_inv25519_p_161,32,
  },
  {
    precomputed_pow_inv25519_q_162,32,
    precomputed_pow_inv25519_p_162,32,
  },
  {
    precomputed_pow_inv25519_q_163,32,
    precomputed_pow_inv25519_p_163,32,
  },
  {
    precomputed_pow_inv25519_q_164,32,
    precomputed_pow_inv25519_p_164,32,
  },
  {
    precomputed_pow_inv25519_q_165,32,
    precomputed_pow_inv25519_p_165,32,
  },
  {
    precomputed_pow_inv25519_q_166,32,
    precomputed_pow_inv25519_p_166,32,
  },
  {
    precomputed_pow_inv25519_q_167,32,
    precomputed_pow_inv25519_p_167,32,
  },
  {
    precomputed_pow_inv25519_q_168,32,
    precomputed_pow_inv25519_p_168,32,
  },
  {
    precomputed_pow_inv25519_q_169,32,
    precomputed_pow_inv25519_p_169,32,
  },
  {
    precomputed_pow_inv25519_q_170,32,
    precomputed_pow_inv25519_p_170,32,
  },
  {
    precomputed_pow_inv25519_q_171,32,
    precomputed_pow_inv25519_p_171,32,
  },
  {
    precomputed_pow_inv25519_q_172,32,
    precomputed_pow_inv25519_p_172,32,
  },
  {
    precomputed_pow_inv25519_q_173,32,
    precomputed_pow_inv25519_p_173,32,
  },
  {
    precomputed_pow_inv25519_q_174,32,
    precomputed_pow_inv25519_p_174,32,
  },
  {
    precomputed_pow_inv25519_q_175,32,
    precomputed_pow_inv25519_p_175,32,
  },
  {
    precomputed_pow_inv25519_q_176,32,
    precomputed_pow_inv25519_p_176,32,
  },
  {
    precomputed_pow_inv25519_q_177,32,
    precomputed_pow_inv25519_p_177,32,
  },
  {
    precomputed_pow_inv25519_q_178,32,
    precomputed_pow_inv25519_p_178,32,
  },
  {
    precomputed_pow_inv25519_q_179,32,
    precomputed_pow_inv25519_p_179,32,
  },
  {
    precomputed_pow_inv25519_q_180,32,
    precomputed_pow_inv25519_p_180,32,
  },
  {
    precomputed_pow_inv25519_q_181,32,
    precomputed_pow_inv25519_p_181,32,
  },
  {
    precomputed_pow_inv25519_q_182,32,
    precomputed_pow_inv25519_p_182,32,
  },
  {
    precomputed_pow_inv25519_q_183,32,
    precomputed_pow_inv25519_p_183,32,
  },
  {
    precomputed_pow_inv25519_q_184,32,
    precomputed_pow_inv25519_p_184,32,
  },
  {
    precomputed_pow_inv25519_q_185,32,
    precomputed_pow_inv25519_p_185,32,
  },
  {
    precomputed_pow_inv25519_q_186,32,
    precomputed_pow_inv25519_p_186,32,
  },
  {
    precomputed_pow_inv25519_q_187,32,
    precomputed_pow_inv25519_p_187,32,
  },
  {
    precomputed_pow_inv25519_q_188,32,
    precomputed_pow_inv25519_p_188,32,
  },
  {
    precomputed_pow_inv25519_q_189,32,
    precomputed_pow_inv25519_p_189,32,
  },
  {
    precomputed_pow_inv25519_q_190,32,
    precomputed_pow_inv25519_p_190,32,
  },
  {
    precomputed_pow_inv25519_q_191,32,
    precomputed_pow_inv25519_p_191,32,
  },
  {
    precomputed_pow_inv25519_q_192,32,
    precomputed_pow_inv25519_p_192,32,
  },
  {
    precomputed_pow_inv25519_q_193,32,
    precomputed_pow_inv25519_p_193,32,
  },
  {
    precomputed_pow_inv25519_q_194,32,
    precomputed_pow_inv25519_p_194,32,
  },
  {
    precomputed_pow_inv25519_q_195,32,
    precomputed_pow_inv25519_p_195,32,
  },
  {
    precomputed_pow_inv25519_q_196,32,
    precomputed_pow_inv25519_p_196,32,
  },
  {
    precomputed_pow_inv25519_q_197,32,
    precomputed_pow_inv25519_p_197,32,
  },
  {
    precomputed_pow_inv25519_q_198,32,
    precomputed_pow_inv25519_p_198,32,
  },
  {
    precomputed_pow_inv25519_q_199,32,
    precomputed_pow_inv25519_p_199,32,
  },
  {
    precomputed_pow_inv25519_q_200,32,
    precomputed_pow_inv25519_p_200,32,
  },
  {
    precomputed_pow_inv25519_q_201,32,
    precomputed_pow_inv25519_p_201,32,
  },
  {
    precomputed_pow_inv25519_q_202,32,
    precomputed_pow_inv25519_p_202,32,
  },
  {
    precomputed_pow_inv25519_q_203,32,
    precomputed_pow_inv25519_p_203,32,
  },
  {
    precomputed_pow_inv25519_q_204,32,
    precomputed_pow_inv25519_p_204,32,
  },
  {
    precomputed_pow_inv25519_q_205,32,
    precomputed_pow_inv25519_p_205,32,
  },
  {
    precomputed_pow_inv25519_q_206,32,
    precomputed_pow_inv25519_p_206,32,
  },
  {
    precomputed_pow_inv25519_q_207,32,
    precomputed_pow_inv25519_p_207,32,
  },
  {
    precomputed_pow_inv25519_q_208,32,
    precomputed_pow_inv25519_p_208,32,
  },
  {
    precomputed_pow_inv25519_q_209,32,
    precomputed_pow_inv25519_p_209,32,
  },
  {
    precomputed_pow_inv25519_q_210,32,
    precomputed_pow_inv25519_p_210,32,
  },
  {
    precomputed_pow_inv25519_q_211,32,
    precomputed_pow_inv25519_p_211,32,
  },
  {
    precomputed_pow_inv25519_q_212,32,
    precomputed_pow_inv25519_p_212,32,
  },
  {
    precomputed_pow_inv25519_q_213,32,
    precomputed_pow_inv25519_p_213,32,
  },
  {
    precomputed_pow_inv25519_q_214,32,
    precomputed_pow_inv25519_p_214,32,
  },
  {
    precomputed_pow_inv25519_q_215,32,
    precomputed_pow_inv25519_p_215,32,
  },
  {
    precomputed_pow_inv25519_q_216,32,
    precomputed_pow_inv25519_p_216,32,
  },
  {
    precomputed_pow_inv25519_q_217,32,
    precomputed_pow_inv25519_p_217,32,
  },
  {
    precomputed_pow_inv25519_q_218,32,
    precomputed_pow_inv25519_p_218,32,
  },
  {
    precomputed_pow_inv25519_q_219,32,
    precomputed_pow_inv25519_p_219,32,
  },
  {
    precomputed_pow_inv25519_q_220,32,
    precomputed_pow_inv25519_p_220,32,
  },
  {
    precomputed_pow_inv25519_q_221,32,
    precomputed_pow_inv25519_p_221,32,
  },
  {
    precomputed_pow_inv25519_q_222,32,
    precomputed_pow_inv25519_p_222,32,
  },
  {
    precomputed_pow_inv25519_q_223,32,
    precomputed_pow_inv25519_p_223,32,
  },
  {
    precomputed_pow_inv25519_q_224,32,
    precomputed_pow_inv25519_p_224,32,
  },
  {
    precomputed_pow_inv25519_q_225,32,
    precomputed_pow_inv25519_p_225,32,
  },
  {
    precomputed_pow_inv25519_q_226,32,
    precomputed_pow_inv25519_p_226,32,
  },
  {
    precomputed_pow_inv25519_q_227,32,
    precomputed_pow_inv25519_p_227,32,
  },
  {
    precomputed_pow_inv25519_q_228,32,
    precomputed_pow_inv25519_p_228,32,
  },
  {
    precomputed_pow_inv25519_q_229,32,
    precomputed_pow_inv25519_p_229,32,
  },
  {
    precomputed_pow_inv25519_q_230,32,
    precomputed_pow_inv25519_p_230,32,
  },
  {
    precomputed_pow_inv25519_q_231,32,
    precomputed_pow_inv25519_p_231,32,
  },
  {
    precomputed_pow_inv25519_q_232,32,
    precomputed_pow_inv25519_p_232,32,
  },
  {
    precomputed_pow_inv25519_q_233,32,
    precomputed_pow_inv25519_p_233,32,
  },
  {
    precomputed_pow_inv25519_q_234,32,
    precomputed_pow_inv25519_p_234,32,
  },
  {
    precomputed_pow_inv25519_q_235,32,
    precomputed_pow_inv25519_p_235,32,
  },
  {
    precomputed_pow_inv25519_q_236,32,
    precomputed_pow_inv25519_p_236,32,
  },
  {
    precomputed_pow_inv25519_q_237,32,
    precomputed_pow_inv25519_p_237,32,
  },
  {
    precomputed_pow_inv25519_q_238,32,
    precomputed_pow_inv25519_p_238,32,
  },
  {
    precomputed_pow_inv25519_q_239,32,
    precomputed_pow_inv25519_p_239,32,
  },
  {
    precomputed_pow_inv25519_q_240,32,
    precomputed_pow_inv25519_p_240,32,
  },
  {
    precomputed_pow_inv25519_q_241,32,
    precomputed_pow_inv25519_p_241,32,
  },
  {
    precomputed_pow_inv25519_q_242,32,
    precomputed_pow_inv25519_p_242,32,
  },
  {
    precomputed_pow_inv25519_q_243,32,
    precomputed_pow_inv25519_p_243,32,
  },
  {
    precomputed_pow_inv25519_q_244,32,
    precomputed_pow_inv25519_p_244,32,
  },
  {
    precomputed_pow_inv25519_q_245,32,
    precomputed_pow_inv25519_p_245,32,
  },
  {
    precomputed_pow_inv25519_q_246,32,
    precomputed_pow_inv25519_p_246,32,
  },
  {
    precomputed_pow_inv25519_q_247,32,
    precomputed_pow_inv25519_p_247,32,
  },
  {
    precomputed_pow_inv25519_q_248,32,
    precomputed_pow_inv25519_p_248,32,
  },
  {
    precomputed_pow_inv25519_q_249,32,
    precomputed_pow_inv25519_p_249,32,
  },
  {
    precomputed_pow_inv25519_q_250,32,
    precomputed_pow_inv25519_p_250,32,
  },
  {
    precomputed_pow_inv25519_q_251,32,
    precomputed_pow_inv25519_p_251,32,
  },
  {
    precomputed_pow_inv25519_q_252,32,
    precomputed_pow_inv25519_p_252,32,
  },
  {
    precomputed_pow_inv25519_q_253,32,
    precomputed_pow_inv25519_p_253,32,
  },
  {
    precomputed_pow_inv25519_q_254,32,
    precomputed_pow_inv25519_p_254,32,
  },
  {
    precomputed_pow_inv25519_q_255,32,
    precomputed_pow_inv25519_p_255,32,
  },
  {
    precomputed_pow_inv25519_q_256,32,
    precomputed_pow_inv25519_p_256,32,
  },
  {
    precomputed_pow_inv25519_q_257,32,
    precomputed_pow_inv25519_p_257,32,
  },
  {
    precomputed_pow_inv25519_q_258,32,
    precomputed_pow_inv25519_p_258,32,
  },
  {
    precomputed_pow_inv25519_q_259,32,
    precomputed_pow_inv25519_p_259,32,
  },
  {
    precomputed_pow_inv25519_q_260,32,
    precomputed_pow_inv25519_p_260,32,
  },
  {
    precomputed_pow_inv25519_q_261,32,
    precomputed_pow_inv25519_p_261,32,
  },
  {
    precomputed_pow_inv25519_q_262,32,
    precomputed_pow_inv25519_p_262,32,
  },
  {
    precomputed_pow_inv25519_q_263,32,
    precomputed_pow_inv25519_p_263,32,
  },
  {
    precomputed_pow_inv25519_q_264,32,
    precomputed_pow_inv25519_p_264,32,
  },
  {
    precomputed_pow_inv25519_q_265,32,
    precomputed_pow_inv25519_p_265,32,
  },
  {
    precomputed_pow_inv25519_q_266,32,
    precomputed_pow_inv25519_p_266,32,
  },
  {
    precomputed_pow_inv25519_q_267,32,
    precomputed_pow_inv25519_p_267,32,
  },
  {
    precomputed_pow_inv25519_q_268,32,
    precomputed_pow_inv25519_p_268,32,
  },
  {
    precomputed_pow_inv25519_q_269,32,
    precomputed_pow_inv25519_p_269,32,
  },
  {
    precomputed_pow_inv25519_q_270,32,
    precomputed_pow_inv25519_p_270,32,
  },
  {
    precomputed_pow_inv25519_q_271,32,
    precomputed_pow_inv25519_p_271,32,
  },
  {
    precomputed_pow_inv25519_q_272,32,
    precomputed_pow_inv25519_p_272,32,
  },
  {
    precomputed_pow_inv25519_q_273,32,
    precomputed_pow_inv25519_p_273,32,
  },
  {
    precomputed_pow_inv25519_q_274,32,
    precomputed_pow_inv25519_p_274,32,
  },
  {
    precomputed_pow_inv25519_q_275,32,
    precomputed_pow_inv25519_p_275,32,
  },
  {
    precomputed_pow_inv25519_q_276,32,
    precomputed_pow_inv25519_p_276,32,
  },
  {
    precomputed_pow_inv25519_q_277,32,
    precomputed_pow_inv25519_p_277,32,
  },
  {
    precomputed_pow_inv25519_q_278,32,
    precomputed_pow_inv25519_p_278,32,
  },
  {
    precomputed_pow_inv25519_q_279,32,
    precomputed_pow_inv25519_p_279,32,
  },
  {
    precomputed_pow_inv25519_q_280,32,
    precomputed_pow_inv25519_p_280,32,
  },
  {
    precomputed_pow_inv25519_q_281,32,
    precomputed_pow_inv25519_p_281,32,
  },
  {
    precomputed_pow_inv25519_q_282,32,
    precomputed_pow_inv25519_p_282,32,
  },
  {
    precomputed_pow_inv25519_q_283,32,
    precomputed_pow_inv25519_p_283,32,
  },
  {
    precomputed_pow_inv25519_q_284,32,
    precomputed_pow_inv25519_p_284,32,
  },
  {
    precomputed_pow_inv25519_q_285,32,
    precomputed_pow_inv25519_p_285,32,
  },
  {
    precomputed_pow_inv25519_q_286,32,
    precomputed_pow_inv25519_p_286,32,
  },
  {
    precomputed_pow_inv25519_q_287,32,
    precomputed_pow_inv25519_p_287,32,
  },
  {
    precomputed_pow_inv25519_q_288,32,
    precomputed_pow_inv25519_p_288,32,
  },
  {
    precomputed_pow_inv25519_q_289,32,
    precomputed_pow_inv25519_p_289,32,
  },
  {
    precomputed_pow_inv25519_q_290,32,
    precomputed_pow_inv25519_p_290,32,
  },
  {
    precomputed_pow_inv25519_q_291,32,
    precomputed_pow_inv25519_p_291,32,
  },
  {
    precomputed_pow_inv25519_q_292,32,
    precomputed_pow_inv25519_p_292,32,
  },
  {
    precomputed_pow_inv25519_q_293,32,
    precomputed_pow_inv25519_p_293,32,
  },
  {
    precomputed_pow_inv25519_q_294,32,
    precomputed_pow_inv25519_p_294,32,
  },
  {
    precomputed_pow_inv25519_q_295,32,
    precomputed_pow_inv25519_p_295,32,
  },
} ;

static void test_pow_inv25519_impl(long long impl)
{
  unsigned char *q = test_pow_inv25519_q;
  unsigned char *p = test_pow_inv25519_p;
  unsigned char *q2 = test_pow_inv25519_q2;
  unsigned char *p2 = test_pow_inv25519_p2;
  long long qlen = crypto_pow_BYTES;
  long long plen = crypto_pow_BYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,lib25519_dispatch_pow_inv25519_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_pow = lib25519_dispatch_pow_inv25519(impl);
    printf("pow_inv25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_pow_inv25519_implementation(impl),lib25519_dispatch_pow_inv25519_compiler(impl));
  } else {
    crypto_pow = lib25519_pow_inv25519;
    printf("pow_inv25519 selected implementation %s compiler %s\n",lib25519_pow_inv25519_implementation(),lib25519_pow_inv25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 512 : 64;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(q2,q,qlen);
      input_prepare(p2,p,plen);
      secret(p,plen);
      crypto_pow(q,p);
      public(p,plen);
      public(q,qlen);
      checksum(q,qlen);
      output_compare(q2,q,qlen,"crypto_pow");
      input_compare(p2,p,plen,"crypto_pow");

      double_canary(q2,q,qlen);
      double_canary(p2,p,plen);
      secret(p2,plen);
      crypto_pow(q2,p2);
      public(p2,plen);
      public(q2,qlen);
      if (memcmp(q2,q,qlen) != 0) fail("failure: crypto_pow is nondeterministic\n");

      double_canary(q2,q,qlen);
      double_canary(p2,p,plen);
      secret(p2,plen);
      crypto_pow(p2,p2);
      public(p2,qlen);
      if (memcmp(p2,q,qlen) != 0) fail("failure: crypto_pow does not handle p=q overlap\n");
      memcpy(p2,p,plen);
    }
    checksum_expected(pow_inv25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_pow_inv25519_NUM;++precomp) {
    output_prepare(q2,q,precomputed_pow_inv25519[precomp].qsize);
    input_prepare(p2,p,precomputed_pow_inv25519[precomp].psize);
    memcpy(p,precomputed_pow_inv25519[precomp].p,precomputed_pow_inv25519[precomp].psize);
    memcpy(p2,precomputed_pow_inv25519[precomp].p,precomputed_pow_inv25519[precomp].psize);
    crypto_pow(q,p);
    if (memcmp(q,precomputed_pow_inv25519[precomp].q,precomputed_pow_inv25519[precomp].qsize)) {
      fail("failure: crypto_pow fails precomputed test vectors\n");
      printf("expected q: ");
      for (long long pos = 0;pos < precomputed_pow_inv25519[precomp].qsize;++pos) printf("%02x",precomputed_pow_inv25519[precomp].q[pos]);
      printf("\n");
      printf("received q: ");
      for (long long pos = 0;pos < precomputed_pow_inv25519[precomp].qsize;++pos) printf("%02x",q[pos]);
      printf("\n");
    }
    output_compare(q2,q,precomputed_pow_inv25519[precomp].qsize,"crypto_pow");
    input_compare(p2,p,precomputed_pow_inv25519[precomp].psize,"crypto_pow");
  }
}

void test_pow_inv25519(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"pow")) return;
  if (targetp && strcmp(targetp,"inv25519")) return;
  storage_pow_inv25519_q = callocplus(crypto_pow_BYTES);
  test_pow_inv25519_q = aligned(storage_pow_inv25519_q,crypto_pow_BYTES);
  if (crypto_pow_BYTES > maxalloc) maxalloc = crypto_pow_BYTES;
  storage_pow_inv25519_p = callocplus(crypto_pow_BYTES);
  test_pow_inv25519_p = aligned(storage_pow_inv25519_p,crypto_pow_BYTES);
  if (crypto_pow_BYTES > maxalloc) maxalloc = crypto_pow_BYTES;
  storage_pow_inv25519_q2 = callocplus(maxalloc);
  test_pow_inv25519_q2 = aligned(storage_pow_inv25519_q2,crypto_pow_BYTES);
  storage_pow_inv25519_p2 = callocplus(maxalloc);
  test_pow_inv25519_p2 = aligned(storage_pow_inv25519_p2,crypto_pow_BYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("pow_inv25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_pow_inv25519();++impl)
      forked(test_pow_inv25519_impl,impl);
    ++test_pow_inv25519_q;
    ++test_pow_inv25519_p;
    ++test_pow_inv25519_q2;
    ++test_pow_inv25519_p2;
  }
  free(storage_pow_inv25519_p2);
  free(storage_pow_inv25519_q2);
  free(storage_pow_inv25519_p);
  free(storage_pow_inv25519_q);
}
#undef crypto_pow_BYTES

