/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef EVENTPASSWIDGET_H
#define EVENTPASSWIDGET_H

#include <QWidget>

#include "core/mpvtypes.h"

class EventPassWidget : public QWidget
{
    Q_OBJECT
public:
    explicit EventPassWidget(QWidget *parent = nullptr);

    void setMouseUsed(bool used);

signals:
    void mousePressed();

private slots:
    void playStateChange(Mpv::PlayState state);
    void videIdChange(int vid);

private:
    void initGlobalSig();

    bool m_mouseUsed,
         m_isMouseEnter,
         m_hasVideo;

    Mpv::PlayState m_playState;

    QTimer  *m_checkMouseTimer,
            *m_lMouseClickTimer;

protected:
    void mousePressEvent(QMouseEvent *e) override;
    void mouseMoveEvent(QMouseEvent *e) override;
    void mouseDoubleClickEvent(QMouseEvent *e) override;
    void enterEvent(QEvent *e) override;
    void leaveEvent(QEvent *e) override;
};

#endif // EVENTPASSWIDGET_H
