/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package testutil;

import java.io.ByteArrayInputStream;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathConstants;

import junit.framework.TestCase;
import org.xml.sax.InputSource;

/**
 * @author Arun Gupta
 */
public class XMLTestCase extends TestCase {
    XPath xpath;

    public XMLTestCase(String name) {
        super(name);
        xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContextImpl());
    }

    public void assertXpathExists(String xp, String inXml) throws Exception {
        XPathExpression xpe = xpath.compile(xp);
        InputSource inputSource = new InputSource(new ByteArrayInputStream(inXml.getBytes()));
        Object obj = xpe.evaluate(inputSource, XPathConstants.NODE);
        if (obj == null)
            throw new AssertionError();
    }

    public void assertXpathEvaluatesTo(String xp, String inXml, String expected) throws Exception {
        XPathExpression xpe = xpath.compile(xp);
        InputSource inputSource = new InputSource(new ByteArrayInputStream(inXml.getBytes()));
        String value = (String)xpe.evaluate(inputSource, XPathConstants.STRING);
        if (!expected.equals(value))
            throw new AssertionError();
    }
}
