---
title: Lateef - Announcement
fontversion: 2.000
---

We are pleased to release version 2.000 of the Lateef font family. The font package is available for download from the [Download page](https://software.sil.org/lateef/download/).

Seven weights for this typeface family are included:

- Lateef ExtraLight
- Lateef Light
- Lateef Regular
- Lateef Medium
- Lateef SemiBold
- Lateef Bold
- Lateef ExtraBold

The full range of weights is accessed in different ways depending on the application. See the [FAQ](faq.md) for details.

## Changes

### 2022-06-24 (SIL WSTech team) Lateef version 2.000

#### New

- Added 6 weights -- ExtraLight, Light, Medium, SemiBold, Bold, and ExtraBold
- Added OpenType support back in to the font
- Added "Disable digit kerning (see FAQ)" TypeTuner-only feature to support the bug in Word
- New features:
     - tnum - access tabular versions of Arabic digits
     - pnum - access proportional versions of Latin digits
     - cv51 - Kyrgyz OE (loop/bar)
     - cv54 - Yeh hamza (Standard/Right hamza)
     - cv85 - Decimal separator (Small reh/Slash)
- Added UI name strings for OpenType features
- Added Kyrgyz language support in Graphite and OpenType
- Added Rohingya language support in Graphite and OpenType
- Added proportional Arabic digits (now the default)
- Added kerning for proportional Arabic digits
- Added Arabic-style (rounded) versions of chevron quotes
- Added:
     - U+0600 ARABIC NUMBER SIGN
     - U+0601 ARABIC SIGN SANAH
     - U+0602 ARABIC FOOTNOTE MARKER
     - U+0603 ARABIC SIGN SAFHA
     - U+0604 ARABIC SIGN SAMVAT
     - U+0605 ARABIC NUMBER MARK ABOVE
     - U+0609 ARABIC-INDIC PER MILLE SIGN
     - U+060A ARABIC-INDIC PER TEN THOUSAND SIGN
     - U+060B AFGHANI SIGN
     - U+060D ARABIC DATE SEPARATOR
     - U+060E ARABIC POETIC VERSE SIGN
     - U+060F ARABIC SIGN MISRA
     - U+0610 ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM
     - U+0611 ARABIC SIGN ALAYHE ASSALLAM
     - U+0612 ARABIC SIGN RAHMATULLAH ALAYHE
     - U+0613 ARABIC SIGN RADI ALLAHOU ANHU
     - U+0615 ARABIC SMALL HIGH TAH
     - U+0616 ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH
     - U+0617 ARABIC SMALL HIGH ZAIN
     - U+0618 ARABIC SMALL FATHA
     - U+0619 ARABIC SMALL DAMMA
     - U+061A ARABIC SMALL KASRA
     - U+0620 ARABIC LETTER KASHMIRI YEH
     - U+063B ARABIC LETTER KEHEH WITH TWO DOTS ABOVE
     - U+063C ARABIC LETTER KEHEH WITH THREE DOTS BELOW
     - U+063E ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE
     - U+063F ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
     - U+065F ARABIC WAVY HAMZA BELOW
     - U+0773 ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE
     - U+0774 ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE
     - U+0775 ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE
     - U+0776 ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE
     - U+0777 ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW
     - U+0778 ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE
     - U+0779 ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE
     - U+077A ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE
     - U+077B ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE
     - U+077C ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW
     - U+077D ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE
     - U+077E ARABIC LETTER SEEN WITH INVERTED V
     - U+077F ARABIC LETTER KAF WITH TWO DOTS ABOVE
     - U+08A0 ARABIC LETTER BEH WITH SMALL V BELOW
     - U+08A1 ARABIC LETTER BEH WITH HAMZA ABOVE
     - U+08A2 ARABIC LETTER JEEM WITH TWO DOTS ABOVE
     - U+08A3 ARABIC LETTER TAH WITH TWO DOTS ABOVE
     - U+08A4 ARABIC LETTER FEH WITH DOT BELOW AND THREE DOTS ABOVE
     - U+08A5 ARABIC LETTER QAF WITH DOT BELOW
     - U+08A6 ARABIC LETTER LAM WITH DOUBLE BAR
     - U+08A7 ARABIC LETTER MEEM WITH THREE DOTS ABOVE
     - U+08A8 ARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVE
     - U+08A9 ARABIC LETTER YEH WITH TWO DOTS BELOW AND DOT ABOVE
     - U+08AA ARABIC LETTER REH WITH LOOP
     - U+08AB ARABIC LETTER WAW WITH DOT WITHIN
     - U+08AC ARABIC LETTER ROHINGYA YEH
     - U+08AD ARABIC LETTER LOW ALEF
     - U+08AE ARABIC LETTER DAL WITH THREE DOTS BELOW
     - U+08AF ARABIC LETTER SAD WITH THREE DOTS BELOW
     - U+08B0 ARABIC LETTER GAF WITH INVERTED STROKE
     - U+08B1 ARABIC LETTER STRAIGHT WAW
     - U+08B2 ARABIC LETTER ZAIN WITH INVERTED V ABOVE
     - U+08B3 ARABIC LETTER AIN WITH THREE DOTS BELOW
     - U+08B4 ARABIC LETTER KAF WITH DOT BELOW
     - U+08B6 ARABIC LETTER BEH WITH SMALL MEEM ABOVE
     - U+08B7 ARABIC LETTER PEH WITH SMALL MEEM ABOVE
     - U+08B8 ARABIC LETTER TEH WITH SMALL TEH ABOVE
     - U+08B9 ARABIC LETTER REH WITH SMALL NOON ABOVE
     - U+08BA ARABIC LETTER YEH WITH TWO DOTS BELOW AND SMALL NOON ABOVE
     - U+08BB ARABIC LETTER AFRICAN FEH
     - U+08BC ARABIC LETTER AFRICAN QAF
     - U+08BD ARABIC LETTER AFRICAN NOON
     - U+08BE ARABIC LETTER PEH WITH SMALL V
     - U+08BF ARABIC LETTER TEH WITH SMALL V
     - U+08C0 ARABIC LETTER TTEH WITH SMALL V
     - U+08C1 ARABIC LETTER TCHEH WITH SMALL V
     - U+08C2 ARABIC LETTER KEHEH WITH SMALL V
     - U+08C3 ARABIC LETTER GHAIN WITH THREE DOTS ABOVE
     - U+08C4 ARABIC LETTER AFRICAN QAF WITH THREE DOTS ABOVE
     - U+08C5 ARABIC LETTER JEEM WITH THREE DOTS ABOVE
     - U+08C6 ARABIC LETTER JEEM WITH THREE DOTS BELOW
     - U+08C7 ARABIC LETTER LAM WITH SMALL ARABIC LETTER TAH ABOVE
     - U+08E3 ARABIC TURNED DAMMA BELOW
     - U+08E4 ARABIC CURLY FATHA
     - U+08E5 ARABIC CURLY DAMMA
     - U+08E6 ARABIC CURLY KASRA
     - U+08E7 ARABIC CURLY FATHATAN
     - U+08E8 ARABIC CURLY DAMMATAN
     - U+08E9 ARABIC CURLY KASRATAN
     - U+08EA ARABIC TONE ONE DOT ABOVE
     - U+08EB ARABIC TONE TWO DOTS ABOVE
     - U+08EC ARABIC TONE LOOP ABOVE
     - U+08ED ARABIC TONE ONE DOT BELOW
     - U+08EE ARABIC TONE TWO DOTS BELOW
     - U+08EF ARABIC TONE LOOP BELOW
     - U+08F0 ARABIC OPEN FATHATAN
     - U+08F1 ARABIC OPEN DAMMATAN
     - U+08F2 ARABIC OPEN KASRATAN
     - U+08F3 ARABIC SMALL HIGH WAW
     - U+08F4 ARABIC FATHA WITH RING
     - U+08F5 ARABIC FATHA WITH DOT ABOVE
     - U+08F6 ARABIC KASRA WITH DOT BELOW
     - U+08F7 ARABIC LEFT ARROWHEAD ABOVE
     - U+08F8 ARABIC RIGHT ARROWHEAD ABOVE
     - U+08F9 ARABIC LEFT ARROWHEAD BELOW
     - U+08FA ARABIC RIGHT ARROWHEAD BELOW
     - U+08FB ARABIC DOUBLE RIGHT ARROWHEAD ABOVE
     - U+08FC ARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOT
     - U+08FD ARABIC RIGHT ARROWHEAD ABOVE WITH DOT
     - U+08FE ARABIC DAMMA WITH DOT
     - U+08FF ARABIC MARK SIDEWAYS NOON GHUNNA
     - U+201B SINGLE HIGH-REVERSED-9 QUOTATION MARK
     - U+201F DOUBLE HIGH-REVERSED-9 QUOTATION MARK
     - U+204F REVERSED SEMICOLON
     - U+2E41 REVERSED COMMA
- Implemented new rules for [Rendering the Allah ligature](allah.md)
- Implemented support for [UNICODE ARABIC MARK RENDERING (UTR #53)](https://unicode.org/reports/tr53)
- Changed design of all Latin glyphs to use Crimson Pro
- Updated Latin script repertoire to support [Recommended characters for Non-Roman fonts](https://scriptsource.org/entry/gg5wm9hhd3)

#### Improved

- Redesign of some Arabic digits
- Redesign of hook on heh-goal
- Redesigned head of feh, qaf, waw
- Redesigned high hamza characters (U+0674..U+0678)
- Redesigned nuktas and variants to be more calligraphic and less geometric
- Slight adjustments to nukta spacing
- Harmonized design of many characters so that all characters in that family (eg seen, dal, feh, keheh, etc) would be consistent
- Harmonized design of all terminals
- Harmonized vertical stems
- Harmonized design of small v and inverted small v characters
    - U+063D ARABIC LETTER FARSI YEH WITH INVERTED V
    - U+065A ARABIC VOWEL SIGN SMALL V ABOVE
    - U+065B ARABIC VOWEL SIGN INVERTED SMALL V ABOVE
    - U+0692 ARABIC LETTER REH WITH SMALL V
    - U+06B5 ARABIC LETTER LAM WITH SMALL V
    - U+06C9 ARABIC LETTER KIRGHIZ YU
    - U+06CE ARABIC LETTER YEH WITH SMALL V
    - U+06EE ARABIC LETTER DAL WITH INVERTED V
    - U+06EF ARABIC LETTER REH WITH INVERTED V
    - U+06FF ARABIC LETTER HEH WITH INVERTED V
    - U+0756 ARABIC LETTER BEH WITH SMALL V
    - U+0769 ARABIC LETTER NOON WITH SMALL V
- Harmonized design of punctuation used in Arabic script (question mark, exclamation mark, quotation marks, commas, period)
- Made space and nobreak space have the same width
- Adjusted width of various whitespace characters to conform to best practice
- Revised side-bearings for many glyphs
- Revised width of kashida
- Changed scaling for some quranic marks (combining) and adjusted weights
- Improved mark positioning
- Redesign 
    - U+0616 ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH
    - U+0677 ARABIC LETTER U WITH HAMZA ABOVE
    - U+06AC ARABIC LETTER KAF WITH DOT ABOVE
    - U+06AD ARABIC LETTER NG
    - U+06C5 ARABIC LETTER KIRGHIZ OE
    - U+06C7 ARABIC LETTER U
    - U+FDF2 ARABIC LIGATURE ALLAH ISOLATED FORM
- Adjusted position of isolate lam characters
- Small changes to some glyphs including maddah, imala e, ain, waw 
- Increase vertical separation between maddah and fatha in context of alef-maddah and initial lam+fatha
- Adjusted default linespacing to match that of Lateef 1.001 (which is tighter than LateefGR)
- Adjusted kerning to be similar to that of LateefGR
- Changed Latin digits to tabular; use new "pnum" feature to access proportional digits
- Fixed bug using kashida-justification in Word (where the lam-alef ligature would break)
- Fixed End-of-Ayah rendering in OpenType

#### Removed

- Removed Graphite from the font
- Removed support for Sindhi-style comma when Sindhi language is selected
- Removed support for Sindhi-style heh when Sindhi language is selected
- Removed support for Urdu-style heh when Urdu language is selected
- Removed features: 
    - Arabic U
    - Show invisible characters
    - Jeh hack
    - Dotless head of Khah hack

#### Known issues

- Characters added since LateefGR are not yet kerned so spacing after reh- and waw-like characters may be incorrect. Please let us know of specific combinations that should be improved.
- In Word: kerning of Arabic proportional digits is incorrect. This is a bug in Word.
- In InDesign: some behaviors, such as the _lam-alef_ ligature, raised _kasra_ with _shadda_, and subtending marks, will not function correctly unless **Ligatures** is turned on in the **Characters** panel.




