# Моделі Параметрів Заголовків

Якщо у Вас є група пов’язаних параметрів заголовків, Ви можете створити **Pydantic модель** для їх оголошення.

Це дозволить Вам повторно **використовувати модель** в **різних місцях**, а також оголосити валідації та метадані для всіх параметрів одночасно. 😎

/// note | Нотатки

Ця можливість підтримується починаючи з версії FastAPI `0.115.0`. 🤓

///

## Параметри Заголовків з Використанням Pydantic Model

Оголосіть потрібні **параметри заголовків** у **Pydantic моделі**, а потім оголосіть параметр як `Header`:

{* ../../docs_src/header_param_models/tutorial001_an_py310.py hl[9:14,18] *}

FastAPI буде витягувати дані для кожного поля з заголовків у запиті та передавати їх у створену Вами Pydantic модель.

**FastAPI** буде **витягувати** дані для **кожного поля** з **заголовків** у запиті та передавати їх у створену Вами Pydantic модель.

## Перевірка в Документації

Ви можете побачити необхідні заголовки в інтерфейсі документації за адресою `/docs`:

<div class="screenshot">
<img src="/img/tutorial/header-param-models/image01.png">
</div>

## Заборона Додаткових Заголовків

У деяких особливих випадках (ймовірно, не дуже поширених) Ви можете захотіти **обмежити** заголовки, які хочете отримати.

Ви можете використати конфігурацію моделі Pydantic, щоб `заборонити` будь-які `додаткові` поля:

{* ../../docs_src/header_param_models/tutorial002_an_py310.py hl[10] *}

Якщо клієнт спробує надіслати **додаткові заголовки**, він отримає **помилку** у відповіді.

Наприклад, якщо клієнт спробує надіслати заголовок `tool` зі значенням `plumbus`, він отримає  **помилку** з повідомленням про те, що параметр заголовка `tool` не дозволений:

```json
{
    "detail": [
        {
            "type": "extra_forbidden",
            "loc": ["header", "tool"],
            "msg": "Extra inputs are not permitted",
            "input": "plumbus",
        }
    ]
}
```

## Підсумок

Ви можете використовувати **Pydantic моделі** для оголошення **заголовків** у **FastAPI**. 😎
