---
id: Navigation
section: components
---

import { Fragment, useState } from 'react';
import CogIcon from '@patternfly/react-icons/dist/esm/icons/cog-icon';
import HelpIcon from '@patternfly/react-icons/dist/esm/icons/help-icon';
import QuestionCircleIcon from '@patternfly/react-icons/dist/esm/icons/question-circle-icon';
import EllipsisVIcon from '@patternfly/react-icons/dist/esm/icons/ellipsis-v-icon';
import BellIcon from '@patternfly/react-icons/dist/esm/icons/bell-icon';
import BarsIcon from '@patternfly/react-icons/dist/esm/icons/bars-icon';
import imgAvatar from '@patternfly/react-core/src/components/assets/avatarImg.svg';
import pfLogo from '@patternfly/react-core/src/demos/assets/PF-HorizontalLogo-Color.svg';
import { DashboardBreadcrumb } from '@patternfly/react-core/dist/js/demos/DashboardWrapper';
import { DashboardHeader } from '@patternfly/react-core/dist/js/demos/DashboardHeader';

## Demos

### Default nav

```js file='./examples/Nav/NavDefault.tsx' isFullscreen
```

### Grouped nav

```js file='./examples/Nav/NavGrouped.tsx' isFullscreen
```

### Expandable nav

```js file='./examples/Nav/NavExpandable.tsx' isFullscreen
```

### Horizontal nav

```js file='./examples/Nav/NavHorizontal.tsx' isFullscreen
```

### Horizontal subnav

```js file='./examples/Nav/NavWithSubnav.tsx' isFullscreen
```

### Horizontal nav with horizontal subnav

```js file='./examples/Nav/NavHorizontalWithSubnav.tsx' isFullscreen
```

### Manual nav

```js file='./examples/Nav/NavManual.tsx' isFullscreen
```

### Flyout nav

```js file='./examples/Nav/NavFlyout.tsx' isFullscreen
```

### Drilldown nav

```js isFullscreen file="./examples/Nav/NavDrilldown.tsx"
```
