import { Fragment, useState } from 'react';
import { Toolbar, ToolbarItem, ToolbarContent, SearchInput, Checkbox } from '@patternfly/react-core';

export const ToolbarSticky = () => {
  const [isSticky, setIsSticky] = useState(true);
  const [showEvenOnly, setShowEvenOnly] = useState(true);
  const [searchValue, setSearchValue] = useState('');
  const array = Array.from(Array(30), (_, x) => x); // create array of numbers from 1-30 for demo purposes
  const numbers = showEvenOnly ? array.filter((number) => number % 2 === 0) : array;

  return (
    <Fragment>
      <div style={{ overflowY: 'scroll', height: '200px' }}>
        <Toolbar id="toolbar-sticky" inset={{ default: 'insetNone' }} isSticky={isSticky}>
          <ToolbarContent>
            <ToolbarItem>
              <SearchInput
                aria-label="Sticky example search input"
                value={searchValue}
                onChange={(_event, value) => setSearchValue(value)}
                onClear={() => setSearchValue('')}
              />
            </ToolbarItem>
            <ToolbarItem alignSelf="center">
              <Checkbox
                label="Show only even number items"
                isChecked={showEvenOnly}
                onChange={(_event, checked) => setShowEvenOnly(checked)}
                id="showOnlyEvenCheckbox"
              />
            </ToolbarItem>
          </ToolbarContent>
        </Toolbar>
        <ul>
          {numbers.map((number) => (
            <li key={number}>{`item ${number}`}</li>
          ))}
        </ul>
      </div>
      <Checkbox
        label="Is toolbar sticky"
        isChecked={isSticky}
        onChange={(_event, checked) => setIsSticky(checked)}
        id="isStickyCheckbox"
      />
    </Fragment>
  );
};
