"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileUploadField = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const file_upload_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/FileUpload/file-upload"));
const react_styles_1 = require("@patternfly/react-styles");
const InputGroup_1 = require("../InputGroup");
const TextInput_1 = require("../TextInput");
const Button_1 = require("../Button");
const TextArea_1 = require("../TextArea");
const Spinner_1 = require("../Spinner");
const fileUtils_1 = require("../../helpers/fileUtils");
const FileUploadField = (_a) => {
    var { id, name, type, value = '', filename = '', onBrowseButtonClick = () => { }, onClearButtonClick = () => { }, onTextAreaClick, onTextChange, onTextAreaBlur, textAreaPlaceholder = '', className = '', isDisabled = false, isReadOnly = false, isLoading = false, spinnerAriaValueText, isRequired = false, isDragActive = false, validated = 'default', 'aria-label': ariaLabel = 'File upload', filenamePlaceholder = 'Drag a file here or browse to upload', filenameAriaLabel = filename ? 'Read only filename' : filenamePlaceholder, browseButtonText = 'Browse...', browseButtonAriaDescribedby, clearButtonText = 'Clear', isBrowseButtonDisabled = false, isClearButtonDisabled = !filename && !value, containerRef = null, allowEditingUploadedText = false, hideDefaultPreview = false, children = null } = _a, props = tslib_1.__rest(_a, ["id", "name", "type", "value", "filename", "onBrowseButtonClick", "onClearButtonClick", "onTextAreaClick", "onTextChange", "onTextAreaBlur", "textAreaPlaceholder", "className", "isDisabled", "isReadOnly", "isLoading", "spinnerAriaValueText", "isRequired", "isDragActive", "validated", 'aria-label', "filenamePlaceholder", "filenameAriaLabel", "browseButtonText", "browseButtonAriaDescribedby", "clearButtonText", "isBrowseButtonDisabled", "isClearButtonDisabled", "containerRef", "allowEditingUploadedText", "hideDefaultPreview", "children"]);
    const onTextAreaChange = (event, newValue) => {
        onTextChange === null || onTextChange === void 0 ? void 0 : onTextChange(event, newValue);
    };
    return ((0, jsx_runtime_1.jsxs)("div", Object.assign({ className: (0, react_styles_1.css)(file_upload_1.default.fileUpload, isDragActive && file_upload_1.default.modifiers.dragHover, isLoading && file_upload_1.default.modifiers.loading, className), ref: containerRef }, props, { children: [(0, jsx_runtime_1.jsx)("div", { className: file_upload_1.default.fileUploadFileSelect, children: (0, jsx_runtime_1.jsxs)(InputGroup_1.InputGroup, { children: [(0, jsx_runtime_1.jsx)(InputGroup_1.InputGroupItem, { isFill: true, children: (0, jsx_runtime_1.jsx)(TextInput_1.TextInput, { readOnlyVariant: "default" // Always read-only regardless of isReadOnly prop (which is just for the TextArea)
                                , isDisabled: isDisabled, id: `${id}-filename`, name: name || `${id}-filename`, "aria-label": filenameAriaLabel, placeholder: filenamePlaceholder, value: filename }) }), (0, jsx_runtime_1.jsx)(InputGroup_1.InputGroupItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, { variant: Button_1.ButtonVariant.control, onClick: onBrowseButtonClick, isDisabled: isDisabled || isBrowseButtonDisabled, "aria-describedby": browseButtonAriaDescribedby, children: browseButtonText }) }), (0, jsx_runtime_1.jsx)(InputGroup_1.InputGroupItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, { variant: Button_1.ButtonVariant.control, isDisabled: isDisabled || isClearButtonDisabled, onClick: onClearButtonClick, children: clearButtonText }) })] }) }), (0, jsx_runtime_1.jsxs)("div", { className: file_upload_1.default.fileUploadFileDetails, children: [!hideDefaultPreview && type === fileUtils_1.fileReaderType.text && ((0, jsx_runtime_1.jsx)(TextArea_1.TextArea, { readOnly: isReadOnly || (!!filename && !allowEditingUploadedText), disabled: isDisabled, isRequired: isRequired, resizeOrientation: TextArea_1.TextAreResizeOrientation.vertical, validated: validated, id: id, "aria-label": ariaLabel, value: value, onChange: onTextAreaChange, onClick: onTextAreaClick, onBlur: onTextAreaBlur, placeholder: textAreaPlaceholder })), isLoading && ((0, jsx_runtime_1.jsx)("div", { className: file_upload_1.default.fileUploadFileDetailsSpinner, children: (0, jsx_runtime_1.jsx)(Spinner_1.Spinner, { size: Spinner_1.spinnerSize.lg, "aria-valuetext": spinnerAriaValueText }) }))] }), children] })));
};
exports.FileUploadField = FileUploadField;
exports.FileUploadField.displayName = 'FileUploadField';
//# sourceMappingURL=FileUploadField.js.map