# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AccessPolicy(msrest.serialization.Model):
    """An Access policy.

    :ivar start: the date-time the policy is active.
    :vartype start: str
    :ivar expiry: the date-time the policy expires.
    :vartype expiry: str
    :ivar permission: the permissions for the acl policy.
    :vartype permission: str
    """

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'str'},
        'expiry': {'key': 'Expiry', 'type': 'str'},
        'permission': {'key': 'Permission', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword start: the date-time the policy is active.
        :paramtype start: str
        :keyword expiry: the date-time the policy expires.
        :paramtype expiry: str
        :keyword permission: the permissions for the acl policy.
        :paramtype permission: str
        """
        super(AccessPolicy, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.expiry = kwargs.get('expiry', None)
        self.permission = kwargs.get('permission', None)


class CorsRule(msrest.serialization.Model):
    """CORS is an HTTP feature that enables a web application running under one domain to access resources in another domain. Web browsers implement a security restriction known as same-origin policy that prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain (the origin domain) to call APIs in another domain.

    All required parameters must be populated in order to send to Azure.

    :ivar allowed_origins: Required. The origin domains that are permitted to make a request
     against the storage service via CORS. The origin domain is the domain from which the request
     originates. Note that the origin must be an exact case-sensitive match with the origin that the
     user age sends to the service. You can also use the wildcard character '*' to allow all origin
     domains to make requests via CORS.
    :vartype allowed_origins: str
    :ivar allowed_methods: Required. The methods (HTTP request verbs) that the origin domain may
     use for a CORS request. (comma separated).
    :vartype allowed_methods: str
    :ivar allowed_headers: Required. the request headers that the origin domain may specify on the
     CORS request.
    :vartype allowed_headers: str
    :ivar exposed_headers: Required. The response headers that may be sent in the response to the
     CORS request and exposed by the browser to the request issuer.
    :vartype exposed_headers: str
    :ivar max_age_in_seconds: Required. The maximum amount time that a browser should cache the
     preflight OPTIONS request.
    :vartype max_age_in_seconds: int
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'allowed_headers': {'required': True},
        'exposed_headers': {'required': True},
        'max_age_in_seconds': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'AllowedOrigins', 'type': 'str'},
        'allowed_methods': {'key': 'AllowedMethods', 'type': 'str'},
        'allowed_headers': {'key': 'AllowedHeaders', 'type': 'str'},
        'exposed_headers': {'key': 'ExposedHeaders', 'type': 'str'},
        'max_age_in_seconds': {'key': 'MaxAgeInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword allowed_origins: Required. The origin domains that are permitted to make a request
         against the storage service via CORS. The origin domain is the domain from which the request
         originates. Note that the origin must be an exact case-sensitive match with the origin that the
         user age sends to the service. You can also use the wildcard character '*' to allow all origin
         domains to make requests via CORS.
        :paramtype allowed_origins: str
        :keyword allowed_methods: Required. The methods (HTTP request verbs) that the origin domain may
         use for a CORS request. (comma separated).
        :paramtype allowed_methods: str
        :keyword allowed_headers: Required. the request headers that the origin domain may specify on
         the CORS request.
        :paramtype allowed_headers: str
        :keyword exposed_headers: Required. The response headers that may be sent in the response to
         the CORS request and exposed by the browser to the request issuer.
        :paramtype exposed_headers: str
        :keyword max_age_in_seconds: Required. The maximum amount time that a browser should cache the
         preflight OPTIONS request.
        :paramtype max_age_in_seconds: int
        """
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = kwargs['allowed_origins']
        self.allowed_methods = kwargs['allowed_methods']
        self.allowed_headers = kwargs['allowed_headers']
        self.exposed_headers = kwargs['exposed_headers']
        self.max_age_in_seconds = kwargs['max_age_in_seconds']


class DequeuedMessageItem(msrest.serialization.Model):
    """The object returned in the QueueMessageList array when calling Get Messages on a Queue.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: Required. The Id of the Message.
    :vartype message_id: str
    :ivar insertion_time: Required. The time the Message was inserted into the Queue.
    :vartype insertion_time: ~datetime.datetime
    :ivar expiration_time: Required. The time that the Message will expire and be automatically
     deleted.
    :vartype expiration_time: ~datetime.datetime
    :ivar pop_receipt: Required. This value is required to delete the Message. If deletion fails
     using this popreceipt then the message has been dequeued by another client.
    :vartype pop_receipt: str
    :ivar time_next_visible: Required. The time that the message will again become visible in the
     Queue.
    :vartype time_next_visible: ~datetime.datetime
    :ivar dequeue_count: Required. The number of times the message has been dequeued.
    :vartype dequeue_count: long
    :ivar message_text: Required. The content of the Message.
    :vartype message_text: str
    """

    _validation = {
        'message_id': {'required': True},
        'insertion_time': {'required': True},
        'expiration_time': {'required': True},
        'pop_receipt': {'required': True},
        'time_next_visible': {'required': True},
        'dequeue_count': {'required': True},
        'message_text': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'MessageId', 'type': 'str'},
        'insertion_time': {'key': 'InsertionTime', 'type': 'rfc-1123'},
        'expiration_time': {'key': 'ExpirationTime', 'type': 'rfc-1123'},
        'pop_receipt': {'key': 'PopReceipt', 'type': 'str'},
        'time_next_visible': {'key': 'TimeNextVisible', 'type': 'rfc-1123'},
        'dequeue_count': {'key': 'DequeueCount', 'type': 'long'},
        'message_text': {'key': 'MessageText', 'type': 'str'},
    }
    _xml_map = {
        'name': 'QueueMessage'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword message_id: Required. The Id of the Message.
        :paramtype message_id: str
        :keyword insertion_time: Required. The time the Message was inserted into the Queue.
        :paramtype insertion_time: ~datetime.datetime
        :keyword expiration_time: Required. The time that the Message will expire and be automatically
         deleted.
        :paramtype expiration_time: ~datetime.datetime
        :keyword pop_receipt: Required. This value is required to delete the Message. If deletion fails
         using this popreceipt then the message has been dequeued by another client.
        :paramtype pop_receipt: str
        :keyword time_next_visible: Required. The time that the message will again become visible in
         the Queue.
        :paramtype time_next_visible: ~datetime.datetime
        :keyword dequeue_count: Required. The number of times the message has been dequeued.
        :paramtype dequeue_count: long
        :keyword message_text: Required. The content of the Message.
        :paramtype message_text: str
        """
        super(DequeuedMessageItem, self).__init__(**kwargs)
        self.message_id = kwargs['message_id']
        self.insertion_time = kwargs['insertion_time']
        self.expiration_time = kwargs['expiration_time']
        self.pop_receipt = kwargs['pop_receipt']
        self.time_next_visible = kwargs['time_next_visible']
        self.dequeue_count = kwargs['dequeue_count']
        self.message_text = kwargs['message_text']


class EnqueuedMessage(msrest.serialization.Model):
    """The object returned in the QueueMessageList array when calling Put Message on a Queue.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: Required. The Id of the Message.
    :vartype message_id: str
    :ivar insertion_time: Required. The time the Message was inserted into the Queue.
    :vartype insertion_time: ~datetime.datetime
    :ivar expiration_time: Required. The time that the Message will expire and be automatically
     deleted.
    :vartype expiration_time: ~datetime.datetime
    :ivar pop_receipt: Required. This value is required to delete the Message. If deletion fails
     using this popreceipt then the message has been dequeued by another client.
    :vartype pop_receipt: str
    :ivar time_next_visible: Required. The time that the message will again become visible in the
     Queue.
    :vartype time_next_visible: ~datetime.datetime
    """

    _validation = {
        'message_id': {'required': True},
        'insertion_time': {'required': True},
        'expiration_time': {'required': True},
        'pop_receipt': {'required': True},
        'time_next_visible': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'MessageId', 'type': 'str'},
        'insertion_time': {'key': 'InsertionTime', 'type': 'rfc-1123'},
        'expiration_time': {'key': 'ExpirationTime', 'type': 'rfc-1123'},
        'pop_receipt': {'key': 'PopReceipt', 'type': 'str'},
        'time_next_visible': {'key': 'TimeNextVisible', 'type': 'rfc-1123'},
    }
    _xml_map = {
        'name': 'QueueMessage'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword message_id: Required. The Id of the Message.
        :paramtype message_id: str
        :keyword insertion_time: Required. The time the Message was inserted into the Queue.
        :paramtype insertion_time: ~datetime.datetime
        :keyword expiration_time: Required. The time that the Message will expire and be automatically
         deleted.
        :paramtype expiration_time: ~datetime.datetime
        :keyword pop_receipt: Required. This value is required to delete the Message. If deletion fails
         using this popreceipt then the message has been dequeued by another client.
        :paramtype pop_receipt: str
        :keyword time_next_visible: Required. The time that the message will again become visible in
         the Queue.
        :paramtype time_next_visible: ~datetime.datetime
        """
        super(EnqueuedMessage, self).__init__(**kwargs)
        self.message_id = kwargs['message_id']
        self.insertion_time = kwargs['insertion_time']
        self.expiration_time = kwargs['expiration_time']
        self.pop_receipt = kwargs['pop_receipt']
        self.time_next_visible = kwargs['time_next_visible']


class GeoReplication(msrest.serialization.Model):
    """GeoReplication.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. The status of the secondary location. Possible values include: "live",
     "bootstrap", "unavailable".
    :vartype status: str or ~azure.storage.queue.models.GeoReplicationStatusType
    :ivar last_sync_time: Required. A GMT date/time value, to the second. All primary writes
     preceding this value are guaranteed to be available for read operations at the secondary.
     Primary writes after this point in time may or may not be available for reads.
    :vartype last_sync_time: ~datetime.datetime
    """

    _validation = {
        'status': {'required': True},
        'last_sync_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'str'},
        'last_sync_time': {'key': 'LastSyncTime', 'type': 'rfc-1123'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword status: Required. The status of the secondary location. Possible values include:
         "live", "bootstrap", "unavailable".
        :paramtype status: str or ~azure.storage.queue.models.GeoReplicationStatusType
        :keyword last_sync_time: Required. A GMT date/time value, to the second. All primary writes
         preceding this value are guaranteed to be available for read operations at the secondary.
         Primary writes after this point in time may or may not be available for reads.
        :paramtype last_sync_time: ~datetime.datetime
        """
        super(GeoReplication, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.last_sync_time = kwargs['last_sync_time']


class ListQueuesSegmentResponse(msrest.serialization.Model):
    """The object returned when calling List Queues on a Queue Service.

    All required parameters must be populated in order to send to Azure.

    :ivar service_endpoint: Required.
    :vartype service_endpoint: str
    :ivar prefix: Required.
    :vartype prefix: str
    :ivar marker:
    :vartype marker: str
    :ivar max_results: Required.
    :vartype max_results: int
    :ivar queue_items:
    :vartype queue_items: list[~azure.storage.queue.models.QueueItem]
    :ivar next_marker: Required.
    :vartype next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'prefix': {'required': True},
        'max_results': {'required': True},
        'next_marker': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str'},
        'marker': {'key': 'Marker', 'type': 'str'},
        'max_results': {'key': 'MaxResults', 'type': 'int'},
        'queue_items': {'key': 'QueueItems', 'type': '[QueueItem]', 'xml': {'name': 'Queues', 'wrapped': True, 'itemsName': 'Queue'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str'},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword service_endpoint: Required.
        :paramtype service_endpoint: str
        :keyword prefix: Required.
        :paramtype prefix: str
        :keyword marker:
        :paramtype marker: str
        :keyword max_results: Required.
        :paramtype max_results: int
        :keyword queue_items:
        :paramtype queue_items: list[~azure.storage.queue.models.QueueItem]
        :keyword next_marker: Required.
        :paramtype next_marker: str
        """
        super(ListQueuesSegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = kwargs['service_endpoint']
        self.prefix = kwargs['prefix']
        self.marker = kwargs.get('marker', None)
        self.max_results = kwargs['max_results']
        self.queue_items = kwargs.get('queue_items', None)
        self.next_marker = kwargs['next_marker']


class Logging(msrest.serialization.Model):
    """Azure Analytics Logging settings.

    All required parameters must be populated in order to send to Azure.

    :ivar version: Required. The version of Storage Analytics to configure.
    :vartype version: str
    :ivar delete: Required. Indicates whether all delete requests should be logged.
    :vartype delete: bool
    :ivar read: Required. Indicates whether all read requests should be logged.
    :vartype read: bool
    :ivar write: Required. Indicates whether all write requests should be logged.
    :vartype write: bool
    :ivar retention_policy: Required. the retention policy.
    :vartype retention_policy: ~azure.storage.queue.models.RetentionPolicy
    """

    _validation = {
        'version': {'required': True},
        'delete': {'required': True},
        'read': {'required': True},
        'write': {'required': True},
        'retention_policy': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str'},
        'delete': {'key': 'Delete', 'type': 'bool'},
        'read': {'key': 'Read', 'type': 'bool'},
        'write': {'key': 'Write', 'type': 'bool'},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword version: Required. The version of Storage Analytics to configure.
        :paramtype version: str
        :keyword delete: Required. Indicates whether all delete requests should be logged.
        :paramtype delete: bool
        :keyword read: Required. Indicates whether all read requests should be logged.
        :paramtype read: bool
        :keyword write: Required. Indicates whether all write requests should be logged.
        :paramtype write: bool
        :keyword retention_policy: Required. the retention policy.
        :paramtype retention_policy: ~azure.storage.queue.models.RetentionPolicy
        """
        super(Logging, self).__init__(**kwargs)
        self.version = kwargs['version']
        self.delete = kwargs['delete']
        self.read = kwargs['read']
        self.write = kwargs['write']
        self.retention_policy = kwargs['retention_policy']


class Metrics(msrest.serialization.Model):
    """a summary of request statistics grouped by API in hour or minute aggregates for queues.

    All required parameters must be populated in order to send to Azure.

    :ivar version: The version of Storage Analytics to configure.
    :vartype version: str
    :ivar enabled: Required. Indicates whether metrics are enabled for the Queue service.
    :vartype enabled: bool
    :ivar include_apis: Indicates whether metrics should generate summary statistics for called API
     operations.
    :vartype include_apis: bool
    :ivar retention_policy: the retention policy.
    :vartype retention_policy: ~azure.storage.queue.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str'},
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'include_apis': {'key': 'IncludeAPIs', 'type': 'bool'},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword version: The version of Storage Analytics to configure.
        :paramtype version: str
        :keyword enabled: Required. Indicates whether metrics are enabled for the Queue service.
        :paramtype enabled: bool
        :keyword include_apis: Indicates whether metrics should generate summary statistics for called
         API operations.
        :paramtype include_apis: bool
        :keyword retention_policy: the retention policy.
        :paramtype retention_policy: ~azure.storage.queue.models.RetentionPolicy
        """
        super(Metrics, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.enabled = kwargs['enabled']
        self.include_apis = kwargs.get('include_apis', None)
        self.retention_policy = kwargs.get('retention_policy', None)


class PeekedMessageItem(msrest.serialization.Model):
    """The object returned in the QueueMessageList array when calling Peek Messages on a Queue.

    All required parameters must be populated in order to send to Azure.

    :ivar message_id: Required. The Id of the Message.
    :vartype message_id: str
    :ivar insertion_time: Required. The time the Message was inserted into the Queue.
    :vartype insertion_time: ~datetime.datetime
    :ivar expiration_time: Required. The time that the Message will expire and be automatically
     deleted.
    :vartype expiration_time: ~datetime.datetime
    :ivar dequeue_count: Required. The number of times the message has been dequeued.
    :vartype dequeue_count: long
    :ivar message_text: Required. The content of the Message.
    :vartype message_text: str
    """

    _validation = {
        'message_id': {'required': True},
        'insertion_time': {'required': True},
        'expiration_time': {'required': True},
        'dequeue_count': {'required': True},
        'message_text': {'required': True},
    }

    _attribute_map = {
        'message_id': {'key': 'MessageId', 'type': 'str'},
        'insertion_time': {'key': 'InsertionTime', 'type': 'rfc-1123'},
        'expiration_time': {'key': 'ExpirationTime', 'type': 'rfc-1123'},
        'dequeue_count': {'key': 'DequeueCount', 'type': 'long'},
        'message_text': {'key': 'MessageText', 'type': 'str'},
    }
    _xml_map = {
        'name': 'QueueMessage'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword message_id: Required. The Id of the Message.
        :paramtype message_id: str
        :keyword insertion_time: Required. The time the Message was inserted into the Queue.
        :paramtype insertion_time: ~datetime.datetime
        :keyword expiration_time: Required. The time that the Message will expire and be automatically
         deleted.
        :paramtype expiration_time: ~datetime.datetime
        :keyword dequeue_count: Required. The number of times the message has been dequeued.
        :paramtype dequeue_count: long
        :keyword message_text: Required. The content of the Message.
        :paramtype message_text: str
        """
        super(PeekedMessageItem, self).__init__(**kwargs)
        self.message_id = kwargs['message_id']
        self.insertion_time = kwargs['insertion_time']
        self.expiration_time = kwargs['expiration_time']
        self.dequeue_count = kwargs['dequeue_count']
        self.message_text = kwargs['message_text']


class QueueItem(msrest.serialization.Model):
    """An Azure Storage Queue.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the Queue.
    :vartype name: str
    :ivar metadata: Dictionary of :code:`<string>`.
    :vartype metadata: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }
    _xml_map = {
        'name': 'Queue'
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the Queue.
        :paramtype name: str
        :keyword metadata: Dictionary of :code:`<string>`.
        :paramtype metadata: dict[str, str]
        """
        super(QueueItem, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.metadata = kwargs.get('metadata', None)


class QueueMessage(msrest.serialization.Model):
    """A Message object which can be stored in a Queue.

    All required parameters must be populated in order to send to Azure.

    :ivar message_text: Required. The content of the message.
    :vartype message_text: str
    """

    _validation = {
        'message_text': {'required': True},
    }

    _attribute_map = {
        'message_text': {'key': 'MessageText', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword message_text: Required. The content of the message.
        :paramtype message_text: str
        """
        super(QueueMessage, self).__init__(**kwargs)
        self.message_text = kwargs['message_text']


class RetentionPolicy(msrest.serialization.Model):
    """the retention policy.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Required. Indicates whether a retention policy is enabled for the storage
     service.
    :vartype enabled: bool
    :ivar days: Indicates the number of days that metrics or logging or soft-deleted data should be
     retained. All data older than this value will be deleted.
    :vartype days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool'},
        'days': {'key': 'Days', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword enabled: Required. Indicates whether a retention policy is enabled for the storage
         service.
        :paramtype enabled: bool
        :keyword days: Indicates the number of days that metrics or logging or soft-deleted data should
         be retained. All data older than this value will be deleted.
        :paramtype days: int
        """
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.days = kwargs.get('days', None)


class SignedIdentifier(msrest.serialization.Model):
    """signed identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. a unique id.
    :vartype id: str
    :ivar access_policy: The access policy.
    :vartype access_policy: ~azure.storage.queue.models.AccessPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'access_policy': {'key': 'AccessPolicy', 'type': 'AccessPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword id: Required. a unique id.
        :paramtype id: str
        :keyword access_policy: The access policy.
        :paramtype access_policy: ~azure.storage.queue.models.AccessPolicy
        """
        super(SignedIdentifier, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.access_policy = kwargs.get('access_policy', None)


class StorageError(msrest.serialization.Model):
    """StorageError.

    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword message:
        :paramtype message: str
        """
        super(StorageError, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)


class StorageServiceProperties(msrest.serialization.Model):
    """Storage Service Properties.

    :ivar logging: Azure Analytics Logging settings.
    :vartype logging: ~azure.storage.queue.models.Logging
    :ivar hour_metrics: A summary of request statistics grouped by API in hourly aggregates for
     queues.
    :vartype hour_metrics: ~azure.storage.queue.models.Metrics
    :ivar minute_metrics: a summary of request statistics grouped by API in minute aggregates for
     queues.
    :vartype minute_metrics: ~azure.storage.queue.models.Metrics
    :ivar cors: The set of CORS rules.
    :vartype cors: list[~azure.storage.queue.models.CorsRule]
    """

    _attribute_map = {
        'logging': {'key': 'Logging', 'type': 'Logging'},
        'hour_metrics': {'key': 'HourMetrics', 'type': 'Metrics'},
        'minute_metrics': {'key': 'MinuteMetrics', 'type': 'Metrics'},
        'cors': {'key': 'Cors', 'type': '[CorsRule]', 'xml': {'wrapped': True}},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword logging: Azure Analytics Logging settings.
        :paramtype logging: ~azure.storage.queue.models.Logging
        :keyword hour_metrics: A summary of request statistics grouped by API in hourly aggregates for
         queues.
        :paramtype hour_metrics: ~azure.storage.queue.models.Metrics
        :keyword minute_metrics: a summary of request statistics grouped by API in minute aggregates
         for queues.
        :paramtype minute_metrics: ~azure.storage.queue.models.Metrics
        :keyword cors: The set of CORS rules.
        :paramtype cors: list[~azure.storage.queue.models.CorsRule]
        """
        super(StorageServiceProperties, self).__init__(**kwargs)
        self.logging = kwargs.get('logging', None)
        self.hour_metrics = kwargs.get('hour_metrics', None)
        self.minute_metrics = kwargs.get('minute_metrics', None)
        self.cors = kwargs.get('cors', None)


class StorageServiceStats(msrest.serialization.Model):
    """Stats for the storage service.

    :ivar geo_replication: Geo-Replication information for the Secondary Storage Service.
    :vartype geo_replication: ~azure.storage.queue.models.GeoReplication
    """

    _attribute_map = {
        'geo_replication': {'key': 'GeoReplication', 'type': 'GeoReplication'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword geo_replication: Geo-Replication information for the Secondary Storage Service.
        :paramtype geo_replication: ~azure.storage.queue.models.GeoReplication
        """
        super(StorageServiceStats, self).__init__(**kwargs)
        self.geo_replication = kwargs.get('geo_replication', None)
