; Utility functions for theorems
;

(defthm env-subset-reflexive
 (implies
  (and
   (symbol-alistp l)
   )
  (env-subset l l)))
  
(defthm env-subset-acons
 (implies
  (and
   (env-subset a b)
   )
  (env-subset a (acons k v b))))
 
(defthm env-subset-set-var
 (implies
  (and
   (env-subset a b)
   )
  (env-subset a (acons k v b))))
 

(defthm env-subset-transitive
 (implies
  (and
   (env-subset a b)
   (env-subset b c)
   )
  (env-subset a c))
 :hints
   (("Goal'" :use (:instance subsetp-equal-transitive
			     (a (domain a))
			     (b (domain b))
			     (c (domain c))))))

(defthm same-is-subset
  (implies
   (and
    (symbol-alistp e)
    (symbol-alistp e2)
    (equal e e2)
    )
   (env-subset e e2)))

(defthm set-var-is-subset
   (implies
    (and
     (symbol-alistp env)
     (symbol-alistp e2)
     (env-subset env e2)
     (symbolp k)
     )
    (env-subset env (set-var k v e2))))

(defthm equal-is-subset
   (implies
    (and
     (symbol-alistp env)
;     (symbol-alistp e2)
;     (equal env e2)
;     (subset env e2)
     )
    (env-subset env env)))

(defthm equal-set-var-is-subset
   (implies
    (and
     (symbol-alistp env)
     (symbolp k)
     )
    (env-subset env (set-var k v env))))

(defthm mk-action-returns-action-p-thm
  (implies
  (and
   (message-p msg)
   (symbolp user)
   (not (null user))
   )
  (action-p (mk-action 'send user msg arg2))))

(defthm mk-email-returns-email-p-thm
  (implies
   (and
    (and 
     (symbolp to)
     (not (null to)))
    (and 
     (symbolp host)
     (not (null host)))
    )
   (email-p (mk-email to host))))

(defthm message-sender-returns-email-p
  (implies
   (and
    (message-p msg)
    )
   (email-p
    (message-sender msg))))

(defthm mk-message-returns-message-p-thm
  (implies
   (and
    (email-p       to)
    (email-p     from)
    (equal (list to) tos)
    (symbol-alistp headers)
    (listp         body)
    )
   (message-p 
    (mk-message from
		tos
		headers
		body))))

(defthm add-mail-action-is-action-listp
 (implies
  (and
   (message-p msg)
   (action-listp rest))
  (action-listp
   (add-mail-action msg rest))))



(defthm add-user-mail-action-arg1
  (equal (action-msg (car (add-user-mail-action type msg rest)))
	 msg))

(defthm add-user-mail-action-returns-action-listp
 (implies
  (and
   (member-equal type '(deliver mail send))
   (message-p msg)
   (action-listp rest))
  (action-listp (add-user-mail-action type msg rest))))

(defthm add-sender-mail-action-returns-action-listp
 (implies
  (and
   (member-equal type '(deliver mail send))
   (message-p msg)
   (action-listp rest))
  (action-listp (add-sender-mail-action type msg rest))))

(defthm add-host-mail-action-returns-action-listp
 (implies
  (and
   (member-equal type '(deliver mail send))
   (message-p msg)
   (action-listp rest))
  (action-listp (add-host-mail-action type msg rest))))

