#!/bin/sh
set -e

if [  -z "$2" ]; then
    echo "This script must be run via uscan or by manually specifying the tarball" >&2
    exit 1
fi
echo "Repackaging..."

VERSION=$2
OLDDIR=$PWD
BASEDIR=$PWD/../

cd $BASEDIR
mkdir 9menu-${VERSION}/
mv 9menu-${VERSION}.shar.gz 9menu-${VERSION}/
cd 9menu-${VERSION}/
echo "Extracting shar file..."
gzip -d 9menu-${VERSION}.shar.gz
sh 9menu-${VERSION}.shar
rm -rf 9menu-${VERSION}.shar
cd ..
echo "Generating tar.gz tarball"
tar cf 9menu_$VERSION.tar 9menu-${VERSION}/
xz 9menu_$VERSION.tar
echo "Generating symlink"
ln -sf 9menu_$VERSION.tar.xz 9menu_$VERSION.orig.tar.xz
