///
/// Wavelets coefficients, extracted from http://wavelets.pybytes.com
///

#ifndef FILTERS_H
#define FILTERS_H

#include <cublas.h>


// Mind that most GPUs are not primarily designed for double precision
// (less "double precision units" in the hardware)
// so the computations will be slower if this is enabled.
// To build a library with double precision computations,
// type "make libpdwtd.so" or manually compile with the flag "-DDOUBLEPRECISION"
#ifndef DOUBLEPRECISION
//~ typedef float DTYPE;
#define DTYPE float
#define cublas_asum cublasSasum
#define cublas_nrm2 cublasSnrm2
#define cublas_scal cublasSscal
#define cublas_axpy cublasSaxpy
#else
//~ typedef double DTYPE;
#define DTYPE double
#define cublas_asum cublasDasum
#define cublas_nrm2 cublasDnrm2
#define cublas_scal cublasDscal
#define cublas_axpy cublasDaxpy
#endif



// Should always be defined
#define COMPILING_LIBRARY

#ifdef COMPILING_LIBRARY
#define LIBEXPORT extern "C"
#else
#define LIBEXPORT
#endif

// Uncomment to use separate compilation
// mind that the "-dc" compilation flag must be used instead of "-c"
// #define SEPARATE_COMPILATION


LIBEXPORT DTYPE DB2_L[4];

LIBEXPORT DTYPE DB2_H[4];

LIBEXPORT DTYPE DB2_I_L[4];

LIBEXPORT DTYPE DB2_I_H[4];

LIBEXPORT DTYPE DB3_L[6];

LIBEXPORT DTYPE DB3_H[6];

LIBEXPORT DTYPE DB3_I_L[6];

LIBEXPORT DTYPE DB3_I_H[6];

LIBEXPORT DTYPE DB4_L[8];

LIBEXPORT DTYPE DB4_H[8];

LIBEXPORT DTYPE DB4_I_L[8];

LIBEXPORT DTYPE DB4_I_H[8];

LIBEXPORT DTYPE DB5_L[10];

LIBEXPORT DTYPE DB5_H[10];

LIBEXPORT DTYPE DB5_I_L[10];

LIBEXPORT DTYPE DB5_I_H[10];

LIBEXPORT DTYPE DB6_L[12];

LIBEXPORT DTYPE DB6_H[12];

LIBEXPORT DTYPE DB6_I_L[12];

LIBEXPORT DTYPE DB6_I_H[12];

LIBEXPORT DTYPE DB7_L[14];

LIBEXPORT DTYPE DB7_I_L[14];

LIBEXPORT DTYPE DB7_H[14];

LIBEXPORT DTYPE DB7_I_H[14];

LIBEXPORT DTYPE DB8_L[16];

LIBEXPORT DTYPE DB8_I_L[16];

LIBEXPORT DTYPE DB8_H[16];

LIBEXPORT DTYPE DB8_I_H[16];

LIBEXPORT DTYPE DB9_L[18];

LIBEXPORT DTYPE DB9_I_L[18];

LIBEXPORT DTYPE DB9_H[18];

LIBEXPORT DTYPE DB9_I_H[18];

LIBEXPORT DTYPE DB10_L[20];

LIBEXPORT DTYPE DB10_I_L[20];

LIBEXPORT DTYPE DB10_H[20];

LIBEXPORT DTYPE DB10_I_H[20];

LIBEXPORT DTYPE DB11_L[22];

LIBEXPORT DTYPE DB11_I_L[22];

LIBEXPORT DTYPE DB11_H[22];

LIBEXPORT DTYPE DB11_I_H[22];

LIBEXPORT DTYPE DB12_L[24];

LIBEXPORT DTYPE DB12_I_L[24];

LIBEXPORT DTYPE DB12_H[24];

LIBEXPORT DTYPE DB12_I_H[24];

LIBEXPORT DTYPE DB13_L[26];

LIBEXPORT DTYPE DB13_I_L[26];

LIBEXPORT DTYPE DB13_H[26];

LIBEXPORT DTYPE DB13_I_H[26];

LIBEXPORT DTYPE DB14_L[28];

LIBEXPORT DTYPE DB14_I_L[28];

LIBEXPORT DTYPE DB14_H[28];

LIBEXPORT DTYPE DB14_I_H[28];

LIBEXPORT DTYPE DB15_L[30];

LIBEXPORT DTYPE DB15_I_L[30];

LIBEXPORT DTYPE DB15_H[30];

LIBEXPORT DTYPE DB15_I_H[30];

LIBEXPORT DTYPE DB16_L[32];

LIBEXPORT DTYPE DB16_I_L[32];

LIBEXPORT DTYPE DB16_H[32];

LIBEXPORT DTYPE DB16_I_H[32];

LIBEXPORT DTYPE DB17_L[34];

LIBEXPORT DTYPE DB17_I_L[34];

LIBEXPORT DTYPE DB17_H[34];

LIBEXPORT DTYPE DB17_I_H[34];

LIBEXPORT DTYPE DB18_L[36];

LIBEXPORT DTYPE DB18_I_L[36];

LIBEXPORT DTYPE DB18_H[36];

LIBEXPORT DTYPE DB18_I_H[36];

LIBEXPORT DTYPE DB19_L[38];

LIBEXPORT DTYPE DB19_I_L[38];

LIBEXPORT DTYPE DB19_H[38];

LIBEXPORT DTYPE DB19_I_H[38];

LIBEXPORT DTYPE DB20_L[40];

LIBEXPORT DTYPE DB20_I_L[40];

LIBEXPORT DTYPE DB20_H[40];

LIBEXPORT DTYPE DB20_I_H[40];

LIBEXPORT DTYPE SYM2_L[4];

LIBEXPORT DTYPE SYM2_I_L[4];

LIBEXPORT DTYPE SYM2_H[4];

LIBEXPORT DTYPE SYM2_I_H[4];

LIBEXPORT DTYPE SYM3_L[6];

LIBEXPORT DTYPE SYM3_I_L[6];

LIBEXPORT DTYPE SYM3_H[6];

LIBEXPORT DTYPE SYM3_I_H[6];

LIBEXPORT DTYPE SYM4_L[8];

LIBEXPORT DTYPE SYM4_I_L[8];

LIBEXPORT DTYPE SYM4_H[8];

LIBEXPORT DTYPE SYM4_I_H[8];

LIBEXPORT DTYPE SYM5_L[10];

LIBEXPORT DTYPE SYM5_I_L[10];

LIBEXPORT DTYPE SYM5_H[10];

LIBEXPORT DTYPE SYM5_I_H[10];

LIBEXPORT DTYPE SYM6_L[12];

LIBEXPORT DTYPE SYM6_I_L[12];

LIBEXPORT DTYPE SYM6_H[12];

LIBEXPORT DTYPE SYM6_I_H[12];

LIBEXPORT DTYPE SYM7_L[14];

LIBEXPORT DTYPE SYM7_I_L[14];

LIBEXPORT DTYPE SYM7_H[14];

LIBEXPORT DTYPE SYM7_I_H[14];

LIBEXPORT DTYPE SYM8_L[16];

LIBEXPORT DTYPE SYM8_I_L[16];

LIBEXPORT DTYPE SYM8_H[16];

LIBEXPORT DTYPE SYM8_I_H[16];

LIBEXPORT DTYPE SYM9_L[18];

LIBEXPORT DTYPE SYM9_I_L[18];

LIBEXPORT DTYPE SYM9_H[18];

LIBEXPORT DTYPE SYM9_I_H[18];

LIBEXPORT DTYPE SYM10_L[20];

LIBEXPORT DTYPE SYM10_I_L[20];

LIBEXPORT DTYPE SYM10_H[20];

LIBEXPORT DTYPE SYM10_I_H[20];

LIBEXPORT DTYPE SYM11_L[22];

LIBEXPORT DTYPE SYM11_I_L[22];

LIBEXPORT DTYPE SYM11_H[22];

LIBEXPORT DTYPE SYM11_I_H[22];

LIBEXPORT DTYPE SYM12_L[24];

LIBEXPORT DTYPE SYM12_I_L[24];

LIBEXPORT DTYPE SYM12_H[24];

LIBEXPORT DTYPE SYM12_I_H[24];

LIBEXPORT DTYPE SYM13_L[26];

LIBEXPORT DTYPE SYM13_I_L[26];

LIBEXPORT DTYPE SYM13_H[26];

LIBEXPORT DTYPE SYM13_I_H[26];

LIBEXPORT DTYPE SYM14_L[28];

LIBEXPORT DTYPE SYM14_I_L[28];

LIBEXPORT DTYPE SYM14_H[28];

LIBEXPORT DTYPE SYM14_I_H[28];

LIBEXPORT DTYPE SYM15_L[30];

LIBEXPORT DTYPE SYM15_I_L[30];

LIBEXPORT DTYPE SYM15_H[30];

LIBEXPORT DTYPE SYM15_I_H[30];

LIBEXPORT DTYPE SYM16_L[32];

LIBEXPORT DTYPE SYM16_I_L[32];

LIBEXPORT DTYPE SYM16_H[32];

LIBEXPORT DTYPE SYM16_I_H[32];

LIBEXPORT DTYPE SYM17_L[34];

LIBEXPORT DTYPE SYM17_I_L[34];

LIBEXPORT DTYPE SYM17_H[34];

LIBEXPORT DTYPE SYM17_I_H[34];

LIBEXPORT DTYPE SYM18_L[36];

LIBEXPORT DTYPE SYM18_I_L[36];

LIBEXPORT DTYPE SYM18_H[36];

LIBEXPORT DTYPE SYM18_I_H[36];

LIBEXPORT DTYPE SYM19_L[38];

LIBEXPORT DTYPE SYM19_I_L[38];

LIBEXPORT DTYPE SYM19_H[38];

LIBEXPORT DTYPE SYM19_I_H[38];

LIBEXPORT DTYPE SYM20_L[40];

LIBEXPORT DTYPE SYM20_I_L[40];

LIBEXPORT DTYPE SYM20_H[40];

LIBEXPORT DTYPE SYM20_I_H[40];

LIBEXPORT DTYPE COIF1_L[6];

LIBEXPORT DTYPE COIF1_I_L[6];

LIBEXPORT DTYPE COIF1_H[6];

LIBEXPORT DTYPE COIF1_I_H[6];

LIBEXPORT DTYPE COIF2_L[12];

LIBEXPORT DTYPE COIF2_I_L[12];

LIBEXPORT DTYPE COIF2_H[12];

LIBEXPORT DTYPE COIF2_I_H[12];

LIBEXPORT DTYPE COIF3_L[18];

LIBEXPORT DTYPE COIF3_I_L[18];

LIBEXPORT DTYPE COIF3_H[18];

LIBEXPORT DTYPE COIF3_I_H[18];

LIBEXPORT DTYPE COIF4_L[24];

LIBEXPORT DTYPE COIF4_I_L[24];

LIBEXPORT DTYPE COIF4_H[24];

LIBEXPORT DTYPE COIF4_I_H[24];

LIBEXPORT DTYPE COIF5_L[30];

LIBEXPORT DTYPE COIF5_I_L[30];

LIBEXPORT DTYPE COIF5_H[30];

LIBEXPORT DTYPE COIF5_I_H[30];

LIBEXPORT DTYPE BIOR1_3_L[6];

LIBEXPORT DTYPE BIOR1_3_I_L[6];

LIBEXPORT DTYPE BIOR1_3_H[6];

LIBEXPORT DTYPE BIOR1_3_I_H[6];

LIBEXPORT DTYPE BIOR1_5_L[10];

LIBEXPORT DTYPE BIOR1_5_I_L[10];

LIBEXPORT DTYPE BIOR1_5_H[10];

LIBEXPORT DTYPE BIOR1_5_I_H[10];

LIBEXPORT DTYPE BIOR2_2_L[6];

LIBEXPORT DTYPE BIOR2_2_I_L[6];

LIBEXPORT DTYPE BIOR2_2_H[6];

LIBEXPORT DTYPE BIOR2_2_I_H[6];

LIBEXPORT DTYPE BIOR2_4_L[10];

LIBEXPORT DTYPE BIOR2_4_I_L[10];

LIBEXPORT DTYPE BIOR2_4_H[10];

LIBEXPORT DTYPE BIOR2_4_I_H[10];

LIBEXPORT DTYPE BIOR2_6_L[14];

LIBEXPORT DTYPE BIOR2_6_I_L[14];

LIBEXPORT DTYPE BIOR2_6_H[14];

LIBEXPORT DTYPE BIOR2_6_I_H[14];

LIBEXPORT DTYPE BIOR2_8_L[18];

LIBEXPORT DTYPE BIOR2_8_I_L[18];

LIBEXPORT DTYPE BIOR2_8_H[18];

LIBEXPORT DTYPE BIOR2_8_I_H[18];

LIBEXPORT DTYPE BIOR3_1_L[4];

LIBEXPORT DTYPE BIOR3_1_I_L[4];

LIBEXPORT DTYPE BIOR3_1_H[4];

LIBEXPORT DTYPE BIOR3_1_I_H[4];

LIBEXPORT DTYPE BIOR3_3_L[8];

LIBEXPORT DTYPE BIOR3_3_I_L[8];

LIBEXPORT DTYPE BIOR3_3_H[8];

LIBEXPORT DTYPE BIOR3_3_I_H[8];

LIBEXPORT DTYPE BIOR3_5_L[12];

LIBEXPORT DTYPE BIOR3_5_I_L[12];

LIBEXPORT DTYPE BIOR3_5_H[12];

LIBEXPORT DTYPE BIOR3_5_I_H[12];

LIBEXPORT DTYPE BIOR3_7_L[16];

LIBEXPORT DTYPE BIOR3_7_I_L[16];

LIBEXPORT DTYPE BIOR3_7_H[16];

LIBEXPORT DTYPE BIOR3_7_I_H[16];

LIBEXPORT DTYPE BIOR3_9_L[20];

LIBEXPORT DTYPE BIOR3_9_I_L[20];

LIBEXPORT DTYPE BIOR3_9_H[20];

LIBEXPORT DTYPE BIOR3_9_I_H[20];

LIBEXPORT DTYPE BIOR4_4_L[10];

LIBEXPORT DTYPE BIOR4_4_I_L[10];

LIBEXPORT DTYPE BIOR4_4_H[10];

LIBEXPORT DTYPE BIOR4_4_I_H[10];

LIBEXPORT DTYPE BIOR5_5_L[12];

LIBEXPORT DTYPE BIOR5_5_H[12];

LIBEXPORT DTYPE BIOR5_5_I_L[12];

LIBEXPORT DTYPE BIOR5_5_I_H[12];

LIBEXPORT DTYPE BIOR6_8_L[18];

LIBEXPORT DTYPE BIOR6_8_H[18];

LIBEXPORT DTYPE BIOR6_8_I_L[18];

LIBEXPORT DTYPE BIOR6_8_I_H[18];

LIBEXPORT DTYPE RBIOR1_3_L[6];

LIBEXPORT DTYPE RBIOR1_3_I_L[6];

LIBEXPORT DTYPE RBIOR1_3_H[6];

LIBEXPORT DTYPE RBIOR1_3_I_H[6];

LIBEXPORT DTYPE RBIOR1_5_L[10];

LIBEXPORT DTYPE RBIOR1_5_I_L[10];

LIBEXPORT DTYPE RBIOR1_5_H[10];

LIBEXPORT DTYPE RBIOR1_5_I_H[10];

LIBEXPORT DTYPE RBIOR2_2_L[6];

LIBEXPORT DTYPE RBIOR2_2_I_L[6];

LIBEXPORT DTYPE RBIOR2_2_H[6];

LIBEXPORT DTYPE RBIOR2_2_I_H[6];

LIBEXPORT DTYPE RBIOR2_4_L[10];

LIBEXPORT DTYPE RBIOR2_4_I_L[10];

LIBEXPORT DTYPE RBIOR2_4_H[10];

LIBEXPORT DTYPE RBIOR2_4_I_H[10];

LIBEXPORT DTYPE RBIOR2_6_L[14];

LIBEXPORT DTYPE RBIOR2_6_I_L[14];

LIBEXPORT DTYPE RBIOR2_6_H[14];

LIBEXPORT DTYPE RBIOR2_6_I_H[14];

LIBEXPORT DTYPE RBIOR2_8_L[18];

LIBEXPORT DTYPE RBIOR2_8_I_L[18];

LIBEXPORT DTYPE RBIOR2_8_H[18];

LIBEXPORT DTYPE RBIOR2_8_I_H[18];

LIBEXPORT DTYPE RBIOR3_1_L[4];

LIBEXPORT DTYPE RBIOR3_1_I_L[4];

LIBEXPORT DTYPE RBIOR3_1_H[4];

LIBEXPORT DTYPE RBIOR3_1_I_H[4];

LIBEXPORT DTYPE RBIOR3_3_L[8];

LIBEXPORT DTYPE RBIOR3_3_I_L[8];

LIBEXPORT DTYPE RBIOR3_3_H[8];

LIBEXPORT DTYPE RBIOR3_3_I_H[8];

LIBEXPORT DTYPE RBIOR3_5_L[12];

LIBEXPORT DTYPE RBIOR3_5_I_L[12];

LIBEXPORT DTYPE RBIOR3_5_H[12];

LIBEXPORT DTYPE RBIOR3_5_I_H[12];

LIBEXPORT DTYPE RBIOR3_7_L[16];

LIBEXPORT DTYPE RBIOR3_7_I_L[16];

LIBEXPORT DTYPE RBIOR3_7_H[16];

LIBEXPORT DTYPE RBIOR3_7_I_H[16];

LIBEXPORT DTYPE RBIOR3_9_L[20];

LIBEXPORT DTYPE RBIOR3_9_I_L[20];

LIBEXPORT DTYPE RBIOR3_9_H[20];

LIBEXPORT DTYPE RBIOR3_9_I_H[20];

LIBEXPORT DTYPE RBIOR4_4_L[10];

LIBEXPORT DTYPE RBIOR4_4_I_L[10];

LIBEXPORT DTYPE RBIOR4_4_H[10];

LIBEXPORT DTYPE RBIOR4_4_I_H[10];

LIBEXPORT DTYPE RBIOR5_5_L[12];

LIBEXPORT DTYPE RBIOR5_5_I_L[12];

LIBEXPORT DTYPE RBIOR5_5_H[12];

LIBEXPORT DTYPE RBIOR5_5_I_H[12];

LIBEXPORT DTYPE RBIOR6_8_L[18];

LIBEXPORT DTYPE RBIOR6_8_I_L[18];

LIBEXPORT DTYPE RBIOR6_8_H[18];

LIBEXPORT DTYPE RBIOR6_8_I_H[18];

LIBEXPORT DTYPE HAAR_L[4];

LIBEXPORT DTYPE HAAR_H[4];

LIBEXPORT DTYPE HAAR_I_L[4];

LIBEXPORT DTYPE HAAR_I_H[4];







///
/// Structure containing the filters pointers
///


struct wfilter {
    char wname[16];
    int hlen;
    DTYPE* f_l; // Forward lowpass
    DTYPE* f_h;  // Forward highpass
    DTYPE* i_l; // Inverse lowpass
    DTYPE* i_h; // Inverse highpass
};


LIBEXPORT wfilter all_filters[72];





#endif




